
#ifndef __NETLINK_H__
#define __NETLINK_H__

#include <asm/types.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>

struct netlink {
	int fd;
	struct sockaddr_nl local;
	__u32 seq;
};



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <net/if_arp.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <sys/uio.h>

#include <asm/types.h>
#include <linux/netlink.h>

#include "netlink.h"

void netlink_close(struct netlink *nl);
int netlink_open(struct netlink *nl, int protocol, int groups);
int netlink_send(struct netlink *nl, struct nlmsghdr *n, pid_t peer, int groups);
int netlink_recv(struct netlink *nl, struct nlmsghdr *n, pid_t *peer);
int netlink_wait(struct netlink *nl, struct nlmsghdr *n, pid_t peer);

int netlink_attr_attach(struct nlmsghdr *n, int max, int type, const void *data, int len);
int netlink_attr_parse(struct nlattr *table[], int max, struct nlattr *src, int len);



#endif /* __NETLINK_H__ */

