#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# Python module lliurexguard.py
# Autogenerated from lliurexguard.glade
# Generated on Thu May  7 10:48:38 2009

# Warning: Do not delete or modify comments related to context
# They are required to keep user's code

import os, gtk
import commands
from lliurexGuardGladeApp import lliurexGuardGladeApp
import gettext
import locale
locale.setlocale(locale.LC_ALL, "")
locale.textdomain("lliurex-guard")
gettext.textdomain("lliurex-guard")
_=locale.gettext 

glade_dir = "/usr/share/lliurex-guard/glade/"

class WindowGuard(lliurexGuardGladeApp):
	def __init__(self, glade_path="lliurexguard.glade", root="window_guard", domain=None):
		glade_path = os.path.join(glade_dir, glade_path)
		lliurexGuardGladeApp.__init__(self, glade_path, root, domain)
		
		self.combobox_set = self.glade.get_widget("combobox_set")
		self.button_edit = self.glade.get_widget("button_edit_set")
		self.button_delete = self.glade.get_widget("button_delete")
		self.button_from_guard = self.glade.get_widget("button_from_guard")
		self.button_to_guard = self.glade.get_widget("button_to_guard")
		self.button_new_from_old = self.glade.get_widget("button_new_from_old")
		self.button_apply = self.glade.get_widget("button_apply")
		self.button_admin_groups = self.glade.get_widget("button_admin_groups")
		self.button_blacklist_enable = self.glade.get_widget("button_blacklist_enable")
		self.button_blacklist_disable = self.glade.get_widget("button_blacklist_disable")
		self.button_blacklist_download = self.glade.get_widget("button_blacklist_download")
		self.blacklist_status_off = self.glade.get_widget("blacklist_status_off")
		self.blacklist_status_on = self.glade.get_widget("blacklist_status_on")
		self.label_extra_blacklist = self.glade.get_widget("label_admin_blacklist_extra")
		self.label_extra_blacklist.set_use_markup(True)
		
		self.button_edit_exceptions.set_sensitive(False)
		self.button_edit_swearwords.set_sensitive(False)
		self.button_edit_banners.set_sensitive(False)
		self.button_delete.set_sensitive(False)
		
			
		# Treeview Loader
		self.treeview_non_guard = self.glade.get_widget("treeview_non_guard")   
		self.treeview_guard = self.glade.get_widget("treeview_guard")   
		self.gtk_list_guard = self.glade.get_widget("list_guard")   
			
		# Image Status Loader
		self.image_status_on = self.glade.get_widget("image_status_on")
		self.image_status_off = self.glade.get_widget("image_status_off")
		self.image_color = self.glade.get_widget("image_color")
		self.image_black = self.glade.get_widget("image_black")
		# Status of llxcfg-guard 
		self.status_of_dans = commands.getstatusoutput("llxcfg-guard isprotected")[0]
		self.status_of_blacklist = ""
		self.blacklist_status()
	
		# Status of SwitchButton of Filtering
		self.status_of_filtering = self.status_of_dans
		if not ( self.status_of_filtering ):
			self.image_status_off.hide()
			self.image_black.hide()
			self.image_status_on.show()
			self.image_color.show()
			self.button_status.set_label(_("Desactive Filtering"))

		else:
			self.image_status_on.hide()
			self.image_color.hide()
			self.image_status_off.show()
			self.image_black.show()
			self.button_status.set_label(_("Active Filtering"))
		
		self.replenish_combobox()
		# List of non_guard
	
	def replenish_combobox(self):
		
		self.combobox_set = self.glade.get_widget("combobox_set")
		self.combobox_set.get_model().clear()
		self.list_sets = [l.split('\t') for l in commands.getoutput("llxcfg-guard list").split('\n')]

		# Set active the Chosen	 
		self.combobox_index = 0
	
		for f in self.list_sets:
			self.combobox_set.append_text(f[1])

			if (f[3] == "1"):
				self.combobox_set.set_active(self.combobox_index) 
			self.combobox_index = self.combobox_index + 1
		self.active_label = self.glade.get_widget("label_se")
		self.active_label.set_label(self.combobox_set.get_active_text())

	def new(self):
		#context WindowGuard.new {
		print "A new WindowGuard has been created"
		#context WindowGuard.new }

	#context WindowGuard custom methods {
	#--- Write your own methods here ---#
	#context WindowGuard custom methods }

	def on_button_admin_groups_clicked(self,widget, *args):
		self.status_of_groups = commands.getstatusoutput("lliurex-guard-admin-groups")[0]
	
	def on_window_guard_destroy(self, widget, *args):
		gtk.main_quit()

#   def on_list_guard_selection_changed(self, widget, *args):
#	   print ""

	def on_button_status_clicked(self, widget, *args):

		if (self.status_of_filtering):
			self.status_of_filtering = False
		else: 
			self.status_of_filtering = True

		if not ( self.status_of_filtering ): 
			self.image_status_off.hide()
			self.image_black.hide()
			self.image_status_on.show()
			self.image_color.show()
			self.status = commands.getstatusoutput("llxcfg-guard protect")[0]
			self.button_blacklist_download.set_sensitive(True)
			self.blacklist_status()
			self.button_status.set_label(_("Desactive Filtering"))
				
		else:
			self.image_status_on.hide()
			self.image_color.hide()
			self.image_status_off.show()
			self.image_black.show()
			self.status = commands.getstatusoutput("llxcfg-guard unprotect")[0]
			self.blacklist_status_on.hide()
			self.blacklist_status_off.show()
			self.button_blacklist_disable.set_sensitive(False)
			self.button_blacklist_enable.set_sensitive(False)
			self.button_blacklist_download.set_sensitive(False)
			self.button_status.set_label(_("Active Filtering"))

	def on_button_edit_banners_clicked(self, widget, *args):
		self.lists_files = commands.getoutput("llxcfg-guard editable-banned %s 2> /dev/null" % self.combobox_set.get_active_text()).split('\n')
		print "llxcfg-guard editable-list %s" % self.combobox_set.get_active_text()
		print ' '.join(self.lists_files)
		self.status = commands.getstatusoutput("gedit %s" % ' '.join(self.lists_files))[0]
		
	def on_button_edit_exceptions_clicked(self, widget, *args):
		self.lists_files = commands.getoutput("llxcfg-guard editable-exceptions %s 2> /dev/null" % self.combobox_set.get_active_text()).split('\n')
		print "llxcfg-guard editable-list %s" % self.combobox_set.get_active_text()
		print ' '.join(self.lists_files)
		self.status = commands.getstatusoutput("gedit %s" % ' '.join(self.lists_files))[0]

	def on_button_edit_swearwords_clicked(self, widget, *args):
		self.lists_files = commands.getoutput("llxcfg-guard editable-phraselists %s 2> /dev/null" % self.combobox_set.get_active_text()).split('\n')
		print "llxcfg-guard editable-list %s" % self.combobox_set.get_active_text()
		print ' '.join(self.lists_files)
		self.status = commands.getstatusoutput("gedit %s" % ' '.join(self.lists_files))[0]

	def on_button_new_from_old_clicked(self, widget, *args):
		self.name_of_new = commands.getoutput("zenity --entry --text=Name")
		self.status = commands.getstatusoutput("llxcfg-guard add %s %s " % (self.name_of_new,self.combobox_set.get_active_text()))
		self.replenish_combobox()


	def on_button_delete_clicked(self,widget, *args):
		#print "llxcfg-guard del %s " % self.combobox_set.get_active_text()
		self.question_text=_("Are you sure that you want to delete this profile?")
		self.status=commands.getstatusoutput("zenity  --question --text=\" %s\"" % self.question_text)[0]
		if (self.status) :
			self.status = commands.getstatusoutput("llxcfg-guard del %s " % self.combobox_set.get_active_text())[0]
			self.replenish_combobox()   
	
	def on_button_exit_clicked(self, widget, *args):
		gtk.main_quit()

	def on_button_apply_clicked(self, widget, *args):
		self.status = commands.getstatusoutput("llxcfg-guard enable %s| zenity --progress --pulsate --auto-close" %self.combobox_set.get_active_text())[0]
#	   self.status = commands.getstatusoutput("llxcfg-guard update")[0]
		self.replenish_combobox()
		
	def on_button_blacklist_download_clicked(self, widget, *args):
		self.question_text=_("Do you want download blacklist from Internet\n(Shalla's Blacklists) for private usage?\n\nYou need internet connection.")
		if (self.ask_msg(self.question_text)):
			self.status = commands.getstatusoutput("llxcfg-guard download-blacklist | zenity --progress --pulsate --auto-close")
			self.blacklist_status()
		
	def on_button_blacklist_disable_clicked(self, widget, *args):
		self.status = commands.getstatusoutput("llxcfg-guard disable-blacklist | zenity --progress --pulsate --auto-close")
		#print(self.status)
		self.blacklist_status()
		
	def on_button_blacklist_enable_clicked(self, widget, *args):
		self.status = commands.getstatusoutput("llxcfg-guard enable-blacklist | zenity --progress --pulsate --auto-close")
		#print(self.status)
		self.blacklist_status()
		if ( self.status_of_blacklist[0] ):
			self.question_text=_("You need first download blacklist from Internet.")
			self.info_msg(self.question_text)
			
	def blacklist_status(self):
		self.status_of_blacklist = commands.getstatusoutput("llxcfg-guard isblacklisted")
		self.download_of_blacklist = commands.getstatusoutput("llxcfg-guard isdownloaded-blacklist")
		#print(self.status_of_blacklist)
		if not ( self.status_of_blacklist[0] ):
			self.blacklist_status_off.hide()
			self.blacklist_status_on.show()
			self.button_blacklist_disable.set_sensitive(True)
			self.button_blacklist_enable.set_sensitive(False)
		else:
			self.blacklist_status_on.hide()
			self.blacklist_status_off.show()
			self.button_blacklist_disable.set_sensitive(False)
			self.button_blacklist_enable.set_sensitive(True)
			
		if (self.download_of_blacklist[0]):
			self.button_blacklist_disable.set_sensitive(False)
			self.button_blacklist_enable.set_sensitive(False)
			
	def info_msg(self,txt):
		d = gtk.MessageDialog(None,
						  gtk.DIALOG_MODAL |
						  gtk.DIALOG_DESTROY_WITH_PARENT,
						  gtk.MESSAGE_INFO,
						  gtk.BUTTONS_OK,
						  txt)
		d.run()
		d.destroy()
		
	def ask_msg(self,txt):
		response="yes"
		d = gtk.MessageDialog(None,
			gtk.DIALOG_MODAL |
			gtk.DIALOG_DESTROY_WITH_PARENT,
			gtk.MESSAGE_QUESTION,
			gtk.BUTTONS_YES_NO,
			txt)
		if d.run() == gtk.RESPONSE_YES:
			response=True
		else:
			response=False
		d.destroy()
		return response
		
	def on_combobox_set_changed(self, widget, *args):
		for f in self.list_sets:
			if ( f[1] == self.combobox_set.get_active_text()): 
				if (f[2] == "1") :  
					self.button_edit_exceptions.set_sensitive(True)
					self.button_edit_swearwords.set_sensitive(True)
					self.button_edit_banners.set_sensitive(True)
					self.button_delete.set_sensitive(True)
				else:
					self.button_edit_exceptions.set_sensitive(False)
					self.button_edit_swearwords.set_sensitive(False)
					self.button_edit_banners.set_sensitive(False)
					self.button_delete.set_sensitive(False)
				if (f[3] == "1") : 
					self.button_delete.set_sensitive(False)


