/**
 * $Id: GHOST_Path-api.cpp 29954 2010-07-05 00:00:40Z campbellbarton $
 *
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2010 by Blender Foundation.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL LICENSE BLOCK *****
 */

#include "intern/GHOST_Debug.h"
#include "GHOST_Path-api.h"
#include "GHOST_ISystem.h"

const GHOST_TUns8* GHOST_getSystemDir()
{
	GHOST_ISystem* system = GHOST_ISystem::getSystem();
	return system ? system->getSystemDir() : NULL;
}

const GHOST_TUns8* GHOST_getUserDir()
{
	GHOST_ISystem* system = GHOST_ISystem::getSystem();
	return system ? system->getUserDir() : NULL; /* will be NULL in background mode */
}

const GHOST_TUns8* GHOST_getBinaryDir()
{
	GHOST_ISystem* system = GHOST_ISystem::getSystem();
	return system ? system->getBinaryDir() : NULL; /* will be NULL in background mode */
}
