/**
 * $Id: logic_header.c 27676 2010-03-23 14:09:09Z campbellbarton $
 *
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2009 Blender Foundation.
 * All rights reserved.
 *
 * 
 * Contributor(s): Blender Foundation
 *
 * ***** END GPL LICENSE BLOCK *****
 */

#include <string.h>
#include <stdio.h>


#include "MEM_guardedalloc.h"

#include "BLI_blenlib.h"

#include "BKE_context.h"
#include "BKE_screen.h"
#include "BKE_main.h"

#include "ED_screen.h"
#include "ED_types.h"
#include "ED_util.h"


#include "BIF_gl.h"
#include "BIF_glutil.h"

#include "UI_interface.h"
#include "UI_resources.h"
#include "UI_view2d.h"

#include "logic_intern.h"

/* ************************ header area region *********************** */


static void do_logic_buttons(bContext *C, void *arg, int event)
{
//	SpaceLogic *slogic= CTX_wm_space_logic(C);
}

static uiBlock *logic_addmenu(bContext *C, ARegion *ar, void *arg_unused)
{
//	SpaceLogic *slogic= CTX_wm_space_logic(C);
	uiBlock *block;
	short yco= 0, menuwidth=120;
	
	block= uiBeginBlock(C, ar, "logic_addmenu", UI_EMBOSSP);
//	uiBlockSetButmFunc(block, do_logic_addmenu, NULL);
	
	uiDefIconTextBut(block, BUTM, 1, ICON_BLANK1, "Nothing yet", 0, yco-=20, menuwidth, 19, NULL, 0.0, 0.0, 1, 2, "");
	
	uiTextBoundsBlock(block, 50);
	uiBlockSetDirection(block, UI_TOP);
	uiEndBlock(C, block);
	
	return block;
}	

void logic_header_buttons(const bContext *C, ARegion *ar)
{
	ScrArea *sa= CTX_wm_area(C);
//	SpaceLogic *slogic= CTX_wm_space_logic(C);
	uiBlock *block;
	short xco, yco= 3;
	
	block= uiBeginBlock(C, ar, "header logic", UI_EMBOSS);
	uiBlockSetHandleFunc(block, do_logic_buttons, NULL);
	
	xco= ED_area_header_standardbuttons(C, block, yco);
	
	if((sa->flag & HEADER_NO_PULLDOWN)==0) {
		int xmax;
	
		xmax= GetButStringLength("View");
		uiDefPulldownBut(block, logic_addmenu, NULL, 
					  "View", xco, yco, xmax-3, 20, "");
		xco+= xmax;
		
		xmax= GetButStringLength("Select");
		uiDefPulldownBut(block, logic_addmenu, NULL, 
						 "Select", xco, yco, xmax-3, 20, "");
		xco+= xmax;
		
		xmax= GetButStringLength("Add");
		uiDefPulldownBut(block, logic_addmenu, NULL, 
						 "Add", xco, yco, xmax-3, 20, "");
		xco+= xmax;
	}
	
	uiBlockSetEmboss(block, UI_EMBOSS);
	
	UI_view2d_totRect_set(&ar->v2d, xco+XIC+100, (int)(ar->v2d.tot.ymax-ar->v2d.tot.ymin));
	
	uiEndBlock(C, block);
	uiDrawBlock(C, block);
}


