# vars



# functions used by tcos hooks

_ldd () {
  # wrapper to ldd
  LC_ALL=C ldd $@ 2>/dev/null || return 1
  return 0
}

_echo () {
 # wrapper to echo in scripts
    echo "$@"
}

_debug() {
  if [ ${TCOS_DEBUG} ]; then
    echo "   DEBUG :: $@" >&2
  fi
}

_verbose() {
  if [ ${TCOS_VERBOSE} ]; then
    echo "## VERBOSE ## '$@'" >&2
  fi
}

_warning() {
  # always show
  echo "## WARNING ## '$@'" >&2
}



read_template() {
  [ ! -e "$1" ] && return
  tpl=$(awk -F"=" '/^TCOS_TEMPLATE=/ {print $2}' $1)
  if [ "$tpl" = "" ]; then
    _verbose "(t-g-f) Not found TEMPLATE in $1, searching BASED_TEMPLATE"
    tpl=$(awk -F"=" '/^TCOS_BASED_TEMPLATE=/ {print $2}' $1)
  fi
  [ "$tpl" = "" ] && _warning "(t-g-f) template don't have TCOS_TEMPLATE or TCOS_BASED_TEMPLATE. BUG???" && return
  #_debug "Template $tpl"
  for tdir in /usr/share/initramfs-tools-tcos/templates /etc/tcos/templates; do
    _verbose "(t-g-f) Searching in dir $tdir"
    [ -f $tdir/$tpl ] && echo "$tdir/$tpl" && break
  done
}

tcos_get_templates() {
  # read template from tcos.conf
  tpl1=$(read_template /etc/tcos/tcos.conf)
  tpl2=""
  personalized=""
  _verbose "(t-g-f) Default template $tpl"
  for tfile in $(find /etc/tcos/templates -type f -name "*.conf"); do
    if [ -f $tfile ]; then
      #_debug "$tfile file exists, adding to tpl2"
      tpl2="$tpl2 $(read_template $tfile)"
      personalized=$tfile
    else
      _verbose "(t-g-f) Based template $tfile not found, ignoring"
    fi
  done
  if [ "$( echo $tpl2 | sed 's/[[:blank:]]//g' )" != "" ]; then
    _verbose "(t-g-f) return tpl2='base.conf $tpl2 $personalized'"
    echo "/usr/share/initramfs-tools-tcos/templates/base.conf $tpl2 $personalized"
  else
    _verbose "(t-g-f) return tpl1='base.conf $tpl1'"
    echo "/usr/share/initramfs-tools-tcos/templates/base.conf $tpl1"
  fi
}


convert_links2files () {
# convert all links in $DESTDIR to linked files
# needed to calculate initramfs space
 #_echo "Converting links to files..."
 subdir=$1
 if [ "$subdir" = "" ]; then
   subdir="usr"
 fi
 dir=$(pwd)
 cd $DESTDIR
 # copy binary not links
 for xfile in $(find "$subdir" -type l); do
   _link=$(readlink $xfile)
   if [ $(echo $_link | grep -c ${TCOS_PKG_CACHE}) != 0 ]; then
     rm -f $DESTDIR/$xfile
     cp -f $_link $DESTDIR/$xfile
     #_echo " ******** convert_link2files() CACHED FILE => cp -f $_link $DESTDIR/$xfile"

   elif [ -f /$xfile ] ;then
     rm -f $DESTDIR/$xfile
     cp -f /$xfile $DESTDIR/$xfile
     #_echo "  :::::::  convert_link2files() :::::A:::: cp /$xfile $DESTDIR/$xfile"

   else
     #_echo "    convert_links2files() "
     rm -f $DESTDIR/$xfile
     cp -f $_link $DESTDIR/$xfile
     #_echo "  :::::::  convert_link2files() :::::R:::: cp -f $_link $DESTDIR/$xfile"
   fi
 done
 cd $dir
}


stat_before () {
  # read space in $DESTDIR (this functions is a checkpoint)
  size1=$(du -s ${DESTDIR} 2>/dev/null| awk '{print $1}')
}
stat_after () {
  # read size after checkpoint and prints diff between disk space
  # this give what space need an app
  convert_links2files
  size2=$(du -s ${DESTDIR} 2>/dev/null| awk '{print $1}')
  #diff_size=$(echo $((size2 -size1)) )
  diff_size=$(echo $size2 $size1 | awk '{print $1 - $2}' )
  if [ ${TCOS_DEBUG} ]; then
     _echo "  Package $1 got ${diff_size} Kb."
  fi
}

pathof() {
  # give absolute path of $1 binary (if found)
    location=$(which $1 | awk '{print $1}')
    if [ -z $location ]; then
        location=$(whereis $1 | awk '{print $2}')
    fi
    if [ ! -e $location ]; then
        echo "pathof() ERROR $1 not found !!!" 1>&2
    fi
    echo $location
}

cpifexists () {
 orig=$1
 dest=$2
  if [ -f $DESTDIR/$orig ]; then
    return 1
  fi
  
  
  if [ $# != 2 ]; then
   echo "    cpifexists(): ERROR: Need 2 arguments: \$1=$orig \$2=$dest"
   return 1
 fi
 
 if [ ! -f $orig ]; then
   echo "    cpifexits() WARNING: $orig not found, searching with pathof()..."
   _file=$(pathof $(basename $orig) )
   if [ "$_file" = "" ]; then
     echo "    cpifexists(): ERROR $orig not found in PATH, please install package that contain $orig."
     return 1
   elif [ -f "$_file" ]; then
     echo "    cpifexists(): FIXED: $(basename $orig) found in other path: $_file, using it!!!"
     orig=$_file
   else
     echo "   cpifexists(): ERROR: $(basename $orig) no found in PATH, please package that contain $orig"
     return 1
   fi   
 fi

 
 if [ ! -d $DESTDIR/$dest ]; then
   echo "  cpifexits() WARNING: $DESTDIR/$dest don't exists"
 fi


copy_exec "${orig}" "${dest}"
return 0
}

copydir () {
 if [ $# != 2 ]; then
   echo "copydir() ERROR Need 2 arguments: \$1=$1 \$2=$2"
   #_echo "     DEBUG: \$1=$1 \$2=$2"
   return 1
 fi
 if [ ! -d $1 ]; then
   echo "copydir() WARNING $1 dir not exits"
   #_echo "     DEBUG: \$1=$1 \$2=$2"
   return 1
 fi
 
#_echo "cp -ra \"${1}\" \"${DESTDIR}/${2}\""
cp -ra "${1}" "${DESTDIR}/${2}"
return 0
}

read_env_var() {
# read from env var
tmpvar=$(env| grep "^$1=" | awk -F "=" '{print $2}')
if [ "$tmpvar" = "" ]; then
  echo "$2"
else
  echo $tmpvar
fi
}

# ubuntu dapper have very old manual_add_modules that don't work correctly
tcos_manual_add_modules()
{
	for mam_x in $(modprobe --set-version="${version}" --ignore-install \
	--show-depends "${1}" 2>/dev/null | awk '/^insmod/ { print $2 }'); do
		# Prune duplicates
		if [ -e "${DESTDIR}/${mam_x}" ]; then
			continue
		fi

		mkdir -p "${DESTDIR}/$(dirname "${mam_x}")"
		ln -s "${mam_x}" "${DESTDIR}/$(dirname "${mam_x}")"
		if [ -n "${verbose}" ] && [ "${verbose}" = "y" ]; then
			echo "Adding module ${mam_x}"
		fi
	done
}


force_add_module() {
        # force copy of module modprobe dont show as dependency
        this_module=$(modprobe --set-version="${version}" -l "${1}")
        if [ ! -e "${DESTDIR}/${this_module}" ]; then
                #echo "  WARNING, adding module $(basename ${this_module}), see Debian bug: #384043"
                mkdir -p "${DESTDIR}/$(dirname "${this_module}")"
                ln -s "${this_module}" "${DESTDIR}/$(dirname "${this_module}")"
        fi
        # end of force copy
}

parse_pxelinuxcfg() {
        if [ $TCOS_NETBOOT_MENU ] && [ -z $2 ]; then
          TEMPLATE=${TCOS_CONF}/${TCOS_PXECFG_MENU}
          _verbose "(t-g-f) BOOT_MENU=1"
        else
          TEMPLATE=${TCOS_CONF}/${TCOS_PXECFG}
          _verbose "(t-g-f) BOOT_MENU=0"
        fi

        if [ $TCOS_NETBOOT_MENU_VESA ]; then
          TCOS_MENU_TYPE=vesamenu.c32
        else
          TCOS_MENU_TYPE=menu.c32
        fi

        if [ $TCOS_NETBOOT_HIDE_INSTALL ]; then
          TCOS_NETBOOT_HIDE_INSTALL_STRING=""
        else
          TCOS_NETBOOT_HIDE_INSTALL_STRING="#"
        fi

        if [ $TCOS_NETBOOT_HIDE_LOCAL ]; then
          TCOS_NETBOOT_HIDE_LOCAL_STRING=""
        else
          TCOS_NETBOOT_HIDE_LOCAL_STRING="#"
        fi

        if [ "$1" != "" ]; then
           DESTFILE=$1
        else
           DESTFILE=${TFTP_DIR}/pxelinux.cfg/default
        fi
        echo "## Generated file don't edit, edit $TEMPLATE instead"                  > ${DESTFILE}
        echo "## File generated by gentcos on $(date)"                               >> ${DESTFILE}
        cat ${TEMPLATE} >> ${DESTFILE}
	[ -e "${TEMPLATE}.others" ] && cat "${TEMPLATE}.others" > "${DESTFILE}.others"
        if [ -d /etc/tcos/conf.d/ ]; then
          if [ $TCOS_NETBOOT_MENU ] && [ -z $2 ]; then
             for i in /etc/tcos/templates/pxelinux.menu*.tpl; do
               [ -e $i ] && cat $i >> ${DESTFILE}
             done
          else
             for i in /etc/tcos/templates/pxelinux.nomenu*.tpl; do
               [ -e $i ] && cat $i >> ${DESTFILE}
             done
          fi
        fi
	
	VAR_LIST="SRV_IP ZNB_BOOT_DEFAULT ZNB_ENABLE_INSTALL ZNB_CENTRO_ENABLE ZNB_SERVER_ENABLE ZNB_CLIENT_ENABLE ZNB_DESKTOP_ENABLE ZNB_MUSIC_ENABLE ZNB_BIBLIO_ENABLE ZNB_INFANTIL_ENABLE ZNB_LITE_ENABLE ZNB_PIME_ENABLE ZNB_ADVANCED_ENABLE LLIUREX_PXE_FLAVOURS ZNB_LANGUAGE_DEFAULT"
	LLX_GETVAR="/usr/sbin/llxcfg-showvars"
	eval `${LLX_GETVAR} ${VAR_LIST}`
	
	if [ $SRV_IP ]; then
          SRVIP=$SRV_IP
        else
          SRVIP=""
        fi

	if [ "$ZNB_ENABLE_INSTALL" = "Y" ]; then
          HIDE_INSTALL="#"
        else
          HIDE_INSTALL=""
        fi

	[ -e  /etc/zero-net-boot/conf.cfg ] && PXEPASSWORD="$(cat /etc/zero-net-boot/conf.cfg | grep "^pxepassword=" | awk -F"=" '{print $2}')"

	if [ "$ZNB_ADVANCED_ENABLE" = "Y" ] && [ ! -z "$PXEPASSWORD" ]; then
          HIDE_ADVANCED="#"
	  ENABLE_PXE_PASSWORD=""
	  PXE_SHA1="$(/usr/bin/mkpasswd -m sha-256 $PXEPASSWORD 2>/dev/null | sed -e "s/\\$/\\\\$/g" 2>/dev/null)"
	  [ -e "${TEMPLATE}.advanced" ] && cat "${TEMPLATE}.advanced" > "${DESTFILE}.advanced"
        else
          HIDE_ADVANCED=""
	  ENABLE_PXE_PASSWORD="#"
	  PXE_SHA1=""
	  [ -e "${DESTFILE}.advanced" ] && rm -f "${DESTFILE}.advanced" 2>/dev/null
        fi

	TCOS_DEFAULT_LABEL="#"
	TCOS_OTHERS_DEFAULT_LABEL="#"
	TCOS_OTHERS_DEFAULT_VESA=""
	TCOS_OTHERS_DEFAULT_NOAUDIO="#"
	TCOS_OTHERS_DEFAULT_NOUSB="#"
	TCOS_OTHERS_DEFAULT_NOAUDIOUSB="#"
	TCOS_OTHERS_DEFAULT_MINIMO="#"

	case $ZNB_BOOT_DEFAULT in
		tcos)
			TCOS_DEFAULT_LABEL=""
			;;
		tcos-vesa)
			TCOS_DEFAULT_LABEL="#"
			TCOS_OTHERS_DEFAULT_LABEL=""
			;;
		tcos-noaudio)
			TCOS_DEFAULT_LABEL="#"
			TCOS_OTHERS_DEFAULT_LABEL=""
			TCOS_OTHERS_DEFAULT_VESA="#"
			TCOS_OTHERS_DEFAULT_NOAUDIO=""
			;;
		tcos-nousb)
			TCOS_DEFAULT_LABEL="#"
			TCOS_OTHERS_DEFAULT_LABEL=""
			TCOS_OTHERS_DEFAULT_VESA="#"
			TCOS_OTHERS_DEFAULT_NOUSB=""
			;;
		tcos-noaudiousb)
			TCOS_DEFAULT_LABEL="#"
			TCOS_OTHERS_DEFAULT_LABEL=""
			TCOS_OTHERS_DEFAULT_VESA="#"
			TCOS_OTHERS_DEFAULT_NOAUDIOUSB=""
			;;
		tcos-minimo)
			TCOS_DEFAULT_LABEL="#"
			TCOS_OTHERS_DEFAULT_LABEL=""
			TCOS_OTHERS_DEFAULT_VESA="#"
			TCOS_OTHERS_DEFAULT_MINIMO=""
			;;
	esac

	if [ "$ZNB_LANGUAGE_DEFAULT" = "qcv_ES" ]; then
          LANG_ES="#"
          LANG_QCV=""
	else
          LANG_ES=""
          LANG_QCV="#"
        fi

	#FLAVOURS="server client desktop music biblio infantil lite"

	for flavour in $LLIUREX_PXE_FLAVOURS; do
            HIDE_ENABLE=""
            HIDE_DEFAULT="#"
            flavour_upper="$(echo $flavour | tr [:lower:] [:upper:])"
            flavour_menu="ZNB_${flavour_upper}_ENABLE"
            flavour_enable="$(eval echo \$$flavour_menu)"
            if [ -e /etc/tcos/pxelinux.menu.$flavour.cfg.tpl ]; then
	       if [ -d ${TFTP_DIR}/modelo-$flavour/ ] && [ -e ${TFTP_DIR}/modelo-$flavour/casper/vmlinuz ]; then
                   [ -h ${TFTP_DIR}/$flavour ] && rm -f ${TFTP_DIR}/$flavour
                   [ -h ${TFTP_DIR}/${flavour}.vcs ] && rm -f ${TFTP_DIR}/${flavour}.vcs
                   [ -h ${TFTP_DIR}/${flavour}.img ] && rm -f ${TFTP_DIR}/${flavour}.img
                   [ -h ${TFTP_DIR}/${flavour}.ics ] && rm -f ${TFTP_DIR}/${flavour}.ics
                   [ -h "${TFTP_DIR}/${flavour}c" ] && rm -f "${TFTP_DIR}/${flavour}c"
                   [ -h "${TFTP_DIR}/${flavour}c.img" ] && rm -f "${TFTP_DIR}/${flavour}c.img"
                   [ -h ${TFTP_DIR}/${flavour}.vsl ] && rm -f ${TFTP_DIR}/${flavour}.vsl
                   [ -h ${TFTP_DIR}/${flavour}.isl ] && rm -f ${TFTP_DIR}/${flavour}.isl
                   echo "## Generated file don't edit, edit ${DESTFILE}.$flavour instead"       > ${DESTFILE}.$flavour
                   echo "## File generated by gentcos on $(date)"                               >> ${DESTFILE}.$flavour
                   cat /etc/tcos/pxelinux.menu.$flavour.cfg.tpl >> ${DESTFILE}.$flavour
         	   [ -e ${TFTP_DIR}/modelo-$flavour/casper/vmlinuz ] && [ ! -h ${TFTP_DIR}/$flavour ] && ln -s ${TFTP_DIR}/modelo-$flavour/casper/vmlinuz ${TFTP_DIR}/$flavour
         	   [ -e ${TFTP_DIR}/modelo-$flavour/casper/vmlinuz.semi ] && [ ! -h ${TFTP_DIR}/${flavour}.vsl ] && ln -s ${TFTP_DIR}/modelo-$flavour/casper/vmlinuz.semi ${TFTP_DIR}/${flavour}.vsl
        	   [ -e ${TFTP_DIR}/modelo-$flavour/casper/initrd.img ] && [ ! -h ${TFTP_DIR}/${flavour}.img ] && ln -s ${TFTP_DIR}/modelo-$flavour/casper/initrd.img ${TFTP_DIR}/${flavour}.img
        	   [ -e ${TFTP_DIR}/modelo-$flavour/casper/initrd.semi ] && [ ! -h ${TFTP_DIR}/${flavour}.isl ] && ln -s ${TFTP_DIR}/modelo-$flavour/casper/initrd.semi ${TFTP_DIR}/${flavour}.isl
         	   #[ -e ${TFTP_DIR}/modelo-$flavour/casper/vmlinuzc ] && [ ! -h "${TFTP_DIR}/${flavour}c" ] && ln -s ${TFTP_DIR}/modelo-$flavour/casper/vmlinuzc "${TFTP_DIR}/${flavour}c"
        	   #[ -e ${TFTP_DIR}/modelo-$flavour/casper/initrdc.img ] && [ ! -h "${TFTP_DIR}/${flavour}c.img" ] && ln -s ${TFTP_DIR}/modelo-$flavour/casper/initrdc.img "${TFTP_DIR}/${flavour}c.img"
                   if [ "$flavour_enable" = "Y" ]; then
                       HIDE_ENABLE="#"
                       if [ "$ZNB_BOOT_DEFAULT" = "$flavour" ]; then
                           HIDE_DEFAULT=""
                       fi
                   fi
               else
                  [ -h ${TFTP_DIR}/$flavour ] && rm -f ${TFTP_DIR}/$flavour
                  [ -h ${TFTP_DIR}/${flavour}.vcs ] && rm -f ${TFTP_DIR}/${flavour}.vcs
                  [ -h ${TFTP_DIR}/${flavour}.img ] && rm -f ${TFTP_DIR}/${flavour}.img
                  [ -h ${TFTP_DIR}/${flavour}.ics ] && rm -f ${TFTP_DIR}/${flavour}.ics
                  [ -h "${TFTP_DIR}/${flavour}c" ] && rm -f "${TFTP_DIR}/${flavour}c"
                  [ -h "${TFTP_DIR}/${flavour}c.img" ] && rm -f "${TFTP_DIR}/${flavour}c.img"
                  [ -h ${TFTP_DIR}/${flavour}.vsl ] && rm -f ${TFTP_DIR}/${flavour}.vsl
                  [ -h ${TFTP_DIR}/${flavour}.isl ] && rm -f ${TFTP_DIR}/${flavour}.isl
               fi	
            fi
            sed -i -e "s/__HIDE_${flavour_upper}__/${HIDE_ENABLE}/g" ${DESTFILE}
            sed -i -e "s/__HIDE_${flavour_upper}_DEFAULT__/${HIDE_DEFAULT}/g" ${DESTFILE}
            if [ -e "${DESTFILE}.advanced" ]; then
		sed -i -e "s/__HIDE_${flavour_upper}__/${HIDE_ENABLE}/g" "${DESTFILE}.advanced"
            fi
	done
        
        for pxe_template in $(ls ${TFTP_DIR}/pxelinux.cfg/); do
          sed -i -e "s/__TCOS_KERNEL__/${TCOS_KERNEL}/g" \
              -e "s/__DATE__/$(date)/g" \
              -e "s/__TCOS_MENU_TYPE__/${TCOS_MENU_TYPE}/g" \
              -e "s/__TCOS_NETBOOT_HIDE_INSTALL__/${TCOS_NETBOOT_HIDE_INSTALL_STRING}/g" \
              -e "s/__TCOS_NETBOOT_HIDE_LOCAL__/${TCOS_NETBOOT_HIDE_LOCAL_STRING}/g" \
              -e "s/__TCOS_MENU_PASSWD__/${TCOS_ROOT_PASSWD}/g" \
              -e "s/__TFTP_LOGO_JPG__/${TFTP_LOGO_JPG}/g" \
              -e "s/__TFTP_MSG_HELP1__/${TFTP_MSG_HELP1}/g" \
              -e "s/__TFTP_MSG_HELP2__/${TFTP_MSG_HELP2}/g" \
              -e "s/__SRV_IP__/${SRVIP}/g" \
              -e "s/__HIDE_INSTALL__/${HIDE_INSTALL}/g" \
              -e "s/__HIDE_ADVANCED__/${HIDE_ADVANCED}/g" \
              -e "s/__ENABLE_PXE_PASSWORD__/${ENABLE_PXE_PASSWORD}/g" \
              -e "s/__LANG_ES__/${LANG_ES}/g" \
              -e "s/__LANG_QCV__/${LANG_QCV}/g" \
              -e "s/__TCOS_DEFAULT_LABEL__/${TCOS_DEFAULT_LABEL}/g" \
              -e "s/__TCOS_OTHERS_DEFAULT_LABEL__/${TCOS_OTHERS_DEFAULT_LABEL}/g" \
              -e "s/__TCOS_OTHERS_DEFAULT_VESA__/${TCOS_OTHERS_DEFAULT_VESA}/g" \
              -e "s/__TCOS_OTHERS_DEFAULT_NOAUDIO__/${TCOS_OTHERS_DEFAULT_NOAUDIO}/g" \
              -e "s/__TCOS_OTHERS_DEFAULT_NOUSB__/${TCOS_OTHERS_DEFAULT_NOUSB}/g" \
              -e "s/__TCOS_OTHERS_DEFAULT_NOAUDIOUSB__/${TCOS_OTHERS_DEFAULT_NOAUDIOUSB}/g" \
              -e "s/__TCOS_OTHERS_DEFAULT_MINIMO__/${TCOS_OTHERS_DEFAULT_MINIMO}/g" \
              -e "s%__TFTP_DIR__%${TFTP_DIR}%g" \
              -e "s/__TFTP_MSG__/${TFTP_MSG}/g" ${TFTP_DIR}/pxelinux.cfg/${pxe_template}
          sed -i -e "s%__PXE_SHA1__%${PXE_SHA1}%g" ${TFTP_DIR}/pxelinux.cfg/${pxe_template}
          _verbose "(t-g-f) MENU_FILE=$(cat ${TFTP_DIR}/pxelinux.cfg/${pxe_template})"
        done

        if [ ! -h ${TFTP_DIR}/vmlinuz-${TCOS_KERNEL} ]; then
          _echo "  Linking vmlinuz-${TCOS_KERNEL} in ${TFTP_DIR}"
          ln -s /boot/vmlinuz-${TCOS_KERNEL} ${TFTP_DIR}
        fi

        if [ -d /etc/tcos/pxelinux.d ]; then
            for f in /etc/tcos/pxelinux.d/*.hook ; do
                . $f || true
            done
        fi

}

