#!/bin/sh
# tcos-udev.sh
# exec by udevd in all block events:
# SUBSYSTEM=="block"

output_file=/tmp/tcos-udevd.log

# don't listen on udev events during boot
# this file is created in scripts/tcos-bottom/55mount_listener
if [ ! -f /var/run/tcos-udev.run ]; then
  exit 0
fi


get_env_var() {
  env_var=$(env |grep ^$1=)
  echo $env_var
}

is_cdrom() {
  # receive hdc hda (without /dev/)
  cdrom=$(head -3 /proc/sys/dev/cdrom/info 2>/dev/null | tail -1 | cut -f 3- | grep -c "$1")
  echo $cdrom
}


#check_smart() {
#   	action=$(get_env_var "ACTION")
#	id_bus=$(get_env_var "ID_BUS")
#   	device=$(get_env_var "DEVNAME")
#	devpath=$(get_env_var "DEVPATH" | awk -F"/" '{print $6}')
#   	vendor=$(get_env_var "ID_VENDOR")
#   	label="ID_FS_LABEL="$(get_env_var "DEVPATH" | awk -F"/" '{print $6}')
#    	model=$(get_env_var "ID_MODEL")
#	vendor_id=$(get_env_var "ID_VENDOR_ID")
#    	model_id=$(get_env_var "ID_MODEL_ID")
#	if [ "$vendor_id" = "ID_VENDOR_ID=0b8c" ] && [ "$action" = "ACTION=add" ]; then
#		/usr/sbin/usbip_bind_driver --usbip $devpath
#		echo "$id_bus#$device#$action#$label#$vendor_id#$vendor#$model#$devpath" >> $output_file
#		exit 0
#	fi
#}


   action=$(get_env_var "ACTION")

if [ "$action" = "ACTION=mount" ] || [ "$action" = "ACTION=umount" ]; then
  # action mount/umount not controlled by tcos-udev.sh
  echo "**tcos-udev.sh ** $action not processed" >> /var/log/listener-daemon.log
  exit 0
fi


   #check_smart
   id_bus=$(get_env_var "ID_BUS")
   device=$(get_env_var "DEVNAME")
  devpath=$(get_env_var "DEVPATH")
  if echo $devpath | grep -q "/devices/" ; then
    # translate name
    _devpath=$(echo "$devpath" | awk -F"/block" '{print "DEVPATH=/block"$2}')
    echo "tcos-udevd.sh OLD ==>$devpath" >> /var/log/listener-daemon.log
    echo "tcos-udevd.sh NEW ==>$_devpath" >> /var/log/listener-daemon.log
    devpath=$_devpath
  fi

  blockname=$(echo $devpath | awk -F"/" '{print $3}')
       part=$(echo $device | awk -F"/" '{print $3}')

if [ $(echo $DEVNAME | grep -c "/dev/loop") != 0 ]; then
   exit 0
fi
if [ $(echo $DEVNAME | grep -c "/dev/ram") != 0 ]; then
   exit 0
fi

    label="ID_FS_LABEL="$(get_env_var "ID_FS_LABEL_SAFE"| awk -F"=" '{print $2}')
  fs_type=$(get_env_var "ID_FS_TYPE")

if [ "$fs_type" = "ID_FS_TYPE=" ] || [ "$fs_type" = "" ]; then
  fs=$(get_filesystem "${device#DEVNAME=}" --only)
  if [ "$fs" != "auto" ] && [ "$fs" != "" ] && [ "$fs" != "unknow" ] && [ "$fs" != "error, need device" ] ; then
     fs_type="ID_FS_TYPE=$fs"
  fi
fi

if [ "$(is_cdrom $part)" = 1 ]; then
  fs_type=$(cd_type "${device#DEVNAME=}")
fi


   vendor=$(get_env_var "ID_VENDOR")
    model=$(get_env_var "ID_MODEL")

if [ "$vendor" = "ID_VENDOR=" ] || [ "$vendor" = "" ]; then
  vendor="ID_VENDOR="$(cat $(dirname $(find /sys/class/scsi_disk/*/device/  -name "block:$blockname") 2>/dev/null)/vendor 2>/dev/null | sed 's/ //g')
fi

if [ "$model" = "ID_MODEL=" ] || [ "$model" = "" ]; then
  model="ID_MODEL="$(cat $(dirname $(find /sys/class/scsi_disk/*/device/  -name "block:$blockname") 2>/dev/null)/model 2>/dev/null | sed 's/ //g')
fi


echo "$id_bus#$device#$action#$label#$fs_type#$vendor#$model#$devpath" >> $output_file

exit 0
