/*
* info.c part of tcosxmlrpc
*   => method that get system info based on /proc
* Copyright (C) 2006,2007,2008  mariodebian at gmail
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "common.h"
#include "debug.h"
#include "info_srv.h"

#if NEWAPI
xmlrpc_value *tcos_info(xmlrpc_env *const env, xmlrpc_value *const in, void *const serverContext)
#else
xmlrpc_value *tcos_info(xmlrpc_env *env, xmlrpc_value *in, void *ud)
#endif
 {
  FILE *fp;
  char line[BIG_BUFFER];
  char cmd[BIG_BUFFER];
  char *info;
  char *arg1;
  size_t *len;
  char *fret;

  /* read what info search */
  xmlrpc_parse_value(env, in, "(ss#)", &info, &arg1, &len);

  dbgtcos("tcosxmlrpc::tcos_info() searching for info=\"%s\"\n", info);

  if ( strcmp(info, "get_process") == 0 ) {
    snprintf( cmd, BSIZE, "%s %s", GET_PROCESS_SEMI, arg1);
    fp=(FILE*)popen(cmd, "r");

  /* default method = error */
  } else
    return xmlrpc_build_value(env, "s", INFO_UNKNOW );

  if (fp == NULL)
    return xmlrpc_build_value(env, "s", INFO_UNKNOW );

  /* put error into line var */
  strncpy(line, INFO_ERROR, BSIZE);

  fret = fgets( line, sizeof line, fp);
  remove_line_break(line);
  pclose(fp);

  dbgtcos("tcosxmlrpc::tcos_info() line=\"%s\"\n", line);

  return xmlrpc_build_value(env, "s", line );
}




