/*
* tcosxmlrpc.c standalone XML-RPC server written in C
* Copyright (C) 2006,2007,2008  mariodebian at gmail
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/





#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define HAVE_MAIN

/* My TCOS includes */

#include "common.h"
#include "debug.h"

#include "login.h"
//#include "xauth.h"
#include "info_srv.h"
//#include "standalone.h"
#include "standalone_srv.h"
//#include "pci.h"
//#include "exe.h"
/*#include "screenshot.h"*/
//#include "xorg.h"
//#include "sound.h"
//#include "devices.h"
//#include "lockscreen.h"
//#include "lockcontroller.h"
//#include "vnc.h"
//#include "vlc.h"
//#include "rtp.h"
#include "wine.h"
#include "tnc.h"
//#include "get_screenshot.h"
//#include "reboot_poweroff.h"
//#include "dpms.h"
//#include "pam-usb.h"
//#include "simple-methods.h"
//#include "config.h"





int main (int argc, char **argv)
{
#ifdef NEWAPI
    xmlrpc_server_abyss_parms serverparm;
    xmlrpc_registry * registryP;
    xmlrpc_env envP;
#endif

    /* check command line config file */
    if (argc != 2) {
	fprintf(stderr, "Usage:\n\t tcosxmlrpc-server /path/of/abyss.conf\n");
	return(1);
    }

    /* initialize server */

#ifdef NEWAPI
    xmlrpc_env_init(&envP);
    registryP = xmlrpc_registry_new(&envP);
#else
    xmlrpc_server_abyss_init(XMLRPC_SERVER_ABYSS_NO_FLAGS, argv[1]);
#endif


    /* add methods */


#ifdef NEWAPI
    xmlrpc_registry_add_method(&envP, registryP, NULL, "tcos.login", &tcos_login, NULL);
    xmlrpc_registry_add_method(&envP, registryP, NULL, "tcos.logout", &tcos_logout, NULL);
    xmlrpc_registry_add_method(&envP, registryP, NULL, "tcos.standalone_srv", &tcos_standalone_srv, NULL);
    xmlrpc_registry_add_method(&envP, registryP, NULL, "tcos.info", &tcos_info, NULL);
    xmlrpc_registry_add_method(&envP, registryP, NULL, "tcos.dbus", &tcos_dbus, NULL);
    xmlrpc_registry_add_method(&envP, registryP, NULL, "tcos.wine", &tcos_wine, NULL);
    xmlrpc_registry_add_method(&envP, registryP, NULL, "tcos.tnc", &tcos_tnc, NULL);
#else
    xmlrpc_server_abyss_add_method_w_doc("tcos.login", &tcos_login, NULL,
    "ss:s", "Tcos, Basic auth system.");

    xmlrpc_server_abyss_add_method_w_doc("tcos.logout", &tcos_logout, NULL,
    ":s", "Tcos, Basic auth system.");

    xmlrpc_server_abyss_add_method_w_doc("tcos.standalone_srv", &tcos_standalone_srv, NULL,
    "sss:s", "Tcos, Standalone_srv. Return standalone values (no auth needed)");

   xmlrpc_server_abyss_add_method_w_doc("tcos.info", &tcos_info, NULL,
    "ss:s", "Tcos, Standalone_srv. Return standalone values");

    xmlrpc_server_abyss_add_method_w_doc("tcos.dbus", &tcos_dbus, NULL,
    "s:s", "Tcos, DBus. Exe with a wrapper some dbus events (auth needed)");

    xmlrpc_server_abyss_add_method_w_doc("tcos.wine", &tcos_wine, NULL,
    "ssss:s", "Tcos, manage wine params.");

    xmlrpc_server_abyss_add_method_w_doc("tcos.tnc", &tcos_tnc, NULL,
    "ssssss:s", "Tcos, net controller params.");
#endif

    /*  end of add methods */


    dbgtcos("tcosxmlrpc-server::main() switching to background.\n");


#ifdef NEWAPI
    serverparm.config_file_name = argv[1];
    serverparm.registryP = registryP;
    xmlrpc_server_abyss(&envP, &serverparm, XMLRPC_APSIZE(registryP));
#else
    xmlrpc_server_abyss_run();
#endif

    /* We never reach this point. */
    return 0;
}
