/* mahjongg.c generated by valac 0.15.2.11-7b14d, the Vala compiler
 * generated from mahjongg.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <games-scores.h>
#include <games-clock.h>
#include <games-pause-action.h>
#include <games-fullscreen-action.h>
#include <games-stock.h>
#include <stdlib.h>
#include <string.h>
#include <games-score.h>
#include <glib/gi18n-lib.h>
#include <games-settings.h>
#include <gdk/gdk.h>
#include <games-preimage.h>
#include <time.h>
#include <games-scores-dialog.h>
#include <games-frame.h>
#include <float.h>
#include <math.h>
#include <games-file-list.h>
#include <locale.h>
#include <stdio.h>


#define TYPE_MAHJONGG (mahjongg_get_type ())
#define MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG, Mahjongg))
#define MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG, MahjonggClass))
#define IS_MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG))
#define IS_MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG))
#define MAHJONGG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG, MahjonggClass))

typedef struct _Mahjongg Mahjongg;
typedef struct _MahjonggClass MahjonggClass;
typedef struct _MahjonggPrivate MahjonggPrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__map_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__map_unref0_ (var), NULL)))
typedef struct _MapPrivate MapPrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _map_unref0(var) ((var == NULL) ? NULL : (var = (map_unref (var), NULL)))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameViewPrivate GameViewPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define TYPE_MATCH (match_get_type ())
#define MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH, Match))
#define MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH, MatchClass))
#define IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH))
#define IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH))
#define MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH, MatchClass))

typedef struct _Match Match;
typedef struct _MatchClass MatchClass;
#define __g_list_free__match_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__match_unref0_ (var), NULL)))
typedef struct _MatchPrivate MatchPrivate;
#define _match_unref0(var) ((var == NULL) ? NULL : (var = (match_unref (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))

#define TYPE_MAP_LOADER (map_loader_get_type ())
#define MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_LOADER, MapLoader))
#define MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_LOADER, MapLoaderClass))
#define IS_MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_LOADER))
#define IS_MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_LOADER))
#define MAP_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_LOADER, MapLoaderClass))

typedef struct _MapLoader MapLoader;
typedef struct _MapLoaderClass MapLoaderClass;
#define _map_loader_unref0(var) ((var == NULL) ? NULL : (var = (map_loader_unref (var), NULL)))
typedef struct _MapLoaderPrivate MapLoaderPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Mahjongg {
	GtkApplication parent_instance;
	MahjonggPrivate * priv;
};

struct _MahjonggClass {
	GtkApplicationClass parent_class;
};

struct _MahjonggPrivate {
	GSettings* settings;
	GamesScores* highscores;
	GList* maps;
	GtkWindow* window;
	GameView* game_view;
	GtkToolItem* status_item;
	GtkUIManager* ui_manager;
	GtkToolbar* toolbar;
	GtkLabel* moves_label;
	GamesClock* game_clock;
	GtkDialog* preferences_dialog;
	GamesPauseAction* pause_action;
	GtkAction* hint_action;
	GtkAction* redo_action;
	GtkAction* undo_action;
	GtkAction* restart_action;
	GamesFullscreenAction* fullscreen_action;
	GamesFullscreenAction* leave_fullscreen_action;
};

struct _Map {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GTypeClass parent_class;
	void (*finalize) (Map *self);
};

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkRGBA background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _Match {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MatchPrivate * priv;
	Tile* tile0;
	Tile* tile1;
};

struct _MatchClass {
	GTypeClass parent_class;
	void (*finalize) (Match *self);
};

struct _MapLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapLoaderPrivate * priv;
	GList* maps;
};

struct _MapLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (MapLoader *self);
};


static gpointer mahjongg_parent_class = NULL;

GType mahjongg_get_type (void) G_GNUC_CONST;
gpointer map_ref (gpointer instance);
void map_unref (gpointer instance);
GParamSpec* param_spec_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_map (GValue* value, gpointer v_object);
void value_take_map (GValue* value, gpointer v_object);
gpointer value_get_map (const GValue* value);
GType map_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
#define MAHJONGG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAHJONGG, MahjonggPrivate))
enum  {
	MAHJONGG_DUMMY_PROPERTY
};
static void _map_unref0_ (gpointer var);
static void _g_list_free__map_unref0_ (GList* self);
static void mahjongg_new_game_cb (Mahjongg* self, GtkAction* action);
static void _mahjongg_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_restart_game_cb (Mahjongg* self, GtkAction* action);
static void _mahjongg_restart_game_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_undo_cb (Mahjongg* self);
static void _mahjongg_undo_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_redo_cb (Mahjongg* self, GtkAction* action);
static void _mahjongg_redo_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_hint_cb (Mahjongg* self);
static void _mahjongg_hint_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_scores_cb (Mahjongg* self, GtkAction* action);
static void _mahjongg_scores_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_quit_cb (Mahjongg* self);
static void _mahjongg_quit_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_properties_cb (Mahjongg* self);
static void _mahjongg_properties_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_help_cb (Mahjongg* self, GtkAction* action);
static void _mahjongg_help_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_about_cb (Mahjongg* self);
static void _mahjongg_about_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void mahjongg_show_toolbar_cb (Mahjongg* self, GtkAction* action);
static void _mahjongg_show_toolbar_cb_gtk_action_callback (GtkAction* action, gpointer self);
#define MAHJONGG_ui_description "<ui>" "  <menubar name='MainMenu'>" "    <menu action='GameMenu'>" "      <menuitem action='NewGame'/>" "      <menuitem action='RestartGame'/>" "      <menuitem action='PauseGame'/>" "      <separator/>" "      <menuitem action='UndoMove'/>" "      <menuitem action='RedoMove'/>" "      <menuitem action='Hint'/>" "      <separator/>" "      <menuitem action='Scores'/>" "      <separator/>" "      <menuitem action='Quit'/>" "    </menu>" "    <menu action='SettingsMenu'>" "      <menuitem action='Fullscreen'/>" "      <menuitem action='ShowToolbar'/>" "      <separator/>" "      <menuitem action='Preferences'/>" "    </menu>" "    <menu action='HelpMenu'>" "      <menuitem action='Contents'/>" "      <menuitem action='About'/>" "    </menu>" "  </menubar>" "  <toolbar name='Toolbar'>" "    <toolitem action='NewGame'/>" "    <toolitem action='UndoMove'/>" "    <toolitem action='Hint'/>" "    <toolitem action='PauseGame'/>" "    <toolitem action='LeaveFullscreen'/>" "  </toolbar>" "</ui>"
Mahjongg* mahjongg_new (void);
Mahjongg* mahjongg_construct (GType object_type);
static void mahjongg_load_maps (Mahjongg* self);
static void _vala_GamesScoresCategory_array_free (GamesScoresCategory* array, gint array_length);
gpointer slot_ref (gpointer instance);
void slot_unref (gpointer instance);
GParamSpec* param_spec_slot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_slot (GValue* value, gpointer v_object);
void value_take_slot (GValue* value, gpointer v_object);
gpointer value_get_slot (const GValue* value);
GType slot_get_type (void) G_GNUC_CONST;
static void mahjongg_create_menus (Mahjongg* self, GtkUIManager* ui_manager);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static gboolean mahjongg_view_button_press_event (Mahjongg* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mahjongg_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void mahjongg_conf_value_changed_cb (Mahjongg* self, GSettings* settings, const gchar* key);
static void _mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void mahjongg_new_game (Mahjongg* self);
static void mahjongg_real_activate (GApplication* base);
void mahjongg_start (Mahjongg* self);
static void mahjongg_update_ui (Mahjongg* self);
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
Game* game_view_get_game (GameView* self);
gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
gboolean game_view_get_paused (GameView* self);
guint game_get_moves_left (Game* self);
gboolean game_get_can_undo (Game* self);
gboolean game_get_can_redo (Game* self);
static void mahjongg_theme_changed_cb (Mahjongg* self, GtkComboBox* widget);
static GamesPreimage* mahjongg_load_theme_texture (Mahjongg* self, const gchar* filename, gboolean fail_on_error);
void game_view_set_theme (GameView* self, GamesPreimage* value);
GamesPreimage* game_view_get_theme (GameView* self);
void game_view_set_background (GameView* self, const gchar* colour);
gboolean game_get_started (Game* self);
static void mahjongg_background_changed_cb (Mahjongg* self, GtkColorButton* widget);
static void mahjongg_map_changed_cb (Mahjongg* self, GtkComboBox* widget);
static void mahjongg_moved_cb (Mahjongg* self);
gboolean game_get_complete (Game* self);
gboolean game_get_can_move (Game* self);
static void mahjongg_restart_game (Mahjongg* self);
static void mahjongg_preferences_dialog_response_cb (Mahjongg* self, GtkDialog* dialog, gint response);
static void _mahjongg_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static GList* mahjongg_load_themes (Mahjongg* self);
static void _mahjongg_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _mahjongg_map_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _mahjongg_background_changed_cb_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
gpointer match_ref (gpointer instance);
void match_unref (gpointer instance);
GParamSpec* param_spec_match (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_match (GValue* value, gpointer v_object);
void value_take_match (GValue* value, gpointer v_object);
gpointer value_get_match (const GValue* value);
GType match_get_type (void) G_GNUC_CONST;
GList* game_find_matches (Game* self, Tile* tile);
Tile* game_get_selected_tile (Game* self);
static void _match_unref0_ (gpointer var);
static void _g_list_free__match_unref0_ (GList* self);
void game_set_hint (Game* self, Tile* tile0, Tile* tile1);
static void mahjongg_pause_cb (Mahjongg* self, GamesPauseAction* action);
void game_view_set_paused (GameView* self, gboolean value);
void game_set_selected_tile (Game* self, Tile* value);
void game_reset (Game* self);
void game_redo (Game* self);
void game_undo (Game* self);
Game* game_new (Map* map);
Game* game_construct (GType object_type, Map* map);
void game_view_set_game (GameView* self, Game* value);
static void _mahjongg_moved_cb_game_moved (Game* _sender, gpointer self);
static void _mahjongg_pause_cb_games_pause_action_state_changed (GamesPauseAction* _sender, gpointer self);
Map* map_new_builtin (void);
Map* map_construct_builtin (GType object_type);
MapLoader* map_loader_new (void);
MapLoader* map_loader_construct (GType object_type);
gpointer map_loader_ref (gpointer instance);
void map_loader_unref (gpointer instance);
GParamSpec* param_spec_map_loader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_map_loader (GValue* value, gpointer v_object);
void value_take_map_loader (GValue* value, gpointer v_object);
gpointer value_get_map_loader (const GValue* value);
GType map_loader_get_type (void) G_GNUC_CONST;
void map_loader_load (MapLoader* self, const gchar* filename, GError** error);
gint mahjongg_main (gchar** args, int args_length1);
static void mahjongg_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAHJONGG_actions[13] = {{"GameMenu", NULL, "_Game"}, {"SettingsMenu", NULL, "_Settings"}, {"HelpMenu", NULL, "_Help"}, {"NewGame", GAMES_STOCK_NEW_GAME, NULL, NULL, "Start a new game", (GCallback) _mahjongg_new_game_cb_gtk_action_callback}, {"RestartGame", GAMES_STOCK_RESTART_GAME, NULL, NULL, "Restart the current game", (GCallback) _mahjongg_restart_game_cb_gtk_action_callback}, {"UndoMove", GAMES_STOCK_UNDO_MOVE, NULL, NULL, "Undo the last move", (GCallback) _mahjongg_undo_cb_gtk_action_callback}, {"RedoMove", GAMES_STOCK_REDO_MOVE, NULL, NULL, "Redo the last move", (GCallback) _mahjongg_redo_cb_gtk_action_callback}, {"Hint", GAMES_STOCK_HINT, NULL, NULL, "Show a hint", (GCallback) _mahjongg_hint_cb_gtk_action_callback}, {"Scores", GAMES_STOCK_SCORES, NULL, NULL, NULL, (GCallback) _mahjongg_scores_cb_gtk_action_callback}, {"Quit", GTK_STOCK_QUIT, NULL, NULL, NULL, (GCallback) _mahjongg_quit_cb_gtk_action_callback}, {"Preferences", GTK_STOCK_PREFERENCES, NULL, NULL, NULL, (GCallback) _mahjongg_properties_cb_gtk_action_callback}, {"Contents", GAMES_STOCK_CONTENTS, NULL, NULL, NULL, (GCallback) _mahjongg_help_cb_gtk_action_callback}, {"About", GTK_STOCK_ABOUT, NULL, NULL, NULL, (GCallback) _mahjongg_about_cb_gtk_action_callback}};
static const GtkToggleActionEntry MAHJONGG_toggle_actions[1] = {{"ShowToolbar", NULL, "_Toolbar", NULL, "Show or hide the toolbar", (GCallback) _mahjongg_show_toolbar_cb_gtk_action_callback}};

static void _map_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (map_unref (var), NULL));
}


static void _g_list_free__map_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _map_unref0_, NULL);
	g_list_free (self);
}


static void _mahjongg_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_new_game_cb (self, action);
}


static void _mahjongg_restart_game_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_restart_game_cb (self, action);
}


static void _mahjongg_undo_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_undo_cb (self);
}


static void _mahjongg_redo_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_redo_cb (self, action);
}


static void _mahjongg_hint_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_hint_cb (self);
}


static void _mahjongg_scores_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_scores_cb (self, action);
}


static void _mahjongg_quit_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_quit_cb (self);
}


static void _mahjongg_properties_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_properties_cb (self);
}


static void _mahjongg_help_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_help_cb (self, action);
}


static void _mahjongg_about_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_about_cb (self);
}


static void _mahjongg_show_toolbar_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	mahjongg_show_toolbar_cb (self, action);
}


static void _vala_GamesScoresCategory_array_free (GamesScoresCategory* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			 (&array[i]);
		}
	}
	g_free (array);
}


static gpointer _map_ref0 (gpointer self) {
	return self ? map_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _mahjongg_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mahjongg_view_button_press_event (self, _sender, event);
	return result;
}


static void _mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	mahjongg_conf_value_changed_cb (self, _sender, key);
}


Mahjongg* mahjongg_construct (GType object_type) {
	Mahjongg * self = NULL;
	GSettings* _tmp0_;
	GamesScoresCategory* _tmp1_ = NULL;
	GamesScoresCategory* _tmp2_;
	gint _tmp2__length1;
	GamesScores* _tmp3_;
	GList* _tmp4_;
	GtkWindow* _tmp14_;
	GtkWindow* _tmp15_;
	GtkWindow* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GtkWindow* _tmp18_;
	GtkWindow* _tmp19_;
	GtkWindow* _tmp20_;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkBox* status_box;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkBox* group_box;
	const gchar* _tmp25_ = NULL;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* label;
	GtkBox* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* spacer;
	GtkBox* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkBox* _tmp35_;
	GtkLabel* _tmp36_;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	const gchar* _tmp40_ = NULL;
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	GtkLabel* game_clock_label;
	GtkBox* _tmp43_;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GtkBox* _tmp46_;
	GtkLabel* _tmp47_;
	GamesClock* _tmp48_;
	GamesClock* _tmp49_;
	GtkBox* _tmp50_;
	GamesClock* _tmp51_;
	GtkBox* _tmp52_;
	GtkBox* _tmp53_;
	GtkBox* _tmp54_;
	GtkBox* vbox;
	GtkUIManager* _tmp55_;
	GtkUIManager* _tmp56_;
	GtkWindow* _tmp57_;
	GtkUIManager* _tmp58_;
	GtkAccelGroup* _tmp59_ = NULL;
	GtkUIManager* _tmp60_;
	GtkWidget* _tmp61_ = NULL;
	GtkWidget* _tmp62_;
	GtkWidget* box;
	GameView* _tmp63_;
	GameView* _tmp64_;
	GameView* _tmp65_;
	GameView* _tmp66_;
	GtkUIManager* _tmp67_;
	GtkWidget* _tmp68_ = NULL;
	GtkToolbar* _tmp69_;
	GtkToolbar* _tmp70_;
	GtkToolbar* _tmp71_;
	GtkStyleContext* _tmp72_ = NULL;
	GtkAlignment* _tmp73_;
	GtkAlignment* _tmp74_;
	GtkAlignment* status_alignment;
	GtkToolItem* _tmp75_;
	GtkToolItem* _tmp76_;
	GtkToolItem* _tmp77_;
	GtkToolItem* _tmp78_;
	GtkToolbar* _tmp79_;
	GtkToolItem* _tmp80_;
	GtkToolbar* _tmp81_;
	GameView* _tmp82_;
	GtkWindow* _tmp83_;
	GSettings* _tmp84_;
	GameView* _tmp85_;
	self = (Mahjongg*) g_object_new (object_type, "application-id", "org.gnome.mahjongg", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	_tmp0_ = g_settings_new ("org.gnome.mahjongg");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	mahjongg_load_maps (self);
	_tmp1_ = g_new0 (GamesScoresCategory, 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 0;
	_tmp3_ = games_scores_new ("mahjongg", _tmp2_, 0, NULL, NULL, 0, GAMES_SCORES_STYLE_TIME_ASCENDING);
	_g_object_unref0 (self->priv->highscores);
	self->priv->highscores = _tmp3_;
	_tmp2_ = (_vala_GamesScoresCategory_array_free (_tmp2_, _tmp2__length1), NULL);
	_tmp4_ = self->priv->maps;
	{
		GList* map_collection = NULL;
		GList* map_it = NULL;
		map_collection = _tmp4_;
		for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
			Map* _tmp5_;
			Map* map = NULL;
			_tmp5_ = _map_ref0 ((Map*) map_it->data);
			map = _tmp5_;
			{
				Map* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* display_name;
				GamesScores* _tmp10_;
				Map* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp6_ = map;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = g_dpgettext2 (NULL, "mahjongg map name", _tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				display_name = _tmp9_;
				_tmp10_ = self->priv->highscores;
				_tmp11_ = map;
				_tmp12_ = _tmp11_->score_name;
				_tmp13_ = display_name;
				games_scores_add_category (_tmp10_, _tmp12_, _tmp13_);
				_g_free0 (display_name);
				_map_unref0 (map);
			}
		}
	}
	_tmp14_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	_tmp15_ = g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp15_;
	_tmp16_ = self->priv->window;
	_tmp17_ = _ ("Mahjongg");
	gtk_window_set_title (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->window;
	gtk_window_set_default_size (_tmp18_, 530, 440);
	_tmp19_ = self->priv->window;
	games_settings_bind_window_state ("/org/gnome/mahjongg/", _tmp19_);
	_tmp20_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp20_);
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	_tmp22_ = g_object_ref_sink (_tmp21_);
	status_box = _tmp22_;
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp24_ = g_object_ref_sink (_tmp23_);
	group_box = _tmp24_;
	_tmp25_ = _ ("Moves Left:");
	_tmp26_ = (GtkLabel*) gtk_label_new (_tmp25_);
	_tmp27_ = g_object_ref_sink (_tmp26_);
	label = _tmp27_;
	_tmp28_ = group_box;
	gtk_box_pack_start (_tmp28_, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp29_ = (GtkLabel*) gtk_label_new (" ");
	_tmp30_ = g_object_ref_sink (_tmp29_);
	spacer = _tmp30_;
	_tmp31_ = group_box;
	_tmp32_ = spacer;
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
	_tmp33_ = (GtkLabel*) gtk_label_new ("");
	_tmp34_ = g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->moves_label);
	self->priv->moves_label = _tmp34_;
	_tmp35_ = group_box;
	_tmp36_ = self->priv->moves_label;
	gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
	_tmp37_ = group_box;
	gtk_box_pack_start (status_box, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 0);
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp39_ = g_object_ref_sink (_tmp38_);
	_g_object_unref0 (group_box);
	group_box = _tmp39_;
	_tmp40_ = _ ("Time:");
	_tmp41_ = (GtkLabel*) gtk_label_new (_tmp40_);
	_tmp42_ = g_object_ref_sink (_tmp41_);
	game_clock_label = _tmp42_;
	_tmp43_ = group_box;
	gtk_box_pack_start (_tmp43_, (GtkWidget*) game_clock_label, FALSE, FALSE, (guint) 0);
	_tmp44_ = (GtkLabel*) gtk_label_new (" ");
	_tmp45_ = g_object_ref_sink (_tmp44_);
	_g_object_unref0 (spacer);
	spacer = _tmp45_;
	_tmp46_ = group_box;
	_tmp47_ = spacer;
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 0);
	_tmp48_ = games_clock_new ();
	_tmp49_ = g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->game_clock);
	self->priv->game_clock = _tmp49_;
	_tmp50_ = group_box;
	_tmp51_ = self->priv->game_clock;
	gtk_box_pack_start (_tmp50_, (GtkWidget*) _tmp51_, FALSE, FALSE, (guint) 0);
	_tmp52_ = group_box;
	gtk_box_pack_start (status_box, (GtkWidget*) _tmp52_, FALSE, FALSE, (guint) 0);
	_tmp53_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	_tmp54_ = g_object_ref_sink (_tmp53_);
	vbox = _tmp54_;
	_tmp55_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui_manager);
	self->priv->ui_manager = _tmp55_;
	_tmp56_ = self->priv->ui_manager;
	mahjongg_create_menus (self, _tmp56_);
	_tmp57_ = self->priv->window;
	_tmp58_ = self->priv->ui_manager;
	_tmp59_ = gtk_ui_manager_get_accel_group (_tmp58_);
	gtk_window_add_accel_group (_tmp57_, _tmp59_);
	_tmp60_ = self->priv->ui_manager;
	_tmp61_ = gtk_ui_manager_get_widget (_tmp60_, "/MainMenu");
	_tmp62_ = _g_object_ref0 (_tmp61_);
	box = _tmp62_;
	_tmp63_ = game_view_new ();
	_tmp64_ = g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->game_view);
	self->priv->game_view = _tmp64_;
	_tmp65_ = self->priv->game_view;
	g_signal_connect_object ((GtkWidget*) _tmp65_, "button-press-event", (GCallback) _mahjongg_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp66_ = self->priv->game_view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp66_, 600, 400);
	_tmp67_ = self->priv->ui_manager;
	_tmp68_ = gtk_ui_manager_get_widget (_tmp67_, "/Toolbar");
	_tmp69_ = _g_object_ref0 (GTK_TOOLBAR (_tmp68_));
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp69_;
	_tmp70_ = self->priv->toolbar;
	gtk_toolbar_set_show_arrow (_tmp70_, FALSE);
	_tmp71_ = self->priv->toolbar;
	_tmp72_ = gtk_widget_get_style_context ((GtkWidget*) _tmp71_);
	gtk_style_context_add_class (_tmp72_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp73_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	_tmp74_ = g_object_ref_sink (_tmp73_);
	status_alignment = _tmp74_;
	gtk_container_add ((GtkContainer*) status_alignment, (GtkWidget*) status_box);
	_tmp75_ = gtk_tool_item_new ();
	_tmp76_ = g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->status_item);
	self->priv->status_item = _tmp76_;
	_tmp77_ = self->priv->status_item;
	gtk_tool_item_set_expand (_tmp77_, TRUE);
	_tmp78_ = self->priv->status_item;
	gtk_container_add ((GtkContainer*) _tmp78_, (GtkWidget*) status_alignment);
	_tmp79_ = self->priv->toolbar;
	_tmp80_ = self->priv->status_item;
	gtk_toolbar_insert (_tmp79_, _tmp80_, -1);
	gtk_box_pack_start (vbox, box, FALSE, FALSE, (guint) 0);
	_tmp81_ = self->priv->toolbar;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp81_, FALSE, FALSE, (guint) 0);
	_tmp82_ = self->priv->game_view;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp82_, TRUE, TRUE, (guint) 0);
	_tmp83_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp83_, (GtkWidget*) vbox);
	_tmp84_ = self->priv->settings;
	g_signal_connect_object (_tmp84_, "changed", (GCallback) _mahjongg_conf_value_changed_cb_g_settings_changed, self, 0);
	mahjongg_new_game (self);
	_tmp85_ = self->priv->game_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp85_);
	_g_object_unref0 (status_alignment);
	_g_object_unref0 (box);
	_g_object_unref0 (vbox);
	_g_object_unref0 (game_clock_label);
	_g_object_unref0 (spacer);
	_g_object_unref0 (label);
	_g_object_unref0 (group_box);
	_g_object_unref0 (status_box);
	return self;
}


Mahjongg* mahjongg_new (void) {
	return mahjongg_construct (TYPE_MAHJONGG);
}


static void mahjongg_real_activate (GApplication* base) {
	Mahjongg * self;
	GtkWindow* _tmp0_;
	self = (Mahjongg*) base;
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


void mahjongg_start (Mahjongg* self) {
	GtkWindow* _tmp0_;
	GamesFullscreenAction* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->leave_fullscreen_action;
	games_fullscreen_action_set_visible_policy (_tmp1_, GAMES_FULLSCREEN_ACTION_VISIBLE_ON_FULLSCREEN);
	_tmp2_ = self->priv->settings;
	mahjongg_conf_value_changed_cb (self, _tmp2_, "tileset");
	_tmp3_ = self->priv->settings;
	mahjongg_conf_value_changed_cb (self, _tmp3_, "bgcolour");
	_tmp4_ = self->priv->settings;
	mahjongg_conf_value_changed_cb (self, _tmp4_, "show-toolbar");
}


static void mahjongg_update_ui (Mahjongg* self) {
	GamesPauseAction* _tmp0_;
	GameView* _tmp1_;
	Game* _tmp2_;
	Game* _tmp3_;
	gint _tmp4_;
	GtkAction* _tmp5_;
	GameView* _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	gint _tmp9_;
	GameView* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GtkLabel* _tmp34_;
	GameView* _tmp35_;
	Game* _tmp36_;
	Game* _tmp37_;
	guint _tmp38_;
	guint _tmp39_;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pause_action;
	_tmp1_ = self->priv->game_view;
	_tmp2_ = game_view_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->move_number;
	gtk_action_set_sensitive ((GtkAction*) _tmp0_, _tmp4_ > 1);
	_tmp5_ = self->priv->restart_action;
	_tmp6_ = self->priv->game_view;
	_tmp7_ = game_view_get_game (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_->move_number;
	gtk_action_set_sensitive (_tmp5_, _tmp9_ > 1);
	_tmp10_ = self->priv->game_view;
	_tmp11_ = game_view_get_paused (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		GtkAction* _tmp13_;
		GtkAction* _tmp14_;
		GtkAction* _tmp15_;
		_tmp13_ = self->priv->hint_action;
		gtk_action_set_sensitive (_tmp13_, FALSE);
		_tmp14_ = self->priv->undo_action;
		gtk_action_set_sensitive (_tmp14_, FALSE);
		_tmp15_ = self->priv->redo_action;
		gtk_action_set_sensitive (_tmp15_, FALSE);
	} else {
		GtkAction* _tmp16_;
		GameView* _tmp17_;
		Game* _tmp18_;
		Game* _tmp19_;
		guint _tmp20_;
		guint _tmp21_;
		GtkAction* _tmp22_;
		GameView* _tmp23_;
		Game* _tmp24_;
		Game* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		GtkAction* _tmp28_;
		GameView* _tmp29_;
		Game* _tmp30_;
		Game* _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp33_;
		_tmp16_ = self->priv->hint_action;
		_tmp17_ = self->priv->game_view;
		_tmp18_ = game_view_get_game (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = game_get_moves_left (_tmp19_);
		_tmp21_ = _tmp20_;
		gtk_action_set_sensitive (_tmp16_, _tmp21_ > ((guint) 0));
		_tmp22_ = self->priv->undo_action;
		_tmp23_ = self->priv->game_view;
		_tmp24_ = game_view_get_game (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = game_get_can_undo (_tmp25_);
		_tmp27_ = _tmp26_;
		gtk_action_set_sensitive (_tmp22_, _tmp27_);
		_tmp28_ = self->priv->redo_action;
		_tmp29_ = self->priv->game_view;
		_tmp30_ = game_view_get_game (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = game_get_can_redo (_tmp31_);
		_tmp33_ = _tmp32_;
		gtk_action_set_sensitive (_tmp28_, _tmp33_);
	}
	_tmp34_ = self->priv->moves_label;
	_tmp35_ = self->priv->game_view;
	_tmp36_ = game_view_get_game (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = game_get_moves_left (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strdup_printf ("%2u", _tmp39_);
	_tmp41_ = _tmp40_;
	gtk_label_set_text (_tmp34_, _tmp41_);
	_g_free0 (_tmp41_);
}


static void mahjongg_theme_changed_cb (Mahjongg* self, GtkComboBox* widget) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gchar* theme = NULL;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &theme, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_string (_tmp6_, "tileset", theme);
	_g_free0 (theme);
}


static void mahjongg_conf_value_changed_cb (Mahjongg* self, GSettings* settings, const gchar* key) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "tileset") == 0) {
		GSettings* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* theme;
		GameView* _tmp3_;
		const gchar* _tmp4_;
		GamesPreimage* _tmp5_ = NULL;
		GamesPreimage* _tmp6_;
		GameView* _tmp7_;
		GamesPreimage* _tmp8_;
		GamesPreimage* _tmp9_;
		_tmp1_ = settings;
		_tmp2_ = g_settings_get_string (_tmp1_, "tileset");
		theme = _tmp2_;
		_tmp3_ = self->priv->game_view;
		_tmp4_ = theme;
		_tmp5_ = mahjongg_load_theme_texture (self, _tmp4_, FALSE);
		_tmp6_ = _tmp5_;
		game_view_set_theme (_tmp3_, _tmp6_);
		_g_object_unref0 (_tmp6_);
		_tmp7_ = self->priv->game_view;
		_tmp8_ = game_view_get_theme (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == NULL) {
			const gchar* _tmp10_;
			GameView* _tmp11_;
			GamesPreimage* _tmp12_ = NULL;
			GamesPreimage* _tmp13_;
			_tmp10_ = theme;
			g_warning ("mahjongg.vala:161: Unable to load theme %s, falling back to default", _tmp10_);
			_tmp11_ = self->priv->game_view;
			_tmp12_ = mahjongg_load_theme_texture (self, "postmodern.svg", TRUE);
			_tmp13_ = _tmp12_;
			game_view_set_theme (_tmp11_, _tmp13_);
			_g_object_unref0 (_tmp13_);
		}
		_g_free0 (theme);
	} else {
		const gchar* _tmp14_;
		_tmp14_ = key;
		if (g_strcmp0 (_tmp14_, "show-toolbar") == 0) {
			GtkToolbar* _tmp15_;
			GSettings* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp15_ = self->priv->toolbar;
			_tmp16_ = settings;
			_tmp17_ = g_settings_get_boolean (_tmp16_, "show-toolbar");
			gtk_widget_set_visible ((GtkWidget*) _tmp15_, _tmp17_);
		} else {
			const gchar* _tmp18_;
			_tmp18_ = key;
			if (g_strcmp0 (_tmp18_, "bgcolour") == 0) {
				GameView* _tmp19_;
				GSettings* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				_tmp19_ = self->priv->game_view;
				_tmp20_ = settings;
				_tmp21_ = g_settings_get_string (_tmp20_, "bgcolour");
				_tmp22_ = _tmp21_;
				game_view_set_background (_tmp19_, _tmp22_);
				_g_free0 (_tmp22_);
			} else {
				const gchar* _tmp23_;
				_tmp23_ = key;
				if (g_strcmp0 (_tmp23_, "mapset") == 0) {
					GameView* _tmp24_;
					Game* _tmp25_;
					Game* _tmp26_;
					gboolean _tmp27_;
					gboolean _tmp28_;
					_tmp24_ = self->priv->game_view;
					_tmp25_ = game_view_get_game (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = game_get_started (_tmp26_);
					_tmp28_ = _tmp27_;
					if (_tmp28_) {
						GtkWindow* _tmp29_;
						const gchar* _tmp30_ = NULL;
						GtkMessageDialog* _tmp31_;
						GtkMessageDialog* _tmp32_;
						GtkMessageDialog* dialog;
						GtkMessageDialog* _tmp33_;
						const gchar* _tmp34_ = NULL;
						GtkMessageDialog* _tmp35_;
						const gchar* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
						GtkMessageDialog* _tmp38_;
						GtkMessageDialog* _tmp39_;
						gint _tmp40_ = 0;
						gint response;
						gint _tmp41_;
						GtkMessageDialog* _tmp42_;
						_tmp29_ = self->priv->window;
						_tmp30_ = _ ("Do you want to start a new game with this map?");
						_tmp31_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp29_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp30_);
						_tmp32_ = g_object_ref_sink (_tmp31_);
						dialog = _tmp32_;
						_tmp33_ = dialog;
						_tmp34_ = _ ("If you continue playing the next game will use the new map.");
						gtk_message_dialog_format_secondary_text (_tmp33_, "%s", _tmp34_);
						_tmp35_ = dialog;
						_tmp36_ = _ ("_Continue playing");
						_tmp37_ = _ ("Use _new map");
						gtk_dialog_add_buttons ((GtkDialog*) _tmp35_, _tmp36_, GTK_RESPONSE_REJECT, _tmp37_, GTK_RESPONSE_ACCEPT, NULL, NULL);
						_tmp38_ = dialog;
						gtk_dialog_set_default_response ((GtkDialog*) _tmp38_, (gint) GTK_RESPONSE_ACCEPT);
						_tmp39_ = dialog;
						_tmp40_ = gtk_dialog_run ((GtkDialog*) _tmp39_);
						response = _tmp40_;
						_tmp41_ = response;
						if (_tmp41_ == ((gint) GTK_RESPONSE_ACCEPT)) {
							mahjongg_new_game (self);
						}
						_tmp42_ = dialog;
						gtk_widget_destroy ((GtkWidget*) _tmp42_);
						_g_object_unref0 (dialog);
					} else {
						mahjongg_new_game (self);
					}
				}
			}
		}
	}
}


static GamesPreimage* mahjongg_load_theme_texture (Mahjongg* self, const gchar* filename, gboolean fail_on_error) {
	GamesPreimage* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp0_, NULL);
	path = _tmp1_;
	{
		GamesPreimage* _tmp2_;
		GamesPreimage* _tmp3_;
		_tmp2_ = games_preimage_new_from_file (path, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		result = _tmp3_;
		_g_free0 (path);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = filename;
		g_warning ("mahjongg.vala:207: Failed to load theme %s: %s", _tmp4_, path);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		return result;
	}
	__finally0:
	_g_free0 (path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gboolean mahjongg_view_button_press_event (Mahjongg* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GamesPauseAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->pause_action;
	_tmp1_ = games_pause_action_get_is_paused (_tmp0_);
	if (_tmp1_) {
		GamesPauseAction* _tmp2_;
		_tmp2_ = self->priv->pause_action;
		games_pause_action_set_is_paused (_tmp2_, FALSE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void mahjongg_show_toolbar_cb (Mahjongg* self, GtkAction* action) {
	GtkAction* _tmp0_;
	GtkToggleAction* _tmp1_;
	GtkToggleAction* toggle_action;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp0_));
	toggle_action = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = gtk_toggle_action_get_active (toggle_action);
	_tmp4_ = _tmp3_;
	g_settings_set_boolean (_tmp2_, "show-toolbar", _tmp4_);
	_g_object_unref0 (toggle_action);
}


static void mahjongg_background_changed_cb (Mahjongg* self, GtkColorButton* widget) {
	GdkRGBA colour = {0};
	GtkColorButton* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GSettings* _tmp2_;
	GdkRGBA _tmp3_;
	gdouble _tmp4_;
	GdkRGBA _tmp5_;
	gdouble _tmp6_;
	GdkRGBA _tmp7_;
	gdouble _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_color_button_get_rgba (_tmp0_, &_tmp1_);
	colour = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = colour;
	_tmp4_ = _tmp3_.red;
	_tmp5_ = colour;
	_tmp6_ = _tmp5_.green;
	_tmp7_ = colour;
	_tmp8_ = _tmp7_.blue;
	_tmp9_ = g_strdup_printf ("#%04x%04x%04x", (guint) ((gint) ((_tmp4_ * 65536) + 0.5)), (guint) ((gint) ((_tmp6_ * 65536) + 0.5)), (guint) ((gint) ((_tmp8_ * 65536) + 0.5)));
	_tmp10_ = _tmp9_;
	g_settings_set_string (_tmp2_, "bgcolour", _tmp10_);
	_g_free0 (_tmp10_);
}


static void mahjongg_map_changed_cb (Mahjongg* self, GtkComboBox* widget) {
	GSettings* _tmp0_;
	GList* _tmp1_;
	GtkComboBox* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->maps;
	_tmp2_ = widget;
	_tmp3_ = gtk_combo_box_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_list_nth_data (_tmp1_, (guint) _tmp4_);
	_tmp6_ = ((Map*) _tmp5_)->name;
	g_settings_set_string (_tmp0_, "mapset", _tmp6_);
}


static void mahjongg_moved_cb (Mahjongg* self) {
	GamesClock* _tmp0_;
	time_t _tmp1_ = 0;
	GameView* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_clock;
	_tmp1_ = games_clock_get_seconds (_tmp0_);
	if (_tmp1_ == ((time_t) 0)) {
		GamesClock* _tmp2_;
		_tmp2_ = self->priv->game_clock;
		games_clock_start (_tmp2_);
	}
	mahjongg_update_ui (self);
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_complete (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GamesClock* _tmp8_;
		GamesClock* _tmp9_;
		time_t _tmp10_ = 0;
		time_t seconds;
		GamesScores* _tmp11_;
		time_t _tmp12_;
		time_t _tmp13_;
		gint _tmp14_ = 0;
		gint p;
		GtkWindow* _tmp15_;
		GamesScores* _tmp16_;
		const gchar* _tmp17_ = NULL;
		GamesScoresDialog* _tmp18_;
		GamesScoresDialog* _tmp19_;
		GamesScoresDialog* scores_dialog;
		GamesScoresDialog* _tmp20_;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* title;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		gchar* message;
		gint _tmp26_;
		GamesScoresDialog* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GamesScoresDialog* _tmp37_;
		gint _tmp38_;
		GamesScoresDialog* _tmp41_;
		gint _tmp42_ = 0;
		GamesScoresDialog* _tmp44_;
		_tmp8_ = self->priv->game_clock;
		games_clock_stop (_tmp8_);
		_tmp9_ = self->priv->game_clock;
		_tmp10_ = games_clock_get_seconds (_tmp9_);
		seconds = _tmp10_;
		_tmp11_ = self->priv->highscores;
		_tmp12_ = seconds;
		_tmp13_ = seconds;
		_tmp14_ = games_scores_add_time_score (_tmp11_, ((_tmp12_ / 60) * 1.0) + ((_tmp13_ % 60) / 100.0));
		p = _tmp14_;
		_tmp15_ = self->priv->window;
		_tmp16_ = self->priv->highscores;
		_tmp17_ = _ ("Mahjongg Scores");
		_tmp18_ = games_scores_dialog_new (_tmp15_, _tmp16_, _tmp17_);
		_tmp19_ = g_object_ref_sink (_tmp18_);
		scores_dialog = _tmp19_;
		_tmp20_ = scores_dialog;
		_tmp21_ = _ ("Map:");
		games_scores_dialog_set_category_description (_tmp20_, _tmp21_);
		_tmp22_ = _ ("Puzzle solved!");
		_tmp23_ = g_strdup (_tmp22_);
		title = _tmp23_;
		_tmp24_ = _ ("You didn't make the top ten, better luck next time.");
		_tmp25_ = g_strdup (_tmp24_);
		message = _tmp25_;
		_tmp26_ = p;
		if (_tmp26_ == 1) {
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			_tmp27_ = _ ("Your score is the best!");
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (message);
			message = _tmp28_;
		} else {
			gint _tmp29_;
			_tmp29_ = p;
			if (_tmp29_ > 1) {
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				_tmp30_ = _ ("Your score has made the top ten.");
				_tmp31_ = g_strdup (_tmp30_);
				_g_free0 (message);
				message = _tmp31_;
			}
		}
		_tmp32_ = scores_dialog;
		_tmp33_ = title;
		_tmp34_ = message;
		_tmp35_ = g_strdup_printf ("<b>%s</b>\n\n%s", _tmp33_, _tmp34_);
		_tmp36_ = _tmp35_;
		games_scores_dialog_set_message (_tmp32_, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = scores_dialog;
		games_scores_dialog_set_buttons (_tmp37_, (guint) (GAMES_SCORES_QUIT_BUTTON | GAMES_SCORES_NEW_GAME_BUTTON));
		_tmp38_ = p;
		if (_tmp38_ > 0) {
			GamesScoresDialog* _tmp39_;
			gint _tmp40_;
			_tmp39_ = scores_dialog;
			_tmp40_ = p;
			games_scores_dialog_set_hilight (_tmp39_, (guint) _tmp40_);
		}
		_tmp41_ = scores_dialog;
		_tmp42_ = gtk_dialog_run ((GtkDialog*) _tmp41_);
		switch (_tmp42_) {
			case GTK_RESPONSE_REJECT:
			{
				GtkWindow* _tmp43_;
				_tmp43_ = self->priv->window;
				gtk_widget_destroy ((GtkWidget*) _tmp43_);
				break;
			}
			default:
			{
				mahjongg_new_game (self);
				break;
			}
		}
		_tmp44_ = scores_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp44_);
		_g_free0 (message);
		_g_free0 (title);
		_g_object_unref0 (scores_dialog);
	} else {
		GameView* _tmp45_;
		Game* _tmp46_;
		Game* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp45_ = self->priv->game_view;
		_tmp46_ = game_view_get_game (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = game_get_can_move (_tmp47_);
		_tmp49_ = _tmp48_;
		if (!_tmp49_) {
			GtkWindow* _tmp50_;
			const gchar* _tmp51_ = NULL;
			GtkMessageDialog* _tmp52_;
			GtkMessageDialog* _tmp53_;
			GtkMessageDialog* dialog;
			GtkMessageDialog* _tmp54_;
			const gchar* _tmp55_ = NULL;
			GtkMessageDialog* _tmp56_;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GtkMessageDialog* _tmp59_;
			GtkMessageDialog* _tmp60_;
			gint _tmp61_ = 0;
			GtkMessageDialog* _tmp62_;
			_tmp50_ = self->priv->window;
			_tmp51_ = _ ("There are no more moves.");
			_tmp52_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp50_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", _tmp51_);
			_tmp53_ = g_object_ref_sink (_tmp52_);
			dialog = _tmp53_;
			_tmp54_ = dialog;
			_tmp55_ = _ ("Each puzzle has at least one solution.  You can undo your moves and tr" \
"y and find the solution for a time penalty, restart this game or start" \
" an new one.");
			gtk_message_dialog_format_secondary_text (_tmp54_, "%s", _tmp55_);
			_tmp56_ = dialog;
			_tmp57_ = _ ("_Restart");
			_tmp58_ = _ ("_New game");
			gtk_dialog_add_buttons ((GtkDialog*) _tmp56_, GTK_STOCK_UNDO, GTK_RESPONSE_REJECT, _tmp57_, GTK_RESPONSE_CANCEL, _tmp58_, GTK_RESPONSE_ACCEPT, NULL);
			_tmp59_ = dialog;
			gtk_dialog_set_default_response ((GtkDialog*) _tmp59_, (gint) GTK_RESPONSE_ACCEPT);
			_tmp60_ = dialog;
			_tmp61_ = gtk_dialog_run ((GtkDialog*) _tmp60_);
			switch (_tmp61_) {
				case GTK_RESPONSE_REJECT:
				{
					mahjongg_undo_cb (self);
					break;
				}
				case GTK_RESPONSE_CANCEL:
				{
					mahjongg_restart_game (self);
					break;
				}
				default:
				case GTK_RESPONSE_ACCEPT:
				{
					mahjongg_new_game (self);
					break;
				}
			}
			_tmp62_ = dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp62_);
			_g_object_unref0 (dialog);
		}
	}
}


static void _mahjongg_preferences_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	mahjongg_preferences_dialog_response_cb (self, _sender, response_id);
}


static void _mahjongg_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	mahjongg_theme_changed_cb (self, _sender);
}


static void _mahjongg_map_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	mahjongg_map_changed_cb (self, _sender);
}


static void _mahjongg_background_changed_cb_gtk_color_button_color_set (GtkColorButton* _sender, gpointer self) {
	mahjongg_background_changed_cb (self, _sender);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void mahjongg_properties_cb (Mahjongg* self) {
	GtkDialog* _tmp0_;
	const gchar* _tmp2_ = NULL;
	GtkWindow* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkBox* _tmp8_ = NULL;
	GtkBox* _tmp9_;
	GtkBox* dialog_content_area;
	GtkBox* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkDialog* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	GtkGrid* top_grid;
	GtkGrid* _tmp16_;
	GtkGrid* _tmp17_;
	GtkGrid* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GamesFrame* _tmp20_;
	GamesFrame* _tmp21_;
	GamesFrame* frame;
	GtkGrid* _tmp22_;
	GamesFrame* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	GtkGrid* grid;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	const gchar* _tmp28_ = NULL;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* label;
	GtkLabel* _tmp31_;
	GtkGrid* _tmp32_;
	GtkLabel* _tmp33_;
	GList* _tmp34_ = NULL;
	GList* themes;
	GtkComboBox* _tmp35_;
	GtkComboBox* _tmp36_;
	GtkComboBox* theme_combo;
	GtkListStore* _tmp37_;
	GtkListStore* theme_store;
	GtkComboBox* _tmp38_;
	GtkListStore* _tmp39_;
	GtkCellRendererText* _tmp40_;
	GtkCellRendererText* _tmp41_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp42_;
	GtkCellRendererText* _tmp43_;
	GtkComboBox* _tmp44_;
	GtkCellRendererText* _tmp45_;
	GList* _tmp46_;
	GtkComboBox* _tmp67_;
	GtkComboBox* _tmp68_;
	GtkGrid* _tmp69_;
	GtkComboBox* _tmp70_;
	GtkLabel* _tmp71_;
	GtkComboBox* _tmp72_;
	GamesFrame* _tmp73_;
	GtkGrid* _tmp74_;
	const gchar* _tmp75_ = NULL;
	GamesFrame* _tmp76_;
	GamesFrame* _tmp77_;
	GtkGrid* _tmp78_;
	GamesFrame* _tmp79_;
	GtkGrid* _tmp80_;
	GtkGrid* _tmp81_;
	GtkGrid* _tmp82_;
	GtkGrid* _tmp83_;
	const gchar* _tmp84_ = NULL;
	GtkLabel* _tmp85_;
	GtkLabel* _tmp86_;
	GtkLabel* _tmp87_;
	GtkGrid* _tmp88_;
	GtkLabel* _tmp89_;
	GtkComboBox* _tmp90_;
	GtkComboBox* _tmp91_;
	GtkComboBox* map_combo;
	GtkListStore* _tmp92_;
	GtkListStore* map_store;
	GtkComboBox* _tmp93_;
	GtkListStore* _tmp94_;
	GtkCellRendererText* _tmp95_;
	GtkCellRendererText* _tmp96_;
	GtkComboBox* _tmp97_;
	GtkCellRendererText* _tmp98_;
	GtkComboBox* _tmp99_;
	GtkCellRendererText* _tmp100_;
	GList* _tmp101_;
	GtkComboBox* _tmp121_;
	GtkComboBox* _tmp122_;
	GtkGrid* _tmp123_;
	GtkComboBox* _tmp124_;
	GtkLabel* _tmp125_;
	GtkComboBox* _tmp126_;
	GamesFrame* _tmp127_;
	GtkGrid* _tmp128_;
	const gchar* _tmp129_ = NULL;
	GamesFrame* _tmp130_;
	GamesFrame* _tmp131_;
	GtkGrid* _tmp132_;
	GamesFrame* _tmp133_;
	GtkGrid* _tmp134_;
	GtkGrid* _tmp135_;
	GtkGrid* _tmp136_;
	GtkGrid* _tmp137_;
	const gchar* _tmp138_ = NULL;
	GtkLabel* _tmp139_;
	GtkLabel* _tmp140_;
	GtkLabel* _tmp141_;
	GtkGrid* _tmp142_;
	GtkLabel* _tmp143_;
	GtkColorButton* _tmp144_;
	GtkColorButton* _tmp145_;
	GtkColorButton* widget;
	GtkColorButton* _tmp146_;
	GameView* _tmp147_;
	GdkRGBA _tmp148_;
	GtkColorButton* _tmp149_;
	GtkColorButton* _tmp150_;
	GtkGrid* _tmp151_;
	GtkColorButton* _tmp152_;
	GtkLabel* _tmp153_;
	GtkColorButton* _tmp154_;
	GamesFrame* _tmp155_;
	GtkGrid* _tmp156_;
	GtkBox* _tmp157_;
	GtkGrid* _tmp158_;
	GtkDialog* _tmp159_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		GtkDialog* _tmp1_;
		_tmp1_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = _ ("Mahjongg Preferences");
	_tmp3_ = self->priv->window;
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp2_, _tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp5_;
	_tmp6_ = self->priv->preferences_dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp6_, (guint) 5);
	_tmp7_ = self->priv->preferences_dialog;
	_tmp8_ = gtk_dialog_get_content_area (_tmp7_);
	_tmp9_ = _g_object_ref0 (GTK_BOX (_tmp8_));
	dialog_content_area = _tmp9_;
	_tmp10_ = dialog_content_area;
	gtk_box_set_spacing (_tmp10_, 2);
	_tmp11_ = self->priv->preferences_dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp11_, FALSE);
	_tmp12_ = self->priv->preferences_dialog;
	gtk_dialog_set_default_response (_tmp12_, (gint) GTK_RESPONSE_CLOSE);
	_tmp13_ = self->priv->preferences_dialog;
	g_signal_connect_object (_tmp13_, "response", (GCallback) _mahjongg_preferences_dialog_response_cb_gtk_dialog_response, self, 0);
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
	_tmp15_ = g_object_ref_sink (_tmp14_);
	top_grid = _tmp15_;
	_tmp16_ = top_grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp16_, (guint) 5);
	_tmp17_ = top_grid;
	gtk_grid_set_row_spacing (_tmp17_, (guint) 18);
	_tmp18_ = top_grid;
	gtk_grid_set_column_spacing (_tmp18_, (guint) 0);
	_tmp19_ = _ ("Tiles");
	_tmp20_ = games_frame_new (_tmp19_);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	frame = _tmp21_;
	_tmp22_ = top_grid;
	_tmp23_ = frame;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 0, 1, 1);
	_tmp24_ = (GtkGrid*) gtk_grid_new ();
	_tmp25_ = g_object_ref_sink (_tmp24_);
	grid = _tmp25_;
	_tmp26_ = grid;
	gtk_grid_set_row_spacing (_tmp26_, (guint) 6);
	_tmp27_ = grid;
	gtk_grid_set_column_spacing (_tmp27_, (guint) 12);
	_tmp28_ = _ ("_Tile set:");
	_tmp29_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp28_);
	_tmp30_ = g_object_ref_sink (_tmp29_);
	label = _tmp30_;
	_tmp31_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp31_, (gfloat) 0, 0.5f);
	_tmp32_ = grid;
	_tmp33_ = label;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 0, 0, 1, 1);
	_tmp34_ = mahjongg_load_themes (self);
	themes = _tmp34_;
	_tmp35_ = (GtkComboBox*) gtk_combo_box_new ();
	_tmp36_ = g_object_ref_sink (_tmp35_);
	theme_combo = _tmp36_;
	_tmp37_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	theme_store = _tmp37_;
	_tmp38_ = theme_combo;
	_tmp39_ = theme_store;
	gtk_combo_box_set_model (_tmp38_, (GtkTreeModel*) _tmp39_);
	_tmp40_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp41_ = g_object_ref_sink (_tmp40_);
	renderer = _tmp41_;
	_tmp42_ = theme_combo;
	_tmp43_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp42_, (GtkCellRenderer*) _tmp43_, TRUE);
	_tmp44_ = theme_combo;
	_tmp45_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp44_, (GtkCellRenderer*) _tmp45_, "text", 0);
	_tmp46_ = themes;
	{
		GList* theme_collection = NULL;
		GList* theme_it = NULL;
		theme_collection = _tmp46_;
		for (theme_it = theme_collection; theme_it != NULL; theme_it = theme_it->next) {
			gchar* _tmp47_;
			gchar* theme = NULL;
			_tmp47_ = g_strdup ((const gchar*) theme_it->data);
			theme = _tmp47_;
			{
				const gchar* _tmp48_;
				gchar** _tmp49_;
				gchar** _tmp50_ = NULL;
				gchar** tokens;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp51_;
				gint _tmp51__length1;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* name;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp54_;
				GtkTreeIter _tmp55_ = {0};
				GtkListStore* _tmp56_;
				GtkTreeIter _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				GSettings* _tmp61_;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_;
				gboolean _tmp64_;
				_tmp48_ = theme;
				_tmp50_ = _tmp49_ = g_strsplit (_tmp48_, ".", -1);
				tokens = _tmp50_;
				tokens_length1 = _vala_array_length (_tmp49_);
				_tokens_size_ = tokens_length1;
				_tmp51_ = tokens;
				_tmp51__length1 = tokens_length1;
				_tmp52_ = _tmp51_[0];
				_tmp53_ = g_strdup (_tmp52_);
				name = _tmp53_;
				_tmp54_ = theme_store;
				gtk_list_store_append (_tmp54_, &_tmp55_);
				iter = _tmp55_;
				_tmp56_ = theme_store;
				_tmp57_ = iter;
				_tmp58_ = name;
				_tmp59_ = theme;
				gtk_list_store_set (_tmp56_, &_tmp57_, 0, _tmp58_, 1, _tmp59_, -1, -1);
				_tmp60_ = theme;
				_tmp61_ = self->priv->settings;
				_tmp62_ = g_settings_get_string (_tmp61_, "tileset");
				_tmp63_ = _tmp62_;
				_tmp64_ = g_strcmp0 (_tmp60_, _tmp63_) == 0;
				_g_free0 (_tmp63_);
				if (_tmp64_) {
					GtkComboBox* _tmp65_;
					GtkTreeIter _tmp66_;
					_tmp65_ = theme_combo;
					_tmp66_ = iter;
					gtk_combo_box_set_active_iter (_tmp65_, &_tmp66_);
				}
				_g_free0 (name);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (theme);
			}
		}
	}
	_tmp67_ = theme_combo;
	g_signal_connect_object (_tmp67_, "changed", (GCallback) _mahjongg_theme_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp68_ = theme_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp68_, TRUE);
	_tmp69_ = grid;
	_tmp70_ = theme_combo;
	gtk_grid_attach (_tmp69_, (GtkWidget*) _tmp70_, 1, 0, 1, 1);
	_tmp71_ = label;
	_tmp72_ = theme_combo;
	gtk_label_set_mnemonic_widget (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = frame;
	_tmp74_ = grid;
	gtk_container_add ((GtkContainer*) _tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = _ ("Maps");
	_tmp76_ = games_frame_new (_tmp75_);
	_tmp77_ = g_object_ref_sink (_tmp76_);
	_g_object_unref0 (frame);
	frame = _tmp77_;
	_tmp78_ = top_grid;
	_tmp79_ = frame;
	gtk_grid_attach (_tmp78_, (GtkWidget*) _tmp79_, 0, 1, 1, 1);
	_tmp80_ = (GtkGrid*) gtk_grid_new ();
	_tmp81_ = g_object_ref_sink (_tmp80_);
	_g_object_unref0 (grid);
	grid = _tmp81_;
	_tmp82_ = grid;
	gtk_grid_set_row_spacing (_tmp82_, (guint) 6);
	_tmp83_ = grid;
	gtk_grid_set_column_spacing (_tmp83_, (guint) 12);
	_tmp84_ = _ ("_Select map:");
	_tmp85_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp84_);
	_tmp86_ = g_object_ref_sink (_tmp85_);
	_g_object_unref0 (label);
	label = _tmp86_;
	_tmp87_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp87_, (gfloat) 0, 0.5f);
	_tmp88_ = grid;
	_tmp89_ = label;
	gtk_grid_attach (_tmp88_, (GtkWidget*) _tmp89_, 0, 0, 1, 1);
	_tmp90_ = (GtkComboBox*) gtk_combo_box_new ();
	_tmp91_ = g_object_ref_sink (_tmp90_);
	map_combo = _tmp91_;
	_tmp92_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	map_store = _tmp92_;
	_tmp93_ = map_combo;
	_tmp94_ = map_store;
	gtk_combo_box_set_model (_tmp93_, (GtkTreeModel*) _tmp94_);
	_tmp95_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp96_ = g_object_ref_sink (_tmp95_);
	_g_object_unref0 (renderer);
	renderer = _tmp96_;
	_tmp97_ = map_combo;
	_tmp98_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp97_, (GtkCellRenderer*) _tmp98_, TRUE);
	_tmp99_ = map_combo;
	_tmp100_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp99_, (GtkCellRenderer*) _tmp100_, "text", 0);
	_tmp101_ = self->priv->maps;
	{
		GList* map_collection = NULL;
		GList* map_it = NULL;
		map_collection = _tmp101_;
		for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
			Map* _tmp102_;
			Map* map = NULL;
			_tmp102_ = _map_ref0 ((Map*) map_it->data);
			map = _tmp102_;
			{
				Map* _tmp103_;
				const gchar* _tmp104_;
				const gchar* _tmp105_ = NULL;
				gchar* _tmp106_;
				gchar* display_name;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp107_;
				GtkTreeIter _tmp108_ = {0};
				GtkListStore* _tmp109_;
				GtkTreeIter _tmp110_;
				const gchar* _tmp111_;
				Map* _tmp112_;
				GSettings* _tmp113_;
				gchar* _tmp114_ = NULL;
				gchar* _tmp115_;
				Map* _tmp116_;
				const gchar* _tmp117_;
				gboolean _tmp118_;
				_tmp103_ = map;
				_tmp104_ = _tmp103_->name;
				_tmp105_ = g_dpgettext2 (NULL, "mahjongg map name", _tmp104_);
				_tmp106_ = g_strdup (_tmp105_);
				display_name = _tmp106_;
				_tmp107_ = map_store;
				gtk_list_store_append (_tmp107_, &_tmp108_);
				iter = _tmp108_;
				_tmp109_ = map_store;
				_tmp110_ = iter;
				_tmp111_ = display_name;
				_tmp112_ = map;
				gtk_list_store_set (_tmp109_, &_tmp110_, 0, _tmp111_, 1, _tmp112_, -1, -1);
				_tmp113_ = self->priv->settings;
				_tmp114_ = g_settings_get_string (_tmp113_, "mapset");
				_tmp115_ = _tmp114_;
				_tmp116_ = map;
				_tmp117_ = _tmp116_->name;
				_tmp118_ = g_strcmp0 (_tmp115_, _tmp117_) == 0;
				_g_free0 (_tmp115_);
				if (_tmp118_) {
					GtkComboBox* _tmp119_;
					GtkTreeIter _tmp120_;
					_tmp119_ = map_combo;
					_tmp120_ = iter;
					gtk_combo_box_set_active_iter (_tmp119_, &_tmp120_);
				}
				_g_free0 (display_name);
				_map_unref0 (map);
			}
		}
	}
	_tmp121_ = map_combo;
	g_signal_connect_object (_tmp121_, "changed", (GCallback) _mahjongg_map_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp122_ = map_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp122_, TRUE);
	_tmp123_ = grid;
	_tmp124_ = map_combo;
	gtk_grid_attach (_tmp123_, (GtkWidget*) _tmp124_, 1, 0, 1, 1);
	_tmp125_ = label;
	_tmp126_ = map_combo;
	gtk_label_set_mnemonic_widget (_tmp125_, (GtkWidget*) _tmp126_);
	_tmp127_ = frame;
	_tmp128_ = grid;
	gtk_container_add ((GtkContainer*) _tmp127_, (GtkWidget*) _tmp128_);
	_tmp129_ = _ ("Colors");
	_tmp130_ = games_frame_new (_tmp129_);
	_tmp131_ = g_object_ref_sink (_tmp130_);
	_g_object_unref0 (frame);
	frame = _tmp131_;
	_tmp132_ = top_grid;
	_tmp133_ = frame;
	gtk_grid_attach (_tmp132_, (GtkWidget*) _tmp133_, 0, 2, 1, 1);
	_tmp134_ = (GtkGrid*) gtk_grid_new ();
	_tmp135_ = g_object_ref_sink (_tmp134_);
	_g_object_unref0 (grid);
	grid = _tmp135_;
	_tmp136_ = grid;
	gtk_grid_set_row_spacing (_tmp136_, (guint) 6);
	_tmp137_ = grid;
	gtk_grid_set_column_spacing (_tmp137_, (guint) 12);
	_tmp138_ = _ ("_Background color:");
	_tmp139_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp138_);
	_tmp140_ = g_object_ref_sink (_tmp139_);
	_g_object_unref0 (label);
	label = _tmp140_;
	_tmp141_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp141_, (gfloat) 0, 0.5f);
	_tmp142_ = grid;
	_tmp143_ = label;
	gtk_grid_attach (_tmp142_, (GtkWidget*) _tmp143_, 0, 0, 1, 1);
	_tmp144_ = (GtkColorButton*) gtk_color_button_new ();
	_tmp145_ = g_object_ref_sink (_tmp144_);
	widget = _tmp145_;
	_tmp146_ = widget;
	_tmp147_ = self->priv->game_view;
	_tmp148_ = _tmp147_->background_color;
	gtk_color_button_set_rgba (_tmp146_, &_tmp148_);
	_tmp149_ = widget;
	g_signal_connect_object (_tmp149_, "color-set", (GCallback) _mahjongg_background_changed_cb_gtk_color_button_color_set, self, 0);
	_tmp150_ = widget;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp150_, TRUE);
	_tmp151_ = grid;
	_tmp152_ = widget;
	gtk_grid_attach (_tmp151_, (GtkWidget*) _tmp152_, 1, 0, 1, 1);
	_tmp153_ = label;
	_tmp154_ = widget;
	gtk_label_set_mnemonic_widget (_tmp153_, (GtkWidget*) _tmp154_);
	_tmp155_ = frame;
	_tmp156_ = grid;
	gtk_container_add ((GtkContainer*) _tmp155_, (GtkWidget*) _tmp156_);
	_tmp157_ = dialog_content_area;
	_tmp158_ = top_grid;
	gtk_box_pack_start (_tmp157_, (GtkWidget*) _tmp158_, TRUE, TRUE, (guint) 0);
	_tmp159_ = self->priv->preferences_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp159_);
	_g_object_unref0 (widget);
	_g_object_unref0 (map_store);
	_g_object_unref0 (map_combo);
	_g_object_unref0 (renderer);
	_g_object_unref0 (theme_store);
	_g_object_unref0 (theme_combo);
	__g_list_free__g_free0_0 (themes);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (frame);
	_g_object_unref0 (top_grid);
	_g_object_unref0 (dialog_content_area);
}


static void mahjongg_preferences_dialog_response_cb (Mahjongg* self, GtkDialog* dialog, gint response) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = NULL;
}


static GList* mahjongg_load_themes (Mahjongg* self) {
	GList* result = NULL;
	GList* themes;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	themes = NULL;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GDir* _tmp2_ = NULL;
		GDir* _tmp3_;
		GDir* _tmp4_;
		_tmp0_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_dir_open (_tmp1_, (guint) 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_dir_close0 (dir);
			__g_list_free__g_free0_0 (themes);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_dir_close0 (dir);
		dir = _tmp4_;
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = themes;
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (dir);
		__g_list_free__g_free0_0 (themes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		GDir* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* s;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp18_;
		gboolean _tmp21_;
		gboolean _tmp24_;
		gboolean _tmp27_;
		gboolean _tmp30_;
		_tmp5_ = dir;
		_tmp6_ = g_dir_read_name (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		s = _tmp7_;
		_tmp8_ = s;
		if (_tmp8_ == NULL) {
			_g_free0 (s);
			break;
		}
		_tmp14_ = s;
		_tmp15_ = g_str_has_suffix (_tmp14_, ".xpm");
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = s;
			_tmp17_ = g_str_has_suffix (_tmp16_, ".svg");
			_tmp13_ = _tmp17_;
		}
		_tmp18_ = _tmp13_;
		if (_tmp18_) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp19_ = s;
			_tmp20_ = g_str_has_suffix (_tmp19_, ".gif");
			_tmp12_ = _tmp20_;
		}
		_tmp21_ = _tmp12_;
		if (_tmp21_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp22_;
			gboolean _tmp23_ = FALSE;
			_tmp22_ = s;
			_tmp23_ = g_str_has_suffix (_tmp22_, ".png");
			_tmp11_ = _tmp23_;
		}
		_tmp24_ = _tmp11_;
		if (_tmp24_) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = s;
			_tmp26_ = g_str_has_suffix (_tmp25_, ".jpg");
			_tmp10_ = _tmp26_;
		}
		_tmp27_ = _tmp10_;
		if (_tmp27_) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp28_;
			gboolean _tmp29_ = FALSE;
			_tmp28_ = s;
			_tmp29_ = g_str_has_suffix (_tmp28_, ".xbm");
			_tmp9_ = _tmp29_;
		}
		_tmp30_ = _tmp9_;
		if (_tmp30_) {
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = s;
			_tmp32_ = g_strdup (_tmp31_);
			themes = g_list_append (themes, _tmp32_);
		}
		_g_free0 (s);
	}
	result = themes;
	_g_dir_close0 (dir);
	return result;
}


static void _match_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (match_unref (var), NULL));
}


static void _g_list_free__match_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _match_unref0_, NULL);
	g_list_free (self);
}


static gpointer _match_ref0 (gpointer self) {
	return self ? match_ref (self) : NULL;
}


static void mahjongg_hint_cb (Mahjongg* self) {
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	GameView* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Tile* _tmp6_;
	Tile* _tmp7_;
	GList* _tmp8_ = NULL;
	GList* matches;
	GList* _tmp9_;
	guint _tmp10_ = 0U;
	guint n_matches;
	guint _tmp11_;
	GamesClock* _tmp38_;
	GamesClock* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_selected_tile (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = game_find_matches (_tmp2_, _tmp7_);
	matches = _tmp8_;
	_tmp9_ = matches;
	_tmp10_ = g_list_length (_tmp9_);
	n_matches = _tmp10_;
	_tmp11_ = n_matches;
	if (_tmp11_ == ((guint) 0)) {
		GameView* _tmp12_;
		Game* _tmp13_;
		Game* _tmp14_;
		Tile* _tmp15_;
		Tile* _tmp16_;
		GameView* _tmp17_;
		Game* _tmp18_;
		Game* _tmp19_;
		GameView* _tmp20_;
		Game* _tmp21_;
		Game* _tmp22_;
		Tile* _tmp23_;
		Tile* _tmp24_;
		_tmp12_ = self->priv->game_view;
		_tmp13_ = game_view_get_game (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = game_get_selected_tile (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == NULL) {
			__g_list_free__match_unref0_0 (matches);
			return;
		}
		_tmp17_ = self->priv->game_view;
		_tmp18_ = game_view_get_game (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->game_view;
		_tmp21_ = game_view_get_game (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = game_get_selected_tile (_tmp22_);
		_tmp24_ = _tmp23_;
		game_set_hint (_tmp19_, _tmp24_, NULL);
	} else {
		guint _tmp25_;
		gint32 _tmp26_ = 0;
		gint32 n;
		GList* _tmp27_;
		gint32 _tmp28_;
		gconstpointer _tmp29_ = NULL;
		Match* _tmp30_;
		Match* match;
		GameView* _tmp31_;
		Game* _tmp32_;
		Game* _tmp33_;
		Match* _tmp34_;
		Tile* _tmp35_;
		Match* _tmp36_;
		Tile* _tmp37_;
		_tmp25_ = n_matches;
		_tmp26_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp25_));
		n = _tmp26_;
		_tmp27_ = matches;
		_tmp28_ = n;
		_tmp29_ = g_list_nth_data (_tmp27_, (guint) _tmp28_);
		_tmp30_ = _match_ref0 ((Match*) _tmp29_);
		match = _tmp30_;
		_tmp31_ = self->priv->game_view;
		_tmp32_ = game_view_get_game (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = match;
		_tmp35_ = _tmp34_->tile0;
		_tmp36_ = match;
		_tmp37_ = _tmp36_->tile1;
		game_set_hint (_tmp33_, _tmp35_, _tmp37_);
		_match_unref0 (match);
	}
	_tmp38_ = self->priv->game_clock;
	games_clock_start (_tmp38_);
	_tmp39_ = self->priv->game_clock;
	games_clock_add_seconds (_tmp39_, (time_t) 30);
	__g_list_free__match_unref0_0 (matches);
}


static void mahjongg_about_cb (Mahjongg* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_ = NULL;
	gchar** artists;
	gint artists_length1;
	gint _artists_size_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_ = NULL;
	gchar** documenters;
	gint documenters_length1;
	gint _documenters_size_;
	GtkWindow* _tmp26_;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Main game:");
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("Francisco Bustamante");
	_tmp3_ = g_strdup ("Max Watson");
	_tmp4_ = g_strdup ("Heinz Hempe");
	_tmp5_ = g_strdup ("Michael Meeks");
	_tmp6_ = g_strdup ("Philippe Chavin");
	_tmp7_ = g_strdup ("Callum McKenzie");
	_tmp8_ = g_strdup ("Robert Ancell");
	_tmp9_ = g_strdup ("");
	_tmp10_ = _ ("Maps:");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_strdup ("Rexford Newbould");
	_tmp13_ = g_strdup ("Krzysztof Foltman");
	_tmp14_ = g_new0 (gchar*, 13 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp2_;
	_tmp14_[2] = _tmp3_;
	_tmp14_[3] = _tmp4_;
	_tmp14_[4] = _tmp5_;
	_tmp14_[5] = _tmp6_;
	_tmp14_[6] = _tmp7_;
	_tmp14_[7] = _tmp8_;
	_tmp14_[8] = _tmp9_;
	_tmp14_[9] = _tmp11_;
	_tmp14_[10] = _tmp12_;
	_tmp14_[11] = _tmp13_;
	_tmp14_[12] = NULL;
	authors = _tmp14_;
	authors_length1 = 13;
	_authors_size_ = authors_length1;
	_tmp15_ = _ ("Tiles:");
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = g_strdup ("Jonathan Buzzard");
	_tmp18_ = g_strdup ("Jim Evans");
	_tmp19_ = g_strdup ("Richard Hoelscher");
	_tmp20_ = g_strdup ("Gonzalo Odiard");
	_tmp21_ = g_strdup ("Max Watson");
	_tmp22_ = g_new0 (gchar*, 7 + 1);
	_tmp22_[0] = _tmp16_;
	_tmp22_[1] = _tmp17_;
	_tmp22_[2] = _tmp18_;
	_tmp22_[3] = _tmp19_;
	_tmp22_[4] = _tmp20_;
	_tmp22_[5] = _tmp21_;
	_tmp22_[6] = NULL;
	artists = _tmp22_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp23_ = g_strdup ("Tiffany Antopolski");
	_tmp24_ = g_strdup ("Chris Beiser");
	_tmp25_ = g_new0 (gchar*, 3 + 1);
	_tmp25_[0] = _tmp23_;
	_tmp25_[1] = _tmp24_;
	_tmp25_[2] = NULL;
	documenters = _tmp25_;
	documenters_length1 = 3;
	_documenters_size_ = documenters_length1;
	_tmp26_ = self->priv->window;
	_tmp27_ = _ ("Mahjongg");
	_tmp28_ = _ ("A matching game played with Mahjongg tiles.\n" \
"\n" \
"Mahjongg is a part of GNOME Games.");
	_tmp29_ = _ ("Mahjongg");
	_tmp30_ = games_get_license (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _ ("translator-credits");
	_tmp33_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp26_, "program-name", _tmp27_, "version", VERSION, "comments", _tmp28_, "copyright", "Copyright \xc2\xa9 1998-2008 Free Software Foundation, Inc.", "license", _tmp31_, "wrap-license", TRUE, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp32_, "logo-icon-name", "mahjongg", "website", "http://www.gnome.org/projects/gnome-games", "website-label", _tmp33_, NULL, NULL);
	_g_free0 (_tmp31_);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void mahjongg_pause_cb (Mahjongg* self, GamesPauseAction* action) {
	GameView* _tmp0_;
	GamesPauseAction* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GameView* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	GameView* _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	GameView* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = action;
	_tmp2_ = games_pause_action_get_is_paused (_tmp1_);
	game_view_set_paused (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	game_set_hint (_tmp5_, NULL, NULL);
	_tmp6_ = self->priv->game_view;
	_tmp7_ = game_view_get_game (_tmp6_);
	_tmp8_ = _tmp7_;
	game_set_selected_tile (_tmp8_, NULL);
	_tmp9_ = self->priv->game_view;
	_tmp10_ = game_view_get_paused (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		GamesClock* _tmp12_;
		_tmp12_ = self->priv->game_clock;
		games_clock_stop (_tmp12_);
	} else {
		GamesClock* _tmp13_;
		_tmp13_ = self->priv->game_clock;
		games_clock_start (_tmp13_);
	}
	mahjongg_update_ui (self);
}


static void mahjongg_scores_cb (Mahjongg* self, GtkAction* action) {
	GtkWindow* _tmp0_;
	GamesScores* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GamesScoresDialog* _tmp3_;
	GamesScoresDialog* _tmp4_;
	GamesScoresDialog* map_scores_dialog;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->highscores;
	_tmp2_ = _ ("Mahjongg Scores");
	_tmp3_ = games_scores_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	map_scores_dialog = _tmp4_;
	_tmp5_ = _ ("Map:");
	games_scores_dialog_set_category_description (map_scores_dialog, _tmp5_);
	gtk_dialog_run ((GtkDialog*) map_scores_dialog);
	gtk_widget_destroy ((GtkWidget*) map_scores_dialog);
	_g_object_unref0 (map_scores_dialog);
}


static void mahjongg_new_game_cb (Mahjongg* self, GtkAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	mahjongg_new_game (self);
}


static void mahjongg_restart_game_cb (Mahjongg* self, GtkAction* action) {
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	GameView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_reset (_tmp2_);
	_tmp3_ = self->priv->game_view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
}


static void mahjongg_quit_cb (Mahjongg* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void mahjongg_redo_cb (Mahjongg* self, GtkAction* action) {
	GameView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GameView* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	game_redo (_tmp5_);
	mahjongg_update_ui (self);
}


static void mahjongg_undo_cb (Mahjongg* self) {
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_undo (_tmp2_);
	mahjongg_update_ui (self);
}


static void mahjongg_restart_game (Mahjongg* self) {
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	GamesClock* _tmp3_;
	GamesClock* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_reset (_tmp2_);
	_tmp3_ = self->priv->game_clock;
	games_clock_stop (_tmp3_);
	_tmp4_ = self->priv->game_clock;
	games_clock_reset (_tmp4_);
	mahjongg_update_ui (self);
}


static void _mahjongg_moved_cb_game_moved (Game* _sender, gpointer self) {
	mahjongg_moved_cb (self);
}


static void mahjongg_new_game (Mahjongg* self) {
	Map* map;
	GList* _tmp0_;
	Map* _tmp10_;
	GameView* _tmp14_;
	Map* _tmp15_;
	Game* _tmp16_;
	Game* _tmp17_;
	GameView* _tmp18_;
	Game* _tmp19_;
	Game* _tmp20_;
	GamesScores* _tmp21_;
	GameView* _tmp22_;
	Game* _tmp23_;
	Game* _tmp24_;
	Map* _tmp25_;
	const gchar* _tmp26_;
	GameView* _tmp27_;
	Game* _tmp28_;
	Game* _tmp29_;
	Map* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* display_name;
	GtkWindow* _tmp34_;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	GamesClock* _tmp38_;
	GamesClock* _tmp39_;
	g_return_if_fail (self != NULL);
	map = NULL;
	_tmp0_ = self->priv->maps;
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp0_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			Map* _tmp1_;
			Map* m = NULL;
			_tmp1_ = _map_ref0 ((Map*) m_it->data);
			m = _tmp1_;
			{
				Map* _tmp2_;
				const gchar* _tmp3_;
				GSettings* _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = m;
				_tmp3_ = _tmp2_->name;
				_tmp4_ = self->priv->settings;
				_tmp5_ = g_settings_get_string (_tmp4_, "mapset");
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp3_, _tmp6_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					Map* _tmp8_;
					Map* _tmp9_;
					_tmp8_ = m;
					_tmp9_ = _map_ref0 (_tmp8_);
					_map_unref0 (map);
					map = _tmp9_;
					_map_unref0 (m);
					break;
				}
				_map_unref0 (m);
			}
		}
	}
	_tmp10_ = map;
	if (_tmp10_ == NULL) {
		GList* _tmp11_;
		gconstpointer _tmp12_ = NULL;
		Map* _tmp13_;
		_tmp11_ = self->priv->maps;
		_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
		_tmp13_ = _map_ref0 ((Map*) _tmp12_);
		_map_unref0 (map);
		map = _tmp13_;
	}
	_tmp14_ = self->priv->game_view;
	_tmp15_ = map;
	_tmp16_ = game_new (_tmp15_);
	_tmp17_ = _tmp16_;
	game_view_set_game (_tmp14_, _tmp17_);
	_game_unref0 (_tmp17_);
	_tmp18_ = self->priv->game_view;
	_tmp19_ = game_view_get_game (_tmp18_);
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "moved", (GCallback) _mahjongg_moved_cb_game_moved, self, 0);
	_tmp21_ = self->priv->highscores;
	_tmp22_ = self->priv->game_view;
	_tmp23_ = game_view_get_game (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->map;
	_tmp26_ = _tmp25_->score_name;
	games_scores_set_category (_tmp21_, _tmp26_);
	_tmp27_ = self->priv->game_view;
	_tmp28_ = game_view_get_game (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_->map;
	_tmp31_ = _tmp30_->name;
	_tmp32_ = g_dpgettext2 (NULL, "mahjongg map name", _tmp31_);
	_tmp33_ = g_strdup (_tmp32_);
	display_name = _tmp33_;
	_tmp34_ = self->priv->window;
	_tmp35_ = _ ("Mahjongg - %s");
	_tmp36_ = g_strdup_printf (_tmp35_, display_name);
	_tmp37_ = _tmp36_;
	gtk_window_set_title (_tmp34_, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = self->priv->game_clock;
	games_clock_stop (_tmp38_);
	_tmp39_ = self->priv->game_clock;
	games_clock_reset (_tmp39_);
	mahjongg_update_ui (self);
	_g_free0 (display_name);
	_map_unref0 (map);
}


static void mahjongg_help_cb (Mahjongg* self, GtkAction* action) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:mahjongg", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("mahjongg.vala:648: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _mahjongg_pause_cb_games_pause_action_state_changed (GamesPauseAction* _sender, gpointer self) {
	mahjongg_pause_cb (self, _sender);
}


static void mahjongg_create_menus (Mahjongg* self, GtkUIManager* ui_manager) {
	GtkActionGroup* _tmp0_;
	GtkActionGroup* action_group;
	GtkUIManager* _tmp1_;
	GtkAction* _tmp3_ = NULL;
	GtkAction* _tmp4_;
	GamesPauseAction* _tmp5_;
	GamesPauseAction* _tmp6_;
	GamesPauseAction* _tmp7_;
	GamesPauseAction* _tmp8_;
	GtkAction* _tmp9_ = NULL;
	GtkAction* _tmp10_;
	GtkAction* _tmp11_;
	GtkAction* _tmp12_ = NULL;
	GtkAction* _tmp13_;
	GtkAction* _tmp14_;
	GtkAction* _tmp15_ = NULL;
	GtkAction* _tmp16_;
	GtkAction* _tmp17_ = NULL;
	GtkToggleAction* _tmp18_;
	GtkToggleAction* show_toolbar_action;
	GtkWindow* _tmp19_;
	GamesFullscreenAction* _tmp20_;
	GamesFullscreenAction* _tmp21_;
	GtkWindow* _tmp22_;
	GamesFullscreenAction* _tmp23_;
	GamesFullscreenAction* _tmp24_;
	GSettings* _tmp25_;
	gboolean _tmp26_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui_manager != NULL);
	_tmp0_ = gtk_action_group_new ("group");
	action_group = _tmp0_;
	gtk_action_group_set_translation_domain (action_group, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (action_group, MAHJONGG_actions, G_N_ELEMENTS (MAHJONGG_actions), self);
	gtk_action_group_add_toggle_actions (action_group, MAHJONGG_toggle_actions, G_N_ELEMENTS (MAHJONGG_toggle_actions), self);
	_tmp1_ = ui_manager;
	gtk_ui_manager_insert_action_group (_tmp1_, action_group, 0);
	{
		GtkUIManager* _tmp2_;
		_tmp2_ = ui_manager;
		gtk_ui_manager_add_ui_from_string (_tmp2_, MAHJONGG_ui_description, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action_group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = gtk_action_group_get_action (action_group, "RestartGame");
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->restart_action);
	self->priv->restart_action = _tmp4_;
	_tmp5_ = games_pause_action_new ("PauseGame");
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp5_;
	_tmp6_ = self->priv->pause_action;
	gtk_action_set_is_important ((GtkAction*) _tmp6_, TRUE);
	_tmp7_ = self->priv->pause_action;
	g_signal_connect_object (_tmp7_, "state-changed", (GCallback) _mahjongg_pause_cb_games_pause_action_state_changed, self, 0);
	_tmp8_ = self->priv->pause_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp8_, NULL);
	_tmp9_ = gtk_action_group_get_action (action_group, "Hint");
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->priv->hint_action);
	self->priv->hint_action = _tmp10_;
	_tmp11_ = self->priv->hint_action;
	gtk_action_set_is_important (_tmp11_, TRUE);
	_tmp12_ = gtk_action_group_get_action (action_group, "UndoMove");
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp13_;
	_tmp14_ = self->priv->undo_action;
	gtk_action_set_is_important (_tmp14_, TRUE);
	_tmp15_ = gtk_action_group_get_action (action_group, "RedoMove");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp16_;
	_tmp17_ = gtk_action_group_get_action (action_group, "ShowToolbar");
	_tmp18_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp17_));
	show_toolbar_action = _tmp18_;
	_tmp19_ = self->priv->window;
	_tmp20_ = games_fullscreen_action_new ("Fullscreen", _tmp19_);
	_g_object_unref0 (self->priv->fullscreen_action);
	self->priv->fullscreen_action = _tmp20_;
	_tmp21_ = self->priv->fullscreen_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp21_, NULL);
	_tmp22_ = self->priv->window;
	_tmp23_ = games_fullscreen_action_new ("LeaveFullscreen", _tmp22_);
	_g_object_unref0 (self->priv->leave_fullscreen_action);
	self->priv->leave_fullscreen_action = _tmp23_;
	_tmp24_ = self->priv->leave_fullscreen_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp24_, NULL);
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_boolean (_tmp25_, "show-toolbar");
	gtk_toggle_action_set_active (show_toolbar_action, _tmp26_);
	_g_object_unref0 (show_toolbar_action);
	_g_object_unref0 (action_group);
}


static void mahjongg_load_maps (Mahjongg* self) {
	Map* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GamesFileList* _tmp3_;
	GamesFileList* _tmp4_;
	GamesFileList* filelist;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__map_unref0_0 (self->priv->maps);
	self->priv->maps = NULL;
	_tmp0_ = map_new_builtin ();
	self->priv->maps = g_list_append (self->priv->maps, _tmp0_);
	_tmp1_ = g_build_filename (DATA_DIRECTORY, "maps", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_file_list_new ("*.map", ".", _tmp2_, NULL, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	filelist = _tmp4_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				GamesFileList* _tmp9_;
				gsize _tmp10_ = 0UL;
				GamesFileList* _tmp11_;
				gint _tmp12_;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* filename;
				MapLoader* _tmp15_;
				MapLoader* loader;
				MapLoader* _tmp21_;
				GList* _tmp22_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = filelist;
				_tmp10_ = games_file_list_length (_tmp9_);
				if (!(((gsize) _tmp8_) < _tmp10_)) {
					break;
				}
				_tmp11_ = filelist;
				_tmp12_ = i;
				_tmp13_ = games_file_list_get_nth (_tmp11_, _tmp12_);
				_tmp14_ = g_strdup (_tmp13_);
				filename = _tmp14_;
				_tmp15_ = map_loader_new ();
				loader = _tmp15_;
				{
					MapLoader* _tmp16_;
					const gchar* _tmp17_;
					_tmp16_ = loader;
					_tmp17_ = filename;
					map_loader_load (_tmp16_, _tmp17_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp18_;
					GError* _tmp19_;
					const gchar* _tmp20_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp18_ = filename;
					_tmp19_ = e;
					_tmp20_ = _tmp19_->message;
					g_warning ("mahjongg.vala:766: Could not load map %s: %s\n", _tmp18_, _tmp20_);
					_g_error_free0 (e);
					_map_loader_unref0 (loader);
					_g_free0 (filename);
					continue;
				}
				__finally4:
				if (_inner_error_ != NULL) {
					_map_loader_unref0 (loader);
					_g_free0 (filename);
					_g_object_unref0 (filelist);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp21_ = loader;
				_tmp22_ = _tmp21_->maps;
				{
					GList* map_collection = NULL;
					GList* map_it = NULL;
					map_collection = _tmp22_;
					for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
						Map* _tmp23_;
						Map* map = NULL;
						_tmp23_ = _map_ref0 ((Map*) map_it->data);
						map = _tmp23_;
						{
							Map* _tmp24_;
							Map* _tmp25_;
							_tmp24_ = map;
							_tmp25_ = _map_ref0 (_tmp24_);
							self->priv->maps = g_list_append (self->priv->maps, _tmp25_);
							_map_unref0 (map);
						}
					}
				}
				_map_loader_unref0 (loader);
				_g_free0 (filename);
			}
		}
	}
	_g_object_unref0 (filelist);
}


gint mahjongg_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* context;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	Mahjongg* _tmp9_;
	Mahjongg* app;
	Mahjongg* _tmp10_;
	Mahjongg* _tmp11_;
	gint _tmp12_ = 0;
	gint _result_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	games_scores_startup ();
	gtk_init (&args_length1, &args);
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	games_stock_init ();
	_tmp8_ = _ ("Mahjongg");
	g_set_application_name (_tmp8_);
	gtk_window_set_default_icon_name ("mahjongg");
	_tmp9_ = mahjongg_new ();
	app = _tmp9_;
	_tmp10_ = app;
	mahjongg_start (_tmp10_);
	_tmp11_ = app;
	_tmp12_ = g_application_run ((GApplication*) _tmp11_, 0, NULL);
	_result_ = _tmp12_;
	g_settings_sync ();
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return mahjongg_main (argv, argc);
}


static void mahjongg_class_init (MahjonggClass * klass) {
	mahjongg_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MahjonggPrivate));
	G_APPLICATION_CLASS (klass)->activate = mahjongg_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mahjongg_finalize;
}


static void mahjongg_instance_init (Mahjongg * self) {
	self->priv = MAHJONGG_GET_PRIVATE (self);
	self->priv->maps = NULL;
	self->priv->preferences_dialog = NULL;
}


static void mahjongg_finalize (GObject* obj) {
	Mahjongg * self;
	self = MAHJONGG (obj);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->highscores);
	__g_list_free__map_unref0_0 (self->priv->maps);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->game_view);
	_g_object_unref0 (self->priv->status_item);
	_g_object_unref0 (self->priv->ui_manager);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->moves_label);
	_g_object_unref0 (self->priv->game_clock);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->hint_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->restart_action);
	_g_object_unref0 (self->priv->fullscreen_action);
	_g_object_unref0 (self->priv->leave_fullscreen_action);
	G_OBJECT_CLASS (mahjongg_parent_class)->finalize (obj);
}


GType mahjongg_get_type (void) {
	static volatile gsize mahjongg_type_id__volatile = 0;
	if (g_once_init_enter (&mahjongg_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MahjonggClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mahjongg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mahjongg), 0, (GInstanceInitFunc) mahjongg_instance_init, NULL };
		GType mahjongg_type_id;
		mahjongg_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Mahjongg", &g_define_type_info, 0);
		g_once_init_leave (&mahjongg_type_id__volatile, mahjongg_type_id);
	}
	return mahjongg_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



