#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
from PyQt4 import QtCore, QtGui
import os
import subprocess
from xmlrpclib import *
import socket
import netifaces

from PyQt4 import QtCore, QtGui

import gettext
import locale

locale.textdomain("macregister")
gettext.textdomain("macregister")
_=locale.gettext




ES_PATH="/usr/share/locale/es/"
QCV_PATH="/usr/share/locale/qcv/"


class Ui_Form(object):
	def setupUi(self, Form):
		Form.setObjectName("Form")
		Form.resize(466, 105)
		self.horizontalLayoutWidget = QtGui.QWidget(Form)
		self.horizontalLayoutWidget.setGeometry(QtCore.QRect(10, 20, 441, 71))
		self.horizontalLayoutWidget.setObjectName("horizontalLayoutWidget")
		self.horizontalLayout = QtGui.QHBoxLayout(self.horizontalLayoutWidget)
		self.horizontalLayout.setObjectName("horizontalLayout")
		self.verticalLayout = QtGui.QVBoxLayout()
		self.verticalLayout.setObjectName("verticalLayout")
		self.label = QtGui.QLabel(self.horizontalLayoutWidget)
		self.label.setObjectName("label")
		self.verticalLayout.addWidget(self.label)
		self.idComboBox = QtGui.QComboBox(self.horizontalLayoutWidget)
		self.idComboBox.setObjectName("idComboBox")
		self.verticalLayout.addWidget(self.idComboBox)
		self.horizontalLayout.addLayout(self.verticalLayout)
		self.teacherCheckBox = QtGui.QCheckBox(self.horizontalLayoutWidget)
		self.teacherCheckBox.setObjectName("teacherCheckBox")
		self.horizontalLayout.addWidget(self.teacherCheckBox)
		self.verticalLayout_2 = QtGui.QVBoxLayout()
		self.verticalLayout_2.setObjectName("verticalLayout_2")
		self.registerButton = QtGui.QPushButton(self.horizontalLayoutWidget)
		self.registerButton.setObjectName("registerButton")
		self.verticalLayout_2.addWidget(self.registerButton)
		self.unregisterButton = QtGui.QPushButton(self.horizontalLayoutWidget)
		self.unregisterButton.setObjectName("unregisterButton")
		self.verticalLayout_2.addWidget(self.unregisterButton)
		self.horizontalLayout.addLayout(self.verticalLayout_2)
		self.retranslateUi(Form)
		QtCore.QMetaObject.connectSlotsByName(Form)

	def retranslateUi(self, Form):
		Form.setWindowTitle(QtGui.QApplication.translate("Form", _("Register this PC"), None, QtGui.QApplication.UnicodeUTF8))
		self.label.setText(QtGui.QApplication.translate("Form", _("Available IDs"), None, QtGui.QApplication.UnicodeUTF8))
		self.teacherCheckBox.setText(QtGui.QApplication.translate("Form", _("Teacher\'s PC"), None, QtGui.QApplication.UnicodeUTF8))
		self.registerButton.setText(QtGui.QApplication.translate("Form", _("Register PC"), None, QtGui.QApplication.UnicodeUTF8))
		self.unregisterButton.setText(QtGui.QApplication.translate("Form", _("Unregister PC"), None, QtGui.QApplication.UnicodeUTF8))


class MyForm(QtGui.QMainWindow):
	def __init__(self, parent=None):
		
		QtGui.QWidget.__init__(self, parent)
		self.ui = Ui_Form()
		self.ui.setupUi(self)
		try:
			self.xmlrpcserver = ServerProxy ("https://server:9779")
			aux = self.xmlrpcserver.get_methods()
		except:
			QtGui.QMessageBox.critical(self,'',_("Could not connect to server. Check if n4d service is started in the server"))
			exit(0)
		self.set_list()
		self.connect(self.ui.registerButton,QtCore.SIGNAL("clicked()"),self.register_clicked)
		self.connect(self.ui.unregisterButton,QtCore.SIGNAL("clicked()"),self.unregister_clicked)

	def get_ip(self):

		for item in netifaces.interfaces():
			tmp=netifaces.ifaddresses(item)
			if tmp.has_key(netifaces.AF_INET):
				if tmp[netifaces.AF_INET][0].has_key("broadcast") and tmp[netifaces.AF_INET][0]["broadcast"]=="10.0.2.255":
					return tmp[netifaces.AF_INET][0]["addr"]
					
	#def get_ip	
	

	def set_list(self):
	    output = self.xmlrpcserver.get_available_id_list('','Dnsmasq')
	    print output
	    self.ui.idComboBox.clear()
	    for i in output['result']:
	        self.ui.idComboBox.addItem(str(i))
	    if output['default'] > 0 :
		self.ui.idComboBox.setCurrentIndex(output['result'].index(int(output['default'])))
	
	def getMac(self,ip):
		for item in netifaces.interfaces():
			tmp=netifaces.ifaddresses(item)
			if (tmp[netifaces.AF_INET][0]['addr']==ip) :
				return tmp[netifaces.AF_LINK][0]['addr']
		return None

	def getMyMAC(self):
		mac = os.getenv('LTSP_CLIENT_MASK')
		if mac == None:
			s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
			try:
				s.connect(("server",9779))
			except Exception as e:
				return ""
			myip = s.getsockname()[0]
			mac = self.getMac(myip)
			s.close()
		return mac

	def register_clicked(self):
		id = str(self.ui.idComboBox.currentText())
		
		isteacher= False
		mac = self.getMyMAC()
		if self.ui.teacherCheckBox.isChecked():
			isteacher = True
		output = self.xmlrpcserver.register_machine('','Dnsmasq',id,mac,isteacher)
		if output['status']:
			QtGui.QMessageBox.information(self,'',_('Register client has been successfull'))
		else:
			QtGui.QMessageBox.warning(self,_('Error'),output['result'])
		self.set_list()
	
	#def register_clicked
			
	def unregister_clicked(self):
		mac = self.getMyMAC()
		output = self.xmlrpcserver.remove_register('','Dnsmasq',mac)
		if output['status']:
			QtGui.QMessageBox.information(self,'',_('Unregister client has been successfull'))
		else:
			QtGui.QMessageBox.warning(self,_('Error'),output['result'])
		self.set_list()
	#def unregister_clicked
			
if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)
	'''
	lang=os.getenv("LANG").split(".")[0]
	if lang=="es_ES":
		translator=QtCore.QTranslator()
		translator.load(ES_PATH + "register_pc.qm")
		#translator.load("register_pc.qm")
		app.installTranslator(translator)
	elif lang=="qcv_ES":
		translator=QtCore.QTranslator()
		translator.load(QCV_PATH + "register_pc.qm")
		app.installTranslator(translator)
	'''
	myapp = MyForm()
	myapp.show()
	sys.exit(app.exec_())
