# -*- coding: utf-8 -*-
import imp
import ldap
import sys
import subprocess
import grp
import shutil
import threading


class Golem:


	PLUGIN_PATH="/usr/share/n4d/python-plugins/"
	
	
	def startup(self,options):
		
		
		try:
			self.obj=imp.load_source("LdapManager",Golem.PLUGIN_PATH + "LdapManager.py")
			obj3=imp.load_source("NetFilesManager",Golem.PLUGIN_PATH + "NetFilesManager.py")
			obj4=imp.load_source("PasswordManager",Golem.PLUGIN_PATH + "PasswordManager.py")
			obj5=imp.load_source("GesItaManager",Golem.PLUGIN_PATH + "GesItaManager.py")
			obj6=imp.load_source("FileOperations",Golem.PLUGIN_PATH + "FileOperations.py")
			obj7=imp.load_source("PeterPan",Golem.PLUGIN_PATH + "PeterPan.py")
			self.ldap=self.obj.LdapManager(llxvars)
			self.netfiles=obj3.NetFilesManager(llxvars)
			self.pw=obj4.PasswordManager()
			self.itaca=obj5.GesItaManager(llxvars,self,'llxgesc.xml')
			self.file_operations=obj6.FileOperations()
			self.peter_pan=obj7.PeterPan()
			self.try_count=0
			self.sharefunctions = {}
			
			
		except Exception as e:
			print e
		
	#def __init__
	
	
	def _restore_groups_folders(self):
		
		t=threading.Thread(target=self.restore_groups_folders)
		t.daemon=True
		t.start()
		
	#def

	def add_user(self,plantille,properties,generic_mode=False):
		
		
		generated_user=None
		properties["uid"]=properties["uid"].encode("utf8")
		properties["cn"]=properties["cn"].encode("utf8")
		properties["sn"]=properties["sn"].encode("utf8")
		
		
		if properties.has_key("userPassword"):
			properties["userPassword"]=properties["userPassword"].encode("utf8")
		
		if type(generic_mode)==type(True):
			#es un booleano
			generated_user=self.ldap.add_user(generic_mode,plantille,properties)
		else:
			generated_user=self.ldap.add_user(False,plantille,properties)
		
		if type(generated_user) is dict:
			
			homepath = self.netfiles.exist_home_or_create(generated_user)
			if plantille=="Teachers" or plantille=="Others":
				self.pw.add_password(generated_user["uid"],generated_user["cn"],generated_user["sn"],generated_user["userPassword"])
			self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem','add_user')
			return "true: " + generated_user["uid"]
		else:
			return generated_user
		
	
	#def add_user
	

	def add_generic_users(self,plantille,group_type,number,generic_name,pwd_generation_type,pwd=None):
		
		generated_list=self.ldap.add_generic_users(plantille,group_type,number,generic_name,pwd_generation_type,pwd)
		for item in generated_list:
			#
			# Item {uid:name,userPassword:password}
			#
			
			homepath = self.netfiles.exist_home_or_create(item)
			
			#print "password saving..."
			if plantille=="Teachers" or plantille=="Others":
				self.pw.add_password(item["uid"],item["cn"],item["sn"],item["userPassword"])
			self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem',('add_generic_users'),{'group':group_type,'user':item})
		return generated_list
		
	#def add_generic_users
	
	def add_admin(self,user_name):
		# existing system user
	
		try:
			uid=pwd.getpwnam(user_name).pw_uid
			
			properties={}
			properties["uid"]=user_name
			properties["cn"]=user_name
			properties["sn"]=user_name
			properties["userPassword"]=uid
			properties["uidNumber"]=os.environ["SUDO_UID"]
			
			self.ldap.add_user(False,"Admin",properties)
			return True
			
		except Exception as e:
			
			return [False,e.message]
			
			
	
	#def add_admin
	
	def login(self,user_info):
		
		uid,password=user_info
		
		dic={}
		p = subprocess.Popen(["groups",uid],stdout = subprocess.PIPE,stderr = subprocess.PIPE)
		output = p.communicate()[0]
		output=output.replace("\n","")
		
		dic["groups"]=output
		
		students="ou=Students,ou=People," + llxvars("LDAP_BASE_DN")
		teachers="ou=Teachers,ou=People," + llxvars("LDAP_BASE_DN")
		admins="ou=Admins,ou=People," + llxvars("LDAP_BASE_DN")
		
		group_type="None"
		
		if output.find("students")!=-1:
			dic["path"]="uid=" + uid + "," + students
			group_type="students"
			
		if output.find("teachers")!=-1:
			dic["path"]="uid=" + uid + "," + teachers
			group_type="teachers"

		if output.find("admins")!=-1 and output.find("teachers")!=-1:
			dic["path"]="uid=" + uid + "," + teachers
			group_type="promoted-teacher"
		
		if output.find("adm")!=-1:
			dic["path"]="uid=" + uid + "," + admins
			group_type="admin"
			return "true " + group_type
			

		
		#print dic["path"]
		

		try:
			
			tmp_ldap=ldap.initialize(llxvars("CLIENT_LDAP_URI"))
			tmp_ldap.set_option(ldap.VERSION,ldap.VERSION3)
			tmp_ldap.bind_s(dic["path"],password)

			return "true " + group_type

		except Exception as e:
			return e[0]["desc"]
		
		
	#def login
	
	
	
	def change_own_password(self,user_info,new_password):
		
		uid,password=user_info
		dic={}
		p = subprocess.Popen(["groups",uid],stdout = subprocess.PIPE,stderr = subprocess.PIPE)
		output = p.communicate()[0]
		output=output.replace("\n","")
		
		dic["groups"]=output
		
		students="ou=Students,ou=People," + llxvars("LDAP_BASE_DN")
		teachers="ou=Teachers,ou=People," + llxvars("LDAP_BASE_DN")
		admin="ou=Admins,ou=People," + llxvars("LDAP_BASE_DN")
		others="ou=Other,ou=People," + llxvars("LDAP_BASE_DN")
		
		if output.find("students")!=-1:
			path="uid=" + uid + "," + students
		elif output.find("teachers")!=-1:
			path="uid=" + uid + "," + teachers
		elif output.find("others")!=-1:
			path="uid=" + uid + "," + others
		elif output.find("admin")!=-1:
			path="uid=" + uid + "," + admin
		else:
			return "false"
		
		dic["path"]=path
		
		#dic["llxvars"]=llxvars
		
		try:
			
			tmp_ldap=ldap.initialize(llxvars("CLIENT_LDAP_URI"))
			dic["a"]="initialize"
			tmp_ldap.set_option(ldap.VERSION,ldap.VERSION3)
			dic["b"]="set_option"
			tmp_ldap.bind_s(path,password)
			dic["c"]="bind"
			self.ldap.change_password(path,new_password)
			dic["d"]="ldap password"
			
			if "Teachers" in path:
				self.pw.set_externally_modified(uid)
			
			return "true"
			
		except Exception as inst:

			

			dic["exception"]=inst
		
			return "false"
		
	#def change_own_password
	
	
	
	
	def delete_student(self,uid,delete_data=True):
		
		user_info={}
		user_info["uid"]=uid
		user_info["profile"]="students"
	
		#self.unfreeze_user(uid)
	
	
		if delete_data==True:
			homepath = self.netfiles.delete_home(user_info)

		ret=self.ldap.delete_student(uid)
		
		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem','delete_student')
		return ret
		
	#def delete_student
		
		
		
	def delete_teacher(self,uid,delete_data=True):

		user_info={}
		user_info["uid"]=uid
		user_info["profile"]="teachers"

		#self.unfreeze_user(uid)		

		if delete_data==True:
			homepath = self.netfiles.delete_home(user_info)

		
		self.pw.remove_password(uid)
		ret=self.ldap.delete_teacher(uid)
		
		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem','delete_teacher')
		return ret
	#def delete_teacher

	def delete_other(self,uid,delete_data=True):

		user_info={}
		user_info["uid"]=uid
		user_info["profile"]="others"
		
		self.unfreeze_user(uid)
		
		
		if delete_data==True:
			homepath = self.netfiles.delete_home(user_info)

		
		self.pw.remove_password(uid)

		ret=self.ldap.delete_other(uid)
		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem','delete_other')
		return ret
		
	#def delete_other

	def delete_students(self,delete_data=True):
		
		list=self.ldap.search_user("*")
		
		ret_list=[]
		
		for item in list:
			if item.properties["path"].find("ou=Students")!=-1:
				ret=self.delete_student(item.properties["uid"],delete_data) 
				ret_list.append(item.properties["uid"] +":"+ret)
				
		return ret_list
				
			
		
	#def delete_students
	
	def delete_teachers(self,delete_data=True):
		
		list=self.ldap.search_user("*")
		
		ret_list=[]
		
		for item in list:
			if item.properties["path"].find("ou=Teachers")!=-1:
				ret=self.delete_teacher(item.properties["uid"],delete_data)
				ret_list.append(item.properties["uid"] +":"+ret)

		return ret_list
			
		
	#def delete_students
	

	def delete_all(self,delete_data=True):
		
		list=self.ldap.search_user("*")
		
		ok=True
		
		ret_list=[]
		
		for item in list:
			if item.properties["path"].find("ou=Teachers")!=-1:
				ret=self.delete_teacher(item.properties["uid"],delete_data)
				ret_list.append(item.properties["uid"] +":"+ret)
				
			if item.properties["path"].find("ou=Students")!=-1:
				ret=self.delete_student(item.properties["uid"],delete_data)
				ret_list.append(item.properties["uid"] +":"+ret)
				
			if item.properties["path"].find("ou=Other")!=-1:
				ret=self.delete_other(item.properties["uid"],delete_data)
				ret_list.append(item.properties["uid"] +":"+ret)
				
		return ret_list
		
	#def delete_students

	def get_students_function_list(self):
		return students_func_list

	def get_teachers_function_list(self):
		return teachers_func_list
		
	def get_admin_function_list(self):
		return admin_func_list
		
	def get_others_function_list(self):
		return others_func_list

	def get_student_list(self):
		
		list=self.ldap.search_students("*")
		
		return_list=[]
		
		for item in list:
			return_list.append(item.properties)
							
		return return_list
		
	def get_teacher_list(self):
		
		list=self.ldap.search_teachers("*")
		
		return_list=[]
		
		for item in list:
			return_list.append(item.properties)
							
		return return_list
			
	def get_user_list(self,filter):

		list=self.ldap.search_user(filter)

		
		#return self.ldap.light_search(filter)
		
		return_list=[]
		for item in list:
			return_list.append(item.properties)
			
		return return_list
		

	#def get_user_list
	
	def light_get_user_list(self):
		
		list=self.ldap.light_search()

			
		return list
		
	#def light_get_user_list
	
	def get_available_groups(self):
		
		return self.ldap.get_available_groups()
		
	#def get_available_groups
	

	def add_to_group(self,uid,group):
		
		result=self.ldap.add_to_group_type(group,uid)

		user_info={}
		user_info["uid"]=uid
		
		path=self.ldap.get_dn(uid)
		
		if path.find("ou=Students")!=-1:
			user_info["profile"]="students"
		if path.find("ou=Teachers")!=-1:
			user_info["profile"]="teachers"	
		if path.find("ou=Other")!=-1:
			user_info["profile"]="others"	
			
		

		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem',('add_to_group'),{'group':{'cn':group},'user':user_info})
		#return must be "true" (string)
		
		return result
		
	#def add_to_group
	
	def remove_from_group(self,uid,group):
		
		result=self.ldap.del_user_from_group(uid,group)
		user_info={}
		user_info["uid"]=uid
		
		
		
		#return must be "true" (string)

		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem',('remove_from_group'),{'group':{'cn':group},'user':user_info})
		return result
		
	#def remove_from_group


	def change_student_personal_data(self,uid,name,surname):
		name=unicode(name).encode("utf8")
		surname=unicode(surname).encode("utf8")
		result=self.ldap.change_student_name(uid,name)
		#print result
		result2=self.ldap.change_student_surname(uid,surname)
		#print result2
		if result==result2 and result=="true":
			return result
		else:
			return result + "," + result2
		
	#def change_personal_data
	
	def change_password(self,path,password,uid="",cn="",sn="",auto=False):
		
		password=unicode(password).encode("utf8")
		result=self.ldap.change_password(path,password)
		
		#trying to obtain user uid
		list=path.split(",")
		uid=list[0].split("=")[1]
		
		
		#return=="true"
		
		if uid!="" and cn!="" and sn!="":
			self.pw.add_password(uid,cn,sn,password)
			
		if not auto:
			if "Teachers" in path:
				self.pw.set_externally_modified(uid)
		
		return result
		
	#def change_student_password

	def change_student_password(self,uid,password):
		
		result=self.ldap.change_user_password(uid,password)
		
		#return=="true"
		
		
		return result
		
	#def change_student_password
	def freeze_user(self,uid_list):
		self.ldap.freeze_user(uid_list)
		return 0
	#def freeze_user

	def freeze_group(self,cn):
		self.ldap.freeze_group(cn)
		return 0
	#def freeze_group

	def unfreeze_user(self,uid_list):
		self.ldap.unfreeze_user(uid_list)
		return 0
	#def unfreeze_user

	def unfreeze_group(self,cn):
		self.ldap.unfreeze_group(cn)
		return 0
	#def unfreeze_group
	
	def add_teacher_to_admins(self,uid):
		
		result=self.ldap.add_teacher_to_admins(uid)
		
		return result
		
	#def add_teacher_to_admins
	
	def del_teacher_from_admins(self,uid):
		
		result=self.ldap.del_teacher_from_admins(uid)
		return result
		
	#def de_teacher_from_admins
	
	
	def change_group_description(self,gid,description):
		
		description=unicode(description).encode("utf8")
		result=self.ldap.change_group_description(gid,description)
		
		return result
		
	#def change_group_description
	
	def delete_group(self,group_name):

		#self.unfreeze_group(gid)
		result=self.ldap.delete_group(group_name)
		try:
			self.netfiles.remove_group_folder(group_name)
		except Exception as e:
			print(e)
		
		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem',('delete_group'),{'group':{'cn':group_name}})
		return result
		
	#def delete_group
	
	
	def add_group(self,properties):
		properties["description"]=unicode(properties["description"]).encode("utf8")
		result=self.ldap.add_group(properties)
		
		try:
			self.create_group_folder(properties["cn"])
		except Exception as e:
			print(e)
		
		try:
			self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem',('add_group'),{'group':properties})
		except Exception as e:
			print(e)
		return result
		
	#def add_group
	
	def get_students_passwords(self):
		
		list = self.ldap.get_students_passwords()

		return self.quicksort(list)
		
	#def get_students_passwords
	
	def get_teachers_passwords(self):
		
		return self.quicksort(self.pw.get_passwords())
		
	#def get_teachers_passwords
	
	def get_all_passwords(self):
		list=self.ldap.get_students_passwords()
		list2=self.pw.get_passwords()
		for item in list2:
			list.append(item)
		return self.quicksort(list)
		
	#def get_all_passwords
	
	def quicksort (self,lista): 
		self.sort_quicksort(lista,0,len(lista)-1) 
		return lista
	
	#def quicksort
	
	def sort_quicksort (self,lista,izdo,dcho) : 
		if izdo<dcho : 
			pivote=lista[(izdo+dcho)/2] 
			i,d=izdo,dcho 
			while i<=d : 
				while lista[i]['sn'].lower()<pivote['sn'].lower() : i+=1 
				while lista[d]['sn'].lower()>pivote['sn'].lower() : d-=1 
				if i<=d : 
					lista[i],lista[d]=lista[d],lista[i] 
					i+=1 
					d-=1 
			if izdo<d : self.sort_quicksort(lista,izdo,d) 
			if i<dcho : self.sort_quicksort(lista,i,dcho) 
		return lista
	#def sort_quicksort
	
	
	def generic_student_to_itaca(self,uid,nia):
		
		return self.ldap.generic_student_to_itaca(uid,nia)
		
	#def generic_student_to_itaca
	
	def generic_teacher_to_itaca(self,uid,nif):
		
		return self.ldap.generic_teacher_to_itaca(uid,nif)
		
	#def generic_teachers_to_itaca
	
	def send_xml_to_server(self,data64,file_name):
		server_path="/tmp/" + file_name
		try:
			ret=self.file_operations.send_file_to_server(data64,server_path)
		except:
			return "false:send_error"
		if ret==1:
			try:
				ret=self.gescen_set_path(server_path)
				if ret:
					return "true"
				else:
					return "false:xml_error"
			except:
				return "false:xml_error"
		else:
			return "false:send_error"
		
		
	#def send_xml_to_server
	
	
	def gescen_info(self):
		return self.itaca.get_info()
	#def gescen_info
	
	def gescen_set_path(self,path):
		return self.itaca.set_path(path)
	#def gescen_info
	
	def gescen_load(self):
		return self.itaca.load_file()
	#def gescen_info

	def gescen_groups(self):
		return self.itaca.get_groups()
	#def gescen_group

	def gescen_partial(self,group_list):
		#print "partial"
		#print group_list
		self.sharefunctions['generate_uid'] = generate_uid
		self.itaca.partial_import(group_list)
		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem',('gescen_partial'),{})
		return 'true'

	#def gescen_partial

	def gescen_full(self):

		try:
			self.sharefunctions['generate_uid'] = generate_uid
		except Exception as e:
			print e
			raise e

		ret=self.itaca.full_import()
		self.peter_pan.execute_python_dir('/usr/share/n4d/hooks/golem',('gescen_full'),{})
		return ret
	#def gescen_full
	
	def empty_students(self,generic=None):
		list=self.ldap.search_user("*")
		
		ret_list=[]
		
		for item in list:
			if item.properties["path"].find("ou=Students")!=-1:
				ret=self.empty_home(item.properties)
				ret_list.append(item.properties["uid"] +":"+ret)
		return ret_list
	#def empty_students
	
	def empty_teachers(self,generic=None):
		list=self.ldap.search_user("*")
		
		ret_list=[]
		
		for item in list:
			if item.properties["path"].find("ou=Teachers")!=-1:
				ret=self.empty_home(item.properties)
				ret_list.append(item.properties["uid"] +":"+ret)
		return ret_list
	#def empty_teachers
	
	def empty_others(self,generic=None):
		list=self.ldap.search_user("*")
		
		ret_list=[]
		
		for item in list:
			if item.properties["path"].find("ou=Other")!=-1:
				ret=self.empty_home(item.properties)
				ret_list.append(item.properties["uid"] +":"+ret)
		return ret_list
	#def empty_others
	
	def empty_all(self):
		
		ret_list=[]
		ret_list.extend(self.empty_students(True))
		ret_list.extend(self.empty_teachers(True))
		ret_list.extend(self.empty_others(True))
		return ret_list
		
	#def empty_all
		
		
	
	def empty_home(self,user_info):
		try:
			self.netfiles.delete_home(user_info)
			self.netfiles.create_home(user_info)
			return "true"
		except:
			return "false"
	#def empty_home

	def get_frozen_users(self):
		return self.ldap.get_frozen_users()
	#def get_frozen_users

	def get_frozen_groups(self):
		return self.ldap.get_frozen_groups()
	#def get_frozen_groups
	
	def is_frozen_user(self,user):
		return self.ldap.is_frozen_user(user)
		
	def exist_home_or_create(self,user):
		return self.netfiles.exist_home_or_create(user)
		

	def create_group_folder(self,group_name):
		
		return self.netfiles.create_group_folder(group_name)
		
		
	#def create_group_folder
	
	def restore_groups_folders(self):
		ret=[]
		try:
			
			for item in self.get_available_groups():
				try:
					id=self.create_group_folder(item["cn"][0])
					ret.append((item["cn"][0],id))
				except Exception as ex:
					ret.append((item["cn"][0],str(ex)))
			
		except Exception as e:
			ret.append(str(e))
			
		return ret
		
	#def restore_group_folders
	

#class Golem


if __name__=="__main__":
	
	golem=Golem()
