/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.AWTError;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import jzebra.LogIt;
import jzebra.PaperFormat;
import jzebra.PrintApplet;

public class PrintPostScript
implements Printable {
    private final AtomicReference<BufferedImage> bufferedImage = new AtomicReference<Object>(null);
    private final AtomicReference<ByteBuffer> bufferedPDF = new AtomicReference<Object>(null);
    private final AtomicReference<PDFFile> pdfFile = new AtomicReference<Object>(null);
    private final AtomicReference<PrintService> ps = new AtomicReference<Object>(null);
    private final AtomicReference<String> jobName = new AtomicReference<String>("jZebra 2D Printing");
    private final AtomicReference<Paper> paper = new AtomicReference<Object>(null);
    private final AtomicReference<PaperFormat> paperSize = new AtomicReference<Object>(null);
    private final AtomicReference<Float> pixelsPerInch = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> copies = new AtomicReference<Object>(null);
    private final AtomicReference<Boolean> logPostScriptFeatures = new AtomicReference<Boolean>(false);
    private static final float DPI = 72.0f;
    private String pdfClass;

    public void print() throws PrinterException {
        int h;
        int w;
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this.bufferedImage.get() != null) {
            w = this.bufferedImage.get().getWidth();
            h = this.bufferedImage.get().getHeight();
        } else if (this.getPDFFile() != null) {
            w = (int)this.getPDFFile().getPage(1).getWidth();
            h = (int)this.getPDFFile().getPage(1).getHeight();
        } else {
            throw new PrinterException("Corrupt or missing file supplied.");
        }
        if (this.logPostScriptFeatures.get().booleanValue()) {
            this.logSupportedPrinterFeatures(job);
        }
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        if (this.paperSize.get() != null) {
            attr.add(this.paperSize.get().getOrientationRequested());
            if (this.paperSize.get().isAutoSize()) {
                this.paperSize.get().setAutoSize(this.bufferedImage.get());
            }
            attr.add(new MediaPrintableArea(0.0f, 0.0f, this.paperSize.get().getAutoWidth(), this.paperSize.get().getAutoHeight(), this.paperSize.get().getUnits()));
        } else {
            attr.add(new MediaPrintableArea(0.0f, 0.0f, (float)w / 72.0f, (float)h / 72.0f, 25400));
        }
        PrintPostScript.logSizeCalculations(this.paperSize.get(), w, h);
        if (this.copies.get() != null) {
            attr.add(new Copies(this.copies.get()));
        }
        job.setPrintService(this.ps.get());
        job.setPrintable(this);
        job.setJobName(this.jobName.get());
        job.print(attr);
        this.bufferedImage.set(null);
        this.bufferedPDF.set(null);
        this.pdfFile.set(null);
    }

    public void setPaper(Paper paper) {
        this.paper.set(paper);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.paper.get() != null) {
            pageFormat.setPaper(this.paper.get());
        }
        if (this.bufferedImage.get() != null) {
            return this.printImage(graphics, pageFormat, pageIndex);
        }
        if (this.bufferedPDF.get() != null) {
            if (this.isClass("com.sun.pdfview.PDFFile")) {
                return this.printPDFRenderer(graphics, pageFormat, pageIndex);
            }
            throw new PrinterException("No suitable PDF render was found in the 'lib' directory.");
        }
        throw new PrinterException("Unupported file/data type was supplied");
    }

    private boolean isClass(String className) {
        if (className != null && className.equals(this.pdfClass)) {
            return true;
        }
        try {
            Class.forName(className);
            LogIt.log("Using PDF renderer: " + className);
            this.pdfClass = className;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int printPDFRenderer(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        PDFFile pdf = this.getPDFFile();
        int pg = pageIndex + 1;
        if (pdf == null) {
            throw new PrinterException("No PDF data specified");
        }
        if (pg < 1 || pg > pdf.getNumPages()) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        PDFPage page = pdf.getPage(pg);
        PDFRenderer pgs = new PDFRenderer(page, g2, page.getPageBox().getBounds(), page.getBBox(), null);
        try {
            page.waitForFinish();
            pgs.run();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return 0;
    }

    private int printImage(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (graphics == null) {
            throw new PrinterException("No graphics specified");
        }
        if (pageFormat == null) {
            throw new PrinterException("No page format specified");
        }
        if (pageIndex > 0) {
            return 1;
        }
        if (this.paperSize.get() != null) {
            pageFormat.setOrientation(this.paperSize.get().getOrientation());
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        BufferedImage imgToPrint = this.bufferedImage.get();
        g2d.drawImage(this.bufferedImage.get(), 0, 0, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight(), imgToPrint.getMinX(), imgToPrint.getMinY(), imgToPrint.getWidth(), imgToPrint.getHeight(), null);
        return 0;
    }

    public float getPixelsPerInch() {
        if (this.pixelsPerInch.get() == null) {
            try {
                this.pixelsPerInch.set(new Float(Toolkit.getDefaultToolkit().getScreenResolution()));
            }
            catch (AWTError e) {
                this.pixelsPerInch.set(new Float(72.0f));
            }
        }
        return this.pixelsPerInch.get().floatValue();
    }

    private PDFFile getPDFFile() throws PrinterException {
        if (this.pdfFile.get() == null && this.bufferedPDF.get() != null) {
            try {
                this.pdfFile.set(new PDFFile(this.bufferedPDF.get()));
            }
            catch (Exception e) {
                throw new PrinterException(e.getMessage());
            }
        }
        return this.pdfFile.get();
    }

    public void setImage(byte[] imgData) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(imgData);
        this.bufferedImage.set(ImageIO.read(in));
    }

    public void setImage(BufferedImage bufferedImage) {
        this.bufferedImage.set(bufferedImage);
    }

    public void setPDF(ByteBuffer bufferedPDF) {
        this.bufferedPDF.set(bufferedPDF);
    }

    public ByteBuffer getPDF() {
        return this.bufferedPDF.get();
    }

    public BufferedImage getImage() {
        return this.bufferedImage.get();
    }

    public void setPaperSize(PaperFormat PaperSize) {
        this.paperSize.set(PaperSize);
    }

    public void setPrintParameters(PrintApplet a) {
        this.setPrintService(a.getPrintService());
        this.setPaperSize(a.getPaperSize());
        this.setCopies(a.getCopies());
        this.setJobName(a.getJobName().replace(" ___ ", " PostScript "));
        this.setLogPostScriptFeatures(a.getLogPostScriptFeatures());
    }

    public void setCopies(Integer copies) {
        this.copies.set(copies);
    }

    public void setJobName(String jobName) {
        this.jobName.set(jobName);
    }

    public void setPrintService(PrintService ps) {
        this.ps.set(ps);
    }

    public String getJobName() {
        return this.jobName.get();
    }

    public void setLogPostScriptFeatures(boolean b) {
        this.logPostScriptFeatures.set(b);
    }

    public boolean getLogPostScriptFeatures() {
        return this.logPostScriptFeatures.get();
    }

    private void logSupportedPrinterFeatures(PrinterJob job) {
        LogIt.log(Level.INFO, "Supported Printing Attributes:");
        for (Class<?> cl : job.getPrintService().getSupportedAttributeCategories()) {
            LogIt.log(Level.INFO, "   Attr type = " + cl + "=" + job.getPrintService().getDefaultAttributeValue(cl));
        }
    }

    public static void logSizeCalculations(PaperFormat p, float w, float h) {
        if (p != null) {
            LogIt.log("Scaling image " + w + "px x " + h + "px to destination " + p.toString());
        } else {
            LogIt.log("Using image at \"natural\" resolution  " + w + "px " + h + "px scaled to " + (int)(w / 72.0f) + "in x " + (int)(h / 72.0f) + "in (assumes 72dpi)");
        }
    }
}

