<?php

class Sabre_PMB_Tree extends Sabre_DAV_ObjectTree {
	private $id_thesaurus;
	private $only_with_notices;
	

	function __construct($config) {
		$this->config = $config;
  		$this->id_thesaurus = $config['used_thesaurus'];
		$this->only_with_notices = $config['only_with_notices'];
		$this->get_restricted_notices($config['included_sets']);
		$this->getRootNode();
	}
	
	function getRootNode(){
		$this->rootNode = new Sabre_PMB_RootNode($this->config);
	}
	
    function get_restricted_notices($restrict_sets){
    	
    	if($this->restricted_notices == ""){
    		if(count($restrict_sets)){
	    		$tab =array();
	    		for ($i=0 ; $i<count($restrict_sets) ; $i++){
	    			$set = new connector_out_set($restrict_sets[$i]);
	    			$tab = array_merge($tab,$set->get_values());
	    			$tab = array_unique($tab);
	    		}
	    		$this->restricted_notices = implode(",",$tab);
				$tab = array();
    		}else{
    			$query = "select notice_id from notices";
    			$result = mysql_query($query);
    			if(mysql_num_rows($result)){
    				while($row = mysql_fetch_object($result)){
    					if($this->restricted_notices) $this->restricted_notices.=",";
    					$this->restricted_notices.=$row->notice_id;
    				}
    			}
    		}
    	}
    }
		
	public function getNodeForPath($path) {
		global $charset;
        $path = trim($path,'/');
        if (isset($this->cache[$path])) return $this->cache[$path];

        $currentNode = $this->rootNode;
        $currentNode->restricted_notices = $this->restricted_notices;
        $currentNode->parent = null;
        $i=0;
        // We're splitting up the path variable into folder/subfolder components and traverse to the correct node.. 
        $exploded_path = explode('/',$path);
        for($i=0 ; $i<count($exploded_path) ; $i++) {
			$pathPart = $exploded_path[$i];
			if($charset != 'utf-8'){
				$pathPart = utf8_decode($pathPart);
			}
			// If this part of the path is just a dot, it actually means we can skip it
            if ($pathPart=='.' || $pathPart=='') continue;

            if (!($currentNode instanceof Sabre_DAV_ICollection))
                throw new Sabre_DAV_Exception_FileNotFound('Could not find node at path: ' . $path);
			$parent = $currentNode;	
           	$currentNode = $currentNode->getChild($pathPart);
           	$currentNode->set_parent($parent);
		}
		$this->cache[$path] = $currentNode;
		return $currentNode;
    }
}