<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: editions_datasource.class.php,v 1.1 2012-11-02 16:15:28 arenou Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class editions_datasource {
	public $datas = array();
	public $table= "";
	public $struct_format = array();
	public $filename = "datasources";
	public $datasource = "";
	
	public function __construct($datasource=""){
		$this->datasource = $datasource;
		$this->fetch_datas();
	}

	protected function fetch_datas(){
		if($this->datasource){
			global $include_path;
			global $msg;
			
			
			$list = array();
			$file =$include_path."/editions/".$this->filename."_subst.xml";
			if(!file_exists($file)){
				$file = $include_path."/editions/".$this->filename.".xml";
			}
			$dom = new domDocument();
			$dom->load($file);
			$datasources = $dom->getElementsByTagName("datasource");
			for($i=0 ; $i<$datasources->length ; $i++){
				if($datasources->item($i)->getAttribute('id') == $this->datasource){
					$datasource = $datasources->item($i);
					break;
				}
			}
			$this->table = $datasource->getElementsByTagName('table')->item(0)->nodeValue;
			$fields = $dom->getElementsByTagName("field");
			for($i=0 ; $i<$fields->length ; $i++){
				$id = $fields->item($i)->getAttribute('id');
				$this->struct_format[$id] = array(
					'field' => $fields->item($i)->getAttribute('field'),
					'id' => $id,
					'label' => $msg[str_replace("msg:","",$fields->item($i)->getAttribute('label'))],
					'type' => $fields->item($i)->getAttribute('type'),
					'repeat' => $fields->item($i)->getAttribute('repeat'),
					'input' => $fields->item($i)->getAttribute('input')
				);
				$join = $fields->item($i)->getElementsByTagName("join");
				if($join->length){
					$this->struct_format[$id]['join'] = $join->item(0)->nodeValue;	
					$this->struct_format[$id]['need_join_in_select'] = $join->item(0)->getAttribute('use_in_select');
				}
				
				$vals = $fields->item($i)->getElementsByTagName("value");
				if($vals->length > 0){
					$this->struct_format[$id]['value'] = array();
					for($j=0 ; $j<$vals->length ; $j++){
						$this->struct_format[$id]['value'][$vals->item($j)->getAttribute("code")] = $msg[str_replace("msg:","",$vals->item($j)->nodeValue)];
					}
				}else{
					$vals = $fields->item($i)->getElementsByTagName("values");
					if($vals->length){
						$vals = $vals->item(0);
						$this->struct_format[$id]['value'] = $this->get_list_values($vals->getAttribute('type'),$vals->getAttribute('elem'));
				
					}	
				}	
			}
		}
	}
	
		
	public function get_list_values($type,$elem){
		global $dbh;
		
		switch($type){
			case "expl" :
				$query = $this->get_expl_list_query($elem);
				break;
			case "empr" :
				$query = $this->get_empr_list_query($elem);
				break;
		}
		
		$values = array();
		$result = mysql_query($query,$dbh);
		if(mysql_num_rows($result)){
			while($row = mysql_fetch_object($result)){
				$values[$row->id] = $row->list_value;
			}
		}
		return $values;
	}
	
	public function get_expl_list_query($elem){
		switch($elem){

			case "lender" :
				$query = "select idlender as id, lender_libelle as list_value from lenders order by 2 asc";
				break;
			case "codestat" :
				$query = "select idcode as id, ".$elem."_libelle as list_value from docs_".$elem." order by 2 asc";
				break;
			case "section" :	
			case "location" :
			case "statut" :
				$query = "select id".$elem." as id, ".$elem."_libelle as list_value from docs_".$elem." order by 2 asc";
				break;
			case "type" :
				$query = "select idtyp_doc as id, tdoc_libelle as list_value from docs_type order by 2 asc";
				break;

				
		}
		return $query;
	}
	
	public function get_empr_list_query($elem){
		switch($elem){
			case "location" :
				$query = "select id".$elem." as id, ".$elem."_libelle as list_value from docs_".$elem." order by 2 asc";
				break;
			case "statut" :
				$query = "select idstatut as id, statut_libelle as list_value from empr_statut order by 2 asc";
				break;
			case "categ" :
				$query = "select id_categ_empr as id, libelle as list_value from empr_".$elem." order by 2 asc";
				break;
			case "codestat" :
				$query = "select idcode as id, libelle as list_value from empr_".$elem." order by 2 asc";
				break;
		}
		return $query;
	}
	
	public function get_datas($params,$params_values){
		$result = mysql_query($this->generate_query($params,$params_values));
		$datas = $label = array();
		//on commence par les libell...
		foreach($params['fields']['content'] as $field){
			$label[] = $this->struct_format[$field]['label'];
		}
		$datas[]=$label;
		if(mysql_num_rows($result)){
			while($row = mysql_fetch_row($result)){
				$values =array();
				foreach($row as $i =>$val){
					if(count($this->struct_format[$params['fields']['content'][$i]]['value'])){
						$values[] = $this->struct_format[$params['fields']['content'][$i]]['value'][$val] ;
					}else{
						if($this->struct_format[$params['fields']['content'][$i]]['type'] == "date"){
							$values[] = formatdate($val);
						}else{
							$values[] = $val;
						}
					}
				}
				$datas[]=$values;
			}
		}
		return $datas;
	}
	
	public function generate_query($params,$params_values){
		global $class_path;
		$query = $select = $from = $join = $where = $order;
		$joins = array();
		if(count($params['fields']['content'])){
			foreach($params['fields']['content'] as $field){
				if($select) $select.=", ";
				$select.= $this->struct_format[$field]['field'];
			}
			$select = "select ".$select;
			if(count($params['filters']['content'])){
				foreach($params['filters']['content'] as $field){
					if($this->struct_format[$field]['input'] == "list"){
						require_once($class_path."/editions_state_filter_list.class.php");
						$filter = new editions_state_filter_list($this->struct_format[$field],$params_values['filters'][$field]);
					}else{
						$class = "editions_state_filter_".$this->struct_format[$field]['type'];
						require_once($class_path."/".$class.".class.php");
						$filter = new $class($this->struct_format[$field],$params_values['filters'][$field]);
					} 
					$condition = $filter->get_sql_filter(); 
					if($condition!= ""){
						if($where) $where.=" and ";
						$where.= $condition; 
						if($this->struct_format[$field]['join']){
							$joins[]= $this->struct_format[$field]['join'];
						}	
					}
				}
				if($where){
					$where = " where ".$where;
				}
			}
			if(count($params['orders']['content'])){
				foreach($params['orders']['content'] as $field){
					if($order) $order.=", ";
					$crit = new editions_state_order($this->struct_format[$field],$params_values['orders'][$field]);
					$order.= $crit->get_sql_filter();
				}
				if($order){
					$order = " order by ".$order;
				}
			}
		}
		$joins = array_unique($joins);
		return $select." from ".$this->table." ".implode(" ",$joins).$where.$order;
	}
	
	public function get_datasources_list(){
		global $include_path;
		global $msg;
		
		
		$list = array();
		$file =$include_path."/editions/".$this->filename."_subst.xml";
		if(!file_exists($file)){
			$file = $include_path."/editions/".$this->filename.".xml";
		}
		$dom = new domDocument();
		$dom->load($file);
		$datasources = $dom->getElementsByTagName("datasource");
		for($i=0 ; $i<$datasources->length ; $i++){
			$list[$datasources->item($i)->getAttribute('id')] = $msg[str_replace("msg:","",$datasources->item($i)->getAttribute('name'))];
		}	
		return $list;	
	}
	
	public function get_struct_format(){
		return $this->struct_format;
	}
}