<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: editions_state.class.php,v 1.1 2012-11-02 16:15:28 arenou Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

require_once($include_path."/templates/editions_state.tpl.php");
require_once($class_path."/editions_state_order.class.php");

class editions_state {
	public $id = 0;
	public $name="";
	public $classement;
	public $comment = "";
	public $used_datasource = "";
	public $datasource;
	public $state_fields_list = array();	
	public $state_fields_params = array();
	
	public function __construct($id=0){
		$this->id = $id*1;
		$this->fetch_data();
	} 

	protected function fetch_data(){
		if(!$this->id){
			$this->name = "";
			$this->classement= 0;
			$this->comment = "";
			$this->used_datasource = "";			
		}else{
			$query = "select editions_state_name, editions_state_used_datasource, editions_state_comment, editions_state_num_classement,editions_state_fieldslist, editions_state_fieldsparams from editions_states where id_editions_state = ".$this->id;			
			$result = mysql_query($query);
			if(mysql_num_rows($result)){
				$row = mysql_fetch_object($result);
				$this->name = $row->editions_state_name;
				$this->used_datasource = $row->editions_state_used_datasource;
				$this->comment = $row->editions_state_comment;
				$this->classement = $row->editions_state_num_classement;
				$this->state_fields_list = unserialize($row->editions_state_fieldslist);
				$this->state_fields_params = unserialize($row->editions_state_fieldsparams);
//				$this->datasource = new $this->used_datasource();
			}
		}
		$this->datasource = new editions_datasource($this->used_datasource);
		$this->fields = $this->datasource->get_struct_format();
	}
	
	public function save(){
		if($this->id){
			$query = "update editions_states";
			$clause= " where id_editions_state = ".$this->id;
		}else{
			$query ="insert into editions_states";
			$clause= "";
		}
		
		//on va chercher les infos des filtres, tris, groupements...
		$query.=" set
			editions_state_name = '".addslashes($this->name)."',
			editions_state_num_classement = '".addslashes($this->classement)."',
			editions_state_used_datasource = '".addslashes($this->used_datasource)."',
			editions_state_comment = '".addslashes($this->comment)."',
			editions_state_fieldslist = '".addslashes(serialize($this->state_fields_list))."',
			editions_state_fieldsparams = '".addslashes(serialize($this->state_fields_params))."'";
		mysql_query($query);
		if(!$this->id){
			$this->id = mysql_insert_id();
		}
	}
	
	public function delete(){
		if($this->id){
			$query = "delete from editions_states where id_editions_state=".$this->id;
			mysql_query($query);
		}
	}
	
	public function get_from_form(){
		global $editions_state_name;
		global $editions_state_classement;
		global $editions_state_datasource;
		global $editions_state_comment;
		global $editions_state_fields_fields;
		global $editions_state_fields_content_fields;
		global $editions_state_filters_fields;
		global $editions_state_filters_content_fields;
		global $editions_state_orders_fields;
		global $editions_state_orders_content_fields;
		global $class_path;
		
		$this->name = 	stripslashes($editions_state_name);
		$this->classement =	$editions_state_classement;
		$this->used_datasource = $editions_state_datasource;
//		$this->datasource = new $this->used_datasource();
		$this->datasource = new editions_datasource($this->used_datasource);
		$this->comment = stripslashes($editions_state_comment);
		$this->fields = $this->datasource->get_struct_format();
		$this->state_fields_list=array(
			'fields' => array(
				'fields' => (is_array($editions_state_fields_fields) ? $editions_state_fields_fields : array()),
				'content' => (is_array($editions_state_fields_content_fields) ? $editions_state_fields_content_fields : array()) 
			),
			'filters' => array(
				'fields' => (is_array($editions_state_filters_fields) ? $editions_state_filters_fields : array()),
				'content' => (is_array($editions_state_filters_content_fields) ? $editions_state_filters_content_fields : array()),
			),
			'orders' => array(
				'fields' => (is_array($editions_state_orders_fields) ? $editions_state_orders_fields : array()),
				'content' => (is_array($editions_state_orders_content_fields) ? $editions_state_orders_content_fields : array()),
			)
		);
		foreach($this->state_fields_list['fields']['content'] as $field){
			
		}
		foreach($this->state_fields_list['filters']['content'] as $field){
			$class = $this->get_filter_class($field);
			require_once($class_path."/".$class.".class.php");
			$filter= new $class($this->fields[$field]);
			$this->state_fields_params['filters'][$field] = $filter->get_params();
		}		
		foreach($this->state_fields_list['orders']['content'] as $field){
			$order = new editions_state_order($this->fields[$field]);
			$this->state_fields_params['orders'][$field] = $order->get_params();
		}
	}
	
	public function get_form(){
		global $msg,$charset;
		global $editions_state_form;
		
		$form = str_replace('!!id!!', $this->id, $editions_state_form);
		
		//positionnement auto sur le dernier onglet, ca marche tout seul, pas besoin de s'en soucier !
		global $editionsstate_active_tab;
		$form = str_replace('!!active_tab!!', htmlentities($editionsstate_active_tab,ENT_QUOTES, $charset), $form);
		
		//Titre du formulaire
		if (!$this->id) $form = str_replace('!!form_title!!', $msg[704], $form);
		else $form = str_replace('!!form_title!!', $msg["procs_modification"], $form);
		
		//nom 
		$form = str_replace('!!name!!', htmlentities($this->name,ENT_QUOTES, $charset), $form);
		//commentaire 
		$form = str_replace('!!comment!!', htmlentities($this->comment,ENT_QUOTES, $charset), $form);
		//classement
		$combo_clas= gen_liste ("SELECT idproc_classement,libproc_classement FROM procs_classements ORDER BY libproc_classement ", "idproc_classement", "libproc_classement", "editions_state_classement", "", $this->classement, 0, $msg[proc_clas_aucun],0, $msg[proc_clas_aucun]) ;
		$form = str_replace('!!classement!!', $combo_clas, $form);
		
		//source de donnes
		$datasource_options = "
			<option value='0'>".$msg['editions_state_datasource_choice']."</options>";
		$datasources_list = $this->datasource->get_datasources_list();
		foreach($datasources_list as $data_key => $label){
			$datasource_options.="
			<option value='".htmlentities($data_key,ENT_QUOTES,$charset)."' ".($this->used_datasource == $data_key ? "selected='selected'":"").">".htmlentities($label,ENT_QUOTES,$charset)."</option>";
		}
//		
//		$datasource_options.="
//			<option value='editions_datasource_loans' ".($this->used_datasource == "editions_datasource_loans" ? "selected='selected'":"").">Prts</option>";
		$form = str_replace('!!datasource_options!!', $datasource_options, $form);
		
		if(!$this->used_datasource){
			$form = str_replace("!!tabs!!","",$form);
		}else{
			$form = str_replace("!!tabs!!",$this->get_tabs_form(),$form);
		}
		
		$del_button = "";
		if($this->id){
			$del_button = "<input type='button' class='bouton' value=' $msg[supprimer] ' onClick='confirm_delete(".$this->id.")' />
			<script type='text/javascript'>
				function confirm_delete(id){
					if(confirm('".addslashes($msg['editions_state_confirm_delete'])."')){
						document.location='./edit.php?categ=state&action=delete&id='+id;
					}
				}
			</script>
			";
		}
		$form = str_replace("!!del_button!!",$del_button,$form);
		
		return $form;
	}
	
	public function get_tabs_form(){
		global $msg,$charset;
		global $class_path;
		global $editions_state_form_tabs;
		
		$form = $editions_state_form_tabs;
		
		if(count($this->state_fields_list['fields']['fields']) ==0 && count($this->state_fields_list['fields']['content']) == 0){
			foreach($this->fields as $id => $field){
				$this->state_fields_list['fields']['fields'][] = $id;
				$this->state_fields_list['filters']['fields'][] = $id;
			}
		}
		//contruction de la liste des champs pour l'onglets champs
		$form = str_replace("!!fields_fields_list!!",$this->gen_tab_list('fields'),$form);
		$form = str_replace("!!fields_fields_content!!",$this->gen_tab_content('fields'),$form);	
		//contruction de la liste des champs pour l'onglets filtres
		$form = str_replace("!!filters_fields_list!!",$this->gen_tab_list('filters'),$form);
		$form = str_replace("!!filters_fields_content!!",$this->gen_tab_content('filters'),$form);		
		//contruction de la liste des champs pour l'onglets tri
		$form = str_replace("!!order_fields_list!!",$this->gen_tab_list('orders'),$form);
		$form = str_replace("!!order_fields_content!!",$this->gen_tab_content('orders'),$form);		
		return $form;
	}
	
	public function gen_tab_list($tab){
		$list = "";
		foreach($this->state_fields_list[$tab]['fields'] as $field){
			switch($tab){
				case "fields" :
					$id = $this->fields[$field]['id'];
					break;
				case "filters" :
					$id = "filter_".$this->fields[$field]['id'];
					break;
				case "orders" :
					$id = "crit_".$this->fields[$field]['id'];
					break;
			}
			$list.="
						<div id='".$id."' class='row' dragtype='editionsstate".$tab."' draggable='yes'>
							<input type='hidden' name='editions_state_".$tab."_fields[]' value='".$this->fields[$field]['id']."' />
							<span>".$this->fields[$field]['label']."</span>
						</div>";
		}
		return $list;
	}

	public function gen_tab_content($tab){
		global $class_path;
		global $msg,$charset;
		
		$content = "";
		foreach($this->state_fields_list[$tab]['content'] as $field){
//			$content.="
//						<div class='row' id='".$tab."_".$field."' draggable='yes' dragtype='editionsstate".$tab."list'>";
			switch($tab){
				case "fields" :
					$content.= "
						<div class='row' id='".$tab."_".$field."' draggable='yes' dragtype='editionsstate".$tab."list'>
							<input type='hidden' name='editions_state_".$tab."_content_fields[]' value='".$this->fields[$field]['id']."' />
							".$this->fields[$field]['label']."
						</div>";
					break;
				case "filters" :
					$class = $this->get_filter_class($field);
					require_once($class_path."/".$class.".class.php");
					$filter= new $class($this->fields[$field],$this->state_fields_params['filters'][$field]);
					$content.= "
					<div class='row' id='".$tab."_".$field."'>
						<input type='hidden' name='editions_state_".$tab."_content_fields[]' value='".$this->fields[$field]['id']."' />"; 
					$content.= $filter->get_form(true);	
					$content.="
					</div>";
					break;
				case "orders" :
					$order = new editions_state_order($this->fields[$field],$this->state_fields_params['orders'][$field]);
					$content.= "
					<div class='row' id='".$tab."_".$field."' draggable='yes' dragtype='editionsstate".$tab."list'>
						<input type='hidden' name='editions_state_".$tab."_content_fields[]' value='".$this->fields[$field]['id']."' />"; 
					$content.= $order->get_form();
					$content.="
					</div>";
					break;
			}
			
		}
		return $content;
	}
	
	public function get_filter_class($field){
		if($this->fields[$field]['input'] == "list"){
			$class = "editions_state_filter_list";
		}else{
			$class = "editions_state_filter_".$this->fields[$field]['type'];
		}
		return $class;
	}
	
	public function show($sub="tab",$elem=""){
		global $class_path;
		global $charset,$msg;
		global $edition_state_render;
		$datas = $this->datasource->get_datas($this->state_fields_list,$this->state_fields_params);
	
		//jouons avec DoJo sur cette partie...
		//4 onglets : tableaux, TCD, groupement,graph
		$html = str_replace("!!id!!",$this->id,$edition_state_render);
		$html = str_replace("!!name!!",$this->name,$html);		
		$html = str_replace("!!class_".$sub."!!","onglet-perio-selected",$html);
		switch($sub){
			case "tab" :	
				$html = str_replace("!!class_tcd!!","onglets-perio",$html);
				$html = str_replace("!!class_group!!","onglets-perio",$html);
				$html = str_replace("!!class_graph!!","onglets-perio",$html);
				$view_class = "editions_state_view";
				break;
			case "tcd" :
				$html = str_replace("!!class_tab!!","onglets-perio",$html);
				$html = str_replace("!!class_group!!","onglets-perio",$html);
				$html = str_replace("!!class_graph!!","onglets-perio",$html);
				$view_class = "editions_state_view_tcd";
				break;
			case "group" :
				$html = str_replace("!!class_tab!!","onglets-perio",$html);
				$html = str_replace("!!class_tcd!!","onglets-perio",$html);
				$html = str_replace("!!class_graph!!","onglets-perio",$html);
				$view_class = "editions_state_view_group";
				break;
			case "graph" :
				$html = str_replace("!!class_tab!!","onglets-perio",$html);
				$html = str_replace("!!class_group!!","onglets-perio",$html);
				$html = str_replace("!!class_tcd!!","onglets-perio",$html);
				$view_class = "editions_state_view_graph";
				break;
		}
		require_once($class_path."/".$view_class.".class.php");
		$view = new $view_class($datas,$this->id);
		$html = str_replace("!!editions_state_render!!",$view->show(),$html);
		switch($elem){
			case "xls" :
				$view->render_xls_file("plop");
				break;
			default : 
				return $html;
				break;
		}
//		return $html;
	}
	
	public function render_file($sub,$elem){
		global $class_path;
		$datas = $this->datasource->get_datas($this->state_fields_list,$this->state_fields_params);
		
		switch($sub){
			case "tab" :
				$view_class = "editions_state_view";
				break;
			case "tcd" :
				$view_class = "editions_state_view_tcd";
				break;
			case "group" :
				$view_class = "editions_state_view_group";
				break;
			case "graph" :
				$view_class = "editions_state_view_graph";
				break;
		}
		
		require_once($class_path."/".$view_class.".class.php");
		$view = new $view_class($datas,$this->id);
		$file_name = convert_diacrit(str_replace(" ","_",$this->name));
		switch($elem){
			case "xls" :
				$view->render_xls_file($file_name);
				break;
			default : 
				return $html;
				break;
		}		
	}
}