<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: editions_state_filter_integer.class.php,v 1.3 2012-11-09 14:17:32 arenou Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

require_once($class_path."/editions_state_filter.class.php");

class editions_state_filter_integer extends editions_state_filter {

	public function __construct($elem,$params=array()){
		parent::__construct($elem,$params);
		//on s'assure d'avoir un nombre !
		$this->value+=0;
	}
	
	public function get_form($draggable=false){
		global $msg,$charset;
		$form= "
			<div class='row'>&nbsp;</div>
			<div class='row' >
				<div class='colonne3' id='filters_".$this->elem['id']."_drag' draggable='yes' dragtype='editionsstatefilterslist'>
					<label>".htmlentities($this->elem['label'],ENT_QUOTES,$charset)."</label>
				</div>
				<div class='colonne3'>
					<select name='".$this->elem['id']."_filter_op'>
						<option value='='".($this->op == "=" ? " selected='selected'" : "").">=</option>
						<option value='>'".($this->op == ">" ? " selected='selected'" : "").">></option>
						<option value='>='".($this->op == ">=" ? " selected='selected'" : "").">>=</option>
						<option value='<'".($this->op == "<" ? " selected='selected'" : "")."><</option>
						<option value='<='".($this->op == "<=" ? " selected='selected'" : "")."><=</option>
					</select>
				</div>
				<div class='colonne_suite'>
					<input type='text' name='".$this->elem['id']."_filter' value ='".htmlentities($this->value,ENT_QUOTES,$charset)."'/>
				</div>
			</div>";	
		return $form;		
	}
	
	public function get_sql_filter(){
		$sql_filter = "";
		if($this->op && $this->value){
			$sql_filter = $this->elem['field']." ".$this->op." ".$this->value;	
		}
		return $sql_filter;
	} 
}