<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: editions_state_filter_list.class.php,v 1.3 2012-11-09 14:17:32 arenou Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

require_once($class_path."/editions_state_filter.class.php");

class editions_state_filter_list extends editions_state_filter {

	public function __construct($elem,$params=array()){
		parent::__construct($elem,$params);
		//on s'assure d'avoir un nombre !
		if(!$this->value) $this->value = array();
	}
	
	public function get_from_form(){
		$filter_value = $this->elem['id']."_filter";
		$filter_op = $this->elem['id']."_filter_op";
		global $$filter_value;
		global $$filter_op;
		$this->value = $$filter_value;
		$this->op =$$filter_op;	
	}
	
	public function get_form($draggable=false){
		global $msg,$charset;
		$form= "
			<div class='row'>&nbsp;</div>
			<div class='row' >
				<div class='colonne3' id='filters_".$this->elem['id']."_drag' draggable='yes' dragtype='editionsstatefilterslist'>
					<label>".htmlentities($this->elem['label'],ENT_QUOTES,$charset)."</label>
				</div>
				<div class='colonne3'>
					<select name='".$this->elem['id']."_filter_op'>
						<option value='in'".($this->op == "in" ? " selected='selected'" : "").">=</option>
						<option value='not in'".($this->op == "not in" ? " selected='selected'" : "").">".$msg['editions_state_filter_different']."</option>
					</select>
				</div>
				<div class='colonne3'>
					<select name='".$this->elem['id']."_filter[]' multiple='yes'>";
		foreach($this->elem['value'] as $value => $label){
			$form.= "
						<option value='".$value."'".(in_array($value,$this->value) ? " selected='selected'" :"").">".htmlentities($label,ENT_QUOTES,$charset)."</option>";
		}
		$form.= "			
					</select>
				</div>
			</div>";	
		return $form;		
	}
	
	public function get_sql_filter(){
		$sql_filter = "";
		if($this->op && count($this->value)){
			$sql_filter = $this->elem['field']." ".$this->op." (".implode(",",$this->value).")";	
		}
		return $sql_filter;
	} 
}