<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: editions_state_view_tcd.class.php,v 1.1 2012-11-02 16:15:28 arenou Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

require_once($class_path."/editions_state_view.class.php");

class editions_state_view_tcd extends editions_state_view {
	public $datas_tcd =array(
		'values' => array(),
		'cols' => array()
	);		//tableau de donnes
	
	
	public function get_datas(){
		global $tcd;
		$value = explode("_",$tcd);
		for($i=1 ; $i<count($this->datas) ; $i++){
			if(!in_array($this->datas[$i][$value[1]],$this->datas_tcd['cols'])){
				$this->datas_tcd['cols'][] = $this->datas[$i][$value[1]];
			}
			$this->datas_tcd['values'][$this->datas[$i][$value[0]]][$this->datas[$i][$value[1]]]++;
		}
		return $this->datas_tcd;
	}
	
	public function get_form(){
		global $charset,$msg;
		global $tcd;
		
		$form = "
		<form action='' method='post' name='editions_state_tcd'>
			<div class='row'>
				<div class='colonne3'>
					<label for='tcd'>".htmlentities($msg["editions_state_tcd_form"],ENT_QUOTES,$charset)."</label>
				</div>
				<div class='colonne_suite'>
					<select name='tcd' onchange='document.forms.editions_state_tcd.submit()'>
						<option value='0'>".htmlentities($msg["editions_state_tcd_choice"],ENT_QUOTES,$charset)."</option>";
		for($i=0 ; $i<count($this->datas[0]) ; $i++){
			for($j=0 ; $j<count($this->datas[0]) ; $j++){
				if($i!=$j){
				$form.="
						<option value='".$i."_".$j."'".($tcd == $i."_".$j ? " selected='selected'" : "").">".htmlentities($this->datas[0][$i]." / ".$this->datas[0][$j],ENT_QUOTES,$charset)."</option>";
				}
			}
		}
		$form.= "
					</select>
				</div>
			</div>
			<div class='row'></div>
		</form>";
		return $form;
	}
	
	
	
	//un simple tableau pour la classe gnrique...
	public function show(){
		global $charset,$msg;
		global $javascript_path;


		$html = $this->get_form();
		$this->get_datas();
		
		if(count($this->datas_tcd['values'])){	
			$html.= "
			<script type='text/javascript' src='".$javascript_path."/sorttable.js'></script>
			<div class='row'>
			<table class='sortable'>
				<tr>
					<th></th>";
			foreach($this->datas_tcd['cols'] as $label){
				$html.= "
					<th>".htmlentities($label,ENT_QUOTES,$charset)."</th>";
			}	
			$html.= "
				</tr>";	
			foreach($this->datas_tcd['values'] as $row => $cols){
				$html.= "
				<tr>
					<th>".htmlentities($row,ENT_QUOTES,$charset)."</th>";
				foreach($this->datas_tcd['cols'] as $key){
					$html.= "
					<td>".htmlentities(($cols[$key] ? $cols[$key] : 0),ENT_QUOTES,$charset)."</td>";
				}		
			$html.= "	
				</tr>";
					
			}
			$html.="
			</table>";
		}
		$html.="
		</div>";	
		return $html;
	}
}