<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_datasource_rss.class.php,v 1.6 2012-11-15 09:47:40 arenou Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class cms_module_common_datasource_rss extends cms_module_common_datasource{
	
	public function __construct($id=0){
		parent::__construct($id);
	}
	/*
	 * On dfini les slecteurs utilisable pour cette source de donne
	 */
	public function get_available_selectors(){
		return array(
			"cms_module_common_selector_rss"
		);
	}
	
	/*
	 * Sauvegarde du formulaire, revient  remplir la proprit parameters et appeler la mthode parente...
	 */
	public function save_form(){
		global $cms_module_common_datasource_rss_limit;
		
		$this->parameters= array();
		$this->parameters['nb_max_elements'] = $cms_module_common_datasource_rss_limit+0;
		return parent::save_form();
	}
	
	public function get_form(){
		$form = parent::get_form();
		$form.= "
			<div class='row'>
				<div class='colonne3'>
					<label for='cms_module_common_datasource_rss_limit'>".$this->format_text($this->msg['cms_module_common_datasource_rss_limit'])."</label> 
				</div>
				<div class='colonne-suite'>
					<input type='text' name='cms_module_common_datasource_rss_limit' value='".$this->parameters['nb_max_elements']."'/>
				</div>
			</div>";
		return $form;
	}
	
	/*
	 * Rcupration des donnes de la source...
	 */
	public function get_datas(){
		//on commence par rcuprer l'identifiant retourn par le slecteur...
		if($this->parameters['selector'] != ""){
			for($i=0 ; $i<count($this->selectors) ; $i++){
				if($this->selectors[$i]['name'] == $this->parameters['selector']){
					$selector = new $this->parameters['selector']($this->selectors[$i]['id']);
					break;
				}
			}
			@ini_set("zend.ze1_compatibility_mode", "0");
			$rss = new domDocument();
			$information = array();
			$loaded = $rss->load($selector->get_value());
			if($loaded){
				//les infos sur le flux...
				$channel = $rss->getElementsByTagName("channel")->item(0);
				$elements = array(
					'title',
					'description',
					'generator',
					'link'
				); 
				$informations = $this->get_informations($channel,$elements,1);
				//on va lire les infos des items...
				$informations['items'] =array();
				$items = $rss->getElementsByTagName("item");
				$elements = array(
					'title',
					'description',
					'link',
					'guid',
					'date',
					'creator',
					'subject',
					'format',
					'language',
				);
				for($i=0 ; $i<$items->length ; $i++){
					if($this->parameters['nb_max_elements']==0 || $i < $this->parameters['nb_max_elements']){
						$informations['items'][]=$this->get_informations($items->item($i),$elements,false);
					}
				}
			}
			@ini_set("zend.ze1_compatibility_mode", "1");
			return $informations;
			
		}
		return false;
	}
	
	protected function get_informations($node,$elements,$first_only=false){
		global $charset;
		$informations = array();
		foreach($elements as $element){
			$items = $node->getElementsByTagName($element);
			if($items->length == 1 || $first_only){
				$informations[$element] = $this->charset_normalize($items->item(0)->nodeValue,"utf-8");
			}else{
				for($i=0 ; $i<$items->length ; $i++){
					$informations[$element][] = $this->charset_normalize($items->item($i)->nodeValue,"utf-8");
				}
			}
		}
		return $informations;
	}
	
	public function get_format_data_structure(){
		return array(
			array(
				'var' => "title",
				'desc' => $this->msg['cms_module_common_datasource_rss_title_desc']
			),
			array(
				'var' => "description",
				'desc' => $this->msg['cms_module_common_datasource_rss_description_desc']
			),
			array(
				'var' => "generator",
				'desc' => $this->msg['cms_module_common_datasource_rss_generator_desc']
			),
			array(
				'var' => "link",
				'desc' => $this->msg['cms_module_common_datasource_rss_link_desc']
			),
			array(
				'var' => "items",
				'desc' => $this->msg['cms_module_common_datasource_rss_items_desc'],
				'children' => array(
					array(
						'var' => "items[i].title",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_title_desc']
					),
					array(
						'var' => "items[i].description",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_description_desc']
					),
					array(
						'var' => "items[i].link",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_link_desc']
					),
					array(
						'var' => "items[i].guid",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_guid_desc']
					),
					array(
						'var' => "items[i].date",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_date_desc']
					),
					array(
						'var' => "items[i].creator",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_creator_desc']
					),
					array(
						'var' => "items[i].subject",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_subject_desc']
					),
					array(
						'var' => "items[i].format",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_format_desc']
					),
					array(
						'var' => "items[i].language",
						"desc" => $this->msg['cms_module_common_datasource_rss_item_language_desc']
					)
				)
			),
		);
	}
}