DROP TABLE IF EXISTS categories_bak;
CREATE TABLE IF NOT EXISTS categories_bak (
  num_thesaurus int(3) unsigned NOT NULL DEFAULT '1',
  num_noeud int(9) unsigned NOT NULL DEFAULT '0',
  langue varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'fr_FR',
  libelle_categorie text COLLATE utf8_unicode_ci NOT NULL,
  note_application text COLLATE utf8_unicode_ci NOT NULL,
  comment_public text COLLATE utf8_unicode_ci NOT NULL,
  comment_voir text COLLATE utf8_unicode_ci NOT NULL,
  index_categorie text COLLATE utf8_unicode_ci NOT NULL,
  path_word_categ text COLLATE utf8_unicode_ci NOT NULL,
  index_path_word_categ text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (num_noeud,langue),
  KEY categ_langue (langue),
  KEY libelle_categorie (libelle_categorie(5))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO categories_bak (num_thesaurus, num_noeud, langue, libelle_categorie, note_application, comment_public, comment_voir, index_categorie, path_word_categ, index_path_word_categ) VALUES
(1, 3, 'fr_FR', '~termes non classés', '', '', '', ' termes non classes ', '', ''),
(1, 2, 'fr_FR', '~termes orphelins', '', '', '', ' termes orphelins ', '', ''),
(1, 2, 'es_ES', '~descripotres no clasificados', '', '', '', ' descriptores no clasificados ', '', ''),
(1, 3, 'es_ES', '~descriptores huérfanos', '', '', '', ' descriptores huérfanos ', '', ''),
(1, 4, 'es_ES', 'Abadías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 5, 'es_ES', 'Abejas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 6, 'es_ES', 'Abogados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 7, 'es_ES', 'Aborto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 8, 'es_ES', 'Abreviaturas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 9, 'es_ES', 'Absentismo laboral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 10, 'es_ES', 'Absolutismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 11, 'es_ES', 'Academias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 12, 'es_ES', 'Accidentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 13, 'es_ES', 'Accidentes de trabajo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 14, 'es_ES', 'Acciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 15, 'es_ES', 'Aceite de oliva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 16, 'es_ES', 'Aceites minerales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 17, 'es_ES', 'Aceites y grasas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 18, 'es_ES', 'Aceitunas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 19, 'es_ES', 'Aceleradores de partículas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 20, 'es_ES', 'Acequias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 21, 'es_ES', 'Acero', '', '', '', 'descriptores no clasificados', '', ''),
(1, 22, 'es_ES', 'Aclimatación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 23, 'es_ES', 'Acróbatas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 24, 'es_ES', 'Actividades subversivas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 25, 'es_ES', 'Actores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 26, 'es_ES', 'Actos jurídicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 27, 'es_ES', 'Actrices', '', '', '', 'descriptores no clasificados', '', ''),
(1, 28, 'es_ES', 'Actualización profesional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 29, 'es_ES', 'Acuarela', '', '', '', 'descriptores no clasificados', '', ''),
(1, 30, 'es_ES', 'Acuarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 31, 'es_ES', 'Acueductos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 32, 'es_ES', 'Acuicultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 33, 'es_ES', 'Aculturación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 34, 'es_ES', 'Acuñación de moneda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 35, 'es_ES', 'Acupuntura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 36, 'es_ES', 'Acústica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 37, 'es_ES', 'Adaptación (Biología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 38, 'es_ES', 'Adaptación (Psicología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 39, 'es_ES', 'Adhesivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 40, 'es_ES', 'Aditivos alimentarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 41, 'es_ES', 'Adivinación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 42, 'es_ES', 'Adivinanzas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 43, 'es_ES', 'Administración autonómica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 44, 'es_ES', 'Administración central', '', '', '', 'descriptores no clasificados', '', ''),
(1, 45, 'es_ES', 'Administración institucional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 46, 'es_ES', 'Administración local', '', '', '', 'descriptores no clasificados', '', ''),
(1, 47, 'es_ES', 'Administración municipal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 48, 'es_ES', 'Administración provincial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 49, 'es_ES', 'Administración pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 50, 'es_ES', 'Adolescentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 51, 'es_ES', 'Adopción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 52, 'es_ES', 'Adquisición de libros (Bibliotecas)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 53, 'es_ES', 'Aduanas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 54, 'es_ES', 'Adulterio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 55, 'es_ES', 'Adviento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 56, 'es_ES', 'Aerobiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 57, 'es_ES', 'Aerodinámica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 58, 'es_ES', 'Aeromodelismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 59, 'es_ES', 'Aeronáutica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 60, 'es_ES', 'Aeropuertos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 61, 'es_ES', 'Aficiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 62, 'es_ES', 'Agencias de noticias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 63, 'es_ES', 'Agentes comerciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 64, 'es_ES', 'Agnosticismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 65, 'es_ES', 'Agresión-Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 66, 'es_ES', 'Agricultores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 67, 'es_ES', 'Agricultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 68, 'es_ES', 'Agrios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 69, 'es_ES', 'Agronomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 70, 'es_ES', 'Agua', '', '', '', 'descriptores no clasificados', '', ''),
(1, 71, 'es_ES', 'Aguafuerte', '', '', '', 'descriptores no clasificados', '', ''),
(1, 72, 'es_ES', 'Aguafuertes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 73, 'es_ES', 'Aguas jurisdiccionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 74, 'es_ES', 'Aguas marinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 75, 'es_ES', 'Aguas minerales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 76, 'es_ES', 'Aguas potables', '', '', '', 'descriptores no clasificados', '', ''),
(1, 77, 'es_ES', 'Aguas residuales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 78, 'es_ES', 'Aguas subterráneas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 79, 'es_ES', 'Aguas superficiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 80, 'es_ES', 'Aire', '', '', '', 'descriptores no clasificados', '', ''),
(1, 81, 'es_ES', 'Aire acondicionado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 82, 'es_ES', 'Aislamiento acústico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 83, 'es_ES', 'Aislamiento térmico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 84, 'es_ES', 'Aislantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 85, 'es_ES', 'Aislantes eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 86, 'es_ES', 'Ajedrez', '', '', '', 'descriptores no clasificados', '', ''),
(1, 87, 'es_ES', 'Ajuar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 88, 'es_ES', 'Alambiques', '', '', '', 'descriptores no clasificados', '', ''),
(1, 89, 'es_ES', 'Alambres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 90, 'es_ES', 'Alambres eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 91, 'es_ES', 'Alarma-Sistemas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 92, 'es_ES', 'Albaceas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 93, 'es_ES', 'Albañilería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 94, 'es_ES', 'Albergues juveniles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 95, 'es_ES', 'Albigenses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 96, 'es_ES', 'Álbumes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 97, 'es_ES', 'Alcaldes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 98, 'es_ES', 'Alcaloides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 99, 'es_ES', 'Alcantarillado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 100, 'es_ES', 'Alco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 101, 'es_ES', 'Aleaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 102, 'es_ES', 'Alergia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 103, 'es_ES', 'Alfabetización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 104, 'es_ES', 'Alfabetización (Indización)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 105, 'es_ES', 'Alfabetos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 106, 'es_ES', 'Alfarería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 107, 'es_ES', 'Alfombras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 108, 'es_ES', 'Algas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 109, 'es_ES', 'Álgebra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 110, 'es_ES', 'Álgebra lineal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 111, 'es_ES', 'Algodón', '', '', '', 'descriptores no clasificados', '', ''),
(1, 112, 'es_ES', 'Alimentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 113, 'es_ES', 'Alimentos congelados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 114, 'es_ES', 'Alimentos sintéticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 115, 'es_ES', 'Alma', '', '', '', 'descriptores no clasificados', '', ''),
(1, 116, 'es_ES', 'Almacenes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 117, 'es_ES', 'Almanaques', '', '', '', 'descriptores no clasificados', '', ''),
(1, 118, 'es_ES', 'Alpinismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 119, 'es_ES', 'Alta fidelidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 120, 'es_ES', 'Altares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 121, 'es_ES', 'Altavoces', '', '', '', 'descriptores no clasificados', '', ''),
(1, 122, 'es_ES', 'Alternadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 123, 'es_ES', 'Altos ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 124, 'es_ES', 'Alumbrado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 125, 'es_ES', 'Ametralladoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 126, 'es_ES', 'Aminoácidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 127, 'es_ES', 'Amistad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 128, 'es_ES', 'Amnesia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 129, 'es_ES', 'Amnistía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 130, 'es_ES', 'Amor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 131, 'es_ES', 'Amparo, Recurso de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 132, 'es_ES', 'Analfabetismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 133, 'es_ES', 'Análisis clínicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 134, 'es_ES', 'Análisis combinatorio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 135, 'es_ES', 'Análisis de sistemas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 136, 'es_ES', 'Análisis documental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 137, 'es_ES', 'Análisis funcional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 138, 'es_ES', 'Análisis lingüístico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 139, 'es_ES', 'Análisis matemático', '', '', '', 'descriptores no clasificados', '', ''),
(1, 140, 'es_ES', 'Análisis numérico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 141, 'es_ES', 'Análisis químico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 142, 'es_ES', 'Análisis químico cualitativo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 143, 'es_ES', 'Análisis químico cuantitativo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 144, 'es_ES', 'Analistas de sistemas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 145, 'es_ES', 'Anarcosindicalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 146, 'es_ES', 'Anarquismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 147, 'es_ES', 'Anarquistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 148, 'es_ES', 'Anatomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 149, 'es_ES', 'Anatomía ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 150, 'es_ES', 'Anatomía animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 151, 'es_ES', 'Anatomía patológica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 152, 'es_ES', 'Anatomía vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 153, 'es_ES', 'Ancianos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 154, 'es_ES', 'Anécdotas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 155, 'es_ES', 'Anemia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 156, 'es_ES', 'Anestesia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 157, 'es_ES', 'Anestésicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 158, 'es_ES', 'Ángeles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 159, 'es_ES', 'Angiografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 160, 'es_ES', 'Angiospermas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 161, 'es_ES', 'Angustia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 162, 'es_ES', 'Animación cultural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 163, 'es_ES', 'Animales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 164, 'es_ES', 'Animales acuáticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 165, 'es_ES', 'Animales de laboratorio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 166, 'es_ES', 'Animales domésticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 167, 'es_ES', 'Animales fantásticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 168, 'es_ES', 'Animales fósiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 169, 'es_ES', 'Animales pre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 170, 'es_ES', 'Animales salvajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 171, 'es_ES', 'Animales venenosos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 172, 'es_ES', 'Animismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 173, 'es_ES', 'Antenas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 174, 'es_ES', 'Antibióticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 175, 'es_ES', 'Anticlericalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 176, 'es_ES', 'Anticonceptivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 177, 'es_ES', 'Anticuerpos y antígenos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 178, 'es_ES', 'Antigüedades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 179, 'es_ES', 'Antimilitarismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 180, 'es_ES', 'Antipiréticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 181, 'es_ES', 'Antisemitismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 182, 'es_ES', 'Antisépticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 183, 'es_ES', 'Antracita', '', '', '', 'descriptores no clasificados', '', ''),
(1, 184, 'es_ES', 'Antropofagia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 185, 'es_ES', 'Antropoides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 186, 'es_ES', 'Antropología criminal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 187, 'es_ES', 'Antropología cultural y social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 188, 'es_ES', 'Antropometría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 189, 'es_ES', 'Antroposofía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 190, 'es_ES', 'Anuncios publicitarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 191, 'es_ES', 'Año litúrgico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 192, 'es_ES', 'Años Santos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 193, 'es_ES', 'Aparato circulatorio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 194, 'es_ES', 'Aparato digestivo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 195, 'es_ES', 'Aparato genital femenino', '', '', '', 'descriptores no clasificados', '', ''),
(1, 196, 'es_ES', 'Aparato genital masculino', '', '', '', 'descriptores no clasificados', '', ''),
(1, 197, 'es_ES', 'Aparato genitourinario', '', '', '', 'descriptores no clasificados', '', ''),
(1, 198, 'es_ES', 'Aparato locomotor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 199, 'es_ES', 'Aparato respiratorio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 200, 'es_ES', 'Aparcamientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 201, 'es_ES', 'Aparejos de pesca', '', '', '', 'descriptores no clasificados', '', ''),
(1, 202, 'es_ES', 'Apariciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 203, 'es_ES', 'Apartamentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 204, 'es_ES', 'Apelación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 205, 'es_ES', 'Apicultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 206, 'es_ES', 'Apologética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 207, 'es_ES', 'Apostolado seglar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 208, 'es_ES', 'Apóstoles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 209, 'es_ES', 'Aprendizaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 210, 'es_ES', 'Aptitudes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 211, 'es_ES', 'Aranceles de aduanas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 212, 'es_ES', 'Arbitraje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 213, 'es_ES', 'Arbitraje industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 214, 'es_ES', 'Arbitraje internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 215, 'es_ES', 'Árboles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 216, 'es_ES', 'Arboricultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 217, 'es_ES', 'Arcilla', '', '', '', 'descriptores no clasificados', '', ''),
(1, 218, 'es_ES', 'Arcos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 219, 'es_ES', 'Arios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 220, 'es_ES', 'Aristocracia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 221, 'es_ES', 'Aristotelismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 222, 'es_ES', 'Aritmética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 223, 'es_ES', 'Armamentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 224, 'es_ES', 'Armas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 225, 'es_ES', 'Armas de fuego', '', '', '', 'descriptores no clasificados', '', ''),
(1, 226, 'es_ES', 'Armas nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 227, 'es_ES', 'Armas submarinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 228, 'es_ES', 'Armonía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 229, 'es_ES', 'Arqueología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 230, 'es_ES', 'Arquitectura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 231, 'es_ES', 'Arquitectura del paisaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 232, 'es_ES', 'Arquitectura militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 233, 'es_ES', 'Arquitectura religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 234, 'es_ES', 'Arquitectura rural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 235, 'es_ES', 'Arrendamiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 236, 'es_ES', 'Arroz', '', '', '', 'descriptores no clasificados', '', ''),
(1, 237, 'es_ES', 'Arte', '', '', '', 'descriptores no clasificados', '', ''),
(1, 238, 'es_ES', 'Arte abstracto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 239, 'es_ES', 'Arte antiguo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 240, 'es_ES', 'Arte asturiano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 241, 'es_ES', 'Arte barroco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 242, 'es_ES', 'Arte bizantino', '', '', '', 'descriptores no clasificados', '', ''),
(1, 243, 'es_ES', 'Arte clásico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 244, 'es_ES', 'Arte contemporáneo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 245, 'es_ES', 'Arte cristiano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 246, 'es_ES', 'Arte egipcio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 247, 'es_ES', 'Arte gótico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 248, 'es_ES', 'Arte griego', '', '', '', 'descriptores no clasificados', '', ''),
(1, 249, 'es_ES', 'Arte medieval', '', '', '', 'descriptores no clasificados', '', ''),
(1, 250, 'es_ES', 'Arte moderno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 251, 'es_ES', 'Arte mozárabe', '', '', '', 'descriptores no clasificados', '', ''),
(1, 252, 'es_ES', 'Arte mudéjar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 253, 'es_ES', 'Arte musulmán', '', '', '', 'descriptores no clasificados', '', ''),
(1, 254, 'es_ES', 'Arte neoclásico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 255, 'es_ES', 'Arte paleocristiano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 256, 'es_ES', 'Arte plateresco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 257, 'es_ES', 'Arte prerrománico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 258, 'es_ES', 'Arte religioso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 259, 'es_ES', 'Arte renacentista', '', '', '', 'descriptores no clasificados', '', ''),
(1, 260, 'es_ES', 'Arte rococó', '', '', '', 'descriptores no clasificados', '', ''),
(1, 261, 'es_ES', 'Arte románico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 262, 'es_ES', 'Arte romano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 263, 'es_ES', 'Arte romántico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 264, 'es_ES', 'Arte visigótico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 265, 'es_ES', 'Arte y ciencias militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 266, 'es_ES', 'Arte y literatura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 267, 'es_ES', 'Arte y sociedad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 268, 'es_ES', 'Artes decorativas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 269, 'es_ES', 'Artes gráficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 270, 'es_ES', 'Artes industriales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 271, 'es_ES', 'Artes populares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 272, 'es_ES', 'Artesanía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 273, 'es_ES', 'Artesanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 274, 'es_ES', 'Articulaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 275, 'es_ES', 'Artículos periodísticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 276, 'es_ES', 'Artillería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 277, 'es_ES', 'Artistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 278, 'es_ES', 'Artistas gráficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 279, 'es_ES', 'Artritis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 280, 'es_ES', 'Artrópodos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 281, 'es_ES', 'Artrosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 282, 'es_ES', 'Ascensores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 283, 'es_ES', 'Ascetismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 284, 'es_ES', 'Asentamientos ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 285, 'es_ES', 'Asesinato', '', '', '', 'descriptores no clasificados', '', ''),
(1, 286, 'es_ES', 'Asesinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 287, 'es_ES', 'Asfixia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 288, 'es_ES', 'Asilo político', '', '', '', 'descriptores no clasificados', '', ''),
(1, 289, 'es_ES', 'Asilos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 290, 'es_ES', 'Asistencia sanitaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 291, 'es_ES', 'Asistencia social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 292, 'es_ES', 'Asistentes sociales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 293, 'es_ES', 'Asociaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 294, 'es_ES', 'Asociaciones estudiantiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 295, 'es_ES', 'Asociaciones religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 296, 'es_ES', 'Astrofísica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 297, 'es_ES', 'Astrología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 298, 'es_ES', 'Astronautas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 299, 'es_ES', 'Astronáutica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 300, 'es_ES', 'Astronomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 301, 'es_ES', 'Astronomía esférica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 302, 'es_ES', 'Astronomía náutica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 303, 'es_ES', 'Ateísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 304, 'es_ES', 'Atentados políticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 305, 'es_ES', 'Atletismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 306, 'es_ES', 'Atmósfera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 307, 'es_ES', 'Atmósfera superior', '', '', '', 'descriptores no clasificados', '', ''),
(1, 308, 'es_ES', 'Atomismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 309, 'es_ES', 'Átomos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 310, 'es_ES', 'Audición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 311, 'es_ES', 'Auditorías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 312, 'es_ES', 'Auroras polares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 313, 'es_ES', 'Autarquía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 314, 'es_ES', 'Autobiografías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 315, 'es_ES', 'Autobuses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 316, 'es_ES', 'Autocamiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 317, 'es_ES', 'Autoclaves', '', '', '', 'descriptores no clasificados', '', ''),
(1, 318, 'es_ES', 'Autógrafos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 319, 'es_ES', 'Automación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 320, 'es_ES', 'Automóviles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 321, 'es_ES', 'Automovilismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 322, 'es_ES', 'Autopistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 323, 'es_ES', 'Autopsia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 324, 'es_ES', 'Autoridad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 325, 'es_ES', 'Autos sacramentales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 326, 'es_ES', 'Avaricia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 327, 'es_ES', 'Aves', '', '', '', 'descriptores no clasificados', '', ''),
(1, 328, 'es_ES', 'Aves de corral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 329, 'es_ES', 'Aviación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 330, 'es_ES', 'Aviación civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 331, 'es_ES', 'Aviadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 332, 'es_ES', 'Avicultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 333, 'es_ES', 'Aviones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 334, 'es_ES', 'Aviones a reacción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 335, 'es_ES', 'Axiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 336, 'es_ES', 'Ayuda económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 337, 'es_ES', 'Ayuda internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 338, 'es_ES', 'Ayuda técnica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 339, 'es_ES', 'Ayuno y abstinencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 340, 'es_ES', 'Ayuntamientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 341, 'es_ES', 'Azar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 342, 'es_ES', 'Aztecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 343, 'es_ES', 'Azúcar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 344, 'es_ES', 'Bacterias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 345, 'es_ES', 'Bacterias patógenas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 346, 'es_ES', 'Bacteriología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 347, 'es_ES', 'Bailes populares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 348, 'es_ES', 'Baladas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 349, 'es_ES', 'Balanza comercial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 350, 'es_ES', 'Balanza de pagos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 351, 'es_ES', 'Balística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 352, 'es_ES', 'Ballet', '', '', '', 'descriptores no clasificados', '', ''),
(1, 353, 'es_ES', 'Balnearios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 354, 'es_ES', 'Bancos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 355, 'es_ES', 'Bancos de datos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 356, 'es_ES', 'Bandas de música', '', '', '', 'descriptores no clasificados', '', ''),
(1, 357, 'es_ES', 'Banderas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 358, 'es_ES', 'Bandoleros y bandolerismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 359, 'es_ES', 'Banqueros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 360, 'es_ES', 'Baños de sol', '', '', '', 'descriptores no clasificados', '', ''),
(1, 361, 'es_ES', 'Barcos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 362, 'es_ES', 'Barcos congeladores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 363, 'es_ES', 'Barcos de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 364, 'es_ES', 'Barcos mercantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 365, 'es_ES', 'Barcos pesqueros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 366, 'es_ES', 'Barcos petroleros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 367, 'es_ES', 'Barnices', '', '', '', 'descriptores no clasificados', '', ''),
(1, 368, 'es_ES', 'Barras de acero', '', '', '', 'descriptores no clasificados', '', ''),
(1, 369, 'es_ES', 'Barrios residenciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 370, 'es_ES', 'Barroco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 371, 'es_ES', 'Bases de datos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 372, 'es_ES', 'Bases militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 373, 'es_ES', 'Basuras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 374, 'es_ES', 'Batallas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 375, 'es_ES', 'Batallas aéreas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 376, 'es_ES', 'Batallas navales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 377, 'es_ES', 'Batiscafos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 378, 'es_ES', 'Bautismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 379, 'es_ES', 'Bebidas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 380, 'es_ES', 'Bebidas alco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 381, 'es_ES', 'Becas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 382, 'es_ES', 'Becas de investigación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 383, 'es_ES', 'Belleza corporal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 384, 'es_ES', 'Beneficencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 385, 'es_ES', 'Beneficios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 386, 'es_ES', 'Biblia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 387, 'es_ES', 'Bibliofilia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 388, 'es_ES', 'Bibliografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 389, 'es_ES', 'Bibliografías de bibliografías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 390, 'es_ES', 'Bibliografías especiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 391, 'es_ES', 'Bibliografías nacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 392, 'es_ES', 'Bibliometría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 393, 'es_ES', 'Bibliotecarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 394, 'es_ES', 'Bibliotecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 395, 'es_ES', 'Bibliotecas científicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 396, 'es_ES', 'Bibliotecas de ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 397, 'es_ES', 'Bibliotecas de prisiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 398, 'es_ES', 'Bibliotecas eclesiásticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 399, 'es_ES', 'Bibliotecas escolares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 400, 'es_ES', 'Bibliotecas especiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 401, 'es_ES', 'Bibliotecas estatales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 402, 'es_ES', 'Bibliotecas infantiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 403, 'es_ES', 'Bibliotecas móviles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 404, 'es_ES', 'Bibliotecas nacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 405, 'es_ES', 'Bibliotecas para ciegos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 406, 'es_ES', 'Bibliotecas privadas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 407, 'es_ES', 'Bibliotecas públicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 408, 'es_ES', 'Bibliotecas universitarias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 409, 'es_ES', 'Biblioteconomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 410, 'es_ES', 'Biblioterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 411, 'es_ES', 'Bicicletas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 412, 'es_ES', 'Bien', '', '', '', 'descriptores no clasificados', '', ''),
(1, 413, 'es_ES', 'Bienes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 414, 'es_ES', 'Bienes comunales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 415, 'es_ES', 'Bienes gananciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 416, 'es_ES', 'Bienes matrimoniales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 417, 'es_ES', 'Bienestar social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 418, 'es_ES', 'Bigamia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 419, 'es_ES', 'Bilingüismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 420, 'es_ES', 'Billetes de banco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 421, 'es_ES', 'Biobibliografías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 422, 'es_ES', 'Bioclimatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 423, 'es_ES', 'Biodegradación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 424, 'es_ES', 'Biofísica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 425, 'es_ES', 'Biogénesis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 426, 'es_ES', 'Biogeografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 427, 'es_ES', 'Biografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 428, 'es_ES', 'Biografías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 429, 'es_ES', 'Bioingeniería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 430, 'es_ES', 'Biología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 431, 'es_ES', 'Biología de agua dulce', '', '', '', 'descriptores no clasificados', '', ''),
(1, 432, 'es_ES', 'Biología marina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 433, 'es_ES', 'Biología molecular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 434, 'es_ES', 'Biología vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 435, 'es_ES', 'Biólogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 436, 'es_ES', 'Biomas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 437, 'es_ES', 'Biometría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 438, 'es_ES', 'Biónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 439, 'es_ES', 'Biopsia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 440, 'es_ES', 'Bioquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 441, 'es_ES', 'Biorritmos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 442, 'es_ES', 'Biosfera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 443, 'es_ES', 'Biosíntesis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 444, 'es_ES', 'Blasfemias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 445, 'es_ES', 'Blenorragia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 446, 'es_ES', 'Bloqueo marítimo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 447, 'es_ES', 'Boca', '', '', '', 'descriptores no clasificados', '', ''),
(1, 448, 'es_ES', 'Bodas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 449, 'es_ES', 'Bolsas de valores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 450, 'es_ES', 'Bombardeos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 451, 'es_ES', 'Bombas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 452, 'es_ES', 'Bombas ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 453, 'es_ES', 'Bombas de napalm', '', '', '', 'descriptores no clasificados', '', ''),
(1, 454, 'es_ES', 'Bomberos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 455, 'es_ES', 'Bondad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 456, 'es_ES', 'Boole, Álgebra de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 457, 'es_ES', 'Bordados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 458, 'es_ES', 'Bosques', '', '', '', 'descriptores no clasificados', '', ''),
(1, 459, 'es_ES', 'Botánica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 460, 'es_ES', 'Botánicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 461, 'es_ES', 'Botín de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 462, 'es_ES', 'Bóvedas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 463, 'es_ES', 'Boxeo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 464, 'es_ES', 'Bra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 465, 'es_ES', 'Braille, Sistema', '', '', '', 'descriptores no clasificados', '', ''),
(1, 466, 'es_ES', 'Brazos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 467, 'es_ES', 'Breviarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 468, 'es_ES', 'Bricolage', '', '', '', 'descriptores no clasificados', '', ''),
(1, 469, 'es_ES', 'Bromatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 470, 'es_ES', 'Brujería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 471, 'es_ES', 'Brújula', '', '', '', 'descriptores no clasificados', '', ''),
(1, 472, 'es_ES', 'Buceo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 473, 'es_ES', 'Budismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 474, 'es_ES', 'Bulas pontificias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 475, 'es_ES', 'Burguesía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 476, 'es_ES', 'Burocracia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 477, 'es_ES', 'Butano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 478, 'es_ES', 'Cábala', '', '', '', 'descriptores no clasificados', '', ''),
(1, 479, 'es_ES', 'Caballeros y caballería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 480, 'es_ES', 'Caballos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 481, 'es_ES', 'Cabello', '', '', '', 'descriptores no clasificados', '', ''),
(1, 482, 'es_ES', 'Cabeza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 483, 'es_ES', 'Cabildos eclesiásticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 484, 'es_ES', 'Cables', '', '', '', 'descriptores no clasificados', '', ''),
(1, 485, 'es_ES', 'Cables eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 486, 'es_ES', 'Cables para telecomunicaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 487, 'es_ES', 'Cables submarinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 488, 'es_ES', 'Cabotaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 489, 'es_ES', 'Cabras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 490, 'es_ES', 'Cacao', '', '', '', 'descriptores no clasificados', '', ''),
(1, 491, 'es_ES', 'Caciquismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 492, 'es_ES', 'Cadáveres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 493, 'es_ES', 'Cadera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 494, 'es_ES', 'Café', '', '', '', 'descriptores no clasificados', '', ''),
(1, 495, 'es_ES', 'Cajas de a', '', '', '', 'descriptores no clasificados', '', ''),
(1, 496, 'es_ES', 'Cajas fuertes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 497, 'es_ES', 'Cal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 498, 'es_ES', 'Calcografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 499, 'es_ES', 'Calculadoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 500, 'es_ES', 'Cálculo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 501, 'es_ES', 'Cálculo analógico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 502, 'es_ES', 'Cálculo de variaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 503, 'es_ES', 'Cálculo diferencial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 504, 'es_ES', 'Cálculo infinitesimal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 505, 'es_ES', 'Cálculo integral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 506, 'es_ES', 'Cálculo mercantil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 507, 'es_ES', 'Cálculo operacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 508, 'es_ES', 'Cálculo tensorial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 509, 'es_ES', 'Cálculo vectorial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 510, 'es_ES', 'Cálculos biliares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 511, 'es_ES', 'Cálculos urinarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 512, 'es_ES', 'Calderas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 513, 'es_ES', 'Calderas de vapor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 514, 'es_ES', 'Calefacción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 515, 'es_ES', 'Calefacción central', '', '', '', 'descriptores no clasificados', '', ''),
(1, 516, 'es_ES', 'Calefacción eléctrica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 517, 'es_ES', 'Calefacción solar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 518, 'es_ES', 'Calendario', '', '', '', 'descriptores no clasificados', '', ''),
(1, 519, 'es_ES', 'Calendario eclesiástico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 520, 'es_ES', 'Calendario escolar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 521, 'es_ES', 'Calendario gregoriano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 522, 'es_ES', 'Calentadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 523, 'es_ES', 'Calibración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 524, 'es_ES', 'Calibradores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 525, 'es_ES', 'Calidad-Control', '', '', '', 'descriptores no clasificados', '', ''),
(1, 526, 'es_ES', 'Caligrafía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 527, 'es_ES', 'Calles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 528, 'es_ES', 'Calor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 529, 'es_ES', 'Calvicie', '', '', '', 'descriptores no clasificados', '', ''),
(1, 530, 'es_ES', 'Calvinismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 531, 'es_ES', 'Calzado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 532, 'es_ES', 'Cámara alta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 533, 'es_ES', 'Cámara baja', '', '', '', 'descriptores no clasificados', '', ''),
(1, 534, 'es_ES', 'Cámaras cinematográficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 535, 'es_ES', 'Cámaras de comercio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 536, 'es_ES', 'Cámaras de televisión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 537, 'es_ES', 'Cámaras fotográficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 538, 'es_ES', 'Cámaras frigoríficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 539, 'es_ES', 'Cambio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 540, 'es_ES', 'Cambio extranjero', '', '', '', 'descriptores no clasificados', '', ''),
(1, 541, 'es_ES', 'Cambio social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 542, 'es_ES', 'Caminos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 543, 'es_ES', 'Camiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 544, 'es_ES', 'Campamentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 545, 'es_ES', 'Campañas electorales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 546, 'es_ES', 'Campañas publicitarias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 547, 'es_ES', 'Campesinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 548, 'es_ES', 'Camping', '', '', '', 'descriptores no clasificados', '', ''),
(1, 549, 'es_ES', 'Campo, Teoría de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 550, 'es_ES', 'Campos algebraicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 551, 'es_ES', 'Campos de concentración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 552, 'es_ES', 'Campos deportivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 553, 'es_ES', 'Campos magnéticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 554, 'es_ES', 'Canales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 555, 'es_ES', 'Cáncer', '', '', '', 'descriptores no clasificados', '', ''),
(1, 556, 'es_ES', 'Cancerología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 557, 'es_ES', 'Canciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 558, 'es_ES', 'Canciones populares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 559, 'es_ES', 'Canje de publicaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 560, 'es_ES', 'Canoas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 561, 'es_ES', 'Canon bíblico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 562, 'es_ES', 'Canonización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 563, 'es_ES', 'Cantantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 564, 'es_ES', 'Cantares de gesta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 565, 'es_ES', 'Cante ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 566, 'es_ES', 'Canteras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 567, 'es_ES', 'Canto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 568, 'es_ES', 'Canto gregoriano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 569, 'es_ES', 'Canto llano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 570, 'es_ES', 'Caña de azúcar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 571, 'es_ES', 'Cáñamo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 572, 'es_ES', 'Cañones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 573, 'es_ES', 'Capacidad legal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 574, 'es_ES', 'Capillas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 575, 'es_ES', 'Capital', '', '', '', 'descriptores no clasificados', '', ''),
(1, 576, 'es_ES', 'Capitalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 577, 'es_ES', 'Cara', '', '', '', 'descriptores no clasificados', '', ''),
(1, 578, 'es_ES', 'Carácter', '', '', '', 'descriptores no clasificados', '', ''),
(1, 579, 'es_ES', 'Caravanas (Automóviles)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 580, 'es_ES', 'Carbón', '', '', '', 'descriptores no clasificados', '', ''),
(1, 581, 'es_ES', 'Carbón vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 582, 'es_ES', 'Carbono', '', '', '', 'descriptores no clasificados', '', ''),
(1, 583, 'es_ES', 'Carburadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 584, 'es_ES', 'Carburantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 585, 'es_ES', 'Cardenales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 586, 'es_ES', 'Cardiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 587, 'es_ES', 'Cargas eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 588, 'es_ES', 'Caricatura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 589, 'es_ES', 'Caricaturas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 590, 'es_ES', 'Caridad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 591, 'es_ES', 'Caries dentales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 592, 'es_ES', 'Carnavales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 593, 'es_ES', 'Carnes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 594, 'es_ES', 'Carnívoros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 595, 'es_ES', 'Carpintería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 596, 'es_ES', 'Carpintería metálica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 597, 'es_ES', 'Carreras ciclistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 598, 'es_ES', 'Carreras de automóviles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 599, 'es_ES', 'Carreras de caballos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 600, 'es_ES', 'Carreras de motocicletas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 601, 'es_ES', 'Carreteras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 602, 'es_ES', 'Carruajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 603, 'es_ES', 'Cartas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 604, 'es_ES', 'Cartas náuticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 605, 'es_ES', 'Cartas pastorales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 606, 'es_ES', 'Carteles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 607, 'es_ES', 'Carteros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 608, 'es_ES', 'Cartografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 609, 'es_ES', 'Cartografía militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 610, 'es_ES', 'Cartógrafos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 611, 'es_ES', 'Cartomancia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 612, 'es_ES', 'Cartón', '', '', '', 'descriptores no clasificados', '', ''),
(1, 613, 'es_ES', 'Cartotecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 614, 'es_ES', 'Cartularios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 615, 'es_ES', 'Casas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 616, 'es_ES', 'Casas reales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 617, 'es_ES', 'Casinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 618, 'es_ES', 'Castas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 619, 'es_ES', 'Castidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 620, 'es_ES', 'Castigos (Educación)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 621, 'es_ES', 'Castillos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 622, 'es_ES', 'Castración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 623, 'es_ES', 'Catacumbas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 624, 'es_ES', 'Catálisis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 625, 'es_ES', 'Catalizadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 626, 'es_ES', 'Catalogación bibliográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 627, 'es_ES', 'Catálogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 628, 'es_ES', 'Catálogos colectivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 629, 'es_ES', 'Cataratas (Hidrología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 630, 'es_ES', 'Cataratas (Oftalmología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 631, 'es_ES', 'Cátaros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 632, 'es_ES', 'Catarro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 633, 'es_ES', 'Catástrofes naturales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 634, 'es_ES', 'Catecismos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 635, 'es_ES', 'Catedrales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 636, 'es_ES', 'Catequesis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 637, 'es_ES', 'Católicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 638, 'es_ES', 'Cauc', '', '', '', 'descriptores no clasificados', '', ''),
(1, 639, 'es_ES', 'Causalidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 640, 'es_ES', 'Caza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 641, 'es_ES', 'Cefalalgia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 642, 'es_ES', 'Ceguera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 643, 'es_ES', 'Celibato eclesiástico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 644, 'es_ES', 'Celos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 645, 'es_ES', 'Células', '', '', '', 'descriptores no clasificados', '', ''),
(1, 646, 'es_ES', 'Células fotoeléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 647, 'es_ES', 'Celulosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 648, 'es_ES', 'Cementerios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 649, 'es_ES', 'Cemento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 650, 'es_ES', 'Censos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 651, 'es_ES', 'Censura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 652, 'es_ES', 'Censura eclesiástica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 653, 'es_ES', 'Centrales ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 654, 'es_ES', 'Centrales de energía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 655, 'es_ES', 'Centrales eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 656, 'es_ES', 'Centrales eólicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 657, 'es_ES', 'Centrales geotérmicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 658, 'es_ES', 'Centrales nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 659, 'es_ES', 'Centrales térmicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 660, 'es_ES', 'Centros comerciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 661, 'es_ES', 'Centros de cálculo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 662, 'es_ES', 'Centros de documentación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 663, 'es_ES', 'Centros de investigación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 664, 'es_ES', 'Centros docentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 665, 'es_ES', 'Centros nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 666, 'es_ES', 'Cerámica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 667, 'es_ES', 'Cerámica industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 668, 'es_ES', 'Cerdos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 669, 'es_ES', 'Cereales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 670, 'es_ES', 'Cerebro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 671, 'es_ES', 'Ceremonial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 672, 'es_ES', 'Ceremonias religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 673, 'es_ES', 'Cerrajería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 674, 'es_ES', 'Cerrajería artística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 675, 'es_ES', 'Certámenes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 676, 'es_ES', 'Certeza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 677, 'es_ES', 'Cervezas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 678, 'es_ES', 'Cestería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 679, 'es_ES', 'Cetrería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 680, 'es_ES', 'Cibernética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 681, 'es_ES', 'Ciclismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 682, 'es_ES', 'Ciclones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 683, 'es_ES', 'Ciclos económicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 684, 'es_ES', 'Ciclotrones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 685, 'es_ES', 'Ciegos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 686, 'es_ES', 'Cielo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 687, 'es_ES', 'Ciencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 688, 'es_ES', 'Ciencia ficción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 689, 'es_ES', 'Ciencia y religión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 690, 'es_ES', 'Ciencias naturales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 691, 'es_ES', 'Ciencias sociales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 692, 'es_ES', 'Científicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 693, 'es_ES', 'Cimentaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 694, 'es_ES', 'Cine', '', '', '', 'descriptores no clasificados', '', ''),
(1, 695, 'es_ES', 'Cinemática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 696, 'es_ES', 'Cinematografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 697, 'es_ES', 'Cines', '', '', '', 'descriptores no clasificados', '', ''),
(1, 698, 'es_ES', 'Cintas magnéticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 699, 'es_ES', 'Cintas magnetofónicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 700, 'es_ES', 'Circo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 701, 'es_ES', 'Circuitos eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 702, 'es_ES', 'Circuitos electrónicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 703, 'es_ES', 'Circuitos impresos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 704, 'es_ES', 'Circuitos integrados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 705, 'es_ES', 'Circuitos lógicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 706, 'es_ES', 'Circuitos magnéticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 707, 'es_ES', 'Circulación sanguínea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 708, 'es_ES', 'Cirugía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 709, 'es_ES', 'Cirugía infantil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 710, 'es_ES', 'Cirugía plástica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 711, 'es_ES', 'Cirugía veterinaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 712, 'es_ES', 'Citas literarias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 713, 'es_ES', 'Citogenética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 714, 'es_ES', 'Citología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 715, 'es_ES', 'Ciudadanía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 716, 'es_ES', 'Ciudades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 717, 'es_ES', 'Ciudades y pueblos desaparecidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 718, 'es_ES', 'Civilización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 719, 'es_ES', 'Civilización del ocio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 720, 'es_ES', 'Civilización futura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 721, 'es_ES', 'Civilización árabe (judía,griega,etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 722, 'es_ES', 'Clanes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 723, 'es_ES', 'Clase media', '', '', '', 'descriptores no clasificados', '', ''),
(1, 724, 'es_ES', 'Clases sociales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 725, 'es_ES', 'Clasificación bibliográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 726, 'es_ES', 'Clasificación de las ciencias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 727, 'es_ES', 'Clericalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 728, 'es_ES', 'Clero', '', '', '', 'descriptores no clasificados', '', ''),
(1, 729, 'es_ES', 'Clima', '', '', '', 'descriptores no clasificados', '', ''),
(1, 730, 'es_ES', 'Climaterio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 731, 'es_ES', 'Climatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 732, 'es_ES', 'Climatología agrícola', '', '', '', 'descriptores no clasificados', '', ''),
(1, 733, 'es_ES', 'Clorofila', '', '', '', 'descriptores no clasificados', '', ''),
(1, 734, 'es_ES', 'Clubs', '', '', '', 'descriptores no clasificados', '', ''),
(1, 735, 'es_ES', 'Cocaína', '', '', '', 'descriptores no clasificados', '', ''),
(1, 736, 'es_ES', 'Cocina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 737, 'es_ES', 'Cocina española (vasca, c', '', '', '', 'descriptores no clasificados', '', ''),
(1, 738, 'es_ES', 'Cocina vegetariana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 739, 'es_ES', 'Cocinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 740, 'es_ES', 'Codificación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 741, 'es_ES', 'Códigos y claves', '', '', '', 'descriptores no clasificados', '', ''),
(1, 742, 'es_ES', 'Códigos y claves telegráficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 743, 'es_ES', 'Coeducación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 744, 'es_ES', 'Cofradías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 745, 'es_ES', 'Cofradías religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 746, 'es_ES', 'Cogestión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 747, 'es_ES', 'Cojinetes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 748, 'es_ES', 'Colas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 749, 'es_ES', 'Coleccionistas y colecciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 750, 'es_ES', 'Colectivismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 751, 'es_ES', 'Colegios mayores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 752, 'es_ES', 'Colegios profesionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 753, 'es_ES', 'Colegios universitarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 754, 'es_ES', 'Coleópteros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 755, 'es_ES', 'Cólera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 756, 'es_ES', 'Colesterol', '', '', '', 'descriptores no clasificados', '', ''),
(1, 757, 'es_ES', 'Colisiones (Física)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 758, 'es_ES', 'Colmenas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 759, 'es_ES', 'Coloides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 760, 'es_ES', 'Colon', '', '', '', 'descriptores no clasificados', '', ''),
(1, 761, 'es_ES', 'Colonialismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 762, 'es_ES', 'Colonias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 763, 'es_ES', 'Colonias escolares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 764, 'es_ES', 'Colonización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 765, 'es_ES', 'Color', '', '', '', 'descriptores no clasificados', '', ''),
(1, 766, 'es_ES', 'Colorantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 767, 'es_ES', 'Colores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 768, 'es_ES', 'Colorimetría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 769, 'es_ES', 'Columna vertebral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 770, 'es_ES', 'Comadronas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 771, 'es_ES', 'Combinaciones (Matemáticas)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 772, 'es_ES', 'Combustibles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 773, 'es_ES', 'Combustibles nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 774, 'es_ES', 'Combustión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 775, 'es_ES', 'Comedia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 776, 'es_ES', 'Comedores escolares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 777, 'es_ES', 'Comerciantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 778, 'es_ES', 'Comercio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 779, 'es_ES', 'Comercio al por mayor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 780, 'es_ES', 'Comercio al por menor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 781, 'es_ES', 'Comercio ambulante', '', '', '', 'descriptores no clasificados', '', ''),
(1, 782, 'es_ES', 'Comercio exterior', '', '', '', 'descriptores no clasificados', '', ''),
(1, 783, 'es_ES', 'Comercio marítimo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 784, 'es_ES', 'Comercios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 785, 'es_ES', 'Cometas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 786, 'es_ES', 'Comités de empresa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 787, 'es_ES', 'Competencia económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 788, 'es_ES', 'Competencia económica desleal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 789, 'es_ES', 'Complejos (Psicología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 790, 'es_ES', 'Comportamiento social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 791, 'es_ES', 'Composición artística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 792, 'es_ES', 'Composición musical', '', '', '', 'descriptores no clasificados', '', ''),
(1, 793, 'es_ES', 'Composición tipográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 794, 'es_ES', 'Compras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 795, 'es_ES', 'Compraventa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 796, 'es_ES', 'Compuestos químicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 797, 'es_ES', 'Comunicación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 798, 'es_ES', 'Comunicación no verbal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 799, 'es_ES', 'Comunicación social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 800, 'es_ES', 'Comunicaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 801, 'es_ES', 'Comunicaciones vía satélite', '', '', '', 'descriptores no clasificados', '', ''),
(1, 802, 'es_ES', 'Comunidades autónomas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 803, 'es_ES', 'Comunismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 804, 'es_ES', 'Comunistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 805, 'es_ES', 'Concejales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 806, 'es_ES', 'Concentración mental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 807, 'es_ES', 'Conceptos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 808, 'es_ES', 'Concesiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 809, 'es_ES', 'Conciencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 810, 'es_ES', 'Conciencia moral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 811, 'es_ES', 'Conciertos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 812, 'es_ES', 'Conciliación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 813, 'es_ES', 'Conciliación industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 814, 'es_ES', 'Concilios y sínodos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 815, 'es_ES', 'Concordancias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 816, 'es_ES', 'Concordatos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 817, 'es_ES', 'Condecoraciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 818, 'es_ES', 'Condensación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 819, 'es_ES', 'Condensadores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 820, 'es_ES', 'Condominio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 821, 'es_ES', 'Conducta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 822, 'es_ES', 'Conducta moral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 823, 'es_ES', 'Conducta política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 824, 'es_ES', 'Conducta religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 825, 'es_ES', 'Conducta sexual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 826, 'es_ES', 'Conductismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 827, 'es_ES', 'Conductores de automóviles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 828, 'es_ES', 'Conductores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 829, 'es_ES', 'Confirmación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 830, 'es_ES', 'Conflictos internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 831, 'es_ES', 'Conflictos laborales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 832, 'es_ES', 'Confucianismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 833, 'es_ES', 'Congelación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 834, 'es_ES', 'Congresos y asambleas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 835, 'es_ES', 'Congresos y asambleas internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 836, 'es_ES', 'Coníferas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 837, 'es_ES', 'Conjuntos, Teoría de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 838, 'es_ES', 'Conmutadores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 839, 'es_ES', 'Conocimiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 840, 'es_ES', 'Conquistadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 841, 'es_ES', 'Consanguinidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 842, 'es_ES', 'Consejos de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 843, 'es_ES', 'Conservadurismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 844, 'es_ES', 'Conservas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 845, 'es_ES', 'Conservatorios de música', '', '', '', 'descriptores no clasificados', '', ''),
(1, 846, 'es_ES', 'Constelaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 847, 'es_ES', 'Constituciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 848, 'es_ES', 'Construcción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 849, 'es_ES', 'Construcciones antisísmicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 850, 'es_ES', 'Construcciones de ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 851, 'es_ES', 'Construcciones de madera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 852, 'es_ES', 'Construcciones metálicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 853, 'es_ES', 'Cónsules', '', '', '', 'descriptores no clasificados', '', ''),
(1, 854, 'es_ES', 'Consumidores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 855, 'es_ES', 'Consumismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 856, 'es_ES', 'Consumo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 857, 'es_ES', 'Contabilidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 858, 'es_ES', 'Contadores de gas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 859, 'es_ES', 'Contadores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 860, 'es_ES', 'Contadores nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 861, 'es_ES', 'Contaminación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 862, 'es_ES', 'Contaminación industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 863, 'es_ES', 'Contaminación petrolífera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 864, 'es_ES', 'Contaminación radiactiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 865, 'es_ES', 'Contenedores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 866, 'es_ES', 'Continentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 867, 'es_ES', 'Contrabando', '', '', '', 'descriptores no clasificados', '', ''),
(1, 868, 'es_ES', 'Contracultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 869, 'es_ES', 'Contrapunto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 870, 'es_ES', 'Contratos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 871, 'es_ES', 'Contratos de trabajo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 872, 'es_ES', 'Control a distancia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 873, 'es_ES', 'Control automático', '', '', '', 'descriptores no clasificados', '', ''),
(1, 874, 'es_ES', 'Control bibliográfico universal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 875, 'es_ES', 'Control de calidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 876, 'es_ES', 'Convenios colectivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 877, 'es_ES', 'Conventos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 878, 'es_ES', 'Convergencia (Matemáticas)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 879, 'es_ES', 'Conversión religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 880, 'es_ES', 'Conversos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 881, 'es_ES', 'Convertidores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 882, 'es_ES', 'Cooperación científica y técnica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 883, 'es_ES', 'Cooperación cultural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 884, 'es_ES', 'Cooperación económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 885, 'es_ES', 'Cooperación educativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 886, 'es_ES', 'Cooperación internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 887, 'es_ES', 'Cooperativas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 888, 'es_ES', 'Cooperativas de crédito', '', '', '', 'descriptores no clasificados', '', ''),
(1, 889, 'es_ES', 'Cooperativismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 890, 'es_ES', 'Coordenadas geográficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 891, 'es_ES', 'Corán', '', '', '', 'descriptores no clasificados', '', ''),
(1, 892, 'es_ES', 'Corazón', '', '', '', 'descriptores no clasificados', '', ''),
(1, 893, 'es_ES', 'Cordelería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 894, 'es_ES', 'Coreografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 895, 'es_ES', 'Coros (Música)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 896, 'es_ES', 'Corporaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 897, 'es_ES', 'Corporativismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 898, 'es_ES', 'Corpúsculos sanguíneos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 899, 'es_ES', 'Correas de transmisión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 900, 'es_ES', 'Corredores de bolsa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 901, 'es_ES', 'Correlación (Estadística)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 902, 'es_ES', 'Correos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 903, 'es_ES', 'Correspondencia comercial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 904, 'es_ES', 'Corresponsales de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 905, 'es_ES', 'Corresponsales extranjeros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 906, 'es_ES', 'Corridas de toros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 907, 'es_ES', 'Corrientes oceánicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 908, 'es_ES', 'Corrosión y anticorrosivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 909, 'es_ES', 'Corrupción administrativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 910, 'es_ES', 'Corrupción política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 911, 'es_ES', 'Corte v cortesanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 912, 'es_ES', 'Corte y confección', '', '', '', 'descriptores no clasificados', '', ''),
(1, 913, 'es_ES', 'Corte y cortesanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 914, 'es_ES', 'Cosmética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 915, 'es_ES', 'Cosméticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 916, 'es_ES', 'Cosmogonía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 917, 'es_ES', 'Cosmografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 918, 'es_ES', 'Cosmología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 919, 'es_ES', 'Costas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 920, 'es_ES', 'Coste de vida', '', '', '', 'descriptores no clasificados', '', ''),
(1, 921, 'es_ES', 'Costos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 922, 'es_ES', 'Costos de mano de obra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 923, 'es_ES', 'Costos de producción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 924, 'es_ES', 'Costura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 925, 'es_ES', 'Cotos de caza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 926, 'es_ES', 'Cráneo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 927, 'es_ES', 'Creación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 928, 'es_ES', 'Creación artística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 929, 'es_ES', 'Creación literaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 930, 'es_ES', 'Creatividad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 931, 'es_ES', 'Crédito', '', '', '', 'descriptores no clasificados', '', ''),
(1, 932, 'es_ES', 'Credos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 933, 'es_ES', 'Creencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 934, 'es_ES', 'Crimen y criminales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 935, 'es_ES', 'Crímenes de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 936, 'es_ES', 'Criminología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 937, 'es_ES', 'Crioterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 938, 'es_ES', 'Criptógamas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 939, 'es_ES', 'Criptografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 940, 'es_ES', 'Crisis económicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 941, 'es_ES', 'Cristales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 942, 'es_ES', 'Cristalografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 943, 'es_ES', 'Cristianismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 944, 'es_ES', 'Cristianismo y judaísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 945, 'es_ES', 'Cristianos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 946, 'es_ES', 'Cristología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 947, 'es_ES', 'Crítica artística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 948, 'es_ES', 'Crítica cinematográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 949, 'es_ES', 'Crítica literaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 950, 'es_ES', 'Crítica teatral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 951, 'es_ES', 'Crítica textual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 952, 'es_ES', 'Críticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 953, 'es_ES', 'Cromatografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 954, 'es_ES', 'Cromosomas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 955, 'es_ES', 'Cronología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 956, 'es_ES', 'Cronología geológica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 957, 'es_ES', 'Cronología griega (mejicana, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 958, 'es_ES', 'Cronología por radiocarbono', '', '', '', 'descriptores no clasificados', '', ''),
(1, 959, 'es_ES', 'Cronómetros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 960, 'es_ES', 'Cruces', '', '', '', 'descriptores no clasificados', '', ''),
(1, 961, 'es_ES', 'Crueldad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 962, 'es_ES', 'Crustáceos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 963, 'es_ES', 'Cruzadas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 964, 'es_ES', 'Cuáqueros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 965, 'es_ES', 'Cuarentena', '', '', '', 'descriptores no clasificados', '', ''),
(1, 966, 'es_ES', 'Cuaresma', '', '', '', 'descriptores no clasificados', '', ''),
(1, 967, 'es_ES', 'Cuarzo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 968, 'es_ES', 'Cubiertas (Construcción)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 969, 'es_ES', 'Cubismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 970, 'es_ES', 'Cuentas corrientes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 971, 'es_ES', 'Cuento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 972, 'es_ES', 'Cuentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 973, 'es_ES', 'Cuentos españoles (franceses,ingleses,etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 974, 'es_ES', 'Cuerdas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 975, 'es_ES', 'Cuero', '', '', '', 'descriptores no clasificados', '', ''),
(1, 976, 'es_ES', 'Cuerpo ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 977, 'es_ES', 'Cuevas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 978, 'es_ES', 'Culpa jurídica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 979, 'es_ES', 'Culpa moral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 980, 'es_ES', 'Cultivos de regadío', '', '', '', 'descriptores no clasificados', '', ''),
(1, 981, 'es_ES', 'Cultivos de secano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 982, 'es_ES', 'Cultivos extensivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 983, 'es_ES', 'Culto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 984, 'es_ES', 'Cultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 985, 'es_ES', 'Cultura de masas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 986, 'es_ES', 'Cultura popular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 987, 'es_ES', 'Curación por la fe', '', '', '', 'descriptores no clasificados', '', ''),
(1, 988, 'es_ES', 'Curanderos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 989, 'es_ES', 'Curia romana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 990, 'es_ES', 'Curtidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 991, 'es_ES', 'Curvas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 992, 'es_ES', 'Dactiloscopia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 993, 'es_ES', 'Dadaísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 994, 'es_ES', 'Dados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 995, 'es_ES', 'Daguerrotipo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 996, 'es_ES', 'Danza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 997, 'es_ES', 'Daños de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 998, 'es_ES', 'Dársenas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 999, 'es_ES', 'Datos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1000, 'es_ES', 'Deber', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1001, 'es_ES', 'Decisiones, Toma de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1002, 'es_ES', 'Decoración floral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1003, 'es_ES', 'Decoración interior', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1004, 'es_ES', 'Deducción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1005, 'es_ES', 'Defensa civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1006, 'es_ES', 'Defensa nacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1007, 'es_ES', 'Defensa penal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1008, 'es_ES', 'Defensas aéreas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1009, 'es_ES', 'Defensor del pueblo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1010, 'es_ES', 'Deficiencia mental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1011, 'es_ES', 'Deflación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1012, 'es_ES', 'Deformidades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1013, 'es_ES', 'Deísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1014, 'es_ES', 'Delincuencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1015, 'es_ES', 'Delincuencia juvenil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1016, 'es_ES', 'Delincuentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1017, 'es_ES', 'Delitos contra la persona', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1018, 'es_ES', 'Delitos contra la propiedad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1019, 'es_ES', 'Delitos electorales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1020, 'es_ES', 'Delitos fiscales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1021, 'es_ES', 'Delitos políticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1022, 'es_ES', 'Delitos sexuales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1023, 'es_ES', 'Delitos y faltas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1024, 'es_ES', 'Democracia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1025, 'es_ES', 'Democratización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1026, 'es_ES', 'Demografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1027, 'es_ES', 'Demolición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1028, 'es_ES', 'Demonio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1029, 'es_ES', 'Demonología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1030, 'es_ES', 'Deontología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1031, 'es_ES', 'Dependientes de comercio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1032, 'es_ES', 'Deportación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1033, 'es_ES', 'Deportes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1034, 'es_ES', 'Deportes acuáticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1035, 'es_ES', 'Deportes aéreos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1036, 'es_ES', 'Deportes de invierno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1037, 'es_ES', 'Deportes de luc', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1038, 'es_ES', 'Deportes del motor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1039, 'es_ES', 'Deportes náuticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1040, 'es_ES', 'Deportistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1041, 'es_ES', 'Depósito legal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1042, 'es_ES', 'Depósitos bancarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1043, 'es_ES', 'Depósitos de agua', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1044, 'es_ES', 'Depresión mental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1045, 'es_ES', 'Deriva continental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1046, 'es_ES', 'Dermatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1047, 'es_ES', 'Desamortización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1048, 'es_ES', 'Desarme', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1049, 'es_ES', 'Desarrollo agrícola', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1050, 'es_ES', 'Desarrollo económico y social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1051, 'es_ES', 'Desarrollo industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1052, 'es_ES', 'Descanso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1053, 'es_ES', 'Descargas eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1054, 'es_ES', 'Descentralización administrativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1055, 'es_ES', 'Descubrimientos científicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1056, 'es_ES', 'Descubrimientos geográficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1057, 'es_ES', 'Desiertos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1058, 'es_ES', 'Desigualdad social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1059, 'es_ES', 'Desinfección', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1060, 'es_ES', 'Desnutrición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1061, 'es_ES', 'Despido', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1062, 'es_ES', 'Destilación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1063, 'es_ES', 'Detectives', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1064, 'es_ES', 'Detención', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1065, 'es_ES', 'Detergentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1066, 'es_ES', 'Determinismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1067, 'es_ES', 'Deuda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1068, 'es_ES', 'Deuda exterior', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1069, 'es_ES', 'Deuda pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1070, 'es_ES', 'Devocionarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1071, 'es_ES', 'Devociones populares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1072, 'es_ES', 'Diabetes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1073, 'es_ES', 'Diagnóstico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1074, 'es_ES', 'Diagnóstico quirúrgico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1075, 'es_ES', 'Dialéctica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1076, 'es_ES', 'Dialectología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1077, 'es_ES', 'Diálisis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1078, 'es_ES', 'Diapositivas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1079, 'es_ES', 'Dibujo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1080, 'es_ES', 'Dibujo geométrico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1081, 'es_ES', 'Dibujo publicitario', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1082, 'es_ES', 'Dibujo técnico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1083, 'es_ES', 'Dibujos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1084, 'es_ES', 'Dibujos animados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1085, 'es_ES', 'Diccionarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1086, 'es_ES', 'Diccionarios políglotas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1087, 'es_ES', 'Dictadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1088, 'es_ES', 'Dictadura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1089, 'es_ES', 'Dictadura del proletariado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1090, 'es_ES', 'Didáctica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1091, 'es_ES', 'Dientes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1092, 'es_ES', 'Dietética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1093, 'es_ES', 'Diezmos y primicias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1094, 'es_ES', 'Difamación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1095, 'es_ES', 'Difracción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1096, 'es_ES', 'Difusión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1097, 'es_ES', 'Digestión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1098, 'es_ES', 'Dilatación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1099, 'es_ES', 'Dinámica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1100, 'es_ES', 'Dinámica de fluidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1101, 'es_ES', 'Dinamos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1102, 'es_ES', 'Diócesis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1103, 'es_ES', 'Dios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1104, 'es_ES', 'Dioses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1105, 'es_ES', 'Diplomacia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1106, 'es_ES', 'Diplomática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1107, 'es_ES', 'Diplomáticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1108, 'es_ES', 'Diputaciones provinciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1109, 'es_ES', 'Diques', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1110, 'es_ES', 'Directores de cine', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1111, 'es_ES', 'Directores de orquesta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1112, 'es_ES', 'Directores de teatro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1113, 'es_ES', 'Disciplina escolar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1114, 'es_ES', 'Disciplina militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1115, 'es_ES', 'Discos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1116, 'es_ES', 'Discos magnéticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1117, 'es_ES', 'Discriminación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1118, 'es_ES', 'Discriminación cultural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1119, 'es_ES', 'Discriminación educativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1120, 'es_ES', 'Discriminación religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1121, 'es_ES', 'Disección', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1122, 'es_ES', 'Diseño', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1123, 'es_ES', 'Diseño artístico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1124, 'es_ES', 'Diseño industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1125, 'es_ES', 'Disminuidos físicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1126, 'es_ES', 'Disminuidos mentales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1127, 'es_ES', 'Disolventes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1128, 'es_ES', 'Disturbios civiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1129, 'es_ES', 'Diuréticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1130, 'es_ES', 'Diversiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1131, 'es_ES', 'Dividendos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1132, 'es_ES', 'División del trabajo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1133, 'es_ES', 'Divorcio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1134, 'es_ES', 'Doble imposición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1135, 'es_ES', 'Documentación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1136, 'es_ES', 'Documentalistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1137, 'es_ES', 'Documentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1138, 'es_ES', 'Documentos pontificios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1139, 'es_ES', 'Documentos públicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1140, 'es_ES', 'Dolor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1141, 'es_ES', 'Domadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1142, 'es_ES', 'Dominio público', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1143, 'es_ES', 'Dote', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1144, 'es_ES', 'Dragado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1145, 'es_ES', 'Dramatizaciones (Enseñanza)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1146, 'es_ES', 'Drenaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1147, 'es_ES', 'Drenaje quirúrgico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1148, 'es_ES', 'Drogadictos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1149, 'es_ES', 'Drogas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1150, 'es_ES', 'Duelos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1151, 'es_ES', 'Ebanistería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1152, 'es_ES', 'Ebullición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1153, 'es_ES', 'Eclipses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1154, 'es_ES', 'Eclipses lunares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1155, 'es_ES', 'Eclipses solares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1156, 'es_ES', 'Ecología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1157, 'es_ES', 'Ecología animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1158, 'es_ES', 'Ecología vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1159, 'es_ES', 'Econometría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1160, 'es_ES', 'Economía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1161, 'es_ES', 'Economía comunista', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1162, 'es_ES', 'Economía de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1163, 'es_ES', 'Economía de libre mercado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1164, 'es_ES', 'Economía doméstica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1165, 'es_ES', 'Economía internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1166, 'es_ES', 'Economía mixta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1167, 'es_ES', 'Economía mundial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1168, 'es_ES', 'Economía planificada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1169, 'es_ES', 'Economistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1170, 'es_ES', 'Ecosistemas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1171, 'es_ES', 'Ecuaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1172, 'es_ES', 'Ecuaciones diferenciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1173, 'es_ES', 'Ecuaciones integrales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1174, 'es_ES', 'Ecumenismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1175, 'es_ES', 'Edad antigua', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1176, 'es_ES', 'Edad contemporánea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1177, 'es_ES', 'Edad de Piedra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1178, 'es_ES', 'Edad del ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1179, 'es_ES', 'Edad del bronce', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1180, 'es_ES', 'Edad media', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1181, 'es_ES', 'Edad moderna', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1182, 'es_ES', 'Edafología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1183, 'es_ES', 'Edición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1184, 'es_ES', 'Ediciones de bibliófilo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1185, 'es_ES', 'Edificios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1186, 'es_ES', 'Edificios académicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1187, 'es_ES', 'Edificios agrícolas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1188, 'es_ES', 'Edificios para la enseñanza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1189, 'es_ES', 'Edificios prefabricados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1190, 'es_ES', 'Editores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1191, 'es_ES', 'Editoriales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1192, 'es_ES', 'Educación ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1193, 'es_ES', 'Educación comparada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1194, 'es_ES', 'Educación de adultos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1195, 'es_ES', 'Educación de la mujer', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1196, 'es_ES', 'Educación de niños', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1197, 'es_ES', 'Educación especial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1198, 'es_ES', 'Educación física', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1199, 'es_ES', 'Educación moral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1200, 'es_ES', 'Educación permanente', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1201, 'es_ES', 'Educación religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1202, 'es_ES', 'Educación sanitaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1203, 'es_ES', 'Educación sexual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1204, 'es_ES', 'Educación y desarrollo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1205, 'es_ES', 'Educación y empleo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1206, 'es_ES', 'Efemérides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1207, 'es_ES', 'Ego (Psicología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1208, 'es_ES', 'Ejecutivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1209, 'es_ES', 'Ejercicio físico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1210, 'es_ES', 'Ejercicios espirituales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1211, 'es_ES', 'Ejército de tierra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1212, 'es_ES', 'Ejército del aire', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1213, 'es_ES', 'Elasticidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1214, 'es_ES', 'Elecciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1215, 'es_ES', 'Elecciones municipales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1216, 'es_ES', 'Electricidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1217, 'es_ES', 'Electricidad atmosférica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1218, 'es_ES', 'Electroacústica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1219, 'es_ES', 'Electrocardiografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1220, 'es_ES', 'Electrodiagnóstico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1221, 'es_ES', 'Electrodinámica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1222, 'es_ES', 'Electrodomésticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1223, 'es_ES', 'Electroencefalografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1224, 'es_ES', 'Electrólisis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1225, 'es_ES', 'Electromagnetismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1226, 'es_ES', 'Electrones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1227, 'es_ES', 'Electrónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1228, 'es_ES', 'Electroquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1229, 'es_ES', 'Electrostática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1230, 'es_ES', 'Electrotecnia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1231, 'es_ES', 'Electroterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1232, 'es_ES', 'Elementos químicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1233, 'es_ES', 'Elites', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1234, 'es_ES', 'Embalajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1235, 'es_ES', 'Embalses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1236, 'es_ES', 'Embarazo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1237, 'es_ES', 'Embargo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1238, 'es_ES', 'Emblemas nacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1239, 'es_ES', 'Embolias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1240, 'es_ES', 'Embriaguez', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1241, 'es_ES', 'Embriología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1242, 'es_ES', 'Embriología animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1243, 'es_ES', 'Embriología vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1244, 'es_ES', 'Embutidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1245, 'es_ES', 'Emigración e inmigración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1246, 'es_ES', 'Emigrantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1247, 'es_ES', 'Emisoras de radio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1248, 'es_ES', 'Emociones y sentimientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1249, 'es_ES', 'Empirismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1250, 'es_ES', 'Empleo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1251, 'es_ES', 'Empresarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1252, 'es_ES', 'Empresas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1253, 'es_ES', 'Empresas extranjeras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1254, 'es_ES', 'Empresas grandes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1255, 'es_ES', 'Empresas mixtas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1256, 'es_ES', 'Empresas privadas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1257, 'es_ES', 'Empresas públicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1258, 'es_ES', 'Encabezamientos de materia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1259, 'es_ES', 'Encabezamientosdemateriaespaño-', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1260, 'es_ES', 'Encíclicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1261, 'es_ES', 'Enciclopedias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1262, 'es_ES', 'Encuadernación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1263, 'es_ES', 'Endogamia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1264, 'es_ES', 'Endoscopia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1265, 'es_ES', 'Energía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1266, 'es_ES', 'Energía ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1267, 'es_ES', 'Energía eléctrica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1268, 'es_ES', 'Energía eólica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1269, 'es_ES', 'Energía geotérmica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1270, 'es_ES', 'Energía mecánica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1271, 'es_ES', 'Energía nuclear', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1272, 'es_ES', 'Energía solar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1273, 'es_ES', 'Energía térmica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1274, 'es_ES', 'Enfermedades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1275, 'es_ES', 'Enfermedades carenciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1276, 'es_ES', 'Enfermedades contagiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1277, 'es_ES', 'Enfermedades infecciosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1278, 'es_ES', 'Enfermedades mentales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1279, 'es_ES', 'Enfermedades parasitarias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1280, 'es_ES', 'Enfermedades profesionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1281, 'es_ES', 'Enfermedades tropicales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1282, 'es_ES', 'Enfermedades venéreas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1283, 'es_ES', 'Enfermeras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1284, 'es_ES', 'Enfermos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1285, 'es_ES', 'Enfermos mentales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1286, 'es_ES', 'Ensayo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1287, 'es_ES', 'Ensayos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1288, 'es_ES', 'Enseñanza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1289, 'es_ES', 'Enseñanza audiovisual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1290, 'es_ES', 'Enseñanza católica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1291, 'es_ES', 'Enseñanza confesional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1292, 'es_ES', 'Enseñanza en equipo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1293, 'es_ES', 'Enseñanza general básica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1294, 'es_ES', 'Enseñanza gratuita', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1295, 'es_ES', 'Enseñanza individualizada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1296, 'es_ES', 'Enseñanza laica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1297, 'es_ES', 'Enseñanza por correspondencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1298, 'es_ES', 'Enseñanza preescolar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1299, 'es_ES', 'Enseñanza primaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1300, 'es_ES', 'Enseñanza privada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1301, 'es_ES', 'Enseñanza profesional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1302, 'es_ES', 'Enseñanza programada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1303, 'es_ES', 'Enseñanza pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1304, 'es_ES', 'Enseñanza secundaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1305, 'es_ES', 'Enseñanza superior', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1306, 'es_ES', 'Entomología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1307, 'es_ES', 'Entremeses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1308, 'es_ES', 'Entrevistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1309, 'es_ES', 'Envases', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1310, 'es_ES', 'Envenenamiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1311, 'es_ES', 'Envidia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1312, 'es_ES', 'Enzimas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1313, 'es_ES', 'Epicureismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1314, 'es_ES', 'Epidemias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1315, 'es_ES', 'Epidemiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1316, 'es_ES', 'Epigrafía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1317, 'es_ES', 'Epigramas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1318, 'es_ES', 'Epilepsia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1319, 'es_ES', 'Epistemología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1320, 'es_ES', 'Equilibrio químico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1321, 'es_ES', 'Equilibristas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1322, 'es_ES', 'Equinodermos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1323, 'es_ES', 'Equitación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1324, 'es_ES', 'Eras geológicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1325, 'es_ES', 'Eritrocitos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1326, 'es_ES', 'Erosión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1327, 'es_ES', 'Erotismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1328, 'es_ES', 'Erupciones volcánicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1329, 'es_ES', 'Escaladores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1330, 'es_ES', 'Escaleras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1331, 'es_ES', 'Escaparates', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1332, 'es_ES', 'Escatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1333, 'es_ES', 'Escatología cristiana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1334, 'es_ES', 'Escenografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1335, 'es_ES', 'Escepticismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1336, 'es_ES', 'Esclavitud', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1337, 'es_ES', 'Esclavos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1338, 'es_ES', 'Esclusas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1339, 'es_ES', 'Escolares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1340, 'es_ES', 'Escolasticismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1341, 'es_ES', 'Escritores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1342, 'es_ES', 'Escritura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1343, 'es_ES', 'Escritura cuneiforme', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1344, 'es_ES', 'Escritura ideográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1345, 'es_ES', 'Escritura jeroglífica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1346, 'es_ES', 'Escudos de armas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1347, 'es_ES', 'Escuelas de verano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1348, 'es_ES', 'Escuelas nocturnas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1349, 'es_ES', 'Escuelas técnicas superiores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1350, 'es_ES', 'Escuelas universitarias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1351, 'es_ES', 'Escultores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1352, 'es_ES', 'Escultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1353, 'es_ES', 'Escultura en madera (metal, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1354, 'es_ES', 'Esgrima', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1355, 'es_ES', 'Esmaltes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1356, 'es_ES', 'Espacio exterior', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1357, 'es_ES', 'Espacio y tiempo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1358, 'es_ES', 'Espacios analíticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1359, 'es_ES', 'Espacios complejos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1360, 'es_ES', 'Espacios generalizados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1361, 'es_ES', 'Espacios métricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1362, 'es_ES', 'Espacios topológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1363, 'es_ES', 'Espadas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1364, 'es_ES', 'Españoles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1365, 'es_ES', 'Espectáculos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1366, 'es_ES', 'Espectrografía.', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1367, 'es_ES', 'Espectroscopia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1368, 'es_ES', 'Espejos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1369, 'es_ES', 'Espeleología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1370, 'es_ES', 'Esperanto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1371, 'es_ES', 'Esperanza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1372, 'es_ES', 'Espionaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1373, 'es_ES', 'Espionaje industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1374, 'es_ES', 'Espiritismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1375, 'es_ES', 'Espíritu Santo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1376, 'es_ES', 'Espiritualidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1377, 'es_ES', 'Esqueleto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1378, 'es_ES', 'Esquizofrenia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1379, 'es_ES', 'Establecimientos penitenciarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1380, 'es_ES', 'Establos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1381, 'es_ES', 'Estaciones de servicio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1382, 'es_ES', 'Estaciones del año', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1383, 'es_ES', 'Estaciones espaciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1384, 'es_ES', 'Estadística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1385, 'es_ES', 'Estadística de población', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1386, 'es_ES', 'Estadística matemática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1387, 'es_ES', 'Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1388, 'es_ES', 'Estado corporativo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1389, 'es_ES', 'Estática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1390, 'es_ES', 'Estatuas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1391, 'es_ES', 'Estenotipia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1392, 'es_ES', 'Estepas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1393, 'es_ES', 'Esterilidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1394, 'es_ES', 'Esterilización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1395, 'es_ES', 'Estética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1396, 'es_ES', 'Estética literaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1397, 'es_ES', 'Estigmatizados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1398, 'es_ES', 'Estilística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1399, 'es_ES', 'Estoicismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1400, 'es_ES', 'Estómago', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1401, 'es_ES', 'Estomatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1402, 'es_ES', 'Estrategia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1403, 'es_ES', 'Estrategia naval', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1404, 'es_ES', 'Estratigrafía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1405, 'es_ES', 'Estrellas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1406, 'es_ES', 'Estructuralismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1407, 'es_ES', 'Estructuras (Construcción)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1408, 'es_ES', 'Estructuras metálicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1409, 'es_ES', 'Estudiantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1410, 'es_ES', 'Estudiantes extranjeros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1411, 'es_ES', 'Estudiantes universitarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1412, 'es_ES', 'Esvástica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1413, 'es_ES', 'Eteres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1414, 'es_ES', 'Eternidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1415, 'es_ES', 'Ética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1416, 'es_ES', 'Ética deportiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1417, 'es_ES', 'Ética política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1418, 'es_ES', 'Etiología médica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1419, 'es_ES', 'Etiqueta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1420, 'es_ES', 'Etnolingüística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1421, 'es_ES', 'Etnología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1422, 'es_ES', 'Etnopsicología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1423, 'es_ES', 'Eucaristía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1424, 'es_ES', 'Eugenesia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1425, 'es_ES', 'Eurocomunismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1426, 'es_ES', 'Eutanasia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1427, 'es_ES', 'Evangelistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1428, 'es_ES', 'Evaporación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1429, 'es_ES', 'Evasión fiscal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1430, 'es_ES', 'Evolución', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1431, 'es_ES', 'Evolucionismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1432, 'es_ES', 'Ex libris', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1433, 'es_ES', 'Exámenes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1434, 'es_ES', 'Excavación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1435, 'es_ES', 'Excavaciones arqueológicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1436, 'es_ES', 'Excavadoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1437, 'es_ES', 'Excomunión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1438, 'es_ES', 'Excursionismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1439, 'es_ES', 'Exégesis bíblica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1440, 'es_ES', 'Exiliados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1441, 'es_ES', 'Existencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1442, 'es_ES', 'Existencialismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1443, 'es_ES', 'Exogamia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1444, 'es_ES', 'Exorcismos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1445, 'es_ES', 'Expediciones científicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1446, 'es_ES', 'Experiencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1447, 'es_ES', 'Exploraciones geográficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1448, 'es_ES', 'Exploradores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1449, 'es_ES', 'Explosiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1450, 'es_ES', 'Explosiones nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1451, 'es_ES', 'Explosivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1452, 'es_ES', 'Exportación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1453, 'es_ES', 'Exposiciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1454, 'es_ES', 'Expresionismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1455, 'es_ES', 'Expropiación forzosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1456, 'es_ES', 'Extensión bibliotecaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1457, 'es_ES', 'Extranjeros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1458, 'es_ES', 'Extraterritorialidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1459, 'es_ES', 'Extremaunción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1460, 'es_ES', 'Fábricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1461, 'es_ES', 'Fábulas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1462, 'es_ES', 'Facsímiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1463, 'es_ES', 'Factor R', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1464, 'es_ES', 'Fallas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1465, 'es_ES', 'Falsificación de moneda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1466, 'es_ES', 'Familia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1467, 'es_ES', 'Fanatismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1468, 'es_ES', 'Fanerógamas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1469, 'es_ES', 'Farmacéuticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1470, 'es_ES', 'Farmacias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1471, 'es_ES', 'Farmacología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1472, 'es_ES', 'Faros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1473, 'es_ES', 'Fascismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1474, 'es_ES', 'Fatiga', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1475, 'es_ES', 'Fauna', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1476, 'es_ES', 'Fauna alpina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1477, 'es_ES', 'Fauna de agua dulce', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1478, 'es_ES', 'Fauna desértica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1479, 'es_ES', 'Fauna marina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1480, 'es_ES', 'Fauna tropical', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1481, 'es_ES', 'Fauvismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1482, 'es_ES', 'Fe', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1483, 'es_ES', 'Fecundación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1484, 'es_ES', 'Fecundidad ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1485, 'es_ES', 'Federalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1486, 'es_ES', 'Felicidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1487, 'es_ES', 'Feminismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1488, 'es_ES', 'Fenomenología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1489, 'es_ES', 'Fenómenos sobrenaturales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1490, 'es_ES', 'Ferias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1491, 'es_ES', 'Fermentación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1492, 'es_ES', 'Ferrerías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1493, 'es_ES', 'Ferrocarriles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1494, 'es_ES', 'Ferrocarriles eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1495, 'es_ES', 'Ferrocarriles metropolitanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1496, 'es_ES', 'Ferroelectricidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1497, 'es_ES', 'Ferromagnetismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1498, 'es_ES', 'Fertilidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1499, 'es_ES', 'Fertilizantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1500, 'es_ES', 'Festivales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1501, 'es_ES', 'Festivales cinematográficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1502, 'es_ES', 'Festivales deportivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1503, 'es_ES', 'Festivales teatrales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1504, 'es_ES', 'Feto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1505, 'es_ES', 'Feudalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1506, 'es_ES', 'Fibras sintéticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1507, 'es_ES', 'Fibras textiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1508, 'es_ES', 'Fibras vegetales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1509, 'es_ES', 'Fideicomiso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1510, 'es_ES', 'Fideicomisos internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1511, 'es_ES', 'Fiebre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1512, 'es_ES', 'Fiestas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1513, 'es_ES', 'Fiestas religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1514, 'es_ES', 'Figuras del lenguaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1515, 'es_ES', 'Figuras geométricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1516, 'es_ES', 'Filatelia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1517, 'es_ES', 'Filiación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1518, 'es_ES', 'Filigranas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1519, 'es_ES', 'Filmotecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1520, 'es_ES', 'Filología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1521, 'es_ES', 'Filosofía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1522, 'es_ES', 'Filósofos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1523, 'es_ES', 'Filoxera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1524, 'es_ES', 'Filtros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1525, 'es_ES', 'Finanzas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1526, 'es_ES', 'Finanzas internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1527, 'es_ES', 'Fiscales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1528, 'es_ES', 'Física de sólidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1529, 'es_ES', 'Física estadística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1530, 'es_ES', 'Física matemática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1531, 'es_ES', 'Física molecular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1532, 'es_ES', 'Física nuclear', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1533, 'es_ES', 'Física recreativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1534, 'es_ES', 'Fisiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1535, 'es_ES', 'Fisiología ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1536, 'es_ES', 'Fisiología animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1537, 'es_ES', 'Fisiología vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1538, 'es_ES', 'Fisioterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1539, 'es_ES', 'Fisonomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1540, 'es_ES', 'Fitogeografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1541, 'es_ES', 'Fitoplancton', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1542, 'es_ES', 'Fitoquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1543, 'es_ES', 'Flamenco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1544, 'es_ES', 'Fletes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1545, 'es_ES', 'Flora', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1546, 'es_ES', 'Flora alpina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1547, 'es_ES', 'Flora de agua dulce', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1548, 'es_ES', 'Flora desértica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1549, 'es_ES', 'Flora marina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1550, 'es_ES', 'Flora tropical', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1551, 'es_ES', 'Flores artificiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1552, 'es_ES', 'Floricultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1553, 'es_ES', 'Fluidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1554, 'es_ES', 'Fluorescencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1555, 'es_ES', 'Folklore', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1556, 'es_ES', 'Fonética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1557, 'es_ES', 'Fonología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1558, 'es_ES', 'Fonotecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1559, 'es_ES', 'Fontanería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1560, 'es_ES', 'Forja', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1561, 'es_ES', 'Formas musicales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1562, 'es_ES', 'Forrajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1563, 'es_ES', 'Fortificaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1564, 'es_ES', 'Fosas sépticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1565, 'es_ES', 'Fosforescencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1566, 'es_ES', 'Fósiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1567, 'es_ES', 'Fotocomposición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1568, 'es_ES', 'Fotocopia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1569, 'es_ES', 'Fotoelectricidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1570, 'es_ES', 'Fotograbado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1571, 'es_ES', 'Fotografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1572, 'es_ES', 'Fotografía aérea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1573, 'es_ES', 'Fotografía artística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1574, 'es_ES', 'Fotografía publicitaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1575, 'es_ES', 'Fotografía submarina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1576, 'es_ES', 'Fotolitografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1577, 'es_ES', 'Fotomicrografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1578, 'es_ES', 'Fotoquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1579, 'es_ES', 'Fourier, Análisis de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1580, 'es_ES', 'Fracturas óseas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1581, 'es_ES', 'Fratricidio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1582, 'es_ES', 'Fraude', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1583, 'es_ES', 'Frenos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1584, 'es_ES', 'Fresadoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1585, 'es_ES', 'Frigoríficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1586, 'es_ES', 'Frío', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1587, 'es_ES', 'Frío industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1588, 'es_ES', 'Fronteras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1589, 'es_ES', 'Frutas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1590, 'es_ES', 'Fruticultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1591, 'es_ES', 'Frutos secos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1592, 'es_ES', 'Fuego', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1593, 'es_ES', 'Fuel oil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1594, 'es_ES', 'Fuentes monumentales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1595, 'es_ES', 'Fuentes termales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1596, 'es_ES', 'Fuero eclesiástico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1597, 'es_ES', 'Fueros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1598, 'es_ES', 'Fuerzas armadas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1599, 'es_ES', 'Fuga de cerebros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1600, 'es_ES', 'Fumigación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1601, 'es_ES', 'Funcionarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1602, 'es_ES', 'Funciones matemáticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1603, 'es_ES', 'Fundaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1604, 'es_ES', 'Fundaciones pías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1605, 'es_ES', 'Fundición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1606, 'es_ES', 'Funerales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1607, 'es_ES', 'Fungicidas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1608, 'es_ES', 'Funiculares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1609, 'es_ES', 'Fusión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1610, 'es_ES', 'Fútbol', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1611, 'es_ES', 'Futbolistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1612, 'es_ES', 'Futurismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1613, 'es_ES', 'Futurología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1614, 'es_ES', 'Galaxias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1615, 'es_ES', 'Galerías de arte', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1616, 'es_ES', 'Galicanismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1617, 'es_ES', 'Galvanotecnia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1618, 'es_ES', 'Ganadería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1619, 'es_ES', 'Ganaderías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1620, 'es_ES', 'Ganaderos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1621, 'es_ES', 'Ganado lanar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1622, 'es_ES', 'Ganado vacuno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1623, 'es_ES', 'Gangrena', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1624, 'es_ES', 'Garajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1625, 'es_ES', 'Gas ciudad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1626, 'es_ES', 'Gases', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1627, 'es_ES', 'Gases naturales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1628, 'es_ES', 'Gasolina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1629, 'es_ES', 'Gasto público', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1630, 'es_ES', 'Gastronomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1631, 'es_ES', 'Genealogía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1632, 'es_ES', 'Generadores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1633, 'es_ES', 'Generales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1634, 'es_ES', 'Géneros literarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1635, 'es_ES', 'Genes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1636, 'es_ES', 'Genética ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1637, 'es_ES', 'Genética animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1638, 'es_ES', 'Genética microbiana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1639, 'es_ES', 'Genética vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1640, 'es_ES', 'Genocidio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1641, 'es_ES', 'Geodesia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1642, 'es_ES', 'Geodinámica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1643, 'es_ES', 'Geofísica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1644, 'es_ES', 'Geografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1645, 'es_ES', 'Geografía antigua', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1646, 'es_ES', 'Geografía económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1647, 'es_ES', 'Geografía física', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1648, 'es_ES', 'Geografía lingüística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1649, 'es_ES', 'Geografía política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1650, 'es_ES', 'Geógrafos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1651, 'es_ES', 'Geología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1652, 'es_ES', 'Geología económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1653, 'es_ES', 'Geología submarina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1654, 'es_ES', 'Geólogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1655, 'es_ES', 'Geometría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1656, 'es_ES', 'Geometría descriptiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1657, 'es_ES', 'Geometría diferencial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1658, 'es_ES', 'Geomorfología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1659, 'es_ES', 'Geopolítica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1660, 'es_ES', 'Geoquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1661, 'es_ES', 'Geriatría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1662, 'es_ES', 'Gérmenes patógenos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1663, 'es_ES', 'Germinación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1664, 'es_ES', 'Gerontología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1665, 'es_ES', 'Gestos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1666, 'es_ES', 'Gimnasia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1667, 'es_ES', 'Gimnasios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1668, 'es_ES', 'Gimnospermas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1669, 'es_ES', 'Ginecología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1670, 'es_ES', 'Gitanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1671, 'es_ES', 'Glaciares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1672, 'es_ES', 'Glándulas endocrinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1673, 'es_ES', 'Glándulas suprarrenales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1674, 'es_ES', 'Gnoseología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1675, 'es_ES', 'Gobierno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1676, 'es_ES', 'Gobierno representativo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1677, 'es_ES', 'Golpes de Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1678, 'es_ES', 'Gomas y resinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1679, 'es_ES', 'Gomas y resinas sintéticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1680, 'es_ES', 'Grabaciones en video', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1681, 'es_ES', 'Grabaciones sonoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1682, 'es_ES', 'Grabado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1683, 'es_ES', 'Grabadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1684, 'es_ES', 'Grabados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1685, 'es_ES', 'Gracia santificante', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1686, 'es_ES', 'Grafología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1687, 'es_ES', 'Gramática comparada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1688, 'es_ES', 'Gramática generativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1689, 'es_ES', 'Graneros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1690, 'es_ES', 'Granizo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1691, 'es_ES', 'Granjas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1692, 'es_ES', 'Gravitación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1693, 'es_ES', 'Gravitación terrestre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1694, 'es_ES', 'Gremios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1695, 'es_ES', 'Grúas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1696, 'es_ES', 'Grupos de presión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1697, 'es_ES', 'Grupos étnicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1698, 'es_ES', 'Grupos sanguíneos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1699, 'es_ES', 'Grupos sociales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1700, 'es_ES', 'Grupos, Teoría de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1701, 'es_ES', 'Guarderías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1702, 'es_ES', 'Guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1703, 'es_ES', 'Guerra aérea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1704, 'es_ES', 'Guerra atómica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1705, 'es_ES', 'Guerra biológica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1706, 'es_ES', 'Guerra civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1707, 'es_ES', 'Guerra espacial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1708, 'es_ES', 'Guerra marítima', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1709, 'es_ES', 'Guerra mundial, ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1710, 'es_ES', 'Guerra química', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1711, 'es_ES', 'Guerra submarina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1712, 'es_ES', 'Guerrillas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1713, 'es_ES', 'Guiones cinematográfícos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1714, 'es_ES', 'Guiones de televisión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1715, 'es_ES', 'Guiones radiofónicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1716, 'es_ES', 'Gula', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1717, 'es_ES', 'Gusto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1718, 'es_ES', 'Hacienda local', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1719, 'es_ES', 'Hacienda municipal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1720, 'es_ES', 'Hacienda provincial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1721, 'es_ES', 'Hacienda pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1722, 'es_ES', 'Hambre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1723, 'es_ES', 'Harinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1724, 'es_ES', 'Hedonismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1725, 'es_ES', 'Helenismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1726, 'es_ES', 'Helicópteros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1727, 'es_ES', 'Hematología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1728, 'es_ES', 'Hemerotecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1729, 'es_ES', 'Hemodiálisis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1730, 'es_ES', 'Hemofilia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1731, 'es_ES', 'Hemorragias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1732, 'es_ES', 'Hemorroides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1733, 'es_ES', 'Heno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1734, 'es_ES', 'Heráldica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1735, 'es_ES', 'Herbarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1736, 'es_ES', 'Herbicidas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1737, 'es_ES', 'Herejías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1738, 'es_ES', 'Herencia (Biología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1739, 'es_ES', 'Herencia (Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1740, 'es_ES', 'Heridas y lesiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1741, 'es_ES', 'Hermenéutica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1742, 'es_ES', 'Hernias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1743, 'es_ES', 'Héroes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1744, 'es_ES', 'Herrajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1745, 'es_ES', 'Herramientas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1746, 'es_ES', 'Hibernación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1747, 'es_ES', 'Hibridación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1748, 'es_ES', 'Hidráulica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1749, 'es_ES', 'Hidroaviones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1750, 'es_ES', 'Hidrobiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1751, 'es_ES', 'Hidrocarburos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1752, 'es_ES', 'Hidrodinámica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1753, 'es_ES', 'Hidrógeno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1754, 'es_ES', 'Hidrogeología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1755, 'es_ES', 'Hidrografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1756, 'es_ES', 'Hidrología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1757, 'es_ES', 'Hidropónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1758, 'es_ES', 'Hidrostática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1759, 'es_ES', 'Hidroterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1760, 'es_ES', 'Hígado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1761, 'es_ES', 'Higiene', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1762, 'es_ES', 'Higiene ambiental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1763, 'es_ES', 'Higiene escolar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1764, 'es_ES', 'Higiene industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1765, 'es_ES', 'Higiene pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1766, 'es_ES', 'Higiene rural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1767, 'es_ES', 'Higiene sexual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1768, 'es_ES', 'Hijos ilegítimos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1769, 'es_ES', 'Himnos nacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1770, 'es_ES', 'Himnos religiosos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1771, 'es_ES', 'Hinayana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1772, 'es_ES', 'Hinduísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1773, 'es_ES', 'Hipertensión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1774, 'es_ES', 'Hípica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1775, 'es_ES', 'Hipnosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1776, 'es_ES', 'Hipófisis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1777, 'es_ES', 'Hipotálamo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1778, 'es_ES', 'Hipotecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1779, 'es_ES', 'Hipotensión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1780, 'es_ES', 'Histeria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1781, 'es_ES', 'Histeria colectiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1782, 'es_ES', 'Histología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1783, 'es_ES', 'Histología animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1784, 'es_ES', 'Histología vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1785, 'es_ES', 'Histoquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1786, 'es_ES', 'Historia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1787, 'es_ES', 'Historia económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1788, 'es_ES', 'Historia militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1789, 'es_ES', 'Historia social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1790, 'es_ES', 'Historia universal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1791, 'es_ES', 'Historiadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1792, 'es_ES', 'Historietas gráficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1793, 'es_ES', 'Historiografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1794, 'es_ES', 'Hojas sueltas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1795, 'es_ES', 'Holdings', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1796, 'es_ES', 'Holografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1797, 'es_ES', 'Hombre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1798, 'es_ES', 'Hombre pre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1799, 'es_ES', 'Hombre primitivo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1800, 'es_ES', 'Homeopatía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1801, 'es_ES', 'Homicidio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1802, 'es_ES', 'Homosexualidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1803, 'es_ES', 'Hongos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1804, 'es_ES', 'Honor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1805, 'es_ES', 'Honorarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1806, 'es_ES', 'Hormigón', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1807, 'es_ES', 'Hormigón armado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1808, 'es_ES', 'Hormigón pretensado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1809, 'es_ES', 'Hormonas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1810, 'es_ES', 'Hormonas sexuales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1811, 'es_ES', 'Hornos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1812, 'es_ES', 'Hornos crematorios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1813, 'es_ES', 'Hornos eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1814, 'es_ES', 'Hornos metalúrgicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1815, 'es_ES', 'Horóscopo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1816, 'es_ES', 'Hortalizas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1817, 'es_ES', 'Horticultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1818, 'es_ES', 'Hospitales de campaña', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1819, 'es_ES', 'Hospitales militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1820, 'es_ES', 'Hospitales psiquiátricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1821, 'es_ES', 'Hospitales rurales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1822, 'es_ES', 'Hospitales y sanatorios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1823, 'es_ES', 'Hoteles y pensiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1824, 'es_ES', 'Huelgas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1825, 'es_ES', 'Huesos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1826, 'es_ES', 'Hulla', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1827, 'es_ES', 'Humanidades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1828, 'es_ES', 'Humanismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1829, 'es_ES', 'Humanitarismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1830, 'es_ES', 'Humedad atmosférica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1831, 'es_ES', 'Humorismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1832, 'es_ES', 'Humus', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1833, 'es_ES', 'Icebergs', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1834, 'es_ES', 'Iconografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1835, 'es_ES', 'Iconografía religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1836, 'es_ES', 'Iconos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1837, 'es_ES', 'Ictiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1838, 'es_ES', 'Idealismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1839, 'es_ES', 'Ideologías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1840, 'es_ES', 'Idolatría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1841, 'es_ES', 'Ídolos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1842, 'es_ES', 'Iglesia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1843, 'es_ES', 'Iglesia anglicana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1844, 'es_ES', 'Iglesia católica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1845, 'es_ES', 'Iglesia y educación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1846, 'es_ES', 'Iglesia y Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1847, 'es_ES', 'Iglesias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1848, 'es_ES', 'Iglesias cristianas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1849, 'es_ES', 'Iluminación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1850, 'es_ES', 'Imágenes religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1851, 'es_ES', 'Imaginación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1852, 'es_ES', 'Impedimentos matrimoniales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1853, 'es_ES', 'Imperialismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1854, 'es_ES', 'Imperio bizantino', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1855, 'es_ES', 'Imperio islámico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1856, 'es_ES', 'Imperio latino de oriente', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1857, 'es_ES', 'Imperio turco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1858, 'es_ES', 'Impermeabilización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1859, 'es_ES', 'Importación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1860, 'es_ES', 'Importadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1861, 'es_ES', 'Imprenta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1862, 'es_ES', 'Impresionismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1863, 'es_ES', 'Impresores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1864, 'es_ES', 'Impuestos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1865, 'es_ES', 'Impuestos municipales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1866, 'es_ES', 'Impuestos provinciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1867, 'es_ES', 'Incendios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1868, 'es_ES', 'Incendios forestales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1869, 'es_ES', 'Incesto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1870, 'es_ES', 'Incineración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1871, 'es_ES', 'Incompatibilidades laborales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1872, 'es_ES', 'Incunables', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1873, 'es_ES', 'Indicadores (Química)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1874, 'es_ES', 'Indicadores socio-económicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1875, 'es_ES', 'Índice de libros pro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1876, 'es_ES', 'Índices', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1877, 'es_ES', 'Indios americanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1878, 'es_ES', 'Individualidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1879, 'es_ES', 'Individualismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1880, 'es_ES', 'Indización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1881, 'es_ES', 'Inducción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1882, 'es_ES', 'Indulgencias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1883, 'es_ES', 'Indulto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1884, 'es_ES', 'Industria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1885, 'es_ES', 'Industrias agropecuarias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1886, 'es_ES', 'Industrias alimentarias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1887, 'es_ES', 'Industrias conserveras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1888, 'es_ES', 'Industrias farmacéuticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1889, 'es_ES', 'Industrias lácteas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1890, 'es_ES', 'Industrias mineras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1891, 'es_ES', 'Industrias papeleras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1892, 'es_ES', 'Industrias pesqueras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1893, 'es_ES', 'Industrias químicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1894, 'es_ES', 'Industrias siderometalúrgicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1895, 'es_ES', 'Industrias textiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1896, 'es_ES', 'Infanticidio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1897, 'es_ES', 'Infartos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1898, 'es_ES', 'Infecciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1899, 'es_ES', 'Infierno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1900, 'es_ES', 'Infinito', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1901, 'es_ES', 'Inflación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1902, 'es_ES', 'Información', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1903, 'es_ES', 'Información bibliográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1904, 'es_ES', 'Información científica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1905, 'es_ES', 'Información pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1906, 'es_ES', 'Información, Teoría de la', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1907, 'es_ES', 'Informadores científicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1908, 'es_ES', 'Informática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1909, 'es_ES', 'Ingeniería ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1910, 'es_ES', 'Ingeniería aeronáutica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1911, 'es_ES', 'Ingeniería agronómica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1912, 'es_ES', 'Ingeniería ambiental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1913, 'es_ES', 'Ingeniería civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1914, 'es_ES', 'Ingeniería de sistemas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1915, 'es_ES', 'Ingeniería forestal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1916, 'es_ES', 'Ingeniería militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1917, 'es_ES', 'Ingeniería naval', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1918, 'es_ES', 'Ingeniería nuclear', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1919, 'es_ES', 'Ingeniería sanitaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1920, 'es_ES', 'Ingenieros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1921, 'es_ES', 'Ingenieros técnicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1922, 'es_ES', 'Injerto de tejidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1923, 'es_ES', 'Injertos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1924, 'es_ES', 'Inmortalidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1925, 'es_ES', 'Inmunización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1926, 'es_ES', 'Inmunología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1927, 'es_ES', 'Inquisición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1928, 'es_ES', 'Inscripciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1929, 'es_ES', 'Insecticidas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1930, 'es_ES', 'Insectos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1931, 'es_ES', 'Insectos nocivos para la agricultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1932, 'es_ES', 'Insectos útiles a la agricultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1933, 'es_ES', 'Inseminación artificial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1934, 'es_ES', 'Inseminación artificial ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1935, 'es_ES', 'Insomnio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1936, 'es_ES', 'Inspección escolar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1937, 'es_ES', 'Inspiración artística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1938, 'es_ES', 'Inspiración bíblica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1939, 'es_ES', 'Instintos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1940, 'es_ES', 'Instituciones científicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1941, 'es_ES', 'Instituciones políticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1942, 'es_ES', 'Institutos de bac', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1943, 'es_ES', 'Instrumentos de cuerda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1944, 'es_ES', 'Instrumentos de percusión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1945, 'es_ES', 'Instrumentos de precisión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1946, 'es_ES', 'Instrumentos de tecla', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1947, 'es_ES', 'Instrumentos de viento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1948, 'es_ES', 'Instrumentos musicales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1949, 'es_ES', 'Integración económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1950, 'es_ES', 'Integrales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1951, 'es_ES', 'Intelectuales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1952, 'es_ES', 'Inteligencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1953, 'es_ES', 'Intendencia militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1954, 'es_ES', 'Intereses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1955, 'es_ES', 'Internacionalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1956, 'es_ES', 'Interruptores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1957, 'es_ES', 'Intervención estatal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1958, 'es_ES', 'Intervención-Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1959, 'es_ES', 'Intestinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1960, 'es_ES', 'Intolerancia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1961, 'es_ES', 'Intoxicaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1962, 'es_ES', 'Intuición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1963, 'es_ES', 'Inundaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1964, 'es_ES', 'Invasiones bárbaras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1965, 'es_ES', 'Inventos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1966, 'es_ES', 'Invernaderos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1967, 'es_ES', 'Inversiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1968, 'es_ES', 'Inversiones extranjeras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1969, 'es_ES', 'Inversiones públicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1970, 'es_ES', 'Invertebrados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1971, 'es_ES', 'Investigación científica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1972, 'es_ES', 'Investigación científica y desarrollo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1973, 'es_ES', 'Investigación criminal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1974, 'es_ES', 'Investigación operativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1975, 'es_ES', 'Invierno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1976, 'es_ES', 'Iones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1977, 'es_ES', 'Ionización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1978, 'es_ES', 'Ionosfera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1979, 'es_ES', 'Ira', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1980, 'es_ES', 'Islamismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1981, 'es_ES', 'Isótopos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1982, 'es_ES', 'Isótopos radiactivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1983, 'es_ES', 'Jabones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1984, 'es_ES', 'Jácaras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1985, 'es_ES', 'Jainismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1986, 'es_ES', 'Jardinería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1987, 'es_ES', 'Jardines botánicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1988, 'es_ES', 'Jardines de infancia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1989, 'es_ES', 'Jazz', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1990, 'es_ES', 'Jefes de Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1991, 'es_ES', 'Jefes y oficiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1992, 'es_ES', 'Jergas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1993, 'es_ES', 'Jesucristo en el arte', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1994, 'es_ES', 'Jesucristo en la literatura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1995, 'es_ES', 'Jornada laboral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1996, 'es_ES', 'Jóvenes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1997, 'es_ES', 'Joyas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1998, 'es_ES', 'Joyerías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 1999, 'es_ES', 'Jubilados y pensionistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2000, 'es_ES', 'Judaísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2001, 'es_ES', 'Judeocristianos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2002, 'es_ES', 'Judíos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2003, 'es_ES', 'Jueces', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2004, 'es_ES', 'Jueces de paz', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2005, 'es_ES', 'Juego', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2006, 'es_ES', 'Juegos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2007, 'es_ES', 'Juegos de azar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2008, 'es_ES', 'Juegos de cartas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2009, 'es_ES', 'Juegos de pelota', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2010, 'es_ES', 'Juegos educativos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2011, 'es_ES', 'Juegos electrónicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2012, 'es_ES', 'Juegos infantiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2013, 'es_ES', 'Juegos olímpicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2014, 'es_ES', 'Juegos populares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2015, 'es_ES', 'Juegos y recreos científicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2016, 'es_ES', 'Juegos, Teoría de los', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2017, 'es_ES', 'Juicio (Lógica)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2018, 'es_ES', 'Juicio Final', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2019, 'es_ES', 'Juicios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2020, 'es_ES', 'Juicios civiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2021, 'es_ES', 'Juicios penales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2022, 'es_ES', 'Jurisdicción administrativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2023, 'es_ES', 'Jurisdicción eclesiástica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2024, 'es_ES', 'Jurisdicción internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2025, 'es_ES', 'Jurisdicción militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2026, 'es_ES', 'Jurisprudencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2027, 'es_ES', 'Jurisprudenciacivil(eclesiástica,', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2028, 'es_ES', 'Justicia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2029, 'es_ES', 'Justicia internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2030, 'es_ES', 'Justicia militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2031, 'es_ES', 'Justicia social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2032, 'es_ES', 'Laboratorios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2033, 'es_ES', 'Laboratorios farmacéuticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2034, 'es_ES', 'Laboratorios químicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2035, 'es_ES', 'Labores de aguja', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2036, 'es_ES', 'Labores de punto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2037, 'es_ES', 'Labranza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2038, 'es_ES', 'Lacas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2039, 'es_ES', 'Lactantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2040, 'es_ES', 'Ladrillos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2041, 'es_ES', 'Ladrones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2042, 'es_ES', 'Lagos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2043, 'es_ES', 'Laicismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2044, 'es_ES', 'Lamas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2045, 'es_ES', 'Laminado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2046, 'es_ES', 'Lámparas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2047, 'es_ES', 'Lámparas eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2048, 'es_ES', 'Lana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2049, 'es_ES', 'Latifundios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2050, 'es_ES', 'Latitud', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2051, 'es_ES', 'Lectura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2052, 'es_ES', 'Legados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2053, 'es_ES', 'Legitimación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2054, 'es_ES', 'Lengua española', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2055, 'es_ES', 'Lengua española comercial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2056, 'es_ES', 'Lengua española técnica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2057, 'es_ES', 'Lenguaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2058, 'es_ES', 'Lenguajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2059, 'es_ES', 'Lenguajes de indización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2060, 'es_ES', 'Lenguajes de ordenadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2061, 'es_ES', 'Lenguajes simbólicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2062, 'es_ES', 'Lenguas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2063, 'es_ES', 'Lenguas artificiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2064, 'es_ES', 'Lenguas eslavas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2065, 'es_ES', 'Lenguas indoeuropeas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2066, 'es_ES', 'Lenguas modernas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2067, 'es_ES', 'Lenguas orientales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2068, 'es_ES', 'Lenguas románicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2069, 'es_ES', 'Lenguas semíticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2070, 'es_ES', 'Lentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2071, 'es_ES', 'Lentes de contacto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2072, 'es_ES', 'Leproserías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2073, 'es_ES', 'Lesbianismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2074, 'es_ES', 'Letras de cambio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2075, 'es_ES', 'Leucemia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2076, 'es_ES', 'Leucocitos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2077, 'es_ES', 'Levaduras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2078, 'es_ES', 'Lexicografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2079, 'es_ES', 'Leyes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2080, 'es_ES', 'Liberalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2081, 'es_ES', 'Liberalismo económico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2082, 'es_ES', 'Libertad condicional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2083, 'es_ES', 'Libertad de asociación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2084, 'es_ES', 'Libertad de enseñanza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2085, 'es_ES', 'Libertad de expresión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2086, 'es_ES', 'Libertad de imprenta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2087, 'es_ES', 'Libertad de información', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2088, 'es_ES', 'Libertad de pensamiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2089, 'es_ES', 'Libertad provisional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2090, 'es_ES', 'Libertad religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2091, 'es_ES', 'Libre albedrío', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2092, 'es_ES', 'Libre cambio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2093, 'es_ES', 'Librerías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2094, 'es_ES', 'Libreros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2095, 'es_ES', 'Libros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2096, 'es_ES', 'Libros de ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2097, 'es_ES', 'Libros de bolsillo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2098, 'es_ES', 'Libros de caballería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2099, 'es_ES', 'Libros de consulta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2100, 'es_ES', 'Libros de texto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2101, 'es_ES', 'Libros ilustrados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2102, 'es_ES', 'Libros infantiles y juveniles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2103, 'es_ES', 'Libros litúrgicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2104, 'es_ES', 'Libros pro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2105, 'es_ES', 'Libros raros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2106, 'es_ES', 'Libros sagrados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2107, 'es_ES', 'Libros xilográficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2108, 'es_ES', 'Licores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2109, 'es_ES', 'Licuefacción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2110, 'es_ES', 'Liderazgo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2111, 'es_ES', 'Líderes obreros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2112, 'es_ES', 'Lignito', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2113, 'es_ES', 'Limones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2114, 'es_ES', 'Limpieza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2115, 'es_ES', 'Líneas aéreas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2116, 'es_ES', 'Líneas eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2117, 'es_ES', 'Líneas telefónicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2118, 'es_ES', 'Líneas telegráficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2119, 'es_ES', 'Linfocitos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2120, 'es_ES', 'Lingüistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2121, 'es_ES', 'Lingüística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2122, 'es_ES', 'Lingüística de ordenadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2123, 'es_ES', 'Lino', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2124, 'es_ES', 'Linotipia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2125, 'es_ES', 'Líquenes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2126, 'es_ES', 'Líquidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2127, 'es_ES', 'Literatura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2128, 'es_ES', 'Literatura ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2129, 'es_ES', 'Literatura catalana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2130, 'es_ES', 'Literatura cristiana primitiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2131, 'es_ES', 'Literatura española', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2132, 'es_ES', 'Literatura gallega', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2133, 'es_ES', 'Literatura popular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2134, 'es_ES', 'Literatura vasca', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2135, 'es_ES', 'Literatura y política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2136, 'es_ES', 'Literatura y sociedad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2137, 'es_ES', 'Literaturas ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2138, 'es_ES', 'Litografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2139, 'es_ES', 'Litosfera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2140, 'es_ES', 'Liturgia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2141, 'es_ES', 'Liturgia de las ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2142, 'es_ES', 'Llanuras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2143, 'es_ES', 'Lluvia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2144, 'es_ES', 'Lockouts', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2145, 'es_ES', 'Locomotoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2146, 'es_ES', 'Logaritmos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2147, 'es_ES', 'Lógica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2148, 'es_ES', 'Lógica matemática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2149, 'es_ES', 'Logística militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2150, 'es_ES', 'Longitud', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2151, 'es_ES', 'Loterías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2152, 'es_ES', 'Lubricación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2153, 'es_ES', 'Lubricantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2154, 'es_ES', 'Lujo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2155, 'es_ES', 'Lujuria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2156, 'es_ES', 'Luminiscencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2157, 'es_ES', 'Luminotecnia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2158, 'es_ES', 'Luna', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2159, 'es_ES', 'Luteranismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2160, 'es_ES', 'Luxaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2161, 'es_ES', 'Luz', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2162, 'es_ES', 'Macrobiótica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2163, 'es_ES', 'Macroeconomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2164, 'es_ES', 'Madera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2165, 'es_ES', 'Madres solteras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2166, 'es_ES', 'Magia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2167, 'es_ES', 'Magisterio eclesiástico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2168, 'es_ES', 'Magnetismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2169, 'es_ES', 'Magnetismo animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2170, 'es_ES', 'Magnetismo nuclear', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2171, 'es_ES', 'Magnetismo terrestre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2172, 'es_ES', 'Magneto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2173, 'es_ES', 'Magnetófonos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2174, 'es_ES', 'Magnetoquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2175, 'es_ES', 'Magos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2176, 'es_ES', 'Maíz', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2177, 'es_ES', 'Mal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2178, 'es_ES', 'Malecones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2179, 'es_ES', 'Malformaciones congénitas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2180, 'es_ES', 'Malnutrición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2181, 'es_ES', 'Maltusianismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2182, 'es_ES', 'Mamíferos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2183, 'es_ES', 'Manantiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2184, 'es_ES', 'Mandamientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2185, 'es_ES', 'Maniobras militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2186, 'es_ES', 'Maniqueísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2187, 'es_ES', 'Mantequilla', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2188, 'es_ES', 'Manufacturas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2189, 'es_ES', 'Manuscritos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2190, 'es_ES', 'Mapas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2191, 'es_ES', 'Mapas antiguos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2192, 'es_ES', 'Mapas militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2193, 'es_ES', 'Mapas topográficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2194, 'es_ES', 'Máquinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2195, 'es_ES', 'Máquinas ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2196, 'es_ES', 'Máquinas agrícolas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2197, 'es_ES', 'Máquinas de vapor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2198, 'es_ES', 'Máquinas eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2199, 'es_ES', 'Máquinas electrónicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2200, 'es_ES', 'Máquinas elevadoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2201, 'es_ES', 'Marcapasos cardíaco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2202, 'es_ES', 'Marcas de fábrica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2203, 'es_ES', 'Marcas tipográficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2204, 'es_ES', 'Mareas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2205, 'es_ES', 'Mares y océanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2206, 'es_ES', 'Marfiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2207, 'es_ES', 'Marginados sociales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2208, 'es_ES', 'Marina de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2209, 'es_ES', 'Marina mercante', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2210, 'es_ES', 'Marineros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2211, 'es_ES', 'Mariología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2212, 'es_ES', 'Marketing', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2213, 'es_ES', 'Marquetería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2214, 'es_ES', 'Marranos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2215, 'es_ES', 'Mártires', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2216, 'es_ES', 'Martirologios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2217, 'es_ES', 'Marxismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2218, 'es_ES', 'Masaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2219, 'es_ES', 'Masonería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2220, 'es_ES', 'Masoquismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2221, 'es_ES', 'Matemáticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2222, 'es_ES', 'Matemáticas recreativas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2223, 'es_ES', 'Materia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2224, 'es_ES', 'Materiales audiovisuales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2225, 'es_ES', 'Materiales cerámicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2226, 'es_ES', 'Materiales de construcción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2227, 'es_ES', 'Materiales no librarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2228, 'es_ES', 'Materiales peligrosos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2229, 'es_ES', 'Materiales refractarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2230, 'es_ES', 'Materialismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2231, 'es_ES', 'Materialismo ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2232, 'es_ES', 'Materialismo dialéctico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2233, 'es_ES', 'Materias primas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2234, 'es_ES', 'Matriarcado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2235, 'es_ES', 'Matrimonio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2236, 'es_ES', 'Matrimonio (Teología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2237, 'es_ES', 'Matrimonio canónico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2238, 'es_ES', 'Matrimonio civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2239, 'es_ES', 'Matrimonio mixto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2240, 'es_ES', 'Matronas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2241, 'es_ES', 'Máximas y aforismos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2242, 'es_ES', 'Mecánica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2243, 'es_ES', 'Mecánica (Tecnología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2244, 'es_ES', 'Mecánica celeste', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2245, 'es_ES', 'Mecánica de fluidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2246, 'es_ES', 'Mecánica de sólidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2247, 'es_ES', 'Mecánica de suelos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2248, 'es_ES', 'Mecánica estadística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2249, 'es_ES', 'Mecánica ondulatoria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2250, 'es_ES', 'Mecánica química', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2251, 'es_ES', 'Mecanografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2252, 'es_ES', 'Mediación internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2253, 'es_ES', 'Medicamentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2254, 'es_ES', 'Medicina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2255, 'es_ES', 'Medicina clínica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2256, 'es_ES', 'Medicina de urgencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2257, 'es_ES', 'Medicina del trabajo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2258, 'es_ES', 'Medicina deportiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2259, 'es_ES', 'Medicina espacial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2260, 'es_ES', 'Medicina interna', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2261, 'es_ES', 'Medicina legal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2262, 'es_ES', 'Medicina mágica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2263, 'es_ES', 'Medicina militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2264, 'es_ES', 'Medicina natural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2265, 'es_ES', 'Medicina nuclear', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2266, 'es_ES', 'Medicina popular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2267, 'es_ES', 'Medicina preventiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2268, 'es_ES', 'Medicina psicosomática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2269, 'es_ES', 'Medicina rural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2270, 'es_ES', 'Medicina social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2271, 'es_ES', 'Medición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2272, 'es_ES', 'Médicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2273, 'es_ES', 'Medio ambiente', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2274, 'es_ES', 'Medios de comunicación social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2275, 'es_ES', 'Meditación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2276, 'es_ES', 'Meditaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2277, 'es_ES', 'Médula espinal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2278, 'es_ES', 'Médula ósea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2279, 'es_ES', 'Melancolía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2280, 'es_ES', 'Melodía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2281, 'es_ES', 'Memoria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2282, 'es_ES', 'Menopausia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2283, 'es_ES', 'Menores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2284, 'es_ES', 'Menstruación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2285, 'es_ES', 'Mente y cuerpo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2286, 'es_ES', 'Mercado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2287, 'es_ES', 'Mercados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2288, 'es_ES', 'Mercancías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2289, 'es_ES', 'Mercantilismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2290, 'es_ES', 'Mercenarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2291, 'es_ES', 'Mesolítico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2292, 'es_ES', 'Mestizaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2293, 'es_ES', 'Metabolismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2294, 'es_ES', 'Metafísica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2295, 'es_ES', 'Metáforas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2296, 'es_ES', 'Metales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2297, 'es_ES', 'Metalistería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2298, 'es_ES', 'Metaloides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2299, 'es_ES', 'Metalurgia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2300, 'es_ES', 'Metano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2301, 'es_ES', 'Meteoritos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2302, 'es_ES', 'Meteorología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2303, 'es_ES', 'Meteorólogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2304, 'es_ES', 'Meteoros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2305, 'es_ES', 'Metodología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2306, 'es_ES', 'Métodos de simulación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2307, 'es_ES', 'Métodos gráficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2308, 'es_ES', 'Métodos iterativos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2309, 'es_ES', 'Metonimias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2310, 'es_ES', 'Mezquitas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2311, 'es_ES', 'Micología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2312, 'es_ES', 'Microanálisis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2313, 'es_ES', 'Microbiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2314, 'es_ES', 'Microbiología agrícola', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2315, 'es_ES', 'Microbiología industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2316, 'es_ES', 'Microbiología médica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2317, 'es_ES', 'Microclimatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2318, 'es_ES', 'Microeconomía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2319, 'es_ES', 'Microelectrónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2320, 'es_ES', 'Microfic', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2321, 'es_ES', 'Microfilmes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2322, 'es_ES', 'Microformas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2323, 'es_ES', 'Microfotografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2324, 'es_ES', 'Microondas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2325, 'es_ES', 'Microordenadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2326, 'es_ES', 'Microorganismos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2327, 'es_ES', 'Microscopía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2328, 'es_ES', 'Microscopía electrónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2329, 'es_ES', 'Microscopios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2330, 'es_ES', 'Miedo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2331, 'es_ES', 'Miembros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2332, 'es_ES', 'Migración interna', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2333, 'es_ES', 'Milagros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2334, 'es_ES', 'Militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2335, 'es_ES', 'Militarismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2336, 'es_ES', 'Mimo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2337, 'es_ES', 'Minas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2338, 'es_ES', 'Minas militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2339, 'es_ES', 'Minas submarinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2340, 'es_ES', 'Minerales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2341, 'es_ES', 'Mineralogía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2342, 'es_ES', 'Minería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2343, 'es_ES', 'Mineros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2344, 'es_ES', 'Miniatura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2345, 'es_ES', 'Miniaturas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2346, 'es_ES', 'Minifundios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2347, 'es_ES', 'Miniordenadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2348, 'es_ES', 'Ministros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2349, 'es_ES', 'Minorías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2350, 'es_ES', 'Minorías étnicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2351, 'es_ES', 'Minorías lingüísticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2352, 'es_ES', 'Minorías políticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2353, 'es_ES', 'Minorías religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2354, 'es_ES', 'Minusválidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2355, 'es_ES', 'Misa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2356, 'es_ES', 'Misales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2357, 'es_ES', 'Misiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2358, 'es_ES', 'Misioneros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2359, 'es_ES', 'Misiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2360, 'es_ES', 'Misiones cristianas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2361, 'es_ES', 'Misiones médicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2362, 'es_ES', 'Misterios religiosos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2363, 'es_ES', 'Mística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2364, 'es_ES', 'Mística ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2365, 'es_ES', 'Mística budista', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2366, 'es_ES', 'Mística cristiana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2367, 'es_ES', 'Mística judía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2368, 'es_ES', 'Mística musulmana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2369, 'es_ES', 'Misticismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2370, 'es_ES', 'Místicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2371, 'es_ES', 'Mitología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2372, 'es_ES', 'Mitos y leyendas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2373, 'es_ES', 'Modas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2374, 'es_ES', 'Modelado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2375, 'es_ES', 'Modelos matemáticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2376, 'es_ES', 'Modernismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2377, 'es_ES', 'Modernismo (Teología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2378, 'es_ES', 'Moléculas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2379, 'es_ES', 'Moluscos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2380, 'es_ES', 'Monacato', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2381, 'es_ES', 'Monarquía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2382, 'es_ES', 'Monasterios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2383, 'es_ES', 'Moneda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2384, 'es_ES', 'Monedas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2385, 'es_ES', 'Monedas árabes (griegas, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2386, 'es_ES', 'Monopolios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2387, 'es_ES', 'Monopolios estatales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2388, 'es_ES', 'Monorraíles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2389, 'es_ES', 'Monoteísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2390, 'es_ES', 'Montaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2391, 'es_ES', 'Montañas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2392, 'es_ES', 'Montañismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2393, 'es_ES', 'Montes de piedad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2394, 'es_ES', 'Montessori, Método de', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2395, 'es_ES', 'Monumentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2396, 'es_ES', 'Monumentos ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2397, 'es_ES', 'Monumentos funerarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2398, 'es_ES', 'Moral católica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2399, 'es_ES', 'Moral cristiana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2400, 'es_ES', 'Moralidades (Teatro)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2401, 'es_ES', 'Moriscos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2402, 'es_ES', 'Mortalidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2403, 'es_ES', 'Mosaicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2404, 'es_ES', 'Mosaicos romanos (bizantinos, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2405, 'es_ES', 'Moticiclismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2406, 'es_ES', 'Motocicletas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2407, 'es_ES', 'Motonáutica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2408, 'es_ES', 'Motores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2409, 'es_ES', 'Motores ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2410, 'es_ES', 'Motores de automóviles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2411, 'es_ES', 'Motores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2412, 'es_ES', 'Movilidad social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2413, 'es_ES', 'Movimiento (Fisiología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2414, 'es_ES', 'Movimiento (Mecánica)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2415, 'es_ES', 'Movimiento (Psicología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2416, 'es_ES', 'Movimiento acelerado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2417, 'es_ES', 'Movimiento obrero', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2418, 'es_ES', 'Movimientos de liberación nacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2419, 'es_ES', 'Movimientos estudiantiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2420, 'es_ES', 'Movimientos religiosos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2421, 'es_ES', 'Mozárabes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2422, 'es_ES', 'Mudéjares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2423, 'es_ES', 'Muebles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2424, 'es_ES', 'Muelles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2425, 'es_ES', 'Muerte', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2426, 'es_ES', 'Muestreo (Estadística)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2427, 'es_ES', 'Mujeres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2428, 'es_ES', 'Mujeres españolas (francesas, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2429, 'es_ES', 'Mulas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2430, 'es_ES', 'Multilingüismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2431, 'es_ES', 'Multinacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2432, 'es_ES', 'Municiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2433, 'es_ES', 'Municipios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2434, 'es_ES', 'Murallas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2435, 'es_ES', 'Muros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2436, 'es_ES', 'Músculos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2437, 'es_ES', 'Museología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2438, 'es_ES', 'Museólogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2439, 'es_ES', 'Museos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2440, 'es_ES', 'Música', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2441, 'es_ES', 'Música coral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2442, 'es_ES', 'Música de cámara', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2443, 'es_ES', 'Música para piano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2444, 'es_ES', 'Música popular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2445, 'es_ES', 'Música sagrada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2446, 'es_ES', 'Música sinfónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2447, 'es_ES', 'Música vocal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2448, 'es_ES', 'Músicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2449, 'es_ES', 'Musulmanes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2450, 'es_ES', 'Mutación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2451, 'es_ES', 'Mutilados de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2452, 'es_ES', 'Mutualidades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2453, 'es_ES', 'Nación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2454, 'es_ES', 'Nacionalidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2455, 'es_ES', 'Nacionalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2456, 'es_ES', 'Nacionalizaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2457, 'es_ES', 'Nacionalsocialismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2458, 'es_ES', 'Naipes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2459, 'es_ES', 'Naranjas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2460, 'es_ES', 'nas, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2461, 'es_ES', 'Natación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2462, 'es_ES', 'Natalidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2463, 'es_ES', 'Natividad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2464, 'es_ES', 'Naturaleza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2465, 'es_ES', 'Naturalistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2466, 'es_ES', 'Naturismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2467, 'es_ES', 'Naufragios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2468, 'es_ES', 'Navegación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2469, 'es_ES', 'Navegación a motor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2470, 'es_ES', 'Navegación a vela', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2471, 'es_ES', 'Navegación de cabotaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2472, 'es_ES', 'Navegación interior', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2473, 'es_ES', 'Navegación submarina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2474, 'es_ES', 'Navegantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2475, 'es_ES', 'Navidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2476, 'es_ES', 'Nebulosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2477, 'es_ES', 'Necrópolis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2478, 'es_ES', 'Necrosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2479, 'es_ES', 'Negocios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2480, 'es_ES', 'Neolítico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2481, 'es_ES', 'Nervios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2482, 'es_ES', 'Neurobiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2483, 'es_ES', 'Neurología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2484, 'es_ES', 'Neuropsiquiatría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2485, 'es_ES', 'Neurosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2486, 'es_ES', 'Neutralidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2487, 'es_ES', 'Neutrones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2488, 'es_ES', 'Niños', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2489, 'es_ES', 'Niños abandonados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2490, 'es_ES', 'Niños anormales y retrasados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2491, 'es_ES', 'Niños incapacitados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2492, 'es_ES', 'Niños prematuros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2493, 'es_ES', 'Niños recién nacidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2494, 'es_ES', 'Nitrógeno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2495, 'es_ES', 'Nivel de vida', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2496, 'es_ES', 'Nobleza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2497, 'es_ES', 'Nomadismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2498, 'es_ES', 'Nomenclatores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2499, 'es_ES', 'Normalización', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2500, 'es_ES', 'Normas técnicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2501, 'es_ES', 'Notación musical', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2502, 'es_ES', 'Novela', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2503, 'es_ES', 'Novelas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2504, 'es_ES', 'Nudismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2505, 'es_ES', 'Números, Teoría de los', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2506, 'es_ES', 'Numismática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2507, 'es_ES', 'Nupcialidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2508, 'es_ES', 'Nutrición', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2509, 'es_ES', 'Obesidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2510, 'es_ES', 'Obispos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2511, 'es_ES', 'Objeción de conciencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2512, 'es_ES', 'Objetos artísticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2513, 'es_ES', 'Obligación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2514, 'es_ES', 'Obligaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2515, 'es_ES', 'Obligaciones (Finanzas)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2516, 'es_ES', 'Obras de arte', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2517, 'es_ES', 'Obras públicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2518, 'es_ES', 'Observatorios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2519, 'es_ES', 'Observatorios astronómicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2520, 'es_ES', 'Observatorios meteorológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2521, 'es_ES', 'Observatorios sismológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2522, 'es_ES', 'Obstetricia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2523, 'es_ES', 'Obstetricia veterinaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2524, 'es_ES', 'Oceanografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2525, 'es_ES', 'Ocio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2526, 'es_ES', 'Ocultismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2527, 'es_ES', 'Odontología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2528, 'es_ES', 'Oferta y demanda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2529, 'es_ES', 'Oficinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2530, 'es_ES', 'Oficios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2531, 'es_ES', 'Oftalmología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2532, 'es_ES', 'Oído', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2533, 'es_ES', 'Ojos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2534, 'es_ES', 'Olas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2535, 'es_ES', 'Oleoductos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2536, 'es_ES', 'Olfato', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2537, 'es_ES', 'Oligarquía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2538, 'es_ES', 'Olivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2539, 'es_ES', 'Ondas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2540, 'es_ES', 'Ondas de radio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2541, 'es_ES', 'Ondas electromagnéticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2542, 'es_ES', 'Ondas sonoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2543, 'es_ES', 'Onomástica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2544, 'es_ES', 'Ontología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2545, 'es_ES', 'Óperas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2546, 'es_ES', 'Operetas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2547, 'es_ES', 'Opinión pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2548, 'es_ES', 'Opio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2549, 'es_ES', 'Oposición política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2550, 'es_ES', 'Oposiciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2551, 'es_ES', 'Óptica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2552, 'es_ES', 'Óptica cristalográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2553, 'es_ES', 'Óptica electrónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2554, 'es_ES', 'Óptica física', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2555, 'es_ES', 'Óptica fotográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2556, 'es_ES', 'Oración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2557, 'es_ES', 'Oraciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2558, 'es_ES', 'Oratoria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2559, 'es_ES', 'Oratoria sagrada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2560, 'es_ES', 'Orden público', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2561, 'es_ES', 'Orden sacerdotal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2562, 'es_ES', 'Ordenación del territorio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2563, 'es_ES', 'Ordenadores analógicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2564, 'es_ES', 'Ordenadores digitales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2565, 'es_ES', 'Ordenadores electrónicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2566, 'es_ES', 'Ordenadores personales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2567, 'es_ES', 'Órdenes militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2568, 'es_ES', 'Órdenes y congregaciones religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2569, 'es_ES', 'Orfanatos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2570, 'es_ES', 'Orfebrería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2571, 'es_ES', 'Organismos internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2572, 'es_ES', 'Órganos (Música)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2573, 'es_ES', 'Órganos artificiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2574, 'es_ES', 'Orientación pedagógica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2575, 'es_ES', 'Orientación profesional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2576, 'es_ES', 'Orientación psicológica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2577, 'es_ES', 'Ornitología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2578, 'es_ES', 'Oro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2579, 'es_ES', 'Orogénesis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2580, 'es_ES', 'Orquestas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2581, 'es_ES', 'Ortodoncia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2582, 'es_ES', 'Ortopedia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2583, 'es_ES', 'Osteología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2584, 'es_ES', 'Otitis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2585, 'es_ES', 'Otoño', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2586, 'es_ES', 'Otorrinolaringología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2587, 'es_ES', 'Ovarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2588, 'es_ES', 'Ovejas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2589, 'es_ES', 'Ovnis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2590, 'es_ES', 'Oxidación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2591, 'es_ES', 'Paciencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2592, 'es_ES', 'Pacifismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2593, 'es_ES', 'Padres de la Iglesia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2594, 'es_ES', 'Padres e ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2595, 'es_ES', 'Paganos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2596, 'es_ES', 'Pagodas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2597, 'es_ES', 'Paisaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2598, 'es_ES', 'Países comunistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2599, 'es_ES', 'Países desarrollados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2600, 'es_ES', 'Países en desarrollo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2601, 'es_ES', 'Países neutrales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2602, 'es_ES', 'Pájaros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2603, 'es_ES', 'Palabras y frases malsonantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2604, 'es_ES', 'Palacios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2605, 'es_ES', 'Palancas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2606, 'es_ES', 'Paleobotánica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2607, 'es_ES', 'Paleoclimatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2608, 'es_ES', 'Paleogeología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2609, 'es_ES', 'Paleografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2610, 'es_ES', 'Paleolítico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2611, 'es_ES', 'Paleontología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2612, 'es_ES', 'Paleozoología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2613, 'es_ES', 'Palimpsestos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2614, 'es_ES', 'Paludismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2615, 'es_ES', 'Pan', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2616, 'es_ES', 'Páncreas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2617, 'es_ES', 'Pantanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2618, 'es_ES', 'Panteísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2619, 'es_ES', 'Pantomima', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2620, 'es_ES', 'Papas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2621, 'es_ES', 'Papel', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2622, 'es_ES', 'Papel moneda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2623, 'es_ES', 'Papiros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2624, 'es_ES', 'Parábolas evangélicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2625, 'es_ES', 'Paracaidismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2626, 'es_ES', 'Paradores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2627, 'es_ES', 'Paramnesia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2628, 'es_ES', 'Paranoia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2629, 'es_ES', 'Parapsicología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2630, 'es_ES', 'Parasitología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2631, 'es_ES', 'Parásitos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2632, 'es_ES', 'Parentesco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2633, 'es_ES', 'Parlamentarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2634, 'es_ES', 'Parlamentarismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2635, 'es_ES', 'Parlamentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2636, 'es_ES', 'Paro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2637, 'es_ES', 'Parques de atracciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2638, 'es_ES', 'Parques nacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2639, 'es_ES', 'Parques y jardines', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2640, 'es_ES', 'Parques zoológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2641, 'es_ES', 'Parricidio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2642, 'es_ES', 'Parroquias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2643, 'es_ES', 'Participación política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2644, 'es_ES', 'Partículas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2645, 'es_ES', 'Partidos comunistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2646, 'es_ES', 'Partidos políticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2647, 'es_ES', 'Parto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2648, 'es_ES', 'Parto sin dolor', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2649, 'es_ES', 'Pasaportes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2650, 'es_ES', 'Pasatiempos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2651, 'es_ES', 'Pascua', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2652, 'es_ES', 'Pastoreo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2653, 'es_ES', 'Pastos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2654, 'es_ES', 'Patatas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2655, 'es_ES', 'Patentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2656, 'es_ES', 'Paternidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2657, 'es_ES', 'Patología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2658, 'es_ES', 'Patología animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2659, 'es_ES', 'Patología quirúrgica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2660, 'es_ES', 'Patología vegetal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2661, 'es_ES', 'Patología veterinaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2662, 'es_ES', 'Patria potestad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2663, 'es_ES', 'Patriarcado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2664, 'es_ES', 'Patrimonio ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2665, 'es_ES', 'Patrimonio artístico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2666, 'es_ES', 'Patrimonio cultural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2667, 'es_ES', 'Patrimonio del Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2668, 'es_ES', 'Patrimonio eclesiástico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2669, 'es_ES', 'Patrimonio bibliográfico y documental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2670, 'es_ES', 'Patriotismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2671, 'es_ES', 'Patrística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2672, 'es_ES', 'Pavimentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2673, 'es_ES', 'Paz', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2674, 'es_ES', 'Pecado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2675, 'es_ES', 'Pecados capitales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2676, 'es_ES', 'Peces', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2677, 'es_ES', 'Pedagogía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2678, 'es_ES', 'Pediatría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2679, 'es_ES', 'Película fotográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2680, 'es_ES', 'Películas cinematográficas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2681, 'es_ES', 'Pelucas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2682, 'es_ES', 'Peluquería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2683, 'es_ES', 'Penas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2684, 'es_ES', 'Penitencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2685, 'es_ES', 'Penitencia (Virtud)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2686, 'es_ES', 'Pensiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2687, 'es_ES', 'Pentecostés', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2688, 'es_ES', 'Pequeñas y medianas empresas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2689, 'es_ES', 'Percepción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2690, 'es_ES', 'Peregrinaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2691, 'es_ES', 'Pereza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2692, 'es_ES', 'Perfección cristiana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2693, 'es_ES', 'Perforación y sondeo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2694, 'es_ES', 'Perforadoras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2695, 'es_ES', 'Perfumes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2696, 'es_ES', 'Periódicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2697, 'es_ES', 'Periódicos españoles (franceses, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2698, 'es_ES', 'Periodismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2699, 'es_ES', 'Periodismo gráfico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2700, 'es_ES', 'Periodistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2701, 'es_ES', 'Permeabilidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2702, 'es_ES', 'Permutaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2703, 'es_ES', 'Perros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2704, 'es_ES', 'Persecuciones religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2705, 'es_ES', 'Persona (Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2706, 'es_ES', 'Personajes literarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2707, 'es_ES', 'Personalidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2708, 'es_ES', 'Personalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2709, 'es_ES', 'Personas jurídicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2710, 'es_ES', 'Perspectiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2711, 'es_ES', 'Perversiones sexuales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2712, 'es_ES', 'Pesca', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2713, 'es_ES', 'Pesca deportiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2714, 'es_ES', 'Pesca fluvial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2715, 'es_ES', 'Pesca marítima', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2716, 'es_ES', 'Pesca submarina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2717, 'es_ES', 'Pescaderías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2718, 'es_ES', 'Pescado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2719, 'es_ES', 'Pescado congelado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2720, 'es_ES', 'Pesos y medidas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2721, 'es_ES', 'Pesquerías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2722, 'es_ES', 'Peste bubónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2723, 'es_ES', 'Pesticidas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2724, 'es_ES', 'Petroglifos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2725, 'es_ES', 'Petróleo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2726, 'es_ES', 'Petrología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2727, 'es_ES', 'Pianos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2728, 'es_ES', 'Picaduras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2729, 'es_ES', 'Pictografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2730, 'es_ES', 'Piedras preciosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2731, 'es_ES', 'Piel', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2732, 'es_ES', 'Pieles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2733, 'es_ES', 'Piensos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2734, 'es_ES', 'Piensos compuestos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2735, 'es_ES', 'Piernas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2736, 'es_ES', 'Pigmentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2737, 'es_ES', 'Pilas eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2738, 'es_ES', 'Pinacotecas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2739, 'es_ES', 'Pinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2740, 'es_ES', 'Pintores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2741, 'es_ES', 'Pintura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2742, 'es_ES', 'Pintura al óleo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2743, 'es_ES', 'Pintura al pastel', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2744, 'es_ES', 'Pintura al temple', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2745, 'es_ES', 'Pintura industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2746, 'es_ES', 'Pintura mural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2747, 'es_ES', 'Pintura rupestre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2748, 'es_ES', 'Pintura española (flamenca,italiana,...)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2749, 'es_ES', 'Pinturas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2750, 'es_ES', 'Piragüismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2751, 'es_ES', 'Pirámides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2752, 'es_ES', 'Piratas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2753, 'es_ES', 'Pirotecnia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2754, 'es_ES', 'Piscicultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2755, 'es_ES', 'Piscifactorías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2756, 'es_ES', 'Piscinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2757, 'es_ES', 'Pistolas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2758, 'es_ES', 'Placas solares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2759, 'es_ES', 'Placer', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2760, 'es_ES', 'Plagas del campo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2761, 'es_ES', 'Plagio literario', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2762, 'es_ES', 'Plancton', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2763, 'es_ES', 'Planes económicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2764, 'es_ES', 'Planetas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2765, 'es_ES', 'Plantaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2766, 'es_ES', 'Plantas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2767, 'es_ES', 'Plantas acuáticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2768, 'es_ES', 'Plantas comestibles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2769, 'es_ES', 'Plantas cultivadas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2770, 'es_ES', 'Plantas forrajeras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2771, 'es_ES', 'Plantas fósiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2772, 'es_ES', 'Plantas industriales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2773, 'es_ES', 'Plantas medicinales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2774, 'es_ES', 'Plantas oleaginosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2775, 'es_ES', 'Plantas ornamentales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2776, 'es_ES', 'Plantas parásitas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2777, 'es_ES', 'Plantas venenosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2778, 'es_ES', 'Plasma (Física)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2779, 'es_ES', 'Plasma sanguíneo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2780, 'es_ES', 'Plásticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2781, 'es_ES', 'Plata', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2782, 'es_ES', 'Platonismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2783, 'es_ES', 'Playas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2784, 'es_ES', 'Plazas de toros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2785, 'es_ES', 'Pliegos de cordel', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2786, 'es_ES', 'Pluriempleo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2787, 'es_ES', 'Plusvalía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2788, 'es_ES', 'Población', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2789, 'es_ES', 'Pobres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2790, 'es_ES', 'Pobreza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2791, 'es_ES', 'Poda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2792, 'es_ES', 'Poder ejecutivo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2793, 'es_ES', 'Poder judicial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2794, 'es_ES', 'Poder legislativo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2795, 'es_ES', 'Poderes del Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2796, 'es_ES', 'Poesía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2797, 'es_ES', 'Poesías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2798, 'es_ES', 'Poética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2799, 'es_ES', 'Polarografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2800, 'es_ES', 'Policía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2801, 'es_ES', 'Policía municipal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2802, 'es_ES', 'Poligamia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2803, 'es_ES', 'Polímeros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2804, 'es_ES', 'Polinomios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2805, 'es_ES', 'Poliomelitis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2806, 'es_ES', 'Politeísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2807, 'es_ES', 'Política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2808, 'es_ES', 'Política agraria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2809, 'es_ES', 'Política ambiental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2810, 'es_ES', 'Política científica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2811, 'es_ES', 'Política cultural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2812, 'es_ES', 'Política económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2813, 'es_ES', 'Política educativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2814, 'es_ES', 'Política energética', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2815, 'es_ES', 'Política fiscal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2816, 'es_ES', 'Política internacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2817, 'es_ES', 'Política social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2818, 'es_ES', 'Políticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2819, 'es_ES', 'Pólvora', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2820, 'es_ES', 'Porcelana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2821, 'es_ES', 'Pornografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2822, 'es_ES', 'Portaaviones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2823, 'es_ES', 'Posesión (Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2824, 'es_ES', 'Posesos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2825, 'es_ES', 'Positivismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2826, 'es_ES', 'Postimpresionismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2827, 'es_ES', 'Postres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2828, 'es_ES', 'Pozos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2829, 'es_ES', 'Pozos artesianos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2830, 'es_ES', 'Pozos petrolíferos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2831, 'es_ES', 'Práctica religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2832, 'es_ES', 'Praderas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2833, 'es_ES', 'Pragmatismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2834, 'es_ES', 'Preceptiva literaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2835, 'es_ES', 'Precepto dominical', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2836, 'es_ES', 'Precepto pascual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2837, 'es_ES', 'Preceptos eclesiásticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2838, 'es_ES', 'Precios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2839, 'es_ES', 'Precipitaciones atmosféricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2840, 'es_ES', 'Predestinación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2841, 'es_ES', 'Predicación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2842, 'es_ES', 'Prefabricados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2843, 'es_ES', 'Premios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2844, 'es_ES', 'Premios literarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2845, 'es_ES', 'Prensa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2846, 'es_ES', 'Prensa clandestina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2847, 'es_ES', 'Prensas mecánicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2848, 'es_ES', 'Presas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2849, 'es_ES', 'Presidentes de gobierno', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2850, 'es_ES', 'Presión atmosférica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2851, 'es_ES', 'Presión sanguínea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2852, 'es_ES', 'Presos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2853, 'es_ES', 'Presos políticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2854, 'es_ES', 'Préstamo bibliotecario', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2855, 'es_ES', 'Préstamos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2856, 'es_ES', 'Préstamos internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2857, 'es_ES', 'Prestidigitación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2858, 'es_ES', 'Presupuestos del Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2859, 'es_ES', 'Presupuestos municipales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2860, 'es_ES', 'Presupuestos provinciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2861, 'es_ES', 'Previsión demográfica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2862, 'es_ES', 'Previsión económica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2863, 'es_ES', 'Primavera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2864, 'es_ES', 'Prisioneros de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2865, 'es_ES', 'Prisiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2866, 'es_ES', 'Privilegios e inmunidades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2867, 'es_ES', 'Probabilidades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2868, 'es_ES', 'Problemas raciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2869, 'es_ES', 'Problemas sociales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2870, 'es_ES', 'Procedimiento administrativo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2871, 'es_ES', 'Procedimiento civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2872, 'es_ES', 'Procedimiento laboral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2873, 'es_ES', 'Procedimiento penal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2874, 'es_ES', 'Procesiones religiosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2875, 'es_ES', 'Procesos célebres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2876, 'es_ES', 'Procesos políticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2877, 'es_ES', 'Procuradores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2878, 'es_ES', 'Producción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2879, 'es_ES', 'Productividad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2880, 'es_ES', 'Producto nacional bruto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2881, 'es_ES', 'Productos agrícolas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2882, 'es_ES', 'Productos forestales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2883, 'es_ES', 'Productos lácteos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2884, 'es_ES', 'Productos químicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2885, 'es_ES', 'Productos químicos agrícolas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2886, 'es_ES', 'Productos sintéticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2887, 'es_ES', 'Profecías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2888, 'es_ES', 'Profecías bíblicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2889, 'es_ES', 'Profesiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2890, 'es_ES', 'Profesores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2891, 'es_ES', 'Profetas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2892, 'es_ES', 'Programación de ordenadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2893, 'es_ES', 'Programación matemática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2894, 'es_ES', 'Programas de ordenadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2895, 'es_ES', 'Progreso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2896, 'es_ES', 'Progreso científico y tecnológico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2897, 'es_ES', 'Proletariado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2898, 'es_ES', 'Pronunciamientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2899, 'es_ES', 'Propaganda', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2900, 'es_ES', 'Propaganda bélica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2901, 'es_ES', 'Propaganda política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2902, 'es_ES', 'Propano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2903, 'es_ES', 'Propiedad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2904, 'es_ES', 'Propiedad ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2905, 'es_ES', 'Propiedad industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2906, 'es_ES', 'Propiedad inmobiliaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2907, 'es_ES', 'Propiedad intelectual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2908, 'es_ES', 'Propiedad mobiliaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2909, 'es_ES', 'Propiedad privada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2910, 'es_ES', 'Propiedad rústica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2911, 'es_ES', 'Proporción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2912, 'es_ES', 'Propulsión a reacción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2913, 'es_ES', 'Propulsión nuclear', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2914, 'es_ES', 'Prospección', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2915, 'es_ES', 'Prospección geofísica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2916, 'es_ES', 'Próstata', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2917, 'es_ES', 'Prostitución', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2918, 'es_ES', 'Protección civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2919, 'es_ES', 'Proteccionismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2920, 'es_ES', 'Protectorados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2921, 'es_ES', 'Proteínas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2922, 'es_ES', 'Prótesis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2923, 'es_ES', 'Protestantismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2924, 'es_ES', 'Protocolo diplomático', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2925, 'es_ES', 'Protocolos notariales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2926, 'es_ES', 'Protones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2927, 'es_ES', 'Protozoos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2928, 'es_ES', 'Providencia divina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2929, 'es_ES', 'Proyección (Geometría)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2930, 'es_ES', 'Proyectiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2931, 'es_ES', 'Proyectores cinematográficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2932, 'es_ES', 'Pruebas (Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2933, 'es_ES', 'Psicoanálisis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2934, 'es_ES', 'Psicodrama', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2935, 'es_ES', 'Psicofarmacología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2936, 'es_ES', 'Psicofármacos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2937, 'es_ES', 'Psicolingüística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2938, 'es_ES', 'Psicología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2939, 'es_ES', 'Psicología aplicada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2940, 'es_ES', 'Psicología clínica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2941, 'es_ES', 'Psicología de la educación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2942, 'es_ES', 'Psicología de la forma', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2943, 'es_ES', 'Psicología evolutiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2944, 'es_ES', 'Psicología fisiológica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2945, 'es_ES', 'Psicología industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2946, 'es_ES', 'Psicología sexual', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2947, 'es_ES', 'Psicología social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2948, 'es_ES', 'Psicólogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2949, 'es_ES', 'Psicometría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2950, 'es_ES', 'Psicomotricidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2951, 'es_ES', 'Psicopatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2952, 'es_ES', 'Psicosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2953, 'es_ES', 'Psicosis maníaco-depresiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2954, 'es_ES', 'Psicosis orgánicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2955, 'es_ES', 'Psicoterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2956, 'es_ES', 'Psicoterapia de grupo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2957, 'es_ES', 'Psicoterapia familiar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2958, 'es_ES', 'Psiquiatría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2959, 'es_ES', 'Psiquiatría infantil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2960, 'es_ES', 'Psiquiatría legal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2961, 'es_ES', 'Psoriasis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2962, 'es_ES', 'Publicaciones científicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2963, 'es_ES', 'Publicaciones oficiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2964, 'es_ES', 'Publicaciones periódicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2965, 'es_ES', 'Publicaciones seriadas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2966, 'es_ES', 'Publicidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2967, 'es_ES', 'Publicidad radiofónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2968, 'es_ES', 'Publicidad televisada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2969, 'es_ES', 'Puentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2970, 'es_ES', 'Puericultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2971, 'es_ES', 'Puertos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2972, 'es_ES', 'Puertos francos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2973, 'es_ES', 'Pulimento y acabado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2974, 'es_ES', 'Pulmones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2975, 'es_ES', 'Purgatorio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2976, 'es_ES', 'Puritanismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2977, 'es_ES', 'Quanta, Teoría de los', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2978, 'es_ES', 'Quemaduras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2979, 'es_ES', 'Queso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2980, 'es_ES', 'Quiebra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2981, 'es_ES', 'Química', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2982, 'es_ES', 'Química física', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2983, 'es_ES', 'Química industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2984, 'es_ES', 'Química inorgánica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2985, 'es_ES', 'Química nuclear', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2986, 'es_ES', 'Química orgánica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2987, 'es_ES', 'Química recreativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2988, 'es_ES', 'Quimioterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2989, 'es_ES', 'Quinielas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2990, 'es_ES', 'Quiromancia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2991, 'es_ES', 'Rabia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2992, 'es_ES', 'Raciocinio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2993, 'es_ES', 'Racionalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2994, 'es_ES', 'Racismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2995, 'es_ES', 'Radar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2996, 'es_ES', 'Radiaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2997, 'es_ES', 'Radiaciones solares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2998, 'es_ES', 'Radiactividad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 2999, 'es_ES', 'Radio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3000, 'es_ES', 'Radio (Hueso)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3001, 'es_ES', 'Radio (Metal)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3002, 'es_ES', 'Radio en la enseñanza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3003, 'es_ES', 'Radiobiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3004, 'es_ES', 'Radiodiagnóstico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3005, 'es_ES', 'Radiodifusión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3006, 'es_ES', 'Radiografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3007, 'es_ES', 'Radiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3008, 'es_ES', 'Radioteléfono', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3009, 'es_ES', 'Radioterapia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3010, 'es_ES', 'Rascacielos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3011, 'es_ES', 'Rayos catódicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3012, 'es_ES', 'Rayos cósmicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3013, 'es_ES', 'Rayos infrarrojos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3014, 'es_ES', 'Rayos láser', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3015, 'es_ES', 'Rayos ultravioletas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3016, 'es_ES', 'RayosX', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3017, 'es_ES', 'Razas ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3018, 'es_ES', 'Reacciones nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3019, 'es_ES', 'Reacciones químicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3020, 'es_ES', 'Reactores nucleares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3021, 'es_ES', 'Realismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3022, 'es_ES', 'Rebeliones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3023, 'es_ES', 'Reclutamiento y alistamiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3024, 'es_ES', 'Recolección', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3025, 'es_ES', 'Reconversión industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3026, 'es_ES', 'Rectificadores de corriente', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3027, 'es_ES', 'Recursos ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3028, 'es_ES', 'Recursos (Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3029, 'es_ES', 'Recursos administrativos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3030, 'es_ES', 'Recursos agrícolas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3031, 'es_ES', 'Recursos alimenticios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3032, 'es_ES', 'Recursos animales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3033, 'es_ES', 'Recursos energéticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3034, 'es_ES', 'Recursos forestales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3035, 'es_ES', 'Recursos marítimos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3036, 'es_ES', 'Recursos minerales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3037, 'es_ES', 'Recursos naturales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3038, 'es_ES', 'Recursos petrolíferos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3039, 'es_ES', 'Redención', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3040, 'es_ES', 'Redes eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3041, 'es_ES', 'Reencarnación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3042, 'es_ES', 'Referendums', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3043, 'es_ES', 'Refinerías petroquímicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3044, 'es_ES', 'Reflejos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3045, 'es_ES', 'Reflejos condicionados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3046, 'es_ES', 'Reflexión (Física)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3047, 'es_ES', 'Reforma', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3048, 'es_ES', 'Reforma agraria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3049, 'es_ES', 'Reformatorios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3050, 'es_ES', 'Refracción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3051, 'es_ES', 'Refranes y proverbios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3052, 'es_ES', 'Refrigeración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3053, 'es_ES', 'Refugiados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3054, 'es_ES', 'Refugiados alemanes (españoles, etc.)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3055, 'es_ES', 'Refugios antiaéreos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3056, 'es_ES', 'Regalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3057, 'es_ES', 'Regatas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3058, 'es_ES', 'Regímenes políticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3059, 'es_ES', 'Regionalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3060, 'es_ES', 'Reinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3061, 'es_ES', 'Rejoneo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3062, 'es_ES', 'Rejuvenecimiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3063, 'es_ES', 'Relaciones laborales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3064, 'es_ES', 'Relaciones prematrimoniales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3065, 'es_ES', 'Relaciones públicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3066, 'es_ES', 'Relajación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3067, 'es_ES', 'Relatividad, Teoría de la', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3068, 'es_ES', 'Relieve terrestre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3069, 'es_ES', 'Religión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3070, 'es_ES', 'Religión y ciencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3071, 'es_ES', 'Religión y literatura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3072, 'es_ES', 'Religiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3073, 'es_ES', 'Religiones antiguas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3074, 'es_ES', 'Religiones primitivas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3075, 'es_ES', 'Religiosidad popular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3076, 'es_ES', 'Religiosos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3077, 'es_ES', 'Relojes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3078, 'es_ES', 'Remo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3079, 'es_ES', 'Remolques', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3080, 'es_ES', 'Renacimiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3081, 'es_ES', 'Rentas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3082, 'es_ES', 'Rentas públicas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3083, 'es_ES', 'Reparaciones de guerra', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3084, 'es_ES', 'Repoblación forestal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3085, 'es_ES', 'Reportajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3086, 'es_ES', 'Reportajes fotográficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3087, 'es_ES', 'Repostería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3088, 'es_ES', 'Reproducción (Biología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3089, 'es_ES', 'Reprografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3090, 'es_ES', 'Reptiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3091, 'es_ES', 'República', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3092, 'es_ES', 'Rescate', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3093, 'es_ES', 'Residuos industriales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3094, 'es_ES', 'Residuos radiactivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3095, 'es_ES', 'Resistencia de materiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3096, 'es_ES', 'Resistencia pasiva', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3097, 'es_ES', 'Resistencias eléctricas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3098, 'es_ES', 'Respiración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3099, 'es_ES', 'Respiración artificial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3100, 'es_ES', 'Responsabilidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3101, 'es_ES', 'Responsabilidad administrativa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3102, 'es_ES', 'Responsabilidad civil', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3103, 'es_ES', 'Responsabilidad del Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3104, 'es_ES', 'Responsabilidad penal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3105, 'es_ES', 'Restauradores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3106, 'es_ES', 'Restaurantes, cafeterías, etc.', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3107, 'es_ES', 'Restos arqueológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3108, 'es_ES', 'Resúmenes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3109, 'es_ES', 'Resurrección', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3110, 'es_ES', 'Retablos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3111, 'es_ES', 'Retórica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3112, 'es_ES', 'Retratos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3113, 'es_ES', 'Retratos fotográficos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3114, 'es_ES', 'Reumatismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3115, 'es_ES', 'Revelación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3116, 'es_ES', 'Revestimientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3117, 'es_ES', 'Revestimientos protectores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3118, 'es_ES', 'Revistas musicales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3119, 'es_ES', 'Revoluciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3120, 'es_ES', 'Reyes y soberanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3121, 'es_ES', 'Riego', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3122, 'es_ES', 'Riesgo (Economía)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3123, 'es_ES', 'Rima', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3124, 'es_ES', 'Riñones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3125, 'es_ES', 'Riñones artificiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3126, 'es_ES', 'Ríos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3127, 'es_ES', 'Riqueza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3128, 'es_ES', 'Ritos y ceremonias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3129, 'es_ES', 'Ritos y ceremonias fúnebres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3130, 'es_ES', 'Robo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3131, 'es_ES', 'Robots', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3132, 'es_ES', 'Rocas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3133, 'es_ES', 'Rodamientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3134, 'es_ES', 'Romanticismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3135, 'es_ES', 'Rosario', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3136, 'es_ES', 'Ruedas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3137, 'es_ES', 'Rugby', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3138, 'es_ES', 'Ruido', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3139, 'es_ES', 'Rumiantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3140, 'es_ES', 'Rutas turísticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3141, 'es_ES', 'Sables', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3142, 'es_ES', 'Sabotaje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3143, 'es_ES', 'Sacerdotes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3144, 'es_ES', 'Sacramentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3145, 'es_ES', 'Sacro romano imperio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3146, 'es_ES', 'Sadismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3147, 'es_ES', 'Sainetes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3148, 'es_ES', 'Salarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3149, 'es_ES', 'Salud', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3150, 'es_ES', 'Salud mental', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3151, 'es_ES', 'Salud pública', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3152, 'es_ES', 'Salvación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3153, 'es_ES', 'Sangre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3154, 'es_ES', 'Santos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3155, 'es_ES', 'Santuarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3156, 'es_ES', 'Sarcoma', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3157, 'es_ES', 'Sastrería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3158, 'es_ES', 'Satélites', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3159, 'es_ES', 'Satélites artificiales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3160, 'es_ES', 'Satélites meteorológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3161, 'es_ES', 'Sátira', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3162, 'es_ES', 'Secretariado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3163, 'es_ES', 'Sectas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3164, 'es_ES', 'Sectascristianas(judías,musulma-', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3165, 'es_ES', 'Secuestro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3166, 'es_ES', 'Secuestro de aviones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3167, 'es_ES', 'Sedantes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3168, 'es_ES', 'Sedimentación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3169, 'es_ES', 'Sefardíes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3170, 'es_ES', 'Seglares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3171, 'es_ES', 'Seguridad ciudadana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3172, 'es_ES', 'Seguridad del Estado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3173, 'es_ES', 'Seguridad industrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3174, 'es_ES', 'Seguridad social', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3175, 'es_ES', 'Seguridad-Sistemas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3176, 'es_ES', 'Seguros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3177, 'es_ES', 'Seguros contra incendios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3178, 'es_ES', 'Seguros de accidentes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3179, 'es_ES', 'Seguros de vida', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3180, 'es_ES', 'Seguros marítimos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3181, 'es_ES', 'Selección de libros (Bibliotecas)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3182, 'es_ES', 'Selección natural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3183, 'es_ES', 'Sellos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3184, 'es_ES', 'Sellos de correo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3185, 'es_ES', 'Semana Santa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3186, 'es_ES', 'Semántica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3187, 'es_ES', 'Semiconductores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3188, 'es_ES', 'Seminarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3189, 'es_ES', 'Semiología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3190, 'es_ES', 'Semiología médica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3191, 'es_ES', 'Sensores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3192, 'es_ES', 'Sentencias', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3193, 'es_ES', 'Sentidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3194, 'es_ES', 'Señales marítimas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3195, 'es_ES', 'Separación conyugal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3196, 'es_ES', 'Separatismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3197, 'es_ES', 'Sepulcros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3198, 'es_ES', 'Sequía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3199, 'es_ES', 'Series (Matemáticas)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3200, 'es_ES', 'Serigrafía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3201, 'es_ES', 'Sermones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3202, 'es_ES', 'Serodiagnóstico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3203, 'es_ES', 'Servicio diplomático y consular', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3204, 'es_ES', 'Servicio doméstico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3205, 'es_ES', 'Servicio militar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3206, 'es_ES', 'Servicio secreto', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3207, 'es_ES', 'Servicios de salud', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3208, 'es_ES', 'Setas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3209, 'es_ES', 'Setas venenosas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3210, 'es_ES', 'Seudónimos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3211, 'es_ES', 'Sexo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3212, 'es_ES', 'Siderurgia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3213, 'es_ES', 'Sigilografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3214, 'es_ES', 'Siglas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3215, 'es_ES', 'Signos y símbolos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3216, 'es_ES', 'Silos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3217, 'es_ES', 'Silvicultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3218, 'es_ES', 'Simbiosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3219, 'es_ES', 'Sinagogas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3220, 'es_ES', 'Sindicalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3221, 'es_ES', 'Sindicatos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3222, 'es_ES', 'Sinécdoques', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3223, 'es_ES', 'Sintoísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3224, 'es_ES', 'Sionismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3225, 'es_ES', 'Sismología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3226, 'es_ES', 'Sistema ', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3227, 'es_ES', 'Sistema linfático', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3228, 'es_ES', 'Sistema métrico decimal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3229, 'es_ES', 'Sistema nervioso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3230, 'es_ES', 'Sistema solar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3231, 'es_ES', 'Sistemas en línea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3232, 'es_ES', 'Sistemas fuera de línea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3233, 'es_ES', 'Sistemas monetarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3234, 'es_ES', 'Sistemas monetarios internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3235, 'es_ES', 'Soberanía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3236, 'es_ES', 'Soberbia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3237, 'es_ES', 'Socialismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3238, 'es_ES', 'Socialistas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3239, 'es_ES', 'Sociedad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3240, 'es_ES', 'Sociedad de masas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3241, 'es_ES', 'Sociedad postindustrial', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3242, 'es_ES', 'Sociedades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3243, 'es_ES', 'Sociedades anónimas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3244, 'es_ES', 'Sociedades primitivas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3245, 'es_ES', 'Sociedades secretas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3246, 'es_ES', 'Sociolingüística', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3247, 'es_ES', 'Sociología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3248, 'es_ES', 'Sociología de la educación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3249, 'es_ES', 'Sociología del arte', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3250, 'es_ES', 'Sociología del ocio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3251, 'es_ES', 'Sociología política', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3252, 'es_ES', 'Sociología rural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3253, 'es_ES', 'Sociología urbana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3254, 'es_ES', 'Sociólogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3255, 'es_ES', 'Socorrismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3256, 'es_ES', 'Sol', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3257, 'es_ES', 'Soldados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3258, 'es_ES', 'Soldadura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3259, 'es_ES', 'Solfeo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3260, 'es_ES', 'Solidificación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3261, 'es_ES', 'Sólidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3262, 'es_ES', 'Soluciones (Química)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3263, 'es_ES', 'Somatotropina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3264, 'es_ES', 'Sombras c', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3265, 'es_ES', 'Sonido', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3266, 'es_ES', 'Sordomudos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3267, 'es_ES', 'Subastas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3268, 'es_ES', 'Subdesarrollo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3269, 'es_ES', 'Sublimación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3270, 'es_ES', 'Submarinismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3271, 'es_ES', 'Submarinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3272, 'es_ES', 'Subnormales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3273, 'es_ES', 'Subsidio de paro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3274, 'es_ES', 'Subsidio de vejez', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3275, 'es_ES', 'Subsidio familiar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3276, 'es_ES', 'Subsidios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3277, 'es_ES', 'Substancias radiactivas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3278, 'es_ES', 'Sucesiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3279, 'es_ES', 'Suelos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3280, 'es_ES', 'Sueño', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3281, 'es_ES', 'Sueños', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3282, 'es_ES', 'Suero', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3283, 'es_ES', 'Sufrimiento', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3284, 'es_ES', 'Suicidio', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3285, 'es_ES', 'Superficies', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3286, 'es_ES', 'Supermercados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3287, 'es_ES', 'Superpoblación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3288, 'es_ES', 'Supersticiones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3289, 'es_ES', 'Surrealismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3290, 'es_ES', 'Tabaco', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3291, 'es_ES', 'Tabletas cuneiformes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3292, 'es_ES', 'Tabúes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3293, 'es_ES', 'Talofitas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3294, 'es_ES', 'Tanques', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3295, 'es_ES', 'Tanques (Ejército)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3296, 'es_ES', 'Taoísmo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3297, 'es_ES', 'Tapicería', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3298, 'es_ES', 'Tapices', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3299, 'es_ES', 'Taquigrafía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3300, 'es_ES', 'Tauromaquia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3301, 'es_ES', 'Teatro', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3302, 'es_ES', 'Teatro cómico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3303, 'es_ES', 'Teatro lírico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3304, 'es_ES', 'Teatro religioso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3305, 'es_ES', 'Teatros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3306, 'es_ES', 'Tecnocracia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3307, 'es_ES', 'Tecnología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3308, 'es_ES', 'Tectónica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3309, 'es_ES', 'Tejidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3310, 'es_ES', 'Tejidos (Biología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3311, 'es_ES', 'Telares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3312, 'es_ES', 'Telecomunicaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3313, 'es_ES', 'Telefax', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3314, 'es_ES', 'Telefonía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3315, 'es_ES', 'Teléfono', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3316, 'es_ES', 'Telefotografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3317, 'es_ES', 'Telegrafía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3318, 'es_ES', 'Telégrafo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3319, 'es_ES', 'Telemática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3320, 'es_ES', 'Telemetría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3321, 'es_ES', 'Teleología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3322, 'es_ES', 'Telepatía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3323, 'es_ES', 'Teleproceso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3324, 'es_ES', 'Telescopios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3325, 'es_ES', 'Teletex', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3326, 'es_ES', 'Televisión', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3327, 'es_ES', 'Televisión en color', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3328, 'es_ES', 'Televisión en la enseñanza', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3329, 'es_ES', 'Televisión por cable', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3330, 'es_ES', 'Televisión privada', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3331, 'es_ES', 'Télex', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3332, 'es_ES', 'Temperatura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3333, 'es_ES', 'Temperatura animal', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3334, 'es_ES', 'Templos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3335, 'es_ES', 'Tensores (Álgebra)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3336, 'es_ES', 'Teocracia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3337, 'es_ES', 'Teología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3338, 'es_ES', 'Teología dogmática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3339, 'es_ES', 'Teología natural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3340, 'es_ES', 'Teología pastoral', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3341, 'es_ES', 'Teosofía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3342, 'es_ES', 'Terapéutica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3343, 'es_ES', 'Terapia ocupacional', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3344, 'es_ES', 'Terminología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3345, 'es_ES', 'Termodinámica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3346, 'es_ES', 'Termoelectricidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3347, 'es_ES', 'Termómetros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3348, 'es_ES', 'Termómetros clínicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3349, 'es_ES', 'Termoquímica', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3350, 'es_ES', 'Terremotos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3351, 'es_ES', 'Territorio (Derec', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3352, 'es_ES', 'Terrorismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3353, 'es_ES', 'Testamentos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3354, 'es_ES', 'Tests de aptitud', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3355, 'es_ES', 'Tests de inteligencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3356, 'es_ES', 'Tests psicológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3357, 'es_ES', 'Tiempo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3358, 'es_ES', 'Tiempo (Meteorología)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3359, 'es_ES', 'Tiempo libre', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3360, 'es_ES', 'Tierra (Planeta)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3361, 'es_ES', 'Tierras de cultivo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3362, 'es_ES', 'Tintes y teñido', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3363, 'es_ES', 'Tipos de imprenta', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3364, 'es_ES', 'Tiro (Ciencia militar)', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3365, 'es_ES', 'Tiroides', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3366, 'es_ES', 'Títeres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3367, 'es_ES', 'Títulos académicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3368, 'es_ES', 'Tocadiscos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3369, 'es_ES', 'Tolerancia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3370, 'es_ES', 'Tomismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3371, 'es_ES', 'Topografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3372, 'es_ES', 'Topografía submarina', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3373, 'es_ES', 'Topología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3374, 'es_ES', 'Toponimia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3375, 'es_ES', 'Tórax', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3376, 'es_ES', 'Toreros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3377, 'es_ES', 'Tormentas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3378, 'es_ES', 'Tornos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3379, 'es_ES', 'Toros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3380, 'es_ES', 'Toros de lidia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3381, 'es_ES', 'Torres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3382, 'es_ES', 'Tortura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3383, 'es_ES', 'Totalitarismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3384, 'es_ES', 'Totemismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3385, 'es_ES', 'Toxicología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3386, 'es_ES', 'Toxicomanía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3387, 'es_ES', 'Trabajadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3388, 'es_ES', 'Trabajadores agrícolas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3389, 'es_ES', 'Trabajadores extranjeros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3390, 'es_ES', 'Trabajo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3391, 'es_ES', 'Trabajos domésticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3392, 'es_ES', 'Trabajos manuales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3393, 'es_ES', 'Tractores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3394, 'es_ES', 'Tradicionalismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3395, 'es_ES', 'Traducción', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3396, 'es_ES', 'Traducción automática', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3397, 'es_ES', 'Traductores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3398, 'es_ES', 'Tráfico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3399, 'es_ES', 'Tráfico aéreo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3400, 'es_ES', 'Tráfico marítimo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3401, 'es_ES', 'Tráfico urbano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3402, 'es_ES', 'Tragedia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3403, 'es_ES', 'Trailers', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3404, 'es_ES', 'Traje', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3405, 'es_ES', 'Trajes populares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3406, 'es_ES', 'Transbordadores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3407, 'es_ES', 'Transductores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3408, 'es_ES', 'Transformaciones matemáticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3409, 'es_ES', 'Transformadores eléctricos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3410, 'es_ES', 'Transistores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3411, 'es_ES', 'Transliteración', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3412, 'es_ES', 'Transportes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3413, 'es_ES', 'Transportes aéreos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3414, 'es_ES', 'Transportes escolares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3415, 'es_ES', 'Transportes ferroviarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3416, 'es_ES', 'Transportes fluviales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3417, 'es_ES', 'Transportes marítimos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3418, 'es_ES', 'Transportes por carretera', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3419, 'es_ES', 'Transportes terrestres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3420, 'es_ES', 'Transportes urbanos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3421, 'es_ES', 'Tranvías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3422, 'es_ES', 'Tras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3423, 'es_ES', 'Trasplante de órganos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3424, 'es_ES', 'Trata de blancas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3425, 'es_ES', 'Tratados internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3426, 'es_ES', 'Traumatología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3427, 'es_ES', 'Trazadores radiactivos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3428, 'es_ES', 'Trenes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3429, 'es_ES', 'Tribunales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3430, 'es_ES', 'Tribunales administrativos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3431, 'es_ES', 'Tribunales de jurado', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3432, 'es_ES', 'Tribunales de menores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3433, 'es_ES', 'Tribunales eclesiásticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3434, 'es_ES', 'Tribunales internacionales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3435, 'es_ES', 'Tribunales laborales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3436, 'es_ES', 'Tribunales mercantiles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3437, 'es_ES', 'Tribunales militares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3438, 'es_ES', 'Tribus', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3439, 'es_ES', 'Trigo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3440, 'es_ES', 'Trigonometría', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3441, 'es_ES', 'Trinidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3442, 'es_ES', 'Trolebuses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3443, 'es_ES', 'Trombosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3444, 'es_ES', 'Tropos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3445, 'es_ES', 'Trusts', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3446, 'es_ES', 'Tuberculosis', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3447, 'es_ES', 'Tuberías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3448, 'es_ES', 'Tubos electrónicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3449, 'es_ES', 'Tumores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3450, 'es_ES', 'Túneles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3451, 'es_ES', 'Turbinas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3452, 'es_ES', 'Turismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3453, 'es_ES', 'Tutela', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3454, 'es_ES', 'Ulceras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3455, 'es_ES', 'Ultrasonidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3456, 'es_ES', 'Universidades', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3457, 'es_ES', 'Universidades laborales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3458, 'es_ES', 'Universidades populares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3459, 'es_ES', 'Universo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3460, 'es_ES', 'Urbanidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3461, 'es_ES', 'Urbanismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3462, 'es_ES', 'Urea', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3463, 'es_ES', 'Urología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3464, 'es_ES', 'Usura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3465, 'es_ES', 'Utopías', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3466, 'es_ES', 'Vacaciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3467, 'es_ES', 'Vacaciones escolares', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3468, 'es_ES', 'Vacas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3469, 'es_ES', 'Vacunación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3470, 'es_ES', 'Vacunas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3471, 'es_ES', 'Vagones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3472, 'es_ES', 'Valdenses', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3473, 'es_ES', 'Valles', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3474, 'es_ES', 'Valor económico', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3475, 'es_ES', 'Valores mobiliarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3476, 'es_ES', 'Varices', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3477, 'es_ES', 'Vasos sanguíneos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3478, 'es_ES', 'Vectores', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3479, 'es_ES', 'Vegetación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3480, 'es_ES', 'Vegetarianismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3481, 'es_ES', 'Vela', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3482, 'es_ES', 'Venenos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3483, 'es_ES', 'Ventanas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3484, 'es_ES', 'Ventas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3485, 'es_ES', 'Ventas a plazos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3486, 'es_ES', 'Ventilación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3487, 'es_ES', 'Verano', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3488, 'es_ES', 'Vertebrados', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3489, 'es_ES', 'Vértebras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3490, 'es_ES', 'Vesícula biliar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3491, 'es_ES', 'Vestidos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3492, 'es_ES', 'Veterinaria', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3493, 'es_ES', 'Veterinarios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3494, 'es_ES', 'Viajes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3495, 'es_ES', 'Viajes por mar', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3496, 'es_ES', 'Vías acuáticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3497, 'es_ES', 'Vías romanas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3498, 'es_ES', 'Vías terrestres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3499, 'es_ES', 'Vibraciones', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3500, 'es_ES', 'Vicios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3501, 'es_ES', 'Vid-Cultivo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3502, 'es_ES', 'Vida cristiana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3503, 'es_ES', 'Vida futura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3504, 'es_ES', 'Vida rural', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3505, 'es_ES', 'Vida urbana', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3506, 'es_ES', 'Vida-Origen', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3507, 'es_ES', 'Vídeo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3508, 'es_ES', 'Videocassettes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3509, 'es_ES', 'Videodiscos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3510, 'es_ES', 'Videoteléfono', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3511, 'es_ES', 'Vidrieras', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3512, 'es_ES', 'Vidrios', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3513, 'es_ES', 'Vidrios artísticos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3514, 'es_ES', 'Vientos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3515, 'es_ES', 'Villancicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3516, 'es_ES', 'Vinos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3517, 'es_ES', 'Violación', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3518, 'es_ES', 'Violencia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3519, 'es_ES', 'Virgen María', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3520, 'es_ES', 'Virginidad', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3521, 'es_ES', 'Virtudes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3522, 'es_ES', 'Virtudes teologales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3523, 'es_ES', 'Virus', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3524, 'es_ES', 'Visigodos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3525, 'es_ES', 'Vista', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3526, 'es_ES', 'Vitaminas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3527, 'es_ES', 'Viticultura', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3528, 'es_ES', 'Viveros', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3529, 'es_ES', 'Viviendas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3530, 'es_ES', 'Vocación religiosa', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3531, 'es_ES', 'Volcanes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3532, 'es_ES', 'Voto femenino', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3533, 'es_ES', 'Votos religiosos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3534, 'es_ES', 'Vuelos célebres', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3535, 'es_ES', 'Vuelos espaciales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3536, 'es_ES', 'Xilografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3537, 'es_ES', 'Yacimientos arqueológicos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3538, 'es_ES', 'Yacimientos minerales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3539, 'es_ES', 'Yeso', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3540, 'es_ES', 'Yoga', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3541, 'es_ES', 'Zarzuelas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3542, 'es_ES', 'Zonas climáticas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3543, 'es_ES', 'Zonas de recreo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3544, 'es_ES', 'Zonas industriales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3545, 'es_ES', 'Zonas rurales', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3546, 'es_ES', 'Zonas urbanas', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3547, 'es_ES', 'Zonas verdes', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3548, 'es_ES', 'Zoogeografía', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3549, 'es_ES', 'Zoología', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3550, 'es_ES', 'Zoólogos', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3551, 'es_ES', 'Zooplancton', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3552, 'es_ES', 'Zootecnia', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3553, 'es_ES', 'Zoroastrismo', '', '', '', 'descriptores no clasificados', '', ''),
(1, 3554, 'es_ES', 'Zumos de frutas', '', '', '', 'descriptores no clasificados', '', '');




INSERT INTO categories (num_thesaurus, num_noeud, langue, libelle_categorie, note_application, comment_public, comment_voir, index_categorie, path_word_categ, index_path_word_categ) 
SELECT DISTINCT A.num_thesaurus, A.num_noeud, A.langue, A.libelle_categorie, A.note_application, A.comment_public, A.comment_voir, A.index_categorie, A.path_word_categ, A.index_path_word_categ
FROM categories_bak A
LEFT JOIN categories B
ON A.num_noeud = B.num_noeud AND A.langue = B.langue AND A.libelle_categorie = B.libelle_categorie
WHERE B.num_noeud IS NULL;

DROP TABLE IF EXISTS categories_bak;
