DROP TABLE IF EXISTS indexint_bak;
CREATE TABLE IF NOT EXISTS indexint_bak (
  indexint_id mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  indexint_name varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  indexint_comment text COLLATE utf8_unicode_ci NOT NULL,
  index_indexint text COLLATE utf8_unicode_ci,
  num_pclass int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (indexint_id),
  UNIQUE KEY indexint_name (indexint_name,num_pclass)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

INSERT INTO indexint_bak(indexint_id,indexint_name,indexint_comment,index_indexint,num_pclass) VALUES (NULL,'0','Generalidades.','0','1'),
(NULL,'003','Escritura. Sistemas de escritura. Signos y símbolos. Representaciones gráficas en general.','003','1'),
(NULL,'004','Ciencia y tecnología de los ordenadores. Informática.','004','1'),
(NULL,'004.3','«Hardware». Componentes físicos del ordenador, máquinas.','004 3','1'),
(NULL,'004.4','«Software». Equipo lógico, componentes lógicos, programas.','004 4','1'),
(NULL,'004.6','Datos. Sistemas de gestión de bases de datos.','004 6','1'),
(NULL,'004.7','Comunicación informática. Redes de ordenadores.','004 7','1'),
(NULL,'005','Estudios teóricos de organización en general. Metodología. Análisis, síntesis, clasificación y taxonomía. Sistematización en general.','005','1'),
(NULL,'006','Normalización en general y normas.','006','1'),
(NULL,'006.9','Cronología.','006 9','1'),
(NULL,'006.91','Metrología. Pesos y medidas en general.','006 91','1'),
(NULL,'007','Teoría de la comunicación y del control en general. Cibernética.','007','1'),
(NULL,'008','Civilización, progreso y cultura en general.','008','1'),
(NULL,'009','Humanidades.','009','1'),
(NULL,'011','Bibliografías universales.','011','1'),
(NULL,'016','Bibliografías especiales.','016','1'),
(NULL,'017','Catálogos en general.','017','1'),
(NULL,'019','Catálogos especiales.','019','1'),
(NULL,'02','Biblioteconomía.','02','1'),
(NULL,'030','Enciclopedias y diccionarios enciclopédicos generales. Obras de referencia general. Estudios y crítica sobre esta clase de obras.','030','1'),
(NULL,'050','Publicaciones seriadas. Publicaciones periódicas. Estudios y críticas sobre estas obras.','050','1'),
(NULL,'06','Organizaciones. Asociaciones. Congresos. Exposiciones. Instituciones científicas.','06','1'),
(NULL,'069','Museos. Galerías. Exposiciones permanentes. Museología.','069','1'),
(NULL,'070','Periodismo. La Prensa (concepto, ética, administración y control, organización comercial y editorial).','070','1'),
(NULL,'08','Poligrafías en general. Colecciones. Homenajes.','08','1'),
(NULL,'087.5','Publicaciones infantiles en general. Libros infantiles y juveniles.','087 5','1'),
(NULL,'087.6','Obras populares. Literatura de quiosco. Cómics.','087 6','1'),
(NULL,'09','Manuscritos. Libros raros y curiosos. Bibliofilia.','09','1'),
(NULL,'1','Filosofía.','1','1'),
(NULL,'1(09)','Historia de la Filosofía.','1 09 ','1'),
(NULL,'11','Metafísica. Ontología. Cosmología.','11','1'),
(NULL,'122/129','Metafísica especial.','122 129','1'),
(NULL,'13','Filosofía de la mente y del espíritu. Metafísica de la vida espiritual.','13','1'),
(NULL,'133','Ciencias ocultas. Ocultismo.','133','1'),
(NULL,'133.52','Astrología.','133 52','1'),
(NULL,'14','Sistemas filosóficos.','14','1'),
(NULL,'141.72','Feminismo.','141 72','1'),
(NULL,'159.9','Psicología.','159 9','1'),
(NULL,'159.91','Psicofisiología.','159 91','1'),
(NULL,'159.97','Psicopatología.','159 97','1'),
(NULL,'159.98','Psicología aplicada (psicotecnología). Test de aptitud.','159 98','1'),
(NULL,'16','Lógica. Teoría del conocimiento. Epistemología. Metodología de la lógica.','16','1'),
(NULL,'17','Ética. Moral.','17','1'),
(NULL,'2','Religión.','2','1'),
(NULL,'21','Teología natural.','21','1'),
(NULL,'22','La Biblia.','22','1'),
(NULL,'222/224','Antiguo Testamento.','222 224','1'),
(NULL,'225','Nuevo Testamento.','225','1'),
(NULL,'23','Teología dogmática.','23','1'),
(NULL,'24','Teología moral. Teología práctica.','24','1'),
(NULL,'25','Teología pastoral.','25','1'),
(NULL,'26','Iglesia cristiana en general. Organización y liturgia.','26','1'),
(NULL,'268','Catequesis.','268','1'),
(NULL,'27','Historia general de la Iglesia cristiana. Órdenes y congregaciones religiosas.','27','1'),
(NULL,'28','Iglesias cristianas. Comunidades y sectas.','28','1'),
(NULL,'282','Iglesia Católica Romana.','282','1'),
(NULL,'283/289','Protestantismo (Iglesias católicas no romanas).','283 289','1'),
(NULL,'29','Religiones no cristianas. Mitología.','29','1'),
(NULL,'292','Antiguas religiones griega y romana. Mitología clásica.','292','1'),
(NULL,'294.3','Budismo.','294 3','1'),
(NULL,'296','Judaísmo.','296','1'),
(NULL,'297','El Islam.','297','1'),
(NULL,'3','Ciencias Sociales en general.','3','1'),
(NULL,'303','Métodos de las Ciencias Sociales (investigación, selección, recopilación de datos, análisis).','303','1'),
(NULL,'de','datos, análisis).','de','1'),
(NULL,'304.2','Cuestiones sociales y culturales. Política social.','304 2','1'),
(NULL,'308','Sociografía. Situación social. Geografía social.','308','1'),
(NULL,'31','Sociología. Estadística. Demografía.','31','1'),
(NULL,'311','Ciencia estadística. Teoría de la estadística.','311','1'),
(NULL,'312','Estadística de la población.','312','1'),
(NULL,'314','Demografía. Estudios de la población.','314','1'),
(NULL,'314.7','Migración. Inmigración y emigración.','314 7','1'),
(NULL,'316','Sociología.','316','1'),
(NULL,'316.6','Psicología social.','316 6','1'),
(NULL,'316.77','Sociología de la comunicación.','316 77','1'),
(NULL,'32','Política.','32','1'),
(NULL,'321','Formas de organización política.','321','1'),
(NULL,'322','Relaciones entre el Estado y la Iglesia. Política religiosa.','322','1'),
(NULL,'323.28','Persecución política. Terrorismo.','323 28','1'),
(NULL,'323.3','Grupos y estratos sociales. Clases. Profesiones.','323 3','1'),
(NULL,'324','Elecciones. Plebiscitos. Referéndum.','324','1'),
(NULL,'325','Migración. Emigración, colonización.','325','1'),
(NULL,'326','Esclavitud.','326','1'),
(NULL,'327','Política internacional. Relaciones internacionales. Política exterior.','327','1'),
(NULL,'328','Parlamentos y gobiernos.','328','1'),
(NULL,'329','Partidos políticos. Movimientos políticos.','329','1'),
(NULL,'33','Economía en general.','33','1'),
(NULL,'330','Ciencia económica. Economía política. Doctrinas económicas.','330','1'),
(NULL,'330.85','Doctrinas marxistas-leninistas.','330 85','1'),
(NULL,'330.86','Doctrinas no marxistas.','330 86','1'),
(NULL,'331','Trabajo.','331','1'),
(NULL,'331.4','Seguridad laboral. Higiene laboral.','331 4','1'),
(NULL,'332','Economía regional, territorial.','332','1'),
(NULL,'332.2','Política del suelo. Propiedad inmobiliaria. Bienes raíces.','332 2','1'),
(NULL,'334','Formas de organización y cooperación en la economía. Cooperativismo.','334','1'),
(NULL,'336','Finanzas. Hacienda pública.','336','1'),
(NULL,'336.7','Banca. Bolsa. Moneda. Crédito.','336 7','1'),
(NULL,'338','Política económica. Organización, planificación y producción.','338','1'),
(NULL,'338.4','Producción. Servicios según los sectores económicos (alimentación, sector terciario, turismo...).','338 4','1'),
(NULL,'339','Comercio en general. Relaciones económicas internacionales. Economía mundial.','339','1'),
(NULL,'339.1','Mercado.','339 1','1'),
(NULL,'339.17','Instituciones de la actividad comercial (ferias, mercados, intermediarios comerciales, etc.).','339 17','1'),
(NULL,'339.3','Comercio interior.','339 3','1'),
(NULL,'339.5','Comercio exterior.','339 5','1'),
(NULL,'339.9','Economía internacional. Divisas.','339 9','1'),
(NULL,'34','Derecho en general.','34','1'),
(NULL,'340','Derecho comparado. Ciencias auxiliares del Derecho.','340','1'),
(NULL,'340.12','Derecho natural. Filosofía y Teoría del Derecho.','340 12','1'),
(NULL,'340.143','Jurisprudencia.','340 143','1'),
(NULL,'341','Derecho internacional.','341','1'),
(NULL,'342','Derecho constitucional. Derecho político. Derecho público.','342','1'),
(NULL,'342.7','Derechos humanos.','342 7','1'),
(NULL,'342.9','Derecho administrativo.','342 9','1'),
(NULL,'343','Derecho penal.','343','1'),
(NULL,'343.6','Delitos contra la persona.','343 6','1'),
(NULL,'344','Derecho penal especial (militar, marítimo, aéreo).','344','1'),
(NULL,'347','Derecho civil. Derecho privado.','347','1'),
(NULL,'347.1','Derecho de las personas.','347 1','1'),
(NULL,'347.2','Derechos reales. Cosas y bienes. Derecho de cultivo. Agua. Derecho minero.','347 2','1'),
(NULL,'347.4','Contratos y obligaciones. Alquileres.','347 4','1'),
(NULL,'347.5','Responsabilidad civil.','347 5','1'),
(NULL,'347.6','Derecho de familia. Derecho de sucesiones. Herederos.','347 6','1'),
(NULL,'347.7','Derecho mercantil. Derecho marítimo. Derecho de autor.','347 7','1'),
(NULL,'347.8','Derecho aéreo. Derecho de la radiodifusión. Derecho del espacio.','347 8','1'),
(NULL,'347.9','Derecho procesal civil.','347 9','1'),
(NULL,'347.96','Personal judicial.','347 96','1'),
(NULL,'348','Derecho canónico. Derecho eclesiástico.','348','1'),
(NULL,'349','Derechos especiales. Ramas especiales del Derecho.','349','1'),
(NULL,'349.2','Derecho del trabajo.','349 2','1'),
(NULL,'349.3','Derecho social.','349 3','1'),
(NULL,'349.4','Derecho del suelo. Derecho agrario. Derecho urbanístico.','349 4','1'),
(NULL,'349.6','Derecho de protección del medio ambiente.','349 6','1'),
(NULL,'349.7','Derecho de la energía atómica, nuclear.','349 7','1'),
(NULL,'35','Administración pública en general.','35','1'),
(NULL,'35.08','Personal administrativo. Funcionarios.','35 08','1'),
(NULL,'351','Funciones propias de la Administración. Legislación administrativa en general.','351','1'),
(NULL,'352','Administración local.','352','1'),
(NULL,'353','Administración regional. Administración autonómica.','353','1'),
(NULL,'354','Administración central.','354','1'),
(NULL,'355','Asuntos militares. Arte de la guerra.','355','1'),
(NULL,'355.1','Fuerzas armadas en general. Vida militar.','355 1','1'),
(NULL,'355.2','Reclutamiento. Enseñanza.','355 2','1'),
(NULL,'355.3','Organización general de las fuerzas armadas.','355 3','1'),
(NULL,'355.4','Táctica. Estrategia. Historia de las campañas.','355 4','1'),
(NULL,'355.7','Organización de establecimientos, edificios e instalaciones militares.','355 7','1'),
(NULL,'356/359','Cuerpos armados.','356 359','1'),
(NULL,'36','Trabajo social. Ayuda social.','36','1'),
(NULL,'364','Asistencia social.','364','1'),
(NULL,'366','Consumismo.','366','1'),
(NULL,'368','Seguros.','368','1'),
(NULL,'369','Seguridad Social.','369','1'),
(NULL,'37','Educación. Enseñanza.','37','1'),
(NULL,'37.01','Bases de la educación. Pedagogía. Política educativa.','37 01','1'),
(NULL,'37.015','Psicología pedagógica. Sociología de la educación.','37 015','1'),
(NULL,'37.02','Didáctica y metodología.','37 02','1'),
(NULL,'37.03','Formación de la inteligencia y de la personalidad.','37 03','1'),
(NULL,'37.04','Orientación educativa.','37 04','1'),
(NULL,'371','Organización de la educación y la enseñanza. Instituciones.','371','1'),
(NULL,'372','Contenido y currículum de la enseñanza preescolar y elemental.','372','1'),
(NULL,'373','Enseñanza escolar en general.','373','1'),
(NULL,'373.2','Enseñanza preescolar.','373 2','1'),
(NULL,'373.3','Enseñanza primaria.','373 3','1'),
(NULL,'373.5','Enseñanza secundaria.','373 5','1'),
(NULL,'374','Enseñanza y educación extraescolares.','374','1'),
(NULL,'376','Enseñanza y educación de grupos especiales.','376','1'),
(NULL,'377','Formación profesional. Enseñanzas técnicas.','377','1'),
(NULL,'378','Enseñanza superior. Universidades y escuelas especiales con estatus universitario.','378','1'),
(NULL,'379.8','Tiempo libre. Ocio.','379 8','1'),
(NULL,'379.82','Tiempo libre en el hogar. Aficiones. Manualidades.','379 82','1'),
(NULL,'379.83','Entretenimientos exteriores (albergues, campamentos).','379 83','1'),
(NULL,'379.85','Turismo. Organización.','379 85','1'),
(NULL,'39','Etnografía. Etnología.','39','1'),
(NULL,'391','Vestimenta. Indumentaria. Moda.','391','1'),
(NULL,'392','Usos y costumbres en la vida privada.','392','1'),
(NULL,'393','Muerte. Funerales. Ritos funerarios.','393','1'),
(NULL,'394','Vida pública. Vida social.','394','1'),
(NULL,'394.2','Fiestas populares. Fiestas nacionales.','394 2','1'),
(NULL,'395','Ceremonial. Etiqueta. Protocolo.','395','1'),
(NULL,'397.7','Usos y costumbres de razas especiales (gitanos, nómadas, etc.).','397 7','1'),
(NULL,'398','Folclore.','398','1'),
(NULL,'398.2','Narraciones, fábulas, sagas, leyendas, chistes.','398 2','1'),
(NULL,'398.8','Cancionero popular.','398 8','1'),
(NULL,'398.9','Proverbios, dichos populares.','398 9','1'),
(NULL,'5','Ciencias Puras. Ciencias Exactas y Naturales 502 Estudio, conservación y protección de la naturaleza.','5','1'),
(NULL,'502','Estudio, conservación y protección de la naturaleza.','502','1'),
(NULL,'504','Ciencias del medio ambiente.','504','1'),
(NULL,'51','Matemáticas.','51','1'),
(NULL,'511','Aritmética. Teoría de los números.','511','1'),
(NULL,'512','Álgebra.','512','1'),
(NULL,'514','Geometría.','514','1'),
(NULL,'515.1','Topología.','515 1','1'),
(NULL,'517','Análisis matemático.','517','1'),
(NULL,'519.1','Análisis combinatorio. Teoría de los grafos.','519 1','1'),
(NULL,'519.2','Probabilidad y estadística matemática.','519 2','1'),
(NULL,'519.6','Matemáticas computacionales. Análisis numérico.','519 6','1'),
(NULL,'519.7','Cibernética matemática.','519 7','1'),
(NULL,'519.8','Investigación operativa. Teoría de los juegos.','519 8','1'),
(NULL,'52','Astronomía. Astrofísica. Investigación espacial. Geodesia.','52','1'),
(NULL,'521','Astronomía teórica. Mecánica celeste. Astrometría.','521','1'),
(NULL,'523','Sistema solar.','523','1'),
(NULL,'524','Estrellas. El universo.','524','1'),
(NULL,'527','Astronomía náutica. Aeronáutica.','527','1'),
(NULL,'528','Geodesia. Topografía. Cartografía.','528','1'),
(NULL,'53','Física.','53','1'),
(NULL,'531','Mecánica general. Mecánica de los cuerpos sólidos y rígidos.','531','1'),
(NULL,'531.5','Gravitación. Péndulos. Balística.','531 5','1'),
(NULL,'532','Mecánica de los fluidos. Hidráulica.','532','1'),
(NULL,'533','Mecánica de los gases. Aerodinámica.','533','1'),
(NULL,'534','Acústica.','534','1'),
(NULL,'535','Óptica.','535','1'),
(NULL,'536','Termodinámica.','536','1'),
(NULL,'537','Electricidad. Magnetismo.','537','1'),
(NULL,'538.9','Física de la materia condensada.','538 9','1'),
(NULL,'539.1','Física nuclear. Física atómica. Física molecular.','539 1','1'),
(NULL,'54','Química.','54','1'),
(NULL,'542','Química experimental.','542','1'),
(NULL,'543','Química analítica.','543','1'),
(NULL,'544','Química física.','544','1'),
(NULL,'546','Química inorgánica.','546','1'),
(NULL,'547','Química orgánica.','547','1'),
(NULL,'548','Cristalografía.','548','1'),
(NULL,'549','Mineralogía.','549','1'),
(NULL,'55','Geología y ciencias afines. Geología regional.','55','1'),
(NULL,'550.34','Sismología. Terremotos en general.','550 34','1'),
(NULL,'551.1','La Tierra.','551 1','1'),
(NULL,'551.2','Geodinámica interna.','551 2','1'),
(NULL,'551.3','Geodinámica externa. Glaciares.','551 3','1'),
(NULL,'551.4','Geomorfología.','551 4','1'),
(NULL,'551.44','Espeleología. Cuevas, grutas. Aguas subterráneas.','551 44','1'),
(NULL,'551.46','Oceanografía.','551 46','1'),
(NULL,'551.5','Meteorología.','551 5','1'),
(NULL,'551.58','Climatología.','551 58','1'),
(NULL,'551.7','Geología histórica. Estratigrafía.','551 7','1'),
(NULL,'552','Petrología. Petrografía.','552','1'),
(NULL,'553','Geología económica. Minerografía. Yacimientos de minerales.','553','1'),
(NULL,'556','Hidrosfera. Agua en general. Hidrología.','556','1'),
(NULL,'56','Paleontología. Fósiles.','56','1'),
(NULL,'57','Ciencias biológicas en general.','57','1'),
(NULL,'572','Antropología.','572','1'),
(NULL,'573','Biología general.','573','1'),
(NULL,'574','Ecología general.','574','1'),
(NULL,'575','Genética.','575','1'),
(NULL,'576','Biología celular. Citología.','576','1'),
(NULL,'577','Bioquímica. Biología molecular. Biofísica.','577','1'),
(NULL,'578','Virología.','578','1'),
(NULL,'579','Microbiología.','579','1'),
(NULL,'58','Botánica.','58','1'),
(NULL,'581.1','Fisiología vegetal.','581 1','1'),
(NULL,'581.9','Geografía botánica. Flora.','581 9','1'),
(NULL,'582','Botánica sistemática.','582','1'),
(NULL,'59','Zoología.','59','1'),
(NULL,'591.1','Fisiología animal.','591 1','1'),
(NULL,'591.9','Zoología geográfica. Fauna.','591 9','1'),
(NULL,'592','Invertebrados.','592','1'),
(NULL,'594','Moluscos.','594','1'),
(NULL,'595','Articulados.','595','1'),
(NULL,'597.2','Peces. Ictiología.','597 2','1'),
(NULL,'597.6','Anfibios.','597 6','1'),
(NULL,'597/599','Vertebrados en general.','597 599','1'),
(NULL,'598','Saurópsidos (reptiles).','598','1'),
(NULL,'598.2','Aves. Ornitología.','598 2','1'),
(NULL,'599','Mamíferos.','599','1'),
(NULL,'6','Ciencias Aplicadas. Medicina. Técnica.','6','1'),
(NULL,'61','Medicina.','61','1'),
(NULL,'611','Anatomía.','611','1'),
(NULL,'612','Fisiología.','612','1'),
(NULL,'613','Higiene. Sanidad privada.','613','1'),
(NULL,'613.2','Higiene de la alimentación. Dietética.','613 2','1'),
(NULL,'613.4','Cuidado del cuerpo.','613 4','1'),
(NULL,'613.5','Higiene de la vivienda.','613 5','1'),
(NULL,'613.6','Higiene industrial y profesional.','613 6','1'),
(NULL,'613.7','Higiene del descanso.','613 7','1'),
(NULL,'613.81','Bebidas alcohólicas.','613 81','1'),
(NULL,'613.83','Drogas.','613 83','1'),
(NULL,'613.84','Tabaco.','613 84','1'),
(NULL,'613.88','Higiene sexual.','613 88','1'),
(NULL,'614','Sanidad pública. Prevención de accidentes.','614','1'),
(NULL,'614.2','Personal sanitario.','614 2','1'),
(NULL,'615','Medicamentos. Farmacología. Terapéutica física. Toxicología.','615','1'),
(NULL,'616','Patología general. Medicina clínica. Terapéutica.','616','1'),
(NULL,'616.1','Patología del aparato respiratorio.','616 1','1'),
(NULL,'616.2','Patología del aparato respiratorio.','616 2','1'),
(NULL,'616.3','Patología del aparato digestivo. Estomatología.','616 3','1'),
(NULL,'616.4','Endocrinología. Patología del aparato linfático.','616 4','1'),
(NULL,'616.5','Dermatología.','616 5','1'),
(NULL,'616.6','Patología del aparato genito-urinario.','616 6','1'),
(NULL,'616.7','Patología del aparato locomotor.','616 7','1'),
(NULL,'616.8','Neurología. Neuropatología. Psiquiatría.','616 8','1'),
(NULL,'616.9','Enfermedades infecciosas y contagiosas.','616 9','1'),
(NULL,'616-053.2','Pediatría.','616 053 2','1'),
(NULL,'616-053.9','Geriatría.','616 053 9','1'),
(NULL,'617','Cirugía. Ortopedia. Oftalmología.','617','1'),
(NULL,'617.3','Ortopedia.','617 3','1'),
(NULL,'617.5','Cirugía.','617 5','1'),
(NULL,'617.7','Oftalmología.','617 7','1'),
(NULL,'618','Ginecología. Obstetricia.','618','1'),
(NULL,'619','Medicina veterinaria.','619','1'),
(NULL,'62','Tecnología en general. Máquinas en general, sus propiedades y características.','62','1'),
(NULL,'620','Ensayo de materiales. Centrales de energía. Economía de la energía.','620','1'),
(NULL,'621','Ingeniería mecánica. Técnica en general.','621','1'),
(NULL,'621.039','Técnica nuclear. Energía nuclear y atómica en general.','621 039','1'),
(NULL,'621.1','Máquinas de vapor. Calderas.','621 1','1'),
(NULL,'621.22','Energía hidráulica. Fuerza hidroeléctrica.','621 22','1'),
(NULL,'621.3','Ingeniería eléctrica. Electrotecnia.','621 3','1'),
(NULL,'621.39','Telecomunicaciones.','621 39','1'),
(NULL,'621.4','Motores térmicos y otros motores especiales.','621 4','1'),
(NULL,'621.5','Energía neumática. Tecnología del frío.','621 5','1'),
(NULL,'621.6','Máquinas y dispositivos para el transporte y almacenamiento de gases y fluidos.','621 6','1'),
(NULL,'621.7','Tratamiento mecanizado en general (sin arranque de material).','621 7','1'),
(NULL,'621.8','Transmisión mecánica. Engranajes. Medios, formas, dispositivos para la transmisión de productos. Lubricación.','621 8','1'),
(NULL,'621.9','Máquinas herramientas. Transformación (con arranque de material).','621 9','1'),
(NULL,'622','Minería.','622','1'),
(NULL,'623','Ingeniería militar.','623','1'),
(NULL,'624','Ingeniería civil.','624','1'),
(NULL,'625','Técnica de las vías de comunicación terrestres.','625','1'),
(NULL,'626','Ingeniería hidráulica. Construcciones en general. Canales, riegos, drenajes.','626','1'),
(NULL,'627','Cursos de agua naturales. Trabajos hidráulicos en los ríos y en el mar.','627','1'),
(NULL,'628','Ingeniería sanitaria. Agua. Saneamiento. Ingeniería de la iluminación.','628','1'),
(NULL,'628.9','Alumbrado. Luminotecnia.','628 9','1'),
(NULL,'629','Ingeniería del transporte. Técnica de los medios de transporte. Vehículos en general.','629','1'),
(NULL,'629.3','Vehículos terrestres (excepto sobre raíles).','629 3','1'),
(NULL,'629.4','Técnica de los medios de transporte sobre raíles.','629 4','1'),
(NULL,'629.5','Ingeniería de los vehículos acuáticos. Ingeniería naval. Barcos, buques.','629 5','1'),
(NULL,'629.7','Técnica de los medios de transporte aéreo y espacial. Aeronáutica.','629 7','1'),
(NULL,'63','Agricultura.','63','1'),
(NULL,'630','Silvicultura. Ingeniería forestal.','630','1'),
(NULL,'631','Agronomía. Técnicas agrícolas.','631','1'),
(NULL,'632','Enfermedades y plagas de las plantas. Fitopatología.','632','1'),
(NULL,'633','Cultivos específicos. Cereales. Forrajes.','633','1'),
(NULL,'634','Horticultura en general. Árboles frutales. Viticultura.','634','1'),
(NULL,'635','Horticultura especial. Plantas comestibles (hortalizas). Floricultura.','635','1'),
(NULL,'636','Zootecnia general. Ganadería, cría de animales.','636','1'),
(NULL,'637','Productos de los animales domésticos, de la caza y de la pesca.','637','1'),
(NULL,'638','Cría de insectos. Apicultura. Sericultura.','638','1'),
(NULL,'639','Caza y pesca industriales. Piscicultura.','639','1'),
(NULL,'639.1','Caza.','639 1','1'),
(NULL,'639.2','Pesca.','639 2','1'),
(NULL,'639.3','Piscicultura.','639 3','1'),
(NULL,'64','Economía doméstica. Cuidado y administración del hogar. Hostelería.','64','1'),
(NULL,'640.4','Empresas de hostelería y restauración.','640 4','1'),
(NULL,'641','Alimentos.','641','1'),
(NULL,'641.5','Arte culinario.','641 5','1'),
(NULL,'643','La vivienda.','643','1'),
(NULL,'649','Cuidado doméstico de niños, enfermos e invitados.','649','1'),
(NULL,'649.1','Cuidado de niños.','649 1','1'),
(NULL,'65.','Organización y gestión de la industria, el comercio y de las comunicaciones.','65 ','1'),
(NULL,'65.01','Cuestiones de método. Teoría y práctica de la organización.','65 01','1'),
(NULL,'651','Organización y técnicas de trabajo en las oficinas.','651','1'),
(NULL,'654','Organización y gestión de la telecomunicación.','654','1'),
(NULL,'654.19','Radio. Televisión (Radiodifusión).','654 19','1'),
(NULL,'655','Industrias gráficas. Industrias del libro. Imprenta. Editoriales. Librerías.','655','1'),
(NULL,'656','Organización y gestión de los transportes. Servicio postal.','656','1'),
(NULL,'656.1','Transporte por carretera.','656 1','1'),
(NULL,'656.2','Transporte ferroviario.','656 2','1'),
(NULL,'656.6','Transporte por agua.','656 6','1'),
(NULL,'656.7','Transporte aéreo.','656 7','1'),
(NULL,'656.71','Aeropuertos.','656 71','1'),
(NULL,'656.8','Correos. Filatelia.','656 8','1'),
(NULL,'657','Contabilidad. Auditoría.','657','1'),
(NULL,'658','Organización de empresas. Técnica comercial.','658','1'),
(NULL,'658.3','Personal. Relaciones humanas en la empresa 658.8 Organización de mercados. «Marketing». Ventas. Distribución.','658 3','1'),
(NULL,'658.8','Organización de mercados. «Marketing». Ventas. Distribución.','658 8','1'),
(NULL,'659','Publicidad y propaganda. Información comercial. Relaciones públicas.','659','1'),
(NULL,'66','Industria química. Tecnología química. Industrias afines.','66','1'),
(NULL,'661','Productos químicos en general.','661','1'),
(NULL,'662','Pirotecnia. Explosivos. Combustibles.','662','1'),
(NULL,'662.2','Explosivos.','662 2','1'),
(NULL,'663','Microbiología y micología industriales. Bebidas. Estimulantes.','663','1'),
(NULL,'664','Fabricación y conservación de alimentos sólidos.','664','1'),
(NULL,'665','Fabricación de aceites, grasas y ceras. Adhesivos. Gomas. Resinas.','665','1'),
(NULL,'666','Industria del vidrio, cerámica, cemento y hormigón.','666','1'),
(NULL,'667','Industrias del color. Fabricación y uso de colorantes, tintas, pinturas, etc.','667','1'),
(NULL,'669','Metalurgia.','669','1'),
(NULL,'67/68','Industria y oficios diversos.','67 68','1'),
(NULL,'671','Joyería. Industrias de los metales y piedras preciosas.','671','1'),
(NULL,'672','Industrias de artículos de hierro y acero en general, metales no ferrosos ni preciosos.','672','1'),
(NULL,'674','Madera e industria de la madera.','674','1'),
(NULL,'675','Industria de cuero. Tratamiento de pieles.','675','1'),
(NULL,'676','Industria del papel y cartón.','676','1'),
(NULL,'677','Industria textil.','677','1'),
(NULL,'678','Industria del caucho. Industria de los plásticos.','678','1'),
(NULL,'679','Industria del cable y de la cordelería. Industrias de la piedra y otros productos naturales.','679','1'),
(NULL,'681','Mecánica de precisión. Relojería. Balanzas, básculas.','681','1'),
(NULL,'681.5','Ingeniería del control automático.','681 5','1'),
(NULL,'681.6','Máquinas reproductoras e impresoras.','681 6','1'),
(NULL,'681.7','Aparatos e instrumentos ópticos.','681 7','1'),
(NULL,'681.8','Técnica acústica. Instrumentos musicales.','681 8','1'),
(NULL,'682','Herrería. Trabajos de forja y fundición.','682','1'),
(NULL,'683','Ferretería. Cerrajería. Lámparas de combustión. Estufas, hornos, calentadores.','683','1'),
(NULL,'684','Industria del mueble y afines. Tapicería.','684','1'),
(NULL,'685','Guarnicionería. Marroquinería. Zapatería. Artículos de viaje, deportes y juegos.','685','1'),
(NULL,'686','Encuadernación. Dorado. Artículos de oficina.','686','1'),
(NULL,'687','Industria del vestido. Artículos de tocador.','687','1'),
(NULL,'687.5','Artículos de fantasía. Juguetes. Artículos de decoración.','687 5','1'),
(NULL,'688','Artículos de fantasía. Juguetes. Artículos de decoración.','688','1'),
(NULL,'689','Bricolaje. Aficiones técnicas o manuales.','689','1'),
(NULL,'69','Construcción. Trabajos y materiales de construcción en general.','69','1'),
(NULL,'691','Materiales de construcción y componentes.','691','1'),
(NULL,'692','Partes estructurales y elementos de la construcción.','692','1'),
(NULL,'693','Albañilería. Construcciones de hormigón y acero.','693','1'),
(NULL,'694','Construcción de madera. Carpintería. Ebanistería.','694','1'),
(NULL,'696','Instalaciones y servicios en la construcción (sanitarios, de gas, vapor, electricidad).','696','1'),
(NULL,'697','Instalaciones de calefacción, ventilación y climatización en los edificios.','697','1'),
(NULL,'699.8','Medidas de seguridad en los edificios.','699 8','1'),
(NULL,'7.','Arte en general. Bellas Artes. Deportes.','7 ','1'),
(NULL,'7.01','Teoría general del arte. Estética. Filosofía del arte.','7 01','1'),
(NULL,'7.025','Restauración.','7 025','1'),
(NULL,'7.03','Estilos artísticos.','7 03','1'),
(NULL,'7.032','Estilos de la antigüedad.','7 032','1'),
(NULL,'7.033','Arte medieval.','7 033','1'),
(NULL,'7.033.4','Arte románico.','7 033 4','1'),
(NULL,'7.033.5','Arte gótico.','7 033 5','1'),
(NULL,'7.034','Renacimiento. Barroco.','7 034','1'),
(NULL,'7.035','Neoclasicismo y movimiento romántico.','7 035','1'),
(NULL,'7.036','Movimientos artísticos modernos (siglo XX).','7 036','1'),
(NULL,'7.04','Iconografía.','7 04','1'),
(NULL,'7.074','Coleccionismo.','7 074','1'),
(NULL,'71','Urbanismo. Ordenación del territorio.','71','1'),
(NULL,'711.3','Ordenación rural. Desarrollo rural.','711 3','1'),
(NULL,'711.4','Ordenación urbana.','711 4','1'),
(NULL,'715','Ordenación del paisaje. Parques y jardines.','715','1'),
(NULL,'72','Arquitectura.','72','1'),
(NULL,'721','Edificios en general.','721','1'),
(NULL,'725','Edificios públicos. Edificios comerciales. Edificios administrativos.','725','1'),
(NULL,'726','Edificios religiosos. Edificios funerarios.','726','1'),
(NULL,'727','Edificios docentes. Edificios con finalidad científica y cultural.','727','1'),
(NULL,'728','Viviendas en general.','728','1'),
(NULL,'73','Artes plásticas. Escultura.','73','1'),
(NULL,'736','Arte de tallar piedras preciosas. Sigilografía.','736','1'),
(NULL,'737','Numismática.','737','1'),
(NULL,'738','Cerámica. Alfarería.','738','1'),
(NULL,'739','Trabajos artísticos en metal.','739','1'),
(NULL,'741','Dibujo en general.','741','1'),
(NULL,'742','Perspectiva en dibujo.','742','1'),
(NULL,'743','Dibujo anatómico.','743','1'),
(NULL,'744','Dibujo lineal y geométrico. Dibujo técnico.','744','1'),
(NULL,'745','Artesanía decorativa.','745','1'),
(NULL,'746','Trabajos manuales de aguja, rafia, mimbre, etc.','746','1'),
(NULL,'747','Decoraciones de interiores.','747','1'),
(NULL,'748','Vidrios y cristales artísticos.','748','1'),
(NULL,'749.1','Muebles artísticos.','749 1','1'),
(NULL,'75','Pintura.','75','1'),
(NULL,'76','Artes gráficas. Grabados.','76','1'),
(NULL,'77','Fotografía.','77','1'),
(NULL,'771','Equipo fotográfico.','771','1'),
(NULL,'772','Procedimientos fotomecánicos de reproducción.','772','1'),
(NULL,'778','Aplicaciones de la fotografía.','778','1'),
(NULL,'78','Música. Géneros musicales. Métodos y estudios de Música para los distintos instrumentos.','78','1'),
(NULL,'79','Diversiones. Juegos. Deportes. Espectáculos públicos.','79','1'),
(NULL,'791.4','Cine.','791 4','1'),
(NULL,'791.8','Circos. Zoológicos.','791 8','1'),
(NULL,'791.862','Corridas de toros. Tauromaquia.','791 862','1'),
(NULL,'792','Teatro. Teoría y técnica teatral.','792','1'),
(NULL,'793','Diversiones de sociedad. Baile.','793','1'),
(NULL,'794','Juegos de tablero y mesa.','794','1'),
(NULL,'794.1','Ajedrez.','794 1','1'),
(NULL,'796','Deportes. Juegos. Gimnasia. Ejercicios físicos.','796','1'),
(NULL,'796.3','Juegos de pelota.','796 3','1'),
(NULL,'796.4','Gimnasia. Atletismo.','796 4','1'),
(NULL,'796.5','Excursiones. Montañismo. Camping.','796 5','1'),
(NULL,'796.6','Deportes sobre ruedas. Ciclismo.','796 6','1'),
(NULL,'796.7','Automovilismo. Motociclismo.','796 7','1'),
(NULL,'796.8','Deportes de combate y defensa.','796 8','1'),
(NULL,'796.9','Deportes de invierno. Juegos sobre hielo.','796 9','1'),
(NULL,'797','Deportes acuáticos. Deportes aéreos.','797','1'),
(NULL,'798','Deportes hípicos.','798','1'),
(NULL,'799','Pesca deportiva. Caza deportiva. Tiro deportivo.','799','1'),
(NULL,'8','Lenguajes, Lingüística y Literatura 80 Lingüística. Filología.','8','1'),
(NULL,'80','Lingüística. Filología.','80','1'),
(NULL,'801.6','Métrica. Prosodia.','801 6','1'),
(NULL,'806','Lenguas ibéricas.','806','1'),
(NULL,'807','Lenguas clásicas.','807','1'),
(NULL,'81','Lingüística y lenguas.','81','1'),
(NULL,'811','Clasificación general de las lenguas.','811','1'),
(NULL,'811.11','Lenguas germánicas.','811 11','1'),
(NULL,'811.111','Inglés.','811 111','1'),
(NULL,'811.13','Lenguas romances.','811 13','1'),
(NULL,'811.131.1','Italiano.','811 131 1','1'),
(NULL,'811.133.1','Francés.','811 133 1','1'),
(NULL,'811.133.2','Provenzal.','811 133 2','1'),
(NULL,'811.134.1','Catalán.','811 134 1','1'),
(NULL,'811.134.11','Variedades del catalán. Valenciano.','811 134 11','1'),
(NULL,'811.134.2','Español.','811 134 2','1'),
(NULL,'811.134.2''282','Dialectos del español.','811 134 2 282','1'),
(NULL,'811.134.3','Portugués.','811 134 3','1'),
(NULL,'811.134.4','Gallego.','811 134 4','1'),
(NULL,'811.14''02','Griego clásico.','811 14 02','1'),
(NULL,'811.14''06','Griego moderno.','811 14 06','1'),
(NULL,'811.16/.17','Lenguas eslavas y bálticas.','811 16  17','1'),
(NULL,'811.361','Vasco (Euskera).','811 361','1'),
(NULL,'811.41/.87','Lenguas orientales, africanas y otras lenguas.','811 41  87','1'),
(NULL,'811.51','Lenguas uralo-altaicas (turanias, manchú, turco, húngaro, lapón...).','811 51','1'),
(NULL,'811.61','Lenguas austro-asiáticas (malayo-polinésicas, oceánicas).','811 61','1'),
(NULL,'811.8','Lenguas indias de América (Amerindias) (del norte, centro y sur de América).','811 8','1'),
(NULL,'811.92','Lenguajes artificiales para uso entre los hombres.','811 92','1'),
(NULL,'812.112.2','Alemán.','812 112 2','1'),
(NULL,'81''34','Fonética. Fonología.','81 34','1'),
(NULL,'81''35','Ortografía.','81 35','1'),
(NULL,'81''36','Gramática. Sintaxis.','81 36','1'),
(NULL,'81''373','Lexicología. Toponimia.','81 373','1'),
(NULL,'81''374','Lexicografía 82 Literatura general.','81 374','1'),
(NULL,'82','Literatura general.','82','1'),
(NULL,'82(09)','Crítica literaria. Historia de la literatura.','82 09 ','1'),
(NULL,'821.11','Literatura en otras lenguas germánicas. Historia y crítica. Obras.','821 11','1'),
(NULL,'821.111','Literatura en lengua inglesa. Historia y crítica. Obras.','821 111','1'),
(NULL,'821.111-1','Literatura en lengua inglesa. Poesía.','821 111 1','1'),
(NULL,'821.111-2','Literatura en lengua inglesa. Teatro.','821 111 2','1'),
(NULL,'821.111-3','Literatura en lengua inglesa. Novela y cuento.','821 111 3','1'),
(NULL,'821.111-4/-9','Literatura en lengua inglesa. Otros géneros.','821 111 4  9','1'),
(NULL,'821.112.2','Literatura en lengua alemana. Historia y crítica. Obras.','821 112 2','1'),
(NULL,'821.112.2-1','Literatura en lengua alemana. Poesía.','821 112 2 1','1'),
(NULL,'821.112.2-2','Literatura en lengua alemana. Teatro.','821 112 2 2','1'),
(NULL,'821.112.2-3','Literatura en lengua alemana. Novela y cuento.','821 112 2 3','1'),
(NULL,'821.112.2-4/-9','Literatura en lengua alemana. Otros géneros.','821 112 2 4  9','1'),
(NULL,'821.124','Literatura latina. Historia y crítica. Obras.','821 124','1'),
(NULL,'821.131.1','Literatura en lengua italiana. Historia y crítica. Obras.','821 131 1','1'),
(NULL,'821.131.1-1','Literatura en lengua italiana. Poesía.','821 131 1 1','1'),
(NULL,'821.131.1-2','Literatura en lengua italiana. Teatro.','821 131 1 2','1'),
(NULL,'821.131.1-3','Literatura en lengua italiana. Novela y cuento.','821 131 1 3','1'),
(NULL,'821.131.1-4/-9','Literatura en lengua italiana. Otros géneros.','821 131 1 4  9','1'),
(NULL,'821.133.1','Literatura en lengua francesa. Historia y crítica. Obras.','821 133 1','1'),
(NULL,'821.133.1-1','Literatura en lengua francesa. Poesía.','821 133 1 1','1'),
(NULL,'821.133.1-2','Literatura en lengua francesa. Teatro.','821 133 1 2','1'),
(NULL,'821.133.1-3','Literatura en lengua francesa. Novela y cuento.','821 133 1 3','1'),
(NULL,'821.133.1-4/-9','Literatura en lengua francesa. Otros géneros.','821 133 1 4  9','1'),
(NULL,'821.134.1','Literatura catalana. Historia y crítica.','821 134 1','1'),
(NULL,'821.134.1-1','Literatura catalana. Poesía.','821 134 1 1','1'),
(NULL,'821.134.1-2','Literatura catalana. Teatro.','821 134 1 2','1'),
(NULL,'821.134.1-3','Literatura catalana. Novela y cuento.','821 134 1 3','1'),
(NULL,'821.134.1-4/-9','Literatura catalana. Otros géneros.','821 134 1 4  9','1'),
(NULL,'821.134.2','Literatura española. Historia y crítica.','821 134 2','1'),
(NULL,'821.134.2-1','Literatura española. Poesía.','821 134 2 1','1'),
(NULL,'821.134.2-2','Literatura española. Teatro.','821 134 2 2','1'),
(NULL,'821.134.2''282','Literatura española dialectal.','821 134 2 282','1'),
(NULL,'821.134.2-3','Literatura española. Novela y cuento.','821 134 2 3','1'),
(NULL,'821.134.2-4/-9','Literatura española. Otros géneros.','821 134 2 4  9','1'),
(NULL,'821.134.27','Literatura de América del Norte y Central en lengua española.','821 134 27','1'),
(NULL,'821.134.27-1','Literatura de América del Norte y Central en lengua española.','821 134 27 1','1'),
(NULL,'821.134.272','Literatura mexicana. Historia y crítica. Obras.','821 134 272','1'),
(NULL,'821.134.27-2','Literatura de América del Norte y Central en lengua española.','821 134 27 2','1'),
(NULL,'821.134.272.81','Literatura guatemalteca. Historia y crítica. Obras.','821 134 272 81','1'),
(NULL,'821.134.272.81-1','Literatura guatemalteca. Poesía.','821 134 272 81 1','1'),
(NULL,'821.134.272.81-2','Literatura guatemalteca. Teatro.','821 134 272 81 2','1'),
(NULL,'821.134.272.81-3','Literatura guatemalteca. Novela y cuento.','821 134 272 81 3','1'),
(NULL,'821.134.272.81-4/-9','Literatura guatemalteca. Otros géneros.','821 134 272 81 4  9','1'),
(NULL,'821.134.272.83','Literatura hondureña. Historia y crítica. Obras.','821 134 272 83','1'),
(NULL,'821.134.272.83-1','Literatura hondureña. Poesía.','821 134 272 83 1','1'),
(NULL,'821.134.272.83-2','Literatura hondureña. Teatro.','821 134 272 83 2','1'),
(NULL,'821.134.272.83-3','Literatura hondureña. Novela y cuento.','821 134 272 83 3','1'),
(NULL,'821.134.272.83-4/-9','Literatura hondureña. Otros géneros.','821 134 272 83 4  9','1'),
(NULL,'821.134.272.84','Literatura salvadoreña. Historia y crítica. Obras.','821 134 272 84','1'),
(NULL,'821.134.272.84-1','Literatura salvadoreña. Poesía.','821 134 272 84 1','1'),
(NULL,'821.134.272.84-2','Literatura salvadoreña. Teatro.','821 134 272 84 2','1'),
(NULL,'821.134.272.84-3','Literatura salvadoreña. Novela y cuento.','821 134 272 84 3','1'),
(NULL,'821.134.272.84-4/-9','Literatura salvadoreña. Otros géneros.','821 134 272 84 4  9','1'),
(NULL,'821.134.272.85','Literatura nicaragüense. Historia y crítica. Obras.','821 134 272 85','1'),
(NULL,'821.134.272.85-1','Literatura nicaragüense. Poesía.','821 134 272 85 1','1'),
(NULL,'821.134.272.85-2','Literatura nicaragüense. Teatro.','821 134 272 85 2','1'),
(NULL,'821.134.272.85-3','Literatura nicaragüense. Novela y cuento.','821 134 272 85 3','1'),
(NULL,'821.134.272.85-4/-9','Literatura nicaragüense. Otros géneros.','821 134 272 85 4  9','1'),
(NULL,'821.134.272.86','Literatura costarricense. Historia y crítica. Obras.','821 134 272 86','1'),
(NULL,'821.134.272.86-1','Literatura costarricense. Poesía.','821 134 272 86 1','1'),
(NULL,'821.134.272.86-2','Literatura costarricense. Teatro.','821 134 272 86 2','1'),
(NULL,'821.134.272.86-3','Literatura costarricense. Novela y cuento.','821 134 272 86 3','1'),
(NULL,'821.134.272.86-4/-9','Literatura costarricense. Otros géneros.','821 134 272 86 4  9','1'),
(NULL,'821.134.272.87','Literatura panameña. Historia y crítica. Obras.','821 134 272 87','1'),
(NULL,'821.134.272.87-1','Literatura panameña. Poesía.','821 134 272 87 1','1'),
(NULL,'821.134.272.87-2','Literatura panameña. Teatro.','821 134 272 87 2','1'),
(NULL,'821.134.272.87-3','Literatura panameña. Novela y cuento.','821 134 272 87 3','1'),
(NULL,'821.134.272.87-4/-9','Literatura panameña. Otros géneros.','821 134 272 87 4  9','1'),
(NULL,'821.134.272.91','Literatura cubana. Historia y crítica. Obras.','821 134 272 91','1'),
(NULL,'821.134.272.91-1','Literatura cubana. Poesía.','821 134 272 91 1','1'),
(NULL,'821.134.272.91-2','Literatura cubana. Teatro.','821 134 272 91 2','1'),
(NULL,'821.134.272.91-3','Literatura cubana. Novela y cuento.','821 134 272 91 3','1'),
(NULL,'821.134.272.91-4/-9','Literatura cubana. Otros géneros.','821 134 272 91 4  9','1'),
(NULL,'821.134.272.93','Literatura dominicana. Historia y crítica. Obras.','821 134 272 93','1'),
(NULL,'821.134.272.93-4/-9','Literatura dominicana. Otros géneros.','821 134 272 93 4  9','1'),
(NULL,'821.134.272.95','Literatura puertorriqueña. Historia y crítica. Obras.','821 134 272 95','1'),
(NULL,'821.134.272.95-1','Literatura puertorriqueña. Poesía.','821 134 272 95 1','1'),
(NULL,'821.134.272.95-2','Literatura puertorriqueña. Teatro.','821 134 272 95 2','1'),
(NULL,'821.134.272.95-3','Literatura puertorriqueña. Novela y cuento.','821 134 272 95 3','1'),
(NULL,'821.134.272.95-4/-9','Literatura puertorriqueña. Otros géneros.','821 134 272 95 4  9','1'),
(NULL,'821.134.272-1','Literatura mexicana. Poesía.','821 134 272 1','1'),
(NULL,'821.134.272-2','Literatura mexicana. Teatro.','821 134 272 2','1'),
(NULL,'821.134.272-3','Literatura mexicana. Novela y cuento.','821 134 272 3','1'),
(NULL,'821.134.272-4/-9','Literatura mexicana. Otros géneros.','821 134 272 4  9','1'),
(NULL,'821.134.27-3','Literatura de América del Norte y Central en lengua española.','821 134 27 3','1'),
(NULL,'821.134.27-4/-9','Literatura de América del Norte y Central en lengua española. Otros géneros.','821 134 27 4  9','1'),
(NULL,'821.134.28','Literatura de América del Sur en lengua española. Historia y crítica. Obras.','821 134 28','1'),
(NULL,'821.134.28-1','Literatura de América del Sur en lengua española. Poesía.','821 134 28 1','1'),
(NULL,'821.134.282','Literatura argentina. Historia y crítica. Obras.','821 134 282','1'),
(NULL,'821.134.28-2','Literatura de América del Sur en lengua española. Teatro.','821 134 28 2','1'),
(NULL,'821.134.282-1','Literatura argentina. Poesía.','821 134 282 1','1'),
(NULL,'821.134.282-2','Literatura argentina. Teatro.','821 134 282 2','1'),
(NULL,'821.134.282-3','Literatura argentina. Novela y cuento.','821 134 282 3','1'),
(NULL,'821.134.282-4/-9','Literatura argentina. Otros géneros.','821 134 282 4  9','1'),
(NULL,'821.134.283','Literatura chilena. Historia y crítica. Obras.','821 134 283','1'),
(NULL,'821.134.28-3','Literatura de América del Sur en lengua española. Novela y cuento.','821 134 28 3','1'),
(NULL,'821.134.283-1','Literatura chilena. Poesía.','821 134 283 1','1'),
(NULL,'821.134.283-2','Literatura chilena. Teatro.','821 134 283 2','1'),
(NULL,'821.134.283-3','Literatura chilena. Novela y cuento.','821 134 283 3','1'),
(NULL,'821.134.283-4/-9','Literatura chilena. Otros géneros.','821 134 283 4  9','1'),
(NULL,'821.134.284','Literatura boliviana. Historia y crítica. Obras.','821 134 284','1'),
(NULL,'821.134.28-4/-9','Literatura de América del Sur en lengua española. Otros géneros.','821 134 28 4  9','1'),
(NULL,'821.134.284-1','Literatura boliviana. Poesía.','821 134 284 1','1'),
(NULL,'821.134.284-2','Literatura boliviana. Teatro.','821 134 284 2','1'),
(NULL,'821.134.284-3','Literatura boliviana. Novela y cuento.','821 134 284 3','1'),
(NULL,'821.134.284-4/-9','Literatura boliviana. Otros géneros.','821 134 284 4  9','1'),
(NULL,'821.134.285','Literatura peruana. Historia y crítica. Obras.','821 134 285','1'),
(NULL,'821.134.285-1','Literatura peruana. Poesía.','821 134 285 1','1'),
(NULL,'821.134.285-2','Literatura peruana. Teatro.','821 134 285 2','1'),
(NULL,'821.134.285-3','Literatura peruana. Novela y cuento.','821 134 285 3','1'),
(NULL,'821.134.285-4/-9','Literatura peruana. Otros géneros.','821 134 285 4  9','1'),
(NULL,'821.134.286.1','Literatura colombiana. Historia y crítica. Obras.','821 134 286 1','1'),
(NULL,'821.134.286.1-1','Literatura colombiana. Poesía.','821 134 286 1 1','1'),
(NULL,'821.134.286.1-2','Literatura colombiana. Teatro.','821 134 286 1 2','1'),
(NULL,'821.134.286.1-3','Literatura colombiana. Novela y cuento.','821 134 286 1 3','1'),
(NULL,'821.134.286.1-4/-9','Literatura colombiana. Otros géneros.','821 134 286 1 4  9','1'),
(NULL,'821.134.286.6','Literatura ecuatoriana. Historia y crítica. Obras.','821 134 286 6','1'),
(NULL,'821.134.286.6-1','Literatura ecuatoriana. Poesía.','821 134 286 6 1','1'),
(NULL,'821.134.286.6-2','Literatura ecuatoriana. Teatro.','821 134 286 6 2','1'),
(NULL,'821.134.286.6-3','Literatura ecuatoriana. Novela y cuento.','821 134 286 6 3','1'),
(NULL,'821.134.286.6-4/-9','Literatura ecuatoriana. Otros géneros.','821 134 286 6 4  9','1'),
(NULL,'821.134.287','Literatura venezolana. Historia y crítica. Obras.','821 134 287','1'),
(NULL,'821.134.287-1','Literatura venezolana. Poesía.','821 134 287 1','1'),
(NULL,'821.134.287-2','Literatura venezolana. Teatro.','821 134 287 2','1'),
(NULL,'821.134.287-3','Literatura venezolana. Novela y cuento.','821 134 287 3','1'),
(NULL,'821.134.287-4/-9','Literatura venezolana. Otros géneros.','821 134 287 4  9','1'),
(NULL,'821.134.289.2','Literatura paraguaya. Historia y crítica. Obras.','821 134 289 2','1'),
(NULL,'821.134.289.2-1','Literatura paraguaya. Poesía.','821 134 289 2 1','1'),
(NULL,'821.134.289.2-2','Literatura paraguaya. Teatro.','821 134 289 2 2','1'),
(NULL,'821.134.289.2-3','Literatura paraguaya. Novela y cuento.','821 134 289 2 3','1'),
(NULL,'821.134.289.2-4/-9','Literatura paraguaya. Otros géneros.','821 134 289 2 4  9','1'),
(NULL,'821.134.289.9','Literatura uruguaya. Historia y crítica. Obras.','821 134 289 9','1'),
(NULL,'821.134.289.9-1','Literatura uruguaya. Poesía.','821 134 289 9 1','1'),
(NULL,'821.134.289.9-2','Literatura uruguaya. Teatro.','821 134 289 9 2','1'),
(NULL,'821.134.289.9-3','Literatura uruguaya. Novela y cuento.','821 134 289 9 3','1'),
(NULL,'821.134.289.9-4/-9','Literatura uruguaya. Otros géneros.','821 134 289 9 4  9','1'),
(NULL,'821.134.3','Literatura en lengua portuguesa. Historia y crítica. Obras.','821 134 3','1'),
(NULL,'821.134.3-1','Literatura en lengua portuguesa. Poesía.','821 134 3 1','1'),
(NULL,'821.134.3-2','Literatura en lengua portuguesa. Teatro.','821 134 3 2','1'),
(NULL,'821.134.3-3','Literatura en lengua portuguesa. Novela y cuento.','821 134 3 3','1'),
(NULL,'821.134.3-4/9','Literatura en lengua portuguesa. Otros géneros.','821 134 3 4 9','1'),
(NULL,'821.134.4','Literatura gallega. Historia y crítica. Obras.','821 134 4','1'),
(NULL,'821.134.4-1','Literatura gallega. Poesía.','821 134 4 1','1'),
(NULL,'821.134.4-2','Literatura gallega. Teatro.','821 134 4 2','1'),
(NULL,'821.134.4-3','Literatura gallega. Novela y cuento.','821 134 4 3','1'),
(NULL,'821.134.4-4/-9','Literatura gallega. Otros géneros.','821 134 4 4  9','1'),
(NULL,'821.14''02','Literatura griega clásica. Historia y crítica. Obras.','821 14 02','1'),
(NULL,'821.14''06','Literatura griega moderna. Historia y crítica. Obras.','821 14 06','1'),
(NULL,'821.16/.17','Literaturas eslavas y bálticas.','821 16  17','1'),
(NULL,'821.161.1','Literatura rusa. Historia y crítica. Obras.','821 161 1','1'),
(NULL,'821.162.1','Literatura polaca. Historia y crítica. Obras.','821 162 1','1'),
(NULL,'821.162.3','Literatura checa.','821 162 3','1'),
(NULL,'821.163','Literatura búlgara, serbia y croata.','821 163','1'),
(NULL,'821.361','Literatura vasca (en euskera). Historia y crítica. Obras.','821 361','1'),
(NULL,'821.361-1','Literatura vasca (en euskera). Poesía.','821 361 1','1'),
(NULL,'821.361-2','Literatura vasca (en euskera). Teatro.','821 361 2','1'),
(NULL,'821.361-3','Literatura vasca (en euskera). Novela y cuento.','821 361 3','1'),
(NULL,'821.361-4/-9','Literatura vasca (en euskera). Otros géneros.','821 361 4  9','1'),
(NULL,'821.411.21','Literatura árabe.','821 411 21','1'),
(NULL,'821.521','Literatura japonesa. Historia y crítica. Obras.','821 521','1'),
(NULL,'82-993','Literatura licenciosa, erótica y pornográfica.','82 993','1'),
(NULL,'87','Literaturas clásicas. Historia y crítica. Obras.','87','1'),
(NULL,'89','Otras literaturas.','89','1'),
(NULL,'9.','Geografía. Biografía. Historia.','9 ','1'),
(NULL,'902','Arqueología.','902','1'),
(NULL,'903','Prehistoria. Restos prehistóricos.','903','1'),
(NULL,'904','Restos culturales de tiempos históricos.','904','1'),
(NULL,'908','Descripción geográfico-histórica de un territorio, una localidad.','908','1'),
(NULL,'91','Geografía general. Historia de la geografía.','91','1'),
(NULL,'910','Geografía como ciencia. Cuestiones generales. Viajes.','910','1'),
(NULL,'910.4','Viajes de descubrimientos. Expediciones.','910 4','1'),
(NULL,'911.2','Geografía física.','911 2','1'),
(NULL,'911.3','Geografía humana, social y cultural.','911 3','1'),
(NULL,'912','Mapas. Atlas geográficos. Globos terráqueos.','912','1'),
(NULL,'913','Geografía del mundo antiguo. Geografía regional en general.','913','1'),
(NULL,'914','Geografía de Europa.','914','1'),
(NULL,'914.60','Geografía de España.','914 60','1'),
(NULL,'914.601.1','Geografía de Galicia.','914 601 1','1'),
(NULL,'914.601.2','Geografía del Principado de Asturias.','914 601 2','1'),
(NULL,'914.601.3','Geografía de Cantabria.','914 601 3','1'),
(NULL,'914.601.5','Geografía del País Vasco.','914 601 5','1'),
(NULL,'914.601.6','Geografía de Navarra.','914 601 6','1'),
(NULL,'914.601.8','Geografía de Castilla y León.','914 601 8','1'),
(NULL,'914.602.1','Geografía de La Rioja.','914 602 1','1'),
(NULL,'914.602.2','Geografía de Aragón.','914 602 2','1'),
(NULL,'914.602.3','Geografía de Cataluña.','914 602 3','1'),
(NULL,'914.602.5','Geografía de Extremadura.','914 602 5','1'),
(NULL,'914.602.7','Geografía de la Comunidad Autónoma de Madrid.','914 602 7','1'),
(NULL,'914.602.8','Geografía de Castilla-La Mancha.','914 602 8','1'),
(NULL,'914.603.1','Geografía de la Comunidad Autónoma Valenciana.','914 603 1','1'),
(NULL,'914.603.2','Geografía de las Baleares.','914 603 2','1'),
(NULL,'914.603.3','Geografía de la Región de Murcia.','914 603 3','1'),
(NULL,'914.603.5','Geografía de Andalucía.','914 603 5','1'),
(NULL,'914.604.1','Geografía de Canarias.','914 604 1','1'),
(NULL,'915','Geografía de Asia.','915','1'),
(NULL,'916','Geografía de África.','916','1'),
(NULL,'917','Geografía de América del Norte y Central.','917','1'),
(NULL,'917.2','Geografía de México.','917 2','1'),
(NULL,'917.281','Geografía de Guatemala.','917 281','1'),
(NULL,'917.282','Geografía de Belice.','917 282','1'),
(NULL,'917.283','Geografía de Honduras.','917 283','1'),
(NULL,'917.284','Geografía de El Salvador.','917 284','1'),
(NULL,'917.285','Geografía de Nicaragua.','917 285','1'),
(NULL,'917.286','Geografía de Costa Rica.','917 286','1'),
(NULL,'917.287','Geografía de Panamá.','917 287','1'),
(NULL,'917.291','Geografía de Cuba.','917 291','1'),
(NULL,'917.292','Geografía de Jamaica.','917 292','1'),
(NULL,'917.293','Geografía de la República Dominicana.','917 293','1'),
(NULL,'917.294','Geografía de Haití.','917 294','1'),
(NULL,'917.295','Geografía de Puerto Rico.','917 295','1'),
(NULL,'917.297/.299','Geografía de las Pequeñas Antillas.','917 297  299','1'),
(NULL,'918','Geografía de América del Sur.','918','1'),
(NULL,'918.1','Geografía de Brasil.','918 1','1'),
(NULL,'918.2','Geografía de Argentina.','918 2','1'),
(NULL,'918.3','Geografía de Chile.','918 3','1'),
(NULL,'918.4','Geografía de Bolivia.','918 4','1'),
(NULL,'918.5','Geografía de Perú.','918 5','1'),
(NULL,'918.61','Geografía de Colombia.','918 61','1'),
(NULL,'918.66','Geografía de Ecuador.','918 66','1'),
(NULL,'918.7','Geografía de Venezuela.','918 7','1'),
(NULL,'918.92','Geografía de Paraguay.','918 92','1'),
(NULL,'918.99','Geografía de Uruguay.','918 99','1'),
(NULL,'919','Geografía de Australia, Oceanía y de las regiones polares.','919','1'),
(NULL,'929','Biografías.','929','1'),
(NULL,'929.5','Genealogía.','929 5','1'),
(NULL,'929.6','Heráldica. Blasones. Escudos de armas.','929 6','1'),
(NULL,'929.7','Nobleza.','929 7','1'),
(NULL,'93','Historia.','93','1'),
(NULL,'930','Ciencias auxiliares de la historia.','930','1'),
(NULL,'930.1','Filosofía de la historia.','930 1','1'),
(NULL,'930.25','Archivística. Archivos 930.85 Historia de la civilización. Historia de la cultura.','930 25','1'),
(NULL,'930.85','Historia de la civilización. Historia de la cultura.','930 85','1'),
(NULL,'930.9','Historia universal.','930 9','1'),
(NULL,'931','Historia del mundo antiguo.','931','1'),
(NULL,'94','Historia de la Edad Media y Moderna en general.','94','1'),
(NULL,'940','Historia de Europa.','940','1'),
(NULL,'946.0','Historia de España.','946 0','1'),
(NULL,'946.011','Historia de Galicia.','946 011','1'),
(NULL,'946.012','Historia del Principado de Asturias.','946 012','1'),
(NULL,'946.013','Historia de Cantabria.','946 013','1'),
(NULL,'946.015','Historia del País Vasco.','946 015','1'),
(NULL,'946.016','Historia de Navarra.','946 016','1'),
(NULL,'946.018','Historia de Castilla y León.','946 018','1'),
(NULL,'946.021','Historia de La Rioja.','946 021','1'),
(NULL,'946.022','Historia de Aragón.','946 022','1'),
(NULL,'946.023','Historia de Cataluña.','946 023','1'),
(NULL,'946.025','Historia de Extremadura.','946 025','1'),
(NULL,'946.027','Historia de la Comunidad Autónoma de Madrid.','946 027','1'),
(NULL,'946.028','Historia de Castilla-La Mancha.','946 028','1'),
(NULL,'946.031','Historia de la Comunidad Autónoma Valenciana.','946 031','1'),
(NULL,'946.032','Historia de las Baleares.','946 032','1'),
(NULL,'946.033','Historia de la Región de Murcia.','946 033','1'),
(NULL,'946.035','Historia de Andalucía.','946 035','1'),
(NULL,'946.041','Historia de Canarias.','946 041','1'),
(NULL,'950','Historia de Asia.','950','1'),
(NULL,'960','Historia de África.','960','1'),
(NULL,'970','Historia de América del Norte y América Central.','970','1'),
(NULL,'972','Historia de México.','972','1'),
(NULL,'972.81','Historia de Guatemala.','972 81','1'),
(NULL,'972.82','Historia de Belice.','972 82','1'),
(NULL,'972.83','Historia de Honduras.','972 83','1'),
(NULL,'972.84','Historia de El Salvador.','972 84','1'),
(NULL,'972.85','Historia de Nicaragua.','972 85','1'),
(NULL,'972.86','Historia de Costa Rica.','972 86','1'),
(NULL,'972.87','Historia de Panamá.','972 87','1'),
(NULL,'972.91','Historia de Cuba.','972 91','1'),
(NULL,'972.92','Historia de Jamaica.','972 92','1'),
(NULL,'972.93','Historia de la República Dominicana.','972 93','1'),
(NULL,'972.94','Historia de Haití.','972 94','1'),
(NULL,'972.95','Historia de las Puerto Rico.','972 95','1'),
(NULL,'972.97/.99','Historia de las Pequeñas Antillas.','972 97  99','1'),
(NULL,'980','Historia de América del Sur.','980','1'),
(NULL,'981','Historia de Brasil.','981','1'),
(NULL,'982','Historia de Argentina.','982','1'),
(NULL,'983','Historia de Chile.','983','1'),
(NULL,'984','Historia de Bolivia.','984','1'),
(NULL,'985','Historia de Perú.','985','1'),
(NULL,'986.1','Historia de Colombia.','986 1','1'),
(NULL,'986.6','Historia de Ecuador.','986 6','1'),
(NULL,'987','Historia de Venezuela.','987','1'),
(NULL,'989.2','Historia de Paraguay.','989 2','1'),
(NULL,'989.9','Historia de Uruguay.','989 9','1'),
(NULL,'990','Historia de Australia, Oceanía y de las regiones polares.','990','1');


INSERT INTO indexint (indexint_id, indexint_name, indexint_comment, index_indexint, num_pclass) 
SELECT DISTINCT A.indexint_id, A.indexint_name, A.indexint_comment, A.index_indexint, A.num_pclass
FROM indexint_bak A
LEFT JOIN indexint B
ON A.indexint_name = B.indexint_name
WHERE B.indexint_name IS NULL;


DROP TABLE IF EXISTS indexint_bak;
