#!/bin/bash


# Get the GPG for a list of GPG keys

KEYSERVER="keyserver.ubuntu.com"
PREFIX="kxstudio_"

show_usage()
{
    echo "USAGE"
    echo "$0 LIST_OF_KEYS_FILE   "
    exit 1
}

if [ $# -ne 1 ]; then
    show_usage 
fi


for line in $(cat "$1"); do 
    gpg --keyserver $KEYSERVER --recv "$line" & sudo gpg --export --armor "$line" > "$PREFIX$line.gpg"
done



exit 0
