/*
 * Decompiled with CFR 0.152.
 */
package hotpot6;

import hotpot6.ConfigSaxHandler;
import hotpot6.GenericSaxModel;
import hotpot6.JClozeUI;
import hotpot6.JMatchUI;
import hotpot6.JQuizUI;
import hotpot6.JxxUI;
import hotpot6.MasherSaxModel;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigSaxModel
extends GenericSaxModel {
    String allPotXmlTags = "jcloze jcross jmatch jmix jquiz";
    boolean b_ReadyToRead = false;
    boolean b_Temp = false;
    ConfigSaxHandler configSaxHandler;
    boolean configUnsaved = false;
    Hashtable ht_ConfigGlobal = new Hashtable();
    Hashtable ht_ConfigJCloze;
    Hashtable ht_ConfigJCross;
    Hashtable ht_ConfigJMatch;
    Hashtable ht_ConfigJMix;
    Hashtable ht_ConfigJQuiz;
    Hashtable ht_ConfigSpecific = new Hashtable();
    JxxUI modelOwner;
    String potXmlTag;
    String str_Default;
    String str_Temp;
    XMLReader xmlReader;

    public ConfigSaxModel() {
        this.ht_ConfigJMatch = new Hashtable();
        this.ht_ConfigJQuiz = new Hashtable();
        this.ht_ConfigJCloze = new Hashtable();
        this.ht_ConfigJCross = new Hashtable();
        this.ht_ConfigJMix = new Hashtable();
    }

    public ConfigSaxModel(File configFile, String potXmlTag, JxxUI modelOwnerIn) {
        this.ht_ConfigJMatch = new Hashtable();
        this.ht_ConfigJQuiz = new Hashtable();
        this.ht_ConfigJCloze = new Hashtable();
        this.ht_ConfigJCross = new Hashtable();
        this.ht_ConfigJMix = new Hashtable();
        this.modelOwner = potXmlTag.equals("jquiz") ? (JQuizUI)modelOwnerIn : (potXmlTag.equals("jmatch") ? (JMatchUI)modelOwnerIn : (potXmlTag.equals("jcloze") ? (JClozeUI)modelOwnerIn : modelOwnerIn));
        StringBuffer sb_Msg = new StringBuffer("ConfigSaxModel.constructor()" + this.crlf);
        this.str_Default = this.hotpotAppPath + "config" + System.getProperty("file.separator") + "English6.cfg";
        this.str_Temp = configFile.getPath();
        if (configFile.exists()) {
            this.b_ReadyToRead = true;
        } else {
            sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-cant-find-config-file") + this.crlf + "'" + this.str_Temp + "'" + this.crlf);
            if (this.str_Temp.equals(this.str_Default)) {
                sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-continue-with-defaults") + this.crlf);
            } else {
                configFile = new File(this.str_Default);
                if (configFile.exists()) {
                    sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-use-this-instead") + this.crlf + "'" + this.str_Default + "'" + this.crlf);
                    this.b_ReadyToRead = true;
                } else {
                    sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-cant-find-config-file") + this.crlf + "'" + this.str_Temp + "'" + this.crlf);
                    sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-continue-with-defaults") + this.crlf);
                }
            }
        }
        if (this.b_ReadyToRead && configFile.canRead()) {
            sb_Msg.setLength(0);
            int statusInitConfig = this.init(configFile, potXmlTag);
            if (statusInitConfig != 0) {
                if (statusInitConfig == 1) {
                    sb_Msg.append("ConfigSaxModel.constructor()" + this.crlf + this.modelOwner.ifSaxModelNew.getMessageString("msg-cant-find-config-file"));
                } else if (statusInitConfig == 2) {
                    sb_Msg.append("ConfigSaxModel.constructor()" + this.crlf + this.modelOwner.ifSaxModelNew.getMessageString("msg-parse-file-failed"));
                }
                sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-continue-with-defaults") + this.crlf);
                this.writeErrorReport(sb_Msg.toString());
            }
        } else {
            this.writeErrorReport(sb_Msg.toString());
        }
    }

    StringBuffer doConfigIncludes(StringBuffer sb_Exercise, MasherSaxModel msm_In) {
        boolean inclBack;
        boolean inclContents;
        boolean inclNextEx;
        this.str_Temp = this.getConfigSaxValue("specific", "exercise-subtitle", "");
        this.b_Temp = this.str_Temp.length() > 0;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclExerciseSubtitle]", this.b_Temp);
        boolean b_useMasherNavButtons = false;
        if (msm_In instanceof MasherSaxModel) {
            b_useMasherNavButtons = msm_In.getMasherSaxBoolean("buttons", "use-masher-settings", "1");
        }
        if (b_useMasherNavButtons) {
            inclNextEx = msm_In.getMasherSaxBoolean("buttons", "include-next-ex", "1");
            inclContents = msm_In.getMasherSaxBoolean("buttons", "include-contents", "1");
            inclBack = msm_In.getMasherSaxBoolean("buttons", "include-back", "1");
        } else {
            inclNextEx = this.getConfigSaxBoolean("global", "include-next-ex", "1");
            inclContents = this.getConfigSaxBoolean("global", "include-contents", "1");
            inclBack = this.getConfigSaxBoolean("global", "include-back", "1");
        }
        this.b_Temp = inclNextEx || inclContents || inclBack;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclNavButtons]", this.b_Temp);
        if (this.b_Temp) {
            sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclNextEx]", inclNextEx);
            sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclContents]", inclContents);
            sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclBack]", inclBack);
        }
        this.b_Temp = this.getConfigSaxBoolean("specific", "show-also-correct", "1");
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclAlsoCorrect]", this.b_Temp);
        if (this.potXmlTag.equals("jmix")) {
            this.b_Temp = this.getConfigSaxBoolean("specific", "include-undo", "1");
            sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclUndo]", this.b_Temp);
            this.b_Temp = this.getConfigSaxBoolean("specific", "include-restart", "1");
            sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclRestart]", this.b_Temp);
            this.b_Temp = this.getConfigSaxBoolean("specific", "include-hint", "1");
            sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclHint]", this.b_Temp);
        }
        this.b_Temp = this.getConfigSaxBoolean("global", "graphic-url", "0");
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclGraphicURL]", this.b_Temp);
        this.b_Temp = true;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclPageBGColor]", this.b_Temp);
        this.b_Temp = true;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclExBGColor]", this.b_Temp);
        this.b_Temp = true;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclNavBarColor]", this.b_Temp);
        this.b_Temp = this.getConfigSaxBoolean(this.potXmlTag, "include-show-answer", "0");
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclShowAnswer]", this.b_Temp);
        this.b_Temp = this.getConfigSaxBoolean(this.potXmlTag, "include-hint", "0");
        if (this.potXmlTag.equals("jcloze") && this.getConfigSaxBoolean(this.potXmlTag, "use-drop-down-list", "0")) {
            this.b_Temp = false;
        }
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclHint]", this.b_Temp);
        this.b_Temp = this.getConfigSaxBoolean(this.potXmlTag, "include-keypad", "0");
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclKeypad]", this.b_Temp);
        if (this.potXmlTag.equals("jcloze")) {
            this.b_Temp = this.getConfigSaxBoolean(this.potXmlTag, "include-word-list", "0");
            sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclWordList]", this.b_Temp);
        }
        this.b_Temp = this.getConfigSaxBoolean(this.potXmlTag, "send-email", "0");
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclSendResults]", this.b_Temp);
        return sb_Exercise;
    }

    StringBuffer doConfigIncludes(StringBuffer sb_Exercise) {
        return this.doConfigIncludes(sb_Exercise, null);
    }

    StringBuffer doConfigReplacements(StringBuffer sb_Exercise, int maxQsToShow, MasherSaxModel msm_In) {
        boolean isJCloze = false;
        boolean isJCross = false;
        boolean isJMatch = false;
        boolean isJMix = false;
        boolean isJQuiz = false;
        if (this.potXmlTag.equals("jcloze")) {
            isJCloze = true;
        }
        if (this.potXmlTag.equals("jcross")) {
            isJCross = true;
        }
        if (this.potXmlTag.equals("jmatch")) {
            isJMatch = true;
        }
        if (this.potXmlTag.equals("jmix")) {
            isJMix = true;
        }
        if (this.potXmlTag.equals("jquiz")) {
            isJQuiz = true;
        }
        String temp_String = this.makeHtmlSafe(this.getConfigSaxValue("specific", "exercise-subtitle", ""));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strExerciseSubtitle]", temp_String));
        temp_String = this.makeHtmlSafe(this.getConfigSaxValue("specific", "instructions", ""));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strInstructions]", temp_String));
        if (isJMatch || isJQuiz || isJCloze || isJMix || isJCross) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "your-score-is", "Your score is: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strYourScoreIs]", temp_String));
        }
        if (isJMatch || isJQuiz || isJMix || isJCross) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue(this.potXmlTag, "guess-correct", "Correct"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strGuessCorrect]", temp_String));
        }
        if (isJMatch || isJQuiz || isJMix || isJCross) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue(this.potXmlTag, "guess-incorrect", "Incorrect"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strGuessIncorrect]", temp_String));
        }
        if (isJMatch || isJQuiz) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "correct-indicator", ":-)"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCorrectIndicator]", temp_String));
        }
        if (isJMatch || isJQuiz) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "incorrect-indicator", " X "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strIncorrectIndicator]", temp_String));
        }
        if (isJQuiz || isJCloze) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue(this.potXmlTag, "next-correct-letter", "The next correct bit is: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNextCorrect]", temp_String));
        }
        if (isJMix || isJCross) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "also-correct", "Also correct: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strTheseAnswersToo]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "this-much-correct", "This much of your answer is correct: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strThisMuch]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "next-correct-part", "Next correct part is: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNextCorrect]", temp_String));
            temp_String = this.getConfigSaxStringBoolean("specific", "capitalize-first-letter", "0");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[boolCapitalizeFirst]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "click-to-add", "Click on a word to add it to the sentence."));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strClickToAdd]", temp_String));
        }
        if (isJCloze) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "guesses-correct", "Correct!"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCorrect]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "guesses-incorrect", "Some of your guesses are incorrect. They have been left in place."));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strIncorrect]", temp_String));
        }
        if (isJCross) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "guess-correct", "Correct!"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCorrect]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "guess-incorrect", "Some of your guesses are incorrect. They have been removed."));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strIncorrect]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "clues-across", "Across"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCluesAcrossLabel]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "clues-down", "Across"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCluesDownLabel]", temp_String));
        }
        if (isJQuiz) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "guess-correct", "Correct!"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strDefaultRight]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "guess-incorrect", "Not perfect yet. Please try again."));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strDefaultWrong]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "enter-a-guess", "Please enter a guess, then check."));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strPleaseEnter]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "partly-incorrect", "Your answer is partly incorrect. "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strPartlyIncorrect]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "correct-list", "Correct Answers: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCorrectList]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "completed-so-far", "Questions completed so far: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCompletedSoFar]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "exercise-completed", "You have completed the exercise. "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strExerciseCompleted]", temp_String));
        }
        if (isJMatch || isJQuiz || isJCloze || isJMix || isJCross) {
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "check-caption", "Check"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCheckCaption]", temp_String));
        }
        if (isJMatch || isJQuiz || isJCloze || isJMix || isJCross) {
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "ok-caption", "OK"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strOKCaption]", temp_String));
        }
        if (isJQuiz || isJCloze || isJMix || isJCross) {
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "hint-caption", "Hint"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strHintCaption]", temp_String));
        }
        if (isJCloze || isJCross) {
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("specific", "next-correct-letter", "The next correct letter has been added to your answer."));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strGiveHint]", temp_String));
        }
        if (isJQuiz) {
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("specific", "show-answer-caption", "Show Answer"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strShowAnswerCaption]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "show-all-questions-caption", "Show All Questions"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strShowAllQuestionsCaption]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "show-all-questions-caption", "Show All Questions"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strShowAllQuestionsCaptionJS]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "show-one-by-one-caption", "Show Questions One By One"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strShowOneByOneCaption]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "show-one-by-one-caption", "Show Questions One By One"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strShowOneByOneCaptionJS]", temp_String));
            temp_String = this.makeXHtmlSafe(this.getConfigSaxValue("global", "last-q-caption", "Prev"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strLastQCaption]", temp_String));
            temp_String = this.makeXHtmlSafe(this.getConfigSaxValue("global", "next-q-caption", "Next"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNextQCaption]", temp_String));
        }
        if (isJMix) {
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "undo-caption", "Undo"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strUndoCaption]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "restart-caption", "Restart"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strRestartCaption]", temp_String));
        }
        if (isJCross) {
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("specific", "enter-caption", "Enter"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strEnterCaption]", temp_String));
        }
        if (msm_In instanceof MasherSaxModel) {
            temp_String = this.makeXHtmlSafe(msm_In.getMasherSaxValue("nav-buttons", "back-caption", "Back"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strBackCaption]", temp_String));
            temp_String = this.makeXHtmlSafe(msm_In.getMasherSaxValue("nav-buttons", "contents-caption", "Index"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strContentsCaption]", temp_String));
            temp_String = this.makeXHtmlSafe(msm_In.getMasherSaxValue("nav-buttons", "next-ex-caption", "Next"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNextExCaption]", temp_String));
            temp_String = msm_In.getContentsFilename();
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strContentsURL]", temp_String));
            temp_String = msm_In.getNextExFilename();
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNextExURL]", temp_String));
        } else {
            temp_String = this.makeXHtmlSafe(this.getConfigSaxValue("global", "back-caption", "Back"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strBackCaption]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "contents-caption", "Index"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strContentsCaption]", temp_String));
            temp_String = this.makeXHtmlSafe(this.getConfigSaxValue("global", "next-ex-caption", "Next"));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNextExCaption]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "contents-url", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strContentsURL]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("specific", "next-ex-url", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNextExURL]", temp_String));
        }
        boolean b_useMasherAppearance = false;
        if (msm_In instanceof MasherSaxModel) {
            b_useMasherAppearance = msm_In.getMasherSaxBoolean("appearance", "use-masher-settings", "1");
        }
        sb_Exercise = b_useMasherAppearance ? this.doConfigReplacementsAppearance(sb_Exercise, msm_In) : this.doConfigReplacementsAppearance(sb_Exercise);
        temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "times-up", ""));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strTimesUp]", temp_String));
        if (isJMatch || isJQuiz) {
            temp_String = this.getConfigSaxBoolean(this.potXmlTag, "show-limited-questions", "1") ? this.getConfigSaxValue(this.potXmlTag, "questions-to-show", "1") : Integer.toString(maxQsToShow);
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[QsToShow]", temp_String));
            temp_String = this.getConfigSaxStringBoolean(this.potXmlTag, "shuffle-questions", "1");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[boolShuffleQs]", temp_String));
            this.b_Temp = this.getConfigSaxBoolean("specific", "show-limited-questions", "0");
            if (this.b_Temp) {
                temp_String = this.makeHtmlSafe(this.getConfigSaxValue("specific", "questions-to-show", "1001"));
                if (temp_String.equals("0")) {
                    temp_String = "111";
                }
            } else {
                temp_String = "1001";
            }
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[QsToShow]", temp_String));
        }
        if (isJQuiz || isJCloze || isJCross) {
            temp_String = this.getConfigSaxStringBoolean("specific", "case-sensitive", "0");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[boolCaseSensitive]", temp_String));
        }
        temp_String = this.getConfigSaxValue("global", "keypad-characters", "");
        StringBuffer sb_KeypadCharsFromData = new StringBuffer();
        String str_Temp2 = "";
        int i = 0;
        while (i < this.modelOwner.strA_KeypadCharsFromData.length) {
            String str_Junk = this.modelOwner.strA_KeypadCharsFromData[i];
            if (temp_String.indexOf(str_Junk) < 0) {
                str_Temp2 = str_Temp2 + this.modelOwner.strA_KeypadCharsFromData[i];
            }
            ++i;
        }
        temp_String = temp_String + str_Temp2;
        temp_String = this.makeKeypadButtons(temp_String);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strKeypad]", temp_String));
        if (isJCross) {
            this.b_Temp = this.getConfigSaxBoolean("specific", "include-clue-list", "0");
            temp_String = this.b_Temp ? " style=\"display: table;\"" : " style=\"display: none;\"";
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[ShowHideClueList]", temp_String));
        }
        if (isJQuiz) {
            temp_String = this.getConfigSaxStringBoolean("specific", "continuous-scoring", "1");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[boolContinuousScoring]", temp_String));
            temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "correct-first-time", "Number correct on first guess: "));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strCorrectFirstTime]", temp_String));
            temp_String = this.getConfigSaxStringBoolean("specific", "show-correct-first-time", "1");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[boolShowCorrectFirstTime]", temp_String));
            temp_String = this.getConfigSaxStringBoolean("specific", "shuffle-answers", "0");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[boolShuffleAs]", temp_String));
            temp_String = this.getConfigSaxStringBoolean("global", "show-also-correct", "0");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[boolShowAlsoCorrect]", temp_String));
            temp_String = this.getConfigSaxValue("specific", "short-answer-tries-on-hybrid-q", "2");
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[intHybridTries]", temp_String));
        }
        temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "formmail-url", ""));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFormMailURL]", temp_String));
        temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "email", ""));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strEMail]", temp_String));
        temp_String = this.makeJavaScriptSafe(this.getConfigSaxValue("global", "name-please", ""));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNamePlease]", temp_String));
        boolean b_useMasherUserStrings = false;
        if (msm_In instanceof MasherSaxModel) {
            b_useMasherUserStrings = msm_In.getMasherSaxBoolean("user-strings", "use-masher-settings", "1");
        }
        if (b_useMasherUserStrings) {
            temp_String = this.makeHtmlSafe(msm_In.getMasherSaxValue("user-strings", "header-code", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strHeaderCode]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("user-strings", "user-string-3", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[userstring3]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("user-strings", "user-string-2", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[userstring2]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("user-strings", "user-string-1", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[userstring1]", temp_String));
        } else {
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("specific", "header-code", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strHeaderCode]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "user-string-3", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[userstring3]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "user-string-2", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[userstring2]", temp_String));
            temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "user-string-1", ""));
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[userstring1]", temp_String));
        }
        return sb_Exercise;
    }

    StringBuffer doConfigReplacements(StringBuffer sb_Exercise, int maxQsToShow) {
        return this.doConfigReplacements(sb_Exercise, maxQsToShow, null);
    }

    StringBuffer doConfigReplacementsAppearance(StringBuffer sb_Exercise, MasherSaxModel msm_In) {
        String temp_String = msm_In.getMasherSaxValue("appearance", "font-face", "Lucida Grande,Arial Unicode MS,Code2000,Palatino,Arial");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFontFace]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "font-size", "small");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFontSize]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "graphic-url", "");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strGraphicURL]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "page-bg-color", "#ffffff");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strPageBGColor]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "title-color", "#000033");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strTitleColor]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "ex-bg-color", "#bbbbee");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strExBGColor]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "text-color", "#000000");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strTextColor]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "link-color", "#0000ff");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strLinkColor]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "vlink-color", "#0000cc");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strVLinkColor]", temp_String));
        temp_String = msm_In.getMasherSaxValue("appearance", "nav-bar-color", "#000066");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavBarColor]", temp_String));
        String str_TempColour = msm_In.getMasherSaxValue("appearance", "ex-bg-color", "#bbbbee");
        temp_String = this.getHighlightColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFuncLightColor]", temp_String));
        str_TempColour = msm_In.getMasherSaxValue("appearance", "ex-bg-color", "#bbbbee");
        temp_String = this.getShadeColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFuncShadeColor]", temp_String));
        str_TempColour = msm_In.getMasherSaxValue("appearance", "nav-bar-color", "#000066");
        temp_String = this.getHighlightColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavLightColor]", temp_String));
        str_TempColour = msm_In.getMasherSaxValue("appearance", "nav-bar-color", "#000066");
        temp_String = this.getShadeColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavShadeColor]", temp_String));
        str_TempColour = msm_In.getMasherSaxValue("appearance", "nav-bar-color", "#000066");
        temp_String = this.getBestContrast(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavTextColor]", temp_String));
        return sb_Exercise;
    }

    StringBuffer doConfigReplacementsAppearance(StringBuffer sb_Exercise) {
        String temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "font-face", "Lucida Grande,Arial Unicode MS,Code2000,Palatino,Arial"));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFontFace]", temp_String));
        temp_String = this.makeHtmlSafe(this.getConfigSaxValue("global", "font-size", "small"));
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFontSize]", temp_String));
        temp_String = this.getConfigSaxValue("global", "graphic-url", "");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strGraphicURL]", temp_String));
        temp_String = this.getConfigSaxValue("global", "page-bg-color", "#ffffff");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strPageBGColor]", temp_String));
        temp_String = this.getConfigSaxValue("global", "title-color", "#000033");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strTitleColor]", temp_String));
        temp_String = this.getConfigSaxValue("global", "ex-bg-color", "#bbbbee");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strExBGColor]", temp_String));
        temp_String = this.getConfigSaxValue("global", "text-color", "#000000");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strTextColor]", temp_String));
        temp_String = this.getConfigSaxValue("global", "link-color", "#0000ff");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strLinkColor]", temp_String));
        temp_String = this.getConfigSaxValue("global", "vlink-color", "#0000cc");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strVLinkColor]", temp_String));
        temp_String = this.getConfigSaxValue("global", "nav-bar-color", "#000066");
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavBarColor]", temp_String));
        String str_TempColour = this.getConfigSaxValue("global", "ex-bg-color", "#bbbbee");
        temp_String = this.getHighlightColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFuncLightColor]", temp_String));
        str_TempColour = this.getConfigSaxValue("global", "ex-bg-color", "#bbbbee");
        temp_String = this.getShadeColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strFuncShadeColor]", temp_String));
        str_TempColour = this.getConfigSaxValue("global", "nav-bar-color", "#000066");
        temp_String = this.getHighlightColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavLightColor]", temp_String));
        str_TempColour = this.getConfigSaxValue("global", "nav-bar-color", "#000066");
        temp_String = this.getShadeColour(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavShadeColor]", temp_String));
        str_TempColour = this.getConfigSaxValue("global", "nav-bar-color", "#000066");
        temp_String = this.getBestContrast(str_TempColour);
        sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strNavTextColor]", temp_String));
        return sb_Exercise;
    }

    public boolean getConfigSaxBoolean(String keyPath, String keyName, String defaultValue) {
        return this.strToBool(this.getConfigSaxValue(keyPath, keyName, defaultValue));
    }

    public String getConfigSaxStringBoolean(String keyPath, String keyName, String defaultValue) {
        boolean b_temp = this.strToBool(this.getConfigSaxValue(keyPath, keyName, defaultValue));
        if (b_temp) {
            return "true";
        }
        return "false";
    }

    public String getConfigSaxValue(String keyPath, String keyName, String defaultValue) {
        String str_Out = "";
        if (keyPath.indexOf("global") >= 0) {
            if (this.ht_ConfigGlobal.containsKey(keyName)) {
                str_Out = (String)this.ht_ConfigGlobal.get(keyName);
            } else {
                this.ht_ConfigGlobal.put(keyName, defaultValue);
            }
        } else if (this.ht_ConfigSpecific.containsKey(keyName)) {
            str_Out = (String)this.ht_ConfigSpecific.get(keyName);
        } else {
            this.ht_ConfigSpecific.put(keyName, defaultValue);
        }
        if (str_Out.equals("")) {
            str_Out = defaultValue;
        }
        return str_Out;
    }

    public boolean getConfigUnsaved() {
        return this.configUnsaved;
    }

    public Hashtable getHTConfigGlobal() {
        return this.configSaxHandler.ht_ConfigGlobal;
    }

    public Hashtable getHTConfigSpecific() {
        return this.configSaxHandler.ht_ConfigSpecific;
    }

    public int init(File configFile, String potXmlTagIn) {
        String str_tempKey = "";
        String str_tempValue = "";
        String str_FileText = "";
        String str_Temp = "";
        String str_FileOneParse = "";
        StringReader sr_ParsedOnce = null;
        try {
            str_FileText = GenericSaxModel.readFile(configFile);
            str_FileOneParse = str_FileText.indexOf("<version>5</version>") > 0 ? str_FileOneParse + this.replaceStuff(str_FileText, "&amp;", "&#x0026;") : str_FileOneParse + this.replaceStuff(str_FileText, "&amp;", "&");
        }
        catch (IOException ioe) {
            return 1;
        }
        try {
            sr_ParsedOnce = new StringReader(str_FileOneParse);
            InputSource inputSource = new InputSource(sr_ParsedOnce);
            inputSource.setEncoding(this.charEncoding);
            this.potXmlTag = potXmlTagIn;
            this.xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.configSaxHandler = new ConfigSaxHandler(this.potXmlTag);
            this.xmlReader.setContentHandler(this.configSaxHandler);
            this.xmlReader.parse(inputSource);
            this.ht_ConfigGlobal.putAll(this.configSaxHandler.ht_ConfigGlobal);
            this.ht_ConfigJMatch.putAll(this.configSaxHandler.ht_ConfigJMatch);
            this.ht_ConfigJQuiz.putAll(this.configSaxHandler.ht_ConfigJQuiz);
            this.ht_ConfigJCloze.putAll(this.configSaxHandler.ht_ConfigJCloze);
            this.ht_ConfigJCross.putAll(this.configSaxHandler.ht_ConfigJCross);
            this.ht_ConfigJMix.putAll(this.configSaxHandler.ht_ConfigJMix);
            this.configSaxHandler.ht_ConfigGlobal.clear();
            this.configSaxHandler.ht_ConfigJMatch.clear();
            this.configSaxHandler.ht_ConfigJQuiz.clear();
            this.configSaxHandler.ht_ConfigJCloze.clear();
            this.configSaxHandler.ht_ConfigJCross.clear();
            this.configSaxHandler.ht_ConfigJMix.clear();
            Enumeration e = this.ht_ConfigGlobal.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.ht_ConfigGlobal.get(str_tempKey));
                this.ht_ConfigGlobal.put(str_tempKey, str_tempValue);
            }
            if (this.potXmlTag == "jquiz") {
                Enumeration e2 = this.ht_ConfigJQuiz.keys();
                while (e2.hasMoreElements()) {
                    str_tempKey = (String)e2.nextElement();
                    str_tempValue = this.undoXmlSafe((String)this.ht_ConfigJQuiz.get(str_tempKey));
                    this.ht_ConfigJQuiz.put(str_tempKey, str_tempValue);
                }
                this.ht_ConfigSpecific = this.ht_ConfigJQuiz;
            } else if (this.potXmlTag == "jcloze") {
                Enumeration e3 = this.ht_ConfigJCloze.keys();
                while (e3.hasMoreElements()) {
                    str_tempKey = (String)e3.nextElement();
                    str_tempValue = this.undoXmlSafe((String)this.ht_ConfigJCloze.get(str_tempKey));
                    this.ht_ConfigJCloze.put(str_tempKey, str_tempValue);
                }
                this.ht_ConfigSpecific = this.ht_ConfigJCloze;
            } else if (this.potXmlTag == "jcross") {
                Enumeration e4 = this.ht_ConfigJCross.keys();
                while (e4.hasMoreElements()) {
                    str_tempKey = (String)e4.nextElement();
                    str_tempValue = this.undoXmlSafe((String)this.ht_ConfigJCross.get(str_tempKey));
                    this.ht_ConfigJCross.put(str_tempKey, str_tempValue);
                }
                this.ht_ConfigSpecific = this.ht_ConfigJCross;
            } else if (this.potXmlTag == "jmatch") {
                Enumeration e5 = this.ht_ConfigJMatch.keys();
                while (e5.hasMoreElements()) {
                    str_tempKey = (String)e5.nextElement();
                    str_tempValue = this.undoXmlSafe((String)this.ht_ConfigJMatch.get(str_tempKey));
                    this.ht_ConfigJMatch.put(str_tempKey, str_tempValue);
                }
                this.ht_ConfigSpecific = this.ht_ConfigJMatch;
            } else if (this.potXmlTag == "jmix") {
                Enumeration e6 = this.ht_ConfigJMix.keys();
                while (e6.hasMoreElements()) {
                    str_tempKey = (String)e6.nextElement();
                    str_tempValue = this.undoXmlSafe((String)this.ht_ConfigJMix.get(str_tempKey));
                    this.ht_ConfigJMix.put(str_tempKey, str_tempValue);
                }
                this.ht_ConfigSpecific = this.ht_ConfigJMix;
            }
            return 0;
        }
        catch (IOException ioe) {
            this.writeErrorReport("ConfigSaxModel.init()" + this.crlf + ioe.toString() + this.crlf + ioe.getMessage());
            return 1;
        }
        catch (SAXException saxe) {
            this.writeErrorReport("ConfigSaxModel.init()" + this.crlf + saxe.toString() + this.crlf + saxe.getMessage());
            return 2;
        }
    }

    String makeKeypadButtons(String str_CharsIn) {
        StringBuffer sb_Out = new StringBuffer();
        int i = 0;
        while (i < str_CharsIn.length()) {
            this.str_Temp = str_CharsIn.substring(i, i + 1);
            sb_Out.append("<button onclick=\"TypeChars('");
            sb_Out.append(this.makeJavaScriptSafe(this.str_Temp));
            sb_Out.append("'); return false;\">");
            sb_Out.append(this.makeHtmlSafe(this.str_Temp));
            sb_Out.append("</button>");
            ++i;
        }
        return sb_Out.toString();
    }

    public boolean putConfigSaxBoolean(String keyPath, String keyName, boolean valueBoolean) {
        this.putConfigSaxValue(keyPath, keyName, this.boolToStr(valueBoolean));
        return true;
    }

    public boolean putConfigSaxValue(String keyPath, String keyName, String valueText) {
        boolean b_Out = true;
        if (keyPath.indexOf("global") >= 0) {
            this.ht_ConfigGlobal.put(keyName, valueText);
        } else {
            this.ht_ConfigSpecific.put(keyName, valueText);
        }
        return b_Out;
    }

    public void setConfigUnsaved(boolean b_In) {
        this.configUnsaved = b_In;
    }

    public String toXml(boolean b_DoAll) {
        Enumeration e;
        String str_tempValue;
        String str_tempKey;
        StringBuffer sb_Out = new StringBuffer();
        String crlf = System.getProperty("line.separator");
        sb_Out.append("<hotpot-config-file>" + crlf);
        sb_Out.append("<global>" + crlf);
        Enumeration e2 = this.ht_ConfigGlobal.keys();
        while (e2.hasMoreElements()) {
            str_tempKey = (String)e2.nextElement();
            str_tempValue = (String)this.ht_ConfigGlobal.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + crlf);
        }
        sb_Out.append("</global>" + crlf);
        if (this.potXmlTag == "jcloze" || b_DoAll) {
            sb_Out.append("<jcloze>" + crlf);
            e = this.ht_ConfigJCloze.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = (String)this.ht_ConfigJCloze.get(str_tempKey);
                sb_Out.append("<" + str_tempKey + ">");
                sb_Out.append(this.makeXmlSafe(str_tempValue));
                sb_Out.append("</" + str_tempKey + ">" + crlf);
            }
            sb_Out.append("</jcloze>" + crlf);
        }
        if (this.potXmlTag == "jcross" || b_DoAll) {
            sb_Out.append("<jcross>" + crlf);
            e = this.ht_ConfigJCross.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = (String)this.ht_ConfigJCross.get(str_tempKey);
                sb_Out.append("<" + str_tempKey + ">");
                sb_Out.append(this.makeXmlSafe(str_tempValue));
                sb_Out.append("</" + str_tempKey + ">" + crlf);
            }
            sb_Out.append("</jcross>" + crlf);
        }
        if (this.potXmlTag == "jmatch" || b_DoAll) {
            sb_Out.append("<jmatch>" + crlf);
            e = this.ht_ConfigJMatch.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = (String)this.ht_ConfigJMatch.get(str_tempKey);
                sb_Out.append("<" + str_tempKey + ">");
                sb_Out.append(this.makeXmlSafe(str_tempValue));
                sb_Out.append("</" + str_tempKey + ">" + crlf);
            }
            sb_Out.append("</jmatch>" + crlf);
        }
        if (this.potXmlTag == "jmix" || b_DoAll) {
            sb_Out.append("<jmix>" + crlf);
            e = this.ht_ConfigJMix.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = (String)this.ht_ConfigJMix.get(str_tempKey);
                sb_Out.append("<" + str_tempKey + ">");
                sb_Out.append(this.makeXmlSafe(str_tempValue));
                sb_Out.append("</" + str_tempKey + ">" + crlf);
            }
            sb_Out.append("</jmix>" + crlf);
        }
        if (this.potXmlTag == "jquiz" || b_DoAll) {
            sb_Out.append("<jquiz>" + crlf);
            e = this.ht_ConfigJQuiz.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = (String)this.ht_ConfigJQuiz.get(str_tempKey);
                sb_Out.append("<" + str_tempKey + ">");
                sb_Out.append(this.makeXmlSafe(str_tempValue));
                sb_Out.append("</" + str_tempKey + ">" + crlf);
            }
            sb_Out.append("</jquiz>" + crlf);
        }
        sb_Out.append("</hotpot-config-file>" + crlf);
        String str_Out = sb_Out.toString();
        return str_Out;
    }

    public String toXml() {
        return this.toXml(true);
    }
}

