/*
 * Decompiled with CFR 0.152.
 */
package hotpot6;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class HBSFileFilter
extends FileFilter {
    private static String HIDDEN_FILE;
    private static String TYPE_UNKNOWN;
    private String description = null;
    private Hashtable filters = new Hashtable();
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    static {
        TYPE_UNKNOWN = "Type Unknown";
        HIDDEN_FILE = "Hidden File";
    }

    public HBSFileFilter(String[] filters, String description) {
        this();
        int i = 0;
        while (i < filters.length) {
            this.addExtension(filters[i]);
            ++i;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public HBSFileFilter(String[] filters) {
        this(filters, null);
    }

    public HBSFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public HBSFileFilter(String extension) {
        this(extension, null);
    }

    public HBSFileFilter() {
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", " + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }
}

