/*
 * Decompiled with CFR 0.152.
 */
package hotpot6;

import hotpot6.GenericSaxModel;
import hotpot6.HP6Button;
import hotpot6.HP6Dialog;
import hotpot6.HP6Label;
import hotpot6.HP6TextField;
import hotpot6.HotPotIfSaxModel;
import hotpot6.HotPotIfSaxModelNew;
import hotpot6.RegSaxHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class HbsRegSaxModel
extends GenericSaxModel {
    static final int HOTPOT6_PRODUCT_INDEX = 0;
    static final int MASHER6_PRODUCT_INDEX = 1;
    BorderLayout borderLayout1;
    Border brdr_10_10_0_5;
    HP6Button btn_RegisterUserCloseWindow;
    HP6Button btn_RegisterUserRegister;
    HP6Dialog dlg_Register;
    GridBagConstraints gbc;
    public File hbsRegFile;
    String hbsRegPathShared;
    String hbsRegPathUser;
    Hashtable ht_RegValues = new Hashtable();
    HotPotIfSaxModel ifSaxModel;
    HotPotIfSaxModelNew ifSaxModelNew;
    int int_productIndex = 0;
    boolean isHP6Registered = false;
    boolean isMasher6Registered = false;
    HP6Label lbl_RegKeyToRegister;
    HP6Label lbl_UserNameToRegister;
    BorderLayout lom_AllRegisterUserComponents;
    GridBagLayout lom_RegKeyToRegister;
    BoxLayout lom_RegisterUserIO;
    BorderLayout lom_RegisterUserTab;
    BoxLayout lom_RegistersUserControls;
    GridBagLayout lom_UserNameToRegister;
    JPanel pnl_AllRegisterUserComponents;
    JPanel pnl_RegKeyToRegister;
    JPanel pnl_RegisterUserControls;
    JPanel pnl_RegisterUserIO;
    JPanel pnl_RegisterUserTab;
    JPanel pnl_UserNameToRegister;
    RegSaxHandler regSaxHandler;
    boolean showUIFeedback = true;
    String str_HP6RegKey = "";
    String str_HP6UserName = "";
    String str_Masher6RegKey = "";
    String str_MasherUserName = "";
    String str_Temp = "";
    HP6TextField tf_RegKeyToRegister;
    HP6TextField tf_UserNameToRegister;
    XMLReader xmlReader;

    public HbsRegSaxModel(HotPotIfSaxModelNew ifSaxModelNewIn) {
        this.hbsRegPathUser = System.getProperty("user.home") + this.fs + "Library" + this.fs + "Preferences" + this.fs + "com.halfbakedsoftware" + this.fs;
        this.hbsRegPathShared = "/" + this.fs + "Library" + this.fs + "Application Support" + this.fs + "com.halfbakedsoftware" + this.fs;
        this.ifSaxModelNew = ifSaxModelNewIn;
        this.isHP6Registered = false;
        this.isMasher6Registered = false;
        this.ensureRegFileExists();
        if (this.getRegNameAndKey()) {
            this.isHP6Registered = this.isValidHP6NameNoKey(this.str_HP6UserName);
            this.isMasher6Registered = this.isValidMasher6NameNoKey(this.str_MasherUserName);
        }
    }

    void RegisterUserUIInit() {
        this.dlg_Register.setName("wd-register-user");
        this.str_Temp = this.int_productIndex == 1 ? "Masher 6" : "Hot Potatoes 6";
        this.dlg_Register.setTitle(this.str_Temp);
        this.dlg_Register.getContentPane().setLayout(this.borderLayout1);
        this.pnl_AllRegisterUserComponents.setLayout(this.lom_AllRegisterUserComponents);
        this.dlg_Register.getContentPane().add((Component)this.pnl_RegisterUserTab, "Center");
        this.pnl_RegisterUserTab.setName("pnl-register-user-tab");
        this.pnl_RegisterUserTab.setLayout(this.lom_RegisterUserTab);
        this.pnl_RegisterUserControls.setName("pnl-register-user-controls");
        this.pnl_RegisterUserControls.setLayout(this.lom_RegistersUserControls);
        this.pnl_RegisterUserControls.setBorder(this.brdr_10_10_0_5);
        this.pnl_RegisterUserTab.add(this.pnl_RegisterUserControls);
        this.pnl_RegisterUserIO.add(this.btn_RegisterUserRegister);
        this.pnl_RegisterUserIO.add(this.btn_RegisterUserCloseWindow);
        this.pnl_RegisterUserTab.add((Component)this.pnl_RegisterUserControls, "North");
        this.pnl_RegisterUserTab.add((Component)this.pnl_RegisterUserIO, "South");
        this.pnl_UserNameToRegister.setBorder(this.brdr_10_10_0_5);
        this.pnl_UserNameToRegister.setLayout(this.lom_UserNameToRegister);
        this.pnl_UserNameToRegister.setName("pnl-user-name-to-register");
        this.lbl_UserNameToRegister.setName("lbl-user-name-to-register");
        this.lbl_UserNameToRegister.setText(this.ifSaxModelNew.getComponentString(this.dlg_Register.getName(), this.lbl_UserNameToRegister.getName(), 0, "Name to Register"));
        this.tf_UserNameToRegister.setName("tf-user-name-to-register");
        this.str_Temp = (String)this.ht_RegValues.get("hotpot-v6-user-name");
        if (this.int_productIndex == 1) {
            this.tf_UserNameToRegister.setText(this.getMasher6UserName());
        } else {
            this.tf_UserNameToRegister.setText(this.getHP6UserName());
        }
        this.pnl_RegKeyToRegister.setBorder(this.brdr_10_10_0_5);
        this.pnl_RegKeyToRegister.setLayout(this.lom_RegKeyToRegister);
        this.pnl_RegKeyToRegister.setName("pnl-reg-key-to-register");
        this.lbl_RegKeyToRegister.setName("lbl-reg-key-to-register");
        this.lbl_RegKeyToRegister.setText(this.ifSaxModelNew.getComponentString(this.dlg_Register.getName(), this.lbl_RegKeyToRegister.getName(), 0, "Registration key (XXXX-XXXX-XXXX)"));
        this.tf_RegKeyToRegister.setName("tf-reg-key-to-register");
        if (this.int_productIndex == 1) {
            this.tf_RegKeyToRegister.setText(this.getMasher6RegKey());
        } else {
            this.tf_RegKeyToRegister.setText(this.getHP6RegKey());
        }
        this.gbc.gridwidth = 2;
        this.gbc.gridheight = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.pnl_UserNameToRegister.add((Component)this.lbl_UserNameToRegister, this.gbc);
        this.pnl_RegKeyToRegister.add((Component)this.lbl_RegKeyToRegister, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        ++this.gbc.gridx;
        this.pnl_UserNameToRegister.add((Component)this.tf_UserNameToRegister, this.gbc);
        this.pnl_RegKeyToRegister.add((Component)this.tf_RegKeyToRegister, this.gbc);
        this.pnl_RegisterUserControls.add(this.pnl_UserNameToRegister);
        this.btn_RegisterUserRegister.setName("btn-register-user");
        this.btn_RegisterUserRegister.setText(this.ifSaxModelNew.getComponentString(this.dlg_Register.getName(), this.btn_RegisterUserRegister.getName(), 0, "Register"));
        this.btn_RegisterUserRegister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HbsRegSaxModel.this.reportRegResults(HbsRegSaxModel.this.int_productIndex);
            }
        });
        this.btn_RegisterUserCloseWindow.setName("btn-register-user-close-window");
        this.btn_RegisterUserCloseWindow.setText(this.ifSaxModelNew.getMessageString("msg-close"));
        this.btn_RegisterUserCloseWindow.setHasValue(false);
        this.btn_RegisterUserCloseWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HbsRegSaxModel.this.hideWindow();
            }
        });
    }

    String createMasherCriticalKeyFromKey(String str_RegKey) {
        if (str_RegKey.length() < 13) {
            return "";
        }
        return str_RegKey.substring(1, 12);
    }

    boolean createRegFile(boolean b_InUserPrefs) {
        StringBuffer sb_Temp = new StringBuffer();
        sb_Temp.append(this.xmlHeader + this.crlf);
        sb_Temp.append("<hbs-registry>" + this.crlf);
        sb_Temp.append("<hotpot-v6-user-name>");
        sb_Temp.append("");
        sb_Temp.append("</hotpot-v6-user-name>" + this.crlf);
        sb_Temp.append("<hotpot-v6-reg-key>");
        sb_Temp.append("");
        sb_Temp.append("</hotpot-v6-reg-key>" + this.crlf);
        sb_Temp.append("<masher-v6-user-name></masher-v6-user-name>" + this.crlf);
        sb_Temp.append("<masher-v6-reg-key></masher-v6-reg-key>" + this.crlf);
        sb_Temp.append("<hotpotnet6-user-name></hotpotnet6-user-name>" + this.crlf);
        sb_Temp.append("<hotpotnet6-password></hotpotnet6-password>" + this.crlf);
        sb_Temp.append("<hotpotnet6-save-password></hotpotnet6-save-password>" + this.crlf);
        sb_Temp.append("<hotpotnet6-use-proxy-server></hotpotnet6-use-proxy-server>" + this.crlf);
        sb_Temp.append("<hotpotnet6-use-ie-proxy-settings></hotpotnet6-use-ie-proxy-settings>" + this.crlf);
        sb_Temp.append("<hotpotnet6-proxy-user-name></hotpotnet6-proxy-user-name>" + this.crlf);
        sb_Temp.append("<hotpotnet6-proxy-password></hotpotnet6-proxy-password>" + this.crlf);
        sb_Temp.append("<hotpotnet6-proxy-server></hotpotnet6-proxy-server>" + this.crlf);
        sb_Temp.append("<hotpotnet6-proxy-port></hotpotnet6-proxy-port>" + this.crlf);
        sb_Temp.append("<hotpotnet6-use-basic-proxy></hotpotnet6-use-basic-proxy>" + this.crlf);
        sb_Temp.append("</hbs-registry>" + this.crlf);
        this.hbsRegFile = b_InUserPrefs ? new File(this.hbsRegPathUser + "HBSRegistry.xml") : new File(this.hbsRegPathShared + "HBSRegistry.xml");
        File parent = new File(this.hbsRegFile.getParent());
        boolean newRegWritten = parent.mkdirs();
        return this.writeStringToFile(sb_Temp.toString(), this.hbsRegFile);
    }

    boolean createRegFile() {
        return this.createRegFile(true);
    }

    boolean ensureRegFileExists() {
        boolean b_Out = false;
        this.hbsRegFile = new File(this.hbsRegPathShared + "HBSRegistry.xml");
        if (!this.hbsRegFile.exists()) {
            this.hbsRegFile = new File(this.hbsRegPathUser + "HBSRegistry.xml");
            if (!this.hbsRegFile.exists()) {
                this.createRegFile();
                return true;
            }
        }
        if (!this.hbsRegFile.canRead()) {
            return b_Out;
        }
        return true;
    }

    public String getHP6RegKey() {
        return this.str_HP6RegKey;
    }

    public String getHP6UserName() {
        return this.str_HP6UserName;
    }

    public boolean getIsHP6Registered() {
        return this.isHP6Registered;
    }

    public boolean getIsMasherRegistered() {
        return this.isMasher6Registered;
    }

    public String getMasher6RegKey() {
        return this.str_Masher6RegKey;
    }

    public String getMasher6UserName() {
        return this.str_MasherUserName;
    }

    public boolean getRegBoolean(String str_Key, boolean b_default) {
        String str_Out = (String)this.ht_RegValues.get(str_Key);
        if (!(str_Out instanceof String)) {
            return b_default;
        }
        return str_Out.equals("1");
    }

    void getRegKeyAndNameFromUser(int int_productIndexIn) {
        this.dlg_Register = new HP6Dialog();
        this.int_productIndex = int_productIndexIn;
        this.brdr_10_10_0_5 = BorderFactory.createEmptyBorder(10, 10, 0, 5);
        this.str_Temp = "";
        this.gbc = new GridBagConstraints();
        this.borderLayout1 = new BorderLayout();
        this.pnl_AllRegisterUserComponents = new JPanel();
        this.lom_AllRegisterUserComponents = new BorderLayout();
        this.pnl_RegisterUserTab = new JPanel();
        this.lom_RegisterUserTab = new BorderLayout();
        this.pnl_RegisterUserControls = new JPanel();
        this.lom_RegistersUserControls = new BoxLayout(this.pnl_RegisterUserControls, 1);
        this.pnl_RegisterUserIO = new JPanel();
        this.lom_RegisterUserIO = new BoxLayout(this.pnl_RegisterUserIO, 1);
        this.pnl_UserNameToRegister = new JPanel();
        this.lom_UserNameToRegister = new GridBagLayout();
        this.lbl_UserNameToRegister = new HP6Label();
        this.tf_UserNameToRegister = new HP6TextField();
        this.pnl_RegKeyToRegister = new JPanel();
        this.lom_RegKeyToRegister = new GridBagLayout();
        this.lbl_RegKeyToRegister = new HP6Label();
        this.tf_RegKeyToRegister = new HP6TextField();
        this.btn_RegisterUserRegister = new HP6Button();
        this.btn_RegisterUserCloseWindow = new HP6Button();
        this.RegisterUserUIInit();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.dlg_Register.setSize(450, 300);
        Dimension frameSize = this.dlg_Register.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.dlg_Register.setLocation((screenSize.width - frameSize.width) / 4, (screenSize.height - frameSize.height) / 4);
        this.dlg_Register.setModal(true);
        this.dlg_Register.validate();
    }

    boolean getRegNameAndKey() {
        boolean b_temp = false;
        switch (this.initRegModel(this.hbsRegFile)) {
            case 0: {
                this.str_HP6UserName = (String)this.ht_RegValues.get("hotpot-v6-user-name");
                this.str_HP6RegKey = (String)this.ht_RegValues.get("hotpot-v6-reg-key");
                this.str_MasherUserName = (String)this.ht_RegValues.get("masher-v6-user-name");
                this.str_Masher6RegKey = (String)this.ht_RegValues.get("masher-v6-reg-key");
                if (this.str_HP6UserName.length() == 0) break;
                b_temp = true;
            }
        }
        return b_temp;
    }

    public String getRegString(String str_Key, String str_Default) {
        String str_Out = (String)this.ht_RegValues.get(str_Key);
        if (!(str_Out instanceof String)) {
            return str_Default;
        }
        return str_Out;
    }

    void hideWindow() {
        this.dlg_Register.setVisible(false);
        this.dlg_Register.dispose();
    }

    public int initRegModel(File regFile) {
        String str_tempKey = "";
        String str_tempValue = "";
        String str_FileText = "";
        String str_Temp = "";
        String str_FileOneParse = "";
        StringReader sr_ParsedOnce = null;
        try {
            str_FileText = GenericSaxModel.readFile(regFile);
            str_FileOneParse = str_FileOneParse + this.replaceStuff(str_FileText, "&amp;", "&");
        }
        catch (IOException ioe) {
            this.writeErrorReport("HbsRegistrySaxModel.init()" + this.crlf + ioe.getMessage() + this.crlf + ioe.toString());
            return 1;
        }
        try {
            sr_ParsedOnce = new StringReader(str_FileOneParse);
            InputSource inputSource = new InputSource(sr_ParsedOnce);
            inputSource.setEncoding(this.charEncoding);
            this.xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.regSaxHandler = new RegSaxHandler();
            this.xmlReader.setContentHandler(this.regSaxHandler);
            this.xmlReader.parse(inputSource);
            Enumeration e = this.regSaxHandler.ht_RegValues.keys();
            while (e.hasMoreElements()) {
                str_tempKey = (String)e.nextElement();
                str_tempValue = this.undoXmlSafe((String)this.regSaxHandler.ht_RegValues.get(str_tempKey));
                this.regSaxHandler.ht_RegValues.put(str_tempKey, str_tempValue);
            }
            this.ht_RegValues.putAll(this.regSaxHandler.ht_RegValues);
            this.regSaxHandler.ht_RegValues.clear();
            return 0;
        }
        catch (IOException ioe) {
            this.writeErrorReport("HbsRegistrySaxModel.init()" + this.crlf + ioe.toString() + this.crlf + ioe.getMessage());
            return 1;
        }
        catch (SAXException saxe) {
            this.writeErrorReport("HbsRegistrySaxModel.init()" + this.crlf + saxe.toString() + this.crlf + saxe.getMessage());
            return 2;
        }
    }

    boolean isValidHP6Key(String str_UserName, String str_RegKey) {
        String goodRegKey = "freeware user";
        String testRegKey = "freeware user";
        if (testRegKey.length() == 0) {
            return false;
        }
        return goodRegKey.equals(testRegKey);
    }

    boolean isValidHP6NameNoKey(String str_UserName) {
        return str_UserName.length() != 0;
    }

    boolean isValidMasher6Key(String str_UserName, String str_RegKey) {
        String goodRegKey = "freeware user";
        String testRegKey = "freeware user";
        str_UserName = "";
        str_RegKey = "";
        if (testRegKey.length() == 0) {
            return false;
        }
        return goodRegKey.equals(testRegKey);
    }

    boolean isValidMasher6NameNoKey(String str_UserName) {
        return str_UserName.length() != 0;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.hideWindow();
        }
    }

    void reportRegResults(int int_ProductIndexIn) {
        if (int_ProductIndexIn == 0) {
            this.str_HP6UserName = this.tf_UserNameToRegister.getText();
            this.str_HP6UserName.trim();
            if (this.str_HP6UserName.startsWith("User name:") | this.str_HP6UserName.startsWith("user name:")) {
                this.str_HP6UserName = this.str_HP6UserName.substring(10);
            }
            this.str_HP6RegKey = this.tf_RegKeyToRegister.getText();
            this.str_HP6RegKey.trim();
            if (this.str_HP6RegKey.startsWith("Key:") | this.str_HP6RegKey.startsWith("key:")) {
                this.str_HP6RegKey = this.str_HP6RegKey.substring(4);
            }
            if (this.isValidHP6NameNoKey(this.str_HP6UserName)) {
                this.str_Temp = this.ifSaxModelNew.getMessageString("msg-registration-success");
                JOptionPane.showMessageDialog(this.dlg_Register, this.str_Temp);
                this.isHP6Registered = true;
                this.ht_RegValues.put("hotpot-v6-user-name", this.tf_UserNameToRegister.getText());
                this.ht_RegValues.put("hotpot-v6-reg-key", this.tf_RegKeyToRegister.getText());
                this.str_Temp = this.xmlHeader + this.crlf + this.toXml();
                if (!this.writeStringToFile(this.str_Temp, this.hbsRegFile)) {
                    this.writeErrorReport("HotPotRegSaxModel.writeStringToFile() Failed to write Registration file.");
                }
            } else {
                this.str_Temp = this.ifSaxModelNew.getMessageString("msg-registration-failed");
                JOptionPane.showMessageDialog(this.dlg_Register, this.str_Temp);
            }
        } else if (int_ProductIndexIn == 1) {
            this.str_MasherUserName = this.tf_UserNameToRegister.getText();
            this.str_MasherUserName.trim();
            if (this.str_MasherUserName.startsWith("User name:") | this.str_MasherUserName.startsWith("user name:")) {
                this.str_MasherUserName = this.str_MasherUserName.substring(10);
            }
            this.str_Masher6RegKey = this.tf_RegKeyToRegister.getText();
            this.str_Masher6RegKey.trim();
            if (this.str_Masher6RegKey.startsWith("Key:") | this.str_Masher6RegKey.startsWith("key:")) {
                this.str_Masher6RegKey = this.str_Masher6RegKey.substring(4);
            }
            if (this.isValidMasher6NameNoKey(this.str_MasherUserName)) {
                this.str_Temp = this.ifSaxModelNew.getMessageString("msg-registration-success");
                JOptionPane.showMessageDialog(this.dlg_Register, this.str_Temp);
                this.isMasher6Registered = true;
                this.ht_RegValues.put("masher-v6-user-name", this.tf_UserNameToRegister.getText());
                this.ht_RegValues.put("masher-v6-reg-key", this.tf_RegKeyToRegister.getText());
                this.str_Temp = this.xmlHeader + this.crlf + this.toXml();
                if (!this.writeStringToFile(this.str_Temp, this.hbsRegFile)) {
                    this.writeErrorReport("HotPotRegSaxModel.writeStringToFile() Failed to write Registration file.");
                }
            } else {
                this.str_Temp = this.ifSaxModelNew.getMessageString("msg-registration-failed");
                JOptionPane.showMessageDialog(this.dlg_Register, this.str_Temp);
            }
        }
    }

    public void setRegBoolean(String str_Key, boolean b_value) {
        if (b_value) {
            this.ht_RegValues.put(str_Key, "1");
        } else {
            this.ht_RegValues.put(str_Key, "0");
        }
    }

    public void setRegString(String str_Key, String str_Value) {
        this.ht_RegValues.put(str_Key, str_Value);
    }

    public String toXml() {
        StringBuffer sb_Out = new StringBuffer();
        sb_Out.append("<hbs-registry>" + this.crlf);
        Enumeration e = this.ht_RegValues.keys();
        while (e.hasMoreElements()) {
            String str_tempKey = (String)e.nextElement();
            String str_tempValue = (String)this.ht_RegValues.get(str_tempKey);
            sb_Out.append("<" + str_tempKey + ">");
            sb_Out.append(this.makeXmlSafe(str_tempValue));
            sb_Out.append("</" + str_tempKey + ">" + this.crlf);
        }
        sb_Out.append("</hbs-registry>" + this.crlf);
        String str_Out = sb_Out.toString();
        return str_Out;
    }
}

