/*
 * Decompiled with CFR 0.152.
 */
package hotpot6;

import hotpot6.JQuizAnswerItem;
import hotpot6.JQuizQuestionItem;
import hotpot6.JQuizUI;
import hotpot6.JxxSaxModel;
import hotpot6.JxxUI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JQuizSaxModel
extends JxxSaxModel {
    int int_temp = 0;
    JQuizSaxHandler jQuizSaxHandler;
    int questionNumber = 0;
    JQuizQuestionItem temp_JQuizQuestionItem;

    public JQuizSaxModel(JxxUI modelOwnerIn, File dataFileIn) {
        this.modelOwner = modelOwnerIn;
        this.dataFile = dataFileIn;
        this.initSaxModel(dataFileIn);
        this.dataFileDefault = this.dataFileDefault;
    }

    public JQuizSaxModel(JxxUI modelOwnerIn) {
        this(modelOwnerIn, new File(System.getProperty("user.home") + System.getProperty("file.separator") + "unnamed.jqz"));
    }

    public JQuizSaxModel(File dataFileIn) {
        this.initSaxModel(dataFileIn);
        this.dataFileDefault = this.dataFileDefault;
    }

    public JQuizSaxModel() {
        this(new File(System.getProperty("user.home") + System.getProperty("file.separator") + "unnamed.jqz"));
    }

    ArrayList compactExItems(boolean forData) {
        ArrayList al_TempExItems;
        int compactIndex = -1;
        if (forData) {
            int max = this.getLastGoodItemForData();
            al_TempExItems = new ArrayList(max + 1);
            int i = 0;
            while (i <= max) {
                if (this.isExItemGoodForData(i)) {
                    al_TempExItems.add(++compactIndex, this.al_ExItems.get(i));
                }
                ++i;
            }
        } else {
            int max = this.getLastGoodItemForExercise();
            al_TempExItems = new ArrayList(max + 1);
            int i = 0;
            while (i <= max) {
                if (this.isExItemGoodForExercise(i)) {
                    al_TempExItems.add(++compactIndex, this.al_ExItems.get(i));
                }
                ++i;
            }
        }
        return al_TempExItems;
    }

    ArrayList compactExItems() {
        return this.compactExItems(true);
    }

    String createHybridQuestionForPage(int indexInSax, int qNumInEx, int int_TextBoxSize, boolean b_useTextAreaIn) {
        StringBuffer sb_Out = new StringBuffer();
        sb_Out.append(this.createSAQuestionForPage(indexInSax, qNumInEx, int_TextBoxSize, b_useTextAreaIn));
        sb_Out.append(this.createMCAnswersForPage(indexInSax, qNumInEx, true));
        return sb_Out.toString();
    }

    String createMCAnswersForPage(int indexInSax, int qNumInEx, boolean isForHybrid) {
        StringBuffer sb_Out = new StringBuffer();
        if (isForHybrid) {
            sb_Out.append("<ol class=\"MCAnswers\" ");
            sb_Out.append(" id=\"Q_" + qNumInEx + "_Hybrid_MC\" ");
            sb_Out.append(" style=\"display: none;\">" + this.crlf);
        } else {
            sb_Out.append("<ol class=\"MCAnswers\">" + this.crlf);
        }
        int int_AnsNumInEx = -1;
        int j = 0;
        while (j < this.getAnswerVector(indexInSax).size()) {
            if (this.getAnswerText(indexInSax, j).length() != 0) {
                ++int_AnsNumInEx;
                if (!isForHybrid || this.getIncludeInMC(indexInSax, j) != 0) {
                    sb_Out.append("<li id=\"Q_" + qNumInEx + "_" + int_AnsNumInEx + "\">" + this.crlf);
                    sb_Out.append("<button class=\"FuncButton\" ");
                    sb_Out.append(" onfocus=\"FuncBtnOver(this)\" ");
                    sb_Out.append(" onblur=\"FuncBtnOut(this)\" ");
                    sb_Out.append(" onmouseover=\"FuncBtnOver(this)\" ");
                    sb_Out.append(" onmouseout=\"FuncBtnOut(this)\" ");
                    sb_Out.append(" onmousedown=\"FuncBtnDown(this)\" ");
                    sb_Out.append(" onmouseup=\"FuncBtnOut(this)\" ");
                    sb_Out.append(" id=\"Q_" + qNumInEx + "_" + int_AnsNumInEx + "_Btn\" ");
                    sb_Out.append(" onclick=\"CheckMCAnswer(" + qNumInEx + "," + int_AnsNumInEx + ",this)\">");
                    sb_Out.append("&nbsp;&nbsp;?&nbsp;&nbsp;");
                    sb_Out.append("</button>");
                    sb_Out.append("&nbsp;&nbsp;" + this.makeHtmlSafe(this.makeCrToBrSafe(this.getAnswerText(indexInSax, j))));
                    sb_Out.append(this.crlf + "</li>" + this.crlf);
                }
            }
            ++j;
        }
        sb_Out.append("</ol>" + this.crlf);
        return sb_Out.toString();
    }

    String createMCQuestionForPage(int indexInSax, int qNumInEx) {
        StringBuffer sb_Out = new StringBuffer();
        sb_Out.append("<div class=\"QuestionText\">");
        sb_Out.append(this.makeHtmlSafe(this.makeCrToBrSafe(this.getQuestionText(indexInSax))));
        sb_Out.append("</div>" + this.crlf);
        sb_Out.append(this.createMCAnswersForPage(indexInSax, qNumInEx, false));
        return sb_Out.toString();
    }

    String createMultiCorrectQuestionForPage(int indexInSax, int qNumInEx) {
        StringBuffer sb_Out = new StringBuffer();
        sb_Out.append("<p class=\"QuestionText\">");
        sb_Out.append(this.makeHtmlSafe(this.makeCrToBrSafe(this.getQuestionText(indexInSax))));
        sb_Out.append("</p>" + this.crlf);
        sb_Out.append("<ol class=\"MSelAnswers\" >" + this.crlf);
        int j = 0;
        while (j < this.getAnswerVector(indexInSax).size()) {
            String str_Temp = this.getAnswerText(indexInSax, j);
            if (str_Temp.length() > 0) {
                sb_Out.append("<li id=\"Q_" + qNumInEx + "_" + j + "\" >");
                sb_Out.append("<form method=\"post\" action=\"\" onsubmit=\"return false;\">" + this.crlf);
                sb_Out.append("<div>" + this.crlf);
                sb_Out.append("<input type=\"checkbox\" class=\"MSelCheckbox\" ");
                sb_Out.append(" id=\"Q_" + qNumInEx + "_" + j + "_Chk\"" + "/>" + this.crlf);
                sb_Out.append(this.makeHtmlSafe(this.makeCrToBrSafe(str_Temp)));
                sb_Out.append("</div>" + this.crlf);
                sb_Out.append("</form>" + this.crlf);
                sb_Out.append("</li>" + this.crlf);
            }
            ++j;
        }
        sb_Out.append("</ol>");
        sb_Out.append("<button class=\"FuncButton\" ");
        sb_Out.append(" onfocus=\"FuncBtnOver(this)\" ");
        sb_Out.append(" onblur=\"FuncBtnOut(this)\" ");
        sb_Out.append(" onmouseover=\"FuncBtnOver(this)\" ");
        sb_Out.append(" onmouseout=\"FuncBtnOut(this)\" ");
        sb_Out.append(" onmousedown=\"FuncBtnDown(this)\" ");
        sb_Out.append(" onmouseup=\"FuncBtnOut(this)\" ");
        sb_Out.append(" onclick=\"CheckMultiSelAnswer(" + qNumInEx + ")\">");
        sb_Out.append(this.makeHtmlSafe(this.modelOwner.configSaxModel.getConfigSaxValue("global", "check-caption", "Check")));
        sb_Out.append("</button>");
        return sb_Out.toString();
    }

    String createSAQuestionForPage(int indexInSax, int qNumInEx, int int_TextBoxSize, boolean b_useTextAreaIn) {
        StringBuffer sb_Out = new StringBuffer();
        sb_Out.append("<div class=\"QuestionText\">");
        sb_Out.append(this.makeHtmlSafe(this.makeCrToBrSafe(this.getQuestionText(indexInSax))));
        sb_Out.append("</div>" + this.crlf);
        sb_Out.append("<div class=\"ShortAnswer\" id=\"Q_" + qNumInEx + "_SA\">" + this.crlf);
        sb_Out.append("<form method=\"post\" action=\"\" onsubmit=\"return false;\">");
        sb_Out.append(" <div>");
        if (b_useTextAreaIn) {
            sb_Out.append(" <textarea id=\"Q_" + qNumInEx + "_Guess\" ");
            sb_Out.append(" onfocus=\"TrackFocus('Q_" + qNumInEx + "_Guess')\" ");
            sb_Out.append(" onblur=\"LeaveGap()\" ");
            sb_Out.append("class=\"ShortAnswerBox\" ");
            sb_Out.append(" cols=\"20\" rows=\"2\">");
            sb_Out.append("</textarea>");
        } else {
            sb_Out.append(" <input type=\"text\" id=\"Q_" + qNumInEx + "_Guess\" ");
            sb_Out.append(" onfocus=\"TrackFocus('Q_" + qNumInEx + "_Guess')\" ");
            sb_Out.append(" onblur=\"LeaveGap()\" ");
            sb_Out.append(" class=\"GapBox\" ");
            sb_Out.append(" size=\"" + int_TextBoxSize + "\"></input>");
        }
        sb_Out.append(" <br /><br /> ");
        sb_Out.append("<button class=\"FuncButton\" ");
        sb_Out.append(" onfocus=\"FuncBtnOver(this)\" ");
        sb_Out.append(" onblur=\"FuncBtnOut(this)\" ");
        sb_Out.append(" onmouseover=\"FuncBtnOver(this)\" ");
        sb_Out.append(" onmouseout=\"FuncBtnOut(this)\" ");
        sb_Out.append(" onmousedown=\"FuncBtnDown(this)\" ");
        sb_Out.append(" onmouseup=\"FuncBtnOut(this)\" ");
        sb_Out.append(" onclick=\"CheckShortAnswer(" + qNumInEx + ")\">");
        sb_Out.append(this.makeHtmlSafe(this.modelOwner.configSaxModel.getConfigSaxValue("global", "check-caption", "Check")));
        sb_Out.append("</button>");
        if (this.modelOwner.configSaxModel.getConfigSaxBoolean("jquiz", "include-hint", "0")) {
            sb_Out.append("<button class=\"FuncButton\" ");
            sb_Out.append(" onfocus=\"FuncBtnOver(this)\" ");
            sb_Out.append(" onblur=\"FuncBtnOut(this)\" ");
            sb_Out.append(" onmouseover=\"FuncBtnOver(this)\" ");
            sb_Out.append(" onmouseout=\"FuncBtnOut(this)\" ");
            sb_Out.append(" onmousedown=\"FuncBtnDown(this)\" ");
            sb_Out.append(" onmouseup=\"FuncBtnOut(this)\" ");
            sb_Out.append(" onclick=\"ShowHint(" + qNumInEx + ")\">");
            sb_Out.append(this.makeHtmlSafe(this.modelOwner.configSaxModel.getConfigSaxValue("global", "hint-caption", "Hint")));
            sb_Out.append("</button>");
        }
        if (this.modelOwner.configSaxModel.getConfigSaxBoolean("jquiz", "include-show-answer", "0")) {
            sb_Out.append("<button class=\"FuncButton\" ");
            sb_Out.append(" onfocus=\"FuncBtnOver(this)\" ");
            sb_Out.append(" onblur=\"FuncBtnOut(this)\" ");
            sb_Out.append(" onmouseover=\"FuncBtnOver(this)\" ");
            sb_Out.append(" onmouseout=\"FuncBtnOut(this)\" ");
            sb_Out.append(" onmousedown=\"FuncBtnDown(this)\" ");
            sb_Out.append(" onmouseup=\"FuncBtnOut(this)\" ");
            sb_Out.append(" onclick=\"ShowAnswers(" + qNumInEx + ")\">");
            sb_Out.append(this.makeHtmlSafe(this.modelOwner.configSaxModel.getConfigSaxValue("jquiz", "show-answer-caption", "Show Answer")));
            sb_Out.append("</button>");
        }
        sb_Out.append("</div>");
        sb_Out.append("</form>");
        sb_Out.append("</div>" + this.crlf);
        return sb_Out.toString();
    }

    String createTextOutput() {
        StringBuffer sb_Out = new StringBuffer();
        StringBuffer sb_Key = new StringBuffer(this.crlf + this.crlf + this.crlf + "----------Key----------" + this.crlf + this.crlf);
        sb_Out.append(this.dataFile.getPath() + this.crlf + this.crlf);
        sb_Out.append(this.getExSaxValue("shared", "title", "JQuiz Exercise") + this.crlf);
        int outputNum = 1;
        int i = 0;
        while (i < this.al_CompactedExItems.size()) {
            sb_Out.append(this.crlf + outputNum + ". " + this.getQuestionText(i) + this.crlf);
            sb_Key.append(this.crlf + outputNum + ". ");
            switch (this.getQuestionType(i)) {
                case 0: {
                    break;
                }
                case 1: 
                case 4: {
                    int j = 0;
                    while (j < this.temp_JQuizQuestionItem.questionAnswer.size()) {
                        String str_Temp = ((JQuizUI)this.modelOwner).pnl_EditExSpecific.getRowLetters(j, true);
                        String str_Temp2 = this.getAnswerText(i, j);
                        if (str_Temp2.length() > 0) {
                            sb_Out.append(str_Temp + ") " + str_Temp2 + this.crlf);
                            if (this.getCorrect(i, j) == 1) {
                                sb_Key.append("(" + str_Temp + ") ");
                            }
                        }
                        ++j;
                    }
                    sb_Key.append(this.crlf);
                    break;
                }
                case 2: 
                case 3: {
                    int j = 0;
                    while (j < this.temp_JQuizQuestionItem.questionAnswer.size()) {
                        if (this.getCorrect(i, j) == 1) {
                            sb_Key.append(this.getAnswerText(i, j) + this.crlf);
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++outputNum;
            ++i;
        }
        return sb_Out.toString() + sb_Key.toString();
    }

    String createWebCTOutput() {
        StringBuffer sb_Out = new StringBuffer();
        int int_outputNum = 1;
        String str_cat = this.makeHtmlSafe(this.getExSaxValue("shared", "title", "JQuiz Exercise"));
        int i = 0;
        while (i < this.al_CompactedExItems.size()) {
            int int_displayAnsNum = 0;
            int int_qType = this.getQuestionType(i);
            this.temp_JQuizQuestionItem = (JQuizQuestionItem)this.al_CompactedExItems.get(i);
            switch (int_qType) {
                case 0: {
                    break;
                }
                case 1: 
                case 4: {
                    String str_Temp;
                    int j;
                    if (int_qType == 4) {
                        sb_Out.append(":TYPE:MC:N:0:A" + this.crlf);
                    } else {
                        int int_NumCorrect = 0;
                        j = 0;
                        while (j < this.temp_JQuizQuestionItem.questionAnswer.size()) {
                            if (this.getCorrect(i, j) == 1) {
                                ++int_NumCorrect;
                            }
                            ++j;
                        }
                        if (int_NumCorrect > 1) {
                            sb_Out.append(":TYPE:MC:N:0:C" + this.crlf);
                        } else {
                            sb_Out.append(":TYPE:MC:1:0:C" + this.crlf);
                        }
                    }
                    sb_Out.append(":TITLE:" + str_cat + " (" + int_outputNum + ")" + this.crlf);
                    sb_Out.append(":CAT:" + str_cat + this.crlf);
                    sb_Out.append(":QUESTION:H" + this.crlf);
                    sb_Out.append(this.makeHtmlSafe(this.getQuestionText(i)) + this.crlf);
                    int j2 = 0;
                    while (j2 < this.temp_JQuizQuestionItem.questionAnswer.size()) {
                        str_Temp = this.makeHtmlSafe(this.getAnswerText(i, j2));
                        if (str_Temp.length() > 0) {
                            sb_Out.append(":ANSWER" + ++int_displayAnsNum + ":" + Integer.toString(this.getPercentCorrect(i, j2)) + ":H" + this.crlf);
                            sb_Out.append(str_Temp + this.crlf);
                            sb_Out.append(":REASON" + int_displayAnsNum + ":H" + this.crlf);
                            sb_Out.append(this.makeHtmlSafe(this.getFeedbackText(i, j2)) + this.crlf);
                        }
                        ++j2;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    String str_Temp;
                    sb_Out.append(":TYPE:S" + this.crlf);
                    sb_Out.append(":TITLE:" + str_cat + " (" + int_outputNum + ")" + this.crlf);
                    sb_Out.append(":CAT:" + str_cat + this.crlf);
                    sb_Out.append(":QUESTION:H" + this.crlf);
                    sb_Out.append(this.makeHtmlSafe(this.getQuestionText(i)) + this.crlf);
                    sb_Out.append(":ANSWERS:1" + this.crlf);
                    sb_Out.append(":CASE:0" + this.crlf);
                    int j = 0;
                    while (j < this.temp_JQuizQuestionItem.questionAnswer.size()) {
                        str_Temp = this.makeHtmlSafe(this.getAnswerText(i, j));
                        if (str_Temp.length() > 0) {
                            sb_Out.append(":ANSWER" + ++int_displayAnsNum + ":" + str_Temp + ":" + Integer.toString(this.getPercentCorrect(i, j)) + ":0:0" + this.crlf);
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++int_outputNum;
            ++i;
        }
        return sb_Out.toString();
    }

    String doArrayForStandardPage() {
        StringBuffer sb_Out = new StringBuffer();
        StringBuffer sb_Msg = new StringBuffer();
        int qNum = -1;
        int ansNum = -1;
        boolean b_temp = false;
        sb_Out.append("var I=new Array();" + this.crlf);
        StringBuffer sb_Error1 = new StringBuffer();
        StringBuffer sb_Error2 = new StringBuffer();
        boolean[] missingQ = new boolean[this.al_CompactedExItems.size()];
        boolean[] missingCorrect = new boolean[this.al_CompactedExItems.size()];
        boolean missingQFlag = false;
        boolean missingCorrectFlag = false;
        int i = 0;
        while (i < this.al_CompactedExItems.size()) {
            String str_Temp = this.getQuestionText(i);
            if (str_Temp.length() == 0) {
                missingQ[i] = true;
            }
            b_temp = false;
            int j = 0;
            while (j < this.getAnswerVector(i).size()) {
                if (this.getCorrect(i, j) == 1) {
                    b_temp = true;
                }
                ++j;
            }
            if (!b_temp) {
                missingCorrect[i] = true;
            }
            if (missingQ[i]) {
                if (!missingCorrect[i]) {
                    missingQFlag = true;
                    sb_Error1.append(i + 1);
                    sb_Error1.append(", ");
                }
            } else if (missingCorrect[i]) {
                missingCorrectFlag = true;
                sb_Error2.append(i + 1);
                sb_Error2.append(", ");
            }
            if (!missingQ[i] && !missingCorrect[i]) {
                sb_Out.append("I[" + ++qNum + "] = new Array();" + this.crlf);
                int int_temp = this.getWeighting(i);
                sb_Out.append("I[" + qNum + "][0] = " + int_temp + ";" + this.crlf);
                str_Temp = "";
                sb_Out.append("I[" + qNum + "][1] = " + "''" + ";" + this.crlf);
                int_temp = this.getQuestionType(i) - 1;
                sb_Out.append("I[" + qNum + "][2] = '" + int_temp + "';" + this.crlf);
                sb_Out.append("I[" + qNum + "][3] = " + "new Array()" + ";" + this.crlf);
                ansNum = -1;
                int j2 = 0;
                while (j2 < this.getAnswerVector(i).size()) {
                    str_Temp = this.getAnswerText(i, j2);
                    if (str_Temp.length() != 0) {
                        sb_Out.append("I[" + qNum + "][3][" + ++ansNum + "] = " + "new Array(" + "'" + this.makeJavaScriptSafe(this.getAnswerText(i, j2)) + "'," + "'" + this.makeJavaScriptSafe(this.getFeedbackText(i, j2)) + "'," + this.getCorrect(i, j2) + "," + this.getPercentCorrect(i, j2) + "," + this.getIncludeInMC(i, j2) + ");" + this.crlf);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (missingQFlag) {
            sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-item-skipped-no-question") + " ");
            sb_Msg.append(sb_Error1.toString() + this.crlf);
        }
        if (missingCorrectFlag) {
            sb_Msg.append(this.modelOwner.ifSaxModelNew.getMessageString("msg-item-skipped-no-correct-answer") + " ");
            sb_Msg.append(sb_Error2.toString() + this.crlf);
        }
        if (missingQFlag || missingCorrectFlag) {
            JOptionPane.showMessageDialog(this.modelOwner, sb_Msg.toString());
        }
        sb_Out.append("");
        return sb_Out.toString();
    }

    String doExDataForStandardPage() {
        StringBuffer sb_Out = new StringBuffer();
        int int_TextBoxSize = 5;
        int int_TextBoxMax = 25;
        this.int_temp = 0;
        boolean[] ba_useTextArea = new boolean[this.al_CompactedExItems.size()];
        int i = 0;
        while (i < this.al_CompactedExItems.size()) {
            ba_useTextArea[i] = false;
            if (this.getQuestionType(i) == 2 || this.getQuestionType(i) == 3) {
                this.int_temp = this.getAnswerText(i, 0).length();
                if (this.int_temp > int_TextBoxMax) {
                    ba_useTextArea[i] = true;
                } else if (this.int_temp > int_TextBoxSize) {
                    int_TextBoxSize = this.int_temp;
                }
            }
            ++i;
        }
        sb_Out.append("<ol class=\"QuizQuestions\" id=\"Questions\">" + this.crlf);
        int qNumInEx = -1;
        int i2 = 0;
        while (i2 < this.al_CompactedExItems.size()) {
            if (this.getQuestionText(i2).length() != 0) {
                boolean b_temp = false;
                int j = 0;
                while (j < this.getAnswerVector(i2).size()) {
                    if (this.getCorrect(i2, j) == 1) {
                        b_temp = true;
                        break;
                    }
                    ++j;
                }
                if (b_temp) {
                    sb_Out.append("<li class=\"QuizQuestion\" id=\"Q_" + ++qNumInEx + "\" style=\"display: none;\">" + this.crlf);
                    switch (this.getQuestionType(i2)) {
                        case 1: {
                            sb_Out.append(this.createMCQuestionForPage(i2, qNumInEx));
                            break;
                        }
                        case 2: {
                            sb_Out.append(this.createSAQuestionForPage(i2, qNumInEx, int_TextBoxSize, ba_useTextArea[i2]));
                            break;
                        }
                        case 3: {
                            sb_Out.append(this.createHybridQuestionForPage(i2, qNumInEx, int_TextBoxSize, ba_useTextArea[i2]));
                            break;
                        }
                        case 4: {
                            sb_Out.append(this.createMultiCorrectQuestionForPage(i2, qNumInEx));
                        }
                    }
                    sb_Out.append("</li>" + this.crlf);
                }
            }
            ++i2;
        }
        sb_Out.append("</ol>" + this.crlf);
        return sb_Out.toString();
    }

    StringBuffer doSpecificIncludes(StringBuffer sb_Exercise) {
        this.al_CompactedExItems = this.compactExItems(false);
        boolean b_inclMultiChoice = false;
        boolean b_inclMultiSelect = false;
        boolean b_inclShortAnswer = false;
        int i = 0;
        while (i < this.al_CompactedExItems.size()) {
            this.int_temp = this.getQuestionType(i);
            if (this.getQuestionText(i).length() > 0) {
                switch (this.int_temp) {
                    case 1: {
                        b_inclMultiChoice = true;
                        break;
                    }
                    case 2: {
                        b_inclShortAnswer = true;
                        break;
                    }
                    case 3: {
                        b_inclMultiChoice = true;
                        b_inclShortAnswer = true;
                        break;
                    }
                    case 4: {
                        b_inclMultiSelect = true;
                    }
                }
            }
            ++i;
        }
        this.temp_bool = b_inclMultiChoice;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclMultiChoice]", this.temp_bool);
        this.temp_bool = b_inclShortAnswer;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclShortAnswer]", this.temp_bool);
        this.temp_bool = b_inclMultiSelect;
        sb_Exercise = this.handleInclXxx(sb_Exercise, "[inclMultiSelect]", this.temp_bool);
        return sb_Exercise;
    }

    StringBuffer doSpecificReplacements(StringBuffer sb_Exercise) {
        if (this.exType == 0) {
            this.temp_String = this.doArrayForStandardPage();
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strItemArray]", this.temp_String));
            this.temp_String = this.doExDataForStandardPage();
            sb_Exercise.replace(0, sb_Exercise.length(), this.replaceStuff(sb_Exercise.toString(), "[strQuestionOutput]", this.temp_String));
        }
        return sb_Exercise;
    }

    public String exSpecificToXml() {
        StringBuffer sb_Out = new StringBuffer();
        String crlf = System.getProperty("line.separator");
        sb_Out.append("");
        sb_Out.append("<questions>" + crlf);
        int i = 0;
        while (i <= this.getLastGoodItemForData()) {
            if (this.isExItemGoodForData(i)) {
                JQuizQuestionItem exItemTemp = (JQuizQuestionItem)this.al_ExItems.get(i);
                sb_Out.append("<question-record>" + crlf);
                String str_Temp = exItemTemp.questionText;
                sb_Out.append("<question>" + this.makeXmlSafe(str_Temp) + "</question>" + crlf);
                str_Temp = exItemTemp.clueText;
                sb_Out.append("<clue>" + this.makeXmlSafe(str_Temp) + "</clue>" + crlf);
                str_Temp = exItemTemp.category;
                sb_Out.append("<category>" + this.makeXmlSafe(str_Temp) + "</category>" + crlf);
                int int_Temp = exItemTemp.weighting;
                str_Temp = String.valueOf(int_Temp);
                sb_Out.append("<weighting>" + this.makeXmlSafe(str_Temp) + "</weighting>" + crlf);
                int_Temp = exItemTemp.fixed;
                str_Temp = String.valueOf(int_Temp);
                sb_Out.append("<fixed>" + this.makeXmlSafe(str_Temp) + "</fixed>" + crlf);
                int_Temp = exItemTemp.questionType;
                str_Temp = String.valueOf(int_Temp);
                sb_Out.append("<question-type>" + this.makeXmlSafe(str_Temp) + "</question-type>" + crlf);
                sb_Out.append("<answers>" + crlf);
                int j = 0;
                while (j < exItemTemp.questionAnswer.size()) {
                    JQuizAnswerItem exAnswerTemp = (JQuizAnswerItem)exItemTemp.questionAnswer.elementAt(j);
                    sb_Out.append("<answer>");
                    str_Temp = exAnswerTemp.ansText;
                    sb_Out.append("<text>" + this.makeXmlSafe(str_Temp) + "</text>" + crlf);
                    str_Temp = exAnswerTemp.ansFeedback;
                    sb_Out.append("<feedback>" + this.makeXmlSafe(str_Temp) + "</feedback>" + crlf);
                    int_Temp = exAnswerTemp.ansCorrect;
                    str_Temp = String.valueOf(int_Temp);
                    sb_Out.append("<correct>" + this.makeXmlSafe(str_Temp) + "</correct>" + crlf);
                    int_Temp = exAnswerTemp.percentCorrect;
                    str_Temp = String.valueOf(int_Temp);
                    sb_Out.append("<percent-correct>" + this.makeXmlSafe(str_Temp) + "</percent-correct>" + crlf);
                    int_Temp = exAnswerTemp.includeMC;
                    str_Temp = String.valueOf(int_Temp);
                    sb_Out.append("<include-in-mc-options>" + this.makeXmlSafe(str_Temp) + "</include-in-mc-options>" + crlf);
                    sb_Out.append("</answer>");
                    ++j;
                }
                sb_Out.append("</answers>" + crlf);
                sb_Out.append("</question-record>" + crlf);
            }
            ++i;
        }
        sb_Out.append("</questions>");
        return sb_Out.toString();
    }

    int fromDataFileToSaxSpecific() {
        try {
            this.jQuizSaxHandler = new JQuizSaxHandler();
            this.xmlReader.setContentHandler(this.jQuizSaxHandler);
            this.xmlReader.parse(this.dataInputSource);
            int i = 0;
            while (i < this.jQuizSaxHandler.temp_JQSMItem.al_ExItems.size()) {
                this.temp_JQuizQuestionItem = new JQuizQuestionItem();
                this.temp_JQuizQuestionItem.questionText = this.jQuizSaxHandler.temp_JQSMItem.getQuestionText(i);
                this.temp_JQuizQuestionItem.clueText = this.jQuizSaxHandler.temp_JQSMItem.getClue(i);
                this.temp_JQuizQuestionItem.weighting = this.jQuizSaxHandler.temp_JQSMItem.getWeighting(i);
                this.temp_JQuizQuestionItem.fixed = this.jQuizSaxHandler.temp_JQSMItem.getFixed(i);
                this.temp_JQuizQuestionItem.questionType = this.jQuizSaxHandler.temp_JQSMItem.getQuestionType(i);
                this.temp_JQuizQuestionItem.questionAnswer = this.jQuizSaxHandler.temp_JQSMItem.getAnswerVector(i);
                int j = 0;
                while (j < this.temp_JQuizQuestionItem.questionAnswer.size()) {
                    JQuizAnswerItem temp_JQuizAnswerItem = new JQuizAnswerItem();
                    temp_JQuizAnswerItem.ansText = this.jQuizSaxHandler.temp_JQSMItem.getAnswerText(i, j);
                    temp_JQuizAnswerItem.ansCorrect = this.jQuizSaxHandler.temp_JQSMItem.getCorrect(i, j);
                    temp_JQuizAnswerItem.percentCorrect = this.jQuizSaxHandler.temp_JQSMItem.getPercentCorrect(i, j);
                    temp_JQuizAnswerItem.ansFeedback = this.jQuizSaxHandler.temp_JQSMItem.getFeedbackText(i, j);
                    temp_JQuizAnswerItem.includeMC = this.jQuizSaxHandler.temp_JQSMItem.getIncludeInMC(i, j);
                    ++j;
                }
                if (i < this.al_ExItems.size()) {
                    this.al_ExItems.set(i, this.temp_JQuizQuestionItem);
                } else {
                    this.al_ExItems.add(this.temp_JQuizQuestionItem);
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            this.writeErrorReport("JQuizSaxModel.fromDataFileToSaxSpecific()" + this.crlf + ioe.toString() + this.crlf + ioe.getMessage());
            return 1;
        }
        catch (SAXException saxe) {
            this.writeErrorReport("JQuizSaxModel.fromDataFileToSaxSpecific()" + this.crlf + saxe.toString() + this.crlf + saxe.getMessage());
            return 2;
        }
        return 0;
    }

    public int fromExSaxToDataFileSpecific() {
        this.sb_DataToWrite.append(this.exSpecificToXml());
        return 0;
    }

    public String getAnswerText(int questionNum, int answerNum) {
        String getAnswer = "";
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                getAnswer = newAnswer.ansText;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return getAnswer;
    }

    public Vector getAnswerVector(int questionNum) {
        Vector ansVec = new Vector();
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            ansVec = (Vector)newQuestion.questionAnswer.clone();
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return ansVec;
    }

    public String getCategory(int questionNum) {
        String getCategory;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            getCategory = newQuestion.category;
        }
        catch (IndexOutOfBoundsException ex) {
            getCategory = "";
        }
        return getCategory;
    }

    public String getClue(int questionNum) {
        String getClue;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            getClue = newQuestion.clueText;
        }
        catch (IndexOutOfBoundsException ex) {
            getClue = "";
        }
        return getClue;
    }

    public int getCorrect(int questionNum, int answerNum) {
        int getCorrect = 0;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                getCorrect = newAnswer.ansCorrect;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return getCorrect;
    }

    public String getFeedbackText(int questionNum, int answerNum) {
        String getFeedback = "";
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                getFeedback = newAnswer.ansFeedback;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return getFeedback;
    }

    public int getFixed(int questionNum) {
        int getFixed = 0;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            getFixed = newQuestion.fixed;
        }
        catch (IndexOutOfBoundsException ex) {
            getFixed = 0;
        }
        return getFixed;
    }

    public int getIncludeInMC(int questionNum, int answerNum) {
        int getIncludeInMC = 0;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                getIncludeInMC = newAnswer.includeMC;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return getIncludeInMC;
    }

    int getLastGoodItemForData() {
        int int_Out = -1;
        int i = this.al_ExItems.size() - 1;
        while (i > -1) {
            if (this.isExItemGoodForData(i)) {
                int_Out = i;
                break;
            }
            --i;
        }
        return int_Out;
    }

    int getLastGoodItemForExercise() {
        int int_Out = -1;
        int i = this.al_ExItems.size() - 1;
        while (i > -1) {
            if (this.isExItemGoodForExercise(i)) {
                int_Out = i;
                break;
            }
            --i;
        }
        return int_Out;
    }

    public int getPercentCorrect(int questionNum, int answerNum) {
        int getPercentCorrect = 0;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                getPercentCorrect = newAnswer.percentCorrect;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        return getPercentCorrect;
    }

    String getPotExt() {
        return this.potExt;
    }

    String getPotXmlTag() {
        return this.potXmlTag;
    }

    public String getQuestionText(int questionNum) {
        String questionText;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            questionText = newQuestion.questionText;
        }
        catch (IndexOutOfBoundsException ex) {
            questionText = "";
        }
        return questionText;
    }

    public int getQuestionType(int questionNum) {
        int questionType = 0;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            questionType = newQuestion.questionType;
        }
        catch (IndexOutOfBoundsException ex) {
            questionType = 5;
        }
        return questionType;
    }

    public int getWeighting(int questionNum) {
        int getWeighting = 0;
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            getWeighting = newQuestion.weighting;
        }
        catch (IndexOutOfBoundsException ex) {
            getWeighting = 0;
        }
        return getWeighting;
    }

    void initSaxModel(File dataFileIn) {
        this.potExt = "jqz";
        this.potXmlTag = "jquiz";
        this.initSaxModelShared(dataFileIn);
        int i = 0;
        while (i < 5) {
            this.al_ExItems.add(new JQuizQuestionItem());
            ++i;
        }
        int i2 = 0;
        while (i2 < 5) {
            this.al_ExItemsDefault.add(new JQuizQuestionItem());
            ++i2;
        }
        this.dataFileDefault = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "unnamed." + this.potExt);
    }

    boolean isExItemGoodForData(int exItemNum) {
        boolean b_QuesGood = false;
        boolean b_AnsGood = false;
        if (this.getQuestionText(exItemNum).length() > 0) {
            b_QuesGood = true;
        }
        int j = 0;
        while (j < this.getAnswerVector(exItemNum).size()) {
            if (this.getAnswerText(exItemNum, j).length() > 0 || this.getFeedbackText(exItemNum, j).length() > 0 || this.getCorrect(exItemNum, j) == 1) {
                b_AnsGood = true;
                break;
            }
            ++j;
        }
        return b_QuesGood && b_AnsGood;
    }

    boolean isExItemGoodForExercise(int exItemNum) {
        boolean b_QuesGood = false;
        boolean b_AnsGood = false;
        if (this.getQuestionText(exItemNum).length() > 0) {
            b_QuesGood = true;
        }
        int j = 0;
        while (j < this.getAnswerVector(exItemNum).size()) {
            if (this.getAnswerText(exItemNum, j).length() > 0 && this.getCorrect(exItemNum, j) == 1) {
                b_AnsGood = true;
                break;
            }
            ++j;
        }
        return b_QuesGood && b_AnsGood;
    }

    public boolean notInRange(int questionNum) {
        boolean notInRange = true;
        return notInRange;
    }

    public void setAnswer(int questionNum, int answerNum, String newAnswerText, String newAnswerFeedback, int newCorrect, int newPercentCorrect, int newIncludeInMC) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = new JQuizAnswerItem();
                newAnswer.ansText = newAnswerText;
                newAnswer.ansFeedback = newAnswerFeedback;
                newAnswer.percentCorrect = newPercentCorrect;
                newAnswer.ansCorrect = newCorrect;
                newAnswer.includeMC = newIncludeInMC;
                newQuestion.questionAnswer.add(answerNum, newAnswer);
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public void setAnswerCorrect(int questionNum, int answerNum, int newAnswerCorrect) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                newAnswer.ansCorrect = newAnswerCorrect;
            }
            catch (IndexOutOfBoundsException ex) {
                JQuizAnswerItem newAnswer = new JQuizAnswerItem();
                newAnswer.ansCorrect = newAnswerCorrect;
                newQuestion.questionAnswer.add(newAnswer);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public void setAnswerFeedback(int questionNum, int answerNum, String newAnswerFeedback) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                newAnswer.ansFeedback = newAnswerFeedback;
            }
            catch (IndexOutOfBoundsException ex) {
                JQuizAnswerItem newAnswer = new JQuizAnswerItem();
                newAnswer.ansFeedback = newAnswerFeedback;
                newQuestion.questionAnswer.add(newAnswer);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public void setAnswerIncludeMC(int questionNum, int answerNum, int newAnswerIncludeMC) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                newAnswer.includeMC = newAnswerIncludeMC;
            }
            catch (IndexOutOfBoundsException ex) {
                JQuizAnswerItem newAnswer = new JQuizAnswerItem();
                newAnswer.includeMC = newAnswerIncludeMC;
                newQuestion.questionAnswer.add(newAnswer);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public void setAnswerPercentCorrect(int questionNum, int answerNum, int newAnswerPercentCorrect) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                newAnswer.percentCorrect = newAnswerPercentCorrect;
            }
            catch (IndexOutOfBoundsException ex) {
                JQuizAnswerItem newAnswer = new JQuizAnswerItem();
                newAnswer.percentCorrect = newAnswerPercentCorrect;
                newQuestion.questionAnswer.add(newAnswer);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public void setAnswerText(int questionNum, int answerNum, String newAnswerText) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            try {
                JQuizAnswerItem newAnswer = (JQuizAnswerItem)newQuestion.questionAnswer.elementAt(answerNum);
                newAnswer.ansText = newAnswerText;
            }
            catch (IndexOutOfBoundsException ex) {
                JQuizAnswerItem newAnswer = new JQuizAnswerItem();
                newAnswer.ansText = newAnswerText;
                newQuestion.questionAnswer.add(newAnswer);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public void setCategory(int questionNum, String newCategory) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            newQuestion.category = newCategory;
        }
        catch (IndexOutOfBoundsException ex) {
            JQuizQuestionItem newQuestion = new JQuizQuestionItem();
            newQuestion.category = newCategory;
            this.al_ExItems.add(newQuestion);
        }
    }

    public void setClue(int questionNum, String newClue) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            newQuestion.clueText = newClue;
        }
        catch (IndexOutOfBoundsException ex) {
            JQuizQuestionItem newQuestion = new JQuizQuestionItem();
            newQuestion.clueText = newClue;
            this.al_ExItems.add(newQuestion);
        }
    }

    public void setFixed(int questionNum, int newFixed) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            newQuestion.fixed = newFixed;
        }
        catch (IndexOutOfBoundsException ex) {
            JQuizQuestionItem newQuestion = new JQuizQuestionItem();
            newQuestion.fixed = newFixed;
            this.al_ExItems.add(newQuestion);
        }
    }

    public void setQuestion(int questionNum, String newQuestionText) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            newQuestion.questionText = newQuestionText;
        }
        catch (IndexOutOfBoundsException ex) {
            JQuizQuestionItem newQuestion = new JQuizQuestionItem();
            newQuestion.questionText = newQuestionText;
            this.al_ExItems.add(newQuestion);
        }
        catch (NullPointerException np) {
            JQuizQuestionItem newQuestion = new JQuizQuestionItem();
            newQuestion.questionText = newQuestionText;
            this.al_ExItems.set(questionNum, newQuestion);
        }
    }

    public void setQuestionType(int questionNum, int newQuestionType) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            newQuestion.questionType = newQuestionType;
        }
        catch (IndexOutOfBoundsException ex) {
            JQuizQuestionItem newQuestion = new JQuizQuestionItem();
            newQuestion.questionType = newQuestionType;
            this.al_ExItems.add(newQuestion);
        }
    }

    public void setWeighting(int questionNum, int newWeighting) {
        try {
            JQuizQuestionItem newQuestion = (JQuizQuestionItem)this.al_ExItems.get(questionNum);
            newQuestion.weighting = newWeighting;
        }
        catch (IndexOutOfBoundsException ex) {
            JQuizQuestionItem newQuestion = new JQuizQuestionItem();
            newQuestion.weighting = newWeighting;
            this.al_ExItems.add(newQuestion);
        }
    }

    class JQuizSaxHandler
    implements ContentHandler {
        int acorrect = 0;
        String afeedback = "";
        boolean afterStartElement = true;
        int anum = 0;
        int apercentcorrect = 0;
        String atext = "";
        String charsBeingMade = "";
        boolean curNodeContainsText = false;
        int dataVersion = 6;
        int includeMC = 0;
        boolean nextNodeContainsFirstText = false;
        int num = 0;
        JQuizSaxModel temp_JQSMItem = new JQuizSaxModel();
        boolean withinAnswer = false;
        boolean withinAnswerCorrect = false;
        boolean withinAnswerFeedback = false;
        boolean withinAnswerIncludeMC = false;
        boolean withinAnswerPercentCorrect = false;
        boolean withinAnswerText = false;
        boolean withinAnswers = false;
        boolean withinExData = false;
        boolean withinQuestion = false;
        boolean withinQuestionCategory = false;
        boolean withinQuestionClue = false;
        boolean withinQuestionFixed = false;
        boolean withinQuestionRecord = false;
        boolean withinQuestionType = false;
        boolean withinQuestionWeighting = false;
        boolean withinQuestions = false;

        JQuizSaxHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.curNodeContainsText & this.afterStartElement) {
                String str_Temp = new String(ch, start, length);
                char int_Junk = str_Temp.charAt(0);
                if (int_Junk == '\n' && str_Temp.length() == 1) {
                    str_Temp = "";
                }
                this.charsBeingMade = this.charsBeingMade + str_Temp;
                str_Temp = "";
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("version")) {
                this.curNodeContainsText = false;
                this.dataVersion = Integer.parseInt(this.charsBeingMade.trim());
            }
            if (localName.equals("data")) {
                this.curNodeContainsText = false;
                this.withinExData = false;
            }
            if (localName.equals("questions")) {
                this.curNodeContainsText = false;
                this.withinQuestions = false;
            }
            if (localName.equals("question-record")) {
                this.withinQuestionRecord = false;
            }
            if (localName.equals("answers") || localName.equals("question-record") && this.dataVersion == 5) {
                this.withinAnswers = false;
            }
            if (localName.equals("answer")) {
                ++this.anum;
                this.withinAnswer = false;
            }
            if (this.withinQuestions && this.withinQuestionRecord) {
                int decnum = this.num - 1;
                if (this.withinQuestion) {
                    this.temp_JQSMItem.setQuestion(decnum, this.charsBeingMade.trim());
                    this.withinQuestion = false;
                } else if (this.withinQuestionClue) {
                    this.temp_JQSMItem.setClue(decnum, this.charsBeingMade.trim());
                    this.withinQuestionClue = false;
                } else if (this.withinQuestionCategory) {
                    this.temp_JQSMItem.setCategory(decnum, this.charsBeingMade.trim());
                    this.withinQuestionCategory = false;
                } else if (this.withinQuestionWeighting) {
                    this.temp_JQSMItem.setWeighting(decnum, Integer.parseInt(this.charsBeingMade));
                    this.withinQuestionWeighting = false;
                } else if (this.withinQuestionFixed) {
                    this.temp_JQSMItem.setFixed(decnum, Integer.parseInt(this.charsBeingMade));
                    this.withinQuestionFixed = false;
                } else if (this.withinQuestionType) {
                    this.temp_JQSMItem.setQuestionType(decnum, Integer.parseInt(this.charsBeingMade));
                    this.withinQuestionType = false;
                } else if (this.withinAnswers && this.withinAnswer) {
                    int decanum = this.num - 1;
                    if (localName.equals("text")) {
                        this.atext = this.charsBeingMade.trim();
                        this.temp_JQSMItem.setAnswerText(decanum, this.anum, this.atext);
                    } else if (localName.equals("feedback")) {
                        this.afeedback = this.charsBeingMade.trim();
                        this.temp_JQSMItem.setAnswerFeedback(decanum, this.anum, this.afeedback);
                    } else if (localName.equals("correct")) {
                        this.acorrect = Integer.parseInt(this.charsBeingMade);
                        this.temp_JQSMItem.setAnswerCorrect(decanum, this.anum, this.acorrect);
                        if (this.dataVersion == 5) {
                            if (this.acorrect == 1) {
                                this.temp_JQSMItem.setAnswerPercentCorrect(decanum, this.anum, 100);
                            } else {
                                this.temp_JQSMItem.setAnswerPercentCorrect(decanum, this.anum, 0);
                            }
                        }
                    } else if (localName.equals("percent-correct")) {
                        this.apercentcorrect = Integer.parseInt(this.charsBeingMade);
                        this.temp_JQSMItem.setAnswerPercentCorrect(decanum, this.anum, this.apercentcorrect);
                    } else if (localName.equals("include-in-mc-options")) {
                        this.includeMC = Integer.parseInt(this.charsBeingMade);
                        this.temp_JQSMItem.setAnswerIncludeMC(decanum, this.anum, this.includeMC);
                    }
                }
            }
            this.charsBeingMade = "";
            this.afterStartElement = false;
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("version")) {
                this.curNodeContainsText = true;
            }
            if (localName.equals("data")) {
                this.withinExData = true;
            }
            if (localName.equals("questions")) {
                this.num = 0;
                this.withinQuestions = true;
            }
            if (localName.equals("question-record")) {
                ++this.num;
                this.withinQuestionRecord = true;
                this.nextNodeContainsFirstText = true;
            }
            if (localName.equals("question")) {
                this.withinQuestion = true;
            }
            if (localName.equals("clue")) {
                this.withinQuestionClue = true;
            }
            if (localName.equals("category")) {
                this.withinQuestionCategory = true;
            }
            if (localName.equals("weighting")) {
                this.withinQuestionWeighting = true;
            }
            if (localName.equals("fixed")) {
                this.withinQuestionFixed = true;
            }
            if (localName.equals("question-type")) {
                this.withinQuestionType = true;
            }
            if (localName.equals("answers") || localName.equals("question-record") && this.dataVersion == 5) {
                this.anum = 0;
                this.withinAnswers = true;
            }
            if (localName.equals("answer")) {
                this.withinAnswer = true;
            }
            if (this.nextNodeContainsFirstText) {
                this.curNodeContainsText = true;
                this.nextNodeContainsFirstText = false;
            }
            this.afterStartElement = true;
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

