/*
 * Decompiled with CFR 0.152.
 */
package hotpotnetclient;

import hotpotnetclient.HpNetClientApp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class HotPotNetUpload
extends JDialog
implements ClipboardOwner {
    boolean b_PageToUploadSeparateJavaScript = false;
    boolean b_PageToUploadSubmits = false;
    JButton btn_UploadHelp;
    JButton btn_UploadOK;
    ButtonGroup btngrp_PageAccessSettings;
    JCheckBox cb_MergeResults;
    JComboBox cmbx_SelectHotPotNetClass;
    String crlf = "";
    GridBagConstraints gbc;
    HpNetClientApp hpNetClientApp;
    JLabel lbl_SelectHotPotNetClass;
    BoxLayout lom_HotPotNetUploadButtons;
    GridBagLayout lom_HotPotNetUploadMain;
    JPanel pnl_HotPotNetUploadButtons = new JPanel();
    JPanel pnl_HotPotNetUploadMain;
    JRadioButton rb_PageAccessProtected;
    JRadioButton rb_PageAccessPublic;
    String str_ExPageContents = "";
    String str_PageToUploadContents = "";
    String str_PageToUploadDescription = "";
    String str_PageToUploadFilename = "";
    String str_PageToUploadNextExURL = "";
    String str_PageToUploadPath = "";
    String str_PageToUploadTitle = "untitled page";

    HotPotNetUpload(HpNetClientApp hpNetClientApp_In) throws HeadlessException {
        this.lom_HotPotNetUploadButtons = new BoxLayout(this.pnl_HotPotNetUploadButtons, 0);
        this.pnl_HotPotNetUploadMain = new JPanel();
        this.lom_HotPotNetUploadMain = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.btngrp_PageAccessSettings = new ButtonGroup();
        this.hpNetClientApp = hpNetClientApp_In;
        this.initComponents();
        this.initLayout();
        this.initVars();
        this.setTitle("Upload to hotpotatoes.net");
        this.setSize(400, 300);
        this.setLocationRelativeTo(this.hpNetClientApp.dlg_Login);
    }

    String ExtractFileName(String str_PathIn) {
        int i = str_PathIn.lastIndexOf(System.getProperty("file.separator"));
        if (i < 0) {
            return str_PathIn;
        }
        return str_PathIn.substring(i, str_PathIn.length());
    }

    void btn_UploadHelpActionPerformed() {
        this.hpNetClientApp.dlgOwner.viewAbsolutePathOrURLInBrowser("http://help.hotpotatoes.info/teacher/1020.php");
    }

    void btn_UploadOKActionPerformed() {
        this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Uploading exercise to hotpotatoes.net");
        this.hpNetClientApp.dlg_Status.setVisible(true);
        String str_ExerciseToUpload = this.prepareFileToUpload();
        System.out.println("");
        System.out.println(str_ExerciseToUpload);
        System.out.println("");
        this.setVisible(false);
        if (str_ExerciseToUpload.length() <= 0) {
            this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("");
            this.hpNetClientApp.dlg_Status.setVisible(false);
            JOptionPane.showMessageDialog(this, "No Exercise to upload. Upload stopped. ", "No Exercise to Upload Error", 0);
            this.hpNetClientApp.dlg_Login.btn_HotPotNetLoginLogoutActionPerformed();
        }
        this.setVisible(false);
        this.hpNetClientApp.dlg_Login.setVisible(true);
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
            catch (Exception ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
        return result;
    }

    void initComponents() {
        this.lbl_SelectHotPotNetClass = new JLabel();
        this.lbl_SelectHotPotNetClass.setName("lbl-select-hot-hot-net-class");
        this.lbl_SelectHotPotNetClass.setText("Select the class or group to view this page");
        this.cmbx_SelectHotPotNetClass = new JComboBox();
        this.cmbx_SelectHotPotNetClass.setEditable(false);
        this.cmbx_SelectHotPotNetClass.addItem("no classes available");
        this.rb_PageAccessPublic = new JRadioButton();
        this.rb_PageAccessPublic.setName("rb-page-access-public");
        this.rb_PageAccessPublic.setText("Make page public");
        this.rb_PageAccessProtected = new JRadioButton();
        this.rb_PageAccessProtected.setName("rb-page-access-protected");
        this.rb_PageAccessProtected.setText("Password-protect page");
        this.btngrp_PageAccessSettings.add(this.rb_PageAccessPublic);
        this.btngrp_PageAccessSettings.add(this.rb_PageAccessProtected);
        this.rb_PageAccessPublic.setSelected(true);
        this.cb_MergeResults = new JCheckBox();
        this.cb_MergeResults.setName("cb-merge-results");
        this.cb_MergeResults.setText("Merge previous results for same exercise title");
        this.cb_MergeResults.setEnabled(false);
        this.btn_UploadOK = new JButton();
        this.btn_UploadOK.setName("btn-upload-ok");
        this.btn_UploadOK.setText("OK");
        this.btn_UploadOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetUpload.this.btn_UploadOKActionPerformed();
            }
        });
        this.btn_UploadHelp = new JButton();
        this.btn_UploadHelp.setName("btn-upload-help");
        this.btn_UploadHelp.setText("Help");
        this.btn_UploadHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HotPotNetUpload.this.btn_UploadHelpActionPerformed();
            }
        });
    }

    void initLayout() {
        this.pnl_HotPotNetUploadMain.setLayout(this.lom_HotPotNetUploadMain);
        this.gbc.insets = new Insets(1, 2, 1, 2);
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.pnl_HotPotNetUploadMain.add((Component)this.lbl_SelectHotPotNetClass, this.gbc);
        ++this.gbc.gridy;
        this.pnl_HotPotNetUploadMain.add((Component)this.cmbx_SelectHotPotNetClass, this.gbc);
        ++this.gbc.gridy;
        this.pnl_HotPotNetUploadMain.add(Box.createVerticalStrut(5), this.gbc);
        ++this.gbc.gridy;
        this.pnl_HotPotNetUploadMain.add((Component)this.rb_PageAccessPublic, this.gbc);
        ++this.gbc.gridy;
        this.pnl_HotPotNetUploadMain.add((Component)this.rb_PageAccessProtected, this.gbc);
        ++this.gbc.gridy;
        this.pnl_HotPotNetUploadMain.add(Box.createVerticalStrut(5), this.gbc);
        ++this.gbc.gridy;
        this.pnl_HotPotNetUploadMain.add((Component)this.cb_MergeResults, this.gbc);
        this.pnl_HotPotNetUploadButtons.setLayout(this.lom_HotPotNetUploadButtons);
        this.pnl_HotPotNetUploadButtons.add(Box.createHorizontalGlue());
        this.pnl_HotPotNetUploadButtons.add(this.btn_UploadOK);
        this.pnl_HotPotNetUploadButtons.add(this.btn_UploadHelp);
        this.pnl_HotPotNetUploadButtons.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)this.pnl_HotPotNetUploadMain, "Center");
        this.getContentPane().add((Component)this.pnl_HotPotNetUploadButtons, "South");
    }

    void initVars() {
        this.crlf = this.hpNetClientApp.dlgOwner.regSaxModel.crlf;
    }

    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    String prepareFileToUpload() {
        StringBuffer sb_Out = new StringBuffer();
        this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Uploading Exercise");
        this.hpNetClientApp.dlg_Status.setVisible(true);
        int int_AssetCount = this.hpNetClientApp.dlg_Login.v_AssetsToUpload.size();
        this.str_ExPageContents = this.hpNetClientApp.dlg_Login.str_ExPageContents;
        sb_Out.append("<xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        sb_Out.append("<uploadexercise-request>");
        String str_DestClass = (String)this.cmbx_SelectHotPotNetClass.getSelectedItem();
        String str_PWProtect = "false";
        if (this.rb_PageAccessProtected.isSelected()) {
            str_PWProtect = "true";
        }
        sb_Out.append(this.tagElement(this.hpNetClientApp.dlgOwner.fullVersionInfo, "version"));
        String str_Temp = this.hpNetClientApp.dlgOwner.regSaxModel.getTextBetween(this.str_ExPageContents, "<title>", "</title>", false);
        str_Temp = this.hpNetClientApp.dlgOwner.regSaxModel.stripTags(str_Temp);
        str_Temp = this.hpNetClientApp.dlgOwner.regSaxModel.makeXHtmlSafe(str_Temp);
        str_Temp.trim();
        if (str_Temp.length() == 0) {
            str_Temp = "Untitled";
        }
        sb_Out.append(this.tagElement(str_Temp, "exercise-title") + this.crlf);
        sb_Out.append(this.tagElement("en", "language") + this.crlf);
        sb_Out.append(this.tagElement("6", "exportformat") + this.crlf);
        sb_Out.append(this.tagElement("Quiz", "description") + this.crlf);
        boolean submits = true;
        if (submits) {
            sb_Out.append(this.tagElement("true", "submits") + this.crlf);
        } else {
            sb_Out.append(this.tagElement("false", "submits") + this.crlf);
        }
        sb_Out.append(this.tagElement(str_DestClass, "class") + this.crlf);
        sb_Out.append(this.tagElement(str_PWProtect, "protect") + this.crlf);
        sb_Out.append(this.tagElement(this.hpNetClientApp.dlgOwner.potXmlTag, "potato") + this.crlf);
        sb_Out.append(this.tagElement(this.hpNetClientApp.f_ExerciseFile.getAbsolutePath(), "original-file-name") + this.crlf);
        sb_Out.append(this.tagElement(this.hpNetClientApp.str_NextExUrl, "nexturl") + this.crlf);
        int previousResults = 0;
        if (previousResults > 0 && this.cb_MergeResults.isSelected()) {
            sb_Out.append(this.tagElement("true", "keepresults") + this.crlf);
        } else {
            sb_Out.append(this.tagElement("false", "keepresults") + this.crlf);
        }
        sb_Out.append(this.hpNetClientApp.dlg_Login.str_AssetSummaryToUpload);
        if (int_AssetCount < 1) {
            sb_Out.append(this.tagElement("0", "noofassets") + this.crlf);
        } else {
            sb_Out.append(this.tagElement(Integer.toString(int_AssetCount), "noofassets") + this.crlf);
            sb_Out.append("<assetlist>");
            int i = 0;
            while (i < int_AssetCount) {
                sb_Out.append("<asset>");
                sb_Out.append(this.ExtractFileName(this.hpNetClientApp.dlg_Login.v_AssetsToUpload.get(i).toString()));
                sb_Out.append("</asset>");
                ++i;
            }
            sb_Out.append("</assetlist>" + this.crlf);
        }
        sb_Out.append(this.tagElement(this.str_ExPageContents, "exercise-content"));
        sb_Out.append("</uploadexercise-request>");
        return sb_Out.toString();
    }

    void receiveExerciseFromServer(String str_FromServer) {
        int int_resultCode = 0;
        try {
            int_resultCode = Integer.parseInt(this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<result-code>", "</result-code>", false));
        }
        catch (Exception e) {
            int_resultCode = 0;
        }
        String str_HotPotNetURL = this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<exerciseurl>", "</exerciseurl>", false);
        switch (int_resultCode) {
            case 0: {
                this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("");
                this.hpNetClientApp.dlg_Status.setVisible(false);
                JOptionPane.showMessageDialog(this, "Upload Exercise returned an unknown error. Upload stopped. " + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.getTextBetween(str_FromServer, "<response-message>", "</response-message>", false) + System.getProperty("line.separator") + this.hpNetClientApp.hpNetInOut.str_SessionID, "Upload Exercise Error", 0);
                break;
            }
            case 1: {
                JOptionPane.showMessageDialog(this, "Upload Exercise Successful. " + System.getProperty("line.separator") + "URL of exercise in hotpotatoes.net is " + System.getProperty("line.separator") + str_HotPotNetURL + System.getProperty("line.separator") + "URL has been copied to the clipboard", "Upload Exercise Successful", 1);
                this.setClipboardContents(str_HotPotNetURL);
                this.hpNetClientApp.dlg_Status.lbl_HotPotNetStatus.setText("Attempting to log off from hotpotatoes.net");
                this.hpNetClientApp.dlg_Status.setVisible(true);
                this.hpNetClientApp.dlg_Login.btn_HotPotNetLoginLogoutActionPerformed();
                this.setVisible(false);
            }
        }
    }

    public void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    String tagElement(String str_Contents, String str_Tag) {
        return "<" + str_Tag + ">" + str_Contents + "</" + str_Tag + ">";
    }

    void updateComboBox(Vector v_In) {
        this.cmbx_SelectHotPotNetClass.removeAllItems();
        int i = 0;
        while (i < v_In.size()) {
            this.cmbx_SelectHotPotNetClass.addItem(v_In.get(i));
            ++i;
        }
    }
}

