import xmlrpclib


class N4dClient:

    def __init__(self, url="https://localhost:9779"):

        self._client = xmlrpclib.ServerProxy(url)
        self._user = ""
        self._password = ""
        self._user_info = (self._user, self._password)

    def __dir__(self):
        ret = self._client.get_methods().strip().split("\n")
        tmp = []
        self._function_info = {}
        for item in ret:
            left = item.find("]")
            right = item.find(" :")
            tmp.append(item[left + 2:right])
        return tmp

    def  __getattr__(self, name):
        if name in ['trait_names', '_getAttributeNames']:
            return
        return getattr(self._client, name)


def change_server(ip):
    n4d._client = xmlrpclib.ServerProxy('https://' + ip + ':9779')


def change_user(user, password):
    n4d._user = user
    n4d._password = password

n4d = N4dClient()