import sys
import xmlrpclib
import getpass
import os.path
import shutil
class ocfs2nfs(object):
	def __init__(self):
		self.c = xmlrpclib.ServerProxy('https://localhost:9779')
	
	def get_local_user(self):
		self.local_user = raw_input("Introduce un usuario administrador: ")
		self.local_pass = getpass.getpass("Introduce el password del administrador: ")

	def get_remote_user(self):
		self.remote_user = raw_input("Introduce un usuario administrador remoto: ")
		self.remote_pass = getpass.getpass("Introduce el password del administrador remoto: ")


	def get_local_ip(self):
		self.local_server_ip = raw_input("Introduce la ip del servidor local: ")

	def connect_remote_server(self):
		self.remote_server_ip = raw_input("Introduce la ip del servidor remoto: ")
		self.r = xmlrpclib.ServerProxy('https://' +self.remote_server_ip + ':9779')

	def check_local_user(self):
		result = self.c.validate_user(self.local_user,self.local_pass) 
		return result[0]

	def check_remote_user(self):
		result = self.r.validate_user(self.remote_user,self.remote_pass) 
		return result[0]

	def get_interface_communicate_remote_server(self):
		self.external_iface = raw_input("La interfaz para realizar la comunicacion con el servidor remoto: ")

	def configure_ldap(self):
		try:
			user = (self.local_user,self.local_pass)
			self.c.reset_slapd(user,"SlapdManager")
			self.c.generate_ssl_certificates(user,"SlapdManager") 
			self.c.load_lliurex_schema(user,"SlapdManager") 
			self.c.enable_tls_communication(user,"SlapdManager",'/etc/ldap/ssl/slapd.cert','/etc/ldap/ssl/slapd.key')
			self.c.set_replicate_interface(user,'SlapdManager',self.external_iface)
			self.c.configure_simple_slapd(user,'SlapdManager')
			self.c.load_acl(user,"SlapdManager")
			self.c.open_ports_slapd(user,"SlapdManager",self.local_server_ip)
			self.c.reboot_slapd(user,"SlapdManager")

			remote_user = (self.remote_user,self.remote_pass)
			result = self.r.get_ldap_password(remote_user,'SlapdManager')
			if not result['status'] :
				raise Exception(result['msg'])
			ldap_password = result['msg']
			self.c.change_admin_passwd(user,"SlapdManager",ldap_password)
			self.c.enable_folders(user,"SlapdManager")
			aux_ldap_basedn = self.r.get_variable(remote_user,'VariablesManager','LDAP_BASE_DN')
			if aux_ldap_basedn == None:
				raise Exception('LDAP_BASE_DN is not defined on master server')
			self.c.add_rid_data_simple_sync(user,'SlapdManager','254',self.remote_server_ip,ldap_password,'cn=admin,' + str(aux_ldap_basedn),str(aux_ldap_basedn))
			self.c.add_updateref_data(user,'SlapdManager',self.remote_server_ip)
			self.c.set_master_server_ip(user,'SlapdManager',self.remote_server_ip)
			self.c.load_schema(user,'SambaManager')
			self.c.load_index(user,'SambaManager')
			self.c.reboot_slapd(user,"SlapdManager")
			print "La configuracion del LDAP se ha realizado correctamente"
		except Exception as e:
			print "Algo ha ido mal"
			print e.msg

	def configure_nfs(self):
		try:
			while True:
				self.nfs_share = raw_input("Introduce el punto a compartir por nfs: ")
				if os.path.exists(self.nfs_share):
					break
			f = open('/etc/exports','a')
			f.write(self.nfs_share+'\t*(rw,sync,no_root_squash)\n')
			f.close()
		except:
			import sys
			print ""
			print "Nfs no se ha configurado"
			sys.exit(0)

	def configure_nss(self):
		os.system("auth-client-config -t nss -p lac_ldap")

	def configure_ldap_conf_files(self):
		shutil.copyfile('/usr/share/ocfs2nfs/etc.ldap.conf','/etc/ldap.conf')
		shutil.copyfile('/usr/share/ocfs2nfs/etc.ldap.ldap.conf','/etc/ldap/ldap.conf')

x = ocfs2nfs()
while True:
	x.get_local_user()
	if x.check_local_user():
		break
	else:
		print "Usuario/password incorrecto"

x.connect_remote_server()
while True:
	x.get_remote_user()
	if x.check_remote_user():
		break
	else:
		print "Usuario/password incorrecto"

x.get_local_ip()
x.get_interface_communicate_remote_server()
x.configure_ldap_conf_files()
x.configure_nss()
x.configure_nfs()
x.configure_ldap()