/* Class definition*/
function ExportIsoManager(){
	var self = this;
	this.BindLoginEventHandlers = function(){
		$("#goback").bind('click',this.goback);
		$("#exportiso").bind('click',this.exportiso);
	}

	this.goback = function (event){
		window.location='main.html';
	}

	this.exportiso = function (){
		var isopath = $("#isopath").val();
		var name_iso = $("#isoname").val();

		if (name_iso === ""){
			console.log("Falta el nombre de la iso");
			$('#result').empty();
			var img = $(document.createElement('img')).attr('src','img/fail.png');
			//Añado los valores al identificador que me mostrara la respuesta por pantalla
			//Especificamos el tamaño de la imagen
			img.attr('style',"width: 15px; height: 15px; margin: 5px;");
			//añado a la variable text la respuesta de N4D
			var text =  document.createTextNode("You don't tell my the name to ISO");
			//Uno la imagen y el texto dentro del identificador de la web result
			$('#result').append(img);
			$('#result').append(text);
			return false;
		}

		$.xmlrpc({
				url: 'https://'+sessionStorage.server+':9779',
				methodName: 'export_iso',
				params: [[sessionStorage.username , sessionStorage.password],"OpenSysCloneExport",isopath, name_iso],
				success: function(response,status,jqXHR){
					$('#result').empty();
					// return 'False'
					// response[0] = False
					// return [False,[1,2,3,4]]
					// response[0] = [False,[1,2,3,4]]
					// response[0][0] = False
					// response[0][1] = [1,2,3,4]
					// response[0][1][0] = 1
					result=response[0][0];
					if (result)
						var img = $(document.createElement('img')).attr('src','img/ok.png');
					else
						var img = $(document.createElement('img')).attr('src','img/fail.png');
					img.attr('style',"width: 15px; height: 15px; margin: 5px;");
					var text = $(document.createElement('span')).html(response[0][1]);
					
					$('#result').append(img);
					$('#result').append(text);
				},
				error: function(jqXHR, status, error) {
					alert("Status: "+status+"\nError: N4d server is down"+error);
				}
			});


	}

}

$(document).ready(function() {
	var mim = new ExportIsoManager();
	mim.BindLoginEventHandlers();
});
