
import sys
import tempfile
import threading
import os
from jinja2 import Environment
from jinja2.loaders import FileSystemLoader


class OpenSysClone:

	# Templates variables
	TEMPLATES_PATH="/usr/share/n4d/templates/OpenSysClone/"
	SAVE_IMAGE_TPL="SaveImage.tpl"
	PXE_DESTINATION="/usr/share/lmd-server/www-boot/pxemenu.d/70-OpenSysClone.php"
	PATH_FILE="/net/OpenSysClone/"
	USER_PATH_FILE="imagenes"
	NAME_FILE="autoname"
	HDD_DISK="sda1"
	FINAL_ACTION="poweroff"
	MIN_CLIENTS = "8"
	MAX_WAIT = "100"
	UDP_PATH="/net/OpenSysClone/prueba"
	INTERFACE="eth0"
	HOST_OPERATION="hostnamesaver.sh"
	

	def __init__(self):
		pass
	#def init
	
	
	
	def write_menu_pxe(self, aux_save_image_tpl=SAVE_IMAGE_TPL, aux_user_path_file = USER_PATH_FILE, aux_name_file = NAME_FILE , aux_hdd_disk = HDD_DISK ,aux_final_action=FINAL_ACTION, aux_host_operation=HOST_OPERATION):
			
		try:	
			# save_path, name_file, hdd_disk, final_action
			environment_variables = {}
			aux_path_file=self.PATH_FILE+aux_user_path_file
			
			# Get the values from free server
			if  objects.has_key("VariablesManager"):
				environment_variables=objects["VariablesManager"].get_variable_list(["SRV_IP"])
				
			
			
			environment_variables["PATH_FILE"]=aux_path_file
			environment_variables["NAME_FILE"]=aux_name_file
			environment_variables["HDD_DISK"]=aux_hdd_disk
			environment_variables["FINAL_ACTION"]=aux_final_action
			environment_variables["HOST_OPERATION"]=aux_host_operation
			
			
			path_to_work=tempfile.mkdtemp()
			filename=path_to_work+"OpenSysClone.pxe"
			
			# Create temporal environment for jinja
			env = Environment(loader=FileSystemLoader(OpenSysClone.TEMPLATES_PATH))
			tmpl = env.get_template(aux_save_image_tpl)
			
			# Render the template with diferent values		
			textrendered=tmpl.render(environment_variables)
			
			#Create a temporal for nsswitch
			tmp,filename=tempfile.mkstemp()
			f = open(filename,'w')
			f.writelines(textrendered)
			f.close()
			
			# Using the ultimate chmod
			self.uchmod(filename,0644)
			
			# Copy unitaria
			shutil.copy(filename,OpenSysClone.PXE_DESTINATION)
			COMMENT_END = "PXE menu is prepared for your requirements with this file %s" %(OpenSysClone.PXE_DESTINATION)
			return [True,str(COMMENT_END)]
		
		except Exception as e:

			return [False,str(e)]	
	
	
	#def write_menu_pxe
	
	
	
	def del_menu_pxe(self, AUX_PXE_DESTINATION=PXE_DESTINATION):
		
		try:	
			# Remove obsolete file for PXE menu
			if os.path.isfile(AUX_PXE_DESTINATION):
				os.remove (AUX_PXE_DESTINATION)
				COMMENT_END = "Remove obsolete file %s for PXE menu" %(AUX_PXE_DESTINATION)
			
				return [True, str(COMMENT_END)]
			else:
				COMMENT_END = "PXE file was delete before"
				return [True, str(COMMENT_END)]
			
		except Exception as e:

				return [False,str(e)]
	#def del_menu_pxe
	
	
	
	def nfs_export_start (self, AUX_USER_PATH_FILE=USER_PATH_FILE):
		
		try:
			AUX_PATH_FILE=self.PATH_FILE+AUX_USER_PATH_FILE
			# Get the values from free server
			if  objects.has_key("VariablesManager"):
				INTERNAL_NETWORK_VARIABLES=objects["VariablesManager"].get_variable_list(["INTERNAL_NETWORK","INTERNAL_MASK"])
				
			#Export file to write or read OpenSysClone in the server to network range
			if os.path.dirname(AUX_PATH_FILE):
				os.system('exportfs -o rw,insecure,no_root_squash,async,no_subtree_check  %s/%s:%s'%(INTERNAL_NETWORK_VARIABLES["INTERNAL_NETWORK"],INTERNAL_NETWORK_VARIABLES["INTERNAL_MASK"],AUX_PATH_FILE))
				COMMENT_END = "NFS is sharing %s to my internal network %s/%s" %(AUX_PATH_FILE,INTERNAL_NETWORK_VARIABLES["INTERNAL_NETWORK"],INTERNAL_NETWORK_VARIABLES["INTERNAL_MASK"])
				return [True, str(COMMENT_END)]
			else:
				return [False,str(e)]
				
		except Exception as e:

			return [False,str(e)]
	#def nfs_export
	
	
	
	def nfs_export_stop (self,AUX_USER_PATH_FILE=USER_PATH_FILE):
	
			#Restart nfs service to restart default parameters and stop extra parameters
		
		#try:	
		#	os.system('service nfs-kernel-server restart')
		#	COMMENT_END = "The NFS system is restarted with defaults parameters and suprimed OpeSysClone shared parameters"
		#	return [True, str(COMMENT_END)]
			
		#except Exception as e:

		#	return [False,str(e)]	
		try:
			AUX_PATH_FILE=self.PATH_FILE+AUX_USER_PATH_FILE
			
			# Get the values from free server
			if  objects.has_key("VariablesManager"):
				INTERNAL_NETWORK_VARIABLES=objects["VariablesManager"].get_variable_list(["INTERNAL_NETWORK","INTERNAL_MASK"])
				
			
			#Cancel the export file to write or read OpenSysClone in the server to network range
			
			if os.path.dirname(AUX_PATH_FILE):
				os.system('exportfs -u  %s/%s:%s'%(INTERNAL_NETWORK_VARIABLES["INTERNAL_NETWORK"],INTERNAL_NETWORK_VARIABLES["INTERNAL_MASK"],AUX_PATH_FILE))
				COMMENT_END = "NFS is NOT SHARING %s to my internal network %s/%s" %(AUX_PATH_FILE,INTERNAL_NETWORK_VARIABLES["INTERNAL_NETWORK"],INTERNAL_NETWORK_VARIABLES["INTERNAL_MASK"])
				return [True, str(COMMENT_END)]
			else:
				return [False,str(e)]
				
		except Exception as e:

			return [False,str(e)]
		
		
	#def nfs_export_stop
	
	
	def uchmod(self,file,mode):
		
		try:
		#Method to change file attributes
		
			prevmask = os.umask(0)
			os.chmod(file,mode)
			os.umask(prevmask)
			
		except Exception as e:

			return [False,str(e)]	
	#def uchmod
	
	
	def aux_send_multicast_file (self, AUX_USER_PATH_FILE=USER_PATH_FILE, AUX_NAME_FILE=NAME_FILE, AUX_MIN_CLIENTS=MIN_CLIENTS, AUX_MAX_WAIT=MAX_WAIT,AUX_INTERFACE=INTERFACE,AUX_UDP_PATH=UDP_PATH):
	
			#Method to restart nfs service to restart default parameters and stop extra parameters
			AUX_PATH_FILE=self.PATH_FILE+AUX_USER_PATH_FILE
			os.system('killall udp-sender')
			os.system('cat %(AUX_UDP_PATH)s/*.gz.* | udp-sender --full-duplex --min-clients %(AUX_MIN_CLIENTS)s --max-wait %(AUX_MAX_WAIT)s --interface %(AUX_INTERFACE)s --nokbd --mcast-all-addr 224.0.0.1 --portbase 2232 --ttl 1' % locals ())
			
	#def aux_send_multicast_file
	
	
	def send_multicast_file (self, AUX_USER_PATH_FILE=USER_PATH_FILE, AUX_NAME_FILE=NAME_FILE, AUX_MIN_CLIENTS=MIN_CLIENTS, AUX_MAX_WAIT=MAX_WAIT):
		
			#Method to execute multiprocess
			
			try:
				AUX_PATH_FILE=self.PATH_FILE+AUX_USER_PATH_FILE
				# Get the values from free server
				if  objects.has_key("VariablesManager"):
					INTERFACE=objects["VariablesManager"].get_variable("INTERNAL_INTERFACE")
				
			
				#Get the UDP path to export in multicast mode
				UDP_PATH=AUX_PATH_FILE+"/"+AUX_NAME_FILE
				
				if os.path.exists(UDP_PATH):
				
					COMMENT_END = "UDP is in multicast mode for my internal network interface %s" %(INTERFACE)
				
					#Instructions to execute multiprocess
					t = threading.Thread(target=self.aux_send_multicast_file,args=(AUX_PATH_FILE,AUX_NAME_FILE,AUX_MIN_CLIENTS,AUX_MAX_WAIT,INTERFACE,UDP_PATH))
					t.daemon=True
					t.start()
					return [True, str(COMMENT_END)]
				else:
					COMMENT_END = "Your image don't exists in this directory"
					return [False,str(COMMENT_END)]
					
			except Exception as e:

				return [False,str(e)]
			
	#def send_multicast_file
	
	
	def list_img (self, AUX_USER_PATH_FILE=USER_PATH_FILE):
		
		#Method to list our ISOS in Server
		
		try:
			AUX_PATH_FILE=self.PATH_FILE+AUX_USER_PATH_FILE
			LIST_DIR=os.listdir(AUX_PATH_FILE)
		
			return [True,LIST_DIR]

		except Exception as e:

				return [False,str(e)]
				
	def check_path (self, AUX_USER_PATH_FILE=USER_PATH_FILE):
		
		#Method to make our dir to save images
		
		try:
			AUX_PATH_FILE=self.PATH_FILE+AUX_USER_PATH_FILE
			
			if os.path.exists(AUX_PATH_FILE):
				COMMENT_END = "Path file exists, do nothing"
				return [True, str(COMMENT_END)]
			else:
				os.makedirs(AUX_PATH_FILE,0777)
				os.chmod(AUX_PATH_FILE,0777)
				COMMENT_END = "Path file is created now %s" %(AUX_PATH_FILE)
				return [True, str(COMMENT_END)]			

		except Exception as e:

				return [False,str(e)]
				
				
	def del_image (self, DIR_FILE_DELETE):
		
		#Method to delete our save images
		
		try:
			AUX1_PATH_FILE=self.PATH_FILE+self.USER_PATH_FILE
			AUX_PATH_FILE=AUX1_PATH_FILE+"/"+DIR_FILE_DELETE
			
			if os.path.exists(AUX_PATH_FILE):
				os.system('rm -R  %s'%(AUX_PATH_FILE))
				COMMENT_END = "Path file is deleted %s" %(AUX_PATH_FILE)
				return [True, str(COMMENT_END)]
			else:
				COMMENT_END = "Path file isn't exists %s" %(AUX_PATH_FILE)
				return [True, str(COMMENT_END)]			

		except Exception as e:

				return [False,str(e)]
				
	#def list_img
	
	
	


	 
