#!/usr/bin/env python
import os
import sys
from jinja2 import Environment
from jinja2.loaders import FileSystemLoader
import tempfile
	
class OpenSysCloneExport: 
	
	def __init__(self):
		self.tftppath = '/var/lib/tftpboot/ltsp/OpenSysClone'
		self.export_options = 'ro,insecure,no_root_squash,async,no_subtree_check'
		self.templates_path="/usr/share/n4d/templates/OpenSysClone/"
		self.pxe_path = "/usr/share/lmd-server/www-boot/pxemenu.d/70-OpenSysClone.php"
	#def init

	def startup(self):
		pass
	#def startup

	def sanity_check(self):
		if not os.path.exists(self.tftppath):
			os.mkdir(self.tftppath)
	#def sanity_check

	def mount_iso(self,iso_path):
		if os.path.exists(iso_path) :
			self.sanity_check()
			result = os.system('mount -o loop %s %s'%(iso_path,self.tftppath))
			if result == 0 or result == 32 or result == 8192:
				return [True,'Mounted']
			else:
				return [False,'Mount failed']
		return [False,'path not exists']
	#def mount_iso

	def add_entry_exportfs(self):
		inetwork=objects["VariablesManager"].get_variable("INTERNAL_NETWORK")
		imask=objects["VariablesManager"].get_variable("INTERNAL_MASK")
		if inetwork == None or imask == None:
			return False
		result = os.system('exportfs -o %s %s/%s:%s'%(self.export_options,inetwork,imask,self.tftppath))
		if result == 0 :
			return [True,'Exported']
		else:
			return [False,'Export failed']
	#def add_entry_exportfs

	def del_entry_exportfs(self):
		inetwork=objects["VariablesManager"].get_variable("INTERNAL_NETWORK")
		imask=objects["VariablesManager"].get_variable("INTERNAL_MASK")
		if inetwork == None or imask == None:
			return [False,'Variables INTERNAL_NETWORK or INTERNAL_MASK not defined']
		result = os.system('exportfs -u %s/%s:%s'%(inetwork,imask,self.tftppath))
		if result == 0 :
			return [True,'Delete export entry']
		else:
			return [False,'Delete failed']
	#def del_entry_exportfs

	def write_pxe(self,name):
		try:	
			# save_path, name_file, hdd_disk, final_action
			environment_variables = {}
			
			# Get the values from free server
			environment_variables["SRV_IP"] = objects["VariablesManager"].get_variable("SRV_IP")
			environment_variables["NAME_ISO"] = name
			environment_variables["EXPORT_PATH"]= self.tftppath
			environment_variables["TFTP_PATH"] = os.path.join(self.tftppath,'casper','vmlinuz')
			environment_variables["VMLINUZ_PATH"]= os.path.join('OpenSysClone','casper','vmlinuz')
			environment_variables["INITRD_PATH"] = os.path.join('OpenSysClone','casper','initrd.lz')
			
			# Create temporal environment for jinja
			env = Environment(loader=FileSystemLoader(self.templates_path))
			tmpl = env.get_template('export-iso.tpl')
			
			# Render the template with diferent values		
			textrendered=tmpl.render(environment_variables)
			
			#Create a temporal for nsswitch
			tmp,filename=tempfile.mkstemp()
			f = open(filename,'w')
			f.writelines(textrendered)
			f.close()
			
			# Using the ultimate chmod
			self.uchmod(filename,0644)
			
			# Copy unitaria
			shutil.copy(filename,self.pxe_path)
			return [True,str(self.pxe_path)]
		
		except Exception as e:

			return [False,str(e)]
	#def write_pxe

	def uchmod(self,file,mode):
		
		try:
		#Method to change file attributes
		
			prevmask = os.umask(0)
			os.chmod(file,mode)
			os.umask(prevmask)
			
		except Exception as e:

			return [False,str(e)]	
	#def uchmod

	def export_iso(self,iso_path,name):
		result = self.mount_iso(iso_path)
		if not result[0]:
			return [False,result[1]]
		result = self.add_entry_exportfs()
		if not result[0]:
			return [False,result[1]]
		result = self.write_pxe(name)
		if not result[0]:
			return [False,result[1]]
		return [True,'Export iso correctly']
	
#class OpenCloneSysExport
