# -*- coding: latin-1 -*-
import sys
sys.path.append(sys.exec_prefix)

sltversion="4.0.10"

#Constantes que indican la plataforma
esLinux=False
esMac=False
miHOME='APPDATA'
pyLIB=sys.exec_prefix+"\\lib"
if sys.platform.lower().find('linux')>=0:
  esLinux=True
  miHOME='HOME'
  pyLIB=sys.exec_prefix+"/lib"

sys.path.append(pyLIB)

import os
# 1. Obtener srvPath
if esLinux:
	srvPath="/usr/share/salt-server"
else:
	srvPath=os.environ['PROGRAMFILES'] + "/salt4"
srvPath=os.path.abspath(srvPath)
srvPath2=os.path.abspath(os.environ[miHOME]+"/salt4") #alternativo

# 2. Obtener usrPath
usrPath=os.path.abspath(os.environ[miHOME]+"/.salt4")
try:
	if os.environ['USERNAME']=='root':
		usrPath=os.path.abspath("/root/.salt4")
except:
	pass
try:
	if os.environ['USER']=='root':
		usrPath=os.path.abspath("/root/.salt4")
except:
	pass

if not os.path.exists(usrPath):
  os.mkdir(usrPath)

# 3. Buscar archivo de configuracien
if not os.path.exists(os.path.abspath(srvPath+'/sltsrv.config')) and os.path.exists(os.path.abspath(srvPath2+'/sltsrv.config')):
  srvPath=srvPath2
  
# 4. Copiar config si es necesario
_config=os.path.abspath('/var/lib/salt/sltsrv.config')
if not os.path.exists(_config):
  _config=os.path.abspath(srvPath+'/sltsrv.config')
if os.path.exists(_config):
  if os.path.exists(os.path.abspath(usrPath+'/sltsrv.config')):
    fsrv=file(_config,'rb')
    fusr=file(os.path.abspath(usrPath+'/sltsrv.config'),'rb')
    cfgsrv=eval(fsrv.read())
    cfgusr=eval(fusr.read())
    fsrv.close()
    fusr.close()
    if not cfgsrv.has_key('entorn') or not cfgusr.has_key('entorn') or not cfgsrv['entorn'].has_key('sltinitime') or not cfgusr['entorn'].has_key('sltinitime') or cfgsrv['entorn']['sltinitime']!=cfgusr['entorn']['sltinitime']:
      import shutil
      shutil.copy(_config,os.path.abspath(usrPath+'/sltsrv.config'))
      try:
	for root,dirs, files in os.walk(usrPath):
	  for name in files:
	    if name[0:3]=='tmp':
	      os.remove(os.path.join(root,name))
      except:
	pass
  else:
    import shutil
    shutil.copy(_config,os.path.abspath(usrPath+'/sltsrv.config'))
    try:
	for root,dirs, files in os.walk(usrPath):
	  for name in files:
	    if name[0:3]=='tmp':
	      os.remove(os.path.join(root,name))
    except:
      pass
    
# Leer configuracion
f=file(os.path.abspath(usrPath+'/sltsrv.config'),'rb')
scfg=f.read()
f.close()
cfg=eval(scfg)
if cfg.has_key('entorn'):
  if cfg['entorn'].has_key('sltsrvpaths'):
    sys.path.extend(cfg['entorn']['sltsrvpaths'])
      
ooopath=sys.executable
bn=os.path.basename(ooopath)
ooopath=os.path.dirname(ooopath)
ooopathpy=""
while bn!="":
  if bn.lower()=="program":
    ooopath=os.path.abspath(ooopath+"/program")
    break
  elif bn.lower().find("python-")>-1:
    ooopathpy=os.path.abspath(ooopath+"/"+bn)
  bn=os.path.basename(ooopath)
  ooopath=os.path.dirname(ooopath)
if ooopathpy!="":
  sys.path.append(os.path.abspath(ooopathpy+"/lib"))
  sys.path.append(os.path.abspath(ooopathpy))
else:
  sys.path.append(os.path.abspath(ooopath+"/python-core-2.3.4/lib"))
  sys.path.append(os.path.abspath(ooopath+"/python-core-2.3.4"))
sys.path.append(ooopath)

import uno
try:
  import unohelper
except:
  pass
import socket
import codecs
# bsddb
import bsddb3 as bsddb
import platform

from com.sun.star.task import XJobExecutor

#Numero de lineas en lis ListBox
if esLinux:
  nitems=16
else:
  nitems=16 #20

def sltDate():
  #Fecha del addon
  try:
    _txt=__name__
  finally:
    return _txt
  if os.path.exists(os.path.abspath(__file__)):
    return time.localtime(os.stat(os.path.abspath(__file__))[8])
  else:
    return None

def uts(s):
  #Pasar cadena unicode a string
  i=0
  t=""
  while i<len(s):
    c=s[i]
    if ord(c)>255:
      c=quitarFF(c)
    t=t+chr(ord(c))
    i=i+1
  return t

def quitarFF(pal):
  #Eliminar caracteres unicode superiores a 255
  n=ord(pal)
  if n==8216 or n==8219 or n==8224:
    ret="'"
  elif n==8221:
    ret=chr(148)
  elif n==8220:
    ret=chr(147)
  elif n==8217:
    ret=chr(146)
  else:
    ret="_"
  return ret

def ucodeSiLinux(s):
  if esLinux:
    try:
      _s=unicode(s,'latin-1').encode('utf-8')
    except:
      _s=s
  else:
    _s=s
  return _s

def socketConnect():
  try:
    sck=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
    sck.connect(('localhost',20001))
  except:
    #iniciar server
    import os,time
    f=file(os.path.abspath(usrPath+'/sltsrv.config'),'rb')
    scfg=f.read()
    f.close()
    cfg=eval(scfg)
    if cfg.has_key('entorn'):
      if cfg['entorn'].has_key('sltsrvexe'):
	if cfg['entorn'].has_key('sltsrvpath'):
	  sltsrvpath=os.path.abspath(cfg['entorn']['sltsrvpath'])
	  os.chdir(sltsrvpath)
	if cfg['entorn'].has_key('sltsrvexe'):
	  sltsrvargs=cfg['entorn']['sltsrvexe']
	  sltsrvexe=os.path.abspath(sltsrvargs[0])
	if esLinux:
	  modo=os.P_NOWAIT
	else:
	  modo=os.P_DETACH
	os.spawnve(modo,sltsrvexe,sltsrvargs,os.environ)
	i=5
	while i>0:
	  try:
	    time.sleep(2)
	    sck.connect(('localhost',20001))
	  except:
	    i=i-1
	  else:
	    break
	if i<=0:
	  msg=MsgWindow('Cal iniciar el servidor Salt4')
	  sck=None
      else:
	msg=MsgWindow('Cal iniciar el servidor Salt4')
	sck=None
  return sck

class uooUNOext:
  #simular la clase uooUNOobj llamada desde sltooo_extern (test)
  def __init__(self, ctx):
    #component context
    self.ctx=ctx
    
  def action(self,args):
    smgr = self.ctx.ServiceManager
    import doooLib
    doooLib.getServiceManager(sMan=smgr)
    doooLib.getDesktop()
    
    # retrieve the desktop object
    desktop = smgr.createInstanceWithContext("com.sun.star.frame.Desktop", self.ctx )
    
    # get current document model
    model = desktop.getCurrentComponent()
    
    # access the document's text property
    #text = model.Text
    
    # create a cursor
    #cursor = text.createTextCursor()
    
    #Cursor
    vcursorsupplier=model.getCurrentController()
    vcursor=vcursorsupplier.getViewCursor()
    text=vcursor.getText()
    cur=text.createTextCursorByRange(vcursor.getStart())
    #Funcion a realizar
    if args=="dicc":
      oDic=DicSaltWindow(desktop)
      oDic.Load()
      oDic.Show("tren")
      oDic.Espera()
    elif args=="diccbil":
      oDic=DicBilWindow(desktop)
      oDic.Load()
      oDic.Espera()
    elif args=="sin":
      pass
    elif args=="verbs":
      oVerbs=VerbsWindow(desktop)
      oVerbs.Load()
      oVerbs.Espera()
    elif args=="info":
      oInfo=InfoWindow(desktop)
      oInfo.Espera()
    elif args=="mouse":
      ListenFields(model)
      Espera()    

# implement a UNO component by deriving from the standard unohelper.Base class
# and from the interface(s) you want to implement.
class uooUNOobj( unohelper.Base, XJobExecutor ):
  def __init__( self, ctx ):
    # store the component context for later use
    self.ctx = ctx

  def trigger( self, args ):
    # note: args[0] == "HelloWorld", see below config settings
    
    # retrieve the desktop object
    desktop = self.ctx.ServiceManager.createInstanceWithContext(
	    "com.sun.star.frame.Desktop", self.ctx )
    import doooLib
    doooLib.getServiceManager(sMan=self.ctx.ServiceManager)

    # get current document model
    model = desktop.getCurrentComponent()

    # access the document's text property
    #text = model.Text

    # create a cursor
    #cursor = text.createTextCursor()

    #Cursor
    vcursorsupplier=model.getCurrentController()
    vcursor=vcursorsupplier.getViewCursor()
    text=vcursor.getText()
    cur=text.createTextCursorByRange(vcursor.getStart())
    
    #Funcion a realizar
    if args=="dicc":
      oDic=DicSaltWindow(desktop)
      oDic.Load()
      #oDic.Espera()
    elif args=="diccbil":
      oDic=DicBilWindow(desktop)
      oDic.Load()
      #oDic.Espera()
    elif args=="sin":
      pass
    elif args=="verbs":
      oVerbs=VerbsWindow(desktop)
      oVerbs.Load()
      #oVerbs.Espera()
    elif args=="info":
      oInfo=InfoWindow(desktop)
      #oInfo.Espera()
    elif args=="mouse":
      ListenFields(model)
      Espera()    
class uooDoc:
  """ Documento para presentar informacion desde los utilities"""
  def __init__(self,desktop,ncolumns=0):
    self.pagini=True
    self.desktop=desktop
    self.doc=None
  
  def NewDoc(self,ncolumns=0):
    #Obtener un nuevo documentos (con o sin formato de columnas)
    self.pagini=True
    model=self.desktop.getCurrentComponent()
    text=model.Text
    cur=text.createTextCursor()
    cur.gotoEnd(1)
    if cur.String!="":
      #Documento en uso: obtener uno nuevo
      doc=self.desktop.loadComponentFromURL("private:factory/swriter","_blank",0,())
      text=doc.Text
      cur=text.createTextCursor()
      cur.gotoEnd(1)
    self.cursor=cur
    if ncolumns!=0:
      #Formato columnas
      oSect=model.createInstance("com.sun.star.text.TextSection")
      #oSect.setName("sltVerbs")
      oCols=model.createInstance("com.sun.star.text.TextColumns")
      oCols.setColumnCount(ncolumns)
      oSect.TextColumns=oCols
      text.insertTextContent(cur,oSect,True)
  
  def PrintDoc(self,fpath):
    #Presentar como documento el archivo cuyo path esta en fpath
    #Antes de abrir otro cerramos el anterior (si hay)
    if self.doc!=None:
      try:
	self.doc.close(True)
      except:
	pass
    url=self.ConvertToUrl(fpath)
    flags=uno.getConstantByName("com.sun.star.frame.FrameSearchFlag.CREATE")+uno.getConstantByName("com.sun.star.frame.FrameSearchFlag.ALL")
    self.doc=self.desktop.loadComponentFromURL(url,"Salt",flags,())

  def PrintLine(self,lin,bold=None,italic=None,font=None,size=None,color=None):
    #Mover linea al final del documento
    self.cursor.gotoEnd(0)
    self.cursor.String=lin
    if bold!=None:
      if bold==True:
	self.cursor.CharWeight=150
      else:
	self.cursor.CharWeight=100
    if italic!=None:
      if italic==True:
	self.cursor.CharPosture=2
      else:
	self.cursor.CharPosture=0
    if font!=None:
      self.cursor.CharFontName=font
    if size!=None:
      self.cursor.CharHeight=size
    if color!=None:
      self.cursor.CharColor=color

  def NewPage(self):
    #Sub InsertPageBreak( oCursor ) 
       #oText = oCursor.getText() 
       #oText.insertControlCharacter( oCursor, com.sun.star.text.ControlCharacter.PARAGRAPH_BREAK, False ) 
       #oCursor.BreakType = com.sun.star.style.BreakType.PAGE_BEFORE 
    #End Sub
    if not self.pagini:
      self.PrintLine("")
      text=self.cursor.getText()
      text.insertControlCharacter(self.cursor,uno.getConstantByName("com.sun.star.text.ControlCharacter.PARAGRAPH_BREAK"),0)
      self.cursor.BreakType=uno.getConstantByName("com.sun.star.style.BreakType.PAGE_BEFORE")
    self.pagini=False
    #self.cursor.BreakType=5
    #self.cursor.gotoEnd(0)
    #self.cursor.String='\n'

  def GotoEnd(self):
    #Dejar que se vea el final del documento
    vcur=self.desktop.getCurrentComponent().getCurrentController().getViewCursor()
    vcur.gotoEnd(0)
    
  def ConvertToUrl(self,fpath):
    #Convertir formato path a URL y devolver el valor convertido
    furl=fpath
    furl.replace("\\","/")
    furl="file:///"+furl
    return furl
		 
from doooWindowLib import DBListenerWindow 
import time

class dicWindow(DBListenerWindow):
  #Eventos
  def lbxLemas_clicked(self,oItemEvent):
    txt=self.getListBoxSelectedItem("lbxLemas")
    self.Show(txt)

  def txtConsulta_changed(self,oTextEvent):
    txt=self.NoAcc(uts(self.getEditText("txtConsulta")))
    self.Refresh(txt)
  
  def txtConsulta_keypressed(self,oKeyEvent):
    if oKeyEvent.KeyCode==1024 or oKeyEvent.KeyCode==1280:
      self.setFocus("lbxLemas")
      self.selectListBoxItemPos("lbxLemas",0,True)
      txt=self.getListBoxSelectedItem("lbxLemas")
      self.Show(txt)
  
  def scrLemas_changed(self,oAdjustmentEvent):
    self.Refresh(oAdjustmentEvent.Value)
    
  def cmbCancel_clicked( self, oActionEvent ): 
    """This is called when the Cancel button is clicked."""
    self.windowClose()

  def windowClosing(self,oActionEvent):
    pass
  
  def windowDeactivated(self,oActionEvent):
    pass
    #self.windowToFront()

  #Metodos
  def Espera(self):
    while not self.terminar:
	time.sleep(1)
	
  def Refresh(self,txt):
    #Presentar items en la lista a partir de txt
    self.removeListBoxItems("lbxLemas",0,self.getListBoxItemCount("lbxLemas"))
    if str(type(txt))=="<type 'unicode'>":
      txt=uts(txt)
    if str(type(txt))=="<type 'str'>":
      if txt.isdigit():
	ini=long(txt)
	if ini>len(self.llms):
	  ini=len(self.llms)
      elif txt=="":
	ini=0
      else:
	try:
	  (k,n)=self.bt.set_location(txt)
	  if k>=txt:
	    ini=eval(n)
	  else:
	    ini=len(self.llms)
	except:
	  ini=len(self.llms)
    else:
      ini=long(txt)
    i=ini
    while i<ini+nitems and i<len(self.llms):
      self.addListBoxItem("lbxLemas",self.llms[i])
      i=i+1
    self.setScrollBarScrollValue("scrLemas",ini)
  
  def NoAcc(self,s):
    #Devuelve la cadena solo con vocales sin acentuar
    s=s.replace('','a')
    s=s.replace('','a')
    s=s.replace('','e')
    s=s.replace('','e')
    s=s.replace('','i')
    s=s.replace('','i')
    s=s.replace('','o')
    s=s.replace('','o')
    s=s.replace('','u')
    s=s.replace('','u')
    s=s.replace('ll','ll')
    s=s.replace('','n')
    s=s.replace('','c')
    return s.lower()
  
# end of class dicWindow

class VerbsWindow(DBListenerWindow):
  def __init__(self,desktop):
    DBListenerWindow.__init__( self, u"Verbs" )
    self.addOptionButton( "optCas", 6, 10, 50, 16, u"Castell", itemListenerProc = self.optCas_clicked ) 
    self.addOptionButton( "optVal", 81, 10, 50, 16, u"Valenci", itemListenerProc = self.optVal_clicked ) 
    self.addEdit( "txtConsulta", 6, 30, 106, 16, "",textListenerProc=self.txtConsulta_changed,keyListenerProc=self.txtConsulta_keypressed )
    self.setEditEditable("txtConsulta",True)
    self.addListBox( "lbxInfs", 6, 55,106,220, bDropdown=False,itemListenerProc = self.lbxInfs_clicked )
    self.addScrollBar("scrInfs",113,55,20,220,bOrientation=1,adjustmentListenerProc=self.scrInfs_changed)
    self.addButton( "cmbCancel", 16, 350, 106, 22, "Cancel·lar", actionListenerProc = self.cmbCancel_clicked ) 

    wpos={'left':-1,'top':137,'width':166,'height':400}
    try:
      #if platform.system()=="Windows":
	#self.wp=bsddb.btopen(os.path.abspath(ooopath+"/sltwpos"))
	#if self.wp.has_key("verbswindow"):
	  #(k,p)=self.wp.set_location("verbswindow")
	  #wpos=eval(p)
      self.wp=bsddb.btopen(os.path.abspath(usrPath+"/sltwpos"))
      if self.wp.has_key("verbswindow"):
	(k,p)=self.wp.set_location("verbswindow")
	wpos=eval(p)
    finally:
      self.setWindowPosSize( wpos['left'], wpos['top'], 166, 400 )
      
    self.terminar=False
    self.lvbs=[]
    self.bt=bsddb.btopen(None)
    self.cv="v" #verbos castellanos(c) o valencianos(v)
    self.setOptionButtonState("optVal",True)

    self.desktop=desktop
    self.doc=uooDoc(desktop)
    self.doc.NewDoc(3)
    
    #self.sck=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
    #self.sck.connect(('localhost',20001))
    self.sck=socketConnect()
    if self.sck==None:
      self.windowClose()
    self.setFocus("txtConsulta")

  #Eventos
  def optCas_clicked(self,oItemEvent):
    self.cv="c"
    self.Load()
  
  def optVal_clicked(self,oItemEvent):
    self.cv="v"
    self.Load()

  def lbxInfs_clicked(self,oItemEvent):
    txt=self.getListBoxSelectedItem("lbxInfs")
    self.Show(txt)

  def txtConsulta_changed(self,oTextEvent):
    txt=self.NoAcc(uts(self.getEditText("txtConsulta")))
    self.Refresh(txt)
  
  def txtConsulta_keypressed(self,oKeyEvent):
    if oKeyEvent.KeyCode==1024 or oKeyEvent.KeyCode==1280:
      self.setFocus("lbxInfs")
      self.selectListBoxItemPos("lbxInfs",0,True)
      txt=self.getListBoxSelectedItem("lbxInfs")
      self.Show(txt)
  
  def scrInfs_changed(self,oAdjustmentEvent):
    self.Refresh(oAdjustmentEvent.Value)
    
  def cmbCancel_clicked( self, oActionEvent ): 
    """This is called when the Cancel button is clicked."""
    self.windowClose()

  def windowClosed(self,oActionEvent):
    self.terminar=True
    self.sck.close()
    #if platform.system()=="Windows":
    rect=self.getWindowPosSize()
    self.wp["verbswindow"]=str({'left':rect.X,'top':rect.Y,'width':rect.Width,'height':rect.Height})
    self.wp.sync()
    self.wp.close()

  def windowClosing(self,oActionEvent):
    pass
  def windowDeactivated(self,oActionEvent):
    pass
    #self.windowToFront()

  #Metodos
  def Espera(self):
    while not self.terminar:
	time.sleep(1)
	
  def Load(self):
    #Cargar lista de infinitivos
    i=0
    tmp=""
    self.lvbs=[]
    self.bt.close()
    self.bt=bsddb.btopen(None)
    self.setEditText("txtConsulta","")
    #Cargar lista de verbos
    datos=str(('verbs',('_lista',self.cv,usrPath)))
    self.sck.send(datos)
    datos=self.sck.recv(200000)
    comando,(inf,cv,tmp)=eval(datos)
    f=file(tmp,'r+b')
    self.lvbs=eval(f.read())
    f.close()
    for i in range(len(self.lvbs)):
      k=ucodeSiLinux(self.lvbs[i])
      self.bt[self.NoAcc(k)]=str(i)
      if k!=self.lvbs[i]:
	self.lvbs[i]=k
    self.setScrollBarScrollValueMax("scrInfs",i)
    self.Refresh(0)
    self.windowToFront()
    
  def Refresh(self,txt):
    #Presentar items en la lista a partir de txt
    self.removeListBoxItems("lbxInfs",0,self.getListBoxItemCount("lbxInfs"))
    if str(type(txt))=="<type 'unicode'>":
      txt=uts(txt)
    if str(type(txt))=="<type 'str'>":
      if txt.isdigit():
	ini=long(txt)
	if ini>len(self.lvbs):
	  ini=len(self.lvbs)
      elif txt=="":
	ini=0
      else:
	try:
	  (k,n)=self.bt.set_location(txt)
	  if k>=txt:
	    ini=eval(n)
	  else:
	    ini=len(self.lvbs)
	except:
	  ini=len(self.lvbs)
    else:
      ini=long(txt)
    i=ini
    while i<ini+nitems and i<len(self.lvbs):
      self.addListBoxItem("lbxInfs",self.lvbs[i])
      i=i+1
    self.setScrollBarScrollValue("scrInfs",ini)
    
  def Show(self,inf):
    #Presentar sobre un documento el verbo inf
    lconj=[]
    datos=str(('verbs',(inf,self.cv,lconj)))
    self.sck.send(datos)
    datos=self.sck.recv(200000)
    comando,(inf,cv,lconj)=eval(datos)

    self.doc.NewPage()
    self.doc.PrintLine(ucodeSiLinux(inf),bold=True,size=16)
    for lin in lconj:
      if str(type(lin))=="<type 'list'>":
	for llin in lin:
	  self.doc.PrintLine(ucodeSiLinux(llin)+'\n',bold=False,size=12)
      elif self.NoAcc(lin.split()[0]).isupper():
	self.doc.PrintLine('\n'+ucodeSiLinux(lin)+'\n',bold=True,size=14)
      elif self.NoAcc(lin.split()[0]).istitle():
	self.doc.PrintLine(ucodeSiLinux(lin)+'\n',bold=True,size=12)
    self.windowToFront()
    #Para que se vea el final
    self.doc.GotoEnd()

  def NoAcc(self,s):
    #Devuelve la cadena solo con vocales sin acentuar
    s=s.replace('','a')
    s=s.replace('','a')
    s=s.replace('','e')
    s=s.replace('','e')
    s=s.replace('','i')
    s=s.replace('','i')
    s=s.replace('','o')
    s=s.replace('','o')
    s=s.replace('','u')
    s=s.replace('','u')
    s=s.replace('l','l')
    s=s.replace('','n')
    s=s.replace('','c')
    return s
# end of class VerbsWindow

class DicSaltWindow(DBListenerWindow):
  def __init__(self,desktop):
    DBListenerWindow.__init__( self, "D. Salt" )
    self.addOptionButton( "optDir", 6, 10, 80, 16, "Directe", itemListenerProc = self.optDir_clicked ) 
    self.addOptionButton( "optInv", 81, 10, 80, 16, "Invers", itemListenerProc = self.optInv_clicked ) 
    self.addEdit( "txtConsulta", 6, 30, 200, 16, "",textListenerProc=self.txtConsulta_changed,keyListenerProc=self.txtConsulta_keypressed )
    self.setEditEditable("txtConsulta",True)
    self.addListBox( "lbxLemas", 6, 55,200,220, bDropdown=False,itemListenerProc = self.lbxLemas_clicked )
    self.addScrollBar("scrLemas",113,55,20,221,bOrientation=1,adjustmentListenerProc=self.scrLemas_changed)
    self.addButton( "cmbCancel", 16, 350, 125, 22, "Cancel·la", actionListenerProc = self.cmbCancel_clicked ) 
    
    wpos={'left':-1,'top':137,'width':250,'height':400}
    try:
      #if platform.system()=="Windows":
	#self.wp=bsddb.btopen(os.path.abspath(ooopath+"/sltwpos"))
	#if self.wp.has_key("dicsaltwindow"):
	  #(k,p)=self.wp.set_location("dicsaltwindow")
	  #wpos=eval(p)
      self.wp=bsddb.btopen(os.path.abspath(usrPath+"/sltwpos"))
      if self.wp.has_key("dicsaltwindow"):
	(k,p)=self.wp.set_location("dicsaltwindow")
	wpos=eval(p)
    finally:
      self.setWindowPosSize( wpos['left'], wpos['top'], 250, 400 )
      
    self.terminar=False
    self.llms=[]
    self.bt=bsddb.btopen(None)
    self.tl="lema" #tipo de lista (lema, amel)
    self.setOptionButtonState("optDir",True)

    self.desktop=desktop
    self.doc=uooDoc(desktop)
    
    #self.sck=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
    #self.sck.connect(('localhost',20001))
    self.sck=socketConnect()
    if self.sck==None:
      self.windowClose()
    self.setFocus("txtConsulta")

  #Eventos
  def optDir_clicked(self,oItemEvent):
    self.tl="lema"
    self.Load()
  
  def optInv_clicked(self,oItemEvent):
    self.tl="amel"
    self.Load()

  def lbxLemas_clicked(self,oItemEvent):
    txt=self.getListBoxSelectedItem("lbxLemas")
    self.Show(txt)

  def txtConsulta_changed(self,oTextEvent):
    txt=self.NoAcc(uts(self.getEditText("txtConsulta")))
    self.Refresh(txt)
  
  def txtConsulta_keypressed(self,oKeyEvent):
    if oKeyEvent.KeyCode==1024 or oKeyEvent.KeyCode==1280:
      self.setFocus("lbxLemas")
      self.selectListBoxItemPos("lbxLemas",0,True)
      txt=self.getListBoxSelectedItem("lbxLemas")
      self.Show(txt)
  
  def scrLemas_changed(self,oAdjustmentEvent):
    self.Refresh(oAdjustmentEvent.Value)
    
  def cmbCancel_clicked( self, oActionEvent ): 
    """This is called when the Cancel button is clicked."""
    self.windowClose()

  def windowClosed(self,oActionEvent):
    self.terminar=True
    self.sck.close()
    #if platform.system()=="Windows":
    rect=self.getWindowPosSize()
    self.wp["dicsaltwindow"]=str({'left':rect.X,'top':rect.Y,'width':rect.Width,'height':rect.Height})
    self.wp.sync()
    self.wp.close()

  def windowClosing(self,oActionEvent):
    pass
  def windowDeactivated(self,oActionEvent):
    pass
    #self.windowToFront()

  #Metodos
  def Espera(self):
    while not self.terminar:
	time.sleep(1)
	
  def Load(self):
    #Cargar lista de palabras
    i=0
    tmp=""
    self.llms=[]
    self.bt.close()
    self.bt=bsddb.btopen(None)
    self.setEditText("txtConsulta","")
    #Cargar lista de lemas
    datos=str(('dicsalt',('_lista',self.tl,usrPath)))
    self.sck.send(datos)
    datos=self.sck.recv(200000)
    comando,(lema,tl,tmp)=eval(datos)
    f=file(tmp,'r+b')
    self.llms=eval(f.read())
    f.close()
    for i in range(len(self.llms)):
      k=ucodeSiLinux(self.llms[i])
      self.bt[self.Invers(self.NoAcc(k))]=str(i)
      if k!=self.llms[i]:
	self.llms[i]=k
    self.setScrollBarScrollValueMax("scrLemas",i)
    self.Refresh(0)
    self.windowToFront()
    
  def Refresh(self,txt):
    #Presentar items en la lista a partir de txt
    self.removeListBoxItems("lbxLemas",0,self.getListBoxItemCount("lbxLemas"))
    if str(type(txt))=="<type 'unicode'>":
      txt=uts(txt)
    if str(type(txt))=="<type 'str'>":
      if txt.isdigit():
	ini=long(txt)
	if ini>len(self.llms):
	  ini=len(self.llms)
      elif txt=="":
	ini=0
      else:
	try:
	  txt=self.Invers(txt)
	  (k,n)=self.bt.set_location(txt)
	  if k>=txt:
	    ini=eval(n)
	  else:
	    ini=len(self.llms)
	except:
	  ini=len(self.llms)
    else:
      ini=long(txt)
    i=ini
    while i<ini+nitems and i<len(self.llms):
      self.addListBoxItem("lbxLemas",self.llms[i])
      i=i+1
    self.setScrollBarScrollValue("scrLemas",ini)
  
  def Show(self,lema):
    #Presentar sobre un documento la palabra lema
    tmp=""
    datos=str(('dicsalt',(lema,self.tl,usrPath)))
    self.sck.send(datos)
    datos=self.sck.recv(200000)
    comando,(lema,tl,tmp)=eval(datos)
    self.doc.PrintDoc(tmp)
    self.windowToFront()
  
  def NoAcc(self,s):
    #Devuelve la cadena slo con vocales sin acentuar
    s=s.replace('','a')
    s=s.replace('','a')
    s=s.replace('','e')
    s=s.replace('','e')
    s=s.replace('','i')
    s=s.replace('','i')
    s=s.replace('','o')
    s=s.replace('','o')
    s=s.replace('','u')
    s=s.replace('','u')
    s=s.replace('l','l')
    s=s.replace('','n')
    s=s.replace('','c')
    return s.lower()

  def Invers(self,s):
    #devuelve la cadena invertida o no segn el valor de self.tl
    rs=""
    if self.tl=="amel":
      for c in s:
	rs=c+rs
    else:
      rs=s
    return rs
  
# end of class DicSaltWindow

class DicBilWindow(DBListenerWindow):
  def Llog(msg):
    f=open("/tmp/angel.log",'a')
    f.write(str(msg)+"\n")
    f.close()
  

  def __init__(self,desktop):
    #LOG
    f=open("/tmp/angel.log",'a')
    f.write("[DicBilWindow] Init!\n")
    f.close()
    
    DBListenerWindow.__init__( self, u"D. bil" )
    self.addOptionButton( "optCV", 6, 10, 50, 16, u"Cas>Val", itemListenerProc = self.optCV_clicked ) 
    self.addOptionButton( "optVC", 81, 10, 50, 16, u"Val>Cas", itemListenerProc = self.optVC_clicked ) 
    self.addEdit( "txtConsulta", 6, 30, 106, 16, "",textListenerProc=self.txtConsulta_changed,keyListenerProc=self.txtConsulta_keypressed )
    self.setEditEditable("txtConsulta",True)
    self.addListBox( "lbxLemas", 6, 55,106,220, bDropdown=False,itemListenerProc = self.lbxLemas_clicked )
    self.addScrollBar("scrLemas",113,55,20,220,bOrientation=1,adjustmentListenerProc=self.scrLemas_changed)
    self.addButton( "cmbCancel", 16, 350, 106, 22, "Cancel·la", actionListenerProc = self.cmbCancel_clicked ) 

    wpos={'left':-1,'top':137,'width':166,'height':400}
    try:
      self.wp=bsddb.btopen(os.path.abspath(usrPath+"/sltwpos"))
      if self.wp.has_key("dicbilwindow"):
	(k,p)=self.wp.set_location("dicbilwindow")
	wpos=eval(p)
    finally:
      self.setWindowPosSize( wpos['left'], wpos['top'], 166, 400 )
      
    self.terminar=False
    self.llms=[]
    self.bt=bsddb.btopen(None)
    self.tl="cv" #tipo de lista (cv, vc)
    self.setOptionButtonState("optCV",True)
    self.setWindowTitle(u"C > V")

    self.desktop=desktop
    self.doc=uooDoc(desktop)
    
    #self.sck=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
    #self.sck.connect(('localhost',20001))
    self.sck=socketConnect()
    if self.sck==None:
      self.windowClose()
    self.setFocus("txtConsulta")
    
  #Eventos
  def optCV_clicked(self,oItemEvent):
    self.setWindowTitle(u"C > V")
    self.tl="cv"
    self.Load()
  
  def optVC_clicked(self,oItemEvent):
    self.setWindowTitle(u"V > C")
    self.tl="vc"
    self.Load()

  def lbxLemas_clicked(self,oItemEvent):
    txt=self.getListBoxSelectedItem("lbxLemas")
    self.Show(txt)

  def txtConsulta_changed(self,oTextEvent):
    txt=self.NoAcc(uts(self.getEditText("txtConsulta")))
    self.Refresh(txt)
  
  def txtConsulta_keypressed(self,oKeyEvent):
    if oKeyEvent.KeyCode==1024 or oKeyEvent.KeyCode==1280:
      self.setFocus("lbxLemas")
      self.selectListBoxItemPos("lbxLemas",0,True)
      txt=self.getListBoxSelectedItem("lbxLemas")
      self.Show(txt)
  
  def scrLemas_changed(self,oAdjustmentEvent):
    self.Refresh(oAdjustmentEvent.Value)
    
  def cmbCancel_clicked( self, oActionEvent ): 
    """This is called when the Cancel button is clicked."""
    self.windowClose()

  def windowClosed(self,oActionEvent):
    self.terminar=True
    self.sck.close()
    #if platform.system()=="Windows":
    rect=self.getWindowPosSize()
    self.wp["dicbilwindow"]=str({'left':rect.X,'top':rect.Y,'width':rect.Width,'height':rect.Height})
    self.wp.sync()
    self.wp.close()

  def windowClosing(self,oActionEvent):
    pass
  def windowDeactivated(self,oActionEvent):
    pass
    #self.windowToFront()

  #Metodos
  def Espera(self):
    while not self.terminar:
	time.sleep(1)
	
  def Load(self):
    #Cargar lista de palabras
    i=0
    tmp=""
    self.llms=[]
    self.bt.close()
    self.bt=bsddb.btopen(None)
    self.setEditText("txtConsulta","")
    #Cargar lista de lemas
    datos=str(('dicbil',('_lista',self.tl,usrPath)))
    self.sck.send(datos)
    datos=self.sck.recv(200000)
    comando,(lema,tl,tmp)=eval(datos)
    f=file(tmp,'r+b')
    self.llms=eval(f.read())
    f.close()
    for i in range(len(self.llms)):
      k=ucodeSiLinux(self.llms[i])
      self.bt[self.NoAcc(k)]=str(i)
      if k!=self.llms[i]:
	self.llms[i]=k
    self.setScrollBarScrollValueMax("scrLemas",i)
    self.Refresh(0)
    self.windowToFront()
    
  def Refresh(self,txt):
    #Presentar items en la lista a partir de txt
    self.removeListBoxItems("lbxLemas",0,self.getListBoxItemCount("lbxLemas"))
    if str(type(txt))=="<type 'unicode'>":
      txt=uts(txt)
    if str(type(txt))=="<type 'str'>":
      if txt.isdigit():
	ini=long(txt)
	if ini>len(self.llms):
	  ini=len(self.llms)
      elif txt=="":
	ini=0
      else:
	try:
	  (k,n)=self.bt.set_location(txt)
	  if k>=txt:
	    ini=eval(n)
	  else:
	    ini=len(self.llms)
	except:
	  ini=len(self.llms)
    else:
      ini=long(txt)
    i=ini
    while i<ini+nitems and i<len(self.llms):
      self.addListBoxItem("lbxLemas",self.llms[i])
      i=i+1
    self.setScrollBarScrollValue("scrLemas",ini)
  
  def Show(self,lema):
    #Presentar sobre un documento la palabra lema
    tmp=""
    datos=str(('dicbil',(lema,self.tl,usrPath)))
    self.sck.send(datos)
    datos=self.sck.recv(200000)
    comando,(lema,tl,tmp)=eval(datos)
    self.doc.PrintDoc(tmp)
    self.windowToFront()
  
  def NoAcc(self,s):
    #Devuelve la cadena solo con vocales sin acentuar
    s=s.replace('','a')
    s=s.replace('','a')
    s=s.replace('','e')
    s=s.replace('','e')
    s=s.replace('','i')
    s=s.replace('','i')
    s=s.replace('','o')
    s=s.replace('','o')
    s=s.replace('','u')
    s=s.replace('','u')
    s=s.replace('l','l')
    s=s.replace('','n')
    s=s.replace('','c')
    return s.lower()
  
# end of class DicBilWindow

class InfoWindow(DBListenerWindow):
  def __init__(self,desktop):
    DBListenerWindow.__init__(self,u"Quant al Salt")
    self.setWindowPosSize(100,100,1130,750)
    self.addGroupBox("grpVersion",10,10,920,100,u"Version")
    self.addFixedText( "lblNombre", 30, 40, 150, 12, u"Salt 4.0" )
    self.addFixedText( "lblVersAddon", 40, 60, 300, 12, u"Addon" )
    self.addFixedText( "lblVersServer", 40, 80, 300, 12, u"Server" )
    self.addFixedText( "lblCopyright", 40, 100, 300, 12, u"Copyright: Generalitat Valenciana" )
    self.addGroupBox("grpCredits",10,140,920,440,u"Credits")
    self.addFixedText( "lblCredits", 30, 170, 900, 420, u"" )
    self.getControl("lblCredits").getModel().MultiLine=True
    self.getControl("lblCredits").getModel().Align=1 #centrado
    self.addButton( "cmbCancel", 420, 720, 106, 22, "Cancel·la", actionListenerProc = self.cmbCancel_clicked ) 

    wpos={'left':-1,'top':137,'width':1130,'height':750}
    try:
      self.wp=bsddb.btopen(os.path.abspath(usrPath+"/sltwpos"))
      if self.wp.has_key("infowindow"):
	(k,p)=self.wp.set_location("infowindow")
	wpos=eval(p)
    finally:
      self.setWindowPosSize( wpos['left'], wpos['top'], 1130, 750 )

    self.terminar=False

    #version del addon
    txt="Addon saltutil " + sltversion
    self.setFixedTextText("lblVersAddon",txt)

    #version del servidor
    self.sck=socketConnect()
    if self.sck==None:
      self.windowClose()
    else:
      #version
      datos=str(('vers',""))
      self.sck.send(datos)
      datos=self.sck.recv(200000)
      comando,txt=eval(datos)
      self.setFixedTextText("lblVersServer","Server "+txt)
      #Creditos
      datos=str(('credits',""))
      self.sck.send(datos)
      datos=self.sck.recv(200000)
      comando,lcred=eval(datos)
      txt=""
      for cred in lcred:
	if str(type(cred))=="<type 'list'>":
	  for s in cred:
	    txt=txt+s+", "
	  txt=txt[0:-2]+"\n\n"
	else:
	  txt=txt+cred+":\n"
      self.setFixedTextText("lblCredits",txt)
	    
  #Eventos
  def cmbCancel_clicked( self, oActionEvent ): 
    """This is called when the Cancel button is clicked."""
    self.windowClose()

  def windowClosed(self,oActionEvent):
    self.terminar=True
    self.sck.close()
    #if platform.system()=="Windows":
    rect=self.getWindowPosSize()
    self.wp["infowindow"]=str({'left':rect.X,'top':rect.Y,'width':rect.Width,'height':rect.Height})
    self.wp.sync()
    self.wp.close()

  def windowClosing(self,oActionEvent):
    pass

  #Metodos
  def Espera(self):
    while not self.terminar:
	time.sleep(1)
	
# end of class InfoWindow

class MsgWindow(DBListenerWindow):
  def __init__(self,msg):
    DBListenerWindow.__init__( self, u"Missatge del Salt")
    self.addFixedText("txtMsg",5,10,300,16,msg)
    self.setFixedTextAlignment("txtMsg",1)
    self.addButton( "cmbCancel", 310, 10, 60, 16, "Cancel·lar", actionListenerProc = self.cmbCancel_clicked ) 
    wpos={'left':100,'top':200,'width':460,'height':40}
    try:
      #if platform.system()=="Windows":
	#self.wp=bsddb.btopen(os.path.abspath(ooopath+"/sltwpos"))
	#if self.wp.has_key("msgwindow"):
	  #(k,p)=self.wp.set_location("msgwindow")
	  #wpos=eval(p)
      self.wp=bsddb.btopen(os.path.abspath(usrPath+"/sltwpos"))
      if self.wp.has_key("msgwindow"):
	(k,p)=self.wp.set_location("msgwindow")
	wpos=eval(p)
    finally:
      self.setWindowPosSize( wpos['left'], wpos['top'], 460, 40 )
    self.windowToFront()

  #Eventos
  def cmbCancel_clicked( self, oActionEvent ): 
    """This is called when the Cancel button is clicked."""
    self.windowClose()
    
  def windowClosed(self,oActionEvent):
    #if platform.system()=="Windows":
    rect=self.getWindowPosSize()
    self.wp["msgwindow"]=str({'left':rect.X,'top':rect.Y,'width':rect.Width,'height':rect.Height})
    self.wp.sync()
    self.wp.close()

# end of class MsgWindow

# pythonloader looks for a static g_ImplementationHelper variable
g_ImplementationHelper = unohelper.ImplementationHelper()
g_ImplementationHelper.addImplementation( \
		uooUNOobj,                        # UNO object class
		"org.openoffice.Office.addon.salt.util.uooUNOobj", # implementation name
											# Change this name for your own
							# script
		("com.sun.star.task.Job",),)          # list of implemented services
											# (the only service)
