#********************************************************************** 
# 
#   Danny.OOo.Listeners.ListenerProcAdapters.py 
# 
#   A module to easily work with OpenOffice.org. 
# 
#********************************************************************** 
#   Copyright (c) 2003-2004 Danny Brewer 
#   d29583@groovegarden.com 
# 
#   This library is free software; you can redistribute it and/or 
#   modify it under the terms of the GNU Lesser General Public 
#   License as published by the Free Software Foundation; either 
#   version 2.1 of the License, or (at your option) any later version. 
# 
#   This library is distributed in the hope that it will be useful, 
#   but WITHOUT ANY WARRANTY; without even the implied warranty of 
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
#   Lesser General Public License for more details. 
# 
#   You should have received a copy of the GNU Lesser General Public 
#   License along with this library; if not, write to the Free Software 
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
# 
#   See:  http://www.gnu.org/licenses/lgpl.html 
# 
#********************************************************************** 
#   If you make changes, please append to the change log below. 
# 
#   Change Log 
#   Danny Brewer         Revised 2004-06-05-01 
# 
#********************************************************************** 



# OOo's libraries 
import uno 
import unohelper 




#-------------------------------------------------- 
# An ActionListener adapter. 
# This object implements com.sun.star.awt.XActionListener. 
# When actionPerformed is called, this will call an arbitrary 
#  python procedure, passing it... 
#   1. the oActionEvent 
#   2. any other parameters you specified to this object's constructor (as a tuple). 
from com.sun.star.awt import XActionListener 
class ActionListenerProcAdapter( unohelper.Base, XActionListener ): 
    def __init__( self, oProcToCall, tParams=() ): 
        self.oProcToCall = oProcToCall # a python procedure 
        self.tParams = tParams # a tuple 

    # oActionEvent is a com.sun.star.awt.ActionEvent struct. 
    def actionPerformed( self, oActionEvent ): 
        if callable( self.oProcToCall ): 
            apply( self.oProcToCall, (oActionEvent,) + self.tParams ) 


#-------------------------------------------------- 
# An ItemListener adapter. 
# This object implements com.sun.star.awt.XItemListener. 
# When itemStateChanged is called, this will call an arbitrary 
#  python procedure, passing it... 
#   1. the oItemEvent 
#   2. any other parameters you specified to this object's constructor (as a tuple). 
from com.sun.star.awt import XItemListener 
class ItemListenerProcAdapter( unohelper.Base, XItemListener ): 
    def __init__( self, oProcToCall, tParams=() ): 
        self.oProcToCall = oProcToCall # a python procedure 
        self.tParams = tParams # a tuple 

    # oItemEvent is a com.sun.star.awt.ItemEvent struct. 
    def itemStateChanged( self, oItemEvent ): 
        if callable( self.oProcToCall ): 
            apply( self.oProcToCall, (oItemEvent,) + self.tParams ) 


#-------------------------------------------------- 
# An TextListener adapter. 
# This object implements com.sun.star.awt.XTextistener. 
# When textChanged is called, this will call an arbitrary 
#  python procedure, passing it... 
#   1. the oTextEvent 
#   2. any other parameters you specified to this object's constructor (as a tuple). 
from com.sun.star.awt import XTextListener 
class TextListenerProcAdapter( unohelper.Base, XTextListener ): 
    def __init__( self, oProcToCall, tParams=() ): 
        self.oProcToCall = oProcToCall # a python procedure 
        self.tParams = tParams # a tuple 

    # oTextEvent is a com.sun.star.awt.TextEvent struct. 
    def textChanged( self, oTextEvent ): 
        if callable( self.oProcToCall ): 
            apply( self.oProcToCall, (oTextEvent,) + self.tParams ) 

#-------------------------------------------------- 
# An Adjustament event adapter. 
# This object implements com.sun.star.awt.AdjustmentEvent. 
# When textChanged is called, this will call an arbitrary 
#  python procedure, passing it... 
#   1. the oTextEvent 
#   2. any other parameters you specified to this object's constructor (as a tuple). 
from com.sun.star.awt import XAdjustmentListener 
class AdjustmentListenerProcAdapter( unohelper.Base, XAdjustmentListener ): 
    def __init__( self, oProcToCall, tParams=() ): 
        self.oProcToCall = oProcToCall # a python procedure 
        self.tParams = tParams # a tuple 

    # oTextEvent is a com.sun.star.awt.TextEvent struct. 
    def adjustmentValueChanged( self, oAdjustmentEvent ): 
        if callable( self.oProcToCall ): 
            apply( self.oProcToCall, (oAdjustmentEvent,) + self.tParams ) 

#-------------------------------------------------- 
# An Key Listener event adapter. 
# This object implements com.sun.star.awt.XKeyListener. 
# When textChanged is called, this will call an arbitrary 
#  python procedure, passing it... 
#   1. the oTextEvent 
#   2. any other parameters you specified to this object's constructor (as a tuple). 
from com.sun.star.awt import XKeyListener 
class KeyListenerProcAdapter( unohelper.Base, XKeyListener ): 
    def __init__( self, oProcToCall, tParams=() ): 
        self.oProcToCall = oProcToCall # a python procedure 
        self.tParams = tParams # a tuple 

    # oKeyEvent is a com.sun.star.awt.KeyEvent struct. 
    def keyPressed( self, oKeyEvent ): 
        if callable( self.oProcToCall ): 
            apply( self.oProcToCall, (oKeyEvent,) + self.tParams ) 