# -*- coding: latin-1 -*-
# Created by Leo from: C:\Development\Python22\Lib\site-packages\vb2py\vb2py.leo
# -*- coding: latin-1 -*-

"""
Functions to mimic VB intrinsic functions or things
"""

from __future__ import generators

from vbclasses import *
from vbconstants import *
import math
import sys
import fnmatch # For Like
import glob    # For Dir
import os

# << Error classes >>
class VB2PYCodeError(Exception): """An error occured executing a vb2py function"""

class VB2PYNotSupported(VB2PYCodeError): """The requested function is not supported"""



class VB2PYFileError(VB2PYCodeError): """Some kind of file error"""
class VB2PYEndOfFile(VB2PYFileError): """Reached the end of file"""
# -- end -- << Error classes >>
# << VBFunctions >> (1 of 26)
class VBMissingArgument:
	"""A generic class to represent an argument omitted from a call"""

	_missing = 1
# << VBFunctions >> (2 of 26)
def vbForRange(start, stop, step=1):
	"""Mimic the range in a for statement

	VB's range is inclusive and can include non-integer elements so
	we use an generator. 

	"""
	num_repeats = (stop-start)/step
	if num_repeats < 0:
		raise StopIteration
	current = start
	while num_repeats >= 0:
		yield current
		current += step
		num_repeats -= 1
# << VBFunctions >> (3 of 26)
def vbObjectInitialize(size, objtype, preserve=None):
	"""Return a new object with the given size and type"""
	#
	# Create the object
	def getObj():
		if len(size) == 1:
			return objtype()
		else:
			return vbObjectInitialize(size[1:], objtype)
	ret = VBArray(size[0], getObj)
	#
	# Preserve the old values if needed
	if preserve is not None:
		preserve.__copyto__(ret)
	return ret
# << VBFunctions >> (4 of 26)
def Left(text, number):
	"""Return the left most characters in the text"""
	return text[:number]
# << VBFunctions >> (5 of 26)
def Right(text, number):
	"""Return the right most characters in the text"""
	return text[-number:]
# << VBFunctions >> (6 of 26)
def Mid(text, start, num=None):
	"""Return some characters from the text"""
	if num is None:
		return text[start-1:]
	else:
		return text[(start-1):(start+num-1)]
# << VBFunctions >> (7 of 26)
def Sgn(num):
	"""Return the sign of a number"""
	n = float(num)
	if n < 0:
		return -1
	elif n == 0:
		return 0
	else:
		return 1
# << VBFunctions >> (8 of 26)
def CBool(num):
	"""Return the boolean version of a number"""
	n = float(num)
	if n:
		return 1
	else:
		return 0
# << VBFunctions >> (9 of 26)
def Int(num):
	"""Return the int of a value"""
	n = float(num)
	if -32767 <= n <= 32767: 
		return int(n)
	else:
		raise ValueError("Out of range in Int (%s)" % n)

def CByte(num):
	"""Return the closest byte of a value"""
	n = round(float(num))
	if 0 <= n <= 255: 
		return int(n)
	else:
		raise ValueError("Out of range in CByte (%s)" % n)

def CInt(num):
	"""Return the closest int of a value"""
	n = round(float(num))
	if -32767 <= n <= 32767: 
		return int(n)
	else:
		raise ValueError("Out of range in Int (%s)" % n)

def CLng(num):
	"""Return the closest long of a value"""
	return long(round(float(num)))
# << VBFunctions >> (10 of 26)
def Sqr(num):
	"""Return the square root of a value"""
	return math.sqrt(float(num))

def Sin(num):
	"""Return the sin of a value"""
	return math.sin(float(num))

def Cos(num):
	"""Return the cosine of a value"""
	return math.cos(float(num))

def Tan(num):
	"""Return the tangent of a value"""
	return math.tan(float(num))

def Atn(num):
	"""Return the arc-tangent of a value"""
	return math.atan(float(num))
# << VBFunctions >> (11 of 26)
def Log(num):
	"""Return the log of a value"""
	return math.log(float(num))

def Exp(num):
	"""Return the log of a value"""
	return math.exp(float(num))
# << VBFunctions >> (12 of 26)
def Oct(num):
	"""Return the oct of a value"""
	n = CInt(num)
	if n == 0:
		return "0"
	else:
		return oct(n)[1:]
# << VBFunctions >> (13 of 26)
def Hex(num):
	"""Return the hex of a value"""
	return hex(CInt(num))[2:].upper()
# << VBFunctions >> (14 of 26)
def Instr(*args):
	"""Return the location of one string in another"""
	if len(args) == 2:
		text, subtext = args
		return text.find(subtext)+1
	else:
		start, text, subtext = args
		pos = text[start-1:].find(subtext)
		if pos == -1:
			return 0
		else:
			return pos + start
# << VBFunctions >> (15 of 26)
def Val(text):
	"""Return the value of a string

	This function finds the longest leftmost number in the string and
	returns it. If there are no valid numbers then it returns 0.

	The method chosen here is very poor - we just keep trying to convert the 
	string to a float and just use the last successful as we increase
	the size of the string. A Regular expression approach is probably 
	quicker.

	"""
	best = 0
	for idx in range(len(text)):
		try:
			best = float(text[:idx+1])
		except ValueError:
			pass
	return best
# << VBFunctions >> (16 of 26)
def IsNumeric(text):
	"""Return true if the string contains a valid number"""
	try:
		dummy = float(text)
	except ValueError:
		return 0
	else:
		return 1
# << VBFunctions >> (17 of 26)
def Like(text, pattern):
	"""Return true if the text matches the pattern

	The pattern is a string containing wildcards
		* = any string of characters
		? = any one character

	Fortunately, the fnmatch library module does this for us!

	"""
	return fnmatch.fnmatch(text, pattern)
# << VBFunctions >> (18 of 26)
def Seek(channel):
	"""Return the current 'cursor' position in the specified channel"""
	return VBFiles.getFile(Int(channel)).tell()+1 # VB starts at 1
# << VBFunctions >> (19 of 26)
_last_files = []

def Dir(path=None):
	"""Recursively return the contents of a path matching a certain pattern

	The complicating part here is that when you first call Dir it return the
	first file. Subsequent calls to Dir with no parameters return the other
	files. When all the files are exhausted, we return an empty string.

	Since we need to remember the original path we have to use a global variable
	which is a bit ugly.

	"""
	global _last_files
	if path:
		_last_files = glob.glob(path)
	if _last_files:
		return os.path.split(_last_files.pop(0))[1] # VB just returns the filename, not full path
	else:
		return ""
# << VBFunctions >> (20 of 26)
def Input(length, channelid):
	"""Return the given number of characters from the given channel"""
	return VBFiles.getChars(channelid, length)
# << VBFunctions >> (21 of 26)
def LCase(text):
	"""Return the lower case version of a string"""
	#return text.lower()
	#Modificado para adaptarlo a maysculas y minsculas latin-1
	i=0
	s=""
	while i<len(text):
		n=ord(text[i])
		if (n>=65 and n<=90) or (n>=192 and n<=214) or (n>=216 and n<=222):
			n=n+32
		s=s+chr(n)
		i=i+1
	return s

def UCase(text):
	"""Return the lower case version of a string"""
	#return text.upper()
	#Modificado para adaptarlo a maysculas y minsculas latin-1
	i=0
	s=""
	while i<len(text):
		n=ord(text[i])
		if (n>=97 and n<=122) or (n>=224 and n<=246) or (n>=248 and n<=254):
			n=n-32
		s=s+chr(n)
		i=i+1
	return s
# << VBFunctions >> (22 of 26)
def String(num=None, text=None):
	"""Return a repeated number of string items"""
	if num is None and text is None:
		return str()
	else:
		return text[:1]*CInt(num)

def Space(num):
	"""Return a repeated number of spaces"""
	return String(num, " ")
# << VBFunctions >> (23 of 26)
def Trim(text):
	"""Strip spaces from the text"""
	return text.strip()

def Ltrim(text):
	"""Strip spaces from the left of the text"""
	return text.lstrip()

def Rtrim(text):
	"""Strip spaces from the right of the text"""
	return text.rstrip()
# << VBFunctions >> (24 of 26)
def UBound(obj, dimension=1):
	"""Return the upper bound for the index"""
	try:
		return obj.__ubound__(dimension)
	except AttributeError:
		raise ValueError("UBound called for invalid object")


def LBound(obj, dimension=1):
	"""Return the lower bound for the index"""
	try:
		return obj.__lbound__(dimension)
	except AttributeError:
		raise ValueError("LBound called for invalid object")
# << VBFunctions >> (25 of 26)
def CreateObject(classname, ipaddress=None):
	"""Try to create an OLE object

	This only works on windows!

	"""
	if ipaddress:
		raise VB2PYNotSupported("DCOM not supported")
	import win32com.client
	return win32com.client.Dispatch(classname)
# << VBFunctions >> (26 of 26)
Abs = abs
Asc = AscB = AscW = ord
Chr = ChrB = ChrW = chr
Fix = Int
CStr = str
CSng = CDbl = float
Len = len
StrComp = cmp
Round = round

True = 1
False = 0

# << VB functions >> (27)
def IIf(cond,alt1,alt2):
	if cond == 0:
		#False
		return alt2
	else:
		#True
		return alt1
	
#
# Command line parameters are retrieved as a whole
Command = " ".join(sys.argv[1:])
# -- end -- << VBFunctions >>