#!/usr/bin/env python
# -*- coding: latin1 -*-

import sys
import os
import time
import stat
#'---------------------------------------------------------------------------
#'   Proceso de inicio: Variables de entorno y paths
#'---------------------------------------------------------------------------
def help():
  print 's: python sltsrv.py -pcarpeta -d[arxiu] -h'
  print '-pcarpeta: carpeta on estn les BDs'
  print '-d[arxiu]: lnies informatives a pantalla; si arxiu (opcional) a arxiu'
  print "-earxiu: lnies d'errors a arxiu"
  print "-i: instllar servidor"
  print "-nxxxxx: Port<>20001"
  print "-1: 1 thread"
  print "-portxxxxx: Port<>8080 en web service"
  cont=raw_input('continuar? (s/n)')
  if vbfunctions.LCase(cont)!='s':
    sys.exit()

class CfgFile:
  def __init__(self,file=None):
    import ConfigParser
    self.cfg=ConfigParser.ConfigParser()
    if file==None:
      miCfg=os.path.abspath('/etc/salt/salt.cfg')
      if not os.path.exists(miCfg):
        miCfg=os.path.dirname(os.path.abspath(__file__))
        if os.path.basename(miCfg)[-3:].lower()=='zip':
          miCfg=os.path.dirname(miCfg)
        miCfg=os.path.abspath(miCfg+"/salt.cfg")
    else:
      miCfg=file
    self.cfg.read(miCfg)
  
  def __call__(self,sec,opt):
    ret=None
    if self.cfg.has_option(sec,opt):
      ret=self.cfg.get(sec,opt)
      lret=ret.lower()
      if lret=="true" or lret=="s" or lret=="si" or lret=="1" or lret=="s":
        ret=True
      elif lret=="false" or lret=="no" or lret=="0" or lret=="n":
        ret=False
      elif ret.isdigit():
        ret=eval(ret)
    return ret

  def Existe(self,sec,opt):
    ret=False
    if self.cfg.has_option(sec,opt):
      if self.cfg.get(sec,opt) != "":
        ret=True
    return ret    

# End of Class CfgFile

_ini=CfgFile()

# Ports y multiproceso
port_ini=20002 #Primer port para subserver srv_b
port_fin=20010 #ltimo port para subserver
port_mio=20001 #Port por defecto
es_srv_a=True #es server principal si True
es_popen=True #conexin server-server va popen
lck=None
#Lista de ports de servidores y su estado
#El servidor inicial escucha por ('',port_ini)
#El estado es libre==True o libre==False (ocupado)
#port_lst=[[libre,port,nombre del Thread si no esta libre],...]
port_lst=[]

#Constantes que indican la plataforma
if sys.platform.lower().find('win32')>=0:
  miHOME="APPDATA"
  esLinux=False
  esMac=False
else:
  esMac=False
  esLinux=True
  miHOME="HOME"

#inst=false: no instalar archivo de configuracin
inst=_inst=False
#Debug (True/False; si True se imprime sobre stdout que se puede modificar)
dbg=False


#se puede cambiar la ruta y el debug en salt.cfg o en la lnea de comandos
_lincom_bds,_lincom_dbgdisc,_lincom_port,_lincom_cfg=None,None,None,None

if _ini.Existe("sltsrv","bdspath"):
  _lincom_bds=_ini("sltsrv","bdspath")
if _ini.Existe("sltsrv","port"):
  _lincom_port=_ini("sltsrv","port")
if _ini.Existe("sltsrv","cfgpath"):
  _lincom_cfg=_ini("sltsrv","cfgpath")
  
sltsrvexe=[]
for arg in sys.argv:
  if arg[0:2]=="-p":
    _lincom_bds=arg[2:]
    sltsrvexe.append(arg)
  elif arg[0:2]=="-d":
    if es_srv_a:
      dbg=True
      if arg[2:]!="":
        sys.stdout=open(arg[2:],'a')
  elif arg[0:2]=="-da":
    dbg=True
    if arg[2:]!="":
      sys.stdout=open(arg[2:],'a')
  elif arg[0:2]=="-e":
    if arg[2:]!="":
      sys.stderr=open(arg[2:],'a')
  elif arg[0:2]=="-t":
    _lincom_dbgdisc="/sltsrv.debug"
  elif arg[0:2]=="-i":
    _inst=True
    inst=True
  elif arg[0:2]=="-h":
    help()
  elif arg[0:2]=="-n":
    port_mio=eval(arg[2:])
    es_srv_a=False
  elif arg[0:2]=="-s":
    #Subserver conectado con popen
    es_srv_a=False
    es_popen=True
    dbg=False
  elif arg[0:5]=="-port":
    #Cambio de port
    _lincom_port=eval(arg[5:])
  elif arg[0:4]=="-cfg":
    #Cambio de la carpeta donde est el archivo sltsrv.config
    _lincom_cfg=arg[4:]
  else:
    sltsrvexe.append(arg)

#1. Entorno (paths de trabajo)
if esLinux:
  miPath=os.path.dirname(os.path.abspath(__file__))
  if os.path.basename(miPath)[-3:].lower()=='zip':
    miPath=os.path.dirname(miPath)
  srvPath="/usr/share/salt-server"
  bdsPath="/var/lib/salt-data"
  cfgPath=os.path.abspath("/var/lib/salt")
else:
  miPath=os.path.dirname(os.path.abspath(__file__))
  if os.path.basename(miPath)[-3:].lower()=='zip':
    miPath=os.path.dirname(miPath)
  srvPath=os.path.abspath(os.environ['PROGRAMFILES'] + "/salt4")
  bdsPath=miPath
  cfgPath=srvPath

srvPath2=os.path.abspath(os.environ[miHOME]+"/salt4") #alternativo
if not os.path.exists(cfgPath):
  os.mkdir(cfgPath)
#Asegurarnos de que tiene permisos
os.chmod(cfgPath,stat.S_IRUSR+stat.S_IWUSR+stat.S_IXUSR+stat.S_IRGRP+stat.S_IWGRP+stat.S_IXGRP+stat.S_IROTH+stat.S_IWOTH+stat.S_IXOTH)


#Modificaciones de la lnea de comandos
if _lincom_dbgdisc!=None:
  sys.stdout=open(os.path.abspath(cfgPath+_lincom_dbgdisc),'a')
  sys.stderr=open(os.path.abspath(cfgPath+_lincom_dbgdisc),'a')
if _lincom_bds!=None:
  bdsPath=_lincom_bds
if _lincom_cfg!=None:
  cfgPath=_lincom_cfg

# 2. Crear cfgPath (en Windows es igual que srvPath) y copiar sltsrv.config desde miPath
try:
  if not os.path.exists(cfgPath):
    os.mkdir(cfgPath)
    os.chmod(cfgPath,stat.S_IRUSR+stat.S_IWUSR+stat.S_IRGRP+stat.S_IWGRP+stat.S_IROTH+stat.S_IWOTH)
    inst=True
  _config=os.path.abspath(cfgPath+'/sltsrv.config')
  if inst or not os.path.exists(_config):
    #si no est lo copiamos (si es distinto)
    if os.path.exists(os.path.abspath(miPath+'/sltsrv.config')) and os.path.abspath(miPath+'/sltsrv.config').lower() != _config.lower():
      import shutil
      shutil.copy(os.path.abspath(miPath+'/sltsrv.config'),_config)
      inst=True
except:
  #Si hay un error probar a cambiar la ruta 
  srvPath=srvPath2
  cfgPath=srvPath
  if not os.path.exists(cfgPath):
    os.mkdir(cfgPath)
    os.chmod(cfgPath,stat.S_IRUSR+stat.S_IWUSR+stat.S_IRGRP+stat.S_IWGRP+stat.S_IROTH+stat.S_IWOTH)
    inst=True
  _config=os.path.abspath(cfgPath+'/sltsrv.config')
  if (inst and not os.path.exists(_config)) or not os.path.exists(_config):
    #si no est lo copiamos
    if os.path.exists(os.path.abspath(miPath+'/sltsrv.config')):
      import shutil
      shutil.copy(os.path.abspath(miPath+'/sltsrv.config'),_config)
      inst=True

# 3. Actualizar la informacin
misPaths=[]
#misPaths.append(miPath)
misPaths.append(os.path.abspath(miPath+'/py'))
sys.path.extend(misPaths)

#Actualizar datos en archivo config: el archivo es _config
if inst and os.path.exists(_config):
  if sltsrvexe[0][-3:].lower()=='.py':
    #hay que aadir el interprete
    sltsrvexe.insert(0,sys.executable)
  
  f=file(_config,'rb')
  scfg=f.read()
  f.close()
  cfg=eval(scfg)
  cfg['entorn']['sltsrvexe']=sltsrvexe
  cfg['entorn']['sltsrvpath']=miPath
  cfg['entorn']['sltsrvpaths']=misPaths
  cfg['entorn']['sltinitime']=time.gmtime(time.time())
  scfg=str(cfg)
  f=file(_config,'wb')
  f.write(scfg)
  f.close()

  #Dar permisos de lectura y escritura
  os.chmod(_config,stat.S_IRUSR+stat.S_IWUSR+stat.S_IRGRP+stat.S_IWGRP+stat.S_IROTH+stat.S_IWOTH)

if _inst:
  #El proceso de instalacin por opcin -i no sigue
  sys.exit()

# ------------------------------------------------------------
# Sigue el proceso normal
# ------------------------------------------------------------

import vbfunctions
import sltgen

def ini():
  global RSet,ByRef,InStr,Trim
  RSet=sltgen.RSet
  ByRef=sltgen.ByRef
  InStr=sltgen.InStr
  Trim=sltgen.Trim
  global AbrirBd,BdClone,CerrarBd
  AbrirBd=sltgen.AbrirBd
  BdClone=sltgen.BdClone
  CerrarBd=sltgen.CerrarBd

# ---------------------------------------------------------------------------
#       Declaraciones y definiciones generales
#
#       Corrector-Traductor de Valenci (CTV)
#
#       Parte general (mantenimiento BD + corrector + traductor)
#
#---------------------------------------------------------------------------
#
#---------------------------------------------------------------------------
#   Declaraciones generales
#---------------------------------------------------------------------------

ini()

#'---------------------------------------------------------------------------
#' constantes y variables generales.
#'---------------------------------------------------------------------------
CTV_VERSION = '4.0'
NO = 0
SI = 1

saltactivo=NO #Indica si se ha inicializado el motor salt

#Uso de maysculas
MAJ_SEMPRE = 1
MAJ_MAI = 2
MAJ_AVEG = 3

#Uso de maysculas (literal)
MAJ_SEMPRE_L = 'Sempre'
MAJ_MAI_L = 'Mai'
MAJ_AVEG_L = 'A vegades'

#Nivell de llenguatge (varietat dialectal)
NIV_DIALECTAL = 1
NIV_ESTANDARD = 2
NIV_CONVERGENT = 3
NIV_ALTRES = 4

#Nivell de llenguatge (literal)
NIV_DIALECTAL_L = 'Dialectal'
NIV_ESTANDARD_L = 'Estndard'
NIV_CONVERGENT_L = 'Convergent'
NIV_ALTRES_L = 'Altres dialectes'

#Registre (nivell de formalitat)
REG_POCFORMAL = 1
REG_FORMAL = 2
REG_MOLTFORMAL = 3

#Registre (literal)
REG_POCFORMAL_L = 'Poc formal'
REG_FORMAL_L = 'Formal'
REG_MOLTFORMAL_L = 'Molt formal'

#Tipo de palabra errnea
TIP_NORMAL = 0
TIP_CAST = 1
TIP_VULG = 2

#Tipo de palabra errnea (literal)
TIP_NORMAL_L = 'Normal'
TIP_CAST_L = 'Castellanisme'
TIP_VULG_L = 'Vulgarisme'

#Flexin
FLX_NO = 0
FLX_MSIN = 1
FLX_FSIN = 2
FLX_MPLU = 3
FLX_FPLU = 4
FLX_MPLUALT = 5
FLX_FPLUALT = 6

#Parte de la oracin
PART_ART = 1
PART_ADV = 2
PART_CONJ = 3
PART_INTER = 4
PART_PREP = 5
PART_ADJ = 6
PART_SUBS = 7
PART_VERB = 8
PART_PRON = 9
PART_FRFETA = 10
PART_CONTR = 11
PART_ABR = 12
PART_TOP = 13
PART_NOMPR = 14
PART_DET = 15
PART_NROMA = 16
PART_SUBSADJ = 18
PART_SUBSPREPA = 7 + 256
PART_MOTESTR = 7 + 512
PART_SUBSPERS = 7 + 1024
PART_VERBTR = 8 + 0
PART_VERBINTR = 8 + 256
PART_VERBPR = 8 + 512
PART_VERBCOPU = 8 + 1024
PART_PRNORMAL = 9 + 0
PART_PRFEBLE = 9 + 256
PART_TOPOFI = 13 + 0
PART_TOPHIST = 13 + 256
PART_DETGEN = 15 + 0
PART_DETQUAN = 15 + 256
PART_SADJPREPA = 18 + 256
PART_SADJPERS = 18 + 1024

#Parte de la oracin (literal)
PART_ART_L = 'Article'
PART_ADV_L = 'Adverbi'
PART_CONJ_L = 'Conjunci'
PART_INTER_L = 'Interjecci'
PART_PREP_L = 'Preposici'
PART_ADJ_L = 'Adjectiu'
PART_SUBS_L = 'Substantiu'
PART_VERB_L = 'Verb'
PART_PRON_L = 'Pronom'
PART_FRFETA_L = 'Frase feta'
PART_CONTR_L = 'Contracci'
PART_ABR_L = 'Abreviaci'
PART_TOP_L = 'Top.'
PART_NOMPR_L = 'N. pr.'
PART_DET_L = 'Det.'
PART_NROMA_L = 'Nombre rom'
PART_MOTESTR_L = 'Mot estranger'
PART_SUBSADJ_L = 'Subs/Adj'
PART_SUBSPREPA_L = 'Subs. prep. a'
PART_SUBSPERS_L = 'Subs. personal'
PART_VERBTR_L = 'Verb tr.'
PART_VERBINTR_L = 'Verb intr.'
PART_VERBPR_L = 'Verb pr.'
PART_VERBCOPU_L = 'Verb copu.'
PART_PRNORMAL_L = 'Pronom'
PART_PRFEBLE_L = 'Pronom feble'
PART_TOPOFI_L = 'Top. oficial'
PART_TOPHIST_L = 'Top. histric'
PART_DETGEN_L = 'Determinant'
PART_DETQUAN_L = 'Det. quantitatiu'
PART_SADJPREPA_L = 'S/Adj prep a'
PART_SADJPERS_L = 'S/Adj personal'

#Posicin del pronombre respecto al verbo
PR_VBOPRO = 0
PR_PROVBO = 4
PR_VOC = 1
PR_CONS = 2
PR_VBVOCNOUPR = PR_VBOPRO + PR_VOC
PR_VBCONSUPR = PR_VBOPRO + PR_CONS
PR_VBPR = PR_VBOPRO + PR_VOC + PR_CONS
PR_PRVOCHVB = PR_PROVBO + PR_VOC
PR_PRCONSVB = PR_PROVBO + PR_CONS
PR_PRVB = PR_PROVBO + PR_VOC + PR_CONS

#Posicin del pronombre respecto al verbo (literal)
PR_VBVOCNOUPR_L = 'Verb ac voc(no u) + pro'
PR_VBCONSUPR_L = 'Verb ac cons/u + pro'
PR_VBPR_L = 'Verb + pro'
PR_PRVOCHVB_L = 'Pro + verb com voc/h'
PR_PRCONSVB_L = 'Pro + verb com cons'
PR_PRVB_L = 'Pro + verb'

#'Tratamiento de verbos
VB_INF = 'INF'
VB_PRT = 'PART'
VB_IMP = 'IMP'
VB_GER = 'GER'
VB_NTREP = 40
VB_GR1 = 1
VB_GR2 = 2
VB_GR3 = 8
VB_GR4 = 32
VB_GR5 = 128
VB_GR6 = 512
VB_GR7 = 1024
VB_GR8 = 4096
VB_GR9 = 8192
VB_GR1_MASK = 1
VB_GR2_MASK = 2 + 4
VB_GR3_MASK = 8 + 16
VB_GR4_MASK = 32 + 64
VB_GR5_MASK = 128 + 256
VB_GR6_MASK = 512
VB_GR7_MASK = 1024 + 2048
VB_GR8_MASK = 4096
VB_GR9_MASK = 8192

#'Opciones (dentro de cada grupo)
VB_OP0 = 0
VB_OP1 = 1
VB_OP2 = 2
VB_OP3 = 3

#'Tipo de locuciones
LOC_TRAD = 0
LOC_CORR = 1

#'---------------------------------------------------------------------------
#' Modalidad de trabajo
#'---------------------------------------------------------------------------
tbvbmodval = ""
tbpron = ""
tbpronerr = ""
tbpadubt = ""
tbvbdubt = ""
tbfrfetes = ""
tbdoblsem = ""
tbajuda = ""
tbajudacont = ""
tbajudaindex = ""
tbvbmodori = ""
tbvbmodmeta = ""
tbpersonaltrad = ""
tbtemporaltrad = ""

#'   Indicador de modalidad
modalitat = ""

#'---------------------------------------------------------------------------
#'   Public constantes
#'---------------------------------------------------------------------------
#'   Estado de la ma_quina correctora (Corr)
CTV_ACTIVAR = 0
CTV_CANCELAR = 1
CTV_IGNORAR = 2

#'   Form de informacin sobre errores
ctverr = 0
palsel = ""

#'   Identificador de traductor o corrector
ctvmodocorrtrad = 0
CTV_ESCORR = 1
CTV_ESTRAD = 2
CTV_ESTRAD2 = 3
CTV_REVISIO = 4

#'   Nivel de depuracin de errores
ctvnivel = 0
CTV_VELOCITAT = 1
CTV_QUALITAT = 2

#'   Control de palabras reconocidas por CoPalReconocida
PALREC_NO = 0
PALREC_SI = 1
PALREC_SI_PERS = 2
PALREC_SI_CASTERR = 3

#'   Tipo de vocales y consonantes (separacin silbica)
VC_VOCFOR = 1
VC_VOCFEB = 2
VC_CONS = 4
VC_CONSLIQ = 8
VC_R = 16
VC_QG = 32
VC_PUNTVOL = 64
VC_GUI = 128
VC_U = 256
VC_L = 512

#'   Modos de actuar la funcin ModificaPalabra
MODO_BORRAR = - 1
MODO_MODIFICAR = 0
MODO_INSERTAR = 1

#'---------------------------------------------------------------------------
#'   Declaraciones globales
#'---------------------------------------------------------------------------

#'       Informacin complementaria para una palabra

class infcomple:
  def __init__(self):
    self.pre = ""
    self.sepsil = 0
    self.pal1 = ""
    self.pal2 = ""
    self.tipopost = 0
    self.post = 0
    self.xi = 0
    self.tipoletra = 0
    self.signopunt = 0
    self.postsignopunt = 0

#'   Tipo de letra de la palabra
TL_TODOMINUS = 1
TL_TODOMAYUS = 2
TL_PRIMERAMAYUS = 3
TL_MAYUSMINUS = 4

#'---------------------------------------------------------------------------
#'   Variables globales
#'---------------------------------------------------------------------------

#' -------------------
#'   Palabra actual
#' -------------------
#' Array de palabras del texto a tratar, como esta_n en el texto. Incluye
#'   apo_strofe, separacio_n sila_bica y mayu_sculas o minu_sculas
#'   -2, -1: Palabras anteriores
#'   0:  Palabra actual
#'   +1, +2: Palabras siguientes

#'   Palabra actual (con dos palabras anteriores y posteriores)
paltext = vbfunctions.vbObjectInitialize(((- 2, 2),), vbfunctions.String)

#'   Caracteri_sticas de la palabra en el documento (u_ltimo byte de PalText(i))
marcaapo = vbfunctions.FixedString(1)
marcagui = vbfunctions.FixedString(1)
marcaapogui = vbfunctions.FixedString(1)
marcaxi = vbfunctions.FixedString(1)

#' Array de palabras de los diccionarios, sin apo_strofe, ni guio_n separador y
#'   so_lo con letras minu_sculas
#'   -2, -1: Palabras anteriores
#'   0:  Palabra actual
#'   +1, +2: Palabras siguientes
paldic = vbfunctions.vbObjectInitialize(((- 2, 2),), vbfunctions.String)

#' Informacin complementaria de la palabra actual
infcomplact = infcomple()

#'-----------------------------
#' Tratamiento de pronombres
#'-----------------------------
#' El pronombre o pronombres a analizar se pasan en PrPron. PrPos indica la
#' posicio_n respecto al verbo y el tipo de verbo ( vocal, consonante, etc)
#' PrNPals indica que palabras de PalText() se pasan en PrPron:
#'   -2: PalText(-2), PalText(-1) y PalText(0)
#'   -1: PalText(-1) y PalText(0)
#'   0:  PalText(0)
#' PrPronOk es la Public construccio_n propuesta como correcta, en caso de que la
#' Public construccio_n de PrPron sea erro_nea
prpron = vbfunctions.String()
prpos = vbfunctions.Integer()
prnpals = vbfunctions.Integer()
prpronok = vbfunctions.String()

#'   Valores de retorno de la funcin BuscaPron (buscar pronombre en BD)
PR_NO = 0
PR_CORR = 1
PR_ERR = 2

#' ---------------------------
#'   Errorres de concordancia
#' ---------------------------
#'Indica si ha de saltar la deteccio_n de concordancia (Ignorar)
concordsalta = vbfunctions.Integer()

#' ----------------------------------------------------
#'   Funciones del corrector desactivadas
#' ----------------------------------------------------
#'Indica si han de ejecutarse la funciones del corrector
#'desactivadas
exereglesdesact =False

#' ----------------------------------------------------
#'   Informacio_n de control del proceso de correccio_n
#' ----------------------------------------------------

#'   Funcio_n de correccio_n que ha detectado la palabra erro_nea
CORR_PAL_NO_RECONOCIDA = 1
CORR_PAL_DUPLICADA = 2
CORR_SEP_SILABICA = 3
CORR_APOSTROFE = 4
CORR_CONTRACCION = 5
CORR_CONCORDANCIA = 6
CORR_DOBLETE_SEMANTICO = 7
CORR_USO_MAYUSCULAS = 8
CORR_USO_PRON = 9
CORR_PLURAL_ALT = 10
CORR_DOBLE_ACC = 11
CORR_MODEL_PART = 12
CORR_VB = 13
CORR_EN = 14
CORR_TOPONIMOS = 15
CORR_REGLAS = 16
CORR_LOCS = 17
CORR_MOTESTR = 18
CORR_GUION = 19
CORR_CONFIG = 20
funcorract = vbfunctions.Integer()

#' --------------------------------------------------------------------------
#'   Opciones de configuracin
#' --------------------------------------------------------------------------
optma = vbfunctions.Integer() #'Si TRUE, detectar uso mayu_sculas
optdsem = vbfunctions.Integer() #'Si TRUE, detectar dobl. semnticos
optpades = vbfunctions.Integer() #'Si TRUE, detectar pal. desconocidas
optnpdes = vbfunctions.Integer() #'Si TRUE, detectar nombres propios desconocidos
optopconfig = vbfunctions.Integer() #'Si TRUE, detectar op. de config.
optxi = vbfunctions.Integer() #'Si TRUE, detectar cifras
optacc = vbfunctions.Integer() #'Si TRUE, modelo 2 (caf)
optplu = vbfunctions.Integer() #'Si TRUE, modelo 2 (texts)
optpart = vbfunctions.Integer() #'Si TRUE, modelo 2 (establert)
optdemostra = vbfunctions.Integer() #'Si TRUE, modelo 2 (este, eixe)
optincoac = vbfunctions.Integer() #'Si TRUE, modelo 2 (patix)
optpis = vbfunctions.Integer() #'Si TRUE, modelo 2 (cants)
optpp = vbfunctions.Integer() #'Si TRUE, modelo 2 (vaig cantar)
opttop = vbfunctions.Integer() #'Si TRUE, usar topnimos oficiales

#'Opcions de lxic
optasi = vbfunctions.Integer() #'Si True, opcin 2 (aixina)
optdesarrollar = vbfunctions.Integer() #'Si True, opcin 2 (desenvolupar)
opthoy = vbfunctions.Integer() #'Si True, opcin 2 (avui)
optocho = vbfunctions.Integer() #'Si True, opcin 2 (vuit)
optquinto = vbfunctions.Integer() #'Si True, opcin 2 (cinqu)
optservicio = vbfunctions.Integer() #'Si True, opcin 1 (servei)
opttener = vbfunctions.Integer() #'Si True, opcin 2 (tenir)
optver = vbfunctions.Integer() #'Si True, opcin 2 (veure)

#'Nivell de formalitat (registro)
optnformal = vbfunctions.Integer()

#'       Posibles valores:
optpocformal = 1
optformal = 2
optmoltformal = 3

#'Detectar en corrector nivell de formalitat
optnfcorrnodetectar = vbfunctions.Integer() #'Si True, opcin 2 (no detectar)

#'Nivell de llenguatge (variedad dialectal)
optnoptimo = vbfunctions.Integer()

#'       Nivel de traduccin que se considera ptimo
#'   cuando una palabra castellana se puede traducir por
#'   varias palabras valencianas, de diferentes niveles
#'   (1=Dialectal, 2=Standard, 3=Convergente, 4=Otros dialectos)
optdialectal = 1
optstandard = 2
optconvergent = 3
optaltres = 4

#'   No traducir dentro de un intervalo
optnotradint = False
optnotradini = vbfunctions.String()
optnotradfi = vbfunctions.String()

#' ---------------------------------------------------------------------------
#'   Sustitucio_n de frases completas (tratamiento de reglas y de locuciones
#'       .. en el proceso de correccio_n)
#' ---------------------------------------------------------------------------
#'   Palabra final de la frase a sustituir (0 = palabra actual)
sustfrfin = vbfunctions.Integer()

#'   Nmero de palabras de la frase a sustituir
sustfrnumpals = vbfunctions.Integer()

#'   Frase a incluir (frase correcta)
sustfrcorr = vbfunctions.String()

#' ---------------------------------------------------------------------------
#'   Avisos posteriores (PostAviso)
#' ---------------------------------------------------------------------------
papalerr = vbfunctions.String()
pamens = vbfunctions.String()
papalalt = vbfunctions.String()
paidbas = vbfunctions.String()
paid = vbfunctions.Long()
paflex = vbfunctions.Integer()

#' ---------------------------------------------------------------------------
#'       Declaraciones y definiciones generales
#'
#'       Corrector-Traductor de Valenci (CTV)
#'
#'       Parte especfica del traductor
#'
#' --------------------------------------------------------------------------
#'
#' --------------------------------------------------------------------------
#'   Mquina de estados Trad()
#' --------------------------------------------------------------------------
#'   Posibles estados
TR_INICIO = 0
TR_OTRAPAL = 1
TR_FRHECHAS = 2
TR_REGLAS = 3
TR_TRADMEC = 4

#'   Llamada inicial (reset) o normal
TR_RESET = 0
TR_NORMAL = 1
TR_CANCELAR = 2

#' --------------------------------------------------------------------------
#'   Mquina de estados TrCorr()     (corregir la traduccin)
#' --------------------------------------------------------------------------
#'   Posibles estados
TRC_OTRAPAL = 0
TRC_CORR = 1

#' --------------------------------------------------------------------------
#'   Funciones TrVerTipoVbCas y TrVerTipoVbVal
#' --------------------------------------------------------------------------
TIPOVB_INICIAR = 1 #'Obtener datos de la base de datos
TIPOVB_COMPR = 2 #'Comprobar datos
TIPOVB_NORMAL = 3 #'Obtener datos + Comprobar datos

#' -------------------------------------------------------------------------
#'   Traduccin de frases hechas (locuciones)
#' -------------------------------------------------------------------------
#'   Public constantes generales

#'Nm. pal. siguientes a tratar (prospeccin)
LOC_NUMPALPRO = 5

#'   Array de palabras a tratar (prospeccin)
class locpro:
  def __init__(self):
    self.palclave = vbfunctions.String() #'Hipottica palabra clave de frase
    self.primerafrase = vbfunctions.Integer() #'Indice en el array de frases (0=no hay frase)

locpals = vbfunctions.vbObjectInitialize((LOC_NUMPALPRO,), locpro)

#'   Array de locuciones asociadas a las palabras a tratar
class locfrase:
  def __init__(self):
    self.frasecast = vbfunctions.String() #Frase origen
    self.fraseval = vbfunctions.String() #Frase meta
    self.condicion = vbfunctions.String() #'Infinitivo condicionante de la frase
    self.condicion2 = vbfunctions.Integer() #'Categoria gramatical condicionante
    self.condicion2b = vbfunctions.String() #'Flexin o tiempo verbal que suma a condicin 2
    self.condicion2ini = vbfunctions.Integer() #'La condicio_n tipo 2 esta_ al principio (True) o al final (False) de la frase
    self.condicion3 = vbfunctions.Integer() #'Nivel de formalidad (registro) condicionante (corrector)
    self.numpals = vbfunctions.Integer() #'Nmero de palabras de la frase
    self.siguientefrase = vbfunctions.Integer() #'Indice en array de frases (0=no hay ms)

locfrases = locfrase()

#'   Anterior palabra castellana
locantpalcast = vbfunctions.String()

#'   Diccionario de frases en memoria
#'   Estructura de los indices:  xxx:yyy;xxx:yyy, siendo xxx=IdCas y yyy=
#'   ndice en LocTr/CoIn/Out
loctrids = vbfunctions.String() #'ndices de las frases del traductor
loctrin = vbfunctions.String() #'Frases del traductor (entrada)
loctrout = vbfunctions.String() #'Frases del traductor (salida)
loccoids = vbfunctions.String() #'ndices de las frases del corrector
loccoin = vbfunctions.String() #'Frases del corrector (entrada)
loccoout = vbfunctions.String() #'Frases del corrector (salida)

#' --------------------------------------------------------------------------
#'   Sufijos diminutivos y aumentativos
#' --------------------------------------------------------------------------

#'   Grupos de sufijos
SUF_MF_CONS = 1 #'Suf m y f empezados por consonant
SUF_M_VOCAL = 2 #'Suf masculinos empezados por vocal
SUF_F_VOCAL = 3 #'Suf femeninos empezados por vocal

#' --------------------------------------------------------------------------
#'   Reglas sobre palabras dudosas (dobletes)
#' --------------------------------------------------------------------------
PALDU_TIPOPIS = 1 #'Regla TrRePalDu5, tipo PIS
PALDU_TIPOPPS = 2 #'Regla TrRePalDu5, tipo PPS/PPP

#' --------------------------------------------------------
#'   Acceso a la lista de palabras
#' --------------------------------------------------------
lspals = []

# ---------------------------------------------------------
# Saltar frases en otras lenguas
# ---------------------------------------------------------
npaldesco=0 #contador de palabras desconocidas
void_npalmin=9999 #condiciones para void
void_percent=100

#' --------------------------------------------------------
#'   Lista de alternativas
#' --------------------------------------------------------
#'   Array de palabras dudosas (para que seleccione el
#'   operador). Cuando los dobletes se generan en
#'   TradMecTrad llamada desde una regla, los dobletes se
#'   han de guardar para su proceso posterior dentro de la
#'   regla
arralt = vbfunctions.String()

#'   Para mostrar todas las palabras dudosas
ls_paldu = [] #ListBox()

#' ----------------------------------------------------------
#' Informacin sobre cada palabra dudosa para revisar
#' equivale al contenido del form frmCTV
#' ----------------------------------------------------------
ls_alt = [] #ListBox()
tx_pal = '' #TextBox()
tx_palerr = '' #TextBox()
lb_mens = '' #Label()

#' -------------------------------------------------------------
#'   Texto del documento que hay que traducir
#' -------------------------------------------------------------
txDOC = '' #TextBox()

#' --------------------------------------------------------------------------
#'   Control para evitar bucles
#' --------------------------------------------------------------------------

#'   Array PalText anterior (-1) y anterior al anterior (-2)
paltextant = vbfunctions.vbObjectInitialize(((- 5, - 1), (- 2, 2),), vbfunctions.String)
yavisto = vbfunctions.String()

#' --------------------------------------------------------
#' --------------------------------------------------------
#'   Diccionarios de palabras ya accedidas
#'
#'   Cada diccionario es una colleccio_n. Cada elemento es
#'   una palabra. El contenido del elemento son bookmarks
#'   a las tablas y la clave de acceso es la palabra
#' --------------------------------------------------------
#'Diccionario de palabras accedidas desde Trad, para su uso
#'desde Trad2 y Trad3
colval = {}

#' --------------------------------------------------------
#' --------------------------------------------------------
#'   Acceso a la base de datos
#' --------------------------------------------------------
#' --------------------------------------------------------
# ------------------------------------------
# Bases de datos virtuales en memoria
# ------------------------------------------
#Nombre de las tablas en memoria
m_tablas=[]
#Diccionario de recodsets accedidos
d_rsets={}

#Nombres de la tablas
tb_d_oriflex_IdOriFlex=os.path.abspath(bdsPath+"/saltbd_a")
tb_d_oriflex_VeuOri=os.path.abspath(bdsPath+"/saltbd_b")
tb_d_metabas_IdOri=os.path.abspath(bdsPath+"/saltbd_c")
tb_d_metabas_IdMeta=os.path.abspath(bdsPath+"/saltbd_d")
tb_d_metaflex_IdMetaFlex=os.path.abspath(bdsPath+"/saltbd_e")
tb_d_metaflex_Veu=os.path.abspath(bdsPath+"/saltbd_f")
tb_d_metasin_IdMeta=os.path.abspath(bdsPath+"/saltbd_g")
tb_d_metasin_IdSin=os.path.abspath(bdsPath+"/saltbd_h")
tb_d_metadoblsem_IdMeta=os.path.abspath(bdsPath+"/saltbd_i")
tb_d_metadoblsem_IdDoblSem=os.path.abspath(bdsPath+"/saltbd_j")
tb_d_motserr_VeuErr=os.path.abspath(bdsPath+"/saltbd_k")
tb_d_sepsil_IdMetaFlex=os.path.abspath(bdsPath+"/saltbd_l")
tb_d_pron_VeuPos=os.path.abspath(bdsPath+"/saltbd_m")
tb_d_pronerr_VeuPos=os.path.abspath(bdsPath+"/saltbd_n")
tb_d_frfetes_IdOri=os.path.abspath(bdsPath+"/saltbd_o")
tb_d_vbmodcas_ModelPersona=os.path.abspath(bdsPath+"/saltbd_p")
tb_d_vbmodcas_Termin=os.path.abspath(bdsPath+"/saltbd_q")
tb_d_vbmodval_ModelPersona=os.path.abspath(bdsPath+"/saltbd_r")
tb_d_vbmodval_Termin=os.path.abspath(bdsPath+"/saltbd_s")
tb_d_padubt_PaClau=os.path.abspath(bdsPath+"/saltbd_t")
tb_d_pacorrec_PaClauRegla=os.path.abspath(bdsPath+"/saltbd_u")
tb_d_padubtaquest_PaClau=os.path.abspath(bdsPath+"/saltbd_v")
tb_d_regles_PaClauRegla=os.path.abspath(bdsPath+"/saltbd_w")
tb_d_vbdubt_PaClau=os.path.abspath(bdsPath+"/saltbd_x")

tb_i_oriflex_IdOriFlex=os.path.abspath(bdsPath+"/saltbdi_a")
tb_i_oriflex_VeuOri=os.path.abspath(bdsPath+"/saltbdi_b")
tb_i_metabas_IdOri=os.path.abspath(bdsPath+"/saltbdi_c")
tb_i_metabas_IdMeta=os.path.abspath(bdsPath+"/saltbdi_d")
tb_i_metaflex_IdMetaFlex=os.path.abspath(bdsPath+"/saltbdi_e")
tb_i_metaflex_Veu=os.path.abspath(bdsPath+"/saltbdi_f")
tb_i_metasin_IdMeta=os.path.abspath(bdsPath+"/saltbdi_g")
tb_i_metasin_IdSin=os.path.abspath(bdsPath+"/saltbdi_h")
tb_i_metadoblsem_IdMeta=os.path.abspath(bdsPath+"/saltbdi_i")
tb_i_metadoblsem_IdDoblSem=os.path.abspath(bdsPath+"/saltbdi_j")
tb_i_motserr_VeuErr=os.path.abspath(bdsPath+"/saltbdi_k")
tb_i_sepsil_IdMetaFlex=os.path.abspath(bdsPath+"/saltbdi_l")
tb_i_pron_VeuPos=os.path.abspath(bdsPath+"/saltbdi_m")
tb_i_pronerr_VeuPos=os.path.abspath(bdsPath+"/saltbdi_n")
tb_i_frfetes_IdOri=os.path.abspath(bdsPath+"/saltbdi_o")
tb_i_vbmodcas_ModelPersona=os.path.abspath(bdsPath+"/saltbdi_p")
tb_i_vbmodcas_Termin=os.path.abspath(bdsPath+"/saltbdi_q")
tb_i_vbmodval_ModelPersona=os.path.abspath(bdsPath+"/saltbdi_r")
tb_i_vbmodval_Termin=os.path.abspath(bdsPath+"/saltbdi_s")
tb_i_padubt_PaClau=os.path.abspath(bdsPath+"/saltbdi_t")
tb_i_pacorrec_PaClauRegla=os.path.abspath(bdsPath+"/saltbdi_u")
tb_i_padubtaquest_PaClau=os.path.abspath(bdsPath+"/saltbdi_v")
tb_i_regles_PaClauRegla=os.path.abspath(bdsPath+"/saltbdi_w")
tb_i_vbdubt_PaClau=os.path.abspath(bdsPath+"/saltbdi_x")

tb_p_personal_VeuPersonal=os.path.abspath(bdsPath+"/saltbdp_a")
tb_p_personaltrad_VeuOri=os.path.abspath(bdsPath+"/saltbdp_b")
tb_p_personaltradi_VeuOri=os.path.abspath(bdsPath+"/saltbdp_c")
tb_p_temporal_VeuTemporal=os.path.abspath(bdsPath+"/saltbdp_d")
tb_p_temporaltrad_VeuOri=os.path.abspath(bdsPath+"/saltbdp_e")
tb_p_temporaltradi_VeuOri=os.path.abspath(bdsPath+"/saltbdp_f")

tb_v_auxvbscas=os.path.abspath(bdsPath+"/saltbdv_a")
tb_v_auxvbsval=os.path.abspath(bdsPath+"/saltbdv_b")

tb_dicsalt_LemaOrdLema=os.path.abspath(bdsPath+"/saltdic_a")
tb_dicsalt_AmelOrdLema=os.path.abspath(bdsPath+"/saltdic_b")
tb_dicsalt_Lema2OrdLema=os.path.abspath(bdsPath+"/saltdic_c")

tb_dicbilcv_LemaOrdLema=os.path.abspath(bdsPath+"/saltdbil_a")
tb_dicbilvc_LemaOrdLema=os.path.abspath(bdsPath+"/saltdbil_b")
tb_dicbilcv_Lema2OrdLema=os.path.abspath(bdsPath+"/saltdbil_c")
tb_dicbilvc_Lema2OrdLema=os.path.abspath(bdsPath+"/saltdbil_d")


#'   Identificador de la base de datos actual
#'   (direccio_n del traductor)
dtrcasval = 'd'
dtrvalcas = 'i'
dtractual = vbfunctions.String()

#'   Base de datos general
#'   BD activa
env=None
bdat = ""
cur=""
bd_oriflex_IdOriFlex=None
bd_oriflex_VeuOri=None
bd_metabas_IdOri=None
bd_metabas_IdMeta=None
bd_metaflex_IdMetaFlex=None
bd_metaflex_Veu=None
bd_metasin_IdMeta=None
bd_metasin_IdSin=None
bd_metadoblsem_IdMeta=None
bd_metadoblsem_IdDoblSem=None
bd_motserr_VeuErr=None
bd_sepsil_IdMetaFlex=None
bd_pron_VeuPos=None
bd_pronerr_VeuPos=None
bd_frfetes_IdOri=None
bd_vbmodori_ModelPersona=None
bd_vbmodori_Termin=None
bd_vbmodmeta_ModelPersona=None
bd_vbmodmeta_Termin=None
bd_padubt_PaClau=None
bd_pacorrec_PaClauRegla=None
bd_padubtaquest_PaClau=None
bd_regles_PaClauRegla=None
bd_vbdubt_PaClau=None
bd_personal_VeuPersonal=None
bd_personaltrad_VeuOri=None
bd_temporal_VeuTemporal=None
bd_temporaltrad_VeuOri=None

roriflex = RSet()
rmetabas = RSet()
rmetaflex = RSet()
rmetasin = RSet()
rmetadoblsem = RSet()
rmotserr = RSet()
rsepsil = RSet()
rpron = RSet()
rpronerr = RSet()
rfrfetes = RSet()
rvbmodori = RSet()
rvbmodmeta = RSet()

rpersonal = RSet()
rtemporal = RSet()
rpersonaltrad = RSet()
rtemporaltrad = RSet()

#'   BD directa
bdatd = ""
curd=""
bd_d_oriflex_IdOriFlex=None
bd_d_oriflex_VeuOri=None
bd_d_metabas_IdOri=None
bd_d_metabas_IdMeta=None
bd_d_metaflex_IdMetaFlex=None
bd_d_metaflex_Veu=None
bd_d_metasin_IdMeta=None
bd_d_metasin_IdSin=None
bd_d_metadoblsem_IdMeta=None
bd_d_metadoblsem_IdDoblSem=None
bd_d_motserr_VeuErr=None
bd_d_sepsil_IdMetaFlex=None
bd_d_pron_VeuPos=None
bd_d_pronerr_VeuPos=None
bd_d_frfetes_IdOri=None
bd_d_vbmodcas_ModelPersona=None
bd_d_vbmodcas_Termin=None
bd_d_vbmodval_ModelPersona=None
bd_d_vbmodval_Termin=None
bd_d_padubt_PaClau=None
bd_d_pacorrec_PaClauRegla=None
bd_d_padubtaquest_PaClau=None
bd_d_regles_PaClauRegla=None
bd_d_vbdubt_PaClau=None

#'   BD inversa
bdati = ""
curi=""
bd_i_oriflex_IdOriFlex=None
bd_i_oriflex_VeuOri=None
bd_i_metabas_IdOri=None
bd_i_metabas_IdMeta=None
bd_i_metaflex_IdMetaFlex=None
bd_i_metaflex_Veu=None
bd_i_metasin_IdMeta=None
bd_i_metasin_IdSin=None
bd_i_metadoblsem_IdMeta=None
bd_i_metadoblsem_IdDoblSem=None
bd_i_motserr_VeuErr=None
bd_i_sepsil_IdMetaFlex=None
bd_i_pron_VeuPos=None
bd_i_pronerr_VeuPos=None
bd_i_frfetes_IdOri=None
bd_i_padubt_PaClau=None
bd_i_pacorrec_PaClauRegla=None
bd_i_padubtaquest_PaClau=None
bd_i_regles_PaClauRegla=None
bd_i_vbdubt_PaClau=None

#'   bases de datos personal
bdatp = ""
curp=""
bd_p_personal_VeuPersonal=None
bd_p_personaltrad_VeuOri=None
bd_p_personaltradi_VeuOri=None
bd_p_temporal_VeuTemporal=None
bd_p_temporaltrad_VeuOri=None
bd_p_temporaltradi_VeuOri=None

## base de datos de ayudas
#bdata = ""
#cura=""
#rpersonal = RSet()
#rtemporal = RSet()
#rajuda = RSet()
#rpersonaltradd = RSet()
#rtemporaltradd = RSet()
#rpersonaltradi = RSet()
#rtemporaltradi = RSet()
#rpersonaltrad = RSet()
#rtemporaltrad = RSet()

#' -------------------------------------------------------
#'   PROCESO DE REVISIN DE LA TRADUCCIN
#' -------------------------------------------------------

#' --------------------------------------------------------
#'   Indicador de que estamos en revisio_n de texto. Es
#'   necesario porque desde revisio_n se puede llamar a
#'   correccio_n, que cambia ctvmodocorrtrad. Asi gracias a
#'   este indicador se puede saber si se ha llamado al
#'   corrector desde la revisio_n del texto
#' --------------------------------------------------------
enrevisio = False

#' --------------------------------------------------------
#'   Nu_mero de palabras que hay que retroceder durante
#'   la revisio_n de texto al tratar el grupo de alternativas
#'   actual. Cuando la funcio_n TradMecDsVer detecta dobletes
#'   y los aade a la lista, actualiza este valor que sera_
#'   posteriormente incorporado a la informacio_n asociada
#'   a la palabra dudosa en el documento (campo Info)
#' --------------------------------------------------------
npretro = vbfunctions.Integer()

#' --------------------------------------------------------
#'   Constantes que identifican la informacio_n adicional,
#'   correspondiente al texto dudoso, que se ha de guardar
#'   junto con cada texto dudoso para el tratamiento
#'   posterior por el operador
#' --------------------------------------------------------
praunumalts = 'numalts' #'Nm. de alternativas
prautxtdu = 'txtdu' #'Texto dudoso
prautxtpro = 'txtpro' #'Texto propuesto '(corresponde a la primera alternativa)
praualt = 'alt' #'Las diferentes alternativas se identifican como $altn=
praudescrierror = 'error' #Texto que describe el tipo de error
praunpretro = 'npretro' #Nm. palabras a retroceder para corregir en el proceso de revisin (si 0 no corregir)
praucolor = 'txtcolor' #Color original del texto dudoso

#' -------------------------------------------------------
#'   Informacin sobre frmCtv
#' -------------------------------------------------------
#'   ltimo botn pulsado en frmCtv
frmctvboton = vbfunctions.String()

#' --------------------------------------------------------
#'   Textos de aviso y de error
#' --------------------------------------------------------
msggen = 1
msggenyaenexe = 2
msgfierr = 3
msgfinoopen = 4
msgfinoopen2 = 5
msgfinoguarda = 6
msgfinocarga = 7
msgfinoimpo = 8
msgfigran = 9
msgimanoinsert = 10
msgimabordererr = 11
msgtraerr = 12
msgtrafin = 13
msgcorrfin = 14
msgrevfin = 15
msgajunoexis = 16
msgadminnoopen = 17
msgadminerrafe = 18
msgbusreemfin = 19
msgbusreemtit = 20
msgfiguardar1 = 21
msgfiguardar2 = 22
msgfiguardar3 = 23
msgimarutaerr = 24
msgtraMarca = 25
msgrevcan = 26
msggennobd = 27
msgrevpte = 28

#'En valenci
msggenval = 'Corregiu el problema i torneu a arrancar el programa.'
msggenyaenexeval = 'No es permet executar dos cpies del programa'
msggennobdval = 'No s\'ha trobat la base de dades '
msgfierrval = 'Tipus de fitxer errni: '
msgfinoopenval = 'No s\'ha pogut obrir el fitxer.'
msgfinoopen2val = 'No es pot obrir el fitxer: '
msgfinoguardaval = 'No es pot guardar el fitxer: '
msgfinocargaval = 'No es pot carregar el fitxer: '
msgfinoimpoval = 'No es pot importar importar el fitxer: '
msgfigranval = 'Fitxer massa gran. proveu convertint-lo a fitxer rtf'
msgfiguardar1val = 'El text en ['
msgfiguardar2val = '] ha canviat.'
msgfiguardar3val = 'Vol guardar els canvis?'
msgimanoinsertval = 'Cannot insert image: '
msgimabordererrval = 'Invalid image border size'
msgimarutaerrval = 'Ruta invlida: '
msgtraerrval = 'Si teniu problemes al traduir el document, proveu a traduir-lo per parts.'
msgtrafinval = 'Traducci finalitzada.'
msgtramarcaval = 'Vol introduir una marca per a reprendre en aquest punt el procs de traducci?'
msgcorrfinval = 'Correcci finalitzada.'
msgrevfinval = 'Revisi del text finalitzada.'
msgrevcanval = 'Revisi del text cancellada.'
msgajunoexisval = 'L\'epgraf demanat no existix'
msgadminnoopenval = 'No s\'ha pogut obrir el fitxer '
msgadminerrafeval = 'Error al afegir fitxer '
msgbusreemfinval = 'Recerca finalitzada'
msgbusreemtitval = 'Cerca i substituci'
msgrevpteval = 'El document t marques de revisi. Vol eliminar-les?'

# VB2PY (UntranslatedCode) Attribute VB_Name = "sltgl"
_t={}