# -*- coding: latin-1 -*-
import vbfunctions
import sltgl
import sltgen

def OpConfigCargar_():
  #Valores por defecto
  sltgl.optma = True
  sltgl.optdsem = True
  sltgl.optpades = True
  sltgl.optnpdes = False
  sltgl.optopconfig = True
  sltgl.optxi = True
  sltgl.optacc = False
  sltgl.optplu = False
  sltgl.optpart = False
  sltgl.optdemostra = True
  sltgl.optincoac = True
  sltgl.optpis = False
  sltgl.optpp = True
  sltgl.opttop = True
  #optAsi = False           'As 1 (aix)
  #optDesarrollar = False   'Desarrollar 1 (desenrotllar)
  #optHoy = False           'Hoy 1 (hui)
  #optOcho = False          'Ocho 1 (huit)
  #optQuinto = False        'Quinto 1 (quint)
  #optServicio = True      'Servicio 1 (servei)
  #optTener = False         'Tener 1 (tindre)
  #optVer = False           'Ver 1 (vore)
  sltgl.optnoptimo = sltgl.optstandard
  sltgl.optnformal = sltgl.optformal
  sltgl.optnfcorrnodetectar = True
  sltgl.optnotradint = False


def OpConfigCargar():
  #
  #   Cargar las opciones de configuracin por defecto.
  #   stos valores por defecto, se pueden modificar en el fichero salt.ini
  #
  # VB2PY (UntranslatedCode) On Error Resume Next
  #Valores por defecto
  sltgl.optma = True
  sltgl.optdsem = True
  sltgl.optpades = True
  sltgl.optnpdes = False
  sltgl.optopconfig = True
  sltgl.optxi = True
  sltgl.optacc = False
  sltgl.optplu = False
  sltgl.optpart = False
  sltgl.optdemostra = True
  sltgl.optincoac = True
  sltgl.optpis = False
  sltgl.optpp = True
  sltgl.opttop = True
  sltgl.optnoptimo = sltgl.optstandard
  sltgl.optnformal = sltgl.optformal
  sltgl.optnfcorrnodetectar = True
  sltgl.optnotradint = False
  #Modificar segn fichero de configuracin
  f=file(sltgl.cfgPath+'/sltsrv.config','rb')
  scfg=f.read()
  f.close()
  cfg=eval(scfg)
  #import ConfigParser
  #cfg=ConfigParser.ConfigParser()
  #cfg.read(os.path.abspath(sltgl.cfgPath+'/sltsrv.config'))
  sltgl.optma=GetConfig(cfg,'config','maj',vTrue='2')
  sltgl.optdsem=GetConfig(cfg,'config','dsem',vTrue='2')
  sltgl.optpades=GetConfig(cfg,'config','pades',vTrue='2')
  sltgl.optnpdes=GetConfig(cfg,'config','npdes',vTrue='2')
  sltgl.optopconfig=GetConfig(cfg,'config','opconfig',vTrue='2')
  sltgl.optxi=GetConfig(cfg,'config','xifres',vTrue='2')
  sltgl.optplu=GetConfig(cfg,'config','plural',vTrue='2')
  sltgl.optdemostra=GetConfig(cfg,'config','demostratius',vTrue='1')
  sltgl.optincoac=GetConfig(cfg,'config','incoatius',vTrue='1')
  sltgl.optacc=GetConfig(cfg,'config','acc',vTrue='2')
  sltgl.opttop=GetConfig(cfg,'config','top',vTrue='1')
  sltgl.optnoptimo=GetConfig(cfg,'config','noptimo',vDef=sltgl.optnoptimo)
  sltgl.optnformal=GetConfig(cfg,'config','nformal',vDef=sltgl.optnformal)
  sltgl.optnfcorrnodetectar=GetConfig(cfg,'config','nfcorr',vTrue='2')
  sltgl.exereglesdesact=GetConfig(cfg,'config','ExeReglesDesact',vTrue='SI')
  sltgl.optnfcorrnodetectar=GetConfig(cfg,'config','nfcorr',vTrue='2')
  #Lxic, per assimilaci a altres opcions de morfosintaxi TODO
  sltgl.optasi=GetConfig(cfg,'config','as',vFalse='1')
  sltgl.optdesarrollar=GetConfig(cfg,'config','desarrollar',vFalse='1')
  sltgl.opthoy=GetConfig(cfg,'config','hoy',vFalse='1')
  sltgl.optocho = sltgl.optacc
  sltgl.opthoy = sltgl.optacc
  sltgl.opttener = sltgl.optacc
  sltgl.optquinto = not sltgl.optdemostra
  sltgl.optservicio = not sltgl.optdemostra
  sltgl.optver=GetConfig(cfg,'config','ver',vFalse='1')
  
  sltgl.void_npalmin=GetConfig(cfg,'config','void_npalmin',vDef=9999)
  sltgl.void_percent=GetConfig(cfg,'config','void_percent',vDef=100)

def OpConfigGuardar():
  #
  #   Guardar las opciones de configuracin en salt.ini
  #
  # VB2PY (UntranslatedCode) On Error Resume Next
  #Modificar segn salt.ini
  cadena = vbfunctions.IIf(sltgl.optma == True, '2', '1')
  WriteBDConfig('maj', cadena)
  cadena = vbfunctions.IIf(sltgl.optdsem == True, '2', '1')
  WriteBDConfig('dsem', cadena)
  cadena = vbfunctions.IIf(sltgl.optpades == True, '2', '1')
  WriteBDConfig('pades', cadena)
  cadena = vbfunctions.IIf(sltgl.optnpdes == True, '2', '1')
  WriteBDConfig('npdes', cadena)
  cadena = vbfunctions.IIf(sltgl.optopconfig == True, '2', '1')
  WriteBDConfig('opconfig', cadena)
  cadena = vbfunctions.IIf(sltgl.optxi == True, '2', '1')
  WriteBDConfig('xifres', cadena)
  cadena = vbfunctions.IIf(sltgl.optplu == True, '2', '1')
  WriteBDConfig('plural', cadena)
  cadena = vbfunctions.IIf(sltgl.optdemostra == False, '2', '1')
  WriteBDConfig('demostratius', cadena)
  cadena = vbfunctions.IIf(sltgl.optincoac == False, '2', '1')
  WriteBDConfig('incoatius', cadena)
  cadena = vbfunctions.IIf(sltgl.optacc == True, '2', '1')
  WriteBDConfig('acc', cadena)
  cadena = vbfunctions.IIf(sltgl.opttop == False, '2', '1')
  WriteBDConfig('top', cadena)
  cadena = vbfunctions.IIf(sltgl.opttener == True, '2', '1')
  WriteBDConfig('tener', cadena)
  cadena = Trim(str(sltgl.optnoptimo))
  WriteBDConfig('noptimo', cadena)
  cadena = Trim(str(sltgl.optnformal))
  WriteBDConfig('nformal', cadena)
  cadena = vbfunctions.IIf(sltgl.optnfcorrnodetectar == True, '2', '1')
  WriteBDConfig('nfcorr', cadena)

def ConfigLoad():
  #Obtener el contenido del fichero de configuracin
  #Retorno: Contenido del fichero de configuracin
  f=file(sltgl.cfgPath+'/sltsrv.config','rb')
  scfg=f.read()
  f.close()
  return scfg

def ConfigSave(scfg):
  #Guardar nueva configuracin en el fichero de configuracin
  #Entrada: scfg: Nueva configuracin (como string)
  f=file(sltgl.cfgPath+'/sltsrv.config','wb')
  f.write(scfg)
  f.close()

def Credits():
  txt=[u'Direcci Salt 4',[u'Vicent Satorres'],u'Direcci Salt 3',[u'Josep Lacreu',u'Vicent Satorres'],
       u'Direcci Salt 1 i 2',[u'Josep Lacreu'],u'Coordinaci lingstica versions 1, 2 i 3',
       [u'Conxa Chuli',u'Robert Escolano'],u'Procs informtic',[u'Rafael Pinter'],
       u'Suport informtic versions Linux',[u'Javier Garca', u'ngel Berlanas'],
       u'Procs lingstic Salt 3 i 4',[u'Ferran Bataller', u'Maluy Benet', u'Cristina Domingo',
       u'Josep G. Illa', u'Enric M. Catal', u'Llus Julin', u'Aurora Navarro',
       u'Juli Ortells', u'Anna Eva Peig', u'Dons Segu', u'Josep Sendra',
       u'Santiago Valls'],
       u'Procs lingstic Salt 1 i 2',[u'Ernest Any',u'Pepa Baixauli',u'Cristina Domingo',
       u'Josep G. Illa',u'Mari Trini Garcia',u'Slvia Garcia',u'Enric M. Catal',
       u'Nria Martnez',u'Rafel Moreno',u'Aurora Navarro',u'Juli Ortells',
       u'Susanna Pardines',u'ngels Romero',u'Vicenta Sabater',u'Marina Sahuquillo',
       u'Beatriu Sales',u'Isabel Saval',u'Dons Segu',u'Empar Sria'],
       u'Diccionari bilinge Salt 4',[u'Robert Escolano',u'Toni Lluch',u'Xavier Casero'],
       u'Diccionari Salt 4',[u'Oflia Sanmartn'],
       u'Grafisme Salt 4',[u'disseny (Snia i lex Ayges)']]
  return txt

def VerModalidad_():
  sltgl.tbvbmodval = 'vbmodval'
  sltgl.tbpron = 'pron'
  sltgl.tbpronerr = 'pronerr'
  sltgl.tbpadubt = vbfunctions.IIf(sltgl.optincoac, 'padubt', 'padubtaquest')
  sltgl.tbvbdubt = 'vbdubt'
  sltgl.tbfrfetes = 'frfetes'
  sltgl.tbdoblsem = 'metadoblsem'
  sltgl.tbajuda = 'ajuda'
  sltgl.tbajudacont = 'AjudaCont'

def VerConfig():
  _ret = None
  #
  #   Analizar si se permite entrar en configuracin,
  #   segn el fichero INI
  #
  #   Retorno:    True, si se permite
  #               False, si no se permite
  #
  _ret = True
  ret,cadena = GetBDConfig('mbit', cadena)
  if ret > 0:
    if vbfunctions.Left(cadena, ret) == '2':
      _ret = False
  return _ret

def IdiomaMsg(msgId):
  _ret = None
  #
  #   Obtener un mensaje de aviso, segn el idioma seleccionado
  #   (pppIdAvisos)
  #
  #   Entrada:    msgId: Identificador de mensaje
  #
  #   Retorno:    Mensaje correspondiente a msgId y pppIdAvisos
  #
  _select367 = msgId
  if (_select367 == sltgl.msggen):
    _ret = sltgl.msggenval
  elif (_select367 == sltgl.msggenyaenexe):
    _ret = sltgl.msggenyaenexeval
  elif (_select367 == sltgl.msggennobd):
    _ret = sltgl.msggennobdval
  elif (_select367 == sltgl.msgfierr):
    _ret = sltgl.msgfierrval
  elif (_select367 == sltgl.msgfinoopen):
    _ret = sltgl.msgfinoopenval
  elif (_select367 == sltgl.msgfinoopen2):
    _ret = sltgl.msgfinoopen2val
  elif (_select367 == sltgl.msgfinoguarda):
    _ret = sltgl.msgfinoguardaval
  elif (_select367 == sltgl.msgfinocarga):
    _ret = sltgl.msgfinocargaval
  elif (_select367 == sltgl.msgfinoimpo):
    _ret = sltgl.msgfinoimpoval
  elif (_select367 == sltgl.msgfigran):
    _ret = sltgl.msgfigranval
  elif (_select367 == sltgl.msgimanoinsert):
    _ret = sltgl.msgimanoinsertval
  elif (_select367 == sltgl.msgimabordererr):
    _ret = sltgl.msgimabordererrval
  elif (_select367 == sltgl.msgtraerr):
    _ret = sltgl.msgtraerrval
  elif (_select367 == sltgl.msgtrafin):
    _ret = sltgl.msgtrafinval
  elif (_select367 == sltgl.msgtraMarca):
    _ret = sltgl.msgtramarcaval
  elif (_select367 == sltgl.msgcorrfin):
    _ret = sltgl.msgcorrfinval
  elif (_select367 == sltgl.msgrevfin):
    _ret = sltgl.msgrevfinval
  elif (_select367 == sltgl.msgrevcan):
    _ret = sltgl.msgrevcanval
  elif (_select367 == sltgl.msgrevpte):
    _ret = sltgl.msgrevpteval
  elif (_select367 == sltgl.msgajunoexis):
    _ret = sltgl.msgajunoexisval
  elif (_select367 == sltgl.msgadminnoopen):
    _ret = sltgl.msgadminnoopenval
  elif (_select367 == sltgl.msgadminerrafe):
    _ret = sltgl.msgadminerrafeval
  elif (_select367 == sltgl.msgbusreemfin):
    _ret = sltgl.msgbusreemfinval
  elif (_select367 == sltgl.msgbusreemtit):
    _ret = sltgl.msgbusreemtitval
  elif (_select367 == sltgl.msgfiguardar1):
    _ret = sltgl.msgfiguardar1val
  elif (_select367 == sltgl.msgfiguardar2):
    _ret = sltgl.msgfiguardar2val
  elif (_select367 == sltgl.msgfiguardar3):
    _ret = sltgl.msgfiguardar3val
  elif (_select367 == sltgl.msgimarutaerr):
    _ret = sltgl.msgimarutaerrval
  return _ret

def Main():
  frmDOC.Show()

def GetConfig(cfg,sec,clave,vDef=None,vTrue=None,vFalse=None):
  _ret = vDef
  #
  #   Obtener informacin del fichero de configuracin
  #
  #   Entrada: cfg: Objeto asociado al fichero de configuracin
  #            sec: Seccin
  #            clave: Clave de la entrada
  #            vDef: Valor por defecto
  #            vTrue: Valor para respoder True
  #            vFalse: Valor para responder False
  #
  #   Retorno: Por defecto retorna vDef. Si existe retorna valor o True/False si valor == vTrue/vFalse
  #
  #if cfg.has_option(sec,clave):
    #if vTrue!=None:
      #_ret = vbfunctions.IIf(vbfunctions.LCase(cfg.get(sec,clave)) == vbfunctions.LCase(vTrue), True, False)
    #elif vFalse!=None:
      #_ret = vbfunctions.IIf(vbfunctions.LCase(cfg.get(sec,clave)) == vbfunctions.LCase(vFalse), False, True)
    #else:
      #_ret=cfg.get(sec,clave)
      #if vDef!=None:
        #if str(type(vDef))=="<type 'int'>":
          #_ret=eval(_ret)
  if cfg.has_key(sec):
    if cfg[sec].has_key(clave):
      if vTrue!=None:
        _ret = vbfunctions.IIf(vbfunctions.LCase(str(cfg[sec][clave])) == vbfunctions.LCase(vTrue), True, False)
      elif vFalse!=None:
        _ret = vbfunctions.IIf(vbfunctions.LCase(str(cfg[sec][clave])) == vbfunctions.LCase(vFalse), False, True)
      else:
        _ret=cfg[sec][clave]
  return _ret

def WriteBDConfig(Clau, Valor):
  #
  #   Guardar informacin de la tabla Config de la base de datos
  #
  #   Entrada: Clau: Clave a buscar
  #            Valor: Informacin asociada a Clau
  #
  r=RSet()
  sql = 'select * from Config where Clau = %s' #+ Clau + '"'
  r.OpenR(sql, (Clau,)) # TODO
  if r.eof:
    sql = 'insert into Config (Clau,Valor) values ("' + Clau + '","' + Valor + '")'
  else:
    sql = 'update Config set Valor = "' + Valor + '" where Clau = "' + Clau + '"'
  sltgl.curd.execute(sql,())

# VB2PY (UntranslatedCode) Attribute VB_Name = "sltslt"
# VB2PY (UntranslatedCode) Option Explicit
