#!/usr/bin/python
# -*- coding: latin-1 -*-

#
# Formas de llamar a sltsrv desde la lnea de comandos
#
# sltsrv [-pcPath] [-dxxx] [-exxx] [-xppath]:
#                  -p: cPath==directorio donde estn las bases de datos
#                  -d: prints informativos (stdout)
#                  -dfich: prints informativos a fichero fich
#                  -e: prints errores (stderr)
#                  -efich: prints errores a fichero fich
#                  -xppath: ppath es una lista a aadir a pythonpath==[path1,path2,...]
import sys
import os

sys.path.extend(["/usr/lib","/usr/share/salt-server","/usr/share/salt-server/py"]) 

_esfr=None
_esprod=None
for _arg in sys.argv:
  if _arg[0:2]=="-x":
    _ppath=eval(_arg[2:])
    for _pp in _ppath:
      sys.path.append(os.path.abspath(_pp))
  elif _arg[0:5]=="-frno":
    _esfr=False
  elif _arg[0:5]=="-frsi":
    _esfr=True
  elif _arg[0:8]=="-fprodno":
    _esprod=False
    
import time
import socket
import threading
import bsddb
import pickle
import stat

import sltgl
import sltgen
import sltslt
import sltsalt
import slttrad
import sltcorr
import sltloc
import slttrad2
import slttradi
import slttrad2i
import sltutil
import vbfunctions

#Constantes que identifican la versin
sltversion="4.1.49"
#sltdate=time.localtime(os.path.getctime(os.path.abspath(__file__)))

#Constante que indica si se trata de una versin de produccin (True) o debug (False)
esprod=True
if _esprod!=None:
  esprod=_esprod
if not esprod:
  sltgl.dbg=True
  #sltgl.es_srv_a=False
  #sltgl.es_popen=False

#Constante que indica si hay que realizar la pasada de traduccin por frases
esfr=True
if _esfr!=None:
  esfr=_esfr

#Constantes que definen la estructura de cada elemento de colTx
tx_paltext=0
tx_nordori=1
tx_carfinpal=2
tx_italica=3
tx_italicaori=4
class infopal:
  def __init__(self):
    self.paltext = vbfunctions.String()
    self.paldic = vbfunctions.String()
    self.pre = vbfunctions.String()
    self.sepsil = vbfunctions.Integer()
    self.pal1 = vbfunctions.String()
    self.pal2 = vbfunctions.String()
    self.tipopost = vbfunctions.Integer()
    self.post = vbfunctions.String()
    self.xi = vbfunctions.Integer()
    self.tipoletra = vbfunctions.Integer()
    self.signopunt = vbfunctions.Integer()
    self.postsignopunt = vbfunctions.Integer()
    self.carfinpal = vbfunctions.String()
    self.italica = vbfunctions.Integer()
    self.italicaori = vbfunctions.Integer()
    self.palori = vbfunctions.String()
    self.nordori = vbfunctions.Long()
    self.ipaldu = vbfunctions.Long()

def ini():
  global Trad,Corr,Trad2i,VerModalidad_,OpConfigCargar
  Trad=slttrad.Trad
  Corr=sltcorr.Corr
  Trad2i=slttrad2i.Trad2i
  VerModalidad_=sltslt.VerModalidad_
  OpConfigCargar=sltslt.OpConfigCargar
  global RSet,ByRef,InStr,Trim
  RSet=sltgen.RSet
  ByRef=sltgen.ByRef
  InStr=sltgen.InStr
  Trim=sltgen.Trim
  global AbrirBd,BdClone,CerrarBd,PalTextIni,DamePalabra,Palabra,NumEnLista,MsgPrint
  AbrirBd=sltgen.AbrirBd
  BdClone=sltgen.BdClone
  CerrarBd=sltgen.CerrarBd
  PalTextIni=sltgen.PalTextIni
  DamePalabra=sltgen.DamePalabra
  Palabra=sltgen.Palabra
  NumEnLista=sltgen.NumEnLista
  MsgPrint=sltgen.MsgPrint
  #global infopal
  #infopal=sltsalt.sltsalt.infopal

def Unpicklar(datos):
  #Obtener la estructura de datos segn el comando
  #La funcin devuelve el comando como una tupla (comando,subcomandos)
  #.. y tambin actualiza variables globales
  com,masdatos=eval(datos)
  if com=='trad' or com=='tradi' or com=='corr' or com=='rev' or com=='revi':
    lsTx,sltgl.lspals.colPalDu=masdatos
    sltgl.lspals.colTx=[]
    for tx in lsTx:
      paltx=infopal()
      paltx.paltext=tx[tx_paltext]
      paltx.palori=tx[tx_paltext]
      paltx.nordori=tx[tx_nordori]
      paltx.carfinpal=tx[tx_carfinpal]
      paltx.italica=tx[tx_italica]
      paltx.italicaori=tx[tx_italicaori]
      sltgl.lspals.InfCompl(paltx)
      sltgl.lspals.colTx.append(paltx)
    return (com,None)
  elif com=='txtrad' or com=='txtradi' or com=='txcorr':
    txt,sltgl.lspals.colPalDu=masdatos
    sltgl.lspals.colTx=[]
    lsTx=TxtaLista(txt)
    for tx in lsTx:
      paltx=infopal()
      paltx.paltext=tx[tx_paltext]
      paltx.palori=tx[tx_paltext]
      paltx.nordori=tx[tx_nordori]
      paltx.carfinpal=tx[tx_carfinpal]
      paltx.italica=tx[tx_italica]
      paltx.italicaori=tx[tx_italicaori]
      sltgl.lspals.InfCompl(paltx)
      sltgl.lspals.colTx.append(paltx)
    return (com,None)
  else:
    return (com,masdatos)

def Unpicklar1(datos):
  #Unpiclar la informacin recibida
  #Entrada: datos: Cadena recibida
  #Retorno: (comando,masdatos) masdatos es el resto de la informacin segn sea el comando
  return eval(datos)

def Unpicklar2(com,masdatos):
  #Unpiclar la informacin recibida
  #Entrada: com: Comando recibido
  #         masdatos: (colTx,colPalDu) es el resto de la informacin que
  #                   hay que guardar en variables globales (en el caso de comandos tipo trad)
  sltgl.lspals.ipa=0
  if com=='trad' or com=='tradi' or com=='corr' or com=='rev' or com=='revi':
    lsTx,sltgl.lspals.colPalDu=masdatos
    sltgl.lspals.colTx=[]
    for tx in lsTx:
      paltx=infopal()
      paltx.paltext=tx[tx_paltext]
      paltx.palori=tx[tx_paltext]
      paltx.nordori=tx[tx_nordori]
      paltx.carfinpal=tx[tx_carfinpal]
      paltx.italica=tx[tx_italica]
      paltx.italicaori=tx[tx_italicaori]
      sltgl.lspals.InfCompl(paltx)
      sltgl.lspals.colTx.append(paltx)
  elif com=='txtrad' or com=='txtradi' or com=='txcorr':
    txt,sltgl.lspals.colPalDu=masdatos
    sltgl.lspals.colTx=[]
    lsTx=TxtaLista(txt)
    for tx in lsTx:
      paltx=infopal()
      paltx.paltext=tx[tx_paltext]
      paltx.palori=tx[tx_paltext]
      paltx.nordori=tx[tx_nordori]
      paltx.carfinpal=tx[tx_carfinpal]
      paltx.italica=tx[tx_italica]
      paltx.italicaori=tx[tx_italicaori]
      sltgl.lspals.InfCompl(paltx)
      sltgl.lspals.colTx.append(paltx)
  
def Picklar(com,masdatos):
  #Componer segn comando
  if com=='trad' or com=='tradi' or com=='corr' or com=='rev' or com=='revi' or com=='void':
    #Afinar palabras dudosas
    for m in sltgl.lspals.colPalDu.keys():
      i=m
      if i>len(sltgl.lspals.colTx)-1:
        i=len(sltgl.lspals.colTx)-1
      #if sltgl.lspals.colPalDu[m]['Clave']!=sltgl.lspals.colTx[i].paldic:
      if sltgl.lspals.colPalDu[m]['Clave']!=sltgl.lspals.colTx[i].paltext:
        #Hay que afinar
        n=sltgl.lspals.colPalDu[m]['Clave'].count(' ')+1
        k=-1
        for j in range(-2,2):
          if i+j>=0 and i+j+n-1<len(sltgl.lspals.colTx):
            pal=paldic=""
            for jj in range(n):
              pal=pal+" "+sltgl.lspals.colTx[i+j+jj].paltext
              paldic=paldic+" "+sltgl.lspals.colTx[i+j+jj].paldic
            pal=pal.strip()
            paldic=paldic.strip()
            if sltgl.lspals.colPalDu[m]['Clave']==pal or sltgl.lspals.colPalDu[m]['Clave']==paldic:
              k=i+j
              break
        if k>-1 and k!=m:
          #Se ha encontrado una palabra que coincide
          sltgl.lspals.colPalDu[k]=sltgl.lspals.colPalDu[m]
          sltgl.lspals.colPalDu[k]['pos']=k
          del sltgl.lspals.colPalDu[m]
        elif k==-1:
          #No se ha encontrado una palabra que coincida
          del sltgl.lspals.colPalDu[m]

    #Componer lista de palabras
    lsTx=[]
    for paltx in sltgl.lspals.colTx:
      tx=(paltx.paltext,paltx.nordori,paltx.carfinpal,paltx.italica,paltx.italicaori)
      lsTx.append(tx)
    datos=str((com,(lsTx,sltgl.lspals.colPalDu)))
  elif com=='txtrad' or com=='txtradi' or com=='txcorr':
    for m in sltgl.lspals.colPalDu.keys():
      newkey=sltgl.lspals.colPalDu[m]['Clave']+"_("+str(m)+")"
      sltgl.lspals.colPalDu[newkey]=sltgl.lspals.colPalDu[m]
      del sltgl.lspals.colPalDu[m]
    
    #Componer lista de palabras
    lsTx=[]
    for paltx in sltgl.lspals.colTx:
      tx=(paltx.paltext,paltx.nordori,paltx.carfinpal,paltx.italica,paltx.italicaori)
      lsTx.append(tx)
    txt=ListaaTxt(lsTx)
    datos=str((com,(txt,sltgl.lspals.colPalDu)))
  else:
    datos=str((com,masdatos))
  return datos

def Picklar1(com,masdatos):
  #Obtener la cadena de respuesta
  #Entrada: com: comando
  #         masdatos: informacin adicional
  #Retorno: Cadena de respuesta
  return str((com,masdatos))

def Picklar2(com):
  #Obtener informacin adicional a partir de las variables globales en caso de comandos tipo trad
  #Entrada: com: Comando
  #Retorno: (colTx,colPalDu) a partir de informacin en memoria
  if com=='trad' or com=='tradi' or com=='corr' or com=='rev' or com=='revi' or com=='void':
    #Afinar palabras dudosas
    for m in sltgl.lspals.colPalDu.keys():
      i=m
      if i>len(sltgl.lspals.colTx)-1:
        i=len(sltgl.lspals.colTx)-1
      #if sltgl.lspals.colPalDu[m]['Clave']!=sltgl.lspals.colTx[i].paldic:
      if sltgl.lspals.colPalDu[m]['Clave']!=sltgl.lspals.colTx[i].paltext:
        #Hay que afinar
        n=sltgl.lspals.colPalDu[m]['Clave'].count(' ')+1
        k=-1
        for j in range(-2,2):
          if i+j>=0 and i+j+n-1<len(sltgl.lspals.colTx):
            pal=paldic=""
            for jj in range(n):
              pal=pal+" "+sltgl.lspals.colTx[i+j+jj].paltext
              paldic=paldic+" "+sltgl.lspals.colTx[i+j+jj].paldic
            pal=pal.strip()
            paldic=paldic.strip()
            if sltgl.lspals.colPalDu[m]['Clave']==pal or sltgl.lspals.colPalDu[m]['Clave']==paldic:
              k=i+j
              break
        if k>-1 and k!=m:
          #Se ha encontrado una palabra que coincide
          sltgl.lspals.colPalDu[k]=sltgl.lspals.colPalDu[m]
          sltgl.lspals.colPalDu[k]['pos']=k
          del sltgl.lspals.colPalDu[m]
        elif k==-1:
          #No se ha encontrado una palabra que coincida
          del sltgl.lspals.colPalDu[m]

    #Componer lista de palabras
    lsTx=[]
    for paltx in sltgl.lspals.colTx:
      tx=(paltx.paltext,paltx.nordori,paltx.carfinpal,paltx.italica,paltx.italicaori)
      lsTx.append(tx)
    return (lsTx,sltgl.lspals.colPalDu)
  elif com=='txtrad' or com=='txtradi' or com=='txcorr':
    for m in sltgl.lspals.colPalDu.keys():
      newkey=sltgl.lspals.colPalDu[m]['Clave']+"_("+str(m)+")"
      sltgl.lspals.colPalDu[newkey]=sltgl.lspals.colPalDu[m]
      del sltgl.lspals.colPalDu[m]
    
    #Componer lista de palabras
    lsTx=[]
    for paltx in sltgl.lspals.colTx:
      tx=(paltx.paltext,paltx.nordori,paltx.carfinpal,paltx.italica,paltx.italicaori)
      lsTx.append(tx)
    txt=ListaaTxt(lsTx)
    return (txt,sltgl.lspals.colPalDu)
  
def TxtaLista(txt):
  #Obtener lista de palabras a partir de un texto
  #Entrada: Texto a pasar a lista
  #Retorno: Lista de palabras del texto
  colTx=[]
  lspals=txt.split()
  i=0
  for pal in lspals:
    if ",;:.?!".find(pal[-1])>-1:
      p1=pal[0:-1]
      s=pal[-1]
      p2=s
    elif "".find(pal[0])>-1:
      p1=pal[0]
      s=pal[0]
      p2=pal[1:]
    else:
      p1=pal
      s=" "
      p2=""
    txpal=(p1,i,s,0,0)
    colTx.append(txpal)
    i=i+1
    if p2!="":
      txpal=(p2,i," ",0,0)
      colTx.append(txpal)
      i=i+1
  return colTx

def ListaaTxt(colTx):
  #Convertir lista de palabras a texto
  #Entrada: colTx: Lista de palabras
  #Retorno: texto correspondiente a colTx
  txt=""
  for e in colTx:
    if txt!="" and e[0]!="." and e[0]!="," and e[0]!=";" and e[0]!=":" and e[0]!="?" and e[0]!="!":
      txt=txt+" "
    txt=txt+e[0]
  return txt
  
def Escuchar():
  #Crear socket y escuchar peticiones
  #Mensajes: (comando,lspals,ls_paldu)
  #tf=0
  ds=None
  sck=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
  sck.bind(('',sltgl.port_mio))
  sck.listen(1)
  while True:
    try:
      if sltgl.dbg:
        print sltgl.port_mio,"esperant conexi"
      con,adr=sck.accept()
      if sltgl.dbg:
        print sltgl.port_mio,"conectat:",con,adr
      if sltgl.es_srv_a and esprod:
        if sltgl.es_popen:
          if esprod:
            t=threading.Thread(target=Pasarelap,args=(con,adr))
            t.start()
          else:
            Pasarelap(con,adr)
        else:
          if esprod:
            t=threading.Thread(target=Pasarela,args=(con,adr))
            t.start()
          else:
            Pasarela(con,adr)        
      else:
        if esprod:
          t=threading.Thread(target=Pasarelai,args=(con,adr))
          t.start()
        else:
          Pasarelai(con,adr)
      #tff=time.clock()
      if sltgl.dbg:
        print sltgl.port_mio,"desconectat" #,". Total(sec):",tff-tii
    except:
      sck.close()
      if sltgl.dbg:
        print sltgl.port_mio,"Error:",sys.exc_info()[0]
      raise

def Escucharp():
  #Escuchar peticiones desde pipe
  #Mensajes: (comando,lspals,ls_paldu)
  #tf=0
  while True:
    ds=None
    datos=Procesar(datos=sys.stdin.readline().rstrip('\n'))
    sys.stdout.write(datos+'\n')
    sys.stdout.flush()
  sys.exit()

def Procesar(datos):
  #Procesar comandos recibidos
  #Entrada: datos: cadena de comandos recibida
  #Retorno: cadena de comandos procesada
  #tii=time.clock()
  yo=threading.currentThread().getName()+">"
  ds=None
  while True:
    if not datos:
      if sltgl.dbg:
        print yo,"sense dades"
      break
    #comando,sltgl.lspals.colTx,sltgl.lspals.colPalDu=cPickle.loads(datos)
    comando,masdatos=Unpicklar1(datos)
    sltgl._t={9:0,0:0,1:0,2:0,3:0,4:0}
    ti=time.clock()
    if sltgl.dbg:
      print "--------"+yo+"petici: --------"
      print comando,len(datos),datos #," te:",ti-tf," ve:",(len(sltgl.lspals.colTx))/(ti-tf)
    sltgl.lspals.ipa=0
    sltgl.papalerr=""
    #tii=time.clock()
    if comando=="trad" or comando=="tradi" or comando=="txtrad" or comando=="txtradi":
      #Trad directa o inversa
      if comando=="tradi" or comando=="txtradi":
        dtr=sltgl.dtrvalcas
      else:
        dtr=sltgl.dtrcasval
              
      ##A los elementos de colTx no se les ha pasaado InfCompl()
      #for paltx in sltgl.lspals.colTx:
        #sltgl.lspals.InfCompl(paltx)
              
      #Traducir del castellano al valenciano
      BdClone(dtr)
      sltgl.ctvnivel=sltgl.CTV_QUALITAT
      sltgl.npaldesco=0
      if esfr:
        fr.BdClone(dtr)
        fr.comactual=comando #Guardar comando recibido
        masdatos=fr.Traduce(dtr,masdatos[0])
      else:
        sltgl.lspals.Unpicklar2(comando,masdatos)
        Trad()
        masdatos=sltgl.lspals.Picklar2(comando)
      
      #Ver es frase o prrafo en idioma <> origen
      #npaltot=len(sltgl.lspals.colTx)
      npaltot=len(masdatos[0])
      if npaltot==0:
        npaltot=1
      if sltgl.npaldesco*100/npaltot>sltgl.void_percent and npaltot>sltgl.void_npalmin:
        comando="void"
    elif comando=="corr" or comando=="txcorr":
      Unpicklar2(comando,masdatos)
      #Correccin
      dtr=sltgl.dtrcasval
              
      ##A los elementos de colTx no se les ha pasaado InfCompl()
      #for paltx in sltgl.lspals.colTx:
        #sltgl.lspals.InfCompl(paltx)
              
      #Corregir valenciano
      BdClone(dtr)
      sltgl.ctvnivel=sltgl.CTV_QUALITAT
      Corr()
      masdatos=Picklar2(comando)
    elif comando=="rev" or comando=="revi":
      Unpicklar2(comando,masdatos)
      #Trad directa o inversa
      if comando=="revi":
        dtr=sltgl.dtrvalcas
      else:
        dtr=sltgl.dtrcasval
              
      ##A los elementos de colTx no se les ha pasaado InfCompl()
      #for paltx in sltgl.lspals.colTx:
        #sltgl.lspals.InfCompl(paltx)
              
      #Revisar
      BdClone(dtr)
      sltgl.enrevisio=True
      _optma=sltgl.optma
      sltgl.optma=False
      if comando=="revi":
        Trad2i()
      else:
        Corr()
      sltgl.optma=_optma
      sltgl.enrevisio=False
      masdatos=Picklar2(comando)
    elif comando == "void":
      pass
    elif comando == "verbs":
      inf,cv,lsvbs=masdatos
      if lsvbs!=[]:
        sltutil.tmpVerbs(lsvbs)
      lsvbs=sltutil.Verb(inf,cv)
      masdatos=(inf,cv,lsvbs)
    elif comando == "dicsalt":
      lema,tl,tmp=masdatos
      sltutil.tmpDicSalt(tmp)
      if not isinstance(ds,sltutil.DicSalt):
        ds=sltutil.DicSalt()
      if lema=="_lista":
        tmp=ds.Lista(tl)
	# Patch for Sovietic Solution
	import shutil
	old_file_dicsalt="/usr/share/salt-old-files/tmpdsa"
	shutil.copyfile(old_file_dicsalt,tmp)
      else:
        tmp=ds.Seek(lema)
      masdatos=(lema,tl,tmp)
    elif comando == "dicbil":
      lema,tl,tmp=masdatos
      sltutil.tmpDicBil(tmp)
      if not isinstance(ds,sltutil.DicBil):
        ds=sltutil.DicBil()
      if lema=="_lista":
        tmp=ds.Lista(tl)
	# Patch for Sovietic Solution
	import shutil
	old_file_dicsalt="/usr/share/salt-old-files/tmpdsb"
	shutil.copyfile(old_file_dicsalt,tmp)
      else:
        tmp=ds.Seek(lema,tl)
      masdatos=(lema,tl,tmp)
    elif comando == "cfgload":
      #Obtener fichero de configuracin del servidor
      masdatos=sltslt.ConfigLoad()
    elif comando == "cfgsave":
      #Guardar informacin de configuracin
      sltslt.ConfigSave(masdatos)
      #Cargar en memoria
      sltslt.OpConfigCargar()
      masdatos=""
    elif comando == "vers":
      masdatos="Salt "+sltversion+" "+str(sltDate())+" "+str(esprod)+" "+str(esfr)
    elif comando == "credits":
      masdatos=sltslt.Credits()
    elif comando == "eixir":
      sys.exit(0)
            
    #Respuesta
    #datos=cPickle.dumps((comando,sltgl.lspals.colTx,sltgl.lspals.colPalDu))
    datos=Picklar1(comando,masdatos)
    tf=time.clock()
    if sltgl.dbg:
      if tf==ti:
        tf=ti+0.000001
      print "-------"+yo+"resposta: --------"
      print comando,len(datos),len(sltgl.locpals),len(sltgl.colval),datos," tr:",tf-ti," v:",(len(sltgl.lspals.colTx))/(tf-ti) #,sltgl._t,len(sltgl.locpals),len(sltgl.colval)
      _npfr,_npstd=fr.npalfr,fr.npalstd
      _nptot=_npfr+_npstd
      if _nptot>0:
        print "** Frases: %.2f %% ; Standard: %.2f %%" %(_npfr*100/_nptot,_npstd*100/_nptot)
    return datos
  
def Procesar_copia(datos):
  #Procesar comandos recibidos
  #Entrada: datos: cadena de comandos recibida
  #Retorno: cadena de comandos procesada
  #tii=time.clock()
  yo=threading.currentThread().getName()+">"
  ds=None
  while True:
    if not datos:
      if sltgl.dbg:
        print yo,"sense dades"
      break
    #comando,sltgl.lspals.colTx,sltgl.lspals.colPalDu=cPickle.loads(datos)
    comando,masdatos=Unpicklar(datos)
    sltgl._t={9:0,0:0,1:0,2:0,3:0,4:0}
    ti=time.clock()
    if sltgl.dbg:
      print "--------"+yo+"petici: --------"
      print comando,len(datos),datos #," te:",ti-tf," ve:",(len(sltgl.lspals.colTx))/(ti-tf)
    sltgl.lspals.ipa=0
    sltgl.papalerr=""
    #tii=time.clock()
    if comando=="trad" or comando=="tradi" or comando=="txtrad" or comando=="txtradi":
      #Trad directa o inversa
      if comando=="tradi" or comando=="txtradi":
        dtr=sltgl.dtrvalcas
      else:
        dtr=sltgl.dtrcasval
              
      ##A los elementos de colTx no se les ha pasaado InfCompl()
      #for paltx in sltgl.lspals.colTx:
        #sltgl.lspals.InfCompl(paltx)
              
      #Traducir del castellano al valenciano
      BdClone(dtr)
      sltgl.ctvnivel=sltgl.CTV_QUALITAT
      sltgl.npaldesco=0
      Trad()
      
      #Ver es frase o prrafo en idioma <> origen
      npaltot=len(sltgl.lspals.colTx)
      if npaltot==0:
        npaltot=1
      if sltgl.npaldesco*100/npaltot>sltgl.void_percent and npaltot>sltgl.void_npalmin:
        comando="void"
    elif comando=="corr" or comando=="txcorr":
      #Correccin
      dtr=sltgl.dtrcasval
              
      ##A los elementos de colTx no se les ha pasaado InfCompl()
      #for paltx in sltgl.lspals.colTx:
        #sltgl.lspals.InfCompl(paltx)
              
      #Corregir valenciano
      BdClone(dtr)
      sltgl.ctvnivel=sltgl.CTV_QUALITAT
      Corr()
    elif comando=="rev" or comando=="revi":
      #Trad directa o inversa
      if comando=="revi":
        dtr=sltgl.dtrvalcas
      else:
        dtr=sltgl.dtrcasval
              
      ##A los elementos de colTx no se les ha pasaado InfCompl()
      #for paltx in sltgl.lspals.colTx:
        #sltgl.lspals.InfCompl(paltx)
              
      #Revisar
      BdClone(dtr)
      sltgl.enrevisio=True
      _optma=sltgl.optma
      sltgl.optma=False
      if comando=="revi":
        Trad2i()
      else:
        Corr()
      sltgl.optma=_optma
      sltgl.enrevisio=False
    elif comando == "void":
      pass
    elif comando == "verbs":
      inf,cv,lsvbs=masdatos
      if lsvbs!=[]:
        sltutil.tmpVerbs(lsvbs)
      lsvbs=sltutil.Verb(inf,cv)
      masdatos=(inf,cv,lsvbs)
    elif comando == "dicsalt":
      lema,tl,tmp=masdatos
      sltutil.tmpDicSalt(tmp)
      if not isinstance(ds,sltutil.DicSalt):
        ds=sltutil.DicSalt()
      if lema=="_lista":
        tmp=ds.Lista(tl)
      else:
        tmp=ds.Seek(lema)
      masdatos=(lema,tl,tmp)
    elif comando == "dicbil":
      lema,tl,tmp=masdatos
      sltutil.tmpDicBil(tmp)
      if not isinstance(ds,sltutil.DicBil):
        ds=sltutil.DicBil()
      if lema=="_lista":
        tmp=ds.Lista(tl)
      else:
        tmp=ds.Seek(lema,tl)
      masdatos=(lema,tl,tmp)
    elif comando == "cfgload":
      #Obtener fichero de configuracin del servidor
      masdatos=sltslt.ConfigLoad()
    elif comando == "cfgsave":
      #Guardar informacin de configuracin
      sltslt.ConfigSave(masdatos)
      #Cargar en memoria
      sltslt.OpConfigCargar()
      masdatos=""
    elif comando == "vers":
      masdatos="Salt "+sltversion+" "+str(sltDate())+" "+str(esprod)+" "+str(esfr)
    elif comando == "credits":
      masdatos=sltslt.Credits()
    elif comando == "eixir":
      sys.exit(0)
            
    #Respuesta
    #datos=cPickle.dumps((comando,sltgl.lspals.colTx,sltgl.lspals.colPalDu))
    datos=Picklar(comando,masdatos)
    tf=time.clock()
    if sltgl.dbg:
      if tf==ti:
        tf=ti+0.000001
      print "-------"+yo+"resposta: --------"
      print comando,len(datos),len(sltgl.locpals),len(sltgl.colval),datos," tr:",tf-ti," v:",(len(sltgl.lspals.colTx))/(tf-ti) #,sltgl._t,len(sltgl.locpals),len(sltgl.colval)
    return datos

def sltDate():
  #Fecha de la aplicacin
  ultfecha=fecha=None
  if os.path.exists(os.path.abspath(sltgl.miPath+"/sltsrv.exe")):
    return time.localtime(os.stat(os.path.abspath(sltgl.miPath+"/sltsrv.exe"))[8])
  elif os.path.exists(os.path.abspath(sltgl.miPath+"/sltsrv.py")):
    return time.localtime(os.stat(os.path.abspath(sltgl.miPath+"/sltsrv.py"))[8])
  else:
    for dp,dns,fns in os.walk(os.path.abspath(sltgl.miPath)):
      for fn in fns:
        if fn[-4:]==".pyc" or fn[-3:]==".py":
          fecha=time.localtime(os.stat(os.path.abspath(dp+"/"+fn))[8])
          if ultfecha==None:
            ultfecha=fecha
          elif fecha > ultfecha:
            ultfecha=fecha
      break
    return fecha

def DameServer():
  #Obtener el primer servidor libre de la lista
  #Retorno: sck: Socket del servidor
  sck=None
  yo=threading.currentThread().getName()
  port=0
  sltgl.lck.acquire()
  if sltgl.dbg:
    print sltgl.port_mio,"server?",sltgl.port_lst
  LimpiaServer()
  for  srv in sltgl.port_lst:
    if srv[0]:
      #Esta libre
      port=srv[1]
      srv[0]=False
      srv[2]=yo
      break
   
  if port==0:
    #No quedan servidores: aadir otro
    if len(sltgl.port_lst)>0:
      port=srv[1]+1
    else:
      port=sltgl.port_ini
    #Antes de aadirlo comprobar si ya esta escuchando
    sck=Conectar(port)
    if sck==None:
      #No escucha: iniciar server
      sltsrvexe=sys.executable
      sltsrvargs=sys.argv
      if sltsrvargs[0]!=sltsrvexe:
        sltsrvargs=[sltsrvexe]+sltsrvargs
      sltsrvargs.append("-n"+repr(port))
      if sltgl.esLinux:
        modo=os.P_NOWAIT
      else:
        modo=os.P_DETACH
      #sltsrvargs.append("-t") #aadir para trace en disco
      os.spawnve(modo,sltsrvexe,sltsrvargs,os.environ)
      #str=argsAString(sltsrvargs)
      #w=os.popen(str,"w")
      #w=os.popen("c:\salt4\sltsrv_n -n"+repr(port))
    
    #Aadir a la lista
    sltgl.port_lst.append([False,port,yo])
    
  if sltgl.dbg:
    print sltgl.port_mio,"server:",sltgl.port_lst
    
  sltgl.lck.release()
  
  #Obtener socket
  sck=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
  while sck.connect_ex(('localhost',port)) !=0:
    time.sleep(0.1)
  
  return sck

def DameServerp():
  #Obtener el primer servidor libre de la lista
  #Retorno: w,r: File objects para escribir y leer
  w,r=None,None # TODO
  yo=threading.currentThread().getName()
  #1. Buscar uno libre
  sltgl.lck.acquire()
  for srv in srv_lst:
    if srv[_srvlibre]:
      srv[_srvlibre]=False
      srv[_srvowner]=yo
      w=srv[_srvw]
      r=srv[_srvr]
      sltgl.lck.release()
      return w,r

  #2. Si no hay libres iniciar otro
  sltsrvexe=sys.executable
  sltsrvargs=sys.argv
  if sltsrvargs[0]!=sltsrvexe:
    sltsrvargs=[sltsrvexe]+sltsrvargs
  sltsrvargs.append("-s")
  sltsrvcmd=""
  for arg in sltsrvargs:
    _arg=arg
    if _arg.find(" ")!=-1:
      _arg='"'+_arg+'"'
    sltsrvcmd=sltsrvcmd+" "+_arg
  sltsrvcmd=sltsrvcmd.strip()
  w,r=os.popen4(sltsrvcmd)

  srv_lst.append([False,yo,w,r,time.clock()])
  sltgl.lck.release()
  return w,r
    
def Conectar(port):
  #Conectar con socket pot port
  #Retorno: sck=socket
  try:
    sck=socket.socket(socket.AF_INET,socket.SOCK_STREAM)
    sck.connect(('localhost',port))
  except:
    sck=None
  
  return sck

def LimpiaServer():
  #Liberar servers que no se usen
  _tmax=10 #Minutos sin uso para cerrar
  if sltgl._ini.Existe("sltsrv","tclose"):
    _tmax=sltgl._ini("sltsrv","tclose")
  while True:
    time.sleep(_tmax*60)
    sltgl.lck.acquire()
    tactual=time.clock()
    for srv in srv_lst:
      if srv[_srvlibre]:
        #Server libre ...
        if tactual-srv[_srvultuso]>_tmax*60:
          #... sin uso ms de _tmax
          if sltgl.dbg:
            print "Closing",srv
          srv[_srvw].close()
          srv[_srvr].close()
          srv_lst.remove(srv)
    
    if sltgl.dbg:
      print "Servers",srv_lst
      
    sltgl.lck.release()      
  
def Pasarela(con,adr):
  #Pasar la peticin a otro server
  #1. Obtener server
  sck=DameServer()
  n=5
  while sck==None:
    time.sleep(0.1)
    sck=DameServer()
    n=n-1
    if n<=0:
      ReleaseServer()
      con.close()
      return
  
  #2.Pasar peticiones al otro server
  yo=threading.currentThread().getName()+">"
  ds=None
  while True:
    if sltgl.dbg:
      print sltgl.port_mio,yo+"esperant petici"
    datos=con.recv(128000)
    if not datos:
      if sltgl.dbg:
        print sltgl.port_mio,yo+"sense dades"
      break
    if sltgl.dbg:
      print sltgl.port_mio,"--------"+yo+"petici: --------"
      print sltgl.port_mio,datos
    
    if datos!="info":
      #Pasar a subserver
      sck.send(datos)
      datos=sck.recv(128000)
    else:
      #Contestar
      datos=repr([sltgl.port_mio,yo,sltgl.port_lst])
    
    #Contestar a cliente
    con.send(datos)
    if sltgl.dbg:
      print sltgl.port_mio,"-------"+yo+"resposta: --------"
      print sltgl.port_mio,datos
  con.close()

  #3. Liberar server
  ReleaseServer()
  sck.close()

def Pasarelap(con,adr):
  #Pasar la peticin a otro server (a travs de popen)
  #1. Obtener server
  w,r=DameServerp()
  #print threading.currentThread().getName(),w,r
  
  #2.Pasar peticiones al otro server
  try:
    yo=threading.currentThread().getName()+">"
    ds=None
    while True:
      if sltgl.dbg:
        print sltgl.port_mio,yo+"esperant petici"
      #print "recibiendo..."
      datos=con.recv(128000)
      #print "recibido"
      if not datos:
        if sltgl.dbg:
          print sltgl.port_mio,yo+"sense dades"
        break
      if sltgl.dbg:
        print sltgl.port_mio,"--------"+yo+"petici: --------"
        print sltgl.port_mio,datos
      
      if datos!="info":
        #Pasar a subserver
        w.write(datos+'\n')
        w.flush()
        datos=r.readline().rstrip('\n')
      else:
        #Contestar
        datos=repr([sltgl.port_mio,yo,sltgl.port_lst])
      
      #Contestar a cliente
      con.send(datos)
      if sltgl.dbg:
        print sltgl.port_mio,"-------"+yo+"resposta: --------"
        print sltgl.port_mio,datos
  
  except:
    pass
  con.close()
  #w.close()
  #r.close()
  ReleaseServerp()

def Pasarelai(con,adr):
  #Simulacin de pasarela para resolver las peticiones internamente (en el mismo programa)
  #Esta funcin se necesita para poder seguir el programa (dedug)
  try:
    yo=threading.currentThread().getName()+">"
    ds=None
    while True:
      if sltgl.dbg:
        print sltgl.port_mio,yo+"esperant petici"
      #print "recibiendo..."
      datos=con.recv(128000)
      #print "recibido"
      if not datos:
        if sltgl.dbg:
          print sltgl.port_mio,yo+"sense dades"
        break
      if sltgl.dbg:
        print sltgl.port_mio,"--------"+yo+"petici: --------"
        print sltgl.port_mio,datos
      
      if datos!="info":
        #Resolver peticin
        datos=Procesar(datos)
      else:
       #Contestar
       datos=repr([sltgl.port_mio,yo,sltgl.port_lst])
      
      #Contestar a cliente
      con.send(datos)
      if sltgl.dbg:
        print sltgl.port_mio,"-------"+yo+"resposta: --------"
        print sltgl.port_mio,datos
  
  except:
    pass
  con.close()
  
def Pasarelaw(datos):
  #Pasar la peticin a otro server (a travs de popen)
  #Esta funcin se usa para web service
  #Entrada: datos: Datos a enviar al subserver
  #Retorno: Respuesta para el cliente
  #1. Obtener server
  yo=threading.currentThread().getName()+">"
  t1=time.clock()
  w,r=DameServerp()
  t2=time.clock()
  if sltgl.dbg:
    print "popen:",t2-t1
    print yo,"------- petici: --------"
    print datos
  #print threading.currentThread().getName(),w,r
  
  #2.Pasar peticiones al otro server
  try:
    ds=None
    if datos!="info":
      #Pasar a subserver
      w.write(datos+'\n')
      w.flush()
      datos=r.readline().rstrip('\n')
    else:
      #Contestar
      datos=repr([yo,srv_lst])
      
  except:
    pass
  t3=time.clock()
  if sltgl.dbg:
    print "Total pasarela:",t3-t1
  
  #ReleaseServerp()
  #w.close()
  #r.close()
  
  #Contestar a cliente
  if sltgl.dbg:
    print yo,"------- resposta: --------"
    print datos
  return datos

def Recv(con=None):
  #Recibir un mensaje de pipe o socket
  try:
    if con==None:
      #pipe
      datos=sys.stdin.readline().rstrip('\n')
    else:
      #socket
      datos=con.recv(128000)
    return datos
  except:
    return False

def Send(datos,con=None):
  #enviar mensaje por pipe o socket
  if con==None:
    #pipe
    sys.stdout.write(datos+'\n')
    sys.stdout.flush()
  else:
    #socket
    con.send(datos)

def Close(con=None):
  if con!=None:
    con.close()
    
def ReleaseServerp():
  #Liberar server actual
  yo=threading.currentThread().getName()
  sltgl.lck.acquire()
  for srv in srv_lst:
    if srv[_srvowner]==yo:
      if sltgl.dbg:
        print yo,"rel server:",srv
      srv[_srvlibre]=True
      srv[_srvowner]=None
      srv[_srvultuso]=time.clock()
      break
  sltgl.lck.release()

def argsAString(args):
  #Pasar argumentos tipo spawn a string tipo linea de comandos
  ret=""
  for arg in args:
    ret=ret+arg+" "
  ret=ret.strip()
  return ret

# ---------------------------------------------------------
# Inicio del programa
# ---------------------------------------------------------

# Iniciar acceso a funciones
ini()

#Inicio del programa
if sltgl.dbg:
  print "**",sys.executable, sys.argv
  print threading.currentThread().getName(),"Salt", sltversion, sltDate(), esprod, esfr
  
#Iniciar acceso a funciones
ini()
slttrad.ini()
sltsalt.ini()
sltgen.ini()
sltgl.ini()
sltloc.ini()
sltcorr.ini()
slttrad2.ini()
slttradi.ini()
slttrad2i.ini()

#Modalidad de trabajo
VerModalidad_()

#Abrir las tablas ms usuales de la base de datos
AbrirBd()

#Por defecto castella > valenci
BdClone(sltgl.dtrcasval)

#Obtener las opciones de configuracin
OpConfigCargar()

#Actualizamos modalidad por si ha habido cambios en OpConfigCargar
VerModalidad_()

#Marcas devueltas por TEXT.BAS en PalText() !!!!
sltgl.marcaapo = chr(19)
sltgl.marcaapogui = chr(20)
sltgl.marcagui = chr(21)
sltgl.marcaxi = chr(22)

#Inicializar arrays
sltgl.lspals=sltsalt.sltsalt()
sltgl.lspals.colPalDu = {}

#Borrar diccionario temporal
r=RSet(sltgl.bd_temporal_VeuTemporal)
r.Clear()
r.Close()

#Borrar diccionario temporal (traductor)
r=RSet(sltgl.bd_temporaltrad_VeuOri)
r.Clear()
r.Close()

#Acceso a frases
import sltfr
fr=sltfr.Frases()
fr.AbrirBd()

sltgl.lck=threading.Lock()

#Atencin: activar psyco en produccin
if esprod:
  try:
    import psyco
    if sltgl.es_srv_a:
      psyco.bind(Escuchar,300)
    else:
      psyco.bind(Escucharp,300)
  except:
    pass

if sltgl.es_srv_a:
  #Acceso a subservers (popen)
  srv_lst=[] #Lista de servidores
  _srvlibre=0 #Servidor libre Si/No
  _srvowner=1 #Nombre del thread que lo est usando
  _srvw=2 #pipe de escritura
  _srvr=3 #pipe de lectura
  _srvultuso=4 #Hora de ltimo uso
  
  #Thread para cancelar subservers
  solouno=True
  if esprod and solouno:
    solouno=False
    tLimpiaServer=threading.Thread(target=LimpiaServer,args=())
    tLimpiaServer.start()
  
  Escuchar()
else:
  Escucharp()

