import pyinotify
import os
import sys
import multiprocessing
import gettext
import lliurex.net
import socket
import xmlrpclib
import psutil

from PyQt4.QtGui import QMainWindow, QApplication

import window_shutdown


class Announcer(object):
    """docstring for Announcer"""

    def __init__(self):
        super(Announcer, self).__init__()
        home = os.environ['HOME']
        user = os.environ['USER']
        aux_cmdline = ['python', '/usr/share/scheduled-shutdown-client/core.py']
        my_pid = os.getpid()
        process_list = psutil.get_process_list()
        for x in process_list:
            if x.pid == my_pid:
                continue
            if not x.is_running():
                continue
            if x.cmdline == aux_cmdline:
                if x.username == user:
                    sys.exit(0)
        share = gettext.translation('xdg-user-dirs',os.environ['LANG']).gettext('Share')
        self.path = os.path.join(home, share,".notifications")
        if not os.path.exists(self.path):
            os.makedirs(self.path)
        else:
            serverip = socket.gethostbyname('server')
            if serverip in os.listdir(self.path):
                aux_path = os.path.join(self.path, str(serverip))
                p = multiprocessing.Process(target=self.notification, args=(aux_path,))
                p.daemon = True
                p.start()


    def notification(self, path):
        c = xmlrpclib.ServerProxy('https://server:9779')
        if c.get_status('', 'ShutdownManager'):
            fd = open(path, 'r')
            shutdown_time = fd.readline()
            fd.close()
            app = QApplication(sys.argv)
            window = QMainWindow()
            x = window_shutdown.Ui_MainWindow(shutdown_time)
            x.setupUi(window)
            window.show()
            app.exec_()

    def watcher(self):
        class ProcessOptions(pyinotify.ProcessEvent):

            def __init__(self, ntm):
                self.ntm = ntm

            def notify(self, event):
                server_ip = lliurex.net.get_ip_from_host("server")
                if server_ip == "127.0.1.1":
                    server_ip = event.name
                if str(server_ip) != event.name:
                    return 0
                path = os.path.join(event.path, event.name)
                self.ntm.notification(path)

            def process_IN_CLOSE_WRITE(self, event):
                p = multiprocessing.Process(target=self.notify, args=(event,))
                p.daemon = True
                p.start()


        wm = pyinotify.WatchManager()
        notifier = pyinotify.Notifier(wm, ProcessOptions(self))
        wm.add_watch(self.path, pyinotify.EventsCodes.ALL_FLAGS["IN_CLOSE_WRITE"])

        while True:

            notifier.process_events()
            if notifier.check_events():
                notifier.read_events()
            notifier.process_events()


x = Announcer()
x.watcher()


