import subprocess
import os
import datetime
import lliurex.net


class ShutdownManager(object):
    """docstring for ShutdownManager"""

    def __init__(self):
        super(ShutdownManager, self).__init__()
        self.status = "running"
        self.share_path = '/net/server-sync/share'

    def shutdown_with_notify(self, time):
        """
            time is on minutes
        """
        try:
            aux_time = int(time)
        except Exception as e:
            return {"status": False, "msg": "time isn't valid number"}
        self.__write_token__(aux_time)
        subprocess.Popen(['shutdown', '-h', str(aux_time)])
        return {"status": True, "msg": "Server is shutdown in " + str(aux_time) + " minutes"}

    def reboot_with_notify(self, time):
        """
            time is on minutes
        """
        try:
            aux_time = int(time)
        except Exception as e:
            return {"status": False, "msg": "time isn't valid number"}
        self.__write_token__(aux_time)
        subprocess.Popen(['shutdown', '-r', str(aux_time)])
        return {"status": True, "msg": "Server is shutdown in " + str(aux_time) + " minutes"}


    def get_status(self):
        if os.path.exists('/run/shutdown.pid'):
            return True
        else:
            return False

    def __write_token__(self, time):
        incremented_date = datetime.datetime.now()
        incremented_date += datetime.timedelta(minutes=time)
        share_path = os.path.join(self.share_path, '.notifications')
        if not os.path.exists(share_path):
            os.makedirs(share_path)
            os.chmod(share_path, 02770)
        int_dev = objects['VariablesManager'].get_variable('INTERNAL_INTERFACE')
        ip_host = lliurex.net.get_ip(int_dev)
        os.system("echo " + incremented_date.strftime("%H:%M:%S") + " > " + os.path.join(share_path, ip_host))
