import xmlrpclib
import os
import sys
from PyQt4.QtGui import QMainWindow, QApplication
from PyQt4 import QtGui
import window_shutdown


class Core(QMainWindow):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.user = os.environ['USER']
        self.n4d = xmlrpclib.ServerProxy('https://localhost:9779')
        self.gui = window_shutdown.Ui_Dialog()
        self.gui.setupUi(self)
        self.show()

    def accept(self):
        self.n4d.create_ticket('', 'NTicketsManager', self.user)
        f = open('/run/n4d/tickets/' + self.user)
        password = f.readline()
        f.close()
        if self.gui.rbshutdown.isChecked():
            self.n4d.shutdown_with_notify((self.user, password), 'ShutdownManager', int(self.gui.timetext.text()))
        elif self.gui.rbreboot.isChecked():
            self.n4d.reboot_with_notify((self.user, password), 'ShutdownManager', int(self.gui.timetext.text()))
        self.close()
    def reject(self):
        pass

    def validate_text(self):
        aux = self.gui.timetext.text()
        try:
            int(aux)
        except:
            self.gui.timetext.setText(aux[:-1])


app = QApplication(sys.argv)
x = Core()
sys.exit(app.exec_())
