/* utils.c generated by valac 0.14.2, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>


#define TYPE_UTILS (utils_get_type ())
#define UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UTILS, Utils))
#define UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UTILS, UtilsClass))
#define IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UTILS))
#define IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UTILS))
#define UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UTILS, UtilsClass))

typedef struct _Utils Utils;
typedef struct _UtilsClass UtilsClass;
typedef struct _UtilsPrivate UtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _Utils {
	GObject parent_instance;
	UtilsPrivate * priv;
};

struct _UtilsClass {
	GObjectClass parent_class;
};


static gpointer utils_parent_class = NULL;
static GHashTable* utils_app_to_desktop_file;
static GHashTable* utils_app_to_desktop_file = NULL;
static gchar** utils_desktop_file_prefixes;
static gint utils_desktop_file_prefixes_length1;
static gchar** utils_desktop_file_prefixes = NULL;
static gint utils_desktop_file_prefixes_length1 = 0;
static gint _utils_desktop_file_prefixes_size_ = 0;

GType utils_get_type (void) G_GNUC_CONST;
enum  {
	UTILS_DUMMY_PROPERTY
};
gchar* utils_get_file_contents (GFile* file);
static void utils_init_desktop_id (void);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static gchar* utils_extract_desktop_id (const gchar* path);
gchar* utils_get_actor_for_desktop_file (const gchar* desktop_file, GDesktopAppInfo** dai);
static void utils_init_application_cache (void);
static void _g_free0_ (gpointer var);
gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype);
gchar* utils_find_desktop_file_for_app (const gchar* app_name, const gchar* mimetype);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
Utils* utils_new (void);
Utils* utils_construct (GType object_type);
static void utils_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar* utils_get_file_contents (GFile* file) {
	gchar* result = NULL;
	gchar* contents = NULL;
	guint8* contents_array = NULL;
	gint contents_array_length1 = 0;
	gint _contents_array_size_ = 0;
	GFile* _tmp0_;
	guint8* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	_tmp3_ = g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error_);
	contents_array = (g_free (contents_array), NULL);
	contents_array = _tmp1_;
	contents_array_length1 = _tmp2_;
	_contents_array_size_ = contents_array_length1;
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		contents_array = (g_free (contents_array), NULL);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (!_tmp4_) {
		result = NULL;
		contents_array = (g_free (contents_array), NULL);
		_g_free0 (contents);
		return result;
	}
	_tmp5_ = g_strdup ((const gchar*) contents_array);
	_g_free0 (contents);
	contents = _tmp5_;
	result = contents;
	contents_array = (g_free (contents_array), NULL);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void utils_init_desktop_id (void) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* session_var = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar** _tmp14_;
	gchar** _tmp15_ = NULL;
	_tmp0_ = utils_desktop_file_prefixes;
	_tmp0__length1 = utils_desktop_file_prefixes_length1;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_getenv ("XDG_CURRENT_DESKTOP");
	session_var = _tmp1_;
	_tmp2_ = session_var;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = session_var;
		g_desktop_app_info_set_desktop_env (_tmp3_);
	} else {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		_tmp4_ = g_getenv ("DESKTOP_SESSION");
		session_var = _tmp4_;
		_tmp5_ = session_var;
		if (_tmp5_ == NULL) {
			g_desktop_app_info_set_desktop_env ("GNOME");
		} else {
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* desktop_session;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = session_var;
			_tmp7_ = g_utf8_strup (_tmp6_, (gssize) (-1));
			desktop_session = _tmp7_;
			_tmp8_ = desktop_session;
			_tmp9_ = g_str_has_prefix (_tmp8_, "GNOME");
			if (_tmp9_) {
				g_desktop_app_info_set_desktop_env ("GNOME");
			} else {
				const gchar* _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp10_ = desktop_session;
				_tmp11_ = g_str_has_prefix (_tmp10_, "KDE");
				if (_tmp11_) {
					g_desktop_app_info_set_desktop_env ("KDE");
				} else {
					const gchar* _tmp12_;
					gboolean _tmp13_ = FALSE;
					_tmp12_ = desktop_session;
					_tmp13_ = g_str_has_prefix (_tmp12_, "XFCE");
					if (_tmp13_) {
						g_desktop_app_info_set_desktop_env ("XFCE");
					} else {
						g_desktop_app_info_set_desktop_env ("GNOME");
					}
				}
			}
			_g_free0 (desktop_session);
		}
	}
	_tmp15_ = _tmp14_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp15_;
		data_dir_collection_length1 = _vala_array_length (_tmp14_);
		for (data_dir_it = 0; data_dir_it < _vala_array_length (_tmp14_); data_dir_it = data_dir_it + 1) {
			const gchar* data_dir = NULL;
			data_dir = data_dir_collection[data_dir_it];
			{
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				_tmp16_ = utils_desktop_file_prefixes;
				_tmp16__length1 = utils_desktop_file_prefixes_length1;
				_tmp17_ = data_dir;
				_tmp18_ = g_build_path (G_DIR_SEPARATOR_S, _tmp17_, "applications", G_DIR_SEPARATOR_S, NULL, NULL);
				_vala_array_add1 (&utils_desktop_file_prefixes, &utils_desktop_file_prefixes_length1, &_utils_desktop_file_prefixes_size_, _tmp18_);
			}
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* utils_extract_desktop_id (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* normalized_path;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_str_has_prefix (_tmp0_, "/");
	if (!_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = path;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = path;
	_tmp5_ = string_replace (_tmp4_, "//", "/");
	normalized_path = _tmp5_;
	_tmp6_ = utils_desktop_file_prefixes;
	_tmp6__length1 = utils_desktop_file_prefixes_length1;
	{
		gchar** prefix_collection = NULL;
		gint prefix_collection_length1 = 0;
		gint _prefix_collection_size_ = 0;
		gint prefix_it = 0;
		prefix_collection = _tmp6_;
		prefix_collection_length1 = _tmp6__length1;
		for (prefix_it = 0; prefix_it < _tmp6__length1; prefix_it = prefix_it + 1) {
			const gchar* prefix = NULL;
			prefix = prefix_collection[prefix_it];
			{
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = normalized_path;
				_tmp8_ = prefix;
				_tmp9_ = g_str_has_prefix (_tmp7_, _tmp8_);
				if (_tmp9_) {
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* without_prefix;
					const gchar* _tmp15_;
					gboolean _tmp16_ = FALSE;
					_tmp10_ = normalized_path;
					_tmp11_ = prefix;
					_tmp12_ = strlen (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = string_substring (_tmp10_, (glong) _tmp13_, (glong) (-1));
					without_prefix = _tmp14_;
					_tmp15_ = without_prefix;
					_tmp16_ = string_contains (_tmp15_, G_DIR_SEPARATOR_S);
					if (_tmp16_) {
						const gchar* _tmp17_;
						gchar* _tmp18_ = NULL;
						_tmp17_ = without_prefix;
						_tmp18_ = string_replace (_tmp17_, G_DIR_SEPARATOR_S, "-");
						result = _tmp18_;
						_g_free0 (without_prefix);
						_g_free0 (normalized_path);
						return result;
					}
					result = without_prefix;
					_g_free0 (normalized_path);
					return result;
				}
			}
		}
	}
	_tmp19_ = path;
	_tmp20_ = g_path_get_basename (_tmp19_);
	result = _tmp20_;
	_g_free0 (normalized_path);
	return result;
}


gchar* utils_get_actor_for_desktop_file (const gchar* desktop_file, GDesktopAppInfo** dai) {
	GDesktopAppInfo* _vala_dai = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GDesktopAppInfo* _tmp6_;
	GDesktopAppInfo* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* desktop_id;
	const gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	utils_init_desktop_id ();
	_tmp0_ = desktop_file;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_;
		GDesktopAppInfo* _tmp3_;
		_tmp2_ = desktop_file;
		_tmp3_ = g_desktop_app_info_new_from_filename (_tmp2_);
		_g_object_unref0 (_vala_dai);
		_vala_dai = _tmp3_;
	} else {
		const gchar* _tmp4_;
		GDesktopAppInfo* _tmp5_;
		_tmp4_ = desktop_file;
		_tmp5_ = g_desktop_app_info_new (_tmp4_);
		_g_object_unref0 (_vala_dai);
		_vala_dai = _tmp5_;
	}
	_tmp6_ = _vala_dai;
	if (_tmp6_ == NULL) {
		result = NULL;
		if (dai) {
			*dai = _vala_dai;
		} else {
			_g_object_unref0 (_vala_dai);
		}
		return result;
	}
	_tmp7_ = _vala_dai;
	_tmp8_ = g_app_info_get_id ((GAppInfo*) _tmp7_);
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		GDesktopAppInfo* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp12_ = _vala_dai;
		_tmp13_ = g_desktop_app_info_get_filename (_tmp12_);
		_tmp14_ = utils_extract_desktop_id (_tmp13_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp14_;
	}
	_tmp15_ = _tmp10_;
	_tmp16_ = g_strdup (_tmp15_);
	desktop_id = _tmp16_;
	_tmp17_ = desktop_id;
	_tmp18_ = g_strdup_printf ("application://%s", _tmp17_);
	result = _tmp18_;
	_g_free0 (desktop_id);
	_g_free0 (_tmp10_);
	if (dai) {
		*dai = _vala_dai;
	} else {
		_g_object_unref0 (_vala_dai);
	}
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void utils_init_application_cache (void) {
	GHashTable* _tmp0_;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = utils_app_to_desktop_file;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		GHashFunc _tmp2_;
		GEqualFunc _tmp3_;
		GHashTable* _tmp4_;
		_tmp2_ = g_str_hash;
		_tmp3_ = g_str_equal;
		_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (utils_app_to_desktop_file);
		utils_app_to_desktop_file = _tmp4_;
	}
}


gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (mimetype != NULL, NULL);
	_tmp0_ = mimetype;
	_tmp1_ = utils_find_desktop_file_for_app ("libreoffice", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp4_ = mimetype;
		_tmp5_ = utils_find_desktop_file_for_app ("ooffice", _tmp4_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp5_;
	}
	result = _tmp2_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* utils_find_desktop_file_for_app (const gchar* app_name, const gchar* mimetype) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* hash_name;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	gconstpointer _tmp11_ = NULL;
	const gchar* in_cache;
	const gchar* _tmp12_;
	gchar** _tmp15_;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** data_dirs;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** _tmp37_;
	gint _tmp37__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	utils_init_application_cache ();
	_tmp1_ = mimetype;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = app_name;
		_tmp3_ = mimetype;
		_tmp4_ = g_strdup_printf ("%s::%s", _tmp2_, _tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = app_name;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = _tmp0_;
	_tmp8_ = g_strdup (_tmp7_);
	hash_name = _tmp8_;
	_tmp9_ = utils_app_to_desktop_file;
	_tmp10_ = hash_name;
	_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
	in_cache = (const gchar*) _tmp11_;
	_tmp12_ = in_cache;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = in_cache;
		_tmp14_ = g_strdup (_tmp13_);
		result = _tmp14_;
		_g_free0 (hash_name);
		_g_free0 (_tmp0_);
		return result;
	}
	_tmp16_ = _tmp15_ = g_get_system_data_dirs ();
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup1 (_tmp16_, _vala_array_length (_tmp15_)) : ((gpointer) _tmp16_);
	_tmp17__length1 = _vala_array_length (_tmp15_);
	data_dirs = _tmp17_;
	data_dirs_length1 = _tmp17__length1;
	_data_dirs_size_ = data_dirs_length1;
	_tmp18_ = data_dirs;
	_tmp18__length1 = data_dirs_length1;
	_tmp19_ = g_get_user_data_dir ();
	_tmp20_ = g_strdup (_tmp19_);
	_vala_array_add2 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp20_);
	_tmp21_ = data_dirs;
	_tmp21__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp21_;
		dir_collection_length1 = _tmp21__length1;
		for (dir_it = 0; dir_it < _tmp21__length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				gchar* p;
				const gchar* _tmp28_;
				GFile* _tmp29_ = NULL;
				GFile* f;
				GFile* _tmp30_;
				gboolean _tmp31_ = FALSE;
				_tmp22_ = dir;
				_tmp23_ = app_name;
				_tmp24_ = g_strdup_printf ("%s.desktop", _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_build_filename (_tmp22_, "applications", _tmp25_, NULL, NULL);
				_tmp27_ = _tmp26_;
				_g_free0 (_tmp25_);
				p = _tmp27_;
				_tmp28_ = p;
				_tmp29_ = g_file_new_for_path (_tmp28_);
				f = _tmp29_;
				_tmp30_ = f;
				_tmp31_ = g_file_query_exists (_tmp30_, NULL);
				if (_tmp31_) {
					GHashTable* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp32_ = utils_app_to_desktop_file;
					_tmp33_ = hash_name;
					_tmp34_ = g_strdup (_tmp33_);
					_tmp35_ = p;
					_tmp36_ = g_strdup (_tmp35_);
					g_hash_table_insert (_tmp32_, _tmp34_, _tmp36_);
					result = p;
					_g_object_unref0 (f);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					return result;
				}
				_g_object_unref0 (f);
				_g_free0 (p);
			}
		}
	}
	_tmp37_ = data_dirs;
	_tmp37__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp37_;
		dir_collection_length1 = _tmp37__length1;
		for (dir_it = 0; dir_it < _tmp37__length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp38_;
				gchar* _tmp39_ = NULL;
				gchar* p;
				const gchar* _tmp40_;
				GFile* _tmp41_ = NULL;
				GFile* app_dir;
				GFile* _tmp42_;
				gboolean _tmp43_ = FALSE;
				_tmp38_ = dir;
				_tmp39_ = g_build_filename (_tmp38_, "applications", NULL, NULL);
				p = _tmp39_;
				_tmp40_ = p;
				_tmp41_ = g_file_new_for_path (_tmp40_);
				app_dir = _tmp41_;
				_tmp42_ = app_dir;
				_tmp43_ = g_file_query_exists (_tmp42_, NULL);
				if (!_tmp43_) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					continue;
				}
				{
					GFile* _tmp44_;
					GFileEnumerator* _tmp45_ = NULL;
					GFileEnumerator* enumerator;
					GFileEnumerator* _tmp46_;
					GFileInfo* _tmp47_ = NULL;
					GFileInfo* fi;
					GFileEnumerator* _tmp83_;
					_tmp44_ = app_dir;
					_tmp45_ = g_file_enumerate_children (_tmp44_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
					enumerator = _tmp45_;
					if (_inner_error_ != NULL) {
						goto __catch5_g_error;
					}
					_tmp46_ = enumerator;
					_tmp47_ = g_file_enumerator_next_file (_tmp46_, NULL, &_inner_error_);
					fi = _tmp47_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (enumerator);
						goto __catch5_g_error;
					}
					while (TRUE) {
						GFileInfo* _tmp48_;
						GFileInfo* _tmp49_;
						const gchar* _tmp50_ = NULL;
						gboolean _tmp51_ = FALSE;
						GFileEnumerator* _tmp80_;
						GFileInfo* _tmp81_ = NULL;
						GFileInfo* _tmp82_;
						_tmp48_ = fi;
						if (!(_tmp48_ != NULL)) {
							break;
						}
						_tmp49_ = fi;
						_tmp50_ = g_file_info_get_name (_tmp49_);
						_tmp51_ = g_str_has_suffix (_tmp50_, ".desktop");
						if (_tmp51_) {
							const gchar* _tmp52_;
							GFileInfo* _tmp53_;
							const gchar* _tmp54_ = NULL;
							gchar* _tmp55_ = NULL;
							gchar* desktop_file;
							const gchar* _tmp56_;
							GFile* _tmp57_ = NULL;
							GFile* f;
							_tmp52_ = p;
							_tmp53_ = fi;
							_tmp54_ = g_file_info_get_name (_tmp53_);
							_tmp55_ = g_build_filename (_tmp52_, _tmp54_, NULL, NULL);
							desktop_file = _tmp55_;
							_tmp56_ = desktop_file;
							_tmp57_ = g_file_new_for_path (_tmp56_);
							f = _tmp57_;
							{
								GFile* _tmp58_;
								gchar* _tmp59_ = NULL;
								gchar* contents;
								const gchar* _tmp60_;
								_tmp58_ = f;
								_tmp59_ = utils_get_file_contents (_tmp58_);
								contents = _tmp59_;
								_tmp60_ = contents;
								if (_tmp60_ != NULL) {
									const gchar* _tmp61_;
									const gchar* _tmp62_;
									gchar* _tmp63_ = NULL;
									gchar* _tmp64_;
									gboolean _tmp65_ = FALSE;
									gboolean _tmp66_;
									_tmp61_ = contents;
									_tmp62_ = app_name;
									_tmp63_ = g_strdup_printf ("Exec=%s", _tmp62_);
									_tmp64_ = _tmp63_;
									_tmp65_ = string_contains (_tmp61_, _tmp64_);
									_tmp66_ = _tmp65_;
									_g_free0 (_tmp64_);
									if (_tmp66_) {
										gboolean _tmp67_ = FALSE;
										const gchar* _tmp68_;
										gboolean _tmp72_;
										_tmp68_ = mimetype;
										if (_tmp68_ == NULL) {
											_tmp67_ = TRUE;
										} else {
											const gchar* _tmp69_;
											const gchar* _tmp70_;
											gboolean _tmp71_ = FALSE;
											_tmp69_ = contents;
											_tmp70_ = mimetype;
											_tmp71_ = string_contains (_tmp69_, _tmp70_);
											_tmp67_ = _tmp71_;
										}
										_tmp72_ = _tmp67_;
										if (_tmp72_) {
											GHashTable* _tmp73_;
											const gchar* _tmp74_;
											gchar* _tmp75_;
											const gchar* _tmp76_;
											gchar* _tmp77_;
											_tmp73_ = utils_app_to_desktop_file;
											_tmp74_ = hash_name;
											_tmp75_ = g_strdup (_tmp74_);
											_tmp76_ = desktop_file;
											_tmp77_ = g_strdup (_tmp76_);
											g_hash_table_insert (_tmp73_, _tmp75_, _tmp77_);
											result = desktop_file;
											_g_free0 (contents);
											_g_object_unref0 (f);
											_g_object_unref0 (fi);
											_g_object_unref0 (enumerator);
											_g_object_unref0 (app_dir);
											_g_free0 (p);
											data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (hash_name);
											_g_free0 (_tmp0_);
											return result;
										}
									}
								}
								_g_free0 (contents);
							}
							goto __finally6;
							__catch6_g_error:
							{
								GError* err = NULL;
								GError* _tmp78_;
								const gchar* _tmp79_;
								err = _inner_error_;
								_inner_error_ = NULL;
								_tmp78_ = err;
								_tmp79_ = _tmp78_->message;
								g_warning ("utils.vala:249: %s", _tmp79_);
								_g_error_free0 (err);
							}
							__finally6:
							if (_inner_error_ != NULL) {
								_g_object_unref0 (f);
								_g_free0 (desktop_file);
								_g_object_unref0 (fi);
								_g_object_unref0 (enumerator);
								goto __catch5_g_error;
							}
							_g_object_unref0 (f);
							_g_free0 (desktop_file);
						}
						_tmp80_ = enumerator;
						_tmp81_ = g_file_enumerator_next_file (_tmp80_, NULL, &_inner_error_);
						_tmp82_ = _tmp81_;
						if (_inner_error_ != NULL) {
							_g_object_unref0 (fi);
							_g_object_unref0 (enumerator);
							goto __catch5_g_error;
						}
						_g_object_unref0 (fi);
						fi = _tmp82_;
					}
					_tmp83_ = enumerator;
					g_file_enumerator_close (_tmp83_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (fi);
						_g_object_unref0 (enumerator);
						goto __catch5_g_error;
					}
					_g_object_unref0 (fi);
					_g_object_unref0 (enumerator);
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError* err = NULL;
					GError* _tmp84_;
					const gchar* _tmp85_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp84_ = err;
					_tmp85_ = _tmp84_->message;
					g_warning ("utils.vala:259: %s", _tmp85_);
					_g_error_free0 (err);
				}
				__finally5:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_object_unref0 (app_dir);
				_g_free0 (p);
			}
		}
	}
	result = NULL;
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (hash_name);
	_g_free0 (_tmp0_);
	return result;
}


Utils* utils_construct (GType object_type) {
	Utils * self = NULL;
	self = (Utils*) g_object_new (object_type, NULL);
	return self;
}


Utils* utils_new (void) {
	return utils_construct (TYPE_UTILS);
}


static void utils_class_init (UtilsClass * klass) {
	utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = utils_finalize;
}


static void utils_instance_init (Utils * self) {
}


static void utils_finalize (GObject* obj) {
	Utils * self;
	self = UTILS (obj);
	G_OBJECT_CLASS (utils_parent_class)->finalize (obj);
}


GType utils_get_type (void) {
	static volatile gsize utils_type_id__volatile = 0;
	if (g_once_init_enter (&utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Utils), 0, (GInstanceInitFunc) utils_instance_init, NULL };
		GType utils_type_id;
		utils_type_id = g_type_register_static (G_TYPE_OBJECT, "Utils", &g_define_type_info, 0);
		g_once_init_leave (&utils_type_id__volatile, utils_type_id);
	}
	return utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



