import os
import os.path
import xmlrpclib
import datetime
import subprocess
import sys
import multiprocessing

from cStringIO import StringIO


import lliurex.net

try:
	from gi.repository import Gtk,Gdk,GLib,Vte
except:
	pass

DNS1="172.27.111.5"
DNS2="172.27.111.6"

class Slave:
	

	def __init__(self,core,server_conf=None):
		
		self.id="SLAVE"
		self.scripts_path="/usr/share/zero-server-wizard/types/slave/actions/"
		self.template={}
		if server_conf!=None:
			try:
				for item in server_conf["variables"]:
					self.template[item]=None
			except:
				pass
				
		
		self.core=core
		
		
		
	#def __init__
	
	def start_gui(self,standalone=False):
		
		self.standalone=standalone
		
		builder=self.core.builder

		
		
		self.apply_button=builder.get_object("apply_button2")
		self.internal_speed_label=builder.get_object("internal_iface_speed_label2")
		self.external_speed_label=builder.get_object("external_iface_speed_label2")
		self.password_entry=builder.get_object("password_entry4")
		self.password_entry2=builder.get_object("password_entry5")
		self.remote_user_entry=builder.get_object("remote_user")
		#self.password_entry.connect("changed",self.password_changed)
		self.srv_name_entry=builder.get_object("srv_name_entry2")
		self.srv_domain_entry=builder.get_object("srv_domain_entry2")
		self.internal_combobox=builder.get_object("internal_combobox2")
		self.internal_combobox.set_name("Button")
		self.external_combobox=builder.get_object("external_combobox2")
		
		self.internal_ip_entry=builder.get_object("srvip_entry2")
		self.internal_mask_entry=builder.get_object("internal_mask_entry2")
		self.external_ip_entry=builder.get_object("external_ip_entry2")
		self.external_mask_entry=builder.get_object("external_mask_entry2")
		self.external_gateway_entry=builder.get_object("external_gateway_entry2")
		self.dns1_entry=builder.get_object("dns1_entry2")
		self.dns2_entry=builder.get_object("dns2_entry2")
		self.pass_label=builder.get_object("pass_label2")
		self.dhcp_radiobutton=builder.get_object("dhcp_radiobutton2")
		self.dhcp_radiobutton.connect("toggled",self.radio_button_changed)
		self.manual_radiobutton=builder.get_object("manual_radiobutton2")
		self.manual_expander=builder.get_object("manual_expander2")
		self.manual_expander.set_sensitive(False)
		self.apply_button.connect("clicked",self.apply_clicked)
		#self.apply_button.set_sensitive(False)
		self.apply_button.set_name("Button")
		self.replication_cbutton=builder.get_object("data_cbutton1")
		self.gluster_msg=builder.get_object("error_label2")
		if self.core.platform != "x86_64":
			self.replication_cbutton.set_sensitive(False)
		else:
			self.gluster_msg.hide()
		
		self.croom_spinbutton=builder.get_object("croom_spinbutton")
		self.croom_spinbutton.connect("changed",self.spin_changed)
		self.set_default_gui_values()
		
		if standalone:
			
			Gtk.main()

		
	#def start_gui
	
	def spin_changed(self,widget):
		
		
		ip="10.2.%s.254"%str(int(self.croom_spinbutton.get_value()))
		self.internal_ip_entry.set_text(ip)
		
		
	#def spin_changed
	
	
	def radio_button_changed(self,widget):

		self.manual_expander.set_sensitive(not self.dhcp_radiobutton.get_active())
		self.manual_expander.set_expanded(not self.dhcp_radiobutton.get_active())
		
	#def radio_button_changed
	
	def password_changed(self,widget):
		
		if self.password_entry.get_text()!=self.password_entry1.get_text():
			self.pass_label.set_markup("<span fgcolor='red'>" + "Passwords do not match" +"</span>")
			self.apply_button.set_sensitive(False)
		else:
			self.pass_label.set_markup("")
			self.apply_button.set_sensitive(True)
			
	#def password_changed
	
	def set_default_gui_values(self):
		

		self.iiface_model=Gtk.ListStore(str)
		self.eiface_model=Gtk.ListStore(str)
		
		self.remote_user_entry.set_text("netadmin")
		
		self.internal_combobox.set_model(self.iiface_model)
		self.external_combobox.set_model(self.eiface_model)
		rendi=Gtk.CellRendererText()
		self.internal_combobox.pack_start(rendi,True)
		self.internal_combobox.add_attribute(rendi,"text",0)
		self.internal_combobox.connect("changed",self.get_link_speed,0)
		rende=Gtk.CellRendererText()
		self.external_combobox.pack_start(rende,True)
		self.external_combobox.add_attribute(rende,"text",0)
		self.external_combobox.connect("changed",self.get_link_speed,1)
		self.interfaces=lliurex.net.get_devices_info()		
		
		
		for item in self.interfaces:
			if "eth" in item["name"]:
				self.iiface_model.append([item["name"]])
				self.eiface_model.append([item["name"]])
				
			
		self.internal_combobox.set_active(0)
		if len(self.iiface_model)>1:
			self.external_combobox.set_active(1)
		else:
			self.external_combobox.set_active(0)
			
		
		self.srv_domain_entry.set_text(self.template.setdefault("srv_domain_name","lliurex"))
		self.srv_domain_entry.set_sensitive(False)

		self.internal_ip_entry.set_text(self.template.setdefault("srv_ip","10.2.1.254"))
		self.internal_ip_entry.set_sensitive(False)
		self.internal_mask_entry.set_text(self.template.setdefault("internal_mask","255.255.255.0"))
		self.internal_mask_entry.set_sensitive(False)
		self.dns1_entry.set_text(DNS1)
		self.dns2_entry.set_text(DNS2)
		
		try:
			
			f=open("/etc/hostname")
			line=f.readline().strip("\n")
			f.close()
			self.srv_name_entry.set_text(self.template.setdefault("srv_name",line))
		except:
			pass
			
		
		
	#def set_default_gui_values
	
	def apply_clicked(self,widget):
		

		self.get_gui_values()
		
		
	#def apply_clicked
	
	def get_gui_values(self):
		
		iter=self.internal_combobox.get_active_iter()
		if iter!=None:
			self.template["internal_iface"]=self.iiface_model.get(iter,0)[0]
		else:
			self.template["internal_iface"]=None
		iter=self.external_combobox.get_active_iter()
		if iter!=None:
			self.template["external_iface"]=self.eiface_model.get(iter,0)[0]
		else:
			self.template["external_iface"]=None
		
		self.template["adminpassword"]=self.password_entry.get_text()
		self.template["remote_user"]=self.remote_user_entry.get_text()
		self.template["remote_password"]=self.password_entry.get_text()
		self.template["remote_password2"]=self.password_entry2.get_text()
		self.template["number_classroom"]=int(self.croom_spinbutton.get_value())
		self.template["enable_data_replication"]=str(self.replication_cbutton.get_active()).lower()
		self.template["srv_name"]=self.srv_name_entry.get_text()
		self.template["srv_name"]=''.join(e for e in self.template["srv_name"] if e.isalnum())
		self.template["srv_domain_name"]=self.srv_domain_entry.get_text()
		self.template["srv_domain_name"]=''.join(e for e in self.template["srv_domain_name"] if e.isalnum())
		self.template["srv_ip"]=self.internal_ip_entry.get_text()
		self.template["internal_mask"]=self.internal_mask_entry.get_text()
		if self.dhcp_radiobutton.get_active():
			self.template["external_mode"]="dhcp"

		else:
			self.template["external_mode"]="manual"

		self.template["external_ip"]=self.external_ip_entry.get_text()
		self.template["external_mask"]=self.external_mask_entry.get_text()
		self.template["external_gateway"]=self.external_gateway_entry.get_text()
		self.template["dns1"]=self.dns1_entry.get_text()
		self.template["dns2"]=self.dns2_entry.get_text()
		
		
		
		self.check_values()
	
	
	def check_values(self):
		

			error_msg=""
			'''
			if self.template["internal_iface"]==self.template["external_iface"]:
				error_msg+="* External and internal interfaces must be different.\n"
			'''
			
			if self.template["remote_password"]!=self.template["remote_password2"]:
				error_msg+="* Remote passwords do not match"
			
			if not lliurex.net.is_valid_ip(self.template["srv_ip"]):
				error_msg+="* Internal IP must be a valid IP.\n"

			if not lliurex.net.is_valid_ip(self.template["internal_mask"]):
				error_msg+="* Internal mask must be a valid IP.\n"
				
			if self.template["srv_name"]=="":
				error_msg+="* Server name cannot be an empty string.\n"
			if self.template["srv_domain_name"]=="":
				error_msg+="* Server domain name cannot be an empty string.\n"
			
			
			if self.template["external_mode"]=="manual":

				if self.template["external_ip"]=='' or not lliurex.net.is_valid_ip(self.template["external_ip"]):
					error_msg+="* External IP must be a valid IP.\n"
				if self.template["external_mask"]=="" or not lliurex.net.is_valid_ip(self.template["external_mask"]):
					error_msg+="* External mask must be a valid IP.\n"
				if self.template["external_gateway"]=="" or not lliurex.net.is_valid_ip(self.template["external_gateway"]):
					error_msg+="* External gateway must be a valid IP.\n"
				
				
			if self.template["dns1"]=="" or not lliurex.net.is_valid_ip(self.template["dns1"]):
				error_msg+="* DNS1 must be a valid IP.\n"
			if self.template["dns2"]=="" or not lliurex.net.is_valid_ip(self.template["dns2"]):
				error_msg+="* DNS2 must be a valid IP.\n"
				
			if error_msg!="":
				builder = Gtk.Builder()
				if os.path.exists("/srv/svn/pandora/zero-server-wizard/trunk/install-files/usr/share/zero-server-wizard/rsrc/warning.glade"):
					builder.add_from_file("/srv/svn/pandora/zero-server-wizard/trunk/install-files/usr/share/zero-server-wizard/rsrc/warning.glade")
				else:
					builder.add_from_file("/usr/share/zero-server-wizard/rsrc/warning.glade")
					
					
				window=builder.get_object("window1")
				msg_label=builder.get_object("msg_label")
				close_button=builder.get_object("close_button")
				def hide(widget):
					window.destroy()
				close_button.connect("clicked",hide)
				msg_label.set_text(error_msg.strip("\n"))
				window.show()				
			
			else:
				
				builder=Gtk.Builder()
				if os.path.exists("/srv/svn/pandora/zero-server-wizard/trunk/install-files/usr/share/zero-server-wizard/rsrc/progress_window.glade"):
					builder.add_from_file("/srv/svn/pandora/zero-server-wizard/trunk/install-files/usr/share/zero-server-wizard/rsrc/progress_window.glade")
				else:
					builder.add_from_file("/usr/share/zero-server-wizard/rsrc/progress_window.glade")				
					
					
				self.error_msg=None
				window=builder.get_object("window1")
				review_textview=builder.get_object("textbuffer1")
				exec_textview=builder.get_object("textbuffer2")
				apply_button=builder.get_object("apply_button")
				close_button=builder.get_object("close_button")
				pbar=builder.get_object("progressbar1")
				terminal_box=builder.get_object("scrolledwindow2")
				
				#vterminal=Vte.Terminal()
				#vterminal.show()
				#terminal_box.add(vterminal)
				
				#ret_textview=builder.get_object("ret_textview")
				widgets=[close_button,pbar]
				self.pulsating=False
				
				
				msg=""
				
				msg+="[ " + "REMOTE USER" + " ] = " + self.template["remote_user"]+ "\n"
				msg+="[ " + "CLASSROOM" + " ] = " + str(self.template["number_classroom"])+ "\n"
				msg+="[ " + "DATA REPLICATION" + " ] = " + self.template["enable_data_replication"]+ "\n"
				msg+="[ "+"SERVER NAME"+" ] = " + self.template["srv_name"] + "\n"
				msg+="[ "+"SERVER DOMAIN NAME"+" ] = " + self.template["srv_domain_name"] + "\n"
				msg+="[ "+"INTERNAL INTERFACE"+" ] = " + self.template["internal_iface"] + "\n"
				msg+="[ "+"INTERNAL IP"+" ] = " + self.template["srv_ip"] + "\n"
				msg+="[ "+"INTERNAL MASK"+" ] = " + self.template["internal_mask"] + "\n"
				msg+="[ "+"EXTERNAL INTERFACE"+" ] = " + self.template["external_iface"] + "\n"
				msg+="[ "+"EXTERNAL MODE"+" ] = " + self.template["external_mode"] + "\n"
				if self.template["external_mode"]!="dhcp":
					msg+="[ "+"EXTERNAL IP"+" ] = " + self.template["external_ip"] + "\n"
					msg+="[ "+"EXTERNAL MASK"+" ] = " + self.template["external_mask"] + "\n"
					msg+="[ "+"EXTERNAL GATEWAY"+" ] = " + self.template["external_gateway"] + "\n"
				msg+="[ "+"DNS"+" ] = " + str(self.template["dns1"]) + ", " + str(self.template["dns2"])+ "\n"
					

				
				review_textview.set_text(msg)
					
				
				
				def pulsating():
					pbar.pulse()
					

					try:
						f=open("/tmp/.zsw-log","r")
						tmp="".join(f.readlines())
						if self.msg_thread!=tmp:
							self.msg_thread=tmp
							exec_textview.set_text(tmp)
							
						f.close()
					except:
						pass
					
					if not os.path.exists("/tmp/.zsw-on"):
						pbar.set_fraction(1)
						close_button.set_sensitive(True)
						
						if os.path.exists("/tmp/.zsw-error"):
						
							f=open("/tmp/.zsw-error","r")
							self.error_msg=f.readline()
							f.close()
							os.remove("/tmp/.zsw-error")
							
							builder = Gtk.Builder()
							if os.path.exists("/srv/svn/pandora/zero-server-wizard/trunk/install-files/usr/share/zero-server-wizard/rsrc/warning.glade"):
								builder.add_from_file("/srv/svn/pandora/zero-server-wizard/trunk/install-files/usr/share/zero-server-wizard/rsrc/warning.glade")
							else:
								builder.add_from_file("/usr/share/zero-server-wizard/rsrc/warning.glade")
								
								
							window2=builder.get_object("window1")
							msg_label=builder.get_object("msg_label")
							close_button2=builder.get_object("close_button")
							def hide(widget):
								window2.destroy()
							close_button2.connect("clicked",hide)
							msg_label.set_markup("<b>"+self.error_msg+"</b>")
							window2.set_title("Error")
							window2.show()
							
							return False
							
						else:
							label = Gtk.Label("Initialization complete. A reboot is required.")
							dialog = Gtk.Dialog("Zero Server Wizard", None, Gtk.DialogFlags.MODAL | Gtk.DialogFlags.DESTROY_WITH_PARENT, (Gtk.STOCK_OK, Gtk.ResponseType.ACCEPT))
							img=Gtk.Image.new_from_stock(Gtk.STOCK_APPLY,Gtk.IconSize.DIALOG)
							hbox=Gtk.HBox()
							hbox.pack_start(img,True,True,5)
							hbox.pack_start(label,True,True,5)
							hbox.show_all()
							dialog.vbox.pack_start(hbox,True,True,10)
							label.show()
							dialog.set_border_width(6)
							response = dialog.run()

							sys.exit(0)
						
						
						
					return True
				
				def apply_clicked(widget,data):
					
					self.pulsating=True
					f=open("/tmp/.zsw-on","w")
					f.close()
					self.msg_thread=""
					self.prv_msg=None
					widget.set_sensitive(False)
					t=multiprocessing.Process(target=self.execute,args=(self.template,True,))
					#t.daemon=True
					t.start()
					close_button.set_sensitive(False)
					GLib.timeout_add(100,pulsating)
					
				def destroy(uno,dos):
					try:
						if self.pulsating:
							return True
						else:
							window.destroy()
					except:
						pass
						

					
				#def apply_clicked
				
				
				def close(widget):
					window.destroy()



				apply_button.connect("clicked",apply_clicked,None)
				close_button.connect("clicked",close)
				#vterminal.connect("child-exited",init_done,close_button)
				window.connect("delete_event",destroy)
				
				window.show()
				
				pass
				#def init_done
				

	#def check_values
	
	def get_link_speed(self,widget,id):
		
		tree_iter = widget.get_active_iter()
		if tree_iter != None:
			model = widget.get_model()
			try:
				speed=lliurex.net.get_device_info(model[tree_iter][0])["Speed"][0]
			except:
				speed="Unknown speed"
			if id==0:
				self.internal_speed_label.set_text(speed)
			else:
				self.external_speed_label.set_text(speed)
				
		
	#def get_link_speed
	
	def external_mode_signal(self,widget):
		
		self.manual_external_box.set_sensitive(not self.dhcp_radiobutton.get_active())
		
	#def ems
	
	
	def close_window(self,widget):
		if self.standalone:
			Gtk.main_quit()
		
		
	#def close_window
	
	
	def execute(self,template,gui=False):
		
		print("[SLAVE] Executing slave configuration...")
			
		#self.template=template
		self.log("Executing Slave configuration...")

		self.core.template=dict(self.core.template.items() + self.template.items())
		self.template=self.core.template

		if not self.template.has_key("remote_ip"):
			self.template["remote_ip"]="localhost"

		
		if os.path.exists("/tmp/.zsw-log"):
			os.remove("/tmp/.zsw-log")
		
		for f in sorted(os.listdir("/usr/share/zero-server-wizard/types/slave/actions/")):
			if os.path.isfile(self.scripts_path+f):
				
				try:
					if f.endswith(".py"):
						self.log("Excuting " + f + " ...")
						print("[SLAVE] Executing " + f + " ...")
						if not gui:
							execfile(self.scripts_path+f,locals())
						else:
							
							#.set_text(ret_textview.get_buffer().get_text(ret_textview.get_buffer().get_start_iter(),ret_textview.get_buffer().get_end_iter(),True)+ "\npor aqui")
							#msg+=("[INDEPENDENT] Executing " + f + " ... ")
							f_=open("/tmp/.zsw-log","a")
							f_.write("[SLAVE] Executing " + f + " ... ")
							f_.close()							
							execfile(self.scripts_path+f,locals())
							f_=open("/tmp/.zsw-log","a")
							f_.write(" OK\n")
							f_.close()
							


							
				except Exception as e:
					print e.message

					try:
						f=open("/tmp/.zsw-error","w")
						f.write(e.message)
						f.close()
					except:
						pass
					
					os.remove("/tmp/.zsw-on")
					return False
		
		if gui:
			os.remove("/tmp/.zsw-on")
		
		return True	
		
	#def execute
	
	def log(self,line):
		
		independent_log="/tmp/slave"
		f=open(independent_log,"a")
		f.write( "[ "+datetime.datetime.today().strftime("%d/%m/%y %H:%M:%S") + " ] " + line + "\n")
		f.close()
		
		
	#def log
	
	
	
	
#class Independent
