#!/usr/bin/python

import xmlrpclib
import os.path


def check_variables():
	
	if ("user" and "password") not in self.template:
		
		if "masterkey" not in self.template:
			
			return (False,"No authentication method found")

			
	else:	
		c=xmlrpclib.ServerProxy("https://"+self.template["remote_ip"]+":9779")
		ret=c.validate_user(self.template["user"],self.template["password"])
		if not ret[0]:
			return(False,"User validation error")
		


	lst=["external_iface","internal_iface","srv_ip","internal_mask","external_mask","external_ip","external_gateway","external_mode"]
	for item in lst:
		if item not in self.template:
			print("\t[015-network] [!]" + item + " is missing from template. Aborting initialization")
			return (False,"[015-network] [!]" + item + " is missing from template. Aborting initialization")
			
	return (True,"")
	
#def check_variables

ret=check_variables()

if ret[0]:
	
	try:
		ip_server = self.template["remote_ip"]
		if "user" in self.template:
			user=(self.template["user"],self.template["password"])
		else:
			user=self.template["masterkey"]
		c=xmlrpclib.ServerProxy("https://"+ip_server+":9779")

		internal_iface=self.template["internal_iface"]
		internal_mask=self.template["internal_mask"]
		
		external_mask=self.template["external_mask"]
		external_mode=self.template["external_mode"]
		external_gateway=self.template["external_gateway"]
		external_ip=self.template["external_ip"]
		external_iface=self.template["external_iface"]
		external_dns_search = self.template["srv_domain_name"]
		srv_ip=self.template["srv_ip"]

		print c.load_network_file(user,'NetworkManager')
		print c.set_internal_interface(user,'NetworkManager',internal_iface)
		print c.set_external_interface(user,'NetworkManager',external_iface)
		
		
		print c.interface_static(user,'NetworkManager',internal_iface,srv_ip,internal_mask,False)
		
		if external_mode=="dhcp":
			print c.interface_dhcp(user,'NetworkManager',external_iface,False)
		else:
			print c.interface_static(user,'NetworkManager',external_iface,external_ip,external_mask,False,external_gateway,external_dns_search)
		

		# MOVED TO THE END OF THE  INITIALIZATION PROCESS
		#print c.restart_interfaces(user,'NetworkManager')		
		
	except Exception as e:
		print(e)
		raise e
	
	
else:
	e=Exception()
	e.message=ret[1]
	raise e
