#!/usr/bin/python

import xmlrpclib


def check_variables():
	if ("user" and "password") not in self.template:
		
		if "masterkey" not in self.template:
			
			return (False,"No authentication method found")

			
	else:	
		c=xmlrpclib.ServerProxy("https://"+self.template["remote_ip"]+":9779")
		ret=c.validate_user(self.template["user"],self.template["password"])
		if not ret[0]:
			return(False,"User validation error")
			
	for item in ["srv_ip","adminpassword","enable_data_replication"]:
		if item not in self.template:
			print("\t[020-ldap] [!]" + item + " is missing from template. Aborting initialization")
			return (False,"[020-ldap] [!]" + item + " is missing from template. Aborting initialization")
		
	return (True,"")
	
#def check_variables

ret=check_variables()
if self.template["enable_data_replication"].lower() == "true":
	if ret[0]:
		
		try:
			ip_server = self.template["remote_ip"]

			if "user" in self.template:
				user=(self.template["user"],self.template["password"])
			else:
				user=self.template["masterkey"]
			vol_name = 'net'
			path_data = '/net/.data'
			name_server = "10.3.0.254"
			dest_path = '/net/server-sync'
			result = c.path_is_clean(user,'GlusterManager',path_data)
			print result
			if not result['status']:
				print path_data + " is dirty. Clean please."
				c.clean_path(user,'GlusterManager',path_data)
			result = c.create_vol(user,'GlusterManager',vol_name,name_server,path_data)
			print result
			if not result['status']:
				print result['msg']
				raise Exception(result['msg'])
			result = c.start_vol(user,'GlusterManager',vol_name)
			print result
			if not result['status']:
				print result['msg']
				raise Exception(result['msg'])

			result = c.mount_on_boot(user,'GlusterManager',vol_name,name_server+':/'+vol_name,dest_path)
	                print result
	                if not result['status']:
	                        print result['msg']
	                        raise Exception(result['msg'])
	                print c.mount_now(user,'GlusterManager')	
		except Exception as e:
			print e
			raise e
		
	else:
		e=Exception()
		e.message=ret[1]
		raise e
