#!/usr/bin/python

import xmlrpclib


def check_variables():
	if ("user" and "password") not in self.template:
		
		if "masterkey" not in self.template:
			
			return (False,"No authentication method found")

			
	else:	
		c=xmlrpclib.ServerProxy("https://"+self.template["remote_ip"]+":9779")
		ret=c.validate_user(self.template["user"],self.template["password"])
		if not ret[0]:
			return(False,"User validation error")
			
	for item in ["srv_ip","enable_data_replication","adminpassword"]:
		if item not in self.template:
			print("\t[065-glusterfs] [!]" + item + " is missing from template. Aborting initialization")
			return (False,"[065-glusterfs] [!]" + item + " is missing from template. Aborting initialization")
		
	return (True,"")
	
#def check_variables

ret=check_variables()
if self.template["enable_data_replication"].lower() == "true":
	if ret[0]:
		
		try:
			ip_server = self.template["remote_ip"]

			if "user" in self.template:
				user=(self.template["user"],self.template["password"])
			else:
				user=self.template["masterkey"]

			if not "remote_user" in self.template:
				self.template["remote_user"]="netadmin"
				self.template["remote_password"]=self.template["adminpassword"]
				
			remote_user = (self.template["remote_user"],self.template["remote_password"])
			r = xmlrpclib.ServerProxy("https://10.3.0.254:9779")

			vol_name = 'net'
			path_data = '/net/.data'
			name_server = "10.3.0." + str(self.template["number_classroom"])
			dest_path = '/net/server-sync'

			result = c.path_is_clean(user,'GlusterManager',path_data)
			print result
			if not result['status']:
				print path_data + " is dirty. Clean please."
				c.clean_path(user,'GlusterManager',path_data)
			result = r.add_peer(remote_user,'GlusterManager',name_server)
			print result
			if not result['status']:
				print result['msg']
				raise Exception(result['msg'])
			result = r.add_brick(remote_user,'GlusterManager',vol_name,name_server,path_data)
			print result
			if not result['status']:
				print result['msg']
				raise Exception(result['msg'])
			result = c.mount_on_boot(user,'GlusterManager',vol_name,name_server+':/'+vol_name,dest_path)
			print result
			if not result['status']:
				print result['msg']
				raise Exception(result['msg'])
			print c.mount_now(user,'GlusterManager')
		except Exception as e:
			print e
			raise e
		
	else:
		e=Exception()
		e.message=ret[1]
		raise e
