from pysqlite2 import dbapi2 as sqlite

import sys
import subprocess
import os
import dbus

database_file="/usr/share/zero-sqlmanager/status.db"

class Zero_Sqlmanager:
	
	def __init__(self):
		

		

		try:
			self.bus=dbus.SessionBus()
		
		
			
			p=self.bus.get_object("net.Lliurex.zerocenter","/net/Lliurex/zerocenter")

			
			p.refresStatus()
						
			
		except:
			pass


		
		self.connection=sqlite.connect(database_file)	
		self.cursor = self.connection.cursor()

		# TABLE OF STATES

		self.ACTIVE_VALUE=1 
		self.ACTIVE_STRING="ACT"
		
		self.WAITING_FOR_CONFIGURATION_VALUE=0
		self.WAITING_FOR_CONFIGURATION_STRING="WAITING"
		
		
		#  ############
		
		
		
	
	#def __init__
	
	
	def createDB(self):
		
		self.cursor.execute("CREATE TABLE status (id INTEGER PRIMARY KEY,name VARCHAR(100),status INTEGER, time DATE)")
		#self.cursor.execute("CREATE TABLE status (id INTEGER PRIMARY KEY,name VARCHAR(100),status VARCHAR(100))")
	#def createDB
	
	def dropDB(self):
		
		self.cursor.execute("DROP TABLE status")
		self.connection.commit()
		
	#def dropDB
	

	def updateTo1_1(self):

		try:
			self.cursor.execute("ALTER TABLE status ADD time DATE")	
			self.connection.commit()
		except:
			pass


	#def updateTo1.1

	
	def checkDB(self):
		
		try:
		
			self.cursor.execute("SELECT * FROM status")
		
			#print self.cursor.fetchall()
		
		except:
			
			print "DELETE"
				
	

	#def checkDB
	
	
	def getStatusList(self):
		
		try:
		
			self.cursor.execute("SELECT * FROM status")
		
			#print self.cursor.fetchall()
		
			for row in self.cursor:
				print ("%s %s %s"%(row[1],row[2],row[3]))
				
		except:
			
			pass 
			
	#def readStatusList
	
	def writeStatus(self,script,status):
		
		sql_query='SELECT * from status'
		
		self.cursor.execute(sql_query)
		
		found=False
		
		for row in self.cursor:
			if row[1]==script:
				found=True
		
		if found:
			sql_query='UPDATE status SET status="'+status+'",time=DATETIME("NOW") WHERE name="'+script+'"'
		else:
			sql_query='INSERT INTO status VALUES(null,"' + script + '","' +status+'",DATETIME("NOW"))'
		
		#print sql_query
		
		self.cursor.execute(sql_query)
		
		self.connection.commit()
			
		self.refreshStatus()
			
		
		
		
	#def writeStatus
	
	
	def refreshStatus(self):
		
		
		
		p1 = subprocess.Popen(["ps","aux"], stdout=subprocess.PIPE)
		p2 = subprocess.Popen(["grep", "mono /usr/lib/zero-center/zero-center.exe"], stdin=p1.stdout, stdout=subprocess.PIPE)
		p3 = subprocess.Popen(["cut", "-d"," ","-f","1"], stdin=p2.stdout, stdout=subprocess.PIPE)
		p4 = subprocess.Popen(["head", "-n","1"], stdin=p3.stdout, stdout=subprocess.PIPE)
		output = p4.communicate()[0]

		user=output.strip('\n')
		print user
		
		subprocess.Popen(["sudo","-u",user,"/usr/sbin/zero-sqlmanager","-q"])
		
	#def refreshStatus
	
	
	def checkScriptState(self,script):
		
		sql_query='SELECT * from status where name="'+script+'"'
		
		self.cursor.execute(sql_query)
		
		for row in self.cursor:
			print "%s %s"%(row[1], row[2])




		
	#def checkScriptState
	
	def removeScript(self,script):
		
		sql_query='DELETE FROM status WHERE name="'+script+'"'
		
		self.cursor.execute(sql_query)
		self.connection.commit()
		
	#def removeScript
	
	
#class Zero_Sqlmanager

if __name__=="__main__":
	
	if not os.path.exists(database_file):
		try:
			subprocess.call(["touch",database_file])
			mng=Zero_Sqlmanager()
			mng.createDB()
		except:
			print "[Error] Unable to create database. Try using sudo."
			sys.exit(0)

	else:
		mng=Zero_Sqlmanager()

	count =0
	
	if len(sys.argv) ==1:
				print "[ZERO-SQLMANAGER]"
				print " Usable parameters:"
				print "   --help, -h \t\t\t\t\tShow this help"
				print "   --get-list, -l \t\t\t\tList of scripts"
				print "   --check-status, -c SCRIPT_NAME\t\tCheck script status"
				print "   --set-status, -s SCRIPT_NAME STATUS\t\tSet script status"
				print "   --remove-from-list, -r SCRIPT_NAME\t\tRemove script from list"
				print " "
				print " Zero-Center Readable Status List:"
				print "   NOT LAUNCHED = 0"
				print "   CONFIGURED = 1"
				print "   SERVICE RUNNING = 2"
				print "   SERVICE STOPPED = 3 "
				print "   CONFIGURATION NEEDED = 4"
				print ""
				
				print ""
	
	for arg in sys.argv:
		if count==0:
			pass
		else:

			if arg=="--help" or arg=="-h":
				print "[ZERO-SQLMANAGER]"
				print " Usable parameters:"
				print "   --help, -h \t\t\t\t\tShow this help"
				print "   --get-list, -l \t\t\t\tList of scripts"
				print "   --check-status, -c SCRIPT_NAME\t\tCheck script status"
				print "   --set-status, -s SCRIPT_NAME STATUS\t\tSet script status"
				print "   --remove-from-list, -r SCRIPT_NAME\t\tRemove script from list"
				print " "
				print " Zero-Center Readable Status List: "
				print "   NOT LAUNCHED = 0"
				print "   CONFIGURED = 1"
				print "   SERVICE RUNNING = 2"
				print "   SERVICE STOPPED = 3 "
				print "   CONFIGURATION NEEDED = 4"
				print ""				
				
				print ""
				
			if arg=="--get-list" or arg=="-l":
				mng.getStatusList()
			if arg=="--set-status" or arg=="-s":
				if  len(sys.argv)==4:
					mng.writeStatus(sys.argv[2],sys.argv[3])
				else:
					print "[!] USAGE: zero-sqlmanager -s SCRIPT_NAME SCRIPT_STATUS"
			if arg=="--check-status" or arg=="-c":
				if len(sys.argv)==3:
					mng.checkScriptState(sys.argv[2])
				else:
					print "[!] USAGE: zero-sqlmanager -c SCRIPT_NAME"
					
			if arg=="--remove-from-list" or arg=="-r":
				if len(sys.argv)==3:
					mng.removeScript(sys.argv[2])
				else:
					print "[!] USAGE: zero-sqlmanager -r SCRIPT_NAME"
					
			if arg=="--init":
				pass
				
			if arg=="--checkdb":
				mng.checkDB()

			if arg=="--update1.1":
				mng.updateTo1_1()

				
			if arg=="--test":
				
				isEmpty=False
				
				mng.cursor.execute("SELECT COUNT(*) FROM status")
				for row in mng.cursor:
					if row[0]==0:
						isEmpty=True
					else:
						isEmpty=False
						
						
				statusInt=True
				
				if isEmpty:
					try:
						mng.writeStatus("test",1)
					except:
						print "uh oh"
						statusInt=False
				else:
					
					mng.cursor.execute("SELECT * FROM status")
			
					for row in mng.cursor:
						if type(row[2]).__name__=="unicode":
							statusInt=False
						

				if not statusInt:
					print "we're gonna have to do something"
				else:
					print "everything's ok"

				
		count+=1
	

	

