/* Manager.c generated by valac 0.14.0, the Vala compiler
 * generated from Manager.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gudev/gudev.h>
#include <gst/gst.h>
#include <stdio.h>


#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_ID_BUS_MANAGER_PROXY (dvb_id_bus_manager_proxy_get_type ())

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;

#define DVB_TYPE_ADAPTER_INFO (dvb_adapter_info_get_type ())
typedef struct _DVBAdapterInfo DVBAdapterInfo;

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;
typedef struct _DVBManagerPrivate DVBManagerPrivate;

#define DVB_MANAGER_TYPE_SCANNER_DATA (dvb_manager_scanner_data_get_type ())
#define DVB_MANAGER_SCANNER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MANAGER_TYPE_SCANNER_DATA, DVBManagerScannerData))
#define DVB_MANAGER_SCANNER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MANAGER_TYPE_SCANNER_DATA, DVBManagerScannerDataClass))
#define DVB_MANAGER_IS_SCANNER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MANAGER_TYPE_SCANNER_DATA))
#define DVB_MANAGER_IS_SCANNER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MANAGER_TYPE_SCANNER_DATA))
#define DVB_MANAGER_SCANNER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MANAGER_TYPE_SCANNER_DATA, DVBManagerScannerDataClass))

typedef struct _DVBManagerScannerData DVBManagerScannerData;
typedef struct _DVBManagerScannerDataClass DVBManagerScannerDataClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DVBManagerScannerDataPrivate DVBManagerScannerDataPrivate;

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_TERRESTRIAL_SCANNER (dvb_terrestrial_scanner_get_type ())
#define DVB_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScanner))
#define DVB_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))
#define DVB_IS_TERRESTRIAL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_IS_TERRESTRIAL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_SCANNER))
#define DVB_TERRESTRIAL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_SCANNER, DVBTerrestrialScannerClass))

typedef struct _DVBTerrestrialScanner DVBTerrestrialScanner;
typedef struct _DVBTerrestrialScannerClass DVBTerrestrialScannerClass;

#define DVB_TYPE_SATELLITE_SCANNER (dvb_satellite_scanner_get_type ())
#define DVB_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScanner))
#define DVB_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))
#define DVB_IS_SATELLITE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_IS_SATELLITE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_SCANNER))
#define DVB_SATELLITE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_SCANNER, DVBSatelliteScannerClass))

typedef struct _DVBSatelliteScanner DVBSatelliteScanner;
typedef struct _DVBSatelliteScannerClass DVBSatelliteScannerClass;

#define DVB_TYPE_CABLE_SCANNER (dvb_cable_scanner_get_type ())
#define DVB_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScanner))
#define DVB_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))
#define DVB_IS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_SCANNER))
#define DVB_IS_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_SCANNER))
#define DVB_CABLE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))

typedef struct _DVBCableScanner DVBCableScanner;
typedef struct _DVBCableScannerClass DVBCableScannerClass;

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_hash_table_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_hash_table_unref0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;

#define DVB_TYPE_ID_BUS_DEVICE_GROUP_PROXY (dvb_id_bus_device_group_proxy_get_type ())

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBAdapterInfo {
	gchar* name;
	gchar* type;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetAdapterInfo) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
};

struct _DVBManager {
	GObject parent_instance;
	DVBManagerPrivate * priv;
};

struct _DVBManagerClass {
	GObjectClass parent_class;
};

struct _DVBManagerPrivate {
	GeeHashMap* scanners;
	GStaticRecMutex __lock_scanners;
	GeeHashMap* devices;
	GStaticRecMutex __lock_devices;
	guint device_group_counter;
	GUdevClient* udev_client;
};

struct _DVBManagerScannerData {
	GObject parent_instance;
	DVBManagerScannerDataPrivate * priv;
	DVBScanner* scanner;
	gulong signal_id;
};

struct _DVBManagerScannerDataClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	gchar* (*GetType) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self, GError** error);
	gchar* (*GetName) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
	gchar** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
	gboolean (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
	gchar* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
};

struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
};

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};


static gpointer dvb_manager_parent_class = NULL;
static DVBLoggingLogger* dvb_manager_log;
static DVBLoggingLogger* dvb_manager_log = NULL;
static DVBManager* dvb_manager_instance;
static DVBManager* dvb_manager_instance = NULL;
static GStaticRecMutex dvb_manager_instance_mutex;
static GStaticRecMutex dvb_manager_instance_mutex = {0};
extern GDBusConnection* main_conn;
static gpointer dvb_manager_scanner_data_parent_class = NULL;
static DVBIDBusManagerIface* dvb_manager_dvb_id_bus_manager_parent_iface = NULL;

GType dvb_id_bus_manager_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_adapter_info_get_type (void) G_GNUC_CONST;
DVBAdapterInfo* dvb_adapter_info_dup (const DVBAdapterInfo* self);
void dvb_adapter_info_free (DVBAdapterInfo* self);
void dvb_adapter_info_copy (const DVBAdapterInfo* self, DVBAdapterInfo* dest);
void dvb_adapter_info_destroy (DVBAdapterInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
GType dvb_manager_get_type (void) G_GNUC_CONST;
static GType dvb_manager_scanner_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
#define DVB_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_MANAGER, DVBManagerPrivate))
enum  {
	DVB_MANAGER_DUMMY_PROPERTY,
	DVB_MANAGER_DEVICE_GROUPS
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBManager* dvb_manager_get_instance (void);
DVBManager* dvb_manager_new (void);
DVBManager* dvb_manager_construct (GType object_type);
void dvb_manager_shutdown (void);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_scanner_get_type (void) G_GNUC_CONST;
void dvb_scanner_do_destroy (DVBScanner* self);
void dvb_device_group_destroy (DVBDeviceGroup* self);
static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error);
#define DVB_CONSTANTS_DBUS_SCANNER_PATH "/org/gnome/DVB/Scanner/%d/%d"
GType dvb_device_get_type (void) G_GNUC_CONST;
static DVBDevice* dvb_manager_get_registered_device (DVBManager* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
static DVBDeviceGroup* dvb_manager_get_device_group_of_device (DVBManager* self, DVBDevice* device);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
DVBAdapterType dvb_device_get_Type (DVBDevice* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static DVBManagerScannerData* dvb_manager_scanner_data_new (void);
static DVBManagerScannerData* dvb_manager_scanner_data_construct (GType object_type);
DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device);
DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_terrestrial_scanner_get_type (void) G_GNUC_CONST;
DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device);
DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_satellite_scanner_get_type (void) G_GNUC_CONST;
DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device);
DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device);
GType dvb_cable_scanner_get_type (void) G_GNUC_CONST;
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner);
static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self);
static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error);
#define DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH "/org/gnome/DVB/DeviceGroup/%u"
static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error);
static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
GQuark dvb_device_error_quark (void);
DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, GError** error);
gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const gchar* value);
gboolean dvb_manager_restore_device_group (DVBManager* self, DVBDeviceGroup* device_group, gboolean store);
static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, gchar** name, GError** error);
const gchar* dvb_device_get_Name (DVBDevice* self);
static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error);
static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (DVBFactory* self);
GeeList* dvb_database_config_store_get_channel_groups (DVBdatabaseConfigStore* self, GError** error);
gint dvb_channel_group_get_id (DVBChannelGroup* self);
const gchar* dvb_channel_group_get_name (DVBChannelGroup* self);
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length);
static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const gchar* name, gint* channel_group_id, GError** error);
gboolean dvb_database_config_store_add_channel_group (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_remove_channel_group (DVBdatabaseConfigStore* self, gint group_id, GError** error);
static GHashTable** dvb_manager_real_GetDevices (DVBIDBusManager* base, int* result_length1, GError** error);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_list_free__g_hash_table_unref0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean dvb_manager_real_GetAdapterInfo (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup, gboolean store);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
gboolean dvb_database_config_store_add_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
GType dvb_id_bus_device_group_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_device_group_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_device_group_get_type (void) G_GNUC_CONST;
static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBIDBusDeviceGroup* idevgroup, guint adapter, guint frontend);
static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* _sender, guint adapter, guint frontend, gpointer self);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error);
void dvb_manager_restore_timers (DVBManager* self, DVBDeviceGroup* device_group);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_database_timers_store_get_type (void) G_GNUC_CONST;
DVBdatabaseTimersStore* dvb_factory_get_timers_store (DVBFactory* self);
GeeList* dvb_database_timers_store_get_all_timers_of_device_group (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
GType dvb_recorder_get_type (void) G_GNUC_CONST;
DVBRecorder* dvb_device_group_get_recorder (DVBDeviceGroup* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id);
gboolean dvb_database_timers_store_remove_timer_from_device_group (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
DVBDevice* dvb_device_new (guint adapter, guint frontend);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
gboolean dvb_database_config_store_remove_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
DVBdatabaseEPGStore* dvb_factory_get_epg_store (DVBFactory* self);
gboolean dvb_database_epg_store_remove_events_of_group (DVBdatabaseEPGStore* self, guint group_id, GError** error);
gboolean dvb_database_timers_store_remove_all_timers_from_device_group (DVBdatabaseTimersStore* self, guint group_id, GError** error);
static void dvb_manager_create_device_group_by_id (DVBManager* self, guint group_id);
GeeList* dvb_database_config_store_get_all_device_groups (DVBdatabaseConfigStore* self, GError** error);
static void dvb_manager_on_udev_event (DVBManager* self, const gchar* action, GUdevDevice* device);
gboolean dvb_database_config_store_get_parent_group (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device);
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _dvb_manager_on_udev_event_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
enum  {
	DVB_MANAGER_SCANNER_DATA_DUMMY_PROPERTY
};
static void dvb_manager_scanner_data_finalize (GObject* obj);
static void dvb_manager_finalize (GObject* obj);
static void _vala_dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* DVB_MANAGER_UDEV_SUBSYSTEMS[2] = {"dvb", NULL};

DVBManager* dvb_manager_get_instance (void) {
	DVBManager* result = NULL;
	DVBManager* _tmp0_;
	DVBManager* _tmp2_;
	g_static_rec_mutex_lock (&dvb_manager_instance_mutex);
	_tmp0_ = dvb_manager_instance;
	if (_tmp0_ == NULL) {
		DVBManager* _tmp1_;
		_tmp1_ = dvb_manager_new ();
		_g_object_unref0 (dvb_manager_instance);
		dvb_manager_instance = _tmp1_;
	}
	g_static_rec_mutex_unlock (&dvb_manager_instance_mutex);
	_tmp2_ = dvb_manager_instance;
	result = _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_manager_shutdown (void) {
	DVBManager* _tmp0_;
	DVBManager* _tmp1_;
	DVBManager* m;
	DVBManager* _tmp2_;
	GError * _inner_error_ = NULL;
	g_static_rec_mutex_lock (&dvb_manager_instance_mutex);
	_tmp0_ = dvb_manager_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	m = _tmp1_;
	_tmp2_ = dvb_manager_instance;
	if (_tmp2_ != NULL) {
		DVBManager* _tmp3_;
		_tmp3_ = m;
		_g_object_unref0 (_tmp3_->priv->udev_client);
		_tmp3_->priv->udev_client = NULL;
		{
			DVBManager* _tmp4_;
			GeeHashMap* _tmp5_;
			_tmp4_ = m;
			_tmp5_ = _tmp4_->priv->scanners;
			g_static_rec_mutex_lock (&_tmp4_->priv->__lock_scanners);
			{
				DVBManager* _tmp24_;
				GeeHashMap* _tmp25_;
				{
					DVBManager* _tmp6_;
					GeeHashMap* _tmp7_;
					GeeCollection* _tmp8_;
					GeeCollection* _tmp9_;
					GeeCollection* _tmp10_;
					GeeIterator* _tmp11_ = NULL;
					GeeIterator* _tmp12_;
					GeeIterator* _data_it;
					_tmp6_ = m;
					_tmp7_ = _tmp6_->priv->scanners;
					_tmp8_ = gee_map_get_values ((GeeMap*) _tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = _tmp9_;
					_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
					_tmp12_ = _tmp11_;
					_g_object_unref0 (_tmp10_);
					_data_it = _tmp12_;
					while (TRUE) {
						GeeIterator* _tmp13_;
						gboolean _tmp14_ = FALSE;
						GeeIterator* _tmp15_;
						gpointer _tmp16_ = NULL;
						DVBManagerScannerData* data;
						DVBLoggingLogger* _tmp17_;
						DVBManagerScannerData* _tmp18_;
						DVBScanner* _tmp19_;
						DVBManagerScannerData* _tmp20_;
						gulong _tmp21_;
						DVBManagerScannerData* _tmp22_;
						DVBScanner* _tmp23_;
						_tmp13_ = _data_it;
						_tmp14_ = gee_iterator_next (_tmp13_);
						if (!_tmp14_) {
							break;
						}
						_tmp15_ = _data_it;
						_tmp16_ = gee_iterator_get (_tmp15_);
						data = (DVBManagerScannerData*) _tmp16_;
						_tmp17_ = dvb_manager_log;
						dvb_logging_logger_debug (_tmp17_, "Manager.vala:80: Stopping scanner");
						_tmp18_ = data;
						_tmp19_ = _tmp18_->scanner;
						_tmp20_ = data;
						_tmp21_ = _tmp20_->signal_id;
						g_signal_handler_disconnect ((GObject*) _tmp19_, _tmp21_);
						_tmp22_ = data;
						_tmp23_ = _tmp22_->scanner;
						dvb_scanner_do_destroy (_tmp23_);
						_g_object_unref0 (data);
					}
					_g_object_unref0 (_data_it);
				}
				_tmp24_ = m;
				_tmp25_ = _tmp24_->priv->scanners;
				gee_abstract_map_clear ((GeeAbstractMap*) _tmp25_);
			}
			__finally85:
			{
				DVBManager* _tmp26_;
				GeeHashMap* _tmp27_;
				_tmp26_ = m;
				_tmp27_ = _tmp26_->priv->scanners;
				g_static_rec_mutex_unlock (&_tmp26_->priv->__lock_scanners);
			}
			if (_inner_error_ != NULL) {
				_g_object_unref0 (m);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			DVBManager* _tmp28_;
			GeeHashMap* _tmp29_;
			_tmp28_ = m;
			_tmp29_ = _tmp28_->priv->devices;
			g_static_rec_mutex_lock (&_tmp28_->priv->__lock_devices);
			{
				DVBManager* _tmp42_;
				GeeHashMap* _tmp43_;
				{
					DVBManager* _tmp30_;
					GeeHashMap* _tmp31_;
					GeeCollection* _tmp32_;
					GeeCollection* _tmp33_;
					GeeCollection* _tmp34_;
					GeeIterator* _tmp35_ = NULL;
					GeeIterator* _tmp36_;
					GeeIterator* _devgrp_it;
					_tmp30_ = m;
					_tmp31_ = _tmp30_->priv->devices;
					_tmp32_ = gee_map_get_values ((GeeMap*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = _tmp33_;
					_tmp35_ = gee_iterable_iterator ((GeeIterable*) _tmp34_);
					_tmp36_ = _tmp35_;
					_g_object_unref0 (_tmp34_);
					_devgrp_it = _tmp36_;
					while (TRUE) {
						GeeIterator* _tmp37_;
						gboolean _tmp38_ = FALSE;
						GeeIterator* _tmp39_;
						gpointer _tmp40_ = NULL;
						DVBDeviceGroup* devgrp;
						DVBDeviceGroup* _tmp41_;
						_tmp37_ = _devgrp_it;
						_tmp38_ = gee_iterator_next (_tmp37_);
						if (!_tmp38_) {
							break;
						}
						_tmp39_ = _devgrp_it;
						_tmp40_ = gee_iterator_get (_tmp39_);
						devgrp = (DVBDeviceGroup*) _tmp40_;
						_tmp41_ = devgrp;
						dvb_device_group_destroy (_tmp41_);
						_g_object_unref0 (devgrp);
					}
					_g_object_unref0 (_devgrp_it);
				}
				_tmp42_ = m;
				_tmp43_ = _tmp42_->priv->devices;
				gee_abstract_map_clear ((GeeAbstractMap*) _tmp43_);
			}
			__finally86:
			{
				DVBManager* _tmp44_;
				GeeHashMap* _tmp45_;
				_tmp44_ = m;
				_tmp45_ = _tmp44_->priv->devices;
				g_static_rec_mutex_unlock (&_tmp44_->priv->__lock_devices);
			}
			if (_inner_error_ != NULL) {
				_g_object_unref0 (m);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (dvb_manager_instance);
		dvb_manager_instance = NULL;
	}
	g_static_rec_mutex_unlock (&dvb_manager_instance_mutex);
	_g_object_unref0 (m);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @opath: Object path of the scanner service
         * @dbusiface: DBus interface of the scanner service
         * @returns: TRUE on success
         *
         * Get the object path of the channel scanner for this device.
         */
static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self) {
	dvb_manager_on_scanner_destroyed (self, _sender);
}


static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error) {
	DVBManager * self;
	char* _vala_opath = NULL;
	gchar* _vala_dbusiface = NULL;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* path;
	const gchar* _tmp3_;
	char* _tmp4_;
	DVBDevice* device = NULL;
	guint _tmp5_;
	guint _tmp6_;
	DVBDevice* _tmp7_ = NULL;
	DVBDevice* reg_dev;
	DVBDevice* _tmp8_;
	DVBDevice* _tmp17_;
	DVBAdapterType _tmp18_;
	DVBAdapterType _tmp19_;
	const gchar* _tmp21_;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, _tmp0_, _tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_opath);
	_vala_opath = _tmp4_;
	_tmp5_ = adapter;
	_tmp6_ = frontend;
	_tmp7_ = dvb_manager_get_registered_device (self, _tmp5_, _tmp6_);
	reg_dev = _tmp7_;
	_tmp8_ = reg_dev;
	if (_tmp8_ == NULL) {
		guint _tmp9_;
		guint _tmp10_;
		DVBDevice* _tmp11_ = NULL;
		_tmp9_ = adapter;
		_tmp10_ = frontend;
		_tmp11_ = dvb_device_new_with_type (_tmp9_, _tmp10_);
		_g_object_unref0 (device);
		device = _tmp11_;
	} else {
		DVBDevice* _tmp12_;
		DVBDeviceGroup* _tmp13_ = NULL;
		DVBDeviceGroup* _tmp14_;
		DVBDevice* _tmp15_;
		DVBDevice* _tmp16_;
		_tmp12_ = reg_dev;
		_tmp13_ = dvb_manager_get_device_group_of_device (self, _tmp12_);
		_tmp14_ = _tmp13_;
		dvb_device_group_stop_epg_scanner (_tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = reg_dev;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_g_object_unref0 (device);
		device = _tmp16_;
	}
	_tmp17_ = device;
	_tmp18_ = dvb_device_get_Type (_tmp17_);
	_tmp19_ = _tmp18_;
	switch (_tmp19_) {
		case DVB_ADAPTER_TYPE_DVB_C:
		case DVB_ADAPTER_TYPE_DVB_S:
		case DVB_ADAPTER_TYPE_DVB_T:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("org.gnome.DVB.Scanner");
			_g_free0 (_vala_dbusiface);
			_vala_dbusiface = _tmp20_;
			break;
		}
		default:
		{
			_g_free0 (_vala_dbusiface);
			_vala_dbusiface = NULL;
			break;
		}
	}
	_tmp21_ = _vala_dbusiface;
	if (_tmp21_ == NULL) {
		DVBLoggingLogger* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = dvb_manager_log;
		dvb_logging_logger_error (_tmp22_, "Manager.vala:141: Unknown adapter type");
		_tmp23_ = g_strdup ("");
		_g_free0 (_vala_dbusiface);
		_vala_dbusiface = _tmp23_;
		result = FALSE;
		_g_object_unref0 (reg_dev);
		_g_object_unref0 (device);
		_g_free0 (path);
		if (opath) {
			*opath = _vala_opath;
		} else {
			_g_free0 (_vala_opath);
		}
		if (dbusiface) {
			*dbusiface = _vala_dbusiface;
		} else {
			_g_free0 (_vala_dbusiface);
		}
		return result;
	}
	{
		GeeHashMap* _tmp24_;
		_tmp24_ = self->priv->scanners;
		g_static_rec_mutex_lock (&self->priv->__lock_scanners);
		{
			GeeHashMap* _tmp25_;
			const gchar* _tmp26_;
			gboolean _tmp27_ = FALSE;
			_tmp25_ = self->priv->scanners;
			_tmp26_ = path;
			_tmp27_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp25_, _tmp26_);
			if (!_tmp27_) {
				DVBManagerScannerData* _tmp28_;
				DVBManagerScannerData* data;
				DVBDevice* _tmp29_;
				DVBAdapterType _tmp30_;
				DVBAdapterType _tmp31_;
				GDBusConnection* _tmp41_;
				const gchar* _tmp42_;
				DVBManagerScannerData* _tmp43_;
				DVBScanner* _tmp44_;
				DVBManagerScannerData* _tmp45_;
				DVBManagerScannerData* _tmp46_;
				DVBScanner* _tmp47_;
				gulong _tmp48_ = 0UL;
				GeeHashMap* _tmp49_;
				const gchar* _tmp50_;
				DVBManagerScannerData* _tmp51_;
				DVBLoggingLogger* _tmp52_;
				guint _tmp53_;
				guint _tmp54_;
				const gchar* _tmp55_;
				_tmp28_ = dvb_manager_scanner_data_new ();
				data = _tmp28_;
				_tmp29_ = device;
				_tmp30_ = dvb_device_get_Type (_tmp29_);
				_tmp31_ = _tmp30_;
				switch (_tmp31_) {
					case DVB_ADAPTER_TYPE_DVB_T:
					{
						DVBManagerScannerData* _tmp32_;
						DVBDevice* _tmp33_;
						DVBTerrestrialScanner* _tmp34_;
						_tmp32_ = data;
						_tmp33_ = device;
						_tmp34_ = dvb_terrestrial_scanner_new (_tmp33_);
						_g_object_unref0 (_tmp32_->scanner);
						_tmp32_->scanner = (DVBScanner*) _tmp34_;
						break;
					}
					case DVB_ADAPTER_TYPE_DVB_S:
					{
						DVBManagerScannerData* _tmp35_;
						DVBDevice* _tmp36_;
						DVBSatelliteScanner* _tmp37_;
						_tmp35_ = data;
						_tmp36_ = device;
						_tmp37_ = dvb_satellite_scanner_new (_tmp36_);
						_g_object_unref0 (_tmp35_->scanner);
						_tmp35_->scanner = (DVBScanner*) _tmp37_;
						break;
					}
					case DVB_ADAPTER_TYPE_DVB_C:
					{
						DVBManagerScannerData* _tmp38_;
						DVBDevice* _tmp39_;
						DVBCableScanner* _tmp40_;
						_tmp38_ = data;
						_tmp39_ = device;
						_tmp40_ = dvb_cable_scanner_new (_tmp39_);
						_g_object_unref0 (_tmp38_->scanner);
						_tmp38_->scanner = (DVBScanner*) _tmp40_;
						break;
					}
					default:
					break;
				}
				_tmp41_ = main_conn;
				_tmp42_ = path;
				_tmp43_ = data;
				_tmp44_ = _tmp43_->scanner;
				dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_SCANNER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp41_, _tmp42_, DVB_ID_BUS_SCANNER (_tmp44_));
				_tmp45_ = data;
				_tmp46_ = data;
				_tmp47_ = _tmp46_->scanner;
				_tmp48_ = g_signal_connect_object (_tmp47_, "destroyed", (GCallback) _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed, self, 0);
				_tmp45_->signal_id = _tmp48_;
				_tmp49_ = self->priv->scanners;
				_tmp50_ = path;
				_tmp51_ = data;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp49_, _tmp50_, _tmp51_);
				_tmp52_ = dvb_manager_log;
				_tmp53_ = adapter;
				_tmp54_ = frontend;
				_tmp55_ = _vala_dbusiface;
				dvb_logging_logger_debug (_tmp52_, "Manager.vala:169: Created new Scanner D-Bus service for adapter %u, fr" \
"ontend %u (%s)", _tmp53_, _tmp54_, _tmp55_);
				_g_object_unref0 (data);
			}
		}
		__finally87:
		{
			GeeHashMap* _tmp56_;
			_tmp56_ = self->priv->scanners;
			g_static_rec_mutex_unlock (&self->priv->__lock_scanners);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (reg_dev);
				_g_object_unref0 (device);
				_g_free0 (path);
				return FALSE;
			} else {
				_g_object_unref0 (reg_dev);
				_g_object_unref0 (device);
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (reg_dev);
	_g_object_unref0 (device);
	_g_free0 (path);
	if (opath) {
		*opath = _vala_opath;
	} else {
		_g_free0 (_vala_opath);
	}
	if (dbusiface) {
		*dbusiface = _vala_dbusiface;
	} else {
		_g_free0 (_vala_dbusiface);
	}
	return result;
}


/**
         * @group_id: A group ID
         * @path: Device group's DBus path
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error) {
	DVBManager * self;
	char* _vala_opath = NULL;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->devices;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeHashMap* _tmp1_;
			guint _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->devices;
			_tmp2_ = group_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				guint _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				char* _tmp7_;
				_tmp4_ = group_id;
				_tmp5_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (_vala_opath);
				_vala_opath = _tmp7_;
				_g_free0 (_tmp6_);
				ret = TRUE;
			} else {
				char* _tmp8_;
				_tmp8_ = g_strdup ("");
				_g_free0 (_vala_opath);
				_vala_opath = _tmp8_;
				ret = FALSE;
			}
		}
		__finally88:
		{
			GeeHashMap* _tmp9_;
			_tmp9_ = self->priv->devices;
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (opath) {
		*opath = _vala_opath;
	} else {
		_g_free0 (_vala_opath);
	}
	return result;
}


/**
         * @returns: Device groups' DBus path
         */
static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	char** result = NULL;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	char** _tmp3_ = NULL;
	char** devs;
	gint devs_length1;
	gint _devs_size_;
	gint i;
	char** _tmp24_;
	gint _tmp24__length1;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (char*, _tmp2_ + 1);
	devs = _tmp3_;
	devs_length1 = _tmp2_;
	_devs_size_ = devs_length1;
	i = 0;
	{
		GeeHashMap* _tmp4_;
		_tmp4_ = self->priv->devices;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			{
				GeeHashMap* _tmp5_;
				GeeSet* _tmp6_;
				GeeSet* _tmp7_;
				GeeSet* _tmp8_;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_;
				GeeIterator* _key_it;
				_tmp5_ = self->priv->devices;
				_tmp6_ = gee_map_get_keys ((GeeMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_key_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_;
					gboolean _tmp12_ = FALSE;
					GeeIterator* _tmp13_;
					gpointer _tmp14_ = NULL;
					guint key;
					char** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					guint _tmp17_;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					char* _tmp20_;
					char* _tmp21_;
					gint _tmp22_;
					_tmp11_ = _key_it;
					_tmp12_ = gee_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _key_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					key = GPOINTER_TO_UINT (_tmp14_);
					_tmp15_ = devs;
					_tmp15__length1 = devs_length1;
					_tmp16_ = i;
					_tmp17_ = key;
					_tmp18_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (_tmp15_[_tmp16_]);
					_tmp15_[_tmp16_] = _tmp20_;
					_tmp21_ = _tmp15_[_tmp16_];
					_g_free0 (_tmp19_);
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally89:
		{
			GeeHashMap* _tmp23_;
			_tmp23_ = self->priv->devices;
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				devs = (_vala_array_free (devs, devs_length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			} else {
				devs = (_vala_array_free (devs, devs_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp24_ = devs;
	_tmp24__length1 = devs_length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	return result;
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @channels_conf: Path to channels.conf for this device
         * @recordings_dir: Path where the recordings should be stored
         * @name: Name of group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new DeviceGroup and new DVB device whereas the
         * DVB device is the reference device of this group (i.e.
         * all other devices of this group will inherit the settings
         * of the reference device).
         */
static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error) {
	DVBManager * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* chan_file;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* rec_dir;
	DVBDevice* device = NULL;
	DVBDevice* _tmp13_;
	gboolean _tmp14_ = FALSE;
	guint _tmp15_;
	guint _tmp16_;
	DVBDevice* _tmp17_;
	DVBDeviceGroup* _tmp18_;
	DVBDeviceGroup* devgroup;
	DVBDeviceGroup* _tmp19_;
	const gchar* _tmp20_;
	DVBDeviceGroup* _tmp21_;
	guint _tmp22_;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	g_return_val_if_fail (channels_conf != NULL, FALSE);
	g_return_val_if_fail (recordings_dir != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = channels_conf;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	chan_file = _tmp1_;
	_tmp2_ = recordings_dir;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	rec_dir = _tmp3_;
	{
		guint _tmp4_;
		guint _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		DVBDevice* _tmp8_ = NULL;
		DVBDevice* _tmp9_;
		_tmp4_ = adapter;
		_tmp5_ = frontend;
		_tmp6_ = chan_file;
		_tmp7_ = rec_dir;
		_tmp8_ = dvb_device_new_full (_tmp4_, _tmp5_, _tmp6_, _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DEVICE_ERROR) {
				goto __catch90_dvb_device_error;
			}
			_g_object_unref0 (device);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (chan_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (device);
		device = _tmp9_;
	}
	goto __finally90;
	__catch90_dvb_device_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = dvb_manager_log;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		dvb_logging_logger_error (_tmp10_, "Manager.vala:239: Could not create device: %s", _tmp12_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		return result;
	}
	__finally90:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (device);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (chan_file);
			return FALSE;
		} else {
			_g_object_unref0 (device);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (chan_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp13_ = device;
	_tmp14_ = dvb_manager_device_is_in_any_group (self, _tmp13_);
	if (_tmp14_) {
		result = FALSE;
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		return result;
	}
	_tmp15_ = self->priv->device_group_counter;
	self->priv->device_group_counter = _tmp15_ + 1;
	_tmp16_ = self->priv->device_group_counter;
	_tmp17_ = device;
	_tmp18_ = dvb_device_group_new (_tmp16_, _tmp17_, TRUE);
	devgroup = _tmp18_;
	_tmp19_ = devgroup;
	_tmp20_ = name;
	dvb_device_group_set_Name (_tmp19_, _tmp20_);
	_tmp21_ = devgroup;
	dvb_manager_restore_device_group (self, _tmp21_, TRUE);
	_tmp22_ = self->priv->device_group_counter;
	g_signal_emit_by_name ((DVBIDBusManager*) self, "group-added", _tmp22_);
	result = TRUE;
	_g_object_unref0 (devgroup);
	_g_object_unref0 (device);
	_g_object_unref0 (rec_dir);
	_g_object_unref0 (chan_file);
	return result;
}


/**
         * @adapter: Adapter of device
         * @frontend: Frontend of device
         * @name: The name of the device or "Unknown"
         * @returns: TRUE on success
         *
         * The device must be part of group, otherwise "Unknown"
         * is returned.
         */
static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, gchar** name, GError** error) {
	DVBManager * self;
	gchar* _vala_name = NULL;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	DVBDevice* _tmp2_ = NULL;
	DVBDevice* dev;
	DVBDevice* _tmp3_;
	self = (DVBManager*) base;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = dvb_manager_get_registered_device (self, _tmp0_, _tmp1_);
	dev = _tmp2_;
	_tmp3_ = dev;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_vala_name);
		_vala_name = _tmp4_;
		result = FALSE;
		_g_object_unref0 (dev);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	} else {
		DVBDevice* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = dev;
		_tmp6_ = dvb_device_get_Name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (_vala_name);
		_vala_name = _tmp8_;
		result = TRUE;
		_g_object_unref0 (dev);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	}
	_g_object_unref0 (dev);
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
}


/**
         * @returns: the numner of configured device groups
         */
static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error) {
	DVBManager * self;
	gint result = 0;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (DVBManager*) base;
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


/**
         * @returns: ID and name of each channel group
         */
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_group_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	DVBChannelGroupInfo* result = NULL;
	DVBFactory* _tmp0_;
	DVBFactory* _tmp1_;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_;
	DVBdatabaseConfigStore* config;
	GeeList* groups = NULL;
	GeeList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	DVBChannelGroupInfo* _tmp15_ = NULL;
	DVBChannelGroupInfo* arr;
	gint arr_length1;
	gint _arr_size_;
	DVBChannelGroupInfo* _tmp39_;
	gint _tmp39__length1;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	{
		DVBdatabaseConfigStore* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp4_ = config;
		_tmp5_ = dvb_database_config_store_get_channel_groups (_tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch91_dvb_database_sql_error;
			}
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (groups);
		groups = _tmp6_;
	}
	goto __finally91;
	__catch91_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		DVBChannelGroupInfo* _tmp10_ = NULL;
		DVBChannelGroupInfo* _tmp11_;
		gint _tmp11__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = dvb_manager_log;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		dvb_logging_logger_error (_tmp7_, "Manager.vala:297: %s", _tmp9_);
		_tmp10_ = g_new0 (DVBChannelGroupInfo, 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp11__length1;
		}
		result = _tmp11_;
		_g_error_free0 (e);
		_g_object_unref0 (groups);
		_g_object_unref0 (config);
		return result;
	}
	__finally91:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			return NULL;
		} else {
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = groups;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_new0 (DVBChannelGroupInfo, _tmp14_);
	arr = _tmp15_;
	arr_length1 = _tmp14_;
	_arr_size_ = arr_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				DVBChannelGroupInfo* _tmp20_;
				gint _tmp20__length1;
				GeeList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_ = NULL;
				DVBChannelGroup* cg;
				DVBChannelGroupInfo* _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				DVBChannelGroupInfo _tmp26_ = {0};
				DVBChannelGroupInfo _tmp27_;
				DVBChannelGroupInfo* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				DVBChannelGroup* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				DVBChannelGroupInfo* _tmp33_;
				gint _tmp33__length1;
				gint _tmp34_;
				DVBChannelGroup* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = arr;
				_tmp20__length1 = arr_length1;
				if (!(_tmp19_ < _tmp20__length1)) {
					break;
				}
				_tmp21_ = groups;
				_tmp22_ = i;
				_tmp23_ = gee_list_get (_tmp21_, _tmp22_);
				cg = (DVBChannelGroup*) _tmp23_;
				_tmp24_ = arr;
				_tmp24__length1 = arr_length1;
				_tmp25_ = i;
				memset (&_tmp26_, 0, sizeof (DVBChannelGroupInfo));
				dvb_channel_group_info_destroy (&_tmp24_[_tmp25_]);
				_tmp24_[_tmp25_] = _tmp26_;
				_tmp27_ = _tmp24_[_tmp25_];
				_tmp28_ = arr;
				_tmp28__length1 = arr_length1;
				_tmp29_ = i;
				_tmp30_ = cg;
				_tmp31_ = dvb_channel_group_get_id (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp28_[_tmp29_].id = _tmp32_;
				_tmp33_ = arr;
				_tmp33__length1 = arr_length1;
				_tmp34_ = i;
				_tmp35_ = cg;
				_tmp36_ = dvb_channel_group_get_name (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strdup (_tmp37_);
				_g_free0 (_tmp33_[_tmp34_].name);
				_tmp33_[_tmp34_].name = _tmp38_;
				_g_object_unref0 (cg);
			}
		}
	}
	_tmp39_ = arr;
	_tmp39__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp39__length1;
	}
	result = _tmp39_;
	_g_object_unref0 (groups);
	_g_object_unref0 (config);
	return result;
}


/**
         * @name: Name of the new group
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const gchar* name, gint* channel_group_id, GError** error) {
	DVBManager * self;
	gint _vala_channel_group_id = 0;
	gboolean result = FALSE;
	DVBFactory* _tmp0_;
	DVBFactory* _tmp1_;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_;
	DVBdatabaseConfigStore* config;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	{
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		_tmp4_ = name;
		_tmp6_ = dvb_database_config_store_add_channel_group (config, _tmp4_, &_tmp5_, &_inner_error_);
		_vala_channel_group_id = _tmp5_;
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch92_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp7_;
	}
	goto __finally92;
	__catch92_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = dvb_manager_log;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		dvb_logging_logger_error (_tmp8_, "Manager.vala:320: %s", _tmp10_);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally92:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	if (channel_group_id) {
		*channel_group_id = _vala_channel_group_id;
	}
	return result;
}


/**
     * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error) {
	DVBManager * self;
	gboolean result = FALSE;
	DVBFactory* _tmp0_;
	DVBFactory* _tmp1_;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_;
	DVBdatabaseConfigStore* config;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	{
		gint _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp4_ = channel_group_id;
		_tmp5_ = dvb_database_config_store_remove_channel_group (config, _tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch93_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp6_;
	}
	goto __finally93;
	__catch93_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = dvb_manager_log;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		dvb_logging_logger_error (_tmp7_, "Manager.vala:336: %s", _tmp9_);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally93:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	return result;
}


/**
         * @returns: informations about all connected
         * devices retrieved via udev
         */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _g_hash_table_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}


static void _g_list_free__g_hash_table_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_hash_table_unref0_, NULL);
	g_list_free (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GHashTable** dvb_manager_real_GetDevices (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	GHashTable** result = NULL;
	GUdevClient* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* devices;
	GList* devices_list;
	GList* _tmp50_;
	guint _tmp51_ = 0U;
	GHashTable** _tmp52_ = NULL;
	GHashTable** arr;
	gint arr_length1;
	gint _arr_size_;
	GHashTable** _tmp66_;
	gint _tmp66__length1;
	self = (DVBManager*) base;
	_tmp0_ = self->priv->udev_client;
	_tmp1_ = g_udev_client_query_by_subsystem (_tmp0_, "dvb");
	devices = _tmp1_;
	devices_list = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				GList* _tmp6_;
				guint _tmp7_ = 0U;
				GList* _tmp8_;
				gint _tmp9_;
				gconstpointer _tmp10_ = NULL;
				GUdevDevice* _tmp11_;
				GUdevDevice* dev;
				GUdevDevice* _tmp12_;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* device_file;
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp16_;
				gboolean _tmp19_;
				GHashFunc _tmp20_;
				GEqualFunc _tmp21_;
				GDestroyNotify _tmp22_;
				GDestroyNotify _tmp23_;
				GHashTable* _tmp24_;
				GHashTable* map;
				GHashTable* _tmp25_;
				GHashTable* _tmp26_;
				GHashTable* _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				GUdevDevice* _tmp31_;
				GUdevDevice* _tmp32_ = NULL;
				GUdevDevice* parent;
				GUdevDevice* _tmp33_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = devices;
				_tmp7_ = g_list_length (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = devices;
				_tmp9_ = i;
				_tmp10_ = g_list_nth_data (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _g_object_ref0 ((GUdevDevice*) _tmp10_);
				dev = _tmp11_;
				_tmp12_ = dev;
				_tmp13_ = g_udev_device_get_device_file (_tmp12_);
				_tmp14_ = g_strdup (_tmp13_);
				device_file = _tmp14_;
				_tmp16_ = device_file;
				if (_tmp16_ == NULL) {
					_tmp15_ = TRUE;
				} else {
					const gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					_tmp17_ = device_file;
					_tmp18_ = string_contains (_tmp17_, "frontend");
					_tmp15_ = !_tmp18_;
				}
				_tmp19_ = _tmp15_;
				if (_tmp19_) {
					_g_free0 (device_file);
					_g_object_unref0 (dev);
					continue;
				}
				_tmp20_ = g_str_hash;
				_tmp21_ = g_str_equal;
				_tmp22_ = g_free;
				_tmp23_ = g_free;
				_tmp24_ = g_hash_table_new_full (_tmp20_, _tmp21_, _tmp22_, _tmp23_);
				map = _tmp24_;
				_tmp25_ = map;
				_tmp26_ = _g_hash_table_ref0 (_tmp25_);
				devices_list = g_list_prepend (devices_list, _tmp26_);
				_tmp27_ = map;
				_tmp28_ = g_strdup ("device_file");
				_tmp29_ = device_file;
				_tmp30_ = g_strdup (_tmp29_);
				g_hash_table_insert (_tmp27_, _tmp28_, _tmp30_);
				_tmp31_ = dev;
				_tmp32_ = g_udev_device_get_parent (_tmp31_);
				parent = _tmp32_;
				_tmp33_ = parent;
				if (_tmp33_ != NULL) {
					gchar* attr = NULL;
					GUdevDevice* _tmp34_;
					const gchar* _tmp35_ = NULL;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					GUdevDevice* _tmp42_;
					const gchar* _tmp43_ = NULL;
					gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp34_ = parent;
					_tmp35_ = g_udev_device_get_sysfs_attr (_tmp34_, "manufacturer");
					_tmp36_ = g_strdup (_tmp35_);
					_g_free0 (attr);
					attr = _tmp36_;
					_tmp37_ = attr;
					if (_tmp37_ != NULL) {
						GHashTable* _tmp38_;
						gchar* _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp38_ = map;
						_tmp39_ = g_strdup ("manufacturer");
						_tmp40_ = attr;
						_tmp41_ = g_strdup (_tmp40_);
						g_hash_table_insert (_tmp38_, _tmp39_, _tmp41_);
					}
					_tmp42_ = parent;
					_tmp43_ = g_udev_device_get_sysfs_attr (_tmp42_, "product");
					_tmp44_ = g_strdup (_tmp43_);
					_g_free0 (attr);
					attr = _tmp44_;
					_tmp45_ = attr;
					if (_tmp45_ != NULL) {
						GHashTable* _tmp46_;
						gchar* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp46_ = map;
						_tmp47_ = g_strdup ("product");
						_tmp48_ = attr;
						_tmp49_ = g_strdup (_tmp48_);
						g_hash_table_insert (_tmp46_, _tmp47_, _tmp49_);
					}
					_g_free0 (attr);
				}
				_g_object_unref0 (parent);
				_g_hash_table_unref0 (map);
				_g_free0 (device_file);
				_g_object_unref0 (dev);
			}
		}
	}
	_tmp50_ = devices_list;
	_tmp51_ = g_list_length (_tmp50_);
	_tmp52_ = g_new0 (GHashTable*, _tmp51_ + 1);
	arr = _tmp52_;
	arr_length1 = _tmp51_;
	_arr_size_ = arr_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp53_;
			_tmp53_ = TRUE;
			while (TRUE) {
				gboolean _tmp54_;
				gint _tmp56_;
				GList* _tmp57_;
				guint _tmp58_ = 0U;
				GHashTable** _tmp59_;
				gint _tmp59__length1;
				gint _tmp60_;
				GList* _tmp61_;
				gint _tmp62_;
				gconstpointer _tmp63_ = NULL;
				GHashTable* _tmp64_;
				GHashTable* _tmp65_;
				_tmp54_ = _tmp53_;
				if (!_tmp54_) {
					gint _tmp55_;
					_tmp55_ = i;
					i = _tmp55_ + 1;
				}
				_tmp53_ = FALSE;
				_tmp56_ = i;
				_tmp57_ = devices_list;
				_tmp58_ = g_list_length (_tmp57_);
				if (!(((guint) _tmp56_) < _tmp58_)) {
					break;
				}
				_tmp59_ = arr;
				_tmp59__length1 = arr_length1;
				_tmp60_ = i;
				_tmp61_ = devices_list;
				_tmp62_ = i;
				_tmp63_ = g_list_nth_data (_tmp61_, (guint) _tmp62_);
				_tmp64_ = _g_hash_table_ref0 ((GHashTable*) _tmp63_);
				_g_hash_table_unref0 (_tmp59_[_tmp60_]);
				_tmp59_[_tmp60_] = _tmp64_;
				_tmp65_ = _tmp59_[_tmp60_];
			}
		}
	}
	_tmp66_ = arr;
	_tmp66__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp66__length1;
	}
	result = _tmp66_;
	__g_list_free__g_hash_table_unref0_0 (devices_list);
	__g_list_free__g_object_unref0_0 (devices);
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static gboolean dvb_manager_real_GetAdapterInfo (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error) {
	DVBManager * self;
	DVBAdapterInfo _vala_info = {0};
	gboolean result = FALSE;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbelement;
	GstElement* _tmp1_;
	guint _tmp2_;
	GstElement* _tmp3_;
	guint _tmp4_;
	GstPipeline* _tmp5_;
	GstElement* pipeline;
	GstElement* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstBus* _tmp11_ = NULL;
	GstBus* bus;
	DVBAdapterInfo _tmp12_ = {0};
	gboolean success;
	GstElement* _tmp42_;
	gboolean _tmp43_;
	self = (DVBManager*) base;
	_tmp0_ = gst_element_factory_make ("dvbsrc", NULL);
	dvbelement = _tmp0_;
	_tmp1_ = dvbelement;
	_tmp2_ = adapter;
	g_object_set ((GObject*) _tmp1_, "adapter", _tmp2_, NULL);
	_tmp3_ = dvbelement;
	_tmp4_ = frontend;
	g_object_set ((GObject*) _tmp3_, "frontend", _tmp4_, NULL);
	_tmp5_ = (GstPipeline*) gst_pipeline_new (NULL);
	gst_object_ref_sink (_tmp5_);
	pipeline = (GstElement*) _tmp5_;
	_tmp6_ = pipeline;
	_tmp7_ = dvbelement;
	_tmp8_ = _gst_object_ref0 (_tmp7_);
	gst_bin_add (GST_BIN (_tmp6_), _tmp8_);
	_tmp9_ = pipeline;
	gst_element_set_state (_tmp9_, GST_STATE_READY);
	_tmp10_ = pipeline;
	_tmp11_ = gst_element_get_bus (_tmp10_);
	bus = _tmp11_;
	memset (&_tmp12_, 0, sizeof (DVBAdapterInfo));
	dvb_adapter_info_destroy (&_vala_info);
	_vala_info = _tmp12_;
	success = FALSE;
	while (TRUE) {
		GstBus* _tmp13_;
		gboolean _tmp14_ = FALSE;
		GstBus* _tmp15_;
		GstMessage* _tmp16_ = NULL;
		GstMessage* msg;
		gboolean _tmp17_ = FALSE;
		GstMessage* _tmp18_;
		GstMessageType _tmp19_;
		gboolean _tmp23_;
		_tmp13_ = bus;
		_tmp14_ = gst_bus_have_pending (_tmp13_);
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = bus;
		_tmp16_ = gst_bus_pop (_tmp15_);
		msg = _tmp16_;
		_tmp18_ = msg;
		_tmp19_ = _tmp18_->type;
		if (_tmp19_ == GST_MESSAGE_ELEMENT) {
			GstMessage* _tmp20_;
			GstObject* _tmp21_;
			GstElement* _tmp22_;
			_tmp20_ = msg;
			_tmp21_ = _tmp20_->src;
			_tmp22_ = dvbelement;
			_tmp17_ = _tmp21_ == GST_OBJECT (_tmp22_);
		} else {
			_tmp17_ = FALSE;
		}
		_tmp23_ = _tmp17_;
		if (_tmp23_) {
			GstMessage* _tmp24_;
			const GstStructure* _tmp25_ = NULL;
			GstStructure* _tmp26_;
			GstStructure* structure;
			const GstStructure* _tmp27_;
			const gchar* _tmp28_ = NULL;
			_tmp24_ = msg;
			_tmp25_ = gst_message_get_structure (_tmp24_);
			_tmp26_ = _gst_structure_copy0 (_tmp25_);
			structure = _tmp26_;
			_tmp27_ = structure;
			_tmp28_ = gst_structure_get_name (_tmp27_);
			if (g_strcmp0 (_tmp28_, "dvb-adapter") == 0) {
				const GstStructure* _tmp29_;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				const GstStructure* _tmp32_;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_;
				_tmp29_ = structure;
				_tmp30_ = gst_structure_get_string (_tmp29_, "name");
				_tmp31_ = g_strdup (_tmp30_);
				_g_free0 (_vala_info.name);
				_vala_info.name = _tmp31_;
				_tmp32_ = structure;
				_tmp33_ = gst_structure_get_string (_tmp32_, "type");
				_tmp34_ = g_strdup (_tmp33_);
				_g_free0 (_vala_info.type);
				_vala_info.type = _tmp34_;
				success = TRUE;
				_gst_structure_free0 (structure);
				_gst_message_unref0 (msg);
				break;
			}
			_gst_structure_free0 (structure);
		} else {
			GstMessage* _tmp35_;
			GstMessageType _tmp36_;
			_tmp35_ = msg;
			_tmp36_ = _tmp35_->type;
			if (_tmp36_ == GST_MESSAGE_ERROR) {
				DVBLoggingLogger* _tmp37_;
				GstMessage* _tmp38_;
				const GstStructure* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_;
				_tmp37_ = dvb_manager_log;
				_tmp38_ = msg;
				_tmp39_ = gst_message_get_structure (_tmp38_);
				_tmp40_ = gst_structure_to_string (_tmp39_);
				_tmp41_ = _tmp40_;
				dvb_logging_logger_warning (_tmp37_, "Manager.vala:407: Could not retrieve adapter infos: %s", _tmp41_);
				_g_free0 (_tmp41_);
			}
		}
		_gst_message_unref0 (msg);
	}
	_tmp42_ = pipeline;
	gst_element_set_state (_tmp42_, GST_STATE_NULL);
	_tmp43_ = success;
	if (!_tmp43_) {
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp44_ = g_strdup ("unknown");
		_g_free0 (_vala_info.name);
		_vala_info.name = _tmp44_;
		_tmp45_ = g_strdup ("unknown");
		_g_free0 (_vala_info.type);
		_vala_info.type = _tmp45_;
	}
	result = success;
	_gst_object_unref0 (bus);
	_gst_object_unref0 (pipeline);
	_gst_object_unref0 (dvbelement);
	if (info) {
		*info = _vala_info;
	} else {
		dvb_adapter_info_destroy (&_vala_info);
	}
	return result;
}


/**
         * @returns: Whether the device has been added successfully
         *
         * Register device, create Recorder and ChannelList D-Bus service
         */
static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* _sender, guint adapter, guint frontend, gpointer self) {
	dvb_manager_on_device_removed_from_group (self, _sender, adapter, frontend);
}


gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup, gboolean store) {
	gboolean result = FALSE;
	DVBDeviceGroup* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint group_id;
	DVBLoggingLogger* _tmp3_;
	guint _tmp4_;
	DVBDeviceGroup* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	DVBDeviceGroup* _tmp8_;
	DVBAdapterType _tmp9_;
	DVBAdapterType _tmp10_;
	gboolean _tmp20_;
	DVBDeviceGroup* _tmp29_;
	guint _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* path;
	GDBusConnection* _tmp32_;
	const gchar* _tmp33_;
	DVBDeviceGroup* _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	DVBDeviceGroup* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_tmp0_ = devgroup;
	_tmp1_ = dvb_device_group_get_Id (_tmp0_);
	_tmp2_ = _tmp1_;
	group_id = _tmp2_;
	_tmp3_ = dvb_manager_log;
	_tmp4_ = group_id;
	_tmp5_ = devgroup;
	_tmp6_ = dvb_device_group_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	dvb_logging_logger_debug (_tmp3_, "Manager.vala:428: Adding device group %u with %d devices", _tmp4_, _tmp7_);
	_tmp8_ = devgroup;
	_tmp9_ = dvb_device_group_get_Type (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == DVB_ADAPTER_TYPE_UNKNOWN) {
		DVBLoggingLogger* _tmp11_;
		DVBDeviceGroup* _tmp12_;
		guint _tmp13_;
		guint _tmp14_;
		_tmp11_ = dvb_manager_log;
		_tmp12_ = devgroup;
		_tmp13_ = dvb_device_group_get_Id (_tmp12_);
		_tmp14_ = _tmp13_;
		dvb_logging_logger_warning (_tmp11_, "Manager.vala:432: Not adding device group %u of unknown type", _tmp14_);
		result = FALSE;
		return result;
	}
	{
		GeeHashMap* _tmp15_;
		_tmp15_ = self->priv->devices;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeHashMap* _tmp16_;
			guint _tmp17_;
			DVBDeviceGroup* _tmp18_;
			_tmp16_ = self->priv->devices;
			_tmp17_ = group_id;
			_tmp18_ = devgroup;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, GUINT_TO_POINTER (_tmp17_), _tmp18_);
		}
		__finally94:
		{
			GeeHashMap* _tmp19_;
			_tmp19_ = self->priv->devices;
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp20_ = store;
	if (_tmp20_) {
		{
			DVBFactory* _tmp21_;
			DVBFactory* _tmp22_;
			DVBdatabaseConfigStore* _tmp23_ = NULL;
			DVBdatabaseConfigStore* _tmp24_;
			DVBDeviceGroup* _tmp25_;
			_tmp21_ = dvb_factory_new ();
			_tmp22_ = _tmp21_;
			_tmp23_ = dvb_factory_get_config_store (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = devgroup;
			dvb_database_config_store_add_device_group (_tmp24_, _tmp25_, &_inner_error_);
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (_tmp22_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch95_dvb_database_sql_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally95;
		__catch95_dvb_database_sql_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = dvb_manager_log;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			dvb_logging_logger_error (_tmp26_, "Manager.vala:444: %s", _tmp28_);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally95:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp29_ = devgroup;
	g_signal_connect_object ((DVBIDBusDeviceGroup*) _tmp29_, "device-removed", (GCallback) _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed, self, 0);
	_tmp30_ = group_id;
	_tmp31_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, _tmp30_);
	path = _tmp31_;
	_tmp32_ = main_conn;
	_tmp33_ = path;
	_tmp34_ = devgroup;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp32_, _tmp33_, (DVBIDBusDeviceGroup*) _tmp34_);
	_tmp35_ = group_id;
	_tmp36_ = self->priv->device_group_counter;
	if (_tmp35_ > _tmp36_) {
		guint _tmp37_;
		_tmp37_ = group_id;
		self->priv->device_group_counter = _tmp37_;
	}
	_tmp38_ = devgroup;
	dvb_device_group_start_epg_scanner (_tmp38_);
	result = TRUE;
	_g_free0 (path);
	return result;
}


gboolean dvb_manager_restore_device_group (DVBManager* self, DVBDeviceGroup* device_group, gboolean store) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	DVBDeviceGroup* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device_group != NULL, FALSE);
	_tmp0_ = dvb_manager_log;
	_tmp1_ = device_group;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	dvb_logging_logger_debug (_tmp0_, "Manager.vala:463: Restoring group %u", _tmp3_);
	{
		DVBDeviceGroup* _tmp4_;
		DVBChannelList* _tmp5_;
		DVBChannelList* _tmp6_;
		DVBDeviceGroup* _tmp7_;
		DVBAdapterType _tmp8_;
		DVBAdapterType _tmp9_;
		_tmp4_ = device_group;
		_tmp5_ = dvb_device_group_get_Channels (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = device_group;
		_tmp8_ = dvb_device_group_get_Type (_tmp7_);
		_tmp9_ = _tmp8_;
		dvb_channel_list_load (_tmp6_, _tmp9_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch96_g_error;
		}
	}
	goto __finally96;
	__catch96_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = dvb_manager_log;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		dvb_logging_logger_error (_tmp10_, "Manager.vala:468: Error reading channels from file: %s", _tmp12_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally96:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp13_ = device_group;
	_tmp14_ = store;
	_tmp15_ = dvb_manager_add_device_group (self, _tmp13_, _tmp14_);
	result = _tmp15_;
	return result;
}


void dvb_manager_restore_timers (DVBManager* self, DVBDeviceGroup* device_group) {
	DVBLoggingLogger* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	DVBFactory* _tmp4_;
	DVBFactory* _tmp5_;
	DVBdatabaseTimersStore* _tmp6_ = NULL;
	DVBdatabaseTimersStore* _tmp7_;
	DVBdatabaseTimersStore* timers_store;
	GeeList* timers = NULL;
	guint32 max_id;
	DVBDeviceGroup* _tmp18_;
	DVBRecorder* _tmp19_;
	DVBRecorder* _tmp20_;
	DVBRecorder* _tmp21_;
	DVBRecorder* rec;
	DVBRecordingsStore* _tmp52_ = NULL;
	DVBRecordingsStore* _tmp53_;
	DVBRecordingsStore* recstore;
	DVBRecordingsStore* _tmp54_;
	guint32 _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_group != NULL);
	_tmp0_ = dvb_manager_log;
	_tmp1_ = device_group;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	dvb_logging_logger_info (_tmp0_, "Manager.vala:476: Restoring timers of device group %u", _tmp3_);
	_tmp4_ = dvb_factory_new ();
	_tmp5_ = _tmp4_;
	_tmp6_ = dvb_factory_get_timers_store (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	timers_store = _tmp7_;
	{
		DVBdatabaseTimersStore* _tmp8_;
		DVBDeviceGroup* _tmp9_;
		GeeList* _tmp10_ = NULL;
		GeeList* _tmp11_;
		_tmp8_ = timers_store;
		_tmp9_ = device_group;
		_tmp10_ = dvb_database_timers_store_get_all_timers_of_device_group (_tmp8_, _tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch97_dvb_database_sql_error;
			}
			_g_object_unref0 (timers);
			_g_object_unref0 (timers_store);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (timers);
		timers = _tmp11_;
	}
	goto __finally97;
	__catch97_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp12_;
		DVBDeviceGroup* _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = dvb_manager_log;
		_tmp13_ = device_group;
		_tmp14_ = dvb_device_group_get_Id (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		dvb_logging_logger_error (_tmp12_, "Manager.vala:484: Failed retrieving timers of group %u: %s", _tmp15_, _tmp17_);
		_g_error_free0 (e);
		_g_object_unref0 (timers);
		_g_object_unref0 (timers_store);
		return;
	}
	__finally97:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (timers);
		_g_object_unref0 (timers_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	max_id = (guint32) 0;
	_tmp18_ = device_group;
	_tmp19_ = dvb_device_group_get_recorder (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	rec = _tmp21_;
	{
		GeeList* _tmp22_;
		GeeList* _tmp23_;
		GeeList* _t_list;
		GeeList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _t_size;
		gint _t_index;
		_tmp22_ = timers;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		_t_list = _tmp23_;
		_tmp24_ = _t_list;
		_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_t_size = _tmp26_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			GeeList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_ = NULL;
			DVBTimer* t;
			DVBTimer* _tmp33_;
			guint32 _tmp34_;
			guint32 _tmp35_;
			guint32 _tmp36_;
			guint32 rec_id = 0U;
			DVBRecorder* _tmp40_;
			DVBTimer* _tmp41_;
			guint32 _tmp42_ = 0U;
			gboolean _tmp43_ = FALSE;
			_tmp27_ = _t_index;
			_t_index = _tmp27_ + 1;
			_tmp28_ = _t_index;
			_tmp29_ = _t_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _t_list;
			_tmp31_ = _t_index;
			_tmp32_ = gee_list_get (_tmp30_, _tmp31_);
			t = (DVBTimer*) _tmp32_;
			_tmp33_ = t;
			_tmp34_ = dvb_timer_get_Id (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = max_id;
			if (_tmp35_ > _tmp36_) {
				DVBTimer* _tmp37_;
				guint32 _tmp38_;
				guint32 _tmp39_;
				_tmp37_ = t;
				_tmp38_ = dvb_timer_get_Id (_tmp37_);
				_tmp39_ = _tmp38_;
				max_id = _tmp39_;
			}
			_tmp40_ = rec;
			_tmp41_ = t;
			_tmp43_ = dvb_recorder_add_timer (_tmp40_, _tmp41_, &_tmp42_);
			rec_id = _tmp42_;
			if (!_tmp43_) {
				{
					DVBdatabaseTimersStore* _tmp44_;
					DVBTimer* _tmp45_;
					guint32 _tmp46_;
					guint32 _tmp47_;
					DVBDeviceGroup* _tmp48_;
					_tmp44_ = timers_store;
					_tmp45_ = t;
					_tmp46_ = dvb_timer_get_Id (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = device_group;
					dvb_database_timers_store_remove_timer_from_device_group (_tmp44_, (guint) _tmp47_, _tmp48_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch98_dvb_database_sql_error;
						}
						_g_object_unref0 (t);
						_g_object_unref0 (_t_list);
						_g_object_unref0 (rec);
						_g_object_unref0 (timers);
						_g_object_unref0 (timers_store);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				goto __finally98;
				__catch98_dvb_database_sql_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp49_;
					GError* _tmp50_;
					const gchar* _tmp51_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp49_ = dvb_manager_log;
					_tmp50_ = e;
					_tmp51_ = _tmp50_->message;
					dvb_logging_logger_error (_tmp49_, "Manager.vala:498: Failed removing timer: %s", _tmp51_);
					_g_error_free0 (e);
				}
				__finally98:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (t);
					_g_object_unref0 (_t_list);
					_g_object_unref0 (rec);
					_g_object_unref0 (timers);
					_g_object_unref0 (timers_store);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_list);
	}
	_tmp52_ = dvb_recordings_store_get_instance ();
	_tmp53_ = _g_object_ref0 (_tmp52_);
	recstore = _tmp53_;
	_tmp54_ = recstore;
	_tmp55_ = max_id;
	dvb_recordings_store_update_last_id (_tmp54_, _tmp55_);
	_g_object_unref0 (recstore);
	_g_object_unref0 (rec);
	_g_object_unref0 (timers);
	_g_object_unref0 (timers_store);
}


void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group) {
	DVBDeviceGroup* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_group != NULL);
	_tmp0_ = device_group;
	_tmp1_ = dvb_manager_restore_device_group (self, _tmp0_, TRUE);
	if (_tmp1_) {
		DVBDeviceGroup* _tmp2_;
		_tmp2_ = device_group;
		dvb_manager_restore_timers (self, _tmp2_);
	}
}


DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id) {
	DVBDeviceGroup* result = NULL;
	DVBDeviceGroup* _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->devices;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeHashMap* _tmp1_;
			guint _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->devices;
			_tmp2_ = group_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint _tmp5_;
				gpointer _tmp6_ = NULL;
				_tmp4_ = self->priv->devices;
				_tmp5_ = group_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				_g_object_unref0 (_result_);
				_result_ = (DVBDeviceGroup*) _tmp6_;
			}
		}
		__finally99:
		{
			GeeHashMap* _tmp7_;
			_tmp7_ = self->priv->devices;
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device) {
	gboolean result = FALSE;
	gboolean _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_result_ = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->devices;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			{
				GeeHashMap* _tmp1_;
				GeeSet* _tmp2_;
				GeeSet* _tmp3_;
				GeeSet* _tmp4_;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_;
				GeeIterator* _group_id_it;
				_tmp1_ = self->priv->devices;
				_tmp2_ = gee_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_group_id_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_;
					gboolean _tmp8_ = FALSE;
					GeeIterator* _tmp9_;
					gpointer _tmp10_ = NULL;
					guint group_id;
					GeeHashMap* _tmp11_;
					guint _tmp12_;
					gpointer _tmp13_ = NULL;
					DVBDeviceGroup* devgroup;
					DVBDeviceGroup* _tmp14_;
					DVBDevice* _tmp15_;
					gboolean _tmp16_ = FALSE;
					_tmp7_ = _group_id_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _group_id_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					group_id = GPOINTER_TO_UINT (_tmp10_);
					_tmp11_ = self->priv->devices;
					_tmp12_ = group_id;
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, GUINT_TO_POINTER (_tmp12_));
					devgroup = (DVBDeviceGroup*) _tmp13_;
					_tmp14_ = devgroup;
					_tmp15_ = device;
					_tmp16_ = dvb_device_group_contains (_tmp14_, _tmp15_);
					if (_tmp16_) {
						_result_ = TRUE;
						_g_object_unref0 (devgroup);
						break;
					}
					_g_object_unref0 (devgroup);
				}
				_g_object_unref0 (_group_id_it);
			}
		}
		__finally100:
		{
			GeeHashMap* _tmp17_;
			_tmp17_ = self->priv->devices;
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner) {
	DVBScanner* _tmp0_;
	DVBDevice* _tmp1_;
	DVBDevice* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint adapter;
	DVBScanner* _tmp5_;
	DVBDevice* _tmp6_;
	DVBDevice* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint frontend;
	gchar* _tmp10_ = NULL;
	gchar* path;
	DVBLoggingLogger* _tmp14_;
	DVBScanner* _tmp15_;
	DVBDevice* _tmp16_;
	DVBDevice* _tmp17_;
	DVBDeviceGroup* _tmp18_ = NULL;
	DVBDeviceGroup* devgroup;
	DVBDeviceGroup* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	_tmp1_ = dvb_scanner_get_Device (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_device_get_Adapter (_tmp2_);
	_tmp4_ = _tmp3_;
	adapter = _tmp4_;
	_tmp5_ = scanner;
	_tmp6_ = dvb_scanner_get_Device (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = dvb_device_get_Frontend (_tmp7_);
	_tmp9_ = _tmp8_;
	frontend = _tmp9_;
	_tmp10_ = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, adapter, frontend);
	path = _tmp10_;
	{
		GeeHashMap* _tmp11_;
		_tmp11_ = self->priv->scanners;
		g_static_rec_mutex_lock (&self->priv->__lock_scanners);
		{
			GeeHashMap* _tmp12_;
			_tmp12_ = self->priv->scanners;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, path, NULL);
		}
		__finally101:
		{
			GeeHashMap* _tmp13_;
			_tmp13_ = self->priv->scanners;
			g_static_rec_mutex_unlock (&self->priv->__lock_scanners);
		}
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = dvb_manager_log;
	dvb_logging_logger_debug (_tmp14_, "Manager.vala:546: Destroying scanner for adapter %u, frontend %u (%s)", adapter, frontend, path);
	_tmp15_ = scanner;
	_tmp16_ = dvb_scanner_get_Device (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = dvb_manager_get_device_group_of_device (self, _tmp17_);
	devgroup = _tmp18_;
	_tmp19_ = devgroup;
	if (_tmp19_ != NULL) {
		DVBDeviceGroup* _tmp20_;
		_tmp20_ = devgroup;
		dvb_device_group_start_epg_scanner (_tmp20_);
	}
	_g_object_unref0 (devgroup);
	_g_free0 (path);
}


static DVBDevice* dvb_manager_get_registered_device (DVBManager* self, guint adapter, guint frontend) {
	DVBDevice* result = NULL;
	DVBDevice* _result_;
	guint _tmp0_;
	guint _tmp1_;
	DVBDevice* _tmp2_;
	DVBDevice* fake_device;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = dvb_device_new (_tmp0_, _tmp1_);
	fake_device = _tmp2_;
	{
		GeeHashMap* _tmp3_;
		_tmp3_ = self->priv->devices;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			{
				GeeHashMap* _tmp4_;
				GeeSet* _tmp5_;
				GeeSet* _tmp6_;
				GeeSet* _tmp7_;
				GeeIterator* _tmp8_ = NULL;
				GeeIterator* _tmp9_;
				GeeIterator* _group_id_it;
				_tmp4_ = self->priv->devices;
				_tmp5_ = gee_map_get_keys ((GeeMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp7_);
				_group_id_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_;
					gboolean _tmp11_ = FALSE;
					GeeIterator* _tmp12_;
					gpointer _tmp13_ = NULL;
					guint group_id;
					GeeHashMap* _tmp14_;
					guint _tmp15_;
					gpointer _tmp16_ = NULL;
					DVBDeviceGroup* devgroup;
					DVBDeviceGroup* _tmp17_;
					DVBDevice* _tmp18_;
					gboolean _tmp19_ = FALSE;
					_tmp10_ = _group_id_it;
					_tmp11_ = gee_iterator_next (_tmp10_);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = _group_id_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					group_id = GPOINTER_TO_UINT (_tmp13_);
					_tmp14_ = self->priv->devices;
					_tmp15_ = group_id;
					_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, GUINT_TO_POINTER (_tmp15_));
					devgroup = (DVBDeviceGroup*) _tmp16_;
					_tmp17_ = devgroup;
					_tmp18_ = fake_device;
					_tmp19_ = dvb_device_group_contains (_tmp17_, _tmp18_);
					if (_tmp19_) {
						{
							DVBDeviceGroup* _tmp20_;
							GeeIterator* _tmp21_ = NULL;
							GeeIterator* _device_it;
							_tmp20_ = devgroup;
							_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
							_device_it = _tmp21_;
							while (TRUE) {
								GeeIterator* _tmp22_;
								gboolean _tmp23_ = FALSE;
								GeeIterator* _tmp24_;
								gpointer _tmp25_ = NULL;
								DVBDevice* device;
								DVBDevice* _tmp26_;
								DVBDevice* _tmp27_;
								gboolean _tmp28_ = FALSE;
								_tmp22_ = _device_it;
								_tmp23_ = gee_iterator_next (_tmp22_);
								if (!_tmp23_) {
									break;
								}
								_tmp24_ = _device_it;
								_tmp25_ = gee_iterator_get (_tmp24_);
								device = (DVBDevice*) _tmp25_;
								_tmp26_ = fake_device;
								_tmp27_ = device;
								_tmp28_ = dvb_device_equal (_tmp26_, _tmp27_);
								if (_tmp28_) {
									DVBDevice* _tmp29_;
									DVBDevice* _tmp30_;
									_tmp29_ = device;
									_tmp30_ = _g_object_ref0 (_tmp29_);
									_g_object_unref0 (_result_);
									_result_ = _tmp30_;
									_g_object_unref0 (device);
									break;
								}
								_g_object_unref0 (device);
							}
							_g_object_unref0 (_device_it);
						}
					}
					_g_object_unref0 (devgroup);
				}
				_g_object_unref0 (_group_id_it);
			}
		}
		__finally102:
		{
			GeeHashMap* _tmp31_;
			_tmp31_ = self->priv->devices;
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (fake_device);
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	_g_object_unref0 (fake_device);
	return result;
}


static DVBDeviceGroup* dvb_manager_get_device_group_of_device (DVBManager* self, DVBDevice* device) {
	DVBDeviceGroup* result = NULL;
	DVBDeviceGroup* _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	_result_ = NULL;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->devices;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			{
				GeeHashMap* _tmp1_;
				GeeSet* _tmp2_;
				GeeSet* _tmp3_;
				GeeSet* _tmp4_;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_;
				GeeIterator* _group_id_it;
				_tmp1_ = self->priv->devices;
				_tmp2_ = gee_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_group_id_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_;
					gboolean _tmp8_ = FALSE;
					GeeIterator* _tmp9_;
					gpointer _tmp10_ = NULL;
					guint group_id;
					GeeHashMap* _tmp11_;
					guint _tmp12_;
					gpointer _tmp13_ = NULL;
					DVBDeviceGroup* devgroup;
					DVBDeviceGroup* _tmp14_;
					DVBDevice* _tmp15_;
					gboolean _tmp16_ = FALSE;
					_tmp7_ = _group_id_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _group_id_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					group_id = GPOINTER_TO_UINT (_tmp10_);
					_tmp11_ = self->priv->devices;
					_tmp12_ = group_id;
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, GUINT_TO_POINTER (_tmp12_));
					devgroup = (DVBDeviceGroup*) _tmp13_;
					_tmp14_ = devgroup;
					_tmp15_ = device;
					_tmp16_ = dvb_device_group_contains (_tmp14_, _tmp15_);
					if (_tmp16_) {
						{
							DVBDeviceGroup* _tmp17_;
							GeeIterator* _tmp18_ = NULL;
							GeeIterator* _grp_device_it;
							_tmp17_ = devgroup;
							_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
							_grp_device_it = _tmp18_;
							while (TRUE) {
								GeeIterator* _tmp19_;
								gboolean _tmp20_ = FALSE;
								GeeIterator* _tmp21_;
								gpointer _tmp22_ = NULL;
								DVBDevice* grp_device;
								DVBDevice* _tmp23_;
								DVBDevice* _tmp24_;
								gboolean _tmp25_ = FALSE;
								_tmp19_ = _grp_device_it;
								_tmp20_ = gee_iterator_next (_tmp19_);
								if (!_tmp20_) {
									break;
								}
								_tmp21_ = _grp_device_it;
								_tmp22_ = gee_iterator_get (_tmp21_);
								grp_device = (DVBDevice*) _tmp22_;
								_tmp23_ = grp_device;
								_tmp24_ = device;
								_tmp25_ = dvb_device_equal (_tmp23_, _tmp24_);
								if (_tmp25_) {
									DVBDeviceGroup* _tmp26_;
									DVBDeviceGroup* _tmp27_;
									_tmp26_ = devgroup;
									_tmp27_ = _g_object_ref0 (_tmp26_);
									_g_object_unref0 (_result_);
									_result_ = _tmp27_;
									_g_object_unref0 (grp_device);
									break;
								}
								_g_object_unref0 (grp_device);
							}
							_g_object_unref0 (_grp_device_it);
						}
					}
					_g_object_unref0 (devgroup);
				}
				_g_object_unref0 (_group_id_it);
			}
		}
		__finally103:
		{
			GeeHashMap* _tmp28_;
			_tmp28_ = self->priv->devices;
			g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBIDBusDeviceGroup* idevgroup, guint adapter, guint frontend) {
	DVBIDBusDeviceGroup* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	DVBDeviceGroup* devgroup;
	DVBDeviceGroup* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint group_id;
	DVBDeviceGroup* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (idevgroup != NULL);
	_tmp0_ = idevgroup;
	_tmp1_ = _g_object_ref0 (DVB_DEVICE_GROUP (_tmp0_));
	devgroup = _tmp1_;
	_tmp2_ = devgroup;
	_tmp3_ = dvb_device_group_get_Id (_tmp2_);
	_tmp4_ = _tmp3_;
	group_id = _tmp4_;
	_tmp5_ = devgroup;
	_tmp6_ = dvb_device_group_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 0) {
		gboolean success = FALSE;
		gboolean _tmp13_;
		{
			GeeHashMap* _tmp8_;
			_tmp8_ = self->priv->devices;
			g_static_rec_mutex_lock (&self->priv->__lock_devices);
			{
				GeeHashMap* _tmp9_;
				guint _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp9_ = self->priv->devices;
				_tmp10_ = group_id;
				_tmp11_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, GUINT_TO_POINTER (_tmp10_), NULL);
				success = _tmp11_;
			}
			__finally104:
			{
				GeeHashMap* _tmp12_;
				_tmp12_ = self->priv->devices;
				g_static_rec_mutex_unlock (&self->priv->__lock_devices);
			}
			if (_inner_error_ != NULL) {
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp13_ = success;
		if (_tmp13_) {
			DVBDeviceGroup* _tmp14_;
			_tmp14_ = devgroup;
			dvb_device_group_destroy (_tmp14_);
			{
				DVBFactory* _tmp15_;
				DVBFactory* _tmp16_;
				DVBdatabaseConfigStore* _tmp17_ = NULL;
				DVBdatabaseConfigStore* _tmp18_;
				DVBDeviceGroup* _tmp19_;
				DVBFactory* _tmp20_;
				DVBFactory* _tmp21_;
				DVBdatabaseEPGStore* _tmp22_ = NULL;
				DVBdatabaseEPGStore* _tmp23_;
				DVBDeviceGroup* _tmp24_;
				guint _tmp25_;
				guint _tmp26_;
				DVBFactory* _tmp27_;
				DVBFactory* _tmp28_;
				DVBdatabaseTimersStore* _tmp29_ = NULL;
				DVBdatabaseTimersStore* _tmp30_;
				DVBDeviceGroup* _tmp31_;
				guint _tmp32_;
				guint _tmp33_;
				guint _tmp34_;
				_tmp15_ = dvb_factory_new ();
				_tmp16_ = _tmp15_;
				_tmp17_ = dvb_factory_get_config_store (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = devgroup;
				dvb_database_config_store_remove_device_group (_tmp18_, _tmp19_, &_inner_error_);
				_g_object_unref0 (_tmp18_);
				_g_object_unref0 (_tmp16_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch105_dvb_database_sql_error;
					}
					_g_object_unref0 (devgroup);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp20_ = dvb_factory_new ();
				_tmp21_ = _tmp20_;
				_tmp22_ = dvb_factory_get_epg_store (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = devgroup;
				_tmp25_ = dvb_device_group_get_Id (_tmp24_);
				_tmp26_ = _tmp25_;
				dvb_database_epg_store_remove_events_of_group (_tmp23_, _tmp26_, &_inner_error_);
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (_tmp21_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch105_dvb_database_sql_error;
					}
					_g_object_unref0 (devgroup);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp27_ = dvb_factory_new ();
				_tmp28_ = _tmp27_;
				_tmp29_ = dvb_factory_get_timers_store (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = devgroup;
				_tmp32_ = dvb_device_group_get_Id (_tmp31_);
				_tmp33_ = _tmp32_;
				dvb_database_timers_store_remove_all_timers_from_device_group (_tmp30_, _tmp33_, &_inner_error_);
				_g_object_unref0 (_tmp30_);
				_g_object_unref0 (_tmp28_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch105_dvb_database_sql_error;
					}
					_g_object_unref0 (devgroup);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp34_ = group_id;
				g_signal_emit_by_name ((DVBIDBusManager*) self, "group-removed", _tmp34_);
			}
			goto __finally105;
			__catch105_dvb_database_sql_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp35_;
				GError* _tmp36_;
				const gchar* _tmp37_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp35_ = dvb_manager_log;
				_tmp36_ = e;
				_tmp37_ = _tmp36_->message;
				dvb_logging_logger_error (_tmp35_, "Manager.vala:618: %s", _tmp37_);
				_g_error_free0 (e);
			}
			__finally105:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (devgroup);
}


static void dvb_manager_create_device_group_by_id (DVBManager* self, guint group_id) {
	DVBFactory* _tmp0_;
	DVBFactory* _tmp1_;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_;
	DVBdatabaseConfigStore* config_store;
	GeeList* groups = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config_store = _tmp3_;
	{
		DVBdatabaseConfigStore* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp4_ = config_store;
		_tmp5_ = dvb_database_config_store_get_all_device_groups (_tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch106_dvb_database_sql_error;
			}
			_g_object_unref0 (groups);
			_g_object_unref0 (config_store);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (groups);
		groups = _tmp6_;
	}
	goto __finally106;
	__catch106_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp7_;
		guint _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = dvb_manager_log;
		_tmp8_ = group_id;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		dvb_logging_logger_error (_tmp7_, "Manager.vala:631: Error restoring group %u: %s", _tmp8_, _tmp10_);
		_g_error_free0 (e);
		_g_object_unref0 (groups);
		_g_object_unref0 (config_store);
		return;
	}
	__finally106:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (groups);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		GeeList* _group_list;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _group_size;
		gint _group_index;
		_tmp11_ = groups;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_group_list = _tmp12_;
		_tmp13_ = _group_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_group_size = _tmp15_;
		_group_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_ = NULL;
			DVBDeviceGroup* group;
			DVBDeviceGroup* _tmp22_;
			guint _tmp23_;
			guint _tmp24_;
			guint _tmp25_;
			_tmp16_ = _group_index;
			_group_index = _tmp16_ + 1;
			_tmp17_ = _group_index;
			_tmp18_ = _group_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _group_list;
			_tmp20_ = _group_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			group = (DVBDeviceGroup*) _tmp21_;
			_tmp22_ = group;
			_tmp23_ = dvb_device_group_get_Id (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = group_id;
			if (_tmp24_ == _tmp25_) {
				DVBDeviceGroup* _tmp26_;
				_tmp26_ = group;
				dvb_manager_restore_device_group_and_timers (self, _tmp26_);
			}
			_g_object_unref0 (group);
		}
		_g_object_unref0 (_group_list);
	}
	_g_object_unref0 (groups);
	_g_object_unref0 (config_store);
}


static void dvb_manager_on_udev_event (DVBManager* self, const gchar* action, GUdevDevice* device) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	_tmp1_ = action;
	if (g_strcmp0 (_tmp1_, "add") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = action;
		_tmp0_ = g_strcmp0 (_tmp2_, "remove") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GUdevDevice* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* dev_file;
		guint adapter;
		guint frontend;
		const gchar* _tmp7_;
		gint _tmp8_ = 0;
		guint group_id = 0U;
		gboolean found;
		DVBFactory* _tmp9_;
		DVBFactory* _tmp10_;
		DVBdatabaseConfigStore* _tmp11_ = NULL;
		DVBdatabaseConfigStore* _tmp12_;
		DVBdatabaseConfigStore* config_store;
		gboolean _tmp21_;
		DVBLoggingLogger* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		guint _tmp25_;
		guint _tmp26_;
		DVBDeviceGroup* _tmp27_ = NULL;
		DVBDeviceGroup* group;
		DVBDeviceGroup* _tmp28_;
		const gchar* _tmp30_;
		DVBDeviceGroup* _tmp44_;
		_tmp4_ = device;
		_tmp5_ = g_udev_device_get_device_file (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		dev_file = _tmp6_;
		adapter = (guint) (-1);
		frontend = (guint) (-1);
		_tmp7_ = dev_file;
		_tmp8_ = sscanf (_tmp7_, "/dev/dvb/adapter%u/frontend%u", &adapter, &frontend);
		if (_tmp8_ != 2) {
			_g_free0 (dev_file);
			return;
		}
		found = FALSE;
		_tmp9_ = dvb_factory_new ();
		_tmp10_ = _tmp9_;
		_tmp11_ = dvb_factory_get_config_store (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		config_store = _tmp12_;
		{
			DVBdatabaseConfigStore* _tmp13_;
			guint _tmp14_;
			guint _tmp15_;
			guint _tmp16_ = 0U;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_;
			_tmp13_ = config_store;
			_tmp14_ = adapter;
			_tmp15_ = frontend;
			_tmp17_ = dvb_database_config_store_get_parent_group (_tmp13_, _tmp14_, _tmp15_, &_tmp16_, &_inner_error_);
			group_id = _tmp16_;
			_tmp18_ = _tmp17_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch107_dvb_database_sql_error;
				}
				_g_object_unref0 (config_store);
				_g_free0 (dev_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			found = _tmp18_;
		}
		goto __finally107;
		__catch107_dvb_database_sql_error:
		{
			GError* e = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			g_critical ("Manager.vala:659: %s", _tmp20_);
			_g_error_free0 (e);
		}
		__finally107:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config_store);
			_g_free0 (dev_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp21_ = found;
		if (!_tmp21_) {
			_g_object_unref0 (config_store);
			_g_free0 (dev_file);
			return;
		}
		_tmp22_ = dvb_manager_log;
		_tmp23_ = action;
		_tmp24_ = dev_file;
		_tmp25_ = group_id;
		dvb_logging_logger_debug (_tmp22_, "Manager.vala:664: %s device %s, part of group %u", _tmp23_, _tmp24_, _tmp25_);
		_tmp26_ = group_id;
		_tmp27_ = dvb_manager_get_device_group_if_exists (self, _tmp26_);
		group = _tmp27_;
		_tmp28_ = group;
		if (_tmp28_ != NULL) {
			DVBDeviceGroup* _tmp29_;
			_tmp29_ = group;
			dvb_device_group_stop_epg_scanner (_tmp29_);
		}
		_tmp30_ = action;
		if (g_strcmp0 (_tmp30_, "add") == 0) {
			DVBDeviceGroup* _tmp31_;
			_tmp31_ = group;
			if (_tmp31_ == NULL) {
				guint _tmp32_;
				_tmp32_ = group_id;
				dvb_manager_create_device_group_by_id (self, _tmp32_);
			} else {
				guint _tmp33_;
				guint _tmp34_;
				DVBDevice* _tmp35_ = NULL;
				DVBDevice* dvb_device;
				DVBDevice* _tmp36_;
				DVBDeviceGroup* _tmp37_;
				DVBDevice* _tmp38_;
				_tmp33_ = adapter;
				_tmp34_ = frontend;
				_tmp35_ = dvb_device_new_with_type (_tmp33_, _tmp34_);
				dvb_device = _tmp35_;
				_tmp36_ = dvb_device;
				if (_tmp36_ == NULL) {
					_g_object_unref0 (dvb_device);
					_g_object_unref0 (group);
					_g_object_unref0 (config_store);
					_g_free0 (dev_file);
					return;
				}
				_tmp37_ = group;
				_tmp38_ = dvb_device;
				dvb_device_group_add (_tmp37_, _tmp38_);
				_g_object_unref0 (dvb_device);
			}
		} else {
			guint _tmp39_;
			guint _tmp40_;
			DVBDevice* _tmp41_;
			DVBDevice* dvb_device;
			DVBDeviceGroup* _tmp42_;
			DVBDevice* _tmp43_;
			_tmp39_ = adapter;
			_tmp40_ = frontend;
			_tmp41_ = dvb_device_new (_tmp39_, _tmp40_);
			dvb_device = _tmp41_;
			_tmp42_ = group;
			_tmp43_ = dvb_device;
			dvb_device_group_remove (_tmp42_, _tmp43_);
			_g_object_unref0 (dvb_device);
		}
		_tmp44_ = group;
		if (_tmp44_ != NULL) {
			DVBDeviceGroup* _tmp45_;
			_tmp45_ = group;
			dvb_device_group_start_epg_scanner (_tmp45_);
		}
		_g_object_unref0 (group);
		_g_object_unref0 (config_store);
		_g_free0 (dev_file);
	}
}


DVBManager* dvb_manager_construct (GType object_type) {
	DVBManager * self = NULL;
	self = (DVBManager*) g_object_new (object_type, NULL);
	return self;
}


DVBManager* dvb_manager_new (void) {
	return dvb_manager_construct (DVB_TYPE_MANAGER);
}


GeeCollection* dvb_manager_get_device_groups (DVBManager* self) {
	GeeCollection* result;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void _dvb_manager_on_udev_event_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
	dvb_manager_on_udev_event (self, action, device);
}


static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GUdevClient* _tmp5_;
	GUdevClient* _tmp6_;
	parent_class = G_OBJECT_CLASS (dvb_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MANAGER (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, DVB_MANAGER_TYPE_SCANNER_DATA, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	_g_object_unref0 (self->priv->scanners);
	self->priv->scanners = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = _tmp4_;
	self->priv->device_group_counter = (guint) 0;
	_tmp5_ = g_udev_client_new (DVB_MANAGER_UDEV_SUBSYSTEMS);
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = _tmp5_;
	_tmp6_ = self->priv->udev_client;
	g_signal_connect_object (_tmp6_, "uevent", (GCallback) _dvb_manager_on_udev_event_g_udev_client_uevent, self, 0);
	return obj;
}


static DVBManagerScannerData* dvb_manager_scanner_data_construct (GType object_type) {
	DVBManagerScannerData * self = NULL;
	self = (DVBManagerScannerData*) g_object_new (object_type, NULL);
	return self;
}


static DVBManagerScannerData* dvb_manager_scanner_data_new (void) {
	return dvb_manager_scanner_data_construct (DVB_MANAGER_TYPE_SCANNER_DATA);
}


static void dvb_manager_scanner_data_class_init (DVBManagerScannerDataClass * klass) {
	dvb_manager_scanner_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dvb_manager_scanner_data_finalize;
}


static void dvb_manager_scanner_data_instance_init (DVBManagerScannerData * self) {
}


static void dvb_manager_scanner_data_finalize (GObject* obj) {
	DVBManagerScannerData * self;
	self = DVB_MANAGER_SCANNER_DATA (obj);
	_g_object_unref0 (self->scanner);
	G_OBJECT_CLASS (dvb_manager_scanner_data_parent_class)->finalize (obj);
}


static GType dvb_manager_scanner_data_get_type (void) {
	static volatile gsize dvb_manager_scanner_data_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_manager_scanner_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBManagerScannerDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_manager_scanner_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBManagerScannerData), 0, (GInstanceInitFunc) dvb_manager_scanner_data_instance_init, NULL };
		GType dvb_manager_scanner_data_type_id;
		dvb_manager_scanner_data_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBManagerScannerData", &g_define_type_info, 0);
		g_once_init_leave (&dvb_manager_scanner_data_type_id__volatile, dvb_manager_scanner_data_type_id);
	}
	return dvb_manager_scanner_data_type_id__volatile;
}


static void dvb_manager_class_init (DVBManagerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	GStaticRecMutex _tmp2_ = {0};
	dvb_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_manager_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_MANAGER_DEVICE_GROUPS, g_param_spec_object ("device-groups", "device-groups", "device-groups", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_manager_log = _tmp1_;
	g_static_rec_mutex_init (&_tmp2_);
	dvb_manager_instance_mutex = _tmp2_;
}


static void dvb_manager_dvb_id_bus_manager_interface_init (DVBIDBusManagerIface * iface) {
	dvb_manager_dvb_id_bus_manager_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetScannerForDevice = (gboolean (*)(DVBIDBusManager*, guint, guint, char**, gchar**, GError**)) dvb_manager_real_GetScannerForDevice;
	iface->GetDeviceGroup = (gboolean (*)(DVBIDBusManager*, guint, char**, GError**)) dvb_manager_real_GetDeviceGroup;
	iface->GetRegisteredDeviceGroups = (char** (*)(DVBIDBusManager*, int*, GError**)) dvb_manager_real_GetRegisteredDeviceGroups;
	iface->AddDeviceToNewGroup = (gboolean (*)(DVBIDBusManager*, guint, guint, const gchar*, const gchar*, const gchar*, GError**)) dvb_manager_real_AddDeviceToNewGroup;
	iface->GetNameOfRegisteredDevice = (gboolean (*)(DVBIDBusManager*, guint, guint, gchar**, GError**)) dvb_manager_real_GetNameOfRegisteredDevice;
	iface->GetDeviceGroupSize = (gint (*)(DVBIDBusManager*, GError**)) dvb_manager_real_GetDeviceGroupSize;
	iface->GetChannelGroups = (DVBChannelGroupInfo* (*)(DVBIDBusManager*, int*, GError**)) dvb_manager_real_GetChannelGroups;
	iface->AddChannelGroup = (gboolean (*)(DVBIDBusManager*, const gchar*, gint*, GError**)) dvb_manager_real_AddChannelGroup;
	iface->RemoveChannelGroup = (gboolean (*)(DVBIDBusManager*, gint, GError**)) dvb_manager_real_RemoveChannelGroup;
	iface->GetDevices = (GHashTable** (*)(DVBIDBusManager*, int*, GError**)) dvb_manager_real_GetDevices;
	iface->GetAdapterInfo = (gboolean (*)(DVBIDBusManager*, guint, guint, DVBAdapterInfo*, GError**)) dvb_manager_real_GetAdapterInfo;
}


static void dvb_manager_instance_init (DVBManager * self) {
	self->priv = DVB_MANAGER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_scanners);
	g_static_rec_mutex_init (&self->priv->__lock_devices);
}


static void dvb_manager_finalize (GObject* obj) {
	DVBManager * self;
	self = DVB_MANAGER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_scanners);
	_g_object_unref0 (self->priv->scanners);
	g_static_rec_mutex_free (&self->priv->__lock_devices);
	_g_object_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->udev_client);
	G_OBJECT_CLASS (dvb_manager_parent_class)->finalize (obj);
}


GType dvb_manager_get_type (void) {
	static volatile gsize dvb_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBManager), 0, (GInstanceInitFunc) dvb_manager_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_manager_info = { (GInterfaceInitFunc) dvb_manager_dvb_id_bus_manager_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_manager_type_id;
		dvb_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBManager", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_manager_type_id, DVB_TYPE_ID_BUS_MANAGER, &dvb_id_bus_manager_info);
		g_once_init_leave (&dvb_manager_type_id__volatile, dvb_manager_type_id);
	}
	return dvb_manager_type_id__volatile;
}


static void _vala_dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBManager * self;
	self = DVB_MANAGER (object);
	switch (property_id) {
		case DVB_MANAGER_DEVICE_GROUPS:
		g_value_take_object (value, dvb_manager_get_device_groups (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



