/* IDBusRecorder.c generated by valac 0.14.0, the Vala compiler
 * generated from IDBusRecorder.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DVB_TYPE_TIMER_INFO (dvb_timer_info_get_type ())
typedef struct _DVBTimerInfo DVBTimerInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_ID_BUS_RECORDER (dvb_id_bus_recorder_get_type ())
#define DVB_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorder))
#define DVB_IS_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDER))
#define DVB_ID_BUS_RECORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorderIface))

typedef struct _DVBIDBusRecorder DVBIDBusRecorder;
typedef struct _DVBIDBusRecorderIface DVBIDBusRecorderIface;

#define DVB_TYPE_ID_BUS_RECORDER_PROXY (dvb_id_bus_recorder_proxy_get_type ())

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())
typedef GDBusProxy DVBIDBusRecorderProxy;
typedef GDBusProxyClass DVBIDBusRecorderProxyClass;

struct _DVBTimerInfo {
	guint32 id;
	guint duration;
	gboolean active;
	gchar* channel_name;
	gchar* title;
};

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBIDBusRecorderIface {
	GTypeInterface parent_iface;
	gboolean (*AddTimer) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerWithMargin) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerForEPGEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
	gboolean (*DeleteTimer) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	guint32* (*GetTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
	gboolean (*SetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
	gboolean (*GetEndTime) (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
	gboolean (*GetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error);
	gboolean (*SetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error);
	gboolean (*GetTitle) (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error);
	guint32* (*GetActiveTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*IsTimerActive) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	gboolean (*HasTimer) (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
	DVBOverlapType (*HasTimerForEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error);
};



GType dvb_timer_info_get_type (void) G_GNUC_CONST;
DVBTimerInfo* dvb_timer_info_dup (const DVBTimerInfo* self);
void dvb_timer_info_free (DVBTimerInfo* self);
void dvb_timer_info_copy (const DVBTimerInfo* self, DVBTimerInfo* dest);
void dvb_timer_info_destroy (DVBTimerInfo* self);
GType dvb_id_bus_recorder_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recorder_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_overlap_type_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_recorder_get_type (void) G_GNUC_CONST;
gboolean dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
gboolean dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
gboolean dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1, GError** error);
gboolean dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
gboolean dvb_id_bus_recorder_SetStartTime (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
gboolean dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
gboolean dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error);
gboolean dvb_id_bus_recorder_SetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error);
gboolean dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error);
gboolean dvb_id_bus_recorder_GetTitle (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error);
gboolean dvb_id_bus_recorder_GetAllInformations (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error);
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1, GError** error);
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
DVBOverlapType dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dvb_id_bus_recorder_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, GVariant* parameters);
static gboolean dvb_id_bus_recorder_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
static gboolean dvb_id_bus_recorder_proxy_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
static gboolean dvb_id_bus_recorder_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
static gboolean dvb_id_bus_recorder_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
static guint32* dvb_id_bus_recorder_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_recorder_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
static gboolean dvb_id_bus_recorder_proxy_SetStartTime (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
static gboolean dvb_id_bus_recorder_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
static gboolean dvb_id_bus_recorder_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error);
static gboolean dvb_id_bus_recorder_proxy_SetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error);
static gboolean dvb_id_bus_recorder_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error);
static gboolean dvb_id_bus_recorder_proxy_GetTitle (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error);
static gboolean dvb_id_bus_recorder_proxy_GetAllInformations (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error);
static guint32* dvb_id_bus_recorder_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_recorder_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
static gboolean dvb_id_bus_recorder_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
static DVBOverlapType dvb_id_bus_recorder_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error);
static void dvb_id_bus_recorder_proxy_dvb_id_bus_recorder_interface_init (DVBIDBusRecorderIface* iface);
static void _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_SetStartTime (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_SetDuration (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetTitle (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetAllInformations (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void dvb_id_bus_recorder_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_recorder_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_recorder_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, gpointer* _data);
static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, gpointer* _data);
static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, gpointer* _data);
static void _dvb_id_bus_recorder_unregister_object (gpointer user_data);

static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_channel = {-1, "channel", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_year = {-1, "start_year", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_month = {-1, "start_month", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_day = {-1, "start_day", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_hour = {-1, "start_hour", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_minute = {-1, "start_minute", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_duration = {-1, "duration", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimer_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_AddTimer_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_AddTimer_channel, &_dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_year, &_dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_month, &_dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_day, &_dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_hour, &_dvb_id_bus_recorder_dbus_arg_info_AddTimer_start_minute, &_dvb_id_bus_recorder_dbus_arg_info_AddTimer_duration, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_AddTimer_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_AddTimer_timer_id, &_dvb_id_bus_recorder_dbus_arg_info_AddTimer_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_AddTimer = {-1, "AddTimer", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_AddTimer_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_AddTimer_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_channel = {-1, "channel", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_year = {-1, "start_year", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_month = {-1, "start_month", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_day = {-1, "start_day", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_hour = {-1, "start_hour", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_minute = {-1, "start_minute", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_duration = {-1, "duration", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_channel, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_year, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_month, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_day, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_hour, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_start_minute, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_duration, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_timer_id, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_AddTimerWithMargin = {-1, "AddTimerWithMargin", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_AddTimerWithMargin_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_channel_sid = {-1, "channel_sid", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_event_id, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_channel_sid, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_timer_id, &_dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_AddTimerForEPGEvent = {-1, "AddTimerForEPGEvent", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_AddTimerForEPGEvent_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_DeleteTimer = {-1, "DeleteTimer", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_DeleteTimer_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetTimers_result = {-1, "result", "au"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetTimers_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetTimers_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetTimers_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetTimers = {-1, "GetTimers", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetTimers_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetTimers_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetStartTime_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetStartTime_start_time = {-1, "start_time", "au"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetStartTime_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetStartTime_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetStartTime_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetStartTime_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetStartTime_start_time, &_dvb_id_bus_recorder_dbus_arg_info_GetStartTime_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetStartTime = {-1, "GetStartTime", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetStartTime_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetStartTime_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_year = {-1, "start_year", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_month = {-1, "start_month", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_day = {-1, "start_day", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_hour = {-1, "start_hour", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_minute = {-1, "start_minute", "i"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_timer_id, &_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_year, &_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_month, &_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_day, &_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_hour, &_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_start_minute, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_SetStartTime_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_SetStartTime = {-1, "SetStartTime", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_SetStartTime_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetEndTime_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetEndTime_end_time = {-1, "end_time", "au"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetEndTime_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetEndTime_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetEndTime_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetEndTime_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetEndTime_end_time, &_dvb_id_bus_recorder_dbus_arg_info_GetEndTime_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetEndTime = {-1, "GetEndTime", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetEndTime_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetEndTime_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetDuration_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetDuration_duration = {-1, "duration", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetDuration_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetDuration_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetDuration_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetDuration_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetDuration_duration, &_dvb_id_bus_recorder_dbus_arg_info_GetDuration_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetDuration = {-1, "GetDuration", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetDuration_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetDuration_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetDuration_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetDuration_duration = {-1, "duration", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_SetDuration_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_SetDuration_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_SetDuration_timer_id, &_dvb_id_bus_recorder_dbus_arg_info_SetDuration_duration, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_SetDuration_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_SetDuration_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_SetDuration = {-1, "SetDuration", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_SetDuration_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_SetDuration_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetChannelName_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetChannelName_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetChannelName_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetChannelName_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetChannelName_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetChannelName_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetChannelName_name, &_dvb_id_bus_recorder_dbus_arg_info_GetChannelName_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetChannelName = {-1, "GetChannelName", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetChannelName_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetChannelName_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetTitle_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetTitle_title = {-1, "title", "s"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetTitle_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetTitle_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetTitle_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetTitle_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetTitle_title, &_dvb_id_bus_recorder_dbus_arg_info_GetTitle_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetTitle = {-1, "GetTitle", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetTitle_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetTitle_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_info = {-1, "info", "(uubss)"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_info, &_dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetAllInformations = {-1, "GetAllInformations", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetAllInformations_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_GetActiveTimers_result = {-1, "result", "au"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetActiveTimers_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_GetActiveTimers_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_GetActiveTimers_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_GetActiveTimers = {-1, "GetActiveTimers", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetActiveTimers_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_GetActiveTimers_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_timer_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_IsTimerActive = {-1, "IsTimerActive", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_IsTimerActive_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_year = {-1, "start_year", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_month = {-1, "start_month", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_day = {-1, "start_day", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_hour = {-1, "start_hour", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_minute = {-1, "start_minute", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimer_duration = {-1, "duration", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimer_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_HasTimer_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_year, &_dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_month, &_dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_day, &_dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_hour, &_dvb_id_bus_recorder_dbus_arg_info_HasTimer_start_minute, &_dvb_id_bus_recorder_dbus_arg_info_HasTimer_duration, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_HasTimer_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_HasTimer_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_HasTimer = {-1, "HasTimer", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_HasTimer_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_HasTimer_out)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_channel_sid = {-1, "channel_sid", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_result = {-1, "result", "i"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_in[] = {&_dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_event_id, &_dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_channel_sid, NULL};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_out[] = {&_dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_recorder_dbus_method_info_HasTimerForEvent = {-1, "HasTimerForEvent", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_in), (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_HasTimerForEvent_out)};
static const GDBusMethodInfo * const _dvb_id_bus_recorder_dbus_method_info[] = {&_dvb_id_bus_recorder_dbus_method_info_AddTimer, &_dvb_id_bus_recorder_dbus_method_info_AddTimerWithMargin, &_dvb_id_bus_recorder_dbus_method_info_AddTimerForEPGEvent, &_dvb_id_bus_recorder_dbus_method_info_DeleteTimer, &_dvb_id_bus_recorder_dbus_method_info_GetTimers, &_dvb_id_bus_recorder_dbus_method_info_GetStartTime, &_dvb_id_bus_recorder_dbus_method_info_SetStartTime, &_dvb_id_bus_recorder_dbus_method_info_GetEndTime, &_dvb_id_bus_recorder_dbus_method_info_GetDuration, &_dvb_id_bus_recorder_dbus_method_info_SetDuration, &_dvb_id_bus_recorder_dbus_method_info_GetChannelName, &_dvb_id_bus_recorder_dbus_method_info_GetTitle, &_dvb_id_bus_recorder_dbus_method_info_GetAllInformations, &_dvb_id_bus_recorder_dbus_method_info_GetActiveTimers, &_dvb_id_bus_recorder_dbus_method_info_IsTimerActive, &_dvb_id_bus_recorder_dbus_method_info_HasTimer, &_dvb_id_bus_recorder_dbus_method_info_HasTimerForEvent, NULL};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_recording_started_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_recording_started[] = {&_dvb_id_bus_recorder_dbus_arg_info_recording_started_timer_id, NULL};
static const GDBusSignalInfo _dvb_id_bus_recorder_dbus_signal_info_recording_started = {-1, "RecordingStarted", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_recording_started)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_recording_finished_recording_id = {-1, "recording_id", "u"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_recording_finished[] = {&_dvb_id_bus_recorder_dbus_arg_info_recording_finished_recording_id, NULL};
static const GDBusSignalInfo _dvb_id_bus_recorder_dbus_signal_info_recording_finished = {-1, "RecordingFinished", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_recording_finished)};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_changed_timer_id = {-1, "timer_id", "u"};
static const GDBusArgInfo _dvb_id_bus_recorder_dbus_arg_info_changed_type = {-1, "type", "u"};
static const GDBusArgInfo * const _dvb_id_bus_recorder_dbus_arg_info_changed[] = {&_dvb_id_bus_recorder_dbus_arg_info_changed_timer_id, &_dvb_id_bus_recorder_dbus_arg_info_changed_type, NULL};
static const GDBusSignalInfo _dvb_id_bus_recorder_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_dvb_id_bus_recorder_dbus_arg_info_changed)};
static const GDBusSignalInfo * const _dvb_id_bus_recorder_dbus_signal_info[] = {&_dvb_id_bus_recorder_dbus_signal_info_recording_started, &_dvb_id_bus_recorder_dbus_signal_info_recording_finished, &_dvb_id_bus_recorder_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_recorder_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_recorder_dbus_interface_info = {-1, "org.gnome.DVB.Recorder", (GDBusMethodInfo **) (&_dvb_id_bus_recorder_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_recorder_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_recorder_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_recorder_dbus_interface_vtable = {dvb_id_bus_recorder_dbus_interface_method_call, dvb_id_bus_recorder_dbus_interface_get_property, dvb_id_bus_recorder_dbus_interface_set_property};

void dvb_timer_info_copy (const DVBTimerInfo* self, DVBTimerInfo* dest) {
	guint32 _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).duration;
	(*dest).duration = _tmp1_;
	_tmp2_ = (*self).active;
	(*dest).active = _tmp2_;
	_tmp3_ = (*self).channel_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).channel_name);
	(*dest).channel_name = _tmp4_;
	_tmp5_ = (*self).title;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp6_;
}


void dvb_timer_info_destroy (DVBTimerInfo* self) {
	_g_free0 ((*self).channel_name);
	_g_free0 ((*self).title);
}


DVBTimerInfo* dvb_timer_info_dup (const DVBTimerInfo* self) {
	DVBTimerInfo* dup;
	dup = g_new0 (DVBTimerInfo, 1);
	dvb_timer_info_copy (self, dup);
	return dup;
}


void dvb_timer_info_free (DVBTimerInfo* self) {
	dvb_timer_info_destroy (self);
	g_free (self);
}


GType dvb_timer_info_get_type (void) {
	static volatile gsize dvb_timer_info_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_timer_info_type_id__volatile)) {
		GType dvb_timer_info_type_id;
		dvb_timer_info_type_id = g_boxed_type_register_static ("DVBTimerInfo", (GBoxedCopyFunc) dvb_timer_info_dup, (GBoxedFreeFunc) dvb_timer_info_free);
		g_once_init_leave (&dvb_timer_info_type_id__volatile, dvb_timer_info_type_id);
	}
	return dvb_timer_info_type_id__volatile;
}


/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @timer_id: The new timer's id on success, or 0 if timer couldn't
         * be created
         * @returns: TRUE on success
         * 
         * Add a new timer
         */
gboolean dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration, timer_id, error);
}


/**
         * Works the same way as AddTimer() but adds a margin before and
         * after the timer.
         */
gboolean dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerWithMargin (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration, timer_id, error);
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @timer_id: The new timer's id on success, or 0 if timer couldn't
         * be created
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerForEPGEvent (self, event_id, channel_sid, timer_id, error);
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->DeleteTimer (self, timer_id, error);
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetTimers (self, result_length1, error);
}


/**
         * @timer_id: Timer's id
         * @start_time: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetStartTime (self, timer_id, start_time, start_time_length1, error);
}


/**
         * @timer_id: The new timer's id on success, or 0 if timer couldn't
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_SetStartTime (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->SetStartTime (self, timer_id, start_year, start_month, start_day, start_hour, start_minute, error);
}


/**
         * @timer_id: Timer's id
         * @end_time: Same as dvb_recorder_GetStartTime()
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetEndTime (self, timer_id, end_time, end_time_length1, error);
}


/**
         * @timer_id: Timer's id
         * @duration: Duration in seconds or 0 if there's no timer with
         * the given id
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetDuration (self, timer_id, duration, error);
}


/**
         * @timer_id: Timer's id
         * @duration: Duration in minutes
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_SetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->SetDuration (self, timer_id, duration, error);
}


/**
         * @timer_id: Timer's id
         * @name: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetChannelName (self, timer_id, name, error);
}


/**
         * @timer_id: Timer's id
         * @title: The name of the show the timer belongs to or an
         * empty string if the timer doesn't exist or has no information
         * about the title of the show
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_recorder_GetTitle (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetTitle (self, timer_id, title, error);
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE on success
         *
         * This method can be used to retrieve all informations
         * about a particular timer at once
         */
gboolean dvb_id_bus_recorder_GetAllInformations (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetAllInformations (self, timer_id, info, error);
}


/**
         * @returns: The currently active timers
         */
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetActiveTimers (self, result_length1, error);
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->IsTimerActive (self, timer_id, error);
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration, error);
}


/**
         * Checks if a timer overlaps with the given event
         */
DVBOverlapType dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error) {
	g_return_val_if_fail (self != NULL, 0);
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimerForEvent (self, event_id, channel_sid, error);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void dvb_id_bus_recorder_base_init (DVBIDBusRecorderIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("recording_started", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("recording_finished", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		/**
		         * @type: 0: added, 1: deleted, 2: updated
		         */
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	}
}


GType dvb_id_bus_recorder_get_type (void) {
	static volatile gsize dvb_id_bus_recorder_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_recorder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecorderIface), (GBaseInitFunc) dvb_id_bus_recorder_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_recorder_type_id;
		dvb_id_bus_recorder_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecorder", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recorder_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_recorder_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_recorder_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_recorder_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.Recorder");
		g_type_set_qdata (dvb_id_bus_recorder_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_recorder_register_object);
		g_once_init_leave (&dvb_id_bus_recorder_type_id__volatile, dvb_id_bus_recorder_type_id);
	}
	return dvb_id_bus_recorder_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusRecorderProxy, dvb_id_bus_recorder_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_RECORDER, dvb_id_bus_recorder_proxy_dvb_id_bus_recorder_interface_init) )
static void dvb_id_bus_recorder_proxy_class_init (DVBIDBusRecorderProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_recorder_proxy_g_signal;
}


static void _dbus_handle_dvb_id_bus_recorder_recording_started (DVBIDBusRecorder* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp187_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp187_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp187_);
	g_variant_unref (_tmp187_);
	g_signal_emit_by_name (self, "recording-started", timer_id);
}


static void _dbus_handle_dvb_id_bus_recorder_recording_finished (DVBIDBusRecorder* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint32 recording_id = 0U;
	GVariant* _tmp188_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp188_ = g_variant_iter_next_value (&_arguments_iter);
	recording_id = g_variant_get_uint32 (_tmp188_);
	g_variant_unref (_tmp188_);
	g_signal_emit_by_name (self, "recording-finished", recording_id);
}


static void _dbus_handle_dvb_id_bus_recorder_changed (DVBIDBusRecorder* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp189_;
	guint type = 0U;
	GVariant* _tmp190_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp189_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp189_);
	g_variant_unref (_tmp189_);
	_tmp190_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp190_);
	g_variant_unref (_tmp190_);
	g_signal_emit_by_name (self, "changed", timer_id, type);
}


static void dvb_id_bus_recorder_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "RecordingStarted") == 0) {
		_dbus_handle_dvb_id_bus_recorder_recording_started ((DVBIDBusRecorder*) proxy, parameters);
	} else if (strcmp (signal_name, "RecordingFinished") == 0) {
		_dbus_handle_dvb_id_bus_recorder_recording_finished ((DVBIDBusRecorder*) proxy, parameters);
	} else if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_dvb_id_bus_recorder_changed ((DVBIDBusRecorder*) proxy, parameters);
	}
}


static void dvb_id_bus_recorder_proxy_init (DVBIDBusRecorderProxy* self) {
}


static gboolean dvb_id_bus_recorder_proxy_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _vala_timer_id;
	GVariant* _tmp191_;
	gboolean _result;
	GVariant* _tmp192_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "AddTimer");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_year));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_month));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_day));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_hour));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_minute));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (duration));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp191_ = g_variant_iter_next_value (&_reply_iter);
	_vala_timer_id = g_variant_get_uint32 (_tmp191_);
	g_variant_unref (_tmp191_);
	*timer_id = _vala_timer_id;
	_tmp192_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp192_);
	g_variant_unref (_tmp192_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _vala_timer_id;
	GVariant* _tmp193_;
	gboolean _result;
	GVariant* _tmp194_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "AddTimerWithMargin");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_year));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_month));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_day));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_hour));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_minute));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (duration));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp193_ = g_variant_iter_next_value (&_reply_iter);
	_vala_timer_id = g_variant_get_uint32 (_tmp193_);
	g_variant_unref (_tmp193_);
	*timer_id = _vala_timer_id;
	_tmp194_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp194_);
	g_variant_unref (_tmp194_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _vala_timer_id;
	GVariant* _tmp195_;
	gboolean _result;
	GVariant* _tmp196_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "AddTimerForEPGEvent");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_sid));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp195_ = g_variant_iter_next_value (&_reply_iter);
	_vala_timer_id = g_variant_get_uint32 (_tmp195_);
	g_variant_unref (_tmp195_);
	*timer_id = _vala_timer_id;
	_tmp196_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp196_);
	g_variant_unref (_tmp196_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp197_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "DeleteTimer");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp197_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp197_);
	g_variant_unref (_tmp197_);
	g_object_unref (_reply_message);
	return _result;
}


static guint32* dvb_id_bus_recorder_proxy_GetTimers (DVBIDBusRecorder* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32* _result;
	int _result_length1;
	GVariant* _tmp198_;
	guint32* _tmp199_;
	int _tmp199__length;
	int _tmp199__size;
	int _tmp199__length1;
	GVariantIter _tmp200_;
	GVariant* _tmp201_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetTimers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp198_ = g_variant_iter_next_value (&_reply_iter);
	_tmp199_ = g_new (guint32, 5);
	_tmp199__length = 0;
	_tmp199__size = 4;
	_tmp199__length1 = 0;
	g_variant_iter_init (&_tmp200_, _tmp198_);
	for (; (_tmp201_ = g_variant_iter_next_value (&_tmp200_)) != NULL; _tmp199__length1++) {
		if (_tmp199__size == _tmp199__length) {
			_tmp199__size = 2 * _tmp199__size;
			_tmp199_ = g_renew (guint32, _tmp199_, _tmp199__size + 1);
		}
		_tmp199_[_tmp199__length++] = g_variant_get_uint32 (_tmp201_);
		g_variant_unref (_tmp201_);
	}
	_result_length1 = _tmp199__length1;
	_result = _tmp199_;
	g_variant_unref (_tmp198_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32* _vala_start_time;
	int _vala_start_time_length1;
	GVariant* _tmp202_;
	guint32* _tmp203_;
	int _tmp203__length;
	int _tmp203__size;
	int _tmp203__length1;
	GVariantIter _tmp204_;
	GVariant* _tmp205_;
	gboolean _result;
	GVariant* _tmp206_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetStartTime");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_start_time_length1 = 0;
	_tmp202_ = g_variant_iter_next_value (&_reply_iter);
	_tmp203_ = g_new (guint32, 5);
	_tmp203__length = 0;
	_tmp203__size = 4;
	_tmp203__length1 = 0;
	g_variant_iter_init (&_tmp204_, _tmp202_);
	for (; (_tmp205_ = g_variant_iter_next_value (&_tmp204_)) != NULL; _tmp203__length1++) {
		if (_tmp203__size == _tmp203__length) {
			_tmp203__size = 2 * _tmp203__size;
			_tmp203_ = g_renew (guint32, _tmp203_, _tmp203__size + 1);
		}
		_tmp203_[_tmp203__length++] = g_variant_get_uint32 (_tmp205_);
		g_variant_unref (_tmp205_);
	}
	_vala_start_time_length1 = _tmp203__length1;
	_vala_start_time = _tmp203_;
	g_variant_unref (_tmp202_);
	*start_time = _vala_start_time;
	*start_time_length1 = _vala_start_time_length1;
	_tmp206_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp206_);
	g_variant_unref (_tmp206_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_SetStartTime (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp207_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "SetStartTime");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_year));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_month));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_day));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_hour));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (start_minute));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp207_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp207_);
	g_variant_unref (_tmp207_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _vala_end_time;
	int _vala_end_time_length1;
	GVariant* _tmp208_;
	guint* _tmp209_;
	int _tmp209__length;
	int _tmp209__size;
	int _tmp209__length1;
	GVariantIter _tmp210_;
	GVariant* _tmp211_;
	gboolean _result;
	GVariant* _tmp212_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetEndTime");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_end_time_length1 = 0;
	_tmp208_ = g_variant_iter_next_value (&_reply_iter);
	_tmp209_ = g_new (guint, 5);
	_tmp209__length = 0;
	_tmp209__size = 4;
	_tmp209__length1 = 0;
	g_variant_iter_init (&_tmp210_, _tmp208_);
	for (; (_tmp211_ = g_variant_iter_next_value (&_tmp210_)) != NULL; _tmp209__length1++) {
		if (_tmp209__size == _tmp209__length) {
			_tmp209__size = 2 * _tmp209__size;
			_tmp209_ = g_renew (guint, _tmp209_, _tmp209__size + 1);
		}
		_tmp209_[_tmp209__length++] = g_variant_get_uint32 (_tmp211_);
		g_variant_unref (_tmp211_);
	}
	_vala_end_time_length1 = _tmp209__length1;
	_vala_end_time = _tmp209_;
	g_variant_unref (_tmp208_);
	*end_time = _vala_end_time;
	*end_time_length1 = _vala_end_time_length1;
	_tmp212_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp212_);
	g_variant_unref (_tmp212_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_GetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _vala_duration;
	GVariant* _tmp213_;
	gboolean _result;
	GVariant* _tmp214_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetDuration");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp213_ = g_variant_iter_next_value (&_reply_iter);
	_vala_duration = g_variant_get_uint32 (_tmp213_);
	g_variant_unref (_tmp213_);
	*duration = _vala_duration;
	_tmp214_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp214_);
	g_variant_unref (_tmp214_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_SetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp215_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "SetDuration");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (duration));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp215_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp215_);
	g_variant_unref (_tmp215_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_name;
	GVariant* _tmp216_;
	gboolean _result;
	GVariant* _tmp217_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetChannelName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp216_ = g_variant_iter_next_value (&_reply_iter);
	_vala_name = g_variant_dup_string (_tmp216_, NULL);
	g_variant_unref (_tmp216_);
	*name = _vala_name;
	_tmp217_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp217_);
	g_variant_unref (_tmp217_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_GetTitle (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_title;
	GVariant* _tmp218_;
	gboolean _result;
	GVariant* _tmp219_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetTitle");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp218_ = g_variant_iter_next_value (&_reply_iter);
	_vala_title = g_variant_dup_string (_tmp218_, NULL);
	g_variant_unref (_tmp218_);
	*title = _vala_title;
	_tmp219_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp219_);
	g_variant_unref (_tmp219_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_GetAllInformations (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBTimerInfo _vala_info;
	GVariant* _tmp220_;
	DVBTimerInfo _tmp221_;
	GVariantIter _tmp222_;
	GVariant* _tmp223_;
	GVariant* _tmp224_;
	GVariant* _tmp225_;
	GVariant* _tmp226_;
	GVariant* _tmp227_;
	gboolean _result;
	GVariant* _tmp228_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetAllInformations");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp220_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp222_, _tmp220_);
	_tmp223_ = g_variant_iter_next_value (&_tmp222_);
	_tmp221_.id = g_variant_get_uint32 (_tmp223_);
	g_variant_unref (_tmp223_);
	_tmp224_ = g_variant_iter_next_value (&_tmp222_);
	_tmp221_.duration = g_variant_get_uint32 (_tmp224_);
	g_variant_unref (_tmp224_);
	_tmp225_ = g_variant_iter_next_value (&_tmp222_);
	_tmp221_.active = g_variant_get_boolean (_tmp225_);
	g_variant_unref (_tmp225_);
	_tmp226_ = g_variant_iter_next_value (&_tmp222_);
	_tmp221_.channel_name = g_variant_dup_string (_tmp226_, NULL);
	g_variant_unref (_tmp226_);
	_tmp227_ = g_variant_iter_next_value (&_tmp222_);
	_tmp221_.title = g_variant_dup_string (_tmp227_, NULL);
	g_variant_unref (_tmp227_);
	_vala_info = _tmp221_;
	g_variant_unref (_tmp220_);
	*info = _vala_info;
	_tmp228_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp228_);
	g_variant_unref (_tmp228_);
	g_object_unref (_reply_message);
	return _result;
}


static guint32* dvb_id_bus_recorder_proxy_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32* _result;
	int _result_length1;
	GVariant* _tmp229_;
	guint32* _tmp230_;
	int _tmp230__length;
	int _tmp230__size;
	int _tmp230__length1;
	GVariantIter _tmp231_;
	GVariant* _tmp232_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "GetActiveTimers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp229_ = g_variant_iter_next_value (&_reply_iter);
	_tmp230_ = g_new (guint32, 5);
	_tmp230__length = 0;
	_tmp230__size = 4;
	_tmp230__length1 = 0;
	g_variant_iter_init (&_tmp231_, _tmp229_);
	for (; (_tmp232_ = g_variant_iter_next_value (&_tmp231_)) != NULL; _tmp230__length1++) {
		if (_tmp230__size == _tmp230__length) {
			_tmp230__size = 2 * _tmp230__size;
			_tmp230_ = g_renew (guint32, _tmp230_, _tmp230__size + 1);
		}
		_tmp230_[_tmp230__length++] = g_variant_get_uint32 (_tmp232_);
		g_variant_unref (_tmp232_);
	}
	_result_length1 = _tmp230__length1;
	_result = _tmp230_;
	g_variant_unref (_tmp229_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp233_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "IsTimerActive");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp233_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp233_);
	g_variant_unref (_tmp233_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_recorder_proxy_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp234_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "HasTimer");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (start_year));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (start_month));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (start_day));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (start_hour));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (start_minute));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (duration));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp234_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp234_);
	g_variant_unref (_tmp234_);
	g_object_unref (_reply_message);
	return _result;
}


static DVBOverlapType dvb_id_bus_recorder_proxy_HasTimerForEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBOverlapType _result;
	GVariant* _tmp235_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Recorder", "HasTimerForEvent");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_sid));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return 0;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp235_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_int32 (_tmp235_);
	g_variant_unref (_tmp235_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_recorder_proxy_dvb_id_bus_recorder_interface_init (DVBIDBusRecorderIface* iface) {
	iface->AddTimer = dvb_id_bus_recorder_proxy_AddTimer;
	iface->AddTimerWithMargin = dvb_id_bus_recorder_proxy_AddTimerWithMargin;
	iface->AddTimerForEPGEvent = dvb_id_bus_recorder_proxy_AddTimerForEPGEvent;
	iface->DeleteTimer = dvb_id_bus_recorder_proxy_DeleteTimer;
	iface->GetTimers = dvb_id_bus_recorder_proxy_GetTimers;
	iface->GetStartTime = dvb_id_bus_recorder_proxy_GetStartTime;
	iface->SetStartTime = dvb_id_bus_recorder_proxy_SetStartTime;
	iface->GetEndTime = dvb_id_bus_recorder_proxy_GetEndTime;
	iface->GetDuration = dvb_id_bus_recorder_proxy_GetDuration;
	iface->SetDuration = dvb_id_bus_recorder_proxy_SetDuration;
	iface->GetChannelName = dvb_id_bus_recorder_proxy_GetChannelName;
	iface->GetTitle = dvb_id_bus_recorder_proxy_GetTitle;
	iface->GetAllInformations = dvb_id_bus_recorder_proxy_GetAllInformations;
	iface->GetActiveTimers = dvb_id_bus_recorder_proxy_GetActiveTimers;
	iface->IsTimerActive = dvb_id_bus_recorder_proxy_IsTimerActive;
	iface->HasTimer = dvb_id_bus_recorder_proxy_HasTimer;
	iface->HasTimerForEvent = dvb_id_bus_recorder_proxy_HasTimerForEvent;
}


static void _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel = 0U;
	GVariant* _tmp236_;
	gint start_year = 0;
	GVariant* _tmp237_;
	gint start_month = 0;
	GVariant* _tmp238_;
	gint start_day = 0;
	GVariant* _tmp239_;
	gint start_hour = 0;
	GVariant* _tmp240_;
	gint start_minute = 0;
	GVariant* _tmp241_;
	guint duration = 0U;
	GVariant* _tmp242_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 timer_id = 0U;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp236_ = g_variant_iter_next_value (&_arguments_iter);
	channel = g_variant_get_uint32 (_tmp236_);
	g_variant_unref (_tmp236_);
	_tmp237_ = g_variant_iter_next_value (&_arguments_iter);
	start_year = g_variant_get_int32 (_tmp237_);
	g_variant_unref (_tmp237_);
	_tmp238_ = g_variant_iter_next_value (&_arguments_iter);
	start_month = g_variant_get_int32 (_tmp238_);
	g_variant_unref (_tmp238_);
	_tmp239_ = g_variant_iter_next_value (&_arguments_iter);
	start_day = g_variant_get_int32 (_tmp239_);
	g_variant_unref (_tmp239_);
	_tmp240_ = g_variant_iter_next_value (&_arguments_iter);
	start_hour = g_variant_get_int32 (_tmp240_);
	g_variant_unref (_tmp240_);
	_tmp241_ = g_variant_iter_next_value (&_arguments_iter);
	start_minute = g_variant_get_int32 (_tmp241_);
	g_variant_unref (_tmp241_);
	_tmp242_ = g_variant_iter_next_value (&_arguments_iter);
	duration = g_variant_get_uint32 (_tmp242_);
	g_variant_unref (_tmp242_);
	result = dvb_id_bus_recorder_AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration, &timer_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (timer_id));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel = 0U;
	GVariant* _tmp243_;
	gint start_year = 0;
	GVariant* _tmp244_;
	gint start_month = 0;
	GVariant* _tmp245_;
	gint start_day = 0;
	GVariant* _tmp246_;
	gint start_hour = 0;
	GVariant* _tmp247_;
	gint start_minute = 0;
	GVariant* _tmp248_;
	guint duration = 0U;
	GVariant* _tmp249_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 timer_id = 0U;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp243_ = g_variant_iter_next_value (&_arguments_iter);
	channel = g_variant_get_uint32 (_tmp243_);
	g_variant_unref (_tmp243_);
	_tmp244_ = g_variant_iter_next_value (&_arguments_iter);
	start_year = g_variant_get_int32 (_tmp244_);
	g_variant_unref (_tmp244_);
	_tmp245_ = g_variant_iter_next_value (&_arguments_iter);
	start_month = g_variant_get_int32 (_tmp245_);
	g_variant_unref (_tmp245_);
	_tmp246_ = g_variant_iter_next_value (&_arguments_iter);
	start_day = g_variant_get_int32 (_tmp246_);
	g_variant_unref (_tmp246_);
	_tmp247_ = g_variant_iter_next_value (&_arguments_iter);
	start_hour = g_variant_get_int32 (_tmp247_);
	g_variant_unref (_tmp247_);
	_tmp248_ = g_variant_iter_next_value (&_arguments_iter);
	start_minute = g_variant_get_int32 (_tmp248_);
	g_variant_unref (_tmp248_);
	_tmp249_ = g_variant_iter_next_value (&_arguments_iter);
	duration = g_variant_get_uint32 (_tmp249_);
	g_variant_unref (_tmp249_);
	result = dvb_id_bus_recorder_AddTimerWithMargin (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration, &timer_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (timer_id));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint event_id = 0U;
	GVariant* _tmp250_;
	guint channel_sid = 0U;
	GVariant* _tmp251_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 timer_id = 0U;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp250_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp250_);
	g_variant_unref (_tmp250_);
	_tmp251_ = g_variant_iter_next_value (&_arguments_iter);
	channel_sid = g_variant_get_uint32 (_tmp251_);
	g_variant_unref (_tmp251_);
	result = dvb_id_bus_recorder_AddTimerForEPGEvent (self, event_id, channel_sid, &timer_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (timer_id));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp252_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp252_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp252_);
	g_variant_unref (_tmp252_);
	result = dvb_id_bus_recorder_DeleteTimer (self, timer_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32* result;
	int result_length1 = 0;
	guint32* _tmp253_;
	GVariantBuilder _tmp254_;
	int _tmp255_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_recorder_GetTimers (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp253_ = result;
	g_variant_builder_init (&_tmp254_, G_VARIANT_TYPE ("au"));
	for (_tmp255_ = 0; _tmp255_ < result_length1; _tmp255_++) {
		g_variant_builder_add_value (&_tmp254_, g_variant_new_uint32 (*_tmp253_));
		_tmp253_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp254_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp256_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32* start_time = NULL;
	int start_time_length1 = 0;
	guint32* _tmp257_;
	GVariantBuilder _tmp258_;
	int _tmp259_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp256_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp256_);
	g_variant_unref (_tmp256_);
	result = dvb_id_bus_recorder_GetStartTime (self, timer_id, &start_time, &start_time_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp257_ = start_time;
	g_variant_builder_init (&_tmp258_, G_VARIANT_TYPE ("au"));
	for (_tmp259_ = 0; _tmp259_ < start_time_length1; _tmp259_++) {
		g_variant_builder_add_value (&_tmp258_, g_variant_new_uint32 (*_tmp257_));
		_tmp257_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp258_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	start_time = (g_free (start_time), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_SetStartTime (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp260_;
	gint start_year = 0;
	GVariant* _tmp261_;
	gint start_month = 0;
	GVariant* _tmp262_;
	gint start_day = 0;
	GVariant* _tmp263_;
	gint start_hour = 0;
	GVariant* _tmp264_;
	gint start_minute = 0;
	GVariant* _tmp265_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp260_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp260_);
	g_variant_unref (_tmp260_);
	_tmp261_ = g_variant_iter_next_value (&_arguments_iter);
	start_year = g_variant_get_int32 (_tmp261_);
	g_variant_unref (_tmp261_);
	_tmp262_ = g_variant_iter_next_value (&_arguments_iter);
	start_month = g_variant_get_int32 (_tmp262_);
	g_variant_unref (_tmp262_);
	_tmp263_ = g_variant_iter_next_value (&_arguments_iter);
	start_day = g_variant_get_int32 (_tmp263_);
	g_variant_unref (_tmp263_);
	_tmp264_ = g_variant_iter_next_value (&_arguments_iter);
	start_hour = g_variant_get_int32 (_tmp264_);
	g_variant_unref (_tmp264_);
	_tmp265_ = g_variant_iter_next_value (&_arguments_iter);
	start_minute = g_variant_get_int32 (_tmp265_);
	g_variant_unref (_tmp265_);
	result = dvb_id_bus_recorder_SetStartTime (self, timer_id, start_year, start_month, start_day, start_hour, start_minute, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp266_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* end_time = NULL;
	int end_time_length1 = 0;
	guint* _tmp267_;
	GVariantBuilder _tmp268_;
	int _tmp269_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp266_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp266_);
	g_variant_unref (_tmp266_);
	result = dvb_id_bus_recorder_GetEndTime (self, timer_id, &end_time, &end_time_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp267_ = end_time;
	g_variant_builder_init (&_tmp268_, G_VARIANT_TYPE ("au"));
	for (_tmp269_ = 0; _tmp269_ < end_time_length1; _tmp269_++) {
		g_variant_builder_add_value (&_tmp268_, g_variant_new_uint32 (*_tmp267_));
		_tmp267_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp268_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	end_time = (g_free (end_time), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp270_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint duration = 0U;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp270_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp270_);
	g_variant_unref (_tmp270_);
	result = dvb_id_bus_recorder_GetDuration (self, timer_id, &duration, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (duration));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_SetDuration (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp271_;
	guint duration = 0U;
	GVariant* _tmp272_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp271_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp271_);
	g_variant_unref (_tmp271_);
	_tmp272_ = g_variant_iter_next_value (&_arguments_iter);
	duration = g_variant_get_uint32 (_tmp272_);
	g_variant_unref (_tmp272_);
	result = dvb_id_bus_recorder_SetDuration (self, timer_id, duration, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp273_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp273_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp273_);
	g_variant_unref (_tmp273_);
	result = dvb_id_bus_recorder_GetChannelName (self, timer_id, &name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetTitle (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp274_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* title = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp274_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp274_);
	g_variant_unref (_tmp274_);
	result = dvb_id_bus_recorder_GetTitle (self, timer_id, &title, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (title));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (title);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetAllInformations (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp275_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBTimerInfo info = {0};
	GVariantBuilder _tmp276_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp275_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp275_);
	g_variant_unref (_tmp275_);
	result = dvb_id_bus_recorder_GetAllInformations (self, timer_id, &info, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp276_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp276_, g_variant_new_uint32 (info.id));
	g_variant_builder_add_value (&_tmp276_, g_variant_new_uint32 (info.duration));
	g_variant_builder_add_value (&_tmp276_, g_variant_new_boolean (info.active));
	g_variant_builder_add_value (&_tmp276_, g_variant_new_string (info.channel_name));
	g_variant_builder_add_value (&_tmp276_, g_variant_new_string (info.title));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp276_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	dvb_timer_info_destroy (&info);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32* result;
	int result_length1 = 0;
	guint32* _tmp277_;
	GVariantBuilder _tmp278_;
	int _tmp279_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_recorder_GetActiveTimers (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp277_ = result;
	g_variant_builder_init (&_tmp278_, G_VARIANT_TYPE ("au"));
	for (_tmp279_ = 0; _tmp279_ < result_length1; _tmp279_++) {
		g_variant_builder_add_value (&_tmp278_, g_variant_new_uint32 (*_tmp277_));
		_tmp277_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp278_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timer_id = 0U;
	GVariant* _tmp280_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp280_ = g_variant_iter_next_value (&_arguments_iter);
	timer_id = g_variant_get_uint32 (_tmp280_);
	g_variant_unref (_tmp280_);
	result = dvb_id_bus_recorder_IsTimerActive (self, timer_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint start_year = 0U;
	GVariant* _tmp281_;
	guint start_month = 0U;
	GVariant* _tmp282_;
	guint start_day = 0U;
	GVariant* _tmp283_;
	guint start_hour = 0U;
	GVariant* _tmp284_;
	guint start_minute = 0U;
	GVariant* _tmp285_;
	guint duration = 0U;
	GVariant* _tmp286_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp281_ = g_variant_iter_next_value (&_arguments_iter);
	start_year = g_variant_get_uint32 (_tmp281_);
	g_variant_unref (_tmp281_);
	_tmp282_ = g_variant_iter_next_value (&_arguments_iter);
	start_month = g_variant_get_uint32 (_tmp282_);
	g_variant_unref (_tmp282_);
	_tmp283_ = g_variant_iter_next_value (&_arguments_iter);
	start_day = g_variant_get_uint32 (_tmp283_);
	g_variant_unref (_tmp283_);
	_tmp284_ = g_variant_iter_next_value (&_arguments_iter);
	start_hour = g_variant_get_uint32 (_tmp284_);
	g_variant_unref (_tmp284_);
	_tmp285_ = g_variant_iter_next_value (&_arguments_iter);
	start_minute = g_variant_get_uint32 (_tmp285_);
	g_variant_unref (_tmp285_);
	_tmp286_ = g_variant_iter_next_value (&_arguments_iter);
	duration = g_variant_get_uint32 (_tmp286_);
	g_variant_unref (_tmp286_);
	result = dvb_id_bus_recorder_HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_recorder_HasTimerForEvent (DVBIDBusRecorder* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint event_id = 0U;
	GVariant* _tmp287_;
	guint channel_sid = 0U;
	GVariant* _tmp288_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBOverlapType result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp287_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp287_);
	g_variant_unref (_tmp287_);
	_tmp288_ = g_variant_iter_next_value (&_arguments_iter);
	channel_sid = g_variant_get_uint32 (_tmp288_);
	g_variant_unref (_tmp288_);
	result = dvb_id_bus_recorder_HasTimerForEvent (self, event_id, channel_sid, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_recorder_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AddTimer") == 0) {
		_dbus_dvb_id_bus_recorder_AddTimer (object, parameters, invocation);
	} else if (strcmp (method_name, "AddTimerWithMargin") == 0) {
		_dbus_dvb_id_bus_recorder_AddTimerWithMargin (object, parameters, invocation);
	} else if (strcmp (method_name, "AddTimerForEPGEvent") == 0) {
		_dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (object, parameters, invocation);
	} else if (strcmp (method_name, "DeleteTimer") == 0) {
		_dbus_dvb_id_bus_recorder_DeleteTimer (object, parameters, invocation);
	} else if (strcmp (method_name, "GetTimers") == 0) {
		_dbus_dvb_id_bus_recorder_GetTimers (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStartTime") == 0) {
		_dbus_dvb_id_bus_recorder_GetStartTime (object, parameters, invocation);
	} else if (strcmp (method_name, "SetStartTime") == 0) {
		_dbus_dvb_id_bus_recorder_SetStartTime (object, parameters, invocation);
	} else if (strcmp (method_name, "GetEndTime") == 0) {
		_dbus_dvb_id_bus_recorder_GetEndTime (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDuration") == 0) {
		_dbus_dvb_id_bus_recorder_GetDuration (object, parameters, invocation);
	} else if (strcmp (method_name, "SetDuration") == 0) {
		_dbus_dvb_id_bus_recorder_SetDuration (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelName") == 0) {
		_dbus_dvb_id_bus_recorder_GetChannelName (object, parameters, invocation);
	} else if (strcmp (method_name, "GetTitle") == 0) {
		_dbus_dvb_id_bus_recorder_GetTitle (object, parameters, invocation);
	} else if (strcmp (method_name, "GetAllInformations") == 0) {
		_dbus_dvb_id_bus_recorder_GetAllInformations (object, parameters, invocation);
	} else if (strcmp (method_name, "GetActiveTimers") == 0) {
		_dbus_dvb_id_bus_recorder_GetActiveTimers (object, parameters, invocation);
	} else if (strcmp (method_name, "IsTimerActive") == 0) {
		_dbus_dvb_id_bus_recorder_IsTimerActive (object, parameters, invocation);
	} else if (strcmp (method_name, "HasTimer") == 0) {
		_dbus_dvb_id_bus_recorder_HasTimer (object, parameters, invocation);
	} else if (strcmp (method_name, "HasTimerForEvent") == 0) {
		_dbus_dvb_id_bus_recorder_HasTimerForEvent (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_recorder_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_recorder_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dvb_id_bus_recorder_recording_started (GObject* _sender, guint32 timer_id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Recorder", "RecordingStarted", _arguments, NULL);
}


static void _dbus_dvb_id_bus_recorder_recording_finished (GObject* _sender, guint32 recording_id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (recording_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Recorder", "RecordingFinished", _arguments, NULL);
}


static void _dbus_dvb_id_bus_recorder_changed (GObject* _sender, guint32 timer_id, guint type, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timer_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Recorder", "Changed", _arguments, NULL);
}


guint dvb_id_bus_recorder_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_recorder_dbus_interface_info), &_dvb_id_bus_recorder_dbus_interface_vtable, data, _dvb_id_bus_recorder_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "recording-started", (GCallback) _dbus_dvb_id_bus_recorder_recording_started, data);
	g_signal_connect (object, "recording-finished", (GCallback) _dbus_dvb_id_bus_recorder_recording_finished, data);
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_recorder_changed, data);
	return result;
}


static void _dvb_id_bus_recorder_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_recorder_recording_started, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_recorder_recording_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_recorder_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



