﻿//
// Modifiers.cs
//
// Author:
//   Mike Krüger <mkrueger@novell.com>
//
// Copyright (C) 2008 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;

namespace ICSharpCode.NRefactory.CSharp
{
	// For compatibility with old nrefactory - same flags.
	[Flags]
	public enum Modifiers
	{
		None       = 0,
		
		Private   = 0x0001,
		Internal  = 0x0002,
		Protected = 0x0004,
		Public    = 0x0008,
		
		Abstract  = 0x0010,
		Virtual   = 0x0020,
		Sealed    = 0x0040,
		Static    = 0x0080,
		Override  = 0x0100,
		Readonly  = 0x0200,
		Const     = 0x0400,
		New       = 0x0800,
		Partial   = 0x1000,
		
		Extern    = 0x2000,
		Volatile  = 0x4000,
		Unsafe    = 0x8000,
		Async     = 0x10000,
		
		//Overloads  = 0x10000,
		//WithEvents = 0x20000,
		//Default    = 0x40000,
		Fixed      = 0x80000,
		
		//ProtectedOrInternal  = Internal | Protected,
		//ProtectedAndInternal = 0x100000, (not supported in C#)
		//SpecialName          = 0x200000,
		//Final                = 0x400000,
		//Literal              = 0x800000,
		VisibilityMask = Private | Internal | Protected | Public,
		
		/// <summary>
		/// Special value used to match any modifiers during pattern matching.
		/// </summary>
		Any = unchecked((int)0x80000000)
	}}
